var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';

var BulletChartRange = function BulletChartRange(_ref) {
  var className = _ref.className,
      value = _ref.value,
      index = _ref.index,
      vertical = _ref.vertical,
      props = _objectWithoutProperties(_ref, ['className', 'value', 'index', 'vertical']);

  var rangeClasses = classNames('bullet-chart-pf-range-bar', 'range-' + index, className);

  if (value > 0 && value <= 100) {
    return React.createElement('div', _extends({
      className: rangeClasses,
      style: {
        width: vertical ? undefined : value + '%',
        height: vertical ? value + '%' : undefined,
        zIndex: 100 - value
      }
    }, props));
  }

  return null;
};

BulletChartRange.propTypes = {
  /** Additional css classes */
  className: PropTypes.string,
  /** End value for the range */
  value: PropTypes.number.isRequired,
  /** Index for the range (1-3) */
  index: PropTypes.number.isRequired,
  /** Vertical chart, default false */
  vertical: PropTypes.bool
};

BulletChartRange.defaultProps = {
  className: '',
  vertical: false
};

export default BulletChartRange;