/*!
 * jQuery JavaScript Library v3.3.1
 * https://jquery.com/
 *
 * Includes Sizzle.js
 * https://sizzlejs.com/
 *
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2018-01-20T17:24Z
 */
(function(e, t) {
    "use strict";
    if (typeof module === "object" && typeof module.exports === "object") {
        // For CommonJS and CommonJS-like environments where a proper `window`
        // is present, execute the factory and get jQuery.
        // For environments that do not have a `window` with a `document`
        // (such as Node.js), expose a factory as module.exports.
        // This accentuates the need for the creation of a real `window`.
        // e.g. var jQuery = require("jquery")(window);
        // See ticket #14549 for more info.
        module.exports = e.document ? t(e, true) : function(e) {
            if (!e.document) {
                throw new Error("jQuery requires a window with a document");
            }
            return t(e);
        };
    } else {
        t(e);
    }
    // Pass this if window is not defined yet
})(typeof window !== "undefined" ? window : this, function(T, e) {
    // Edge <= 12 - 13+, Firefox <=18 - 45+, IE 10 - 11, Safari 5.1 - 9+, iOS 6 - 9.1
    // throw exceptions when non-strict code (e.g., ASP.NET 4.5) accesses strict mode
    // arguments.callee.caller (trac-13335). But as of jQuery 3.0 (2016), strict mode should be common
    // enough that all such attempts are guarded in a try block.
    "use strict";
    var t = [];
    var D = T.document;
    var i = Object.getPrototypeOf;
    var s = t.slice;
    var g = t.concat;
    var l = t.push;
    var r = t.indexOf;
    var n = {};
    var o = n.toString;
    var v = n.hasOwnProperty;
    var a = v.toString;
    var f = a.call(Object);
    var m = {};
    var y = function e(t) {
        // Support: Chrome <=57, Firefox <=52
        // In some browsers, typeof returns "function" for HTML <object> elements
        // (i.e., `typeof document.createElement( "object" ) === "function"`).
        // We don't want to classify *any* DOM node as a function.
        return typeof t === "function" && typeof t.nodeType !== "number";
    };
    var b = function e(t) {
        return t != null && t === t.window;
    };
    var u = {
        type: true,
        src: true,
        noModule: true
    };
    function w(e, t, n) {
        t = t || D;
        var i, r = t.createElement("script");
        r.text = e;
        if (n) {
            for (i in u) {
                if (n[i]) {
                    r[i] = n[i];
                }
            }
        }
        t.head.appendChild(r).parentNode.removeChild(r);
    }
    function x(e) {
        if (e == null) {
            return e + "";
        }
        // Support: Android <=2.3 only (functionish RegExp)
                return typeof e === "object" || typeof e === "function" ? n[o.call(e)] || "object" : typeof e;
    }
    /* global Symbol */
    // Defining this global in .eslintrc.json would create a danger of using the global
    // unguarded in another place, it seems safer to define global only for this module
        var c = "3.3.1", 
    // Define a local copy of jQuery
    k = function(e, t) {
        // The jQuery object is actually just the init constructor 'enhanced'
        // Need init if jQuery is called (just allow error to be thrown if not included)
        return new k.fn.init(e, t);
    }, 
    // Support: Android <=4.0 only
    // Make sure we trim BOM and NBSP
    d = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;
    k.fn = k.prototype = {
        // The current version of jQuery being used
        jquery: c,
        constructor: k,
        // The default length of a jQuery object is 0
        length: 0,
        toArray: function() {
            return s.call(this);
        },
        // Get the Nth element in the matched element set OR
        // Get the whole matched element set as a clean array
        get: function(e) {
            // Return all the elements in a clean array
            if (e == null) {
                return s.call(this);
            }
            // Return just the one element from the set
                        return e < 0 ? this[e + this.length] : this[e];
        },
        // Take an array of elements and push it onto the stack
        // (returning the new matched element set)
        pushStack: function(e) {
            // Build a new jQuery matched element set
            var t = k.merge(this.constructor(), e);
            // Add the old object onto the stack (as a reference)
                        t.prevObject = this;
            // Return the newly-formed element set
                        return t;
        },
        // Execute a callback for every element in the matched set.
        each: function(e) {
            return k.each(this, e);
        },
        map: function(n) {
            return this.pushStack(k.map(this, function(e, t) {
                return n.call(e, t, e);
            }));
        },
        slice: function() {
            return this.pushStack(s.apply(this, arguments));
        },
        first: function() {
            return this.eq(0);
        },
        last: function() {
            return this.eq(-1);
        },
        eq: function(e) {
            var t = this.length, n = +e + (e < 0 ? t : 0);
            return this.pushStack(n >= 0 && n < t ? [ this[n] ] : []);
        },
        end: function() {
            return this.prevObject || this.constructor();
        },
        // For internal use only.
        // Behaves like an Array's method, not like a jQuery method.
        push: l,
        sort: t.sort,
        splice: t.splice
    };
    k.extend = k.fn.extend = function() {
        var e, t, n, i, r, o, a = arguments[0] || {}, s = 1, l = arguments.length, f = false;
        // Handle a deep copy situation
                if (typeof a === "boolean") {
            f = a;
            // Skip the boolean and the target
                        a = arguments[s] || {};
            s++;
        }
        // Handle case when target is a string or something (possible in deep copy)
                if (typeof a !== "object" && !y(a)) {
            a = {};
        }
        // Extend jQuery itself if only one argument is passed
                if (s === l) {
            a = this;
            s--;
        }
        for (;s < l; s++) {
            // Only deal with non-null/undefined values
            if ((e = arguments[s]) != null) {
                // Extend the base object
                for (t in e) {
                    n = a[t];
                    i = e[t];
                    // Prevent never-ending loop
                                        if (a === i) {
                        continue;
                    }
                    // Recurse if we're merging plain objects or arrays
                                        if (f && i && (k.isPlainObject(i) || (r = Array.isArray(i)))) {
                        if (r) {
                            r = false;
                            o = n && Array.isArray(n) ? n : [];
                        } else {
                            o = n && k.isPlainObject(n) ? n : {};
                        }
                        // Never move original objects, clone them
                                                a[t] = k.extend(f, o, i);
                        // Don't bring in undefined values
                                        } else if (i !== undefined) {
                        a[t] = i;
                    }
                }
            }
        }
        // Return the modified object
                return a;
    };
    k.extend({
        // Unique for each copy of jQuery on the page
        expando: "jQuery" + (c + Math.random()).replace(/\D/g, ""),
        // Assume jQuery is ready without the ready module
        isReady: true,
        error: function(e) {
            throw new Error(e);
        },
        noop: function() {},
        isPlainObject: function(e) {
            var t, n;
            // Detect obvious negatives
            // Use toString instead of jQuery.type to catch host objects
                        if (!e || o.call(e) !== "[object Object]") {
                return false;
            }
            t = i(e);
            // Objects with no prototype (e.g., `Object.create( null )`) are plain
                        if (!t) {
                return true;
            }
            // Objects with prototype are plain iff they were constructed by a global Object function
                        n = v.call(t, "constructor") && t.constructor;
            return typeof n === "function" && a.call(n) === f;
        },
        isEmptyObject: function(e) {
            /* eslint-disable no-unused-vars */
            // See https://github.com/eslint/eslint/issues/6125
            var t;
            for (t in e) {
                return false;
            }
            return true;
        },
        // Evaluates a script in a global context
        globalEval: function(e) {
            w(e);
        },
        each: function(e, t) {
            var n, i = 0;
            if (p(e)) {
                n = e.length;
                for (;i < n; i++) {
                    if (t.call(e[i], i, e[i]) === false) {
                        break;
                    }
                }
            } else {
                for (i in e) {
                    if (t.call(e[i], i, e[i]) === false) {
                        break;
                    }
                }
            }
            return e;
        },
        // Support: Android <=4.0 only
        trim: function(e) {
            return e == null ? "" : (e + "").replace(d, "");
        },
        // results is for internal usage only
        makeArray: function(e, t) {
            var n = t || [];
            if (e != null) {
                if (p(Object(e))) {
                    k.merge(n, typeof e === "string" ? [ e ] : e);
                } else {
                    l.call(n, e);
                }
            }
            return n;
        },
        inArray: function(e, t, n) {
            return t == null ? -1 : r.call(t, e, n);
        },
        // Support: Android <=4.0 only, PhantomJS 1 only
        // push.apply(_, arraylike) throws on ancient WebKit
        merge: function(e, t) {
            var n = +t.length, i = 0, r = e.length;
            for (;i < n; i++) {
                e[r++] = t[i];
            }
            e.length = r;
            return e;
        },
        grep: function(e, t, n) {
            var i, r = [], o = 0, a = e.length, s = !n;
            // Go through the array, only saving the items
            // that pass the validator function
                        for (;o < a; o++) {
                i = !t(e[o], o);
                if (i !== s) {
                    r.push(e[o]);
                }
            }
            return r;
        },
        // arg is for internal usage only
        map: function(e, t, n) {
            var i, r, o = 0, a = [];
            // Go through the array, translating each of the items to their new values
                        if (p(e)) {
                i = e.length;
                for (;o < i; o++) {
                    r = t(e[o], o, n);
                    if (r != null) {
                        a.push(r);
                    }
                }
                // Go through every key on the object,
                        } else {
                for (o in e) {
                    r = t(e[o], o, n);
                    if (r != null) {
                        a.push(r);
                    }
                }
            }
            // Flatten any nested arrays
                        return g.apply([], a);
        },
        // A global GUID counter for objects
        guid: 1,
        // jQuery.support is not used in Core but other projects attach their
        // properties to it so it needs to exist.
        support: m
    });
    if (typeof Symbol === "function") {
        k.fn[Symbol.iterator] = t[Symbol.iterator];
    }
    // Populate the class2type map
        k.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "), function(e, t) {
        n["[object " + t + "]"] = t.toLowerCase();
    });
    function p(e) {
        // Support: real iOS 8.2 only (not reproducible in simulator)
        // `in` check used to prevent JIT error (gh-2145)
        // hasOwn isn't used here due to false negatives
        // regarding Nodelist length in IE
        var t = !!e && "length" in e && e.length, n = x(e);
        if (y(e) || b(e)) {
            return false;
        }
        return n === "array" || t === 0 || typeof t === "number" && t > 0 && t - 1 in e;
    }
    var h = 
    /*!
 * Sizzle CSS Selector Engine v2.3.3
 * https://sizzlejs.com/
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2016-08-08
 */
    function(n) {
        var e, p, w, o, r, h, c, g, x, l, f, 
        // Local document vars
        C, T, a, D, v, s, u, m, 
        // Instance-specific data
        k = "sizzle" + 1 * new Date(), y = n.document, S = 0, i = 0, d = ae(), b = ae(), E = ae(), $ = function(e, t) {
            if (e === t) {
                f = true;
            }
            return 0;
        }, 
        // Instance methods
        A = {}.hasOwnProperty, t = [], N = t.pop, j = t.push, L = t.push, I = t.slice, 
        // Use a stripped-down indexOf as it's faster than native
        // https://jsperf.com/thor-indexof-vs-for/5
        P = function(e, t) {
            var n = 0, i = e.length;
            for (;n < i; n++) {
                if (e[n] === t) {
                    return n;
                }
            }
            return -1;
        }, O = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped", 
        // Regular expressions
        // http://www.w3.org/TR/css3-selectors/#whitespace
        R = "[\\x20\\t\\r\\n\\f]", 
        // http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier
        H = "(?:\\\\.|[\\w-]|[^\0-\\xa0])+", 
        // Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors
        q = "\\[" + R + "*(" + H + ")(?:" + R + 
        // Operator (capture 2)
        "*([*^$|!~]?=)" + R + 
        // "Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]"
        "*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + H + "))|)" + R + "*\\]", B = ":(" + H + ")(?:\\((" + 
        // To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
        // 1. quoted (capture 3; capture 4 or capture 5)
        "('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" + 
        // 2. simple (capture 6)
        "((?:\\\\.|[^\\\\()[\\]]|" + q + ")*)|" + 
        // 3. anything else (capture 2)
        ".*" + ")\\)|)", 
        // Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
        M = new RegExp(R + "+", "g"), _ = new RegExp("^" + R + "+|((?:^|[^\\\\])(?:\\\\.)*)" + R + "+$", "g"), F = new RegExp("^" + R + "*," + R + "*"), U = new RegExp("^" + R + "*([>+~]|" + R + ")" + R + "*"), W = new RegExp("=" + R + "*([^\\]'\"]*?)" + R + "*\\]", "g"), z = new RegExp(B), G = new RegExp("^" + H + "$"), Q = {
            ID: new RegExp("^#(" + H + ")"),
            CLASS: new RegExp("^\\.(" + H + ")"),
            TAG: new RegExp("^(" + H + "|[*])"),
            ATTR: new RegExp("^" + q),
            PSEUDO: new RegExp("^" + B),
            CHILD: new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + R + "*(even|odd|(([+-]|)(\\d*)n|)" + R + "*(?:([+-]|)" + R + "*(\\d+)|))" + R + "*\\)|)", "i"),
            bool: new RegExp("^(?:" + O + ")$", "i"),
            // For use in libraries implementing .is()
            // We use this for POS matching in `select`
            needsContext: new RegExp("^" + R + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + R + "*((?:-\\d)?\\d*)" + R + "*\\)|)(?=[^-]|$)", "i")
        }, V = /^(?:input|select|textarea|button)$/i, X = /^h\d$/i, Y = /^[^{]+\{\s*\[native \w/, 
        // Easily-parseable/retrievable ID or TAG or CLASS selectors
        J = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/, K = /[+~]/, 
        // CSS escapes
        // http://www.w3.org/TR/CSS21/syndata.html#escaped-characters
        Z = new RegExp("\\\\([\\da-f]{1,6}" + R + "?|(" + R + ")|.)", "ig"), ee = function(e, t, n) {
            var i = "0x" + t - 65536;
            // NaN means non-codepoint
            // Support: Firefox<24
            // Workaround erroneous numeric interpretation of +"0x"
                        return i !== i || n ? t : i < 0 ? 
            // BMP codepoint
            String.fromCharCode(i + 65536) : 
            // Supplemental Plane codepoint (surrogate pair)
            String.fromCharCode(i >> 10 | 55296, i & 1023 | 56320);
        }, 
        // CSS string/identifier serialization
        // https://drafts.csswg.org/cssom/#common-serializing-idioms
        te = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g, ne = function(e, t) {
            if (t) {
                // U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
                if (e === "\0") {
                    return "�";
                }
                // Control characters and (dependent upon position) numbers get escaped as code points
                                return e.slice(0, -1) + "\\" + e.charCodeAt(e.length - 1).toString(16) + " ";
            }
            // Other potentially-special ASCII characters get backslash-escaped
                        return "\\" + e;
        }, 
        // Used for iframes
        // See setDocument()
        // Removing the function wrapper causes a "Permission Denied"
        // error in IE
        ie = function() {
            C();
        }, re = ye(function(e) {
            return e.disabled === true && ("form" in e || "label" in e);
        }, {
            dir: "parentNode",
            next: "legend"
        });
        // Optimize for push.apply( _, NodeList )
                try {
            L.apply(t = I.call(y.childNodes), y.childNodes);
            // Support: Android<4.0
            // Detect silently failing push.apply
                        t[y.childNodes.length].nodeType;
        } catch (e) {
            L = {
                apply: t.length ? 
                // Leverage slice if possible
                function(e, t) {
                    j.apply(e, I.call(t));
                } : 
                // Support: IE<9
                // Otherwise append directly
                function(e, t) {
                    var n = e.length, i = 0;
                    // Can't trust NodeList.length
                                        while (e[n++] = t[i++]) {}
                    e.length = n - 1;
                }
            };
        }
        function oe(e, t, n, i) {
            var r, o, a, s, l, f, u, c = t && t.ownerDocument, 
            // nodeType defaults to 9, since context defaults to document
            d = t ? t.nodeType : 9;
            n = n || [];
            // Return early from calls with invalid selector or context
                        if (typeof e !== "string" || !e || d !== 1 && d !== 9 && d !== 11) {
                return n;
            }
            // Try to shortcut find operations (as opposed to filters) in HTML documents
                        if (!i) {
                if ((t ? t.ownerDocument || t : y) !== T) {
                    C(t);
                }
                t = t || T;
                if (D) {
                    // If the selector is sufficiently simple, try using a "get*By*" DOM method
                    // (excepting DocumentFragment context, where the methods don't exist)
                    if (d !== 11 && (l = J.exec(e))) {
                        // ID selector
                        if (r = l[1]) {
                            // Document context
                            if (d === 9) {
                                if (a = t.getElementById(r)) {
                                    // Support: IE, Opera, Webkit
                                    // TODO: identify versions
                                    // getElementById can match elements by name instead of ID
                                    if (a.id === r) {
                                        n.push(a);
                                        return n;
                                    }
                                } else {
                                    return n;
                                }
                                // Element context
                                                        } else {
                                // Support: IE, Opera, Webkit
                                // TODO: identify versions
                                // getElementById can match elements by name instead of ID
                                if (c && (a = c.getElementById(r)) && m(t, a) && a.id === r) {
                                    n.push(a);
                                    return n;
                                }
                            }
                            // Type selector
                                                } else if (l[2]) {
                            L.apply(n, t.getElementsByTagName(e));
                            return n;
                            // Class selector
                                                } else if ((r = l[3]) && p.getElementsByClassName && t.getElementsByClassName) {
                            L.apply(n, t.getElementsByClassName(r));
                            return n;
                        }
                    }
                    // Take advantage of querySelectorAll
                                        if (p.qsa && !E[e + " "] && (!v || !v.test(e))) {
                        if (d !== 1) {
                            c = t;
                            u = e;
                            // qSA looks outside Element context, which is not what we want
                            // Thanks to Andrew Dupont for this workaround technique
                            // Support: IE <=8
                            // Exclude object elements
                                                } else if (t.nodeName.toLowerCase() !== "object") {
                            // Capture the context ID, setting it first if necessary
                            if (s = t.getAttribute("id")) {
                                s = s.replace(te, ne);
                            } else {
                                t.setAttribute("id", s = k);
                            }
                            // Prefix every selector in the list
                                                        f = h(e);
                            o = f.length;
                            while (o--) {
                                f[o] = "#" + s + " " + me(f[o]);
                            }
                            u = f.join(",");
                            // Expand context for sibling selectors
                                                        c = K.test(e) && ge(t.parentNode) || t;
                        }
                        if (u) {
                            try {
                                L.apply(n, c.querySelectorAll(u));
                                return n;
                            } catch (e) {} finally {
                                if (s === k) {
                                    t.removeAttribute("id");
                                }
                            }
                        }
                    }
                }
            }
            // All others
                        return g(e.replace(_, "$1"), t, n, i);
        }
        /**
 * Create key-value caches of limited size
 * @returns {function(string, object)} Returns the Object data after storing it on itself with
 *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
 *	deleting the oldest entry
 */        function ae() {
            var n = [];
            function i(e, t) {
                // Use (key + " ") to avoid collision with native prototype properties (see Issue #157)
                if (n.push(e + " ") > w.cacheLength) {
                    // Only keep the most recent entries
                    delete i[n.shift()];
                }
                return i[e + " "] = t;
            }
            return i;
        }
        /**
 * Mark a function for special use by Sizzle
 * @param {Function} fn The function to mark
 */        function se(e) {
            e[k] = true;
            return e;
        }
        /**
 * Support testing using an element
 * @param {Function} fn Passed the created element and returns a boolean result
 */        function le(e) {
            var t = T.createElement("fieldset");
            try {
                return !!e(t);
            } catch (e) {
                return false;
            } finally {
                // Remove from its parent by default
                if (t.parentNode) {
                    t.parentNode.removeChild(t);
                }
                // release memory in IE
                                t = null;
            }
        }
        /**
 * Adds the same handler for all of the specified attrs
 * @param {String} attrs Pipe-separated list of attributes
 * @param {Function} handler The method that will be applied
 */        function fe(e, t) {
            var n = e.split("|"), i = n.length;
            while (i--) {
                w.attrHandle[n[i]] = t;
            }
        }
        /**
 * Checks document order of two siblings
 * @param {Element} a
 * @param {Element} b
 * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b
 */        function ue(e, t) {
            var n = t && e, i = n && e.nodeType === 1 && t.nodeType === 1 && e.sourceIndex - t.sourceIndex;
            // Use IE sourceIndex if available on both nodes
                        if (i) {
                return i;
            }
            // Check if b follows a
                        if (n) {
                while (n = n.nextSibling) {
                    if (n === t) {
                        return -1;
                    }
                }
            }
            return e ? 1 : -1;
        }
        /**
 * Returns a function to use in pseudos for input types
 * @param {String} type
 */        function ce(n) {
            return function(e) {
                var t = e.nodeName.toLowerCase();
                return t === "input" && e.type === n;
            };
        }
        /**
 * Returns a function to use in pseudos for buttons
 * @param {String} type
 */        function de(n) {
            return function(e) {
                var t = e.nodeName.toLowerCase();
                return (t === "input" || t === "button") && e.type === n;
            };
        }
        /**
 * Returns a function to use in pseudos for :enabled/:disabled
 * @param {Boolean} disabled true for :disabled; false for :enabled
 */        function pe(t) {
            // Known :disabled false positives: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable
            return function(e) {
                // Only certain elements can match :enabled or :disabled
                // https://html.spec.whatwg.org/multipage/scripting.html#selector-enabled
                // https://html.spec.whatwg.org/multipage/scripting.html#selector-disabled
                if ("form" in e) {
                    // Check for inherited disabledness on relevant non-disabled elements:
                    // * listed form-associated elements in a disabled fieldset
                    //   https://html.spec.whatwg.org/multipage/forms.html#category-listed
                    //   https://html.spec.whatwg.org/multipage/forms.html#concept-fe-disabled
                    // * option elements in a disabled optgroup
                    //   https://html.spec.whatwg.org/multipage/forms.html#concept-option-disabled
                    // All such elements have a "form" property.
                    if (e.parentNode && e.disabled === false) {
                        // Option elements defer to a parent optgroup if present
                        if ("label" in e) {
                            if ("label" in e.parentNode) {
                                return e.parentNode.disabled === t;
                            } else {
                                return e.disabled === t;
                            }
                        }
                        // Support: IE 6 - 11
                        // Use the isDisabled shortcut property to check for disabled fieldset ancestors
                                                return e.isDisabled === t || 
                        // Where there is no isDisabled, check manually
                        /* jshint -W018 */
                        e.isDisabled !== !t && re(e) === t;
                    }
                    return e.disabled === t;
                    // Try to winnow out elements that can't be disabled before trusting the disabled property.
                    // Some victims get caught in our net (label, legend, menu, track), but it shouldn't
                    // even exist on them, let alone have a boolean value.
                                } else if ("label" in e) {
                    return e.disabled === t;
                }
                // Remaining elements are neither :enabled nor :disabled
                                return false;
            };
        }
        /**
 * Returns a function to use in pseudos for positionals
 * @param {Function} fn
 */        function he(a) {
            return se(function(o) {
                o = +o;
                return se(function(e, t) {
                    var n, i = a([], e.length, o), r = i.length;
                    // Match elements found at the specified indexes
                                        while (r--) {
                        if (e[n = i[r]]) {
                            e[n] = !(t[n] = e[n]);
                        }
                    }
                });
            });
        }
        /**
 * Checks a node for validity as a Sizzle context
 * @param {Element|Object=} context
 * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
 */        function ge(e) {
            return e && typeof e.getElementsByTagName !== "undefined" && e;
        }
        // Expose support vars for convenience
                p = oe.support = {};
        /**
 * Detects XML nodes
 * @param {Element|Object} elem An element or a document
 * @returns {Boolean} True iff elem is a non-HTML XML node
 */        r = oe.isXML = function(e) {
            // documentElement is verified for cases where it doesn't yet exist
            // (such as loading iframes in IE - #4833)
            var t = e && (e.ownerDocument || e).documentElement;
            return t ? t.nodeName !== "HTML" : false;
        };
        /**
 * Sets document-related variables once based on the current document
 * @param {Element|Object} [doc] An element or document object to use to set the document
 * @returns {Object} Returns the current document
 */        C = oe.setDocument = function(e) {
            var t, n, i = e ? e.ownerDocument || e : y;
            // Return early if doc is invalid or already selected
                        if (i === T || i.nodeType !== 9 || !i.documentElement) {
                return T;
            }
            // Update global variables
                        T = i;
            a = T.documentElement;
            D = !r(T);
            // Support: IE 9-11, Edge
            // Accessing iframe documents after unload throws "permission denied" errors (jQuery #13936)
                        if (y !== T && (n = T.defaultView) && n.top !== n) {
                // Support: IE 11, Edge
                if (n.addEventListener) {
                    n.addEventListener("unload", ie, false);
                    // Support: IE 9 - 10 only
                                } else if (n.attachEvent) {
                    n.attachEvent("onunload", ie);
                }
            }
            /* Attributes
	---------------------------------------------------------------------- */
            // Support: IE<8
            // Verify that getAttribute really returns attributes and not properties
            // (excepting IE8 booleans)
                        p.attributes = le(function(e) {
                e.className = "i";
                return !e.getAttribute("className");
            });
            /* getElement(s)By*
	---------------------------------------------------------------------- */
            // Check if getElementsByTagName("*") returns only elements
                        p.getElementsByTagName = le(function(e) {
                e.appendChild(T.createComment(""));
                return !e.getElementsByTagName("*").length;
            });
            // Support: IE<9
                        p.getElementsByClassName = Y.test(T.getElementsByClassName);
            // Support: IE<10
            // Check if getElementById returns elements by name
            // The broken getElementById methods don't pick up programmatically-set names,
            // so use a roundabout getElementsByName test
                        p.getById = le(function(e) {
                a.appendChild(e).id = k;
                return !T.getElementsByName || !T.getElementsByName(k).length;
            });
            // ID filter and find
                        if (p.getById) {
                w.filter["ID"] = function(e) {
                    var t = e.replace(Z, ee);
                    return function(e) {
                        return e.getAttribute("id") === t;
                    };
                };
                w.find["ID"] = function(e, t) {
                    if (typeof t.getElementById !== "undefined" && D) {
                        var n = t.getElementById(e);
                        return n ? [ n ] : [];
                    }
                };
            } else {
                w.filter["ID"] = function(e) {
                    var n = e.replace(Z, ee);
                    return function(e) {
                        var t = typeof e.getAttributeNode !== "undefined" && e.getAttributeNode("id");
                        return t && t.value === n;
                    };
                };
                // Support: IE 6 - 7 only
                // getElementById is not reliable as a find shortcut
                                w.find["ID"] = function(e, t) {
                    if (typeof t.getElementById !== "undefined" && D) {
                        var n, i, r, o = t.getElementById(e);
                        if (o) {
                            // Verify the id attribute
                            n = o.getAttributeNode("id");
                            if (n && n.value === e) {
                                return [ o ];
                            }
                            // Fall back on getElementsByName
                                                        r = t.getElementsByName(e);
                            i = 0;
                            while (o = r[i++]) {
                                n = o.getAttributeNode("id");
                                if (n && n.value === e) {
                                    return [ o ];
                                }
                            }
                        }
                        return [];
                    }
                };
            }
            // Tag
                        w.find["TAG"] = p.getElementsByTagName ? function(e, t) {
                if (typeof t.getElementsByTagName !== "undefined") {
                    return t.getElementsByTagName(e);
                    // DocumentFragment nodes don't have gEBTN
                                } else if (p.qsa) {
                    return t.querySelectorAll(e);
                }
            } : function(e, t) {
                var n, i = [], r = 0, 
                // By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too
                o = t.getElementsByTagName(e);
                // Filter out possible comments
                                if (e === "*") {
                    while (n = o[r++]) {
                        if (n.nodeType === 1) {
                            i.push(n);
                        }
                    }
                    return i;
                }
                return o;
            };
            // Class
                        w.find["CLASS"] = p.getElementsByClassName && function(e, t) {
                if (typeof t.getElementsByClassName !== "undefined" && D) {
                    return t.getElementsByClassName(e);
                }
            };
            /* QSA/matchesSelector
	---------------------------------------------------------------------- */
            // QSA and matchesSelector support
            // matchesSelector(:active) reports false when true (IE9/Opera 11.5)
                        s = [];
            // qSa(:focus) reports false when true (Chrome 21)
            // We allow this because of a bug in IE8/9 that throws an error
            // whenever `document.activeElement` is accessed on an iframe
            // So, we allow :focus to pass through QSA all the time to avoid the IE error
            // See https://bugs.jquery.com/ticket/13378
                        v = [];
            if (p.qsa = Y.test(T.querySelectorAll)) {
                // Build QSA regex
                // Regex strategy adopted from Diego Perini
                le(function(e) {
                    // Select is set to empty string on purpose
                    // This is to test IE's treatment of not explicitly
                    // setting a boolean content attribute,
                    // since its presence should be enough
                    // https://bugs.jquery.com/ticket/12359
                    a.appendChild(e).innerHTML = "<a id='" + k + "'></a>" + "<select id='" + k + "-\r\\' msallowcapture=''>" + "<option selected=''></option></select>";
                    // Support: IE8, Opera 11-12.16
                    // Nothing should be selected when empty strings follow ^= or $= or *=
                    // The test attribute must be unknown in Opera but "safe" for WinRT
                    // https://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section
                                        if (e.querySelectorAll("[msallowcapture^='']").length) {
                        v.push("[*^$]=" + R + "*(?:''|\"\")");
                    }
                    // Support: IE8
                    // Boolean attributes and "value" are not treated correctly
                                        if (!e.querySelectorAll("[selected]").length) {
                        v.push("\\[" + R + "*(?:value|" + O + ")");
                    }
                    // Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+
                                        if (!e.querySelectorAll("[id~=" + k + "-]").length) {
                        v.push("~=");
                    }
                    // Webkit/Opera - :checked should return selected option elements
                    // http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
                    // IE8 throws error here and will not see later tests
                                        if (!e.querySelectorAll(":checked").length) {
                        v.push(":checked");
                    }
                    // Support: Safari 8+, iOS 8+
                    // https://bugs.webkit.org/show_bug.cgi?id=136851
                    // In-page `selector#id sibling-combinator selector` fails
                                        if (!e.querySelectorAll("a#" + k + "+*").length) {
                        v.push(".#.+[+~]");
                    }
                });
                le(function(e) {
                    e.innerHTML = "<a href='' disabled='disabled'></a>" + "<select disabled='disabled'><option/></select>";
                    // Support: Windows 8 Native Apps
                    // The type and name attributes are restricted during .innerHTML assignment
                                        var t = T.createElement("input");
                    t.setAttribute("type", "hidden");
                    e.appendChild(t).setAttribute("name", "D");
                    // Support: IE8
                    // Enforce case-sensitivity of name attribute
                                        if (e.querySelectorAll("[name=d]").length) {
                        v.push("name" + R + "*[*^$|!~]?=");
                    }
                    // FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
                    // IE8 throws error here and will not see later tests
                                        if (e.querySelectorAll(":enabled").length !== 2) {
                        v.push(":enabled", ":disabled");
                    }
                    // Support: IE9-11+
                    // IE's :disabled selector does not pick up the children of disabled fieldsets
                                        a.appendChild(e).disabled = true;
                    if (e.querySelectorAll(":disabled").length !== 2) {
                        v.push(":enabled", ":disabled");
                    }
                    // Opera 10-11 does not throw on post-comma invalid pseudos
                                        e.querySelectorAll("*,:x");
                    v.push(",.*:");
                });
            }
            if (p.matchesSelector = Y.test(u = a.matches || a.webkitMatchesSelector || a.mozMatchesSelector || a.oMatchesSelector || a.msMatchesSelector)) {
                le(function(e) {
                    // Check to see if it's possible to do matchesSelector
                    // on a disconnected node (IE 9)
                    p.disconnectedMatch = u.call(e, "*");
                    // This should fail with an exception
                    // Gecko does not error, returns false instead
                                        u.call(e, "[s!='']:x");
                    s.push("!=", B);
                });
            }
            v = v.length && new RegExp(v.join("|"));
            s = s.length && new RegExp(s.join("|"));
            /* Contains
	---------------------------------------------------------------------- */            t = Y.test(a.compareDocumentPosition);
            // Element contains another
            // Purposefully self-exclusive
            // As in, an element does not contain itself
                        m = t || Y.test(a.contains) ? function(e, t) {
                var n = e.nodeType === 9 ? e.documentElement : e, i = t && t.parentNode;
                return e === i || !!(i && i.nodeType === 1 && (n.contains ? n.contains(i) : e.compareDocumentPosition && e.compareDocumentPosition(i) & 16));
            } : function(e, t) {
                if (t) {
                    while (t = t.parentNode) {
                        if (t === e) {
                            return true;
                        }
                    }
                }
                return false;
            };
            /* Sorting
	---------------------------------------------------------------------- */
            // Document order sorting
                        $ = t ? function(e, t) {
                // Flag for duplicate removal
                if (e === t) {
                    f = true;
                    return 0;
                }
                // Sort on method existence if only one input has compareDocumentPosition
                                var n = !e.compareDocumentPosition - !t.compareDocumentPosition;
                if (n) {
                    return n;
                }
                // Calculate position if both inputs belong to the same document
                                n = (e.ownerDocument || e) === (t.ownerDocument || t) ? e.compareDocumentPosition(t) : 
                // Otherwise we know they are disconnected
                1;
                // Disconnected nodes
                                if (n & 1 || !p.sortDetached && t.compareDocumentPosition(e) === n) {
                    // Choose the first element that is related to our preferred document
                    if (e === T || e.ownerDocument === y && m(y, e)) {
                        return -1;
                    }
                    if (t === T || t.ownerDocument === y && m(y, t)) {
                        return 1;
                    }
                    // Maintain original order
                                        return l ? P(l, e) - P(l, t) : 0;
                }
                return n & 4 ? -1 : 1;
            } : function(e, t) {
                // Exit early if the nodes are identical
                if (e === t) {
                    f = true;
                    return 0;
                }
                var n, i = 0, r = e.parentNode, o = t.parentNode, a = [ e ], s = [ t ];
                // Parentless nodes are either documents or disconnected
                                if (!r || !o) {
                    return e === T ? -1 : t === T ? 1 : r ? -1 : o ? 1 : l ? P(l, e) - P(l, t) : 0;
                    // If the nodes are siblings, we can do a quick check
                                } else if (r === o) {
                    return ue(e, t);
                }
                // Otherwise we need full lists of their ancestors for comparison
                                n = e;
                while (n = n.parentNode) {
                    a.unshift(n);
                }
                n = t;
                while (n = n.parentNode) {
                    s.unshift(n);
                }
                // Walk down the tree looking for a discrepancy
                                while (a[i] === s[i]) {
                    i++;
                }
                return i ? 
                // Do a sibling check if the nodes have a common ancestor
                ue(a[i], s[i]) : 
                // Otherwise nodes in our document sort first
                a[i] === y ? -1 : s[i] === y ? 1 : 0;
            };
            return T;
        };
        oe.matches = function(e, t) {
            return oe(e, null, null, t);
        };
        oe.matchesSelector = function(e, t) {
            // Set document vars if needed
            if ((e.ownerDocument || e) !== T) {
                C(e);
            }
            // Make sure that attribute selectors are quoted
                        t = t.replace(W, "='$1']");
            if (p.matchesSelector && D && !E[t + " "] && (!s || !s.test(t)) && (!v || !v.test(t))) {
                try {
                    var n = u.call(e, t);
                    // IE 9's matchesSelector returns false on disconnected nodes
                                        if (n || p.disconnectedMatch || 
                    // As well, disconnected nodes are said to be in a document
                    // fragment in IE 9
                    e.document && e.document.nodeType !== 11) {
                        return n;
                    }
                } catch (e) {}
            }
            return oe(t, T, null, [ e ]).length > 0;
        };
        oe.contains = function(e, t) {
            // Set document vars if needed
            if ((e.ownerDocument || e) !== T) {
                C(e);
            }
            return m(e, t);
        };
        oe.attr = function(e, t) {
            // Set document vars if needed
            if ((e.ownerDocument || e) !== T) {
                C(e);
            }
            var n = w.attrHandle[t.toLowerCase()], 
            // Don't get fooled by Object.prototype properties (jQuery #13807)
            i = n && A.call(w.attrHandle, t.toLowerCase()) ? n(e, t, !D) : undefined;
            return i !== undefined ? i : p.attributes || !D ? e.getAttribute(t) : (i = e.getAttributeNode(t)) && i.specified ? i.value : null;
        };
        oe.escape = function(e) {
            return (e + "").replace(te, ne);
        };
        oe.error = function(e) {
            throw new Error("Syntax error, unrecognized expression: " + e);
        };
        /**
 * Document sorting and removing duplicates
 * @param {ArrayLike} results
 */        oe.uniqueSort = function(e) {
            var t, n = [], i = 0, r = 0;
            // Unless we *know* we can detect duplicates, assume their presence
                        f = !p.detectDuplicates;
            l = !p.sortStable && e.slice(0);
            e.sort($);
            if (f) {
                while (t = e[r++]) {
                    if (t === e[r]) {
                        i = n.push(r);
                    }
                }
                while (i--) {
                    e.splice(n[i], 1);
                }
            }
            // Clear input after sorting to release objects
            // See https://github.com/jquery/sizzle/pull/225
                        l = null;
            return e;
        };
        /**
 * Utility function for retrieving the text value of an array of DOM nodes
 * @param {Array|Element} elem
 */        o = oe.getText = function(e) {
            var t, n = "", i = 0, r = e.nodeType;
            if (!r) {
                // If no nodeType, this is expected to be an array
                while (t = e[i++]) {
                    // Do not traverse comment nodes
                    n += o(t);
                }
            } else if (r === 1 || r === 9 || r === 11) {
                // Use textContent for elements
                // innerText usage removed for consistency of new lines (jQuery #11153)
                if (typeof e.textContent === "string") {
                    return e.textContent;
                } else {
                    // Traverse its children
                    for (e = e.firstChild; e; e = e.nextSibling) {
                        n += o(e);
                    }
                }
            } else if (r === 3 || r === 4) {
                return e.nodeValue;
            }
            // Do not include comment or processing instruction nodes
                        return n;
        };
        w = oe.selectors = {
            // Can be adjusted by the user
            cacheLength: 50,
            createPseudo: se,
            match: Q,
            attrHandle: {},
            find: {},
            relative: {
                ">": {
                    dir: "parentNode",
                    first: true
                },
                " ": {
                    dir: "parentNode"
                },
                "+": {
                    dir: "previousSibling",
                    first: true
                },
                "~": {
                    dir: "previousSibling"
                }
            },
            preFilter: {
                ATTR: function(e) {
                    e[1] = e[1].replace(Z, ee);
                    // Move the given value to match[3] whether quoted or unquoted
                                        e[3] = (e[3] || e[4] || e[5] || "").replace(Z, ee);
                    if (e[2] === "~=") {
                        e[3] = " " + e[3] + " ";
                    }
                    return e.slice(0, 4);
                },
                CHILD: function(e) {
                    /* matches from matchExpr["CHILD"]
				1 type (only|nth|...)
				2 what (child|of-type)
				3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
				4 xn-component of xn+y argument ([+-]?\d*n|)
				5 sign of xn-component
				6 x of xn-component
				7 sign of y-component
				8 y of y-component
			*/
                    e[1] = e[1].toLowerCase();
                    if (e[1].slice(0, 3) === "nth") {
                        // nth-* requires argument
                        if (!e[3]) {
                            oe.error(e[0]);
                        }
                        // numeric x and y parameters for Expr.filter.CHILD
                        // remember that false/true cast respectively to 0/1
                                                e[4] = +(e[4] ? e[5] + (e[6] || 1) : 2 * (e[3] === "even" || e[3] === "odd"));
                        e[5] = +(e[7] + e[8] || e[3] === "odd");
                        // other types prohibit arguments
                                        } else if (e[3]) {
                        oe.error(e[0]);
                    }
                    return e;
                },
                PSEUDO: function(e) {
                    var t, n = !e[6] && e[2];
                    if (Q["CHILD"].test(e[0])) {
                        return null;
                    }
                    // Accept quoted arguments as-is
                                        if (e[3]) {
                        e[2] = e[4] || e[5] || "";
                        // Strip excess characters from unquoted arguments
                                        } else if (n && z.test(n) && (
                    // Get excess from tokenize (recursively)
                    t = h(n, true)) && (
                    // advance to the next closing parenthesis
                    t = n.indexOf(")", n.length - t) - n.length)) {
                        // excess is a negative index
                        e[0] = e[0].slice(0, t);
                        e[2] = n.slice(0, t);
                    }
                    // Return only captures needed by the pseudo filter method (type and argument)
                                        return e.slice(0, 3);
                }
            },
            filter: {
                TAG: function(e) {
                    var t = e.replace(Z, ee).toLowerCase();
                    return e === "*" ? function() {
                        return true;
                    } : function(e) {
                        return e.nodeName && e.nodeName.toLowerCase() === t;
                    };
                },
                CLASS: function(e) {
                    var t = d[e + " "];
                    return t || (t = new RegExp("(^|" + R + ")" + e + "(" + R + "|$)")) && d(e, function(e) {
                        return t.test(typeof e.className === "string" && e.className || typeof e.getAttribute !== "undefined" && e.getAttribute("class") || "");
                    });
                },
                ATTR: function(n, i, r) {
                    return function(e) {
                        var t = oe.attr(e, n);
                        if (t == null) {
                            return i === "!=";
                        }
                        if (!i) {
                            return true;
                        }
                        t += "";
                        return i === "=" ? t === r : i === "!=" ? t !== r : i === "^=" ? r && t.indexOf(r) === 0 : i === "*=" ? r && t.indexOf(r) > -1 : i === "$=" ? r && t.slice(-r.length) === r : i === "~=" ? (" " + t.replace(M, " ") + " ").indexOf(r) > -1 : i === "|=" ? t === r || t.slice(0, r.length + 1) === r + "-" : false;
                    };
                },
                CHILD: function(h, e, t, g, v) {
                    var m = h.slice(0, 3) !== "nth", y = h.slice(-4) !== "last", b = e === "of-type";
                    return g === 1 && v === 0 ? 
                    // Shortcut for :nth-*(n)
                    function(e) {
                        return !!e.parentNode;
                    } : function(e, t, n) {
                        var i, r, o, a, s, l, f = m !== y ? "nextSibling" : "previousSibling", u = e.parentNode, c = b && e.nodeName.toLowerCase(), d = !n && !b, p = false;
                        if (u) {
                            // :(first|last|only)-(child|of-type)
                            if (m) {
                                while (f) {
                                    a = e;
                                    while (a = a[f]) {
                                        if (b ? a.nodeName.toLowerCase() === c : a.nodeType === 1) {
                                            return false;
                                        }
                                    }
                                    // Reverse direction for :only-* (if we haven't yet done so)
                                                                        l = f = h === "only" && !l && "nextSibling";
                                }
                                return true;
                            }
                            l = [ y ? u.firstChild : u.lastChild ];
                            // non-xml :nth-child(...) stores cache data on `parent`
                                                        if (y && d) {
                                // Seek `elem` from a previously-cached index
                                // ...in a gzip-friendly way
                                a = u;
                                o = a[k] || (a[k] = {});
                                // Support: IE <9 only
                                // Defend against cloned attroperties (jQuery gh-1709)
                                                                r = o[a.uniqueID] || (o[a.uniqueID] = {});
                                i = r[h] || [];
                                s = i[0] === S && i[1];
                                p = s && i[2];
                                a = s && u.childNodes[s];
                                while (a = ++s && a && a[f] || (
                                // Fallback to seeking `elem` from the start
                                p = s = 0) || l.pop()) {
                                    // When found, cache indexes on `parent` and break
                                    if (a.nodeType === 1 && ++p && a === e) {
                                        r[h] = [ S, s, p ];
                                        break;
                                    }
                                }
                            } else {
                                // Use previously-cached element index if available
                                if (d) {
                                    // ...in a gzip-friendly way
                                    a = e;
                                    o = a[k] || (a[k] = {});
                                    // Support: IE <9 only
                                    // Defend against cloned attroperties (jQuery gh-1709)
                                                                        r = o[a.uniqueID] || (o[a.uniqueID] = {});
                                    i = r[h] || [];
                                    s = i[0] === S && i[1];
                                    p = s;
                                }
                                // xml :nth-child(...)
                                // or :nth-last-child(...) or :nth(-last)?-of-type(...)
                                                                if (p === false) {
                                    // Use the same loop as above to seek `elem` from the start
                                    while (a = ++s && a && a[f] || (p = s = 0) || l.pop()) {
                                        if ((b ? a.nodeName.toLowerCase() === c : a.nodeType === 1) && ++p) {
                                            // Cache the index of each encountered element
                                            if (d) {
                                                o = a[k] || (a[k] = {});
                                                // Support: IE <9 only
                                                // Defend against cloned attroperties (jQuery gh-1709)
                                                                                                r = o[a.uniqueID] || (o[a.uniqueID] = {});
                                                r[h] = [ S, p ];
                                            }
                                            if (a === e) {
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                            // Incorporate the offset, then check against cycle size
                                                        p -= v;
                            return p === g || p % g === 0 && p / g >= 0;
                        }
                    };
                },
                PSEUDO: function(e, o) {
                    // pseudo-class names are case-insensitive
                    // http://www.w3.org/TR/selectors/#pseudo-classes
                    // Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
                    // Remember that setFilters inherits from pseudos
                    var t, a = w.pseudos[e] || w.setFilters[e.toLowerCase()] || oe.error("unsupported pseudo: " + e);
                    // The user may use createPseudo to indicate that
                    // arguments are needed to create the filter function
                    // just as Sizzle does
                                        if (a[k]) {
                        return a(o);
                    }
                    // But maintain support for old signatures
                                        if (a.length > 1) {
                        t = [ e, e, "", o ];
                        return w.setFilters.hasOwnProperty(e.toLowerCase()) ? se(function(e, t) {
                            var n, i = a(e, o), r = i.length;
                            while (r--) {
                                n = P(e, i[r]);
                                e[n] = !(t[n] = i[r]);
                            }
                        }) : function(e) {
                            return a(e, 0, t);
                        };
                    }
                    return a;
                }
            },
            pseudos: {
                // Potentially complex pseudos
                not: se(function(e) {
                    // Trim the selector passed to compile
                    // to avoid treating leading and trailing
                    // spaces as combinators
                    var i = [], r = [], s = c(e.replace(_, "$1"));
                    return s[k] ? se(function(e, t, n, i) {
                        var r, o = s(e, null, i, []), a = e.length;
                        // Match elements unmatched by `matcher`
                                                while (a--) {
                            if (r = o[a]) {
                                e[a] = !(t[a] = r);
                            }
                        }
                    }) : function(e, t, n) {
                        i[0] = e;
                        s(i, null, n, r);
                        // Don't keep the element (issue #299)
                                                i[0] = null;
                        return !r.pop();
                    };
                }),
                has: se(function(t) {
                    return function(e) {
                        return oe(t, e).length > 0;
                    };
                }),
                contains: se(function(t) {
                    t = t.replace(Z, ee);
                    return function(e) {
                        return (e.textContent || e.innerText || o(e)).indexOf(t) > -1;
                    };
                }),
                // "Whether an element is represented by a :lang() selector
                // is based solely on the element's language value
                // being equal to the identifier C,
                // or beginning with the identifier C immediately followed by "-".
                // The matching of C against the element's language value is performed case-insensitively.
                // The identifier C does not have to be a valid language name."
                // http://www.w3.org/TR/selectors/#lang-pseudo
                lang: se(function(n) {
                    // lang value must be a valid identifier
                    if (!G.test(n || "")) {
                        oe.error("unsupported lang: " + n);
                    }
                    n = n.replace(Z, ee).toLowerCase();
                    return function(e) {
                        var t;
                        do {
                            if (t = D ? e.lang : e.getAttribute("xml:lang") || e.getAttribute("lang")) {
                                t = t.toLowerCase();
                                return t === n || t.indexOf(n + "-") === 0;
                            }
                        } while ((e = e.parentNode) && e.nodeType === 1);
                        return false;
                    };
                }),
                // Miscellaneous
                target: function(e) {
                    var t = n.location && n.location.hash;
                    return t && t.slice(1) === e.id;
                },
                root: function(e) {
                    return e === a;
                },
                focus: function(e) {
                    return e === T.activeElement && (!T.hasFocus || T.hasFocus()) && !!(e.type || e.href || ~e.tabIndex);
                },
                // Boolean properties
                enabled: pe(false),
                disabled: pe(true),
                checked: function(e) {
                    // In CSS3, :checked should return both checked and selected elements
                    // http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
                    var t = e.nodeName.toLowerCase();
                    return t === "input" && !!e.checked || t === "option" && !!e.selected;
                },
                selected: function(e) {
                    // Accessing this property makes selected-by-default
                    // options in Safari work properly
                    if (e.parentNode) {
                        e.parentNode.selectedIndex;
                    }
                    return e.selected === true;
                },
                // Contents
                empty: function(e) {
                    // http://www.w3.org/TR/selectors/#empty-pseudo
                    // :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
                    //   but not by others (comment: 8; processing instruction: 7; etc.)
                    // nodeType < 6 works because attributes (2) do not appear as children
                    for (e = e.firstChild; e; e = e.nextSibling) {
                        if (e.nodeType < 6) {
                            return false;
                        }
                    }
                    return true;
                },
                parent: function(e) {
                    return !w.pseudos["empty"](e);
                },
                // Element/input types
                header: function(e) {
                    return X.test(e.nodeName);
                },
                input: function(e) {
                    return V.test(e.nodeName);
                },
                button: function(e) {
                    var t = e.nodeName.toLowerCase();
                    return t === "input" && e.type === "button" || t === "button";
                },
                text: function(e) {
                    var t;
                    return e.nodeName.toLowerCase() === "input" && e.type === "text" && (
                    // Support: IE<8
                    // New HTML5 attribute values (e.g., "search") appear with elem.type === "text"
                    (t = e.getAttribute("type")) == null || t.toLowerCase() === "text");
                },
                // Position-in-collection
                first: he(function() {
                    return [ 0 ];
                }),
                last: he(function(e, t) {
                    return [ t - 1 ];
                }),
                eq: he(function(e, t, n) {
                    return [ n < 0 ? n + t : n ];
                }),
                even: he(function(e, t) {
                    var n = 0;
                    for (;n < t; n += 2) {
                        e.push(n);
                    }
                    return e;
                }),
                odd: he(function(e, t) {
                    var n = 1;
                    for (;n < t; n += 2) {
                        e.push(n);
                    }
                    return e;
                }),
                lt: he(function(e, t, n) {
                    var i = n < 0 ? n + t : n;
                    for (;--i >= 0; ) {
                        e.push(i);
                    }
                    return e;
                }),
                gt: he(function(e, t, n) {
                    var i = n < 0 ? n + t : n;
                    for (;++i < t; ) {
                        e.push(i);
                    }
                    return e;
                })
            }
        };
        w.pseudos["nth"] = w.pseudos["eq"];
        // Add button/input type pseudos
                for (e in {
            radio: true,
            checkbox: true,
            file: true,
            password: true,
            image: true
        }) {
            w.pseudos[e] = ce(e);
        }
        for (e in {
            submit: true,
            reset: true
        }) {
            w.pseudos[e] = de(e);
        }
        // Easy API for creating new setFilters
                function ve() {}
        ve.prototype = w.filters = w.pseudos;
        w.setFilters = new ve();
        h = oe.tokenize = function(e, t) {
            var n, i, r, o, a, s, l, f = b[e + " "];
            if (f) {
                return t ? 0 : f.slice(0);
            }
            a = e;
            s = [];
            l = w.preFilter;
            while (a) {
                // Comma and first run
                if (!n || (i = F.exec(a))) {
                    if (i) {
                        // Don't consume trailing commas as valid
                        a = a.slice(i[0].length) || a;
                    }
                    s.push(r = []);
                }
                n = false;
                // Combinators
                                if (i = U.exec(a)) {
                    n = i.shift();
                    r.push({
                        value: n,
                        // Cast descendant combinators to space
                        type: i[0].replace(_, " ")
                    });
                    a = a.slice(n.length);
                }
                // Filters
                                for (o in w.filter) {
                    if ((i = Q[o].exec(a)) && (!l[o] || (i = l[o](i)))) {
                        n = i.shift();
                        r.push({
                            value: n,
                            type: o,
                            matches: i
                        });
                        a = a.slice(n.length);
                    }
                }
                if (!n) {
                    break;
                }
            }
            // Return the length of the invalid excess
            // if we're just parsing
            // Otherwise, throw an error or return tokens
                        return t ? a.length : a ? oe.error(e) : 
            // Cache the tokens
            b(e, s).slice(0);
        };
        function me(e) {
            var t = 0, n = e.length, i = "";
            for (;t < n; t++) {
                i += e[t].value;
            }
            return i;
        }
        function ye(s, e, t) {
            var l = e.dir, f = e.next, u = f || l, c = t && u === "parentNode", d = i++;
            return e.first ? 
            // Check against closest ancestor/preceding element
            function(e, t, n) {
                while (e = e[l]) {
                    if (e.nodeType === 1 || c) {
                        return s(e, t, n);
                    }
                }
                return false;
            } : 
            // Check against all ancestor/preceding elements
            function(e, t, n) {
                var i, r, o, a = [ S, d ];
                // We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching
                                if (n) {
                    while (e = e[l]) {
                        if (e.nodeType === 1 || c) {
                            if (s(e, t, n)) {
                                return true;
                            }
                        }
                    }
                } else {
                    while (e = e[l]) {
                        if (e.nodeType === 1 || c) {
                            o = e[k] || (e[k] = {});
                            // Support: IE <9 only
                            // Defend against cloned attroperties (jQuery gh-1709)
                                                        r = o[e.uniqueID] || (o[e.uniqueID] = {});
                            if (f && f === e.nodeName.toLowerCase()) {
                                e = e[l] || e;
                            } else if ((i = r[u]) && i[0] === S && i[1] === d) {
                                // Assign to newCache so results back-propagate to previous elements
                                return a[2] = i[2];
                            } else {
                                // Reuse newcache so results back-propagate to previous elements
                                r[u] = a;
                                // A match means we're done; a fail means we have to keep checking
                                                                if (a[2] = s(e, t, n)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
                return false;
            };
        }
        function be(r) {
            return r.length > 1 ? function(e, t, n) {
                var i = r.length;
                while (i--) {
                    if (!r[i](e, t, n)) {
                        return false;
                    }
                }
                return true;
            } : r[0];
        }
        function we(e, t, n) {
            var i = 0, r = t.length;
            for (;i < r; i++) {
                oe(e, t[i], n);
            }
            return n;
        }
        function xe(e, t, n, i, r) {
            var o, a = [], s = 0, l = e.length, f = t != null;
            for (;s < l; s++) {
                if (o = e[s]) {
                    if (!n || n(o, i, r)) {
                        a.push(o);
                        if (f) {
                            t.push(s);
                        }
                    }
                }
            }
            return a;
        }
        function Ce(p, h, g, v, m, e) {
            if (v && !v[k]) {
                v = Ce(v);
            }
            if (m && !m[k]) {
                m = Ce(m, e);
            }
            return se(function(e, t, n, i) {
                var r, o, a, s = [], l = [], f = t.length, 
                // Get initial elements from seed or context
                u = e || we(h || "*", n.nodeType ? [ n ] : n, []), 
                // Prefilter to get matcher input, preserving a map for seed-results synchronization
                c = p && (e || !h) ? xe(u, s, p, n, i) : u, d = g ? 
                // If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
                m || (e ? p : f || v) ? 
                // ...intermediate processing is necessary
                [] : 
                // ...otherwise use results directly
                t : c;
                // Find primary matches
                                if (g) {
                    g(c, d, n, i);
                }
                // Apply postFilter
                                if (v) {
                    r = xe(d, l);
                    v(r, [], n, i);
                    // Un-match failing elements by moving them back to matcherIn
                                        o = r.length;
                    while (o--) {
                        if (a = r[o]) {
                            d[l[o]] = !(c[l[o]] = a);
                        }
                    }
                }
                if (e) {
                    if (m || p) {
                        if (m) {
                            // Get the final matcherOut by condensing this intermediate into postFinder contexts
                            r = [];
                            o = d.length;
                            while (o--) {
                                if (a = d[o]) {
                                    // Restore matcherIn since elem is not yet a final match
                                    r.push(c[o] = a);
                                }
                            }
                            m(null, d = [], r, i);
                        }
                        // Move matched elements from seed to results to keep them synchronized
                                                o = d.length;
                        while (o--) {
                            if ((a = d[o]) && (r = m ? P(e, a) : s[o]) > -1) {
                                e[r] = !(t[r] = a);
                            }
                        }
                    }
                    // Add elements to results, through postFinder if defined
                                } else {
                    d = xe(d === t ? d.splice(f, d.length) : d);
                    if (m) {
                        m(null, t, d, i);
                    } else {
                        L.apply(t, d);
                    }
                }
            });
        }
        function Te(e) {
            var r, t, n, i = e.length, o = w.relative[e[0].type], a = o || w.relative[" "], s = o ? 1 : 0, 
            // The foundational matcher ensures that elements are reachable from top-level context(s)
            l = ye(function(e) {
                return e === r;
            }, a, true), f = ye(function(e) {
                return P(r, e) > -1;
            }, a, true), u = [ function(e, t, n) {
                var i = !o && (n || t !== x) || ((r = t).nodeType ? l(e, t, n) : f(e, t, n));
                // Avoid hanging onto element (issue #299)
                                r = null;
                return i;
            } ];
            for (;s < i; s++) {
                if (t = w.relative[e[s].type]) {
                    u = [ ye(be(u), t) ];
                } else {
                    t = w.filter[e[s].type].apply(null, e[s].matches);
                    // Return special upon seeing a positional matcher
                                        if (t[k]) {
                        // Find the next relative operator (if any) for proper handling
                        n = ++s;
                        for (;n < i; n++) {
                            if (w.relative[e[n].type]) {
                                break;
                            }
                        }
                        return Ce(s > 1 && be(u), s > 1 && me(
                        // If the preceding token was a descendant combinator, insert an implicit any-element `*`
                        e.slice(0, s - 1).concat({
                            value: e[s - 2].type === " " ? "*" : ""
                        })).replace(_, "$1"), t, s < n && Te(e.slice(s, n)), n < i && Te(e = e.slice(n)), n < i && me(e));
                    }
                    u.push(t);
                }
            }
            return be(u);
        }
        function De(v, m) {
            var y = m.length > 0, b = v.length > 0, e = function(e, t, n, i, r) {
                var o, a, s, l = 0, f = "0", u = e && [], c = [], d = x, 
                // We must always have either seed elements or outermost context
                p = e || b && w.find["TAG"]("*", r), 
                // Use integer dirruns iff this is the outermost matcher
                h = S += d == null ? 1 : Math.random() || .1, g = p.length;
                if (r) {
                    x = t === T || t || r;
                }
                // Add elements passing elementMatchers directly to results
                // Support: IE<9, Safari
                // Tolerate NodeList properties (IE: "length"; Safari: <number>) matching elements by id
                                for (;f !== g && (o = p[f]) != null; f++) {
                    if (b && o) {
                        a = 0;
                        if (!t && o.ownerDocument !== T) {
                            C(o);
                            n = !D;
                        }
                        while (s = v[a++]) {
                            if (s(o, t || T, n)) {
                                i.push(o);
                                break;
                            }
                        }
                        if (r) {
                            S = h;
                        }
                    }
                    // Track unmatched elements for set filters
                                        if (y) {
                        // They will have gone through all possible matchers
                        if (o = !s && o) {
                            l--;
                        }
                        // Lengthen the array for every element, matched or not
                                                if (e) {
                            u.push(o);
                        }
                    }
                }
                // `i` is now the count of elements visited above, and adding it to `matchedCount`
                // makes the latter nonnegative.
                                l += f;
                // Apply set filters to unmatched elements
                // NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`
                // equals `i`), unless we didn't visit _any_ elements in the above loop because we have
                // no element matchers and no seed.
                // Incrementing an initially-string "0" `i` allows `i` to remain a string only in that
                // case, which will result in a "00" `matchedCount` that differs from `i` but is also
                // numerically zero.
                                if (y && f !== l) {
                    a = 0;
                    while (s = m[a++]) {
                        s(u, c, t, n);
                    }
                    if (e) {
                        // Reintegrate element matches to eliminate the need for sorting
                        if (l > 0) {
                            while (f--) {
                                if (!(u[f] || c[f])) {
                                    c[f] = N.call(i);
                                }
                            }
                        }
                        // Discard index placeholder values to get only actual matches
                                                c = xe(c);
                    }
                    // Add matches to results
                                        L.apply(i, c);
                    // Seedless set matches succeeding multiple successful matchers stipulate sorting
                                        if (r && !e && c.length > 0 && l + m.length > 1) {
                        oe.uniqueSort(i);
                    }
                }
                // Override manipulation of globals by nested matchers
                                if (r) {
                    S = h;
                    x = d;
                }
                return u;
            };
            return y ? se(e) : e;
        }
        c = oe.compile = function(e, t /* Internal Use Only */) {
            var n, i = [], r = [], o = E[e + " "];
            if (!o) {
                // Generate a function of recursive functions that can be used to check each element
                if (!t) {
                    t = h(e);
                }
                n = t.length;
                while (n--) {
                    o = Te(t[n]);
                    if (o[k]) {
                        i.push(o);
                    } else {
                        r.push(o);
                    }
                }
                // Cache the compiled function
                                o = E(e, De(r, i));
                // Save selector and tokenization
                                o.selector = e;
            }
            return o;
        };
        /**
 * A low-level selection function that works with Sizzle's compiled
 *  selector functions
 * @param {String|Function} selector A selector or a pre-compiled
 *  selector function built with Sizzle.compile
 * @param {Element} context
 * @param {Array} [results]
 * @param {Array} [seed] A set of elements to match against
 */        g = oe.select = function(e, t, n, i) {
            var r, o, a, s, l, f = typeof e === "function" && e, u = !i && h(e = f.selector || e);
            n = n || [];
            // Try to minimize operations if there is only one selector in the list and no seed
            // (the latter of which guarantees us context)
                        if (u.length === 1) {
                // Reduce context if the leading compound selector is an ID
                o = u[0] = u[0].slice(0);
                if (o.length > 2 && (a = o[0]).type === "ID" && t.nodeType === 9 && D && w.relative[o[1].type]) {
                    t = (w.find["ID"](a.matches[0].replace(Z, ee), t) || [])[0];
                    if (!t) {
                        return n;
                        // Precompiled matchers will still verify ancestry, so step up a level
                                        } else if (f) {
                        t = t.parentNode;
                    }
                    e = e.slice(o.shift().value.length);
                }
                // Fetch a seed set for right-to-left matching
                                r = Q["needsContext"].test(e) ? 0 : o.length;
                while (r--) {
                    a = o[r];
                    // Abort if we hit a combinator
                                        if (w.relative[s = a.type]) {
                        break;
                    }
                    if (l = w.find[s]) {
                        // Search, expanding context for leading sibling combinators
                        if (i = l(a.matches[0].replace(Z, ee), K.test(o[0].type) && ge(t.parentNode) || t)) {
                            // If seed is empty or no tokens remain, we can return early
                            o.splice(r, 1);
                            e = i.length && me(o);
                            if (!e) {
                                L.apply(n, i);
                                return n;
                            }
                            break;
                        }
                    }
                }
            }
            // Compile and execute a filtering function if one is not provided
            // Provide `match` to avoid retokenization if we modified the selector above
                        // Compile and execute a filtering function if one is not provided
            // Provide `match` to avoid retokenization if we modified the selector above
            (f || c(e, u))(i, t, !D, n, !t || K.test(e) && ge(t.parentNode) || t);
            return n;
        };
        // One-time assignments
        // Sort stability
                p.sortStable = k.split("").sort($).join("") === k;
        // Support: Chrome 14-35+
        // Always assume duplicates if they aren't passed to the comparison function
                p.detectDuplicates = !!f;
        // Initialize against the default document
                C();
        // Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)
        // Detached nodes confoundingly follow *each other*
                p.sortDetached = le(function(e) {
            // Should return 1, but returns 4 (following)
            return e.compareDocumentPosition(T.createElement("fieldset")) & 1;
        });
        // Support: IE<8
        // Prevent attribute/property "interpolation"
        // https://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx
                if (!le(function(e) {
            e.innerHTML = "<a href='#'></a>";
            return e.firstChild.getAttribute("href") === "#";
        })) {
            fe("type|href|height|width", function(e, t, n) {
                if (!n) {
                    return e.getAttribute(t, t.toLowerCase() === "type" ? 1 : 2);
                }
            });
        }
        // Support: IE<9
        // Use defaultValue in place of getAttribute("value")
                if (!p.attributes || !le(function(e) {
            e.innerHTML = "<input/>";
            e.firstChild.setAttribute("value", "");
            return e.firstChild.getAttribute("value") === "";
        })) {
            fe("value", function(e, t, n) {
                if (!n && e.nodeName.toLowerCase() === "input") {
                    return e.defaultValue;
                }
            });
        }
        // Support: IE<9
        // Use getAttributeNode to fetch booleans when getAttribute lies
                if (!le(function(e) {
            return e.getAttribute("disabled") == null;
        })) {
            fe(O, function(e, t, n) {
                var i;
                if (!n) {
                    return e[t] === true ? t.toLowerCase() : (i = e.getAttributeNode(t)) && i.specified ? i.value : null;
                }
            });
        }
        return oe;
    }(T);
    k.find = h;
    k.expr = h.selectors;
    // Deprecated
        k.expr[":"] = k.expr.pseudos;
    k.uniqueSort = k.unique = h.uniqueSort;
    k.text = h.getText;
    k.isXMLDoc = h.isXML;
    k.contains = h.contains;
    k.escapeSelector = h.escape;
    var C = function(e, t, n) {
        var i = [], r = n !== undefined;
        while ((e = e[t]) && e.nodeType !== 9) {
            if (e.nodeType === 1) {
                if (r && k(e).is(n)) {
                    break;
                }
                i.push(e);
            }
        }
        return i;
    };
    var S = function(e, t) {
        var n = [];
        for (;e; e = e.nextSibling) {
            if (e.nodeType === 1 && e !== t) {
                n.push(e);
            }
        }
        return n;
    };
    var E = k.expr.match.needsContext;
    function $(e, t) {
        return e.nodeName && e.nodeName.toLowerCase() === t.toLowerCase();
    }
    var A = /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;
    // Implement the identical functionality for filter and not
        function N(e, n, i) {
        if (y(n)) {
            return k.grep(e, function(e, t) {
                return !!n.call(e, t, e) !== i;
            });
        }
        // Single element
                if (n.nodeType) {
            return k.grep(e, function(e) {
                return e === n !== i;
            });
        }
        // Arraylike of elements (jQuery, arguments, Array)
                if (typeof n !== "string") {
            return k.grep(e, function(e) {
                return r.call(n, e) > -1 !== i;
            });
        }
        // Filtered directly for both simple and complex selectors
                return k.filter(n, e, i);
    }
    k.filter = function(e, t, n) {
        var i = t[0];
        if (n) {
            e = ":not(" + e + ")";
        }
        if (t.length === 1 && i.nodeType === 1) {
            return k.find.matchesSelector(i, e) ? [ i ] : [];
        }
        return k.find.matches(e, k.grep(t, function(e) {
            return e.nodeType === 1;
        }));
    };
    k.fn.extend({
        find: function(e) {
            var t, n, i = this.length, r = this;
            if (typeof e !== "string") {
                return this.pushStack(k(e).filter(function() {
                    for (t = 0; t < i; t++) {
                        if (k.contains(r[t], this)) {
                            return true;
                        }
                    }
                }));
            }
            n = this.pushStack([]);
            for (t = 0; t < i; t++) {
                k.find(e, r[t], n);
            }
            return i > 1 ? k.uniqueSort(n) : n;
        },
        filter: function(e) {
            return this.pushStack(N(this, e || [], false));
        },
        not: function(e) {
            return this.pushStack(N(this, e || [], true));
        },
        is: function(e) {
            return !!N(this, 
            // If this is a positional/relative selector, check membership in the returned set
            // so $("p:first").is("p:last") won't return true for a doc with two "p".
            typeof e === "string" && E.test(e) ? k(e) : e || [], false).length;
        }
    });
    // Initialize a jQuery object
    // A central reference to the root jQuery(document)
        var j, 
    // A simple way to check for HTML strings
    // Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
    // Strict HTML recognition (#11290: must start with <)
    // Shortcut simple #id case for speed
    L = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/, I = k.fn.init = function(e, t, n) {
        var i, r;
        // HANDLE: $(""), $(null), $(undefined), $(false)
                if (!e) {
            return this;
        }
        // Method init() accepts an alternate rootjQuery
        // so migrate can support jQuery.sub (gh-2101)
                n = n || j;
        // Handle HTML strings
                if (typeof e === "string") {
            if (e[0] === "<" && e[e.length - 1] === ">" && e.length >= 3) {
                // Assume that strings that start and end with <> are HTML and skip the regex check
                i = [ null, e, null ];
            } else {
                i = L.exec(e);
            }
            // Match html or make sure no context is specified for #id
                        if (i && (i[1] || !t)) {
                // HANDLE: $(html) -> $(array)
                if (i[1]) {
                    t = t instanceof k ? t[0] : t;
                    // Option to run scripts is true for back-compat
                    // Intentionally let the error be thrown if parseHTML is not present
                                        k.merge(this, k.parseHTML(i[1], t && t.nodeType ? t.ownerDocument || t : D, true));
                    // HANDLE: $(html, props)
                                        if (A.test(i[1]) && k.isPlainObject(t)) {
                        for (i in t) {
                            // Properties of context are called as methods if possible
                            if (y(this[i])) {
                                this[i](t[i]);
                                // ...and otherwise set as attributes
                                                        } else {
                                this.attr(i, t[i]);
                            }
                        }
                    }
                    return this;
                    // HANDLE: $(#id)
                                } else {
                    r = D.getElementById(i[2]);
                    if (r) {
                        // Inject the element directly into the jQuery object
                        this[0] = r;
                        this.length = 1;
                    }
                    return this;
                }
                // HANDLE: $(expr, $(...))
                        } else if (!t || t.jquery) {
                return (t || n).find(e);
                // HANDLE: $(expr, context)
                // (which is just equivalent to: $(context).find(expr)
                        } else {
                return this.constructor(t).find(e);
            }
            // HANDLE: $(DOMElement)
                } else if (e.nodeType) {
            this[0] = e;
            this.length = 1;
            return this;
            // HANDLE: $(function)
            // Shortcut for document ready
                } else if (y(e)) {
            return n.ready !== undefined ? n.ready(e) : 
            // Execute immediately if ready is not present
            e(k);
        }
        return k.makeArray(e, this);
    };
    // Give the init function the jQuery prototype for later instantiation
        I.prototype = k.fn;
    // Initialize central reference
        j = k(D);
    var P = /^(?:parents|prev(?:Until|All))/, 
    // Methods guaranteed to produce a unique set when starting from a unique set
    O = {
        children: true,
        contents: true,
        next: true,
        prev: true
    };
    k.fn.extend({
        has: function(e) {
            var t = k(e, this), n = t.length;
            return this.filter(function() {
                var e = 0;
                for (;e < n; e++) {
                    if (k.contains(this, t[e])) {
                        return true;
                    }
                }
            });
        },
        closest: function(e, t) {
            var n, i = 0, r = this.length, o = [], a = typeof e !== "string" && k(e);
            // Positional selectors never match, since there's no _selection_ context
                        if (!E.test(e)) {
                for (;i < r; i++) {
                    for (n = this[i]; n && n !== t; n = n.parentNode) {
                        // Always skip document fragments
                        if (n.nodeType < 11 && (a ? a.index(n) > -1 : 
                        // Don't pass non-elements to Sizzle
                        n.nodeType === 1 && k.find.matchesSelector(n, e))) {
                            o.push(n);
                            break;
                        }
                    }
                }
            }
            return this.pushStack(o.length > 1 ? k.uniqueSort(o) : o);
        },
        // Determine the position of an element within the set
        index: function(e) {
            // No argument, return index in parent
            if (!e) {
                return this[0] && this[0].parentNode ? this.first().prevAll().length : -1;
            }
            // Index in selector
                        if (typeof e === "string") {
                return r.call(k(e), this[0]);
            }
            // Locate the position of the desired element
                        return r.call(this, 
            // If it receives a jQuery object, the first element is used
            e.jquery ? e[0] : e);
        },
        add: function(e, t) {
            return this.pushStack(k.uniqueSort(k.merge(this.get(), k(e, t))));
        },
        addBack: function(e) {
            return this.add(e == null ? this.prevObject : this.prevObject.filter(e));
        }
    });
    function R(e, t) {
        while ((e = e[t]) && e.nodeType !== 1) {}
        return e;
    }
    k.each({
        parent: function(e) {
            var t = e.parentNode;
            return t && t.nodeType !== 11 ? t : null;
        },
        parents: function(e) {
            return C(e, "parentNode");
        },
        parentsUntil: function(e, t, n) {
            return C(e, "parentNode", n);
        },
        next: function(e) {
            return R(e, "nextSibling");
        },
        prev: function(e) {
            return R(e, "previousSibling");
        },
        nextAll: function(e) {
            return C(e, "nextSibling");
        },
        prevAll: function(e) {
            return C(e, "previousSibling");
        },
        nextUntil: function(e, t, n) {
            return C(e, "nextSibling", n);
        },
        prevUntil: function(e, t, n) {
            return C(e, "previousSibling", n);
        },
        siblings: function(e) {
            return S((e.parentNode || {}).firstChild, e);
        },
        children: function(e) {
            return S(e.firstChild);
        },
        contents: function(e) {
            if ($(e, "iframe")) {
                return e.contentDocument;
            }
            // Support: IE 9 - 11 only, iOS 7 only, Android Browser <=4.3 only
            // Treat the template element as a regular one in browsers that
            // don't support it.
                        if ($(e, "template")) {
                e = e.content || e;
            }
            return k.merge([], e.childNodes);
        }
    }, function(i, r) {
        k.fn[i] = function(e, t) {
            var n = k.map(this, r, e);
            if (i.slice(-5) !== "Until") {
                t = e;
            }
            if (t && typeof t === "string") {
                n = k.filter(t, n);
            }
            if (this.length > 1) {
                // Remove duplicates
                if (!O[i]) {
                    k.uniqueSort(n);
                }
                // Reverse order for parents* and prev-derivatives
                                if (P.test(i)) {
                    n.reverse();
                }
            }
            return this.pushStack(n);
        };
    });
    var H = /[^\x20\t\r\n\f]+/g;
    // Convert String-formatted options into Object-formatted ones
        function q(e) {
        var n = {};
        k.each(e.match(H) || [], function(e, t) {
            n[t] = true;
        });
        return n;
    }
    /*
 * Create a callback list using the following parameters:
 *
 *	options: an optional list of space-separated options that will change how
 *			the callback list behaves or a more traditional option object
 *
 * By default a callback list will act like an event callback list and can be
 * "fired" multiple times.
 *
 * Possible options:
 *
 *	once:			will ensure the callback list can only be fired once (like a Deferred)
 *
 *	memory:			will keep track of previous values and will call any callback added
 *					after the list has been fired right away with the latest "memorized"
 *					values (like a Deferred)
 *
 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
 *
 *	stopOnFalse:	interrupt callings when a callback returns false
 *
 */    k.Callbacks = function(i) {
        // Convert options from String-formatted to Object-formatted if needed
        // (we check in cache first)
        i = typeof i === "string" ? q(i) : k.extend({}, i);
        var // Flag to know if list is currently firing
        n, 
        // Last fire value for non-forgettable lists
        e, 
        // Flag to know if list was already fired
        t, 
        // Flag to prevent firing
        r, 
        // Actual callback list
        o = [], 
        // Queue of execution data for repeatable lists
        a = [], 
        // Index of currently firing callback (modified by add/remove as needed)
        s = -1, 
        // Fire callbacks
        l = function() {
            // Enforce single-firing
            r = r || i.once;
            // Execute callbacks for all pending executions,
            // respecting firingIndex overrides and runtime changes
                        t = n = true;
            for (;a.length; s = -1) {
                e = a.shift();
                while (++s < o.length) {
                    // Run callback and check for early termination
                    if (o[s].apply(e[0], e[1]) === false && i.stopOnFalse) {
                        // Jump to end and forget the data so .add doesn't re-fire
                        s = o.length;
                        e = false;
                    }
                }
            }
            // Forget the data if we're done with it
                        if (!i.memory) {
                e = false;
            }
            n = false;
            // Clean up if we're done firing for good
                        if (r) {
                // Keep an empty list if we have data for future add calls
                if (e) {
                    o = [];
                    // Otherwise, this object is spent
                                } else {
                    o = "";
                }
            }
        }, 
        // Actual Callbacks object
        f = {
            // Add a callback or a collection of callbacks to the list
            add: function() {
                if (o) {
                    // If we have memory from a past run, we should fire after adding
                    if (e && !n) {
                        s = o.length - 1;
                        a.push(e);
                    }
                    (function n(e) {
                        k.each(e, function(e, t) {
                            if (y(t)) {
                                if (!i.unique || !f.has(t)) {
                                    o.push(t);
                                }
                            } else if (t && t.length && x(t) !== "string") {
                                // Inspect recursively
                                n(t);
                            }
                        });
                    })(arguments);
                    if (e && !n) {
                        l();
                    }
                }
                return this;
            },
            // Remove a callback from the list
            remove: function() {
                k.each(arguments, function(e, t) {
                    var n;
                    while ((n = k.inArray(t, o, n)) > -1) {
                        o.splice(n, 1);
                        // Handle firing indexes
                                                if (n <= s) {
                            s--;
                        }
                    }
                });
                return this;
            },
            // Check if a given callback is in the list.
            // If no argument is given, return whether or not list has callbacks attached.
            has: function(e) {
                return e ? k.inArray(e, o) > -1 : o.length > 0;
            },
            // Remove all callbacks from the list
            empty: function() {
                if (o) {
                    o = [];
                }
                return this;
            },
            // Disable .fire and .add
            // Abort any current/pending executions
            // Clear all callbacks and values
            disable: function() {
                r = a = [];
                o = e = "";
                return this;
            },
            disabled: function() {
                return !o;
            },
            // Disable .fire
            // Also disable .add unless we have memory (since it would have no effect)
            // Abort any pending executions
            lock: function() {
                r = a = [];
                if (!e && !n) {
                    o = e = "";
                }
                return this;
            },
            locked: function() {
                return !!r;
            },
            // Call all callbacks with the given context and arguments
            fireWith: function(e, t) {
                if (!r) {
                    t = t || [];
                    t = [ e, t.slice ? t.slice() : t ];
                    a.push(t);
                    if (!n) {
                        l();
                    }
                }
                return this;
            },
            // Call all the callbacks with the given arguments
            fire: function() {
                f.fireWith(this, arguments);
                return this;
            },
            // To know if the callbacks have already been called at least once
            fired: function() {
                return !!t;
            }
        };
        return f;
    };
    function B(e) {
        return e;
    }
    function M(e) {
        throw e;
    }
    function _(e, t, n, i) {
        var r;
        try {
            // Check for promise aspect first to privilege synchronous behavior
            if (e && y(r = e.promise)) {
                r.call(e).done(t).fail(n);
                // Other thenables
                        } else if (e && y(r = e.then)) {
                r.call(e, t, n);
                // Other non-thenables
                        } else {
                // Control `resolve` arguments by letting Array#slice cast boolean `noValue` to integer:
                // * false: [ value ].slice( 0 ) => resolve( value )
                // * true: [ value ].slice( 1 ) => resolve()
                t.apply(undefined, [ e ].slice(i));
            }
            // For Promises/A+, convert exceptions into rejections
            // Since jQuery.when doesn't unwrap thenables, we can skip the extra checks appearing in
            // Deferred#then to conditionally suppress rejection.
                } catch (e) {
            // Support: Android 4.0 only
            // Strict mode functions invoked without .call/.apply get global-object context
            n.apply(undefined, [ e ]);
        }
    }
    k.extend({
        Deferred: function(e) {
            var o = [ 
            // action, add listener, callbacks,
            // ... .then handlers, argument index, [final state]
            [ "notify", "progress", k.Callbacks("memory"), k.Callbacks("memory"), 2 ], [ "resolve", "done", k.Callbacks("once memory"), k.Callbacks("once memory"), 0, "resolved" ], [ "reject", "fail", k.Callbacks("once memory"), k.Callbacks("once memory"), 1, "rejected" ] ], r = "pending", a = {
                state: function() {
                    return r;
                },
                always: function() {
                    s.done(arguments).fail(arguments);
                    return this;
                },
                catch: function(e) {
                    return a.then(null, e);
                },
                // Keep pipe for back-compat
                pipe: function() {
                    var r = arguments;
                    return k.Deferred(function(i) {
                        k.each(o, function(e, t) {
                            // Map tuples (progress, done, fail) to arguments (done, fail, progress)
                            var n = y(r[t[4]]) && r[t[4]];
                            // deferred.progress(function() { bind to newDefer or newDefer.notify })
                            // deferred.done(function() { bind to newDefer or newDefer.resolve })
                            // deferred.fail(function() { bind to newDefer or newDefer.reject })
                                                        s[t[1]](function() {
                                var e = n && n.apply(this, arguments);
                                if (e && y(e.promise)) {
                                    e.promise().progress(i.notify).done(i.resolve).fail(i.reject);
                                } else {
                                    i[t[0] + "With"](this, n ? [ e ] : arguments);
                                }
                            });
                        });
                        r = null;
                    }).promise();
                },
                then: function(t, n, i) {
                    var l = 0;
                    function f(r, o, a, s) {
                        return function() {
                            var n = this, i = arguments, e = function() {
                                var e, t;
                                // Support: Promises/A+ section 2.3.3.3.3
                                // https://promisesaplus.com/#point-59
                                // Ignore double-resolution attempts
                                                                if (r < l) {
                                    return;
                                }
                                e = a.apply(n, i);
                                // Support: Promises/A+ section 2.3.1
                                // https://promisesaplus.com/#point-48
                                                                if (e === o.promise()) {
                                    throw new TypeError("Thenable self-resolution");
                                }
                                // Support: Promises/A+ sections 2.3.3.1, 3.5
                                // https://promisesaplus.com/#point-54
                                // https://promisesaplus.com/#point-75
                                // Retrieve `then` only once
                                                                t = e && (
                                // Support: Promises/A+ section 2.3.4
                                // https://promisesaplus.com/#point-64
                                // Only check objects and functions for thenability
                                typeof e === "object" || typeof e === "function") && e.then;
                                // Handle a returned thenable
                                                                if (y(t)) {
                                    // Special processors (notify) just wait for resolution
                                    if (s) {
                                        t.call(e, f(l, o, B, s), f(l, o, M, s));
                                        // Normal processors (resolve) also hook into progress
                                                                        } else {
                                        // ...and disregard older resolution values
                                        l++;
                                        t.call(e, f(l, o, B, s), f(l, o, M, s), f(l, o, B, o.notifyWith));
                                    }
                                    // Handle all other returned values
                                                                } else {
                                    // Only substitute handlers pass on context
                                    // and multiple values (non-spec behavior)
                                    if (a !== B) {
                                        n = undefined;
                                        i = [ e ];
                                    }
                                    // Process the value(s)
                                    // Default process is resolve
                                                                        // Process the value(s)
                                    // Default process is resolve
                                    (s || o.resolveWith)(n, i);
                                }
                            }, 
                            // Only normal processors (resolve) catch and reject exceptions
                            t = s ? e : function() {
                                try {
                                    e();
                                } catch (e) {
                                    if (k.Deferred.exceptionHook) {
                                        k.Deferred.exceptionHook(e, t.stackTrace);
                                    }
                                    // Support: Promises/A+ section 2.3.3.3.4.1
                                    // https://promisesaplus.com/#point-61
                                    // Ignore post-resolution exceptions
                                                                        if (r + 1 >= l) {
                                        // Only substitute handlers pass on context
                                        // and multiple values (non-spec behavior)
                                        if (a !== M) {
                                            n = undefined;
                                            i = [ e ];
                                        }
                                        o.rejectWith(n, i);
                                    }
                                }
                            };
                            // Support: Promises/A+ section 2.3.3.3.1
                            // https://promisesaplus.com/#point-57
                            // Re-resolve promises immediately to dodge false rejection from
                            // subsequent errors
                                                        if (r) {
                                t();
                            } else {
                                // Call an optional hook to record the stack, in case of exception
                                // since it's otherwise lost when execution goes async
                                if (k.Deferred.getStackHook) {
                                    t.stackTrace = k.Deferred.getStackHook();
                                }
                                T.setTimeout(t);
                            }
                        };
                    }
                    return k.Deferred(function(e) {
                        // progress_handlers.add( ... )
                        o[0][3].add(f(0, e, y(i) ? i : B, e.notifyWith));
                        // fulfilled_handlers.add( ... )
                                                o[1][3].add(f(0, e, y(t) ? t : B));
                        // rejected_handlers.add( ... )
                                                o[2][3].add(f(0, e, y(n) ? n : M));
                    }).promise();
                },
                // Get a promise for this deferred
                // If obj is provided, the promise aspect is added to the object
                promise: function(e) {
                    return e != null ? k.extend(e, a) : a;
                }
            }, s = {};
            // Add list-specific methods
                        k.each(o, function(e, t) {
                var n = t[2], i = t[5];
                // promise.progress = list.add
                // promise.done = list.add
                // promise.fail = list.add
                                a[t[1]] = n.add;
                // Handle state
                                if (i) {
                    n.add(function() {
                        // state = "resolved" (i.e., fulfilled)
                        // state = "rejected"
                        r = i;
                    }, 
                    // rejected_callbacks.disable
                    // fulfilled_callbacks.disable
                    o[3 - e][2].disable, 
                    // rejected_handlers.disable
                    // fulfilled_handlers.disable
                    o[3 - e][3].disable, 
                    // progress_callbacks.lock
                    o[0][2].lock, 
                    // progress_handlers.lock
                    o[0][3].lock);
                }
                // progress_handlers.fire
                // fulfilled_handlers.fire
                // rejected_handlers.fire
                                n.add(t[3].fire);
                // deferred.notify = function() { deferred.notifyWith(...) }
                // deferred.resolve = function() { deferred.resolveWith(...) }
                // deferred.reject = function() { deferred.rejectWith(...) }
                                s[t[0]] = function() {
                    s[t[0] + "With"](this === s ? undefined : this, arguments);
                    return this;
                };
                // deferred.notifyWith = list.fireWith
                // deferred.resolveWith = list.fireWith
                // deferred.rejectWith = list.fireWith
                                s[t[0] + "With"] = n.fireWith;
            });
            // Make the deferred a promise
                        a.promise(s);
            // Call given func if any
                        if (e) {
                e.call(s, s);
            }
            // All done!
                        return s;
        },
        // Deferred helper
        when: function(e) {
            var 
            // count of uncompleted subordinates
            n = arguments.length, 
            // count of unprocessed arguments
            t = n, 
            // subordinate fulfillment data
            i = Array(t), r = s.call(arguments), 
            // the master Deferred
            o = k.Deferred(), 
            // subordinate callback factory
            a = function(t) {
                return function(e) {
                    i[t] = this;
                    r[t] = arguments.length > 1 ? s.call(arguments) : e;
                    if (!--n) {
                        o.resolveWith(i, r);
                    }
                };
            };
            // Single- and empty arguments are adopted like Promise.resolve
                        if (n <= 1) {
                _(e, o.done(a(t)).resolve, o.reject, !n);
                // Use .then() to unwrap secondary thenables (cf. gh-3000)
                                if (o.state() === "pending" || y(r[t] && r[t].then)) {
                    return o.then();
                }
            }
            // Multiple arguments are aggregated like Promise.all array elements
                        while (t--) {
                _(r[t], a(t), o.reject);
            }
            return o.promise();
        }
    });
    // These usually indicate a programmer mistake during development,
    // warn about them ASAP rather than swallowing them by default.
        var F = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;
    k.Deferred.exceptionHook = function(e, t) {
        // Support: IE 8 - 9 only
        // Console exists when dev tools are open, which can happen at any time
        if (T.console && T.console.warn && e && F.test(e.name)) {
            T.console.warn("jQuery.Deferred exception: " + e.message, e.stack, t);
        }
    };
    k.readyException = function(e) {
        T.setTimeout(function() {
            throw e;
        });
    };
    // The deferred used on DOM ready
        var U = k.Deferred();
    k.fn.ready = function(e) {
        U.then(e).catch(function(e) {
            k.readyException(e);
        });
        return this;
    };
    k.extend({
        // Is the DOM ready to be used? Set to true once it occurs.
        isReady: false,
        // A counter to track how many items to wait for before
        // the ready event fires. See #6781
        readyWait: 1,
        // Handle when the DOM is ready
        ready: function(e) {
            // Abort if there are pending holds or we're already ready
            if (e === true ? --k.readyWait : k.isReady) {
                return;
            }
            // Remember that the DOM is ready
                        k.isReady = true;
            // If a normal DOM Ready event fired, decrement, and wait if need be
                        if (e !== true && --k.readyWait > 0) {
                return;
            }
            // If there are functions bound, to execute
                        U.resolveWith(D, [ k ]);
        }
    });
    k.ready.then = U.then;
    // The ready event handler and self cleanup method
        function W() {
        D.removeEventListener("DOMContentLoaded", W);
        T.removeEventListener("load", W);
        k.ready();
    }
    // Catch cases where $(document).ready() is called
    // after the browser event has already occurred.
    // Support: IE <=9 - 10 only
    // Older IE sometimes signals "interactive" too soon
        if (D.readyState === "complete" || D.readyState !== "loading" && !D.documentElement.doScroll) {
        // Handle it asynchronously to allow scripts the opportunity to delay ready
        T.setTimeout(k.ready);
    } else {
        // Use the handy event callback
        D.addEventListener("DOMContentLoaded", W);
        // A fallback to window.onload, that will always work
                T.addEventListener("load", W);
    }
    // Multifunctional method to get and set values of a collection
    // The value/s can optionally be executed if it's a function
        var z = function(e, t, n, i, r, o, a) {
        var s = 0, l = e.length, f = n == null;
        // Sets many values
                if (x(n) === "object") {
            r = true;
            for (s in n) {
                z(e, t, s, n[s], true, o, a);
            }
            // Sets one value
                } else if (i !== undefined) {
            r = true;
            if (!y(i)) {
                a = true;
            }
            if (f) {
                // Bulk operations run against the entire set
                if (a) {
                    t.call(e, i);
                    t = null;
                    // ...except when executing function values
                                } else {
                    f = t;
                    t = function(e, t, n) {
                        return f.call(k(e), n);
                    };
                }
            }
            if (t) {
                for (;s < l; s++) {
                    t(e[s], n, a ? i : i.call(e[s], s, t(e[s], n)));
                }
            }
        }
        if (r) {
            return e;
        }
        // Gets
                if (f) {
            return t.call(e);
        }
        return l ? t(e[0], n) : o;
    };
    // Matches dashed string for camelizing
        var G = /^-ms-/, Q = /-([a-z])/g;
    // Used by camelCase as callback to replace()
        function V(e, t) {
        return t.toUpperCase();
    }
    // Convert dashed to camelCase; used by the css and data modules
    // Support: IE <=9 - 11, Edge 12 - 15
    // Microsoft forgot to hump their vendor prefix (#9572)
        function X(e) {
        return e.replace(G, "ms-").replace(Q, V);
    }
    var Y = function(e) {
        // Accepts only:
        //  - Node
        //    - Node.ELEMENT_NODE
        //    - Node.DOCUMENT_NODE
        //  - Object
        //    - Any
        return e.nodeType === 1 || e.nodeType === 9 || !+e.nodeType;
    };
    function J() {
        this.expando = k.expando + J.uid++;
    }
    J.uid = 1;
    J.prototype = {
        cache: function(e) {
            // Check if the owner object already has a cache
            var t = e[this.expando];
            // If not, create one
                        if (!t) {
                t = {};
                // We can accept data for non-element nodes in modern browsers,
                // but we should not, see #8335.
                // Always return an empty object.
                                if (Y(e)) {
                    // If it is a node unlikely to be stringify-ed or looped over
                    // use plain assignment
                    if (e.nodeType) {
                        e[this.expando] = t;
                        // Otherwise secure it in a non-enumerable property
                        // configurable must be true to allow the property to be
                        // deleted when data is removed
                                        } else {
                        Object.defineProperty(e, this.expando, {
                            value: t,
                            configurable: true
                        });
                    }
                }
            }
            return t;
        },
        set: function(e, t, n) {
            var i, r = this.cache(e);
            // Handle: [ owner, key, value ] args
            // Always use camelCase key (gh-2257)
                        if (typeof t === "string") {
                r[X(t)] = n;
                // Handle: [ owner, { properties } ] args
                        } else {
                // Copy the properties one-by-one to the cache object
                for (i in t) {
                    r[X(i)] = t[i];
                }
            }
            return r;
        },
        get: function(e, t) {
            return t === undefined ? this.cache(e) : 
            // Always use camelCase key (gh-2257)
            e[this.expando] && e[this.expando][X(t)];
        },
        access: function(e, t, n) {
            // In cases where either:
            //
            //   1. No key was specified
            //   2. A string key was specified, but no value provided
            //
            // Take the "read" path and allow the get method to determine
            // which value to return, respectively either:
            //
            //   1. The entire cache object
            //   2. The data stored at the key
            //
            if (t === undefined || t && typeof t === "string" && n === undefined) {
                return this.get(e, t);
            }
            // When the key is not a string, or both a key and value
            // are specified, set or extend (existing objects) with either:
            //
            //   1. An object of properties
            //   2. A key and value
            //
                        this.set(e, t, n);
            // Since the "set" path can have two possible entry points
            // return the expected data based on which path was taken[*]
                        return n !== undefined ? n : t;
        },
        remove: function(e, t) {
            var n, i = e[this.expando];
            if (i === undefined) {
                return;
            }
            if (t !== undefined) {
                // Support array or space separated string of keys
                if (Array.isArray(t)) {
                    // If key is an array of keys...
                    // We always set camelCase keys, so remove that.
                    t = t.map(X);
                } else {
                    t = X(t);
                    // If a key with the spaces exists, use it.
                    // Otherwise, create an array by matching non-whitespace
                                        t = t in i ? [ t ] : t.match(H) || [];
                }
                n = t.length;
                while (n--) {
                    delete i[t[n]];
                }
            }
            // Remove the expando if there's no more data
                        if (t === undefined || k.isEmptyObject(i)) {
                // Support: Chrome <=35 - 45
                // Webkit & Blink performance suffers when deleting properties
                // from DOM nodes, so set to undefined instead
                // https://bugs.chromium.org/p/chromium/issues/detail?id=378607 (bug restricted)
                if (e.nodeType) {
                    e[this.expando] = undefined;
                } else {
                    delete e[this.expando];
                }
            }
        },
        hasData: function(e) {
            var t = e[this.expando];
            return t !== undefined && !k.isEmptyObject(t);
        }
    };
    var K = new J();
    var Z = new J();
    //	Implementation Summary
    //
    //	1. Enforce API surface and semantic compatibility with 1.9.x branch
    //	2. Improve the module's maintainability by reducing the storage
    //		paths to a single mechanism.
    //	3. Use the same single mechanism to support "private" and "user" data.
    //	4. _Never_ expose "private" data to user code (TODO: Drop _data, _removeData)
    //	5. Avoid exposing implementation details on user objects (eg. expando properties)
    //	6. Provide a clear path for implementation upgrade to WeakMap in 2014
        var ee = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/, te = /[A-Z]/g;
    function ne(e) {
        if (e === "true") {
            return true;
        }
        if (e === "false") {
            return false;
        }
        if (e === "null") {
            return null;
        }
        // Only convert to a number if it doesn't change the string
                if (e === +e + "") {
            return +e;
        }
        if (ee.test(e)) {
            return JSON.parse(e);
        }
        return e;
    }
    function ie(e, t, n) {
        var i;
        // If nothing was found internally, try to fetch any
        // data from the HTML5 data-* attribute
                if (n === undefined && e.nodeType === 1) {
            i = "data-" + t.replace(te, "-$&").toLowerCase();
            n = e.getAttribute(i);
            if (typeof n === "string") {
                try {
                    n = ne(n);
                } catch (e) {}
                // Make sure we set the data so it isn't changed later
                                Z.set(e, t, n);
            } else {
                n = undefined;
            }
        }
        return n;
    }
    k.extend({
        hasData: function(e) {
            return Z.hasData(e) || K.hasData(e);
        },
        data: function(e, t, n) {
            return Z.access(e, t, n);
        },
        removeData: function(e, t) {
            Z.remove(e, t);
        },
        // TODO: Now that all calls to _data and _removeData have been replaced
        // with direct calls to dataPriv methods, these can be deprecated.
        _data: function(e, t, n) {
            return K.access(e, t, n);
        },
        _removeData: function(e, t) {
            K.remove(e, t);
        }
    });
    k.fn.extend({
        data: function(n, e) {
            var t, i, r, o = this[0], a = o && o.attributes;
            // Gets all values
                        if (n === undefined) {
                if (this.length) {
                    r = Z.get(o);
                    if (o.nodeType === 1 && !K.get(o, "hasDataAttrs")) {
                        t = a.length;
                        while (t--) {
                            // Support: IE 11 only
                            // The attrs elements can be null (#14894)
                            if (a[t]) {
                                i = a[t].name;
                                if (i.indexOf("data-") === 0) {
                                    i = X(i.slice(5));
                                    ie(o, i, r[i]);
                                }
                            }
                        }
                        K.set(o, "hasDataAttrs", true);
                    }
                }
                return r;
            }
            // Sets multiple values
                        if (typeof n === "object") {
                return this.each(function() {
                    Z.set(this, n);
                });
            }
            return z(this, function(e) {
                var t;
                // The calling jQuery object (element matches) is not empty
                // (and therefore has an element appears at this[ 0 ]) and the
                // `value` parameter was not undefined. An empty jQuery object
                // will result in `undefined` for elem = this[ 0 ] which will
                // throw an exception if an attempt to read a data cache is made.
                                if (o && e === undefined) {
                    // Attempt to get data from the cache
                    // The key will always be camelCased in Data
                    t = Z.get(o, n);
                    if (t !== undefined) {
                        return t;
                    }
                    // Attempt to "discover" the data in
                    // HTML5 custom data-* attrs
                                        t = ie(o, n);
                    if (t !== undefined) {
                        return t;
                    }
                    // We tried really hard, but the data doesn't exist.
                                        return;
                }
                // Set the data...
                                this.each(function() {
                    // We always store the camelCased key
                    Z.set(this, n, e);
                });
            }, null, e, arguments.length > 1, null, true);
        },
        removeData: function(e) {
            return this.each(function() {
                Z.remove(this, e);
            });
        }
    });
    k.extend({
        queue: function(e, t, n) {
            var i;
            if (e) {
                t = (t || "fx") + "queue";
                i = K.get(e, t);
                // Speed up dequeue by getting out quickly if this is just a lookup
                                if (n) {
                    if (!i || Array.isArray(n)) {
                        i = K.access(e, t, k.makeArray(n));
                    } else {
                        i.push(n);
                    }
                }
                return i || [];
            }
        },
        dequeue: function(e, t) {
            t = t || "fx";
            var n = k.queue(e, t), i = n.length, r = n.shift(), o = k._queueHooks(e, t), a = function() {
                k.dequeue(e, t);
            };
            // If the fx queue is dequeued, always remove the progress sentinel
                        if (r === "inprogress") {
                r = n.shift();
                i--;
            }
            if (r) {
                // Add a progress sentinel to prevent the fx queue from being
                // automatically dequeued
                if (t === "fx") {
                    n.unshift("inprogress");
                }
                // Clear up the last queue stop function
                                delete o.stop;
                r.call(e, a, o);
            }
            if (!i && o) {
                o.empty.fire();
            }
        },
        // Not public - generate a queueHooks object, or return the current one
        _queueHooks: function(e, t) {
            var n = t + "queueHooks";
            return K.get(e, n) || K.access(e, n, {
                empty: k.Callbacks("once memory").add(function() {
                    K.remove(e, [ t + "queue", n ]);
                })
            });
        }
    });
    k.fn.extend({
        queue: function(t, n) {
            var e = 2;
            if (typeof t !== "string") {
                n = t;
                t = "fx";
                e--;
            }
            if (arguments.length < e) {
                return k.queue(this[0], t);
            }
            return n === undefined ? this : this.each(function() {
                var e = k.queue(this, t, n);
                // Ensure a hooks for this queue
                                k._queueHooks(this, t);
                if (t === "fx" && e[0] !== "inprogress") {
                    k.dequeue(this, t);
                }
            });
        },
        dequeue: function(e) {
            return this.each(function() {
                k.dequeue(this, e);
            });
        },
        clearQueue: function(e) {
            return this.queue(e || "fx", []);
        },
        // Get a promise resolved when queues of a certain type
        // are emptied (fx is the type by default)
        promise: function(e, t) {
            var n, i = 1, r = k.Deferred(), o = this, a = this.length, s = function() {
                if (!--i) {
                    r.resolveWith(o, [ o ]);
                }
            };
            if (typeof e !== "string") {
                t = e;
                e = undefined;
            }
            e = e || "fx";
            while (a--) {
                n = K.get(o[a], e + "queueHooks");
                if (n && n.empty) {
                    i++;
                    n.empty.add(s);
                }
            }
            s();
            return r.promise(t);
        }
    });
    var re = /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source;
    var oe = new RegExp("^(?:([+-])=|)(" + re + ")([a-z%]*)$", "i");
    var ae = [ "Top", "Right", "Bottom", "Left" ];
    var se = function(e, t) {
        // isHiddenWithinTree might be called from jQuery#filter function;
        // in that case, element will be second argument
        e = t || e;
        // Inline style trumps all
                return e.style.display === "none" || e.style.display === "" && 
        // Otherwise, check computed style
        // Support: Firefox <=43 - 45
        // Disconnected elements can have computed display: none, so first confirm that elem is
        // in the document.
        k.contains(e.ownerDocument, e) && k.css(e, "display") === "none";
    };
    var le = function(e, t, n, i) {
        var r, o, a = {};
        // Remember the old values, and insert the new ones
                for (o in t) {
            a[o] = e.style[o];
            e.style[o] = t[o];
        }
        r = n.apply(e, i || []);
        // Revert the old values
                for (o in t) {
            e.style[o] = a[o];
        }
        return r;
    };
    function fe(e, t, n, i) {
        var r, o, a = 20, s = i ? function() {
            return i.cur();
        } : function() {
            return k.css(e, t, "");
        }, l = s(), f = n && n[3] || (k.cssNumber[t] ? "" : "px"), 
        // Starting value computation is required for potential unit mismatches
        u = (k.cssNumber[t] || f !== "px" && +l) && oe.exec(k.css(e, t));
        if (u && u[3] !== f) {
            // Support: Firefox <=54
            // Halve the iteration target value to prevent interference from CSS upper bounds (gh-2144)
            l = l / 2;
            // Trust units reported by jQuery.css
                        f = f || u[3];
            // Iteratively approximate from a nonzero starting point
                        u = +l || 1;
            while (a--) {
                // Evaluate and update our best guess (doubling guesses that zero out).
                // Finish if the scale equals or crosses 1 (making the old*new product non-positive).
                k.style(e, t, u + f);
                if ((1 - o) * (1 - (o = s() / l || .5)) <= 0) {
                    a = 0;
                }
                u = u / o;
            }
            u = u * 2;
            k.style(e, t, u + f);
            // Make sure we update the tween properties later on
                        n = n || [];
        }
        if (n) {
            u = +u || +l || 0;
            // Apply relative offset (+=/-=) if specified
                        r = n[1] ? u + (n[1] + 1) * n[2] : +n[2];
            if (i) {
                i.unit = f;
                i.start = u;
                i.end = r;
            }
        }
        return r;
    }
    var ue = {};
    function ce(e) {
        var t, n = e.ownerDocument, i = e.nodeName, r = ue[i];
        if (r) {
            return r;
        }
        t = n.body.appendChild(n.createElement(i));
        r = k.css(t, "display");
        t.parentNode.removeChild(t);
        if (r === "none") {
            r = "block";
        }
        ue[i] = r;
        return r;
    }
    function de(e, t) {
        var n, i, r = [], o = 0, a = e.length;
        // Determine new display value for elements that need to change
                for (;o < a; o++) {
            i = e[o];
            if (!i.style) {
                continue;
            }
            n = i.style.display;
            if (t) {
                // Since we force visibility upon cascade-hidden elements, an immediate (and slow)
                // check is required in this first loop unless we have a nonempty display value (either
                // inline or about-to-be-restored)
                if (n === "none") {
                    r[o] = K.get(i, "display") || null;
                    if (!r[o]) {
                        i.style.display = "";
                    }
                }
                if (i.style.display === "" && se(i)) {
                    r[o] = ce(i);
                }
            } else {
                if (n !== "none") {
                    r[o] = "none";
                    // Remember what we're overwriting
                                        K.set(i, "display", n);
                }
            }
        }
        // Set the display of the elements in a second loop to avoid constant reflow
                for (o = 0; o < a; o++) {
            if (r[o] != null) {
                e[o].style.display = r[o];
            }
        }
        return e;
    }
    k.fn.extend({
        show: function() {
            return de(this, true);
        },
        hide: function() {
            return de(this);
        },
        toggle: function(e) {
            if (typeof e === "boolean") {
                return e ? this.show() : this.hide();
            }
            return this.each(function() {
                if (se(this)) {
                    k(this).show();
                } else {
                    k(this).hide();
                }
            });
        }
    });
    var pe = /^(?:checkbox|radio)$/i;
    var he = /<([a-z][^\/\0>\x20\t\r\n\f]+)/i;
    var ge = /^$|^module$|\/(?:java|ecma)script/i;
    // We have to close these tags to support XHTML (#13200)
        var ve = {
        // Support: IE <=9 only
        option: [ 1, "<select multiple='multiple'>", "</select>" ],
        // XHTML parsers do not magically insert elements in the
        // same way that tag soup parsers do. So we cannot shorten
        // this by omitting <tbody> or other required elements.
        thead: [ 1, "<table>", "</table>" ],
        col: [ 2, "<table><colgroup>", "</colgroup></table>" ],
        tr: [ 2, "<table><tbody>", "</tbody></table>" ],
        td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],
        _default: [ 0, "", "" ]
    };
    // Support: IE <=9 only
        ve.optgroup = ve.option;
    ve.tbody = ve.tfoot = ve.colgroup = ve.caption = ve.thead;
    ve.th = ve.td;
    function me(e, t) {
        // Support: IE <=9 - 11 only
        // Use typeof to avoid zero-argument method invocation on host objects (#15151)
        var n;
        if (typeof e.getElementsByTagName !== "undefined") {
            n = e.getElementsByTagName(t || "*");
        } else if (typeof e.querySelectorAll !== "undefined") {
            n = e.querySelectorAll(t || "*");
        } else {
            n = [];
        }
        if (t === undefined || t && $(e, t)) {
            return k.merge([ e ], n);
        }
        return n;
    }
    // Mark scripts as having already been evaluated
        function ye(e, t) {
        var n = 0, i = e.length;
        for (;n < i; n++) {
            K.set(e[n], "globalEval", !t || K.get(t[n], "globalEval"));
        }
    }
    var be = /<|&#?\w+;/;
    function we(e, t, n, i, r) {
        var o, a, s, l, f, u, c = t.createDocumentFragment(), d = [], p = 0, h = e.length;
        for (;p < h; p++) {
            o = e[p];
            if (o || o === 0) {
                // Add nodes directly
                if (x(o) === "object") {
                    // Support: Android <=4.0 only, PhantomJS 1 only
                    // push.apply(_, arraylike) throws on ancient WebKit
                    k.merge(d, o.nodeType ? [ o ] : o);
                    // Convert non-html into a text node
                                } else if (!be.test(o)) {
                    d.push(t.createTextNode(o));
                    // Convert html into DOM nodes
                                } else {
                    a = a || c.appendChild(t.createElement("div"));
                    // Deserialize a standard representation
                                        s = (he.exec(o) || [ "", "" ])[1].toLowerCase();
                    l = ve[s] || ve._default;
                    a.innerHTML = l[1] + k.htmlPrefilter(o) + l[2];
                    // Descend through wrappers to the right content
                                        u = l[0];
                    while (u--) {
                        a = a.lastChild;
                    }
                    // Support: Android <=4.0 only, PhantomJS 1 only
                    // push.apply(_, arraylike) throws on ancient WebKit
                                        k.merge(d, a.childNodes);
                    // Remember the top-level container
                                        a = c.firstChild;
                    // Ensure the created nodes are orphaned (#12392)
                                        a.textContent = "";
                }
            }
        }
        // Remove wrapper from fragment
                c.textContent = "";
        p = 0;
        while (o = d[p++]) {
            // Skip elements already in the context collection (trac-4087)
            if (i && k.inArray(o, i) > -1) {
                if (r) {
                    r.push(o);
                }
                continue;
            }
            f = k.contains(o.ownerDocument, o);
            // Append to fragment
                        a = me(c.appendChild(o), "script");
            // Preserve script evaluation history
                        if (f) {
                ye(a);
            }
            // Capture executables
                        if (n) {
                u = 0;
                while (o = a[u++]) {
                    if (ge.test(o.type || "")) {
                        n.push(o);
                    }
                }
            }
        }
        return c;
    }
    (function() {
        var e = D.createDocumentFragment(), t = e.appendChild(D.createElement("div")), n = D.createElement("input");
        // Support: Android 4.0 - 4.3 only
        // Check state lost if the name is set (#11217)
        // Support: Windows Web Apps (WWA)
        // `name` and `type` must use .setAttribute for WWA (#14901)
                n.setAttribute("type", "radio");
        n.setAttribute("checked", "checked");
        n.setAttribute("name", "t");
        t.appendChild(n);
        // Support: Android <=4.1 only
        // Older WebKit doesn't clone checked state correctly in fragments
                m.checkClone = t.cloneNode(true).cloneNode(true).lastChild.checked;
        // Support: IE <=11 only
        // Make sure textarea (and checkbox) defaultValue is properly cloned
                t.innerHTML = "<textarea>x</textarea>";
        m.noCloneChecked = !!t.cloneNode(true).lastChild.defaultValue;
    })();
    var xe = D.documentElement;
    var Ce = /^key/, Te = /^(?:mouse|pointer|contextmenu|drag|drop)|click/, De = /^([^.]*)(?:\.(.+)|)/;
    function ke() {
        return true;
    }
    function Se() {
        return false;
    }
    // Support: IE <=9 only
    // See #13393 for more info
        function Ee() {
        try {
            return D.activeElement;
        } catch (e) {}
    }
    function $e(e, t, n, i, r, o) {
        var a, s;
        // Types can be a map of types/handlers
                if (typeof t === "object") {
            // ( types-Object, selector, data )
            if (typeof n !== "string") {
                // ( types-Object, data )
                i = i || n;
                n = undefined;
            }
            for (s in t) {
                $e(e, s, n, i, t[s], o);
            }
            return e;
        }
        if (i == null && r == null) {
            // ( types, fn )
            r = n;
            i = n = undefined;
        } else if (r == null) {
            if (typeof n === "string") {
                // ( types, selector, fn )
                r = i;
                i = undefined;
            } else {
                // ( types, data, fn )
                r = i;
                i = n;
                n = undefined;
            }
        }
        if (r === false) {
            r = Se;
        } else if (!r) {
            return e;
        }
        if (o === 1) {
            a = r;
            r = function(e) {
                // Can use an empty set, since event contains the info
                k().off(e);
                return a.apply(this, arguments);
            };
            // Use same guid so caller can remove using origFn
                        r.guid = a.guid || (a.guid = k.guid++);
        }
        return e.each(function() {
            k.event.add(this, t, r, i, n);
        });
    }
    /*
 * Helper functions for managing events -- not part of the public interface.
 * Props to Dean Edwards' addEvent library for many of the ideas.
 */    k.event = {
        global: {},
        add: function(t, e, n, i, r) {
            var o, a, s, l, f, u, c, d, p, h, g, v = K.get(t);
            // Don't attach events to noData or text/comment nodes (but allow plain objects)
                        if (!v) {
                return;
            }
            // Caller can pass in an object of custom data in lieu of the handler
                        if (n.handler) {
                o = n;
                n = o.handler;
                r = o.selector;
            }
            // Ensure that invalid selectors throw exceptions at attach time
            // Evaluate against documentElement in case elem is a non-element node (e.g., document)
                        if (r) {
                k.find.matchesSelector(xe, r);
            }
            // Make sure that the handler has a unique ID, used to find/remove it later
                        if (!n.guid) {
                n.guid = k.guid++;
            }
            // Init the element's event structure and main handler, if this is the first
                        if (!(l = v.events)) {
                l = v.events = {};
            }
            if (!(a = v.handle)) {
                a = v.handle = function(e) {
                    // Discard the second event of a jQuery.event.trigger() and
                    // when an event is called after a page has unloaded
                    return typeof k !== "undefined" && k.event.triggered !== e.type ? k.event.dispatch.apply(t, arguments) : undefined;
                };
            }
            // Handle multiple events separated by a space
                        e = (e || "").match(H) || [ "" ];
            f = e.length;
            while (f--) {
                s = De.exec(e[f]) || [];
                p = g = s[1];
                h = (s[2] || "").split(".").sort();
                // There *must* be a type, no attaching namespace-only handlers
                                if (!p) {
                    continue;
                }
                // If event changes its type, use the special event handlers for the changed type
                                c = k.event.special[p] || {};
                // If selector defined, determine special event api type, otherwise given type
                                p = (r ? c.delegateType : c.bindType) || p;
                // Update special based on newly reset type
                                c = k.event.special[p] || {};
                // handleObj is passed to all event handlers
                                u = k.extend({
                    type: p,
                    origType: g,
                    data: i,
                    handler: n,
                    guid: n.guid,
                    selector: r,
                    needsContext: r && k.expr.match.needsContext.test(r),
                    namespace: h.join(".")
                }, o);
                // Init the event handler queue if we're the first
                                if (!(d = l[p])) {
                    d = l[p] = [];
                    d.delegateCount = 0;
                    // Only use addEventListener if the special events handler returns false
                                        if (!c.setup || c.setup.call(t, i, h, a) === false) {
                        if (t.addEventListener) {
                            t.addEventListener(p, a);
                        }
                    }
                }
                if (c.add) {
                    c.add.call(t, u);
                    if (!u.handler.guid) {
                        u.handler.guid = n.guid;
                    }
                }
                // Add to the element's handler list, delegates in front
                                if (r) {
                    d.splice(d.delegateCount++, 0, u);
                } else {
                    d.push(u);
                }
                // Keep track of which events have ever been used, for event optimization
                                k.event.global[p] = true;
            }
        },
        // Detach an event or set of events from an element
        remove: function(e, t, n, i, r) {
            var o, a, s, l, f, u, c, d, p, h, g, v = K.hasData(e) && K.get(e);
            if (!v || !(l = v.events)) {
                return;
            }
            // Once for each type.namespace in types; type may be omitted
                        t = (t || "").match(H) || [ "" ];
            f = t.length;
            while (f--) {
                s = De.exec(t[f]) || [];
                p = g = s[1];
                h = (s[2] || "").split(".").sort();
                // Unbind all events (on this namespace, if provided) for the element
                                if (!p) {
                    for (p in l) {
                        k.event.remove(e, p + t[f], n, i, true);
                    }
                    continue;
                }
                c = k.event.special[p] || {};
                p = (i ? c.delegateType : c.bindType) || p;
                d = l[p] || [];
                s = s[2] && new RegExp("(^|\\.)" + h.join("\\.(?:.*\\.|)") + "(\\.|$)");
                // Remove matching events
                                a = o = d.length;
                while (o--) {
                    u = d[o];
                    if ((r || g === u.origType) && (!n || n.guid === u.guid) && (!s || s.test(u.namespace)) && (!i || i === u.selector || i === "**" && u.selector)) {
                        d.splice(o, 1);
                        if (u.selector) {
                            d.delegateCount--;
                        }
                        if (c.remove) {
                            c.remove.call(e, u);
                        }
                    }
                }
                // Remove generic event handler if we removed something and no more handlers exist
                // (avoids potential for endless recursion during removal of special event handlers)
                                if (a && !d.length) {
                    if (!c.teardown || c.teardown.call(e, h, v.handle) === false) {
                        k.removeEvent(e, p, v.handle);
                    }
                    delete l[p];
                }
            }
            // Remove data and the expando if it's no longer used
                        if (k.isEmptyObject(l)) {
                K.remove(e, "handle events");
            }
        },
        dispatch: function(e) {
            // Make a writable jQuery.Event from the native event object
            var t = k.event.fix(e);
            var n, i, r, o, a, s, l = new Array(arguments.length), f = (K.get(this, "events") || {})[t.type] || [], u = k.event.special[t.type] || {};
            // Use the fix-ed jQuery.Event rather than the (read-only) native event
                        l[0] = t;
            for (n = 1; n < arguments.length; n++) {
                l[n] = arguments[n];
            }
            t.delegateTarget = this;
            // Call the preDispatch hook for the mapped type, and let it bail if desired
                        if (u.preDispatch && u.preDispatch.call(this, t) === false) {
                return;
            }
            // Determine handlers
                        s = k.event.handlers.call(this, t, f);
            // Run delegates first; they may want to stop propagation beneath us
                        n = 0;
            while ((o = s[n++]) && !t.isPropagationStopped()) {
                t.currentTarget = o.elem;
                i = 0;
                while ((a = o.handlers[i++]) && !t.isImmediatePropagationStopped()) {
                    // Triggered event must either 1) have no namespace, or 2) have namespace(s)
                    // a subset or equal to those in the bound event (both can have no namespace).
                    if (!t.rnamespace || t.rnamespace.test(a.namespace)) {
                        t.handleObj = a;
                        t.data = a.data;
                        r = ((k.event.special[a.origType] || {}).handle || a.handler).apply(o.elem, l);
                        if (r !== undefined) {
                            if ((t.result = r) === false) {
                                t.preventDefault();
                                t.stopPropagation();
                            }
                        }
                    }
                }
            }
            // Call the postDispatch hook for the mapped type
                        if (u.postDispatch) {
                u.postDispatch.call(this, t);
            }
            return t.result;
        },
        handlers: function(e, t) {
            var n, i, r, o, a, s = [], l = t.delegateCount, f = e.target;
            // Find delegate handlers
                        if (l && 
            // Support: IE <=9
            // Black-hole SVG <use> instance trees (trac-13180)
            f.nodeType && 
            // Support: Firefox <=42
            // Suppress spec-violating clicks indicating a non-primary pointer button (trac-3861)
            // https://www.w3.org/TR/DOM-Level-3-Events/#event-type-click
            // Support: IE 11 only
            // ...but not arrow key "clicks" of radio inputs, which can have `button` -1 (gh-2343)
            !(e.type === "click" && e.button >= 1)) {
                for (;f !== this; f = f.parentNode || this) {
                    // Don't check non-elements (#13208)
                    // Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)
                    if (f.nodeType === 1 && !(e.type === "click" && f.disabled === true)) {
                        o = [];
                        a = {};
                        for (n = 0; n < l; n++) {
                            i = t[n];
                            // Don't conflict with Object.prototype properties (#13203)
                                                        r = i.selector + " ";
                            if (a[r] === undefined) {
                                a[r] = i.needsContext ? k(r, this).index(f) > -1 : k.find(r, this, null, [ f ]).length;
                            }
                            if (a[r]) {
                                o.push(i);
                            }
                        }
                        if (o.length) {
                            s.push({
                                elem: f,
                                handlers: o
                            });
                        }
                    }
                }
            }
            // Add the remaining (directly-bound) handlers
                        f = this;
            if (l < t.length) {
                s.push({
                    elem: f,
                    handlers: t.slice(l)
                });
            }
            return s;
        },
        addProp: function(t, e) {
            Object.defineProperty(k.Event.prototype, t, {
                enumerable: true,
                configurable: true,
                get: y(e) ? function() {
                    if (this.originalEvent) {
                        return e(this.originalEvent);
                    }
                } : function() {
                    if (this.originalEvent) {
                        return this.originalEvent[t];
                    }
                },
                set: function(e) {
                    Object.defineProperty(this, t, {
                        enumerable: true,
                        configurable: true,
                        writable: true,
                        value: e
                    });
                }
            });
        },
        fix: function(e) {
            return e[k.expando] ? e : new k.Event(e);
        },
        special: {
            load: {
                // Prevent triggered image.load events from bubbling to window.load
                noBubble: true
            },
            focus: {
                // Fire native event if possible so blur/focus sequence is correct
                trigger: function() {
                    if (this !== Ee() && this.focus) {
                        this.focus();
                        return false;
                    }
                },
                delegateType: "focusin"
            },
            blur: {
                trigger: function() {
                    if (this === Ee() && this.blur) {
                        this.blur();
                        return false;
                    }
                },
                delegateType: "focusout"
            },
            click: {
                // For checkbox, fire native event so checked state will be right
                trigger: function() {
                    if (this.type === "checkbox" && this.click && $(this, "input")) {
                        this.click();
                        return false;
                    }
                },
                // For cross-browser consistency, don't fire native .click() on links
                _default: function(e) {
                    return $(e.target, "a");
                }
            },
            beforeunload: {
                postDispatch: function(e) {
                    // Support: Firefox 20+
                    // Firefox doesn't alert if the returnValue field is not set.
                    if (e.result !== undefined && e.originalEvent) {
                        e.originalEvent.returnValue = e.result;
                    }
                }
            }
        }
    };
    k.removeEvent = function(e, t, n) {
        // This "if" is needed for plain objects
        if (e.removeEventListener) {
            e.removeEventListener(t, n);
        }
    };
    k.Event = function(e, t) {
        // Allow instantiation without the 'new' keyword
        if (!(this instanceof k.Event)) {
            return new k.Event(e, t);
        }
        // Event object
                if (e && e.type) {
            this.originalEvent = e;
            this.type = e.type;
            // Events bubbling up the document may have been marked as prevented
            // by a handler lower down the tree; reflect the correct value.
                        this.isDefaultPrevented = e.defaultPrevented || e.defaultPrevented === undefined && 
            // Support: Android <=2.3 only
            e.returnValue === false ? ke : Se;
            // Create target properties
            // Support: Safari <=6 - 7 only
            // Target should not be a text node (#504, #13143)
                        this.target = e.target && e.target.nodeType === 3 ? e.target.parentNode : e.target;
            this.currentTarget = e.currentTarget;
            this.relatedTarget = e.relatedTarget;
            // Event type
                } else {
            this.type = e;
        }
        // Put explicitly provided properties onto the event object
                if (t) {
            k.extend(this, t);
        }
        // Create a timestamp if incoming event doesn't have one
                this.timeStamp = e && e.timeStamp || Date.now();
        // Mark it as fixed
                this[k.expando] = true;
    };
    // jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
    // https://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
        k.Event.prototype = {
        constructor: k.Event,
        isDefaultPrevented: Se,
        isPropagationStopped: Se,
        isImmediatePropagationStopped: Se,
        isSimulated: false,
        preventDefault: function() {
            var e = this.originalEvent;
            this.isDefaultPrevented = ke;
            if (e && !this.isSimulated) {
                e.preventDefault();
            }
        },
        stopPropagation: function() {
            var e = this.originalEvent;
            this.isPropagationStopped = ke;
            if (e && !this.isSimulated) {
                e.stopPropagation();
            }
        },
        stopImmediatePropagation: function() {
            var e = this.originalEvent;
            this.isImmediatePropagationStopped = ke;
            if (e && !this.isSimulated) {
                e.stopImmediatePropagation();
            }
            this.stopPropagation();
        }
    };
    // Includes all common event props including KeyEvent and MouseEvent specific props
        k.each({
        altKey: true,
        bubbles: true,
        cancelable: true,
        changedTouches: true,
        ctrlKey: true,
        detail: true,
        eventPhase: true,
        metaKey: true,
        pageX: true,
        pageY: true,
        shiftKey: true,
        view: true,
        char: true,
        charCode: true,
        key: true,
        keyCode: true,
        button: true,
        buttons: true,
        clientX: true,
        clientY: true,
        offsetX: true,
        offsetY: true,
        pointerId: true,
        pointerType: true,
        screenX: true,
        screenY: true,
        targetTouches: true,
        toElement: true,
        touches: true,
        which: function(e) {
            var t = e.button;
            // Add which for key events
                        if (e.which == null && Ce.test(e.type)) {
                return e.charCode != null ? e.charCode : e.keyCode;
            }
            // Add which for click: 1 === left; 2 === middle; 3 === right
                        if (!e.which && t !== undefined && Te.test(e.type)) {
                if (t & 1) {
                    return 1;
                }
                if (t & 2) {
                    return 3;
                }
                if (t & 4) {
                    return 2;
                }
                return 0;
            }
            return e.which;
        }
    }, k.event.addProp);
    // Create mouseenter/leave events using mouseover/out and event-time checks
    // so that event delegation works in jQuery.
    // Do the same for pointerenter/pointerleave and pointerover/pointerout
    //
    // Support: Safari 7 only
    // Safari sends mouseenter too often; see:
    // https://bugs.chromium.org/p/chromium/issues/detail?id=470258
    // for the description of the bug (it existed in older Chrome versions as well).
        k.each({
        mouseenter: "mouseover",
        mouseleave: "mouseout",
        pointerenter: "pointerover",
        pointerleave: "pointerout"
    }, function(e, o) {
        k.event.special[e] = {
            delegateType: o,
            bindType: o,
            handle: function(e) {
                var t, n = this, i = e.relatedTarget, r = e.handleObj;
                // For mouseenter/leave call the handler if related is outside the target.
                // NB: No relatedTarget if the mouse left/entered the browser window
                                if (!i || i !== n && !k.contains(n, i)) {
                    e.type = r.origType;
                    t = r.handler.apply(this, arguments);
                    e.type = o;
                }
                return t;
            }
        };
    });
    k.fn.extend({
        on: function(e, t, n, i) {
            return $e(this, e, t, n, i);
        },
        one: function(e, t, n, i) {
            return $e(this, e, t, n, i, 1);
        },
        off: function(e, t, n) {
            var i, r;
            if (e && e.preventDefault && e.handleObj) {
                // ( event )  dispatched jQuery.Event
                i = e.handleObj;
                k(e.delegateTarget).off(i.namespace ? i.origType + "." + i.namespace : i.origType, i.selector, i.handler);
                return this;
            }
            if (typeof e === "object") {
                // ( types-object [, selector] )
                for (r in e) {
                    this.off(r, t, e[r]);
                }
                return this;
            }
            if (t === false || typeof t === "function") {
                // ( types [, fn] )
                n = t;
                t = undefined;
            }
            if (n === false) {
                n = Se;
            }
            return this.each(function() {
                k.event.remove(this, e, n, t);
            });
        }
    });
    var 
    /* eslint-disable max-len */
    // See https://github.com/eslint/eslint/issues/3229
    Ae = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi, 
    /* eslint-enable */
    // Support: IE <=10 - 11, Edge 12 - 13 only
    // In IE/Edge using regex groups here causes severe slowdowns.
    // See https://connect.microsoft.com/IE/feedback/details/1736512/
    Ne = /<script|<style|<link/i, 
    // checked="checked" or checked
    je = /checked\s*(?:[^=]|=\s*.checked.)/i, Le = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;
    // Prefer a tbody over its parent table for containing new rows
        function Ie(e, t) {
        if ($(e, "table") && $(t.nodeType !== 11 ? t : t.firstChild, "tr")) {
            return k(e).children("tbody")[0] || e;
        }
        return e;
    }
    // Replace/restore the type attribute of script elements for safe DOM manipulation
        function Pe(e) {
        e.type = (e.getAttribute("type") !== null) + "/" + e.type;
        return e;
    }
    function Oe(e) {
        if ((e.type || "").slice(0, 5) === "true/") {
            e.type = e.type.slice(5);
        } else {
            e.removeAttribute("type");
        }
        return e;
    }
    function Re(e, t) {
        var n, i, r, o, a, s, l, f;
        if (t.nodeType !== 1) {
            return;
        }
        // 1. Copy private data: events, handlers, etc.
                if (K.hasData(e)) {
            o = K.access(e);
            a = K.set(t, o);
            f = o.events;
            if (f) {
                delete a.handle;
                a.events = {};
                for (r in f) {
                    for (n = 0, i = f[r].length; n < i; n++) {
                        k.event.add(t, r, f[r][n]);
                    }
                }
            }
        }
        // 2. Copy user data
                if (Z.hasData(e)) {
            s = Z.access(e);
            l = k.extend({}, s);
            Z.set(t, l);
        }
    }
    // Fix IE bugs, see support tests
        function He(e, t) {
        var n = t.nodeName.toLowerCase();
        // Fails to persist the checked state of a cloned checkbox or radio button.
                if (n === "input" && pe.test(e.type)) {
            t.checked = e.checked;
            // Fails to return the selected option to the default selected state when cloning options
                } else if (n === "input" || n === "textarea") {
            t.defaultValue = e.defaultValue;
        }
    }
    function qe(n, i, r, o) {
        // Flatten any nested arrays
        i = g.apply([], i);
        var e, t, a, s, l, f, u = 0, c = n.length, d = c - 1, p = i[0], h = y(p);
        // We can't cloneNode fragments that contain checked, in WebKit
                if (h || c > 1 && typeof p === "string" && !m.checkClone && je.test(p)) {
            return n.each(function(e) {
                var t = n.eq(e);
                if (h) {
                    i[0] = p.call(this, e, t.html());
                }
                qe(t, i, r, o);
            });
        }
        if (c) {
            e = we(i, n[0].ownerDocument, false, n, o);
            t = e.firstChild;
            if (e.childNodes.length === 1) {
                e = t;
            }
            // Require either new content or an interest in ignored elements to invoke the callback
                        if (t || o) {
                a = k.map(me(e, "script"), Pe);
                s = a.length;
                // Use the original fragment for the last item
                // instead of the first because it can end up
                // being emptied incorrectly in certain situations (#8070).
                                for (;u < c; u++) {
                    l = e;
                    if (u !== d) {
                        l = k.clone(l, true, true);
                        // Keep references to cloned scripts for later restoration
                                                if (s) {
                            // Support: Android <=4.0 only, PhantomJS 1 only
                            // push.apply(_, arraylike) throws on ancient WebKit
                            k.merge(a, me(l, "script"));
                        }
                    }
                    r.call(n[u], l, u);
                }
                if (s) {
                    f = a[a.length - 1].ownerDocument;
                    // Reenable scripts
                                        k.map(a, Oe);
                    // Evaluate executable scripts on first document insertion
                                        for (u = 0; u < s; u++) {
                        l = a[u];
                        if (ge.test(l.type || "") && !K.access(l, "globalEval") && k.contains(f, l)) {
                            if (l.src && (l.type || "").toLowerCase() !== "module") {
                                // Optional AJAX dependency, but won't run scripts if not present
                                if (k._evalUrl) {
                                    k._evalUrl(l.src);
                                }
                            } else {
                                w(l.textContent.replace(Le, ""), f, l);
                            }
                        }
                    }
                }
            }
        }
        return n;
    }
    function Be(e, t, n) {
        var i, r = t ? k.filter(t, e) : e, o = 0;
        for (;(i = r[o]) != null; o++) {
            if (!n && i.nodeType === 1) {
                k.cleanData(me(i));
            }
            if (i.parentNode) {
                if (n && k.contains(i.ownerDocument, i)) {
                    ye(me(i, "script"));
                }
                i.parentNode.removeChild(i);
            }
        }
        return e;
    }
    k.extend({
        htmlPrefilter: function(e) {
            return e.replace(Ae, "<$1></$2>");
        },
        clone: function(e, t, n) {
            var i, r, o, a, s = e.cloneNode(true), l = k.contains(e.ownerDocument, e);
            // Fix IE cloning issues
                        if (!m.noCloneChecked && (e.nodeType === 1 || e.nodeType === 11) && !k.isXMLDoc(e)) {
                // We eschew Sizzle here for performance reasons: https://jsperf.com/getall-vs-sizzle/2
                a = me(s);
                o = me(e);
                for (i = 0, r = o.length; i < r; i++) {
                    He(o[i], a[i]);
                }
            }
            // Copy the events from the original to the clone
                        if (t) {
                if (n) {
                    o = o || me(e);
                    a = a || me(s);
                    for (i = 0, r = o.length; i < r; i++) {
                        Re(o[i], a[i]);
                    }
                } else {
                    Re(e, s);
                }
            }
            // Preserve script evaluation history
                        a = me(s, "script");
            if (a.length > 0) {
                ye(a, !l && me(e, "script"));
            }
            // Return the cloned set
                        return s;
        },
        cleanData: function(e) {
            var t, n, i, r = k.event.special, o = 0;
            for (;(n = e[o]) !== undefined; o++) {
                if (Y(n)) {
                    if (t = n[K.expando]) {
                        if (t.events) {
                            for (i in t.events) {
                                if (r[i]) {
                                    k.event.remove(n, i);
                                    // This is a shortcut to avoid jQuery.event.remove's overhead
                                                                } else {
                                    k.removeEvent(n, i, t.handle);
                                }
                            }
                        }
                        // Support: Chrome <=35 - 45+
                        // Assign undefined instead of using delete, see Data#remove
                                                n[K.expando] = undefined;
                    }
                    if (n[Z.expando]) {
                        // Support: Chrome <=35 - 45+
                        // Assign undefined instead of using delete, see Data#remove
                        n[Z.expando] = undefined;
                    }
                }
            }
        }
    });
    k.fn.extend({
        detach: function(e) {
            return Be(this, e, true);
        },
        remove: function(e) {
            return Be(this, e);
        },
        text: function(e) {
            return z(this, function(e) {
                return e === undefined ? k.text(this) : this.empty().each(function() {
                    if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
                        this.textContent = e;
                    }
                });
            }, null, e, arguments.length);
        },
        append: function() {
            return qe(this, arguments, function(e) {
                if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
                    var t = Ie(this, e);
                    t.appendChild(e);
                }
            });
        },
        prepend: function() {
            return qe(this, arguments, function(e) {
                if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
                    var t = Ie(this, e);
                    t.insertBefore(e, t.firstChild);
                }
            });
        },
        before: function() {
            return qe(this, arguments, function(e) {
                if (this.parentNode) {
                    this.parentNode.insertBefore(e, this);
                }
            });
        },
        after: function() {
            return qe(this, arguments, function(e) {
                if (this.parentNode) {
                    this.parentNode.insertBefore(e, this.nextSibling);
                }
            });
        },
        empty: function() {
            var e, t = 0;
            for (;(e = this[t]) != null; t++) {
                if (e.nodeType === 1) {
                    // Prevent memory leaks
                    k.cleanData(me(e, false));
                    // Remove any remaining nodes
                                        e.textContent = "";
                }
            }
            return this;
        },
        clone: function(e, t) {
            e = e == null ? false : e;
            t = t == null ? e : t;
            return this.map(function() {
                return k.clone(this, e, t);
            });
        },
        html: function(e) {
            return z(this, function(e) {
                var t = this[0] || {}, n = 0, i = this.length;
                if (e === undefined && t.nodeType === 1) {
                    return t.innerHTML;
                }
                // See if we can take a shortcut and just use innerHTML
                                if (typeof e === "string" && !Ne.test(e) && !ve[(he.exec(e) || [ "", "" ])[1].toLowerCase()]) {
                    e = k.htmlPrefilter(e);
                    try {
                        for (;n < i; n++) {
                            t = this[n] || {};
                            // Remove element nodes and prevent memory leaks
                                                        if (t.nodeType === 1) {
                                k.cleanData(me(t, false));
                                t.innerHTML = e;
                            }
                        }
                        t = 0;
                        // If using innerHTML throws an exception, use the fallback method
                                        } catch (e) {}
                }
                if (t) {
                    this.empty().append(e);
                }
            }, null, e, arguments.length);
        },
        replaceWith: function() {
            var n = [];
            // Make the changes, replacing each non-ignored context element with the new content
                        return qe(this, arguments, function(e) {
                var t = this.parentNode;
                if (k.inArray(this, n) < 0) {
                    k.cleanData(me(this));
                    if (t) {
                        t.replaceChild(e, this);
                    }
                }
                // Force callback invocation
                        }, n);
        }
    });
    k.each({
        appendTo: "append",
        prependTo: "prepend",
        insertBefore: "before",
        insertAfter: "after",
        replaceAll: "replaceWith"
    }, function(e, a) {
        k.fn[e] = function(e) {
            var t, n = [], i = k(e), r = i.length - 1, o = 0;
            for (;o <= r; o++) {
                t = o === r ? this : this.clone(true);
                k(i[o])[a](t);
                // Support: Android <=4.0 only, PhantomJS 1 only
                // .get() because push.apply(_, arraylike) throws on ancient WebKit
                                l.apply(n, t.get());
            }
            return this.pushStack(n);
        };
    });
    var Me = new RegExp("^(" + re + ")(?!px)[a-z%]+$", "i");
    var _e = function(e) {
        // Support: IE <=11 only, Firefox <=30 (#15098, #14150)
        // IE throws on elements created in popups
        // FF meanwhile throws on frame elements through "defaultView.getComputedStyle"
        var t = e.ownerDocument.defaultView;
        if (!t || !t.opener) {
            t = T;
        }
        return t.getComputedStyle(e);
    };
    var Fe = new RegExp(ae.join("|"), "i");
    (function() {
        // Executing both pixelPosition & boxSizingReliable tests require only one layout
        // so they're executed at the same time to save the second computation.
        function e() {
            // This is a singleton, we need to execute it only once
            if (!l) {
                return;
            }
            s.style.cssText = "position:absolute;left:-11111px;width:60px;" + "margin-top:1px;padding:0;border:0";
            l.style.cssText = "position:relative;display:block;box-sizing:border-box;overflow:scroll;" + "margin:auto;border:1px;padding:1px;" + "width:60%;top:1%";
            xe.appendChild(s).appendChild(l);
            var e = T.getComputedStyle(l);
            n = e.top !== "1%";
            // Support: Android 4.0 - 4.3 only, Firefox <=3 - 44
                        a = t(e.marginLeft) === 12;
            // Support: Android 4.0 - 4.3 only, Safari <=9.1 - 10.1, iOS <=7.0 - 9.3
            // Some styles come back with percentage values, even though they shouldn't
                        l.style.right = "60%";
            o = t(e.right) === 36;
            // Support: IE 9 - 11 only
            // Detect misreporting of content dimensions for box-sizing:border-box elements
                        i = t(e.width) === 36;
            // Support: IE 9 only
            // Detect overflow:scroll screwiness (gh-3699)
                        l.style.position = "absolute";
            r = l.offsetWidth === 36 || "absolute";
            xe.removeChild(s);
            // Nullify the div so it wouldn't be stored in the memory and
            // it will also be a sign that checks already performed
                        l = null;
        }
        function t(e) {
            return Math.round(parseFloat(e));
        }
        var n, i, r, o, a, s = D.createElement("div"), l = D.createElement("div");
        // Finish early in limited (non-browser) environments
                if (!l.style) {
            return;
        }
        // Support: IE <=9 - 11 only
        // Style of cloned element affects source element cloned (#8908)
                l.style.backgroundClip = "content-box";
        l.cloneNode(true).style.backgroundClip = "";
        m.clearCloneStyle = l.style.backgroundClip === "content-box";
        k.extend(m, {
            boxSizingReliable: function() {
                e();
                return i;
            },
            pixelBoxStyles: function() {
                e();
                return o;
            },
            pixelPosition: function() {
                e();
                return n;
            },
            reliableMarginLeft: function() {
                e();
                return a;
            },
            scrollboxSize: function() {
                e();
                return r;
            }
        });
    })();
    function Ue(e, t, n) {
        var i, r, o, a, 
        // Support: Firefox 51+
        // Retrieving style before computed somehow
        // fixes an issue with getting wrong values
        // on detached elements
        s = e.style;
        n = n || _e(e);
        // getPropertyValue is needed for:
        //   .css('filter') (IE 9 only, #12537)
        //   .css('--customProperty) (#3144)
                if (n) {
            a = n.getPropertyValue(t) || n[t];
            if (a === "" && !k.contains(e.ownerDocument, e)) {
                a = k.style(e, t);
            }
            // A tribute to the "awesome hack by Dean Edwards"
            // Android Browser returns percentage for some values,
            // but width seems to be reliably pixels.
            // This is against the CSSOM draft spec:
            // https://drafts.csswg.org/cssom/#resolved-values
                        if (!m.pixelBoxStyles() && Me.test(a) && Fe.test(t)) {
                // Remember the original values
                i = s.width;
                r = s.minWidth;
                o = s.maxWidth;
                // Put in the new values to get a computed value out
                                s.minWidth = s.maxWidth = s.width = a;
                a = n.width;
                // Revert the changed values
                                s.width = i;
                s.minWidth = r;
                s.maxWidth = o;
            }
        }
        return a !== undefined ? 
        // Support: IE <=9 - 11 only
        // IE returns zIndex value as an integer.
        a + "" : a;
    }
    function We(e, t) {
        // Define the hook, we'll check on the first run if it's really needed.
        return {
            get: function() {
                if (e()) {
                    // Hook not needed (or it's not possible to use it due
                    // to missing dependency), remove it.
                    delete this.get;
                    return;
                }
                // Hook needed; redefine it so that the support test is not executed again.
                                return (this.get = t).apply(this, arguments);
            }
        };
    }
    var 
    // Swappable if display is none or starts with table
    // except "table", "table-cell", or "table-caption"
    // See here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
    ze = /^(none|table(?!-c[ea]).+)/, Ge = /^--/, Qe = {
        position: "absolute",
        visibility: "hidden",
        display: "block"
    }, Ve = {
        letterSpacing: "0",
        fontWeight: "400"
    }, Xe = [ "Webkit", "Moz", "ms" ], Ye = D.createElement("div").style;
    // Return a css property mapped to a potentially vendor prefixed property
        function Je(e) {
        // Shortcut for names that are not vendor prefixed
        if (e in Ye) {
            return e;
        }
        // Check for vendor prefixed names
                var t = e[0].toUpperCase() + e.slice(1), n = Xe.length;
        while (n--) {
            e = Xe[n] + t;
            if (e in Ye) {
                return e;
            }
        }
    }
    // Return a property mapped along what jQuery.cssProps suggests or to
    // a vendor prefixed property.
        function Ke(e) {
        var t = k.cssProps[e];
        if (!t) {
            t = k.cssProps[e] = Je(e) || e;
        }
        return t;
    }
    function Ze(e, t, n) {
        // Any relative (+/-) values have already been
        // normalized at this point
        var i = oe.exec(t);
        return i ? 
        // Guard against undefined "subtract", e.g., when used as in cssHooks
        Math.max(0, i[2] - (n || 0)) + (i[3] || "px") : t;
    }
    function et(e, t, n, i, r, o) {
        var a = t === "width" ? 1 : 0, s = 0, l = 0;
        // Adjustment may not be necessary
                if (n === (i ? "border" : "content")) {
            return 0;
        }
        for (;a < 4; a += 2) {
            // Both box models exclude margin
            if (n === "margin") {
                l += k.css(e, n + ae[a], true, r);
            }
            // If we get here with a content-box, we're seeking "padding" or "border" or "margin"
                        if (!i) {
                // Add padding
                l += k.css(e, "padding" + ae[a], true, r);
                // For "border" or "margin", add border
                                if (n !== "padding") {
                    l += k.css(e, "border" + ae[a] + "Width", true, r);
                    // But still keep track of it otherwise
                                } else {
                    s += k.css(e, "border" + ae[a] + "Width", true, r);
                }
                // If we get here with a border-box (content + padding + border), we're seeking "content" or
                // "padding" or "margin"
                        } else {
                // For "content", subtract padding
                if (n === "content") {
                    l -= k.css(e, "padding" + ae[a], true, r);
                }
                // For "content" or "padding", subtract border
                                if (n !== "margin") {
                    l -= k.css(e, "border" + ae[a] + "Width", true, r);
                }
            }
        }
        // Account for positive content-box scroll gutter when requested by providing computedVal
                if (!i && o >= 0) {
            // offsetWidth/offsetHeight is a rounded sum of content, padding, scroll gutter, and border
            // Assuming integer scroll gutter, subtract the rest and round down
            l += Math.max(0, Math.ceil(e["offset" + t[0].toUpperCase() + t.slice(1)] - o - l - s - .5));
        }
        return l;
    }
    function tt(e, t, n) {
        // Start with computed style
        var i = _e(e), r = Ue(e, t, i), o = k.css(e, "boxSizing", false, i) === "border-box", a = o;
        // Support: Firefox <=54
        // Return a confounding non-pixel value or feign ignorance, as appropriate.
                if (Me.test(r)) {
            if (!n) {
                return r;
            }
            r = "auto";
        }
        // Check for style in case a browser which returns unreliable values
        // for getComputedStyle silently falls back to the reliable elem.style
                a = a && (m.boxSizingReliable() || r === e.style[t]);
        // Fall back to offsetWidth/offsetHeight when value is "auto"
        // This happens for inline elements with no explicit setting (gh-3571)
        // Support: Android <=4.1 - 4.3 only
        // Also use offsetWidth/offsetHeight for misreported inline dimensions (gh-3602)
                if (r === "auto" || !parseFloat(r) && k.css(e, "display", false, i) === "inline") {
            r = e["offset" + t[0].toUpperCase() + t.slice(1)];
            // offsetWidth/offsetHeight provide border-box values
                        a = true;
        }
        // Normalize "" and auto
                r = parseFloat(r) || 0;
        // Adjust for the element's box model
                return r + et(e, t, n || (o ? "border" : "content"), a, i, 
        // Provide the current computed size to request scroll gutter calculation (gh-3589)
        r) + "px";
    }
    k.extend({
        // Add in style property hooks for overriding the default
        // behavior of getting and setting a style property
        cssHooks: {
            opacity: {
                get: function(e, t) {
                    if (t) {
                        // We should always get a number back from opacity
                        var n = Ue(e, "opacity");
                        return n === "" ? "1" : n;
                    }
                }
            }
        },
        // Don't automatically add "px" to these possibly-unitless properties
        cssNumber: {
            animationIterationCount: true,
            columnCount: true,
            fillOpacity: true,
            flexGrow: true,
            flexShrink: true,
            fontWeight: true,
            lineHeight: true,
            opacity: true,
            order: true,
            orphans: true,
            widows: true,
            zIndex: true,
            zoom: true
        },
        // Add in properties whose names you wish to fix before
        // setting or getting the value
        cssProps: {},
        // Get and set the style property on a DOM Node
        style: function(e, t, n, i) {
            // Don't set styles on text and comment nodes
            if (!e || e.nodeType === 3 || e.nodeType === 8 || !e.style) {
                return;
            }
            // Make sure that we're working with the right name
                        var r, o, a, s = X(t), l = Ge.test(t), f = e.style;
            // Make sure that we're working with the right name. We don't
            // want to query the value if it is a CSS custom property
            // since they are user-defined.
                        if (!l) {
                t = Ke(s);
            }
            // Gets hook for the prefixed version, then unprefixed version
                        a = k.cssHooks[t] || k.cssHooks[s];
            // Check if we're setting a value
                        if (n !== undefined) {
                o = typeof n;
                // Convert "+=" or "-=" to relative numbers (#7345)
                                if (o === "string" && (r = oe.exec(n)) && r[1]) {
                    n = fe(e, t, r);
                    // Fixes bug #9237
                                        o = "number";
                }
                // Make sure that null and NaN values aren't set (#7116)
                                if (n == null || n !== n) {
                    return;
                }
                // If a number was passed in, add the unit (except for certain CSS properties)
                                if (o === "number") {
                    n += r && r[3] || (k.cssNumber[s] ? "" : "px");
                }
                // background-* props affect original clone's values
                                if (!m.clearCloneStyle && n === "" && t.indexOf("background") === 0) {
                    f[t] = "inherit";
                }
                // If a hook was provided, use that value, otherwise just set the specified value
                                if (!a || !("set" in a) || (n = a.set(e, n, i)) !== undefined) {
                    if (l) {
                        f.setProperty(t, n);
                    } else {
                        f[t] = n;
                    }
                }
            } else {
                // If a hook was provided get the non-computed value from there
                if (a && "get" in a && (r = a.get(e, false, i)) !== undefined) {
                    return r;
                }
                // Otherwise just get the value from the style object
                                return f[t];
            }
        },
        css: function(e, t, n, i) {
            var r, o, a, s = X(t), l = Ge.test(t);
            // Make sure that we're working with the right name. We don't
            // want to modify the value if it is a CSS custom property
            // since they are user-defined.
                        if (!l) {
                t = Ke(s);
            }
            // Try prefixed name followed by the unprefixed name
                        a = k.cssHooks[t] || k.cssHooks[s];
            // If a hook was provided get the computed value from there
                        if (a && "get" in a) {
                r = a.get(e, true, n);
            }
            // Otherwise, if a way to get the computed value exists, use that
                        if (r === undefined) {
                r = Ue(e, t, i);
            }
            // Convert "normal" to computed value
                        if (r === "normal" && t in Ve) {
                r = Ve[t];
            }
            // Make numeric if forced or a qualifier was provided and val looks numeric
                        if (n === "" || n) {
                o = parseFloat(r);
                return n === true || isFinite(o) ? o || 0 : r;
            }
            return r;
        }
    });
    k.each([ "height", "width" ], function(e, s) {
        k.cssHooks[s] = {
            get: function(e, t, n) {
                if (t) {
                    // Certain elements can have dimension info if we invisibly show them
                    // but it must have a current display style that would benefit
                    return ze.test(k.css(e, "display")) && (
                    // Support: Safari 8+
                    // Table columns in Safari have non-zero offsetWidth & zero
                    // getBoundingClientRect().width unless display is changed.
                    // Support: IE <=11 only
                    // Running getBoundingClientRect on a disconnected node
                    // in IE throws an error.
                    !e.getClientRects().length || !e.getBoundingClientRect().width) ? le(e, Qe, function() {
                        return tt(e, s, n);
                    }) : tt(e, s, n);
                }
            },
            set: function(e, t, n) {
                var i, r = _e(e), o = k.css(e, "boxSizing", false, r) === "border-box", a = n && et(e, s, n, o, r);
                // Account for unreliable border-box dimensions by comparing offset* to computed and
                // faking a content-box to get border and padding (gh-3699)
                                if (o && m.scrollboxSize() === r.position) {
                    a -= Math.ceil(e["offset" + s[0].toUpperCase() + s.slice(1)] - parseFloat(r[s]) - et(e, s, "border", false, r) - .5);
                }
                // Convert to pixels if value adjustment is needed
                                if (a && (i = oe.exec(t)) && (i[3] || "px") !== "px") {
                    e.style[s] = t;
                    t = k.css(e, s);
                }
                return Ze(e, t, a);
            }
        };
    });
    k.cssHooks.marginLeft = We(m.reliableMarginLeft, function(e, t) {
        if (t) {
            return (parseFloat(Ue(e, "marginLeft")) || e.getBoundingClientRect().left - le(e, {
                marginLeft: 0
            }, function() {
                return e.getBoundingClientRect().left;
            })) + "px";
        }
    });
    // These hooks are used by animate to expand properties
        k.each({
        margin: "",
        padding: "",
        border: "Width"
    }, function(r, o) {
        k.cssHooks[r + o] = {
            expand: function(e) {
                var t = 0, n = {}, 
                // Assumes a single number if not a string
                i = typeof e === "string" ? e.split(" ") : [ e ];
                for (;t < 4; t++) {
                    n[r + ae[t] + o] = i[t] || i[t - 2] || i[0];
                }
                return n;
            }
        };
        if (r !== "margin") {
            k.cssHooks[r + o].set = Ze;
        }
    });
    k.fn.extend({
        css: function(e, t) {
            return z(this, function(e, t, n) {
                var i, r, o = {}, a = 0;
                if (Array.isArray(t)) {
                    i = _e(e);
                    r = t.length;
                    for (;a < r; a++) {
                        o[t[a]] = k.css(e, t[a], false, i);
                    }
                    return o;
                }
                return n !== undefined ? k.style(e, t, n) : k.css(e, t);
            }, e, t, arguments.length > 1);
        }
    });
    function nt(e, t, n, i, r) {
        return new nt.prototype.init(e, t, n, i, r);
    }
    k.Tween = nt;
    nt.prototype = {
        constructor: nt,
        init: function(e, t, n, i, r, o) {
            this.elem = e;
            this.prop = n;
            this.easing = r || k.easing._default;
            this.options = t;
            this.start = this.now = this.cur();
            this.end = i;
            this.unit = o || (k.cssNumber[n] ? "" : "px");
        },
        cur: function() {
            var e = nt.propHooks[this.prop];
            return e && e.get ? e.get(this) : nt.propHooks._default.get(this);
        },
        run: function(e) {
            var t, n = nt.propHooks[this.prop];
            if (this.options.duration) {
                this.pos = t = k.easing[this.easing](e, this.options.duration * e, 0, 1, this.options.duration);
            } else {
                this.pos = t = e;
            }
            this.now = (this.end - this.start) * t + this.start;
            if (this.options.step) {
                this.options.step.call(this.elem, this.now, this);
            }
            if (n && n.set) {
                n.set(this);
            } else {
                nt.propHooks._default.set(this);
            }
            return this;
        }
    };
    nt.prototype.init.prototype = nt.prototype;
    nt.propHooks = {
        _default: {
            get: function(e) {
                var t;
                // Use a property on the element directly when it is not a DOM element,
                // or when there is no matching style property that exists.
                                if (e.elem.nodeType !== 1 || e.elem[e.prop] != null && e.elem.style[e.prop] == null) {
                    return e.elem[e.prop];
                }
                // Passing an empty string as a 3rd parameter to .css will automatically
                // attempt a parseFloat and fallback to a string if the parse fails.
                // Simple values such as "10px" are parsed to Float;
                // complex values such as "rotate(1rad)" are returned as-is.
                                t = k.css(e.elem, e.prop, "");
                // Empty strings, null, undefined and "auto" are converted to 0.
                                return !t || t === "auto" ? 0 : t;
            },
            set: function(e) {
                // Use step hook for back compat.
                // Use cssHook if its there.
                // Use .style if available and use plain properties where available.
                if (k.fx.step[e.prop]) {
                    k.fx.step[e.prop](e);
                } else if (e.elem.nodeType === 1 && (e.elem.style[k.cssProps[e.prop]] != null || k.cssHooks[e.prop])) {
                    k.style(e.elem, e.prop, e.now + e.unit);
                } else {
                    e.elem[e.prop] = e.now;
                }
            }
        }
    };
    // Support: IE <=9 only
    // Panic based approach to setting things on disconnected nodes
        nt.propHooks.scrollTop = nt.propHooks.scrollLeft = {
        set: function(e) {
            if (e.elem.nodeType && e.elem.parentNode) {
                e.elem[e.prop] = e.now;
            }
        }
    };
    k.easing = {
        linear: function(e) {
            return e;
        },
        swing: function(e) {
            return .5 - Math.cos(e * Math.PI) / 2;
        },
        _default: "swing"
    };
    k.fx = nt.prototype.init;
    // Back compat <1.8 extension point
        k.fx.step = {};
    var it, rt, ot = /^(?:toggle|show|hide)$/, at = /queueHooks$/;
    function st() {
        if (rt) {
            if (D.hidden === false && T.requestAnimationFrame) {
                T.requestAnimationFrame(st);
            } else {
                T.setTimeout(st, k.fx.interval);
            }
            k.fx.tick();
        }
    }
    // Animations created synchronously will run synchronously
        function lt() {
        T.setTimeout(function() {
            it = undefined;
        });
        return it = Date.now();
    }
    // Generate parameters to create a standard animation
        function ft(e, t) {
        var n, i = 0, r = {
            height: e
        };
        // If we include width, step value is 1 to do all cssExpand values,
        // otherwise step value is 2 to skip over Left and Right
                t = t ? 1 : 0;
        for (;i < 4; i += 2 - t) {
            n = ae[i];
            r["margin" + n] = r["padding" + n] = e;
        }
        if (t) {
            r.opacity = r.width = e;
        }
        return r;
    }
    function ut(e, t, n) {
        var i, r = (pt.tweeners[t] || []).concat(pt.tweeners["*"]), o = 0, a = r.length;
        for (;o < a; o++) {
            if (i = r[o].call(n, t, e)) {
                // We're done with this property
                return i;
            }
        }
    }
    function ct(e, t, n) {
        var i, r, o, a, s, l, f, u, c = "width" in t || "height" in t, d = this, p = {}, h = e.style, g = e.nodeType && se(e), v = K.get(e, "fxshow");
        // Queue-skipping animations hijack the fx hooks
                if (!n.queue) {
            a = k._queueHooks(e, "fx");
            if (a.unqueued == null) {
                a.unqueued = 0;
                s = a.empty.fire;
                a.empty.fire = function() {
                    if (!a.unqueued) {
                        s();
                    }
                };
            }
            a.unqueued++;
            d.always(function() {
                // Ensure the complete handler is called before this completes
                d.always(function() {
                    a.unqueued--;
                    if (!k.queue(e, "fx").length) {
                        a.empty.fire();
                    }
                });
            });
        }
        // Detect show/hide animations
                for (i in t) {
            r = t[i];
            if (ot.test(r)) {
                delete t[i];
                o = o || r === "toggle";
                if (r === (g ? "hide" : "show")) {
                    // Pretend to be hidden if this is a "show" and
                    // there is still data from a stopped show/hide
                    if (r === "show" && v && v[i] !== undefined) {
                        g = true;
                        // Ignore all other no-op show/hide data
                                        } else {
                        continue;
                    }
                }
                p[i] = v && v[i] || k.style(e, i);
            }
        }
        // Bail out if this is a no-op like .hide().hide()
                l = !k.isEmptyObject(t);
        if (!l && k.isEmptyObject(p)) {
            return;
        }
        // Restrict "overflow" and "display" styles during box animations
                if (c && e.nodeType === 1) {
            // Support: IE <=9 - 11, Edge 12 - 15
            // Record all 3 overflow attributes because IE does not infer the shorthand
            // from identically-valued overflowX and overflowY and Edge just mirrors
            // the overflowX value there.
            n.overflow = [ h.overflow, h.overflowX, h.overflowY ];
            // Identify a display type, preferring old show/hide data over the CSS cascade
                        f = v && v.display;
            if (f == null) {
                f = K.get(e, "display");
            }
            u = k.css(e, "display");
            if (u === "none") {
                if (f) {
                    u = f;
                } else {
                    // Get nonempty value(s) by temporarily forcing visibility
                    de([ e ], true);
                    f = e.style.display || f;
                    u = k.css(e, "display");
                    de([ e ]);
                }
            }
            // Animate inline elements as inline-block
                        if (u === "inline" || u === "inline-block" && f != null) {
                if (k.css(e, "float") === "none") {
                    // Restore the original display value at the end of pure show/hide animations
                    if (!l) {
                        d.done(function() {
                            h.display = f;
                        });
                        if (f == null) {
                            u = h.display;
                            f = u === "none" ? "" : u;
                        }
                    }
                    h.display = "inline-block";
                }
            }
        }
        if (n.overflow) {
            h.overflow = "hidden";
            d.always(function() {
                h.overflow = n.overflow[0];
                h.overflowX = n.overflow[1];
                h.overflowY = n.overflow[2];
            });
        }
        // Implement show/hide animations
                l = false;
        for (i in p) {
            // General show/hide setup for this element animation
            if (!l) {
                if (v) {
                    if ("hidden" in v) {
                        g = v.hidden;
                    }
                } else {
                    v = K.access(e, "fxshow", {
                        display: f
                    });
                }
                // Store hidden/visible for toggle so `.stop().toggle()` "reverses"
                                if (o) {
                    v.hidden = !g;
                }
                // Show elements before animating them
                                if (g) {
                    de([ e ], true);
                }
                /* eslint-disable no-loop-func */                d.done(function() {
                    /* eslint-enable no-loop-func */
                    // The final step of a "hide" animation is actually hiding the element
                    if (!g) {
                        de([ e ]);
                    }
                    K.remove(e, "fxshow");
                    for (i in p) {
                        k.style(e, i, p[i]);
                    }
                });
            }
            // Per-property setup
                        l = ut(g ? v[i] : 0, i, d);
            if (!(i in v)) {
                v[i] = l.start;
                if (g) {
                    l.end = l.start;
                    l.start = 0;
                }
            }
        }
    }
    function dt(e, t) {
        var n, i, r, o, a;
        // camelCase, specialEasing and expand cssHook pass
                for (n in e) {
            i = X(n);
            r = t[i];
            o = e[n];
            if (Array.isArray(o)) {
                r = o[1];
                o = e[n] = o[0];
            }
            if (n !== i) {
                e[i] = o;
                delete e[n];
            }
            a = k.cssHooks[i];
            if (a && "expand" in a) {
                o = a.expand(o);
                delete e[i];
                // Not quite $.extend, this won't overwrite existing keys.
                // Reusing 'index' because we have the correct "name"
                                for (n in o) {
                    if (!(n in e)) {
                        e[n] = o[n];
                        t[n] = r;
                    }
                }
            } else {
                t[i] = r;
            }
        }
    }
    function pt(a, e, t) {
        var n, s, i = 0, r = pt.prefilters.length, l = k.Deferred().always(function() {
            // Don't match elem in the :animated selector
            delete o.elem;
        }), o = function() {
            if (s) {
                return false;
            }
            var e = it || lt(), t = Math.max(0, f.startTime + f.duration - e), 
            // Support: Android 2.3 only
            // Archaic crash bug won't allow us to use `1 - ( 0.5 || 0 )` (#12497)
            n = t / f.duration || 0, i = 1 - n, r = 0, o = f.tweens.length;
            for (;r < o; r++) {
                f.tweens[r].run(i);
            }
            l.notifyWith(a, [ f, i, t ]);
            // If there's more to do, yield
                        if (i < 1 && o) {
                return t;
            }
            // If this was an empty animation, synthesize a final progress notification
                        if (!o) {
                l.notifyWith(a, [ f, 1, 0 ]);
            }
            // Resolve the animation and report its conclusion
                        l.resolveWith(a, [ f ]);
            return false;
        }, f = l.promise({
            elem: a,
            props: k.extend({}, e),
            opts: k.extend(true, {
                specialEasing: {},
                easing: k.easing._default
            }, t),
            originalProperties: e,
            originalOptions: t,
            startTime: it || lt(),
            duration: t.duration,
            tweens: [],
            createTween: function(e, t) {
                var n = k.Tween(a, f.opts, e, t, f.opts.specialEasing[e] || f.opts.easing);
                f.tweens.push(n);
                return n;
            },
            stop: function(e) {
                var t = 0, 
                // If we are going to the end, we want to run all the tweens
                // otherwise we skip this part
                n = e ? f.tweens.length : 0;
                if (s) {
                    return this;
                }
                s = true;
                for (;t < n; t++) {
                    f.tweens[t].run(1);
                }
                // Resolve when we played the last frame; otherwise, reject
                                if (e) {
                    l.notifyWith(a, [ f, 1, 0 ]);
                    l.resolveWith(a, [ f, e ]);
                } else {
                    l.rejectWith(a, [ f, e ]);
                }
                return this;
            }
        }), u = f.props;
        dt(u, f.opts.specialEasing);
        for (;i < r; i++) {
            n = pt.prefilters[i].call(f, a, u, f.opts);
            if (n) {
                if (y(n.stop)) {
                    k._queueHooks(f.elem, f.opts.queue).stop = n.stop.bind(n);
                }
                return n;
            }
        }
        k.map(u, ut, f);
        if (y(f.opts.start)) {
            f.opts.start.call(a, f);
        }
        // Attach callbacks from options
                f.progress(f.opts.progress).done(f.opts.done, f.opts.complete).fail(f.opts.fail).always(f.opts.always);
        k.fx.timer(k.extend(o, {
            elem: a,
            anim: f,
            queue: f.opts.queue
        }));
        return f;
    }
    k.Animation = k.extend(pt, {
        tweeners: {
            "*": [ function(e, t) {
                var n = this.createTween(e, t);
                fe(n.elem, e, oe.exec(t), n);
                return n;
            } ]
        },
        tweener: function(e, t) {
            if (y(e)) {
                t = e;
                e = [ "*" ];
            } else {
                e = e.match(H);
            }
            var n, i = 0, r = e.length;
            for (;i < r; i++) {
                n = e[i];
                pt.tweeners[n] = pt.tweeners[n] || [];
                pt.tweeners[n].unshift(t);
            }
        },
        prefilters: [ ct ],
        prefilter: function(e, t) {
            if (t) {
                pt.prefilters.unshift(e);
            } else {
                pt.prefilters.push(e);
            }
        }
    });
    k.speed = function(e, t, n) {
        var i = e && typeof e === "object" ? k.extend({}, e) : {
            complete: n || !n && t || y(e) && e,
            duration: e,
            easing: n && t || t && !y(t) && t
        };
        // Go to the end state if fx are off
                if (k.fx.off) {
            i.duration = 0;
        } else {
            if (typeof i.duration !== "number") {
                if (i.duration in k.fx.speeds) {
                    i.duration = k.fx.speeds[i.duration];
                } else {
                    i.duration = k.fx.speeds._default;
                }
            }
        }
        // Normalize opt.queue - true/undefined/null -> "fx"
                if (i.queue == null || i.queue === true) {
            i.queue = "fx";
        }
        // Queueing
                i.old = i.complete;
        i.complete = function() {
            if (y(i.old)) {
                i.old.call(this);
            }
            if (i.queue) {
                k.dequeue(this, i.queue);
            }
        };
        return i;
    };
    k.fn.extend({
        fadeTo: function(e, t, n, i) {
            // Show any hidden elements after setting opacity to 0
            return this.filter(se).css("opacity", 0).show().end().animate({
                opacity: t
            }, e, n, i);
        },
        animate: function(t, e, n, i) {
            var r = k.isEmptyObject(t), o = k.speed(e, n, i), a = function() {
                // Operate on a copy of prop so per-property easing won't be lost
                var e = pt(this, k.extend({}, t), o);
                // Empty animations, or finishing resolves immediately
                                if (r || K.get(this, "finish")) {
                    e.stop(true);
                }
            };
            a.finish = a;
            return r || o.queue === false ? this.each(a) : this.queue(o.queue, a);
        },
        stop: function(r, e, o) {
            var a = function(e) {
                var t = e.stop;
                delete e.stop;
                t(o);
            };
            if (typeof r !== "string") {
                o = e;
                e = r;
                r = undefined;
            }
            if (e && r !== false) {
                this.queue(r || "fx", []);
            }
            return this.each(function() {
                var e = true, t = r != null && r + "queueHooks", n = k.timers, i = K.get(this);
                if (t) {
                    if (i[t] && i[t].stop) {
                        a(i[t]);
                    }
                } else {
                    for (t in i) {
                        if (i[t] && i[t].stop && at.test(t)) {
                            a(i[t]);
                        }
                    }
                }
                for (t = n.length; t--; ) {
                    if (n[t].elem === this && (r == null || n[t].queue === r)) {
                        n[t].anim.stop(o);
                        e = false;
                        n.splice(t, 1);
                    }
                }
                // Start the next in the queue if the last step wasn't forced.
                // Timers currently will call their complete callbacks, which
                // will dequeue but only if they were gotoEnd.
                                if (e || !o) {
                    k.dequeue(this, r);
                }
            });
        },
        finish: function(a) {
            if (a !== false) {
                a = a || "fx";
            }
            return this.each(function() {
                var e, t = K.get(this), n = t[a + "queue"], i = t[a + "queueHooks"], r = k.timers, o = n ? n.length : 0;
                // Enable finishing flag on private data
                                t.finish = true;
                // Empty the queue first
                                k.queue(this, a, []);
                if (i && i.stop) {
                    i.stop.call(this, true);
                }
                // Look for any active animations, and finish them
                                for (e = r.length; e--; ) {
                    if (r[e].elem === this && r[e].queue === a) {
                        r[e].anim.stop(true);
                        r.splice(e, 1);
                    }
                }
                // Look for any animations in the old queue and finish them
                                for (e = 0; e < o; e++) {
                    if (n[e] && n[e].finish) {
                        n[e].finish.call(this);
                    }
                }
                // Turn off finishing flag
                                delete t.finish;
            });
        }
    });
    k.each([ "toggle", "show", "hide" ], function(e, i) {
        var r = k.fn[i];
        k.fn[i] = function(e, t, n) {
            return e == null || typeof e === "boolean" ? r.apply(this, arguments) : this.animate(ft(i, true), e, t, n);
        };
    });
    // Generate shortcuts for custom animations
        k.each({
        slideDown: ft("show"),
        slideUp: ft("hide"),
        slideToggle: ft("toggle"),
        fadeIn: {
            opacity: "show"
        },
        fadeOut: {
            opacity: "hide"
        },
        fadeToggle: {
            opacity: "toggle"
        }
    }, function(e, i) {
        k.fn[e] = function(e, t, n) {
            return this.animate(i, e, t, n);
        };
    });
    k.timers = [];
    k.fx.tick = function() {
        var e, t = 0, n = k.timers;
        it = Date.now();
        for (;t < n.length; t++) {
            e = n[t];
            // Run the timer and safely remove it when done (allowing for external removal)
                        if (!e() && n[t] === e) {
                n.splice(t--, 1);
            }
        }
        if (!n.length) {
            k.fx.stop();
        }
        it = undefined;
    };
    k.fx.timer = function(e) {
        k.timers.push(e);
        k.fx.start();
    };
    k.fx.interval = 13;
    k.fx.start = function() {
        if (rt) {
            return;
        }
        rt = true;
        st();
    };
    k.fx.stop = function() {
        rt = null;
    };
    k.fx.speeds = {
        slow: 600,
        fast: 200,
        // Default speed
        _default: 400
    };
    // Based off of the plugin by Clint Helfers, with permission.
    // https://web.archive.org/web/20100324014747/http://blindsignals.com/index.php/2009/07/jquery-delay/
        k.fn.delay = function(i, e) {
        i = k.fx ? k.fx.speeds[i] || i : i;
        e = e || "fx";
        return this.queue(e, function(e, t) {
            var n = T.setTimeout(e, i);
            t.stop = function() {
                T.clearTimeout(n);
            };
        });
    };
    (function() {
        var e = D.createElement("input"), t = D.createElement("select"), n = t.appendChild(D.createElement("option"));
        e.type = "checkbox";
        // Support: Android <=4.3 only
        // Default value for a checkbox should be "on"
                m.checkOn = e.value !== "";
        // Support: IE <=11 only
        // Must access selectedIndex to make default options select
                m.optSelected = n.selected;
        // Support: IE <=11 only
        // An input loses its value after becoming a radio
                e = D.createElement("input");
        e.value = "t";
        e.type = "radio";
        m.radioValue = e.value === "t";
    })();
    var ht, gt = k.expr.attrHandle;
    k.fn.extend({
        attr: function(e, t) {
            return z(this, k.attr, e, t, arguments.length > 1);
        },
        removeAttr: function(e) {
            return this.each(function() {
                k.removeAttr(this, e);
            });
        }
    });
    k.extend({
        attr: function(e, t, n) {
            var i, r, o = e.nodeType;
            // Don't get/set attributes on text, comment and attribute nodes
                        if (o === 3 || o === 8 || o === 2) {
                return;
            }
            // Fallback to prop when attributes are not supported
                        if (typeof e.getAttribute === "undefined") {
                return k.prop(e, t, n);
            }
            // Attribute hooks are determined by the lowercase version
            // Grab necessary hook if one is defined
                        if (o !== 1 || !k.isXMLDoc(e)) {
                r = k.attrHooks[t.toLowerCase()] || (k.expr.match.bool.test(t) ? ht : undefined);
            }
            if (n !== undefined) {
                if (n === null) {
                    k.removeAttr(e, t);
                    return;
                }
                if (r && "set" in r && (i = r.set(e, n, t)) !== undefined) {
                    return i;
                }
                e.setAttribute(t, n + "");
                return n;
            }
            if (r && "get" in r && (i = r.get(e, t)) !== null) {
                return i;
            }
            i = k.find.attr(e, t);
            // Non-existent attributes return null, we normalize to undefined
                        return i == null ? undefined : i;
        },
        attrHooks: {
            type: {
                set: function(e, t) {
                    if (!m.radioValue && t === "radio" && $(e, "input")) {
                        var n = e.value;
                        e.setAttribute("type", t);
                        if (n) {
                            e.value = n;
                        }
                        return t;
                    }
                }
            }
        },
        removeAttr: function(e, t) {
            var n, i = 0, 
            // Attribute names can contain non-HTML whitespace characters
            // https://html.spec.whatwg.org/multipage/syntax.html#attributes-2
            r = t && t.match(H);
            if (r && e.nodeType === 1) {
                while (n = r[i++]) {
                    e.removeAttribute(n);
                }
            }
        }
    });
    // Hooks for boolean attributes
        ht = {
        set: function(e, t, n) {
            if (t === false) {
                // Remove boolean attributes when set to false
                k.removeAttr(e, n);
            } else {
                e.setAttribute(n, n);
            }
            return n;
        }
    };
    k.each(k.expr.match.bool.source.match(/\w+/g), function(e, t) {
        var a = gt[t] || k.find.attr;
        gt[t] = function(e, t, n) {
            var i, r, o = t.toLowerCase();
            if (!n) {
                // Avoid an infinite loop by temporarily removing this function from the getter
                r = gt[o];
                gt[o] = i;
                i = a(e, t, n) != null ? o : null;
                gt[o] = r;
            }
            return i;
        };
    });
    var vt = /^(?:input|select|textarea|button)$/i, mt = /^(?:a|area)$/i;
    k.fn.extend({
        prop: function(e, t) {
            return z(this, k.prop, e, t, arguments.length > 1);
        },
        removeProp: function(e) {
            return this.each(function() {
                delete this[k.propFix[e] || e];
            });
        }
    });
    k.extend({
        prop: function(e, t, n) {
            var i, r, o = e.nodeType;
            // Don't get/set properties on text, comment and attribute nodes
                        if (o === 3 || o === 8 || o === 2) {
                return;
            }
            if (o !== 1 || !k.isXMLDoc(e)) {
                // Fix name and attach hooks
                t = k.propFix[t] || t;
                r = k.propHooks[t];
            }
            if (n !== undefined) {
                if (r && "set" in r && (i = r.set(e, n, t)) !== undefined) {
                    return i;
                }
                return e[t] = n;
            }
            if (r && "get" in r && (i = r.get(e, t)) !== null) {
                return i;
            }
            return e[t];
        },
        propHooks: {
            tabIndex: {
                get: function(e) {
                    // Support: IE <=9 - 11 only
                    // elem.tabIndex doesn't always return the
                    // correct value when it hasn't been explicitly set
                    // https://web.archive.org/web/20141116233347/http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
                    // Use proper attribute retrieval(#12072)
                    var t = k.find.attr(e, "tabindex");
                    if (t) {
                        return parseInt(t, 10);
                    }
                    if (vt.test(e.nodeName) || mt.test(e.nodeName) && e.href) {
                        return 0;
                    }
                    return -1;
                }
            }
        },
        propFix: {
            for: "htmlFor",
            class: "className"
        }
    });
    // Support: IE <=11 only
    // Accessing the selectedIndex property
    // forces the browser to respect setting selected
    // on the option
    // The getter ensures a default option is selected
    // when in an optgroup
    // eslint rule "no-unused-expressions" is disabled for this code
    // since it considers such accessions noop
        if (!m.optSelected) {
        k.propHooks.selected = {
            get: function(e) {
                /* eslint no-unused-expressions: "off" */
                var t = e.parentNode;
                if (t && t.parentNode) {
                    t.parentNode.selectedIndex;
                }
                return null;
            },
            set: function(e) {
                /* eslint no-unused-expressions: "off" */
                var t = e.parentNode;
                if (t) {
                    t.selectedIndex;
                    if (t.parentNode) {
                        t.parentNode.selectedIndex;
                    }
                }
            }
        };
    }
    k.each([ "tabIndex", "readOnly", "maxLength", "cellSpacing", "cellPadding", "rowSpan", "colSpan", "useMap", "frameBorder", "contentEditable" ], function() {
        k.propFix[this.toLowerCase()] = this;
    });
    // Strip and collapse whitespace according to HTML spec
    // https://infra.spec.whatwg.org/#strip-and-collapse-ascii-whitespace
        function yt(e) {
        var t = e.match(H) || [];
        return t.join(" ");
    }
    function bt(e) {
        return e.getAttribute && e.getAttribute("class") || "";
    }
    function wt(e) {
        if (Array.isArray(e)) {
            return e;
        }
        if (typeof e === "string") {
            return e.match(H) || [];
        }
        return [];
    }
    k.fn.extend({
        addClass: function(t) {
            var e, n, i, r, o, a, s, l = 0;
            if (y(t)) {
                return this.each(function(e) {
                    k(this).addClass(t.call(this, e, bt(this)));
                });
            }
            e = wt(t);
            if (e.length) {
                while (n = this[l++]) {
                    r = bt(n);
                    i = n.nodeType === 1 && " " + yt(r) + " ";
                    if (i) {
                        a = 0;
                        while (o = e[a++]) {
                            if (i.indexOf(" " + o + " ") < 0) {
                                i += o + " ";
                            }
                        }
                        // Only assign if different to avoid unneeded rendering.
                                                s = yt(i);
                        if (r !== s) {
                            n.setAttribute("class", s);
                        }
                    }
                }
            }
            return this;
        },
        removeClass: function(t) {
            var e, n, i, r, o, a, s, l = 0;
            if (y(t)) {
                return this.each(function(e) {
                    k(this).removeClass(t.call(this, e, bt(this)));
                });
            }
            if (!arguments.length) {
                return this.attr("class", "");
            }
            e = wt(t);
            if (e.length) {
                while (n = this[l++]) {
                    r = bt(n);
                    // This expression is here for better compressibility (see addClass)
                                        i = n.nodeType === 1 && " " + yt(r) + " ";
                    if (i) {
                        a = 0;
                        while (o = e[a++]) {
                            // Remove *all* instances
                            while (i.indexOf(" " + o + " ") > -1) {
                                i = i.replace(" " + o + " ", " ");
                            }
                        }
                        // Only assign if different to avoid unneeded rendering.
                                                s = yt(i);
                        if (r !== s) {
                            n.setAttribute("class", s);
                        }
                    }
                }
            }
            return this;
        },
        toggleClass: function(r, t) {
            var o = typeof r, a = o === "string" || Array.isArray(r);
            if (typeof t === "boolean" && a) {
                return t ? this.addClass(r) : this.removeClass(r);
            }
            if (y(r)) {
                return this.each(function(e) {
                    k(this).toggleClass(r.call(this, e, bt(this), t), t);
                });
            }
            return this.each(function() {
                var e, t, n, i;
                if (a) {
                    // Toggle individual class names
                    t = 0;
                    n = k(this);
                    i = wt(r);
                    while (e = i[t++]) {
                        // Check each className given, space separated list
                        if (n.hasClass(e)) {
                            n.removeClass(e);
                        } else {
                            n.addClass(e);
                        }
                    }
                    // Toggle whole class name
                                } else if (r === undefined || o === "boolean") {
                    e = bt(this);
                    if (e) {
                        // Store className if set
                        K.set(this, "__className__", e);
                    }
                    // If the element has a class name or if we're passed `false`,
                    // then remove the whole classname (if there was one, the above saved it).
                    // Otherwise bring back whatever was previously saved (if anything),
                    // falling back to the empty string if nothing was stored.
                                        if (this.setAttribute) {
                        this.setAttribute("class", e || r === false ? "" : K.get(this, "__className__") || "");
                    }
                }
            });
        },
        hasClass: function(e) {
            var t, n, i = 0;
            t = " " + e + " ";
            while (n = this[i++]) {
                if (n.nodeType === 1 && (" " + yt(bt(n)) + " ").indexOf(t) > -1) {
                    return true;
                }
            }
            return false;
        }
    });
    var xt = /\r/g;
    k.fn.extend({
        val: function(n) {
            var i, e, r, t = this[0];
            if (!arguments.length) {
                if (t) {
                    i = k.valHooks[t.type] || k.valHooks[t.nodeName.toLowerCase()];
                    if (i && "get" in i && (e = i.get(t, "value")) !== undefined) {
                        return e;
                    }
                    e = t.value;
                    // Handle most common string cases
                                        if (typeof e === "string") {
                        return e.replace(xt, "");
                    }
                    // Handle cases where value is null/undef or number
                                        return e == null ? "" : e;
                }
                return;
            }
            r = y(n);
            return this.each(function(e) {
                var t;
                if (this.nodeType !== 1) {
                    return;
                }
                if (r) {
                    t = n.call(this, e, k(this).val());
                } else {
                    t = n;
                }
                // Treat null/undefined as ""; convert numbers to string
                                if (t == null) {
                    t = "";
                } else if (typeof t === "number") {
                    t += "";
                } else if (Array.isArray(t)) {
                    t = k.map(t, function(e) {
                        return e == null ? "" : e + "";
                    });
                }
                i = k.valHooks[this.type] || k.valHooks[this.nodeName.toLowerCase()];
                // If set returns undefined, fall back to normal setting
                                if (!i || !("set" in i) || i.set(this, t, "value") === undefined) {
                    this.value = t;
                }
            });
        }
    });
    k.extend({
        valHooks: {
            option: {
                get: function(e) {
                    var t = k.find.attr(e, "value");
                    return t != null ? t : 
                    // Support: IE <=10 - 11 only
                    // option.text throws exceptions (#14686, #14858)
                    // Strip and collapse whitespace
                    // https://html.spec.whatwg.org/#strip-and-collapse-whitespace
                    yt(k.text(e));
                }
            },
            select: {
                get: function(e) {
                    var t, n, i, r = e.options, o = e.selectedIndex, a = e.type === "select-one", s = a ? null : [], l = a ? o + 1 : r.length;
                    if (o < 0) {
                        i = l;
                    } else {
                        i = a ? o : 0;
                    }
                    // Loop through all the selected options
                                        for (;i < l; i++) {
                        n = r[i];
                        // Support: IE <=9 only
                        // IE8-9 doesn't update selected after form reset (#2551)
                                                if ((n.selected || i === o) && 
                        // Don't return options that are disabled or in a disabled optgroup
                        !n.disabled && (!n.parentNode.disabled || !$(n.parentNode, "optgroup"))) {
                            // Get the specific value for the option
                            t = k(n).val();
                            // We don't need an array for one selects
                                                        if (a) {
                                return t;
                            }
                            // Multi-Selects return an array
                                                        s.push(t);
                        }
                    }
                    return s;
                },
                set: function(e, t) {
                    var n, i, r = e.options, o = k.makeArray(t), a = r.length;
                    while (a--) {
                        i = r[a];
                        /* eslint-disable no-cond-assign */                        if (i.selected = k.inArray(k.valHooks.option.get(i), o) > -1) {
                            n = true;
                        }
                        /* eslint-enable no-cond-assign */                    }
                    // Force browsers to behave consistently when non-matching value is set
                                        if (!n) {
                        e.selectedIndex = -1;
                    }
                    return o;
                }
            }
        }
    });
    // Radios and checkboxes getter/setter
        k.each([ "radio", "checkbox" ], function() {
        k.valHooks[this] = {
            set: function(e, t) {
                if (Array.isArray(t)) {
                    return e.checked = k.inArray(k(e).val(), t) > -1;
                }
            }
        };
        if (!m.checkOn) {
            k.valHooks[this].get = function(e) {
                return e.getAttribute("value") === null ? "on" : e.value;
            };
        }
    });
    // Return jQuery for attributes-only inclusion
        m.focusin = "onfocusin" in T;
    var Ct = /^(?:focusinfocus|focusoutblur)$/, Tt = function(e) {
        e.stopPropagation();
    };
    k.extend(k.event, {
        trigger: function(e, t, n, i) {
            var r, o, a, s, l, f, u, c, d = [ n || D ], p = v.call(e, "type") ? e.type : e, h = v.call(e, "namespace") ? e.namespace.split(".") : [];
            o = c = a = n = n || D;
            // Don't do events on text and comment nodes
                        if (n.nodeType === 3 || n.nodeType === 8) {
                return;
            }
            // focus/blur morphs to focusin/out; ensure we're not firing them right now
                        if (Ct.test(p + k.event.triggered)) {
                return;
            }
            if (p.indexOf(".") > -1) {
                // Namespaced trigger; create a regexp to match event type in handle()
                h = p.split(".");
                p = h.shift();
                h.sort();
            }
            l = p.indexOf(":") < 0 && "on" + p;
            // Caller can pass in a jQuery.Event object, Object, or just an event type string
                        e = e[k.expando] ? e : new k.Event(p, typeof e === "object" && e);
            // Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)
                        e.isTrigger = i ? 2 : 3;
            e.namespace = h.join(".");
            e.rnamespace = e.namespace ? new RegExp("(^|\\.)" + h.join("\\.(?:.*\\.|)") + "(\\.|$)") : null;
            // Clean up the event in case it is being reused
                        e.result = undefined;
            if (!e.target) {
                e.target = n;
            }
            // Clone any incoming data and prepend the event, creating the handler arg list
                        t = t == null ? [ e ] : k.makeArray(t, [ e ]);
            // Allow special events to draw outside the lines
                        u = k.event.special[p] || {};
            if (!i && u.trigger && u.trigger.apply(n, t) === false) {
                return;
            }
            // Determine event propagation path in advance, per W3C events spec (#9951)
            // Bubble up to document, then to window; watch for a global ownerDocument var (#9724)
                        if (!i && !u.noBubble && !b(n)) {
                s = u.delegateType || p;
                if (!Ct.test(s + p)) {
                    o = o.parentNode;
                }
                for (;o; o = o.parentNode) {
                    d.push(o);
                    a = o;
                }
                // Only add window if we got to document (e.g., not plain obj or detached DOM)
                                if (a === (n.ownerDocument || D)) {
                    d.push(a.defaultView || a.parentWindow || T);
                }
            }
            // Fire handlers on the event path
                        r = 0;
            while ((o = d[r++]) && !e.isPropagationStopped()) {
                c = o;
                e.type = r > 1 ? s : u.bindType || p;
                // jQuery handler
                                f = (K.get(o, "events") || {})[e.type] && K.get(o, "handle");
                if (f) {
                    f.apply(o, t);
                }
                // Native handler
                                f = l && o[l];
                if (f && f.apply && Y(o)) {
                    e.result = f.apply(o, t);
                    if (e.result === false) {
                        e.preventDefault();
                    }
                }
            }
            e.type = p;
            // If nobody prevented the default action, do it now
                        if (!i && !e.isDefaultPrevented()) {
                if ((!u._default || u._default.apply(d.pop(), t) === false) && Y(n)) {
                    // Call a native DOM method on the target with the same name as the event.
                    // Don't do default actions on window, that's where global variables be (#6170)
                    if (l && y(n[p]) && !b(n)) {
                        // Don't re-trigger an onFOO event when we call its FOO() method
                        a = n[l];
                        if (a) {
                            n[l] = null;
                        }
                        // Prevent re-triggering of the same event, since we already bubbled it above
                                                k.event.triggered = p;
                        if (e.isPropagationStopped()) {
                            c.addEventListener(p, Tt);
                        }
                        n[p]();
                        if (e.isPropagationStopped()) {
                            c.removeEventListener(p, Tt);
                        }
                        k.event.triggered = undefined;
                        if (a) {
                            n[l] = a;
                        }
                    }
                }
            }
            return e.result;
        },
        // Piggyback on a donor event to simulate a different one
        // Used only for `focus(in | out)` events
        simulate: function(e, t, n) {
            var i = k.extend(new k.Event(), n, {
                type: e,
                isSimulated: true
            });
            k.event.trigger(i, null, t);
        }
    });
    k.fn.extend({
        trigger: function(e, t) {
            return this.each(function() {
                k.event.trigger(e, t, this);
            });
        },
        triggerHandler: function(e, t) {
            var n = this[0];
            if (n) {
                return k.event.trigger(e, t, n, true);
            }
        }
    });
    // Support: Firefox <=44
    // Firefox doesn't have focus(in | out) events
    // Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787
    //
    // Support: Chrome <=48 - 49, Safari <=9.0 - 9.1
    // focus(in | out) events fire after focus & blur events,
    // which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order
    // Related ticket - https://bugs.chromium.org/p/chromium/issues/detail?id=449857
        if (!m.focusin) {
        k.each({
            focus: "focusin",
            blur: "focusout"
        }, function(n, i) {
            // Attach a single capturing handler on the document while someone wants focusin/focusout
            var r = function(e) {
                k.event.simulate(i, e.target, k.event.fix(e));
            };
            k.event.special[i] = {
                setup: function() {
                    var e = this.ownerDocument || this, t = K.access(e, i);
                    if (!t) {
                        e.addEventListener(n, r, true);
                    }
                    K.access(e, i, (t || 0) + 1);
                },
                teardown: function() {
                    var e = this.ownerDocument || this, t = K.access(e, i) - 1;
                    if (!t) {
                        e.removeEventListener(n, r, true);
                        K.remove(e, i);
                    } else {
                        K.access(e, i, t);
                    }
                }
            };
        });
    }
    var Dt = T.location;
    var kt = Date.now();
    var St = /\?/;
    // Cross-browser xml parsing
        k.parseXML = function(e) {
        var t;
        if (!e || typeof e !== "string") {
            return null;
        }
        // Support: IE 9 - 11 only
        // IE throws on parseFromString with invalid input.
                try {
            t = new T.DOMParser().parseFromString(e, "text/xml");
        } catch (e) {
            t = undefined;
        }
        if (!t || t.getElementsByTagName("parsererror").length) {
            k.error("Invalid XML: " + e);
        }
        return t;
    };
    var Et = /\[\]$/, $t = /\r?\n/g, At = /^(?:submit|button|image|reset|file)$/i, Nt = /^(?:input|select|textarea|keygen)/i;
    function jt(n, e, i, r) {
        var t;
        if (Array.isArray(e)) {
            // Serialize array item.
            k.each(e, function(e, t) {
                if (i || Et.test(n)) {
                    // Treat each array item as a scalar.
                    r(n, t);
                } else {
                    // Item is non-scalar (array or object), encode its numeric index.
                    jt(n + "[" + (typeof t === "object" && t != null ? e : "") + "]", t, i, r);
                }
            });
        } else if (!i && x(e) === "object") {
            // Serialize object item.
            for (t in e) {
                jt(n + "[" + t + "]", e[t], i, r);
            }
        } else {
            // Serialize scalar item.
            r(n, e);
        }
    }
    // Serialize an array of form elements or a set of
    // key/values into a query string
        k.param = function(e, t) {
        var n, i = [], r = function(e, t) {
            // If value is a function, invoke it and use its return value
            var n = y(t) ? t() : t;
            i[i.length] = encodeURIComponent(e) + "=" + encodeURIComponent(n == null ? "" : n);
        };
        // If an array was passed in, assume that it is an array of form elements.
                if (Array.isArray(e) || e.jquery && !k.isPlainObject(e)) {
            // Serialize the form elements
            k.each(e, function() {
                r(this.name, this.value);
            });
        } else {
            // If traditional, encode the "old" way (the way 1.3.2 or older
            // did it), otherwise encode params recursively.
            for (n in e) {
                jt(n, e[n], t, r);
            }
        }
        // Return the resulting serialization
                return i.join("&");
    };
    k.fn.extend({
        serialize: function() {
            return k.param(this.serializeArray());
        },
        serializeArray: function() {
            return this.map(function() {
                // Can add propHook for "elements" to filter or add form elements
                var e = k.prop(this, "elements");
                return e ? k.makeArray(e) : this;
            }).filter(function() {
                var e = this.type;
                // Use .is( ":disabled" ) so that fieldset[disabled] works
                                return this.name && !k(this).is(":disabled") && Nt.test(this.nodeName) && !At.test(e) && (this.checked || !pe.test(e));
            }).map(function(e, t) {
                var n = k(this).val();
                if (n == null) {
                    return null;
                }
                if (Array.isArray(n)) {
                    return k.map(n, function(e) {
                        return {
                            name: t.name,
                            value: e.replace($t, "\r\n")
                        };
                    });
                }
                return {
                    name: t.name,
                    value: n.replace($t, "\r\n")
                };
            }).get();
        }
    });
    var Lt = /%20/g, It = /#.*$/, Pt = /([?&])_=[^&]*/, Ot = /^(.*?):[ \t]*([^\r\n]*)$/gm, 
    // #7653, #8125, #8152: local protocol detection
    Rt = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/, Ht = /^(?:GET|HEAD)$/, qt = /^\/\//, 
    /* Prefilters
	 * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)
	 * 2) These are called:
	 *    - BEFORE asking for a transport
	 *    - AFTER param serialization (s.data is a string if s.processData is true)
	 * 3) key is the dataType
	 * 4) the catchall symbol "*" can be used
	 * 5) execution will start with transport dataType and THEN continue down to "*" if needed
	 */
    Bt = {}, 
    /* Transports bindings
	 * 1) key is the dataType
	 * 2) the catchall symbol "*" can be used
	 * 3) selection will start with transport dataType and THEN go to "*" if needed
	 */
    Mt = {}, 
    // Avoid comment-prolog char sequence (#10098); must appease lint and evade compression
    _t = "*/".concat("*"), 
    // Anchor tag for parsing the document origin
    Ft = D.createElement("a");
    Ft.href = Dt.href;
    // Base "constructor" for jQuery.ajaxPrefilter and jQuery.ajaxTransport
        function Ut(o) {
        // dataTypeExpression is optional and defaults to "*"
        return function(e, t) {
            if (typeof e !== "string") {
                t = e;
                e = "*";
            }
            var n, i = 0, r = e.toLowerCase().match(H) || [];
            if (y(t)) {
                // For each dataType in the dataTypeExpression
                while (n = r[i++]) {
                    // Prepend if requested
                    if (n[0] === "+") {
                        n = n.slice(1) || "*";
                        (o[n] = o[n] || []).unshift(t);
                        // Otherwise append
                                        } else {
                        (o[n] = o[n] || []).push(t);
                    }
                }
            }
        };
    }
    // Base inspection function for prefilters and transports
        function Wt(t, r, o, a) {
        var s = {}, l = t === Mt;
        function f(e) {
            var i;
            s[e] = true;
            k.each(t[e] || [], function(e, t) {
                var n = t(r, o, a);
                if (typeof n === "string" && !l && !s[n]) {
                    r.dataTypes.unshift(n);
                    f(n);
                    return false;
                } else if (l) {
                    return !(i = n);
                }
            });
            return i;
        }
        return f(r.dataTypes[0]) || !s["*"] && f("*");
    }
    // A special extend for ajax options
    // that takes "flat" options (not to be deep extended)
    // Fixes #9887
        function zt(e, t) {
        var n, i, r = k.ajaxSettings.flatOptions || {};
        for (n in t) {
            if (t[n] !== undefined) {
                (r[n] ? e : i || (i = {}))[n] = t[n];
            }
        }
        if (i) {
            k.extend(true, e, i);
        }
        return e;
    }
    /* Handles responses to an ajax request:
 * - finds the right dataType (mediates between content-type and expected dataType)
 * - returns the corresponding response
 */    function Gt(e, t, n) {
        var i, r, o, a, s = e.contents, l = e.dataTypes;
        // Remove auto dataType and get content-type in the process
                while (l[0] === "*") {
            l.shift();
            if (i === undefined) {
                i = e.mimeType || t.getResponseHeader("Content-Type");
            }
        }
        // Check if we're dealing with a known content-type
                if (i) {
            for (r in s) {
                if (s[r] && s[r].test(i)) {
                    l.unshift(r);
                    break;
                }
            }
        }
        // Check to see if we have a response for the expected dataType
                if (l[0] in n) {
            o = l[0];
        } else {
            // Try convertible dataTypes
            for (r in n) {
                if (!l[0] || e.converters[r + " " + l[0]]) {
                    o = r;
                    break;
                }
                if (!a) {
                    a = r;
                }
            }
            // Or just use first one
                        o = o || a;
        }
        // If we found a dataType
        // We add the dataType to the list if needed
        // and return the corresponding response
                if (o) {
            if (o !== l[0]) {
                l.unshift(o);
            }
            return n[o];
        }
    }
    /* Chain conversions given the request and the original response
 * Also sets the responseXXX fields on the jqXHR instance
 */    function Qt(e, t, n, i) {
        var r, o, a, s, l, f = {}, 
        // Work with a copy of dataTypes in case we need to modify it for conversion
        u = e.dataTypes.slice();
        // Create converters map with lowercased keys
                if (u[1]) {
            for (a in e.converters) {
                f[a.toLowerCase()] = e.converters[a];
            }
        }
        o = u.shift();
        // Convert to each sequential dataType
                while (o) {
            if (e.responseFields[o]) {
                n[e.responseFields[o]] = t;
            }
            // Apply the dataFilter if provided
                        if (!l && i && e.dataFilter) {
                t = e.dataFilter(t, e.dataType);
            }
            l = o;
            o = u.shift();
            if (o) {
                // There's only work to do if current dataType is non-auto
                if (o === "*") {
                    o = l;
                    // Convert response if prev dataType is non-auto and differs from current
                                } else if (l !== "*" && l !== o) {
                    // Seek a direct converter
                    a = f[l + " " + o] || f["* " + o];
                    // If none found, seek a pair
                                        if (!a) {
                        for (r in f) {
                            // If conv2 outputs current
                            s = r.split(" ");
                            if (s[1] === o) {
                                // If prev can be converted to accepted input
                                a = f[l + " " + s[0]] || f["* " + s[0]];
                                if (a) {
                                    // Condense equivalence converters
                                    if (a === true) {
                                        a = f[r];
                                        // Otherwise, insert the intermediate dataType
                                                                        } else if (f[r] !== true) {
                                        o = s[0];
                                        u.unshift(s[1]);
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    // Apply converter (if not an equivalence)
                                        if (a !== true) {
                        // Unless errors are allowed to bubble, catch and return them
                        if (a && e.throws) {
                            t = a(t);
                        } else {
                            try {
                                t = a(t);
                            } catch (e) {
                                return {
                                    state: "parsererror",
                                    error: a ? e : "No conversion from " + l + " to " + o
                                };
                            }
                        }
                    }
                }
            }
        }
        return {
            state: "success",
            data: t
        };
    }
    k.extend({
        // Counter for holding the number of active queries
        active: 0,
        // Last-Modified header cache for next request
        lastModified: {},
        etag: {},
        ajaxSettings: {
            url: Dt.href,
            type: "GET",
            isLocal: Rt.test(Dt.protocol),
            global: true,
            processData: true,
            async: true,
            contentType: "application/x-www-form-urlencoded; charset=UTF-8",
            /*
		timeout: 0,
		data: null,
		dataType: null,
		username: null,
		password: null,
		cache: null,
		throws: false,
		traditional: false,
		headers: {},
		*/
            accepts: {
                "*": _t,
                text: "text/plain",
                html: "text/html",
                xml: "application/xml, text/xml",
                json: "application/json, text/javascript"
            },
            contents: {
                xml: /\bxml\b/,
                html: /\bhtml/,
                json: /\bjson\b/
            },
            responseFields: {
                xml: "responseXML",
                text: "responseText",
                json: "responseJSON"
            },
            // Data converters
            // Keys separate source (or catchall "*") and destination types with a single space
            converters: {
                // Convert anything to text
                "* text": String,
                // Text to html (true = no transformation)
                "text html": true,
                // Evaluate text as a json expression
                "text json": JSON.parse,
                // Parse text as xml
                "text xml": k.parseXML
            },
            // For options that shouldn't be deep extended:
            // you can add your own custom options here if
            // and when you create one that shouldn't be
            // deep extended (see ajaxExtend)
            flatOptions: {
                url: true,
                context: true
            }
        },
        // Creates a full fledged settings object into target
        // with both ajaxSettings and settings fields.
        // If target is omitted, writes into ajaxSettings.
        ajaxSetup: function(e, t) {
            return t ? 
            // Building a settings object
            zt(zt(e, k.ajaxSettings), t) : 
            // Extending ajaxSettings
            zt(k.ajaxSettings, e);
        },
        ajaxPrefilter: Ut(Bt),
        ajaxTransport: Ut(Mt),
        // Main method
        ajax: function(e, t) {
            // If url is an object, simulate pre-1.5 signature
            if (typeof e === "object") {
                t = e;
                e = undefined;
            }
            // Force options to be an object
                        t = t || {};
            var u, 
            // URL without anti-cache param
            c, 
            // Response headers
            d, n, 
            // timeout handle
            p, 
            // Url cleanup var
            i, 
            // Request state (becomes false upon send and true upon completion)
            h, 
            // To know if global events are to be dispatched
            g, 
            // Loop variable
            r, 
            // uncached part of the url
            o, 
            // Create the final options object
            v = k.ajaxSetup({}, t), 
            // Callbacks context
            m = v.context || v, 
            // Context for global events is callbackContext if it is a DOM node or jQuery collection
            y = v.context && (m.nodeType || m.jquery) ? k(m) : k.event, 
            // Deferreds
            b = k.Deferred(), w = k.Callbacks("once memory"), 
            // Status-dependent callbacks
            x = v.statusCode || {}, 
            // Headers (they are sent all at once)
            a = {}, s = {}, 
            // Default abort message
            l = "canceled", 
            // Fake xhr
            C = {
                readyState: 0,
                // Builds headers hashtable if needed
                getResponseHeader: function(e) {
                    var t;
                    if (h) {
                        if (!n) {
                            n = {};
                            while (t = Ot.exec(d)) {
                                n[t[1].toLowerCase()] = t[2];
                            }
                        }
                        t = n[e.toLowerCase()];
                    }
                    return t == null ? null : t;
                },
                // Raw string
                getAllResponseHeaders: function() {
                    return h ? d : null;
                },
                // Caches the header
                setRequestHeader: function(e, t) {
                    if (h == null) {
                        e = s[e.toLowerCase()] = s[e.toLowerCase()] || e;
                        a[e] = t;
                    }
                    return this;
                },
                // Overrides response content-type header
                overrideMimeType: function(e) {
                    if (h == null) {
                        v.mimeType = e;
                    }
                    return this;
                },
                // Status-dependent callbacks
                statusCode: function(e) {
                    var t;
                    if (e) {
                        if (h) {
                            // Execute the appropriate callbacks
                            C.always(e[C.status]);
                        } else {
                            // Lazy-add the new callbacks in a way that preserves old ones
                            for (t in e) {
                                x[t] = [ x[t], e[t] ];
                            }
                        }
                    }
                    return this;
                },
                // Cancel the request
                abort: function(e) {
                    var t = e || l;
                    if (u) {
                        u.abort(t);
                    }
                    f(0, t);
                    return this;
                }
            };
            // Attach deferreds
                        b.promise(C);
            // Add protocol if not provided (prefilters might expect it)
            // Handle falsy url in the settings object (#10093: consistency with old signature)
            // We also use the url parameter if available
                        v.url = ((e || v.url || Dt.href) + "").replace(qt, Dt.protocol + "//");
            // Alias method option to type as per ticket #12004
                        v.type = t.method || t.type || v.method || v.type;
            // Extract dataTypes list
                        v.dataTypes = (v.dataType || "*").toLowerCase().match(H) || [ "" ];
            // A cross-domain request is in order when the origin doesn't match the current origin.
                        if (v.crossDomain == null) {
                i = D.createElement("a");
                // Support: IE <=8 - 11, Edge 12 - 15
                // IE throws exception on accessing the href property if url is malformed,
                // e.g. http://example.com:80x/
                                try {
                    i.href = v.url;
                    // Support: IE <=8 - 11 only
                    // Anchor's host property isn't correctly set when s.url is relative
                                        i.href = i.href;
                    v.crossDomain = Ft.protocol + "//" + Ft.host !== i.protocol + "//" + i.host;
                } catch (e) {
                    // If there is an error parsing the URL, assume it is crossDomain,
                    // it can be rejected by the transport if it is invalid
                    v.crossDomain = true;
                }
            }
            // Convert data if not already a string
                        if (v.data && v.processData && typeof v.data !== "string") {
                v.data = k.param(v.data, v.traditional);
            }
            // Apply prefilters
                        Wt(Bt, v, t, C);
            // If request was aborted inside a prefilter, stop there
                        if (h) {
                return C;
            }
            // We can fire global events as of now if asked to
            // Don't fire events if jQuery.event is undefined in an AMD-usage scenario (#15118)
                        g = k.event && v.global;
            // Watch for a new set of requests
                        if (g && k.active++ === 0) {
                k.event.trigger("ajaxStart");
            }
            // Uppercase the type
                        v.type = v.type.toUpperCase();
            // Determine if request has content
                        v.hasContent = !Ht.test(v.type);
            // Save the URL in case we're toying with the If-Modified-Since
            // and/or If-None-Match header later on
            // Remove hash to simplify url manipulation
                        c = v.url.replace(It, "");
            // More options handling for requests with no content
                        if (!v.hasContent) {
                // Remember the hash so we can put it back
                o = v.url.slice(c.length);
                // If data is available and should be processed, append data to url
                                if (v.data && (v.processData || typeof v.data === "string")) {
                    c += (St.test(c) ? "&" : "?") + v.data;
                    // #9682: remove data so that it's not used in an eventual retry
                                        delete v.data;
                }
                // Add or update anti-cache param if needed
                                if (v.cache === false) {
                    c = c.replace(Pt, "$1");
                    o = (St.test(c) ? "&" : "?") + "_=" + kt++ + o;
                }
                // Put hash and anti-cache on the URL that will be requested (gh-1732)
                                v.url = c + o;
                // Change '%20' to '+' if this is encoded form body content (gh-2658)
                        } else if (v.data && v.processData && (v.contentType || "").indexOf("application/x-www-form-urlencoded") === 0) {
                v.data = v.data.replace(Lt, "+");
            }
            // Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
                        if (v.ifModified) {
                if (k.lastModified[c]) {
                    C.setRequestHeader("If-Modified-Since", k.lastModified[c]);
                }
                if (k.etag[c]) {
                    C.setRequestHeader("If-None-Match", k.etag[c]);
                }
            }
            // Set the correct header, if data is being sent
                        if (v.data && v.hasContent && v.contentType !== false || t.contentType) {
                C.setRequestHeader("Content-Type", v.contentType);
            }
            // Set the Accepts header for the server, depending on the dataType
                        C.setRequestHeader("Accept", v.dataTypes[0] && v.accepts[v.dataTypes[0]] ? v.accepts[v.dataTypes[0]] + (v.dataTypes[0] !== "*" ? ", " + _t + "; q=0.01" : "") : v.accepts["*"]);
            // Check for headers option
                        for (r in v.headers) {
                C.setRequestHeader(r, v.headers[r]);
            }
            // Allow custom headers/mimetypes and early abort
                        if (v.beforeSend && (v.beforeSend.call(m, C, v) === false || h)) {
                // Abort if not done already and return
                return C.abort();
            }
            // Aborting is no longer a cancellation
                        l = "abort";
            // Install callbacks on deferreds
                        w.add(v.complete);
            C.done(v.success);
            C.fail(v.error);
            // Get transport
                        u = Wt(Mt, v, t, C);
            // If no transport, we auto-abort
                        if (!u) {
                f(-1, "No Transport");
            } else {
                C.readyState = 1;
                // Send global event
                                if (g) {
                    y.trigger("ajaxSend", [ C, v ]);
                }
                // If request was aborted inside ajaxSend, stop there
                                if (h) {
                    return C;
                }
                // Timeout
                                if (v.async && v.timeout > 0) {
                    p = T.setTimeout(function() {
                        C.abort("timeout");
                    }, v.timeout);
                }
                try {
                    h = false;
                    u.send(a, f);
                } catch (e) {
                    // Rethrow post-completion exceptions
                    if (h) {
                        throw e;
                    }
                    // Propagate others as results
                                        f(-1, e);
                }
            }
            // Callback for when everything is done
                        function f(e, t, n, i) {
                var r, o, a, s, l, f = t;
                // Ignore repeat invocations
                                if (h) {
                    return;
                }
                h = true;
                // Clear timeout if it exists
                                if (p) {
                    T.clearTimeout(p);
                }
                // Dereference transport for early garbage collection
                // (no matter how long the jqXHR object will be used)
                                u = undefined;
                // Cache response headers
                                d = i || "";
                // Set readyState
                                C.readyState = e > 0 ? 4 : 0;
                // Determine if successful
                                r = e >= 200 && e < 300 || e === 304;
                // Get response data
                                if (n) {
                    s = Gt(v, C, n);
                }
                // Convert no matter what (that way responseXXX fields are always set)
                                s = Qt(v, s, C, r);
                // If successful, handle type chaining
                                if (r) {
                    // Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
                    if (v.ifModified) {
                        l = C.getResponseHeader("Last-Modified");
                        if (l) {
                            k.lastModified[c] = l;
                        }
                        l = C.getResponseHeader("etag");
                        if (l) {
                            k.etag[c] = l;
                        }
                    }
                    // if no content
                                        if (e === 204 || v.type === "HEAD") {
                        f = "nocontent";
                        // if not modified
                                        } else if (e === 304) {
                        f = "notmodified";
                        // If we have data, let's convert it
                                        } else {
                        f = s.state;
                        o = s.data;
                        a = s.error;
                        r = !a;
                    }
                } else {
                    // Extract error from statusText and normalize for non-aborts
                    a = f;
                    if (e || !f) {
                        f = "error";
                        if (e < 0) {
                            e = 0;
                        }
                    }
                }
                // Set data for the fake xhr object
                                C.status = e;
                C.statusText = (t || f) + "";
                // Success/Error
                                if (r) {
                    b.resolveWith(m, [ o, f, C ]);
                } else {
                    b.rejectWith(m, [ C, f, a ]);
                }
                // Status-dependent callbacks
                                C.statusCode(x);
                x = undefined;
                if (g) {
                    y.trigger(r ? "ajaxSuccess" : "ajaxError", [ C, v, r ? o : a ]);
                }
                // Complete
                                w.fireWith(m, [ C, f ]);
                if (g) {
                    y.trigger("ajaxComplete", [ C, v ]);
                    // Handle the global AJAX counter
                                        if (!--k.active) {
                        k.event.trigger("ajaxStop");
                    }
                }
            }
            return C;
        },
        getJSON: function(e, t, n) {
            return k.get(e, t, n, "json");
        },
        getScript: function(e, t) {
            return k.get(e, undefined, t, "script");
        }
    });
    k.each([ "get", "post" ], function(e, r) {
        k[r] = function(e, t, n, i) {
            // Shift arguments if data argument was omitted
            if (y(t)) {
                i = i || n;
                n = t;
                t = undefined;
            }
            // The url can be an options object (which then must have .url)
                        return k.ajax(k.extend({
                url: e,
                type: r,
                dataType: i,
                data: t,
                success: n
            }, k.isPlainObject(e) && e));
        };
    });
    k._evalUrl = function(e) {
        return k.ajax({
            url: e,
            // Make this explicit, since user can override this through ajaxSetup (#11264)
            type: "GET",
            dataType: "script",
            cache: true,
            async: false,
            global: false,
            throws: true
        });
    };
    k.fn.extend({
        wrapAll: function(e) {
            var t;
            if (this[0]) {
                if (y(e)) {
                    e = e.call(this[0]);
                }
                // The elements to wrap the target around
                                t = k(e, this[0].ownerDocument).eq(0).clone(true);
                if (this[0].parentNode) {
                    t.insertBefore(this[0]);
                }
                t.map(function() {
                    var e = this;
                    while (e.firstElementChild) {
                        e = e.firstElementChild;
                    }
                    return e;
                }).append(this);
            }
            return this;
        },
        wrapInner: function(n) {
            if (y(n)) {
                return this.each(function(e) {
                    k(this).wrapInner(n.call(this, e));
                });
            }
            return this.each(function() {
                var e = k(this), t = e.contents();
                if (t.length) {
                    t.wrapAll(n);
                } else {
                    e.append(n);
                }
            });
        },
        wrap: function(t) {
            var n = y(t);
            return this.each(function(e) {
                k(this).wrapAll(n ? t.call(this, e) : t);
            });
        },
        unwrap: function(e) {
            this.parent(e).not("body").each(function() {
                k(this).replaceWith(this.childNodes);
            });
            return this;
        }
    });
    k.expr.pseudos.hidden = function(e) {
        return !k.expr.pseudos.visible(e);
    };
    k.expr.pseudos.visible = function(e) {
        return !!(e.offsetWidth || e.offsetHeight || e.getClientRects().length);
    };
    k.ajaxSettings.xhr = function() {
        try {
            return new T.XMLHttpRequest();
        } catch (e) {}
    };
    var Vt = {
        // File protocol always yields status code 0, assume 200
        0: 200,
        // Support: IE <=9 only
        // #1450: sometimes IE returns 1223 when it should be 204
        1223: 204
    }, Xt = k.ajaxSettings.xhr();
    m.cors = !!Xt && "withCredentials" in Xt;
    m.ajax = Xt = !!Xt;
    k.ajaxTransport(function(r) {
        var o, a;
        // Cross domain only allowed if supported through XMLHttpRequest
                if (m.cors || Xt && !r.crossDomain) {
            return {
                send: function(e, t) {
                    var n, i = r.xhr();
                    i.open(r.type, r.url, r.async, r.username, r.password);
                    // Apply custom fields if provided
                                        if (r.xhrFields) {
                        for (n in r.xhrFields) {
                            i[n] = r.xhrFields[n];
                        }
                    }
                    // Override mime type if needed
                                        if (r.mimeType && i.overrideMimeType) {
                        i.overrideMimeType(r.mimeType);
                    }
                    // X-Requested-With header
                    // For cross-domain requests, seeing as conditions for a preflight are
                    // akin to a jigsaw puzzle, we simply never set it to be sure.
                    // (it can always be set on a per-request basis or even using ajaxSetup)
                    // For same-domain requests, won't change header if already provided.
                                        if (!r.crossDomain && !e["X-Requested-With"]) {
                        e["X-Requested-With"] = "XMLHttpRequest";
                    }
                    // Set headers
                                        for (n in e) {
                        i.setRequestHeader(n, e[n]);
                    }
                    // Callback
                                        o = function(e) {
                        return function() {
                            if (o) {
                                o = a = i.onload = i.onerror = i.onabort = i.ontimeout = i.onreadystatechange = null;
                                if (e === "abort") {
                                    i.abort();
                                } else if (e === "error") {
                                    // Support: IE <=9 only
                                    // On a manual native abort, IE9 throws
                                    // errors on any property access that is not readyState
                                    if (typeof i.status !== "number") {
                                        t(0, "error");
                                    } else {
                                        t(
                                        // File: protocol always yields status 0; see #8605, #14207
                                        i.status, i.statusText);
                                    }
                                } else {
                                    t(Vt[i.status] || i.status, i.statusText, 
                                    // Support: IE <=9 only
                                    // IE9 has no XHR2 but throws on binary (trac-11426)
                                    // For XHR2 non-text, let the caller handle it (gh-2498)
                                    (i.responseType || "text") !== "text" || typeof i.responseText !== "string" ? {
                                        binary: i.response
                                    } : {
                                        text: i.responseText
                                    }, i.getAllResponseHeaders());
                                }
                            }
                        };
                    };
                    // Listen to events
                                        i.onload = o();
                    a = i.onerror = i.ontimeout = o("error");
                    // Support: IE 9 only
                    // Use onreadystatechange to replace onabort
                    // to handle uncaught aborts
                                        if (i.onabort !== undefined) {
                        i.onabort = a;
                    } else {
                        i.onreadystatechange = function() {
                            // Check readyState before timeout as it changes
                            if (i.readyState === 4) {
                                // Allow onerror to be called first,
                                // but that will not handle a native abort
                                // Also, save errorCallback to a variable
                                // as xhr.onerror cannot be accessed
                                T.setTimeout(function() {
                                    if (o) {
                                        a();
                                    }
                                });
                            }
                        };
                    }
                    // Create the abort callback
                                        o = o("abort");
                    try {
                        // Do send the request (this may raise an exception)
                        i.send(r.hasContent && r.data || null);
                    } catch (e) {
                        // #14683: Only rethrow if this hasn't been notified as an error yet
                        if (o) {
                            throw e;
                        }
                    }
                },
                abort: function() {
                    if (o) {
                        o();
                    }
                }
            };
        }
    });
    // Prevent auto-execution of scripts when no explicit dataType was provided (See gh-2432)
        k.ajaxPrefilter(function(e) {
        if (e.crossDomain) {
            e.contents.script = false;
        }
    });
    // Install script dataType
        k.ajaxSetup({
        accepts: {
            script: "text/javascript, application/javascript, " + "application/ecmascript, application/x-ecmascript"
        },
        contents: {
            script: /\b(?:java|ecma)script\b/
        },
        converters: {
            "text script": function(e) {
                k.globalEval(e);
                return e;
            }
        }
    });
    // Handle cache's special case and crossDomain
        k.ajaxPrefilter("script", function(e) {
        if (e.cache === undefined) {
            e.cache = false;
        }
        if (e.crossDomain) {
            e.type = "GET";
        }
    });
    // Bind script tag hack transport
        k.ajaxTransport("script", function(n) {
        // This transport only deals with cross domain requests
        if (n.crossDomain) {
            var i, r;
            return {
                send: function(e, t) {
                    i = k("<script>").prop({
                        charset: n.scriptCharset,
                        src: n.url
                    }).on("load error", r = function(e) {
                        i.remove();
                        r = null;
                        if (e) {
                            t(e.type === "error" ? 404 : 200, e.type);
                        }
                    });
                    // Use native DOM manipulation to avoid our domManip AJAX trickery
                                        D.head.appendChild(i[0]);
                },
                abort: function() {
                    if (r) {
                        r();
                    }
                }
            };
        }
    });
    var Yt = [], Jt = /(=)\?(?=&|$)|\?\?/;
    // Default jsonp settings
        k.ajaxSetup({
        jsonp: "callback",
        jsonpCallback: function() {
            var e = Yt.pop() || k.expando + "_" + kt++;
            this[e] = true;
            return e;
        }
    });
    // Detect, normalize options and install callbacks for jsonp requests
        k.ajaxPrefilter("json jsonp", function(e, t, n) {
        var i, r, o, a = e.jsonp !== false && (Jt.test(e.url) ? "url" : typeof e.data === "string" && (e.contentType || "").indexOf("application/x-www-form-urlencoded") === 0 && Jt.test(e.data) && "data");
        // Handle iff the expected data type is "jsonp" or we have a parameter to set
                if (a || e.dataTypes[0] === "jsonp") {
            // Get callback name, remembering preexisting value associated with it
            i = e.jsonpCallback = y(e.jsonpCallback) ? e.jsonpCallback() : e.jsonpCallback;
            // Insert callback into url or form data
                        if (a) {
                e[a] = e[a].replace(Jt, "$1" + i);
            } else if (e.jsonp !== false) {
                e.url += (St.test(e.url) ? "&" : "?") + e.jsonp + "=" + i;
            }
            // Use data converter to retrieve json after script execution
                        e.converters["script json"] = function() {
                if (!o) {
                    k.error(i + " was not called");
                }
                return o[0];
            };
            // Force json dataType
                        e.dataTypes[0] = "json";
            // Install callback
                        r = T[i];
            T[i] = function() {
                o = arguments;
            };
            // Clean-up function (fires after converters)
                        n.always(function() {
                // If previous value didn't exist - remove it
                if (r === undefined) {
                    k(T).removeProp(i);
                    // Otherwise restore preexisting value
                                } else {
                    T[i] = r;
                }
                // Save back as free
                                if (e[i]) {
                    // Make sure that re-using the options doesn't screw things around
                    e.jsonpCallback = t.jsonpCallback;
                    // Save the callback name for future use
                                        Yt.push(i);
                }
                // Call if it was a function and we have a response
                                if (o && y(r)) {
                    r(o[0]);
                }
                o = r = undefined;
            });
            // Delegate to script
                        return "script";
        }
    });
    // Support: Safari 8 only
    // In Safari 8 documents created via document.implementation.createHTMLDocument
    // collapse sibling forms: the second one becomes a child of the first one.
    // Because of that, this security measure has to be disabled in Safari 8.
    // https://bugs.webkit.org/show_bug.cgi?id=137337
        m.createHTMLDocument = function() {
        var e = D.implementation.createHTMLDocument("").body;
        e.innerHTML = "<form></form><form></form>";
        return e.childNodes.length === 2;
    }();
    // Argument "data" should be string of html
    // context (optional): If specified, the fragment will be created in this context,
    // defaults to document
    // keepScripts (optional): If true, will include scripts passed in the html string
        k.parseHTML = function(e, t, n) {
        if (typeof e !== "string") {
            return [];
        }
        if (typeof t === "boolean") {
            n = t;
            t = false;
        }
        var i, r, o;
        if (!t) {
            // Stop scripts or inline event handlers from being executed immediately
            // by using document.implementation
            if (m.createHTMLDocument) {
                t = D.implementation.createHTMLDocument("");
                // Set the base href for the created document
                // so any parsed elements with URLs
                // are based on the document's URL (gh-2965)
                                i = t.createElement("base");
                i.href = D.location.href;
                t.head.appendChild(i);
            } else {
                t = D;
            }
        }
        r = A.exec(e);
        o = !n && [];
        // Single tag
                if (r) {
            return [ t.createElement(r[1]) ];
        }
        r = we([ e ], t, o);
        if (o && o.length) {
            k(o).remove();
        }
        return k.merge([], r.childNodes);
    };
    /**
 * Load a url into a page
 */    k.fn.load = function(e, t, n) {
        var i, r, o, a = this, s = e.indexOf(" ");
        if (s > -1) {
            i = yt(e.slice(s));
            e = e.slice(0, s);
        }
        // If it's a function
                if (y(t)) {
            // We assume that it's the callback
            n = t;
            t = undefined;
            // Otherwise, build a param string
                } else if (t && typeof t === "object") {
            r = "POST";
        }
        // If we have elements to modify, make the request
                if (a.length > 0) {
            k.ajax({
                url: e,
                // If "type" variable is undefined, then "GET" method will be used.
                // Make value of this field explicit since
                // user can override it through ajaxSetup method
                type: r || "GET",
                dataType: "html",
                data: t
            }).done(function(e) {
                // Save response for use in complete callback
                o = arguments;
                a.html(i ? 
                // If a selector was specified, locate the right elements in a dummy div
                // Exclude scripts to avoid IE 'Permission Denied' errors
                k("<div>").append(k.parseHTML(e)).find(i) : 
                // Otherwise use the full result
                e);
                // If the request succeeds, this function gets "data", "status", "jqXHR"
                // but they are ignored because response was set above.
                // If it fails, this function gets "jqXHR", "status", "error"
                        }).always(n && function(e, t) {
                a.each(function() {
                    n.apply(this, o || [ e.responseText, t, e ]);
                });
            });
        }
        return this;
    };
    // Attach a bunch of functions for handling common AJAX events
        k.each([ "ajaxStart", "ajaxStop", "ajaxComplete", "ajaxError", "ajaxSuccess", "ajaxSend" ], function(e, t) {
        k.fn[t] = function(e) {
            return this.on(t, e);
        };
    });
    k.expr.pseudos.animated = function(t) {
        return k.grep(k.timers, function(e) {
            return t === e.elem;
        }).length;
    };
    k.offset = {
        setOffset: function(e, t, n) {
            var i, r, o, a, s, l, f, u = k.css(e, "position"), c = k(e), d = {};
            // Set position first, in-case top/left are set even on static elem
                        if (u === "static") {
                e.style.position = "relative";
            }
            s = c.offset();
            o = k.css(e, "top");
            l = k.css(e, "left");
            f = (u === "absolute" || u === "fixed") && (o + l).indexOf("auto") > -1;
            // Need to be able to calculate position if either
            // top or left is auto and position is either absolute or fixed
                        if (f) {
                i = c.position();
                a = i.top;
                r = i.left;
            } else {
                a = parseFloat(o) || 0;
                r = parseFloat(l) || 0;
            }
            if (y(t)) {
                // Use jQuery.extend here to allow modification of coordinates argument (gh-1848)
                t = t.call(e, n, k.extend({}, s));
            }
            if (t.top != null) {
                d.top = t.top - s.top + a;
            }
            if (t.left != null) {
                d.left = t.left - s.left + r;
            }
            if ("using" in t) {
                t.using.call(e, d);
            } else {
                c.css(d);
            }
        }
    };
    k.fn.extend({
        // offset() relates an element's border box to the document origin
        offset: function(t) {
            // Preserve chaining for setter
            if (arguments.length) {
                return t === undefined ? this : this.each(function(e) {
                    k.offset.setOffset(this, t, e);
                });
            }
            var e, n, i = this[0];
            if (!i) {
                return;
            }
            // Return zeros for disconnected and hidden (display: none) elements (gh-2310)
            // Support: IE <=11 only
            // Running getBoundingClientRect on a
            // disconnected node in IE throws an error
                        if (!i.getClientRects().length) {
                return {
                    top: 0,
                    left: 0
                };
            }
            // Get document-relative position by adding viewport scroll to viewport-relative gBCR
                        e = i.getBoundingClientRect();
            n = i.ownerDocument.defaultView;
            return {
                top: e.top + n.pageYOffset,
                left: e.left + n.pageXOffset
            };
        },
        // position() relates an element's margin box to its offset parent's padding box
        // This corresponds to the behavior of CSS absolute positioning
        position: function() {
            if (!this[0]) {
                return;
            }
            var e, t, n, i = this[0], r = {
                top: 0,
                left: 0
            };
            // position:fixed elements are offset from the viewport, which itself always has zero offset
                        if (k.css(i, "position") === "fixed") {
                // Assume position:fixed implies availability of getBoundingClientRect
                t = i.getBoundingClientRect();
            } else {
                t = this.offset();
                // Account for the *real* offset parent, which can be the document or its root element
                // when a statically positioned element is identified
                                n = i.ownerDocument;
                e = i.offsetParent || n.documentElement;
                while (e && (e === n.body || e === n.documentElement) && k.css(e, "position") === "static") {
                    e = e.parentNode;
                }
                if (e && e !== i && e.nodeType === 1) {
                    // Incorporate borders into its offset, since they are outside its content origin
                    r = k(e).offset();
                    r.top += k.css(e, "borderTopWidth", true);
                    r.left += k.css(e, "borderLeftWidth", true);
                }
            }
            // Subtract parent offsets and element margins
                        return {
                top: t.top - r.top - k.css(i, "marginTop", true),
                left: t.left - r.left - k.css(i, "marginLeft", true)
            };
        },
        // This method will return documentElement in the following cases:
        // 1) For the element inside the iframe without offsetParent, this method will return
        //    documentElement of the parent window
        // 2) For the hidden or detached element
        // 3) For body or html element, i.e. in case of the html node - it will return itself
        //
        // but those exceptions were never presented as a real life use-cases
        // and might be considered as more preferable results.
        //
        // This logic, however, is not guaranteed and can change at any point in the future
        offsetParent: function() {
            return this.map(function() {
                var e = this.offsetParent;
                while (e && k.css(e, "position") === "static") {
                    e = e.offsetParent;
                }
                return e || xe;
            });
        }
    });
    // Create scrollLeft and scrollTop methods
        k.each({
        scrollLeft: "pageXOffset",
        scrollTop: "pageYOffset"
    }, function(t, r) {
        var o = "pageYOffset" === r;
        k.fn[t] = function(e) {
            return z(this, function(e, t, n) {
                // Coalesce documents and windows
                var i;
                if (b(e)) {
                    i = e;
                } else if (e.nodeType === 9) {
                    i = e.defaultView;
                }
                if (n === undefined) {
                    return i ? i[r] : e[t];
                }
                if (i) {
                    i.scrollTo(!o ? n : i.pageXOffset, o ? n : i.pageYOffset);
                } else {
                    e[t] = n;
                }
            }, t, e, arguments.length);
        };
    });
    // Support: Safari <=7 - 9.1, Chrome <=37 - 49
    // Add the top/left cssHooks using jQuery.fn.position
    // Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
    // Blink bug: https://bugs.chromium.org/p/chromium/issues/detail?id=589347
    // getComputedStyle returns percent when specified for top/left/bottom/right;
    // rather than make the css module depend on the offset module, just check for it here
        k.each([ "top", "left" ], function(e, n) {
        k.cssHooks[n] = We(m.pixelPosition, function(e, t) {
            if (t) {
                t = Ue(e, n);
                // If curCSS returns percentage, fallback to offset
                                return Me.test(t) ? k(e).position()[n] + "px" : t;
            }
        });
    });
    // Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
        k.each({
        Height: "height",
        Width: "width"
    }, function(a, s) {
        k.each({
            padding: "inner" + a,
            content: s,
            "": "outer" + a
        }, function(i, o) {
            // Margin is only for outerHeight, outerWidth
            k.fn[o] = function(e, t) {
                var n = arguments.length && (i || typeof e !== "boolean"), r = i || (e === true || t === true ? "margin" : "border");
                return z(this, function(e, t, n) {
                    var i;
                    if (b(e)) {
                        // $( window ).outerWidth/Height return w/h including scrollbars (gh-1729)
                        return o.indexOf("outer") === 0 ? e["inner" + a] : e.document.documentElement["client" + a];
                    }
                    // Get document width or height
                                        if (e.nodeType === 9) {
                        i = e.documentElement;
                        // Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],
                        // whichever is greatest
                                                return Math.max(e.body["scroll" + a], i["scroll" + a], e.body["offset" + a], i["offset" + a], i["client" + a]);
                    }
                    return n === undefined ? 
                    // Get width or height on the element, requesting but not forcing parseFloat
                    k.css(e, t, r) : 
                    // Set width or height on the element
                    k.style(e, t, n, r);
                }, s, n ? e : undefined, n);
            };
        });
    });
    k.each(("blur focus focusin focusout resize scroll click dblclick " + "mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " + "change select submit keydown keypress keyup contextmenu").split(" "), function(e, n) {
        // Handle event binding
        k.fn[n] = function(e, t) {
            return arguments.length > 0 ? this.on(n, null, e, t) : this.trigger(n);
        };
    });
    k.fn.extend({
        hover: function(e, t) {
            return this.mouseenter(e).mouseleave(t || e);
        }
    });
    k.fn.extend({
        bind: function(e, t, n) {
            return this.on(e, null, t, n);
        },
        unbind: function(e, t) {
            return this.off(e, null, t);
        },
        delegate: function(e, t, n, i) {
            return this.on(t, e, n, i);
        },
        undelegate: function(e, t, n) {
            // ( namespace ) or ( selector, types [, fn] )
            return arguments.length === 1 ? this.off(e, "**") : this.off(t, e || "**", n);
        }
    });
    // Bind a function to a context, optionally partially applying any
    // arguments.
    // jQuery.proxy is deprecated to promote standards (specifically Function#bind)
    // However, it is not slated for removal any time soon
        k.proxy = function(e, t) {
        var n, i, r;
        if (typeof t === "string") {
            n = e[t];
            t = e;
            e = n;
        }
        // Quick check to determine if target is callable, in the spec
        // this throws a TypeError, but we will just return undefined.
                if (!y(e)) {
            return undefined;
        }
        // Simulated bind
                i = s.call(arguments, 2);
        r = function() {
            return e.apply(t || this, i.concat(s.call(arguments)));
        };
        // Set the guid of unique handler to the same of original handler, so it can be removed
                r.guid = e.guid = e.guid || k.guid++;
        return r;
    };
    k.holdReady = function(e) {
        if (e) {
            k.readyWait++;
        } else {
            k.ready(true);
        }
    };
    k.isArray = Array.isArray;
    k.parseJSON = JSON.parse;
    k.nodeName = $;
    k.isFunction = y;
    k.isWindow = b;
    k.camelCase = X;
    k.type = x;
    k.now = Date.now;
    k.isNumeric = function(e) {
        // As of jQuery 3.0, isNumeric is limited to
        // strings and numbers (primitives or objects)
        // that can be coerced to finite numbers (gh-2662)
        var t = k.type(e);
        return (t === "number" || t === "string") && 
        // parseFloat NaNs numeric-cast false positives ("")
        // ...but misinterprets leading-number strings, particularly hex literals ("0x...")
        // subtraction forces infinities to NaN
        !isNaN(e - parseFloat(e));
    };
    // Register as a named AMD module, since jQuery can be concatenated with other
    // files that may use define, but not via a proper concatenation script that
    // understands anonymous AMD modules. A named AMD is safest and most robust
    // way to register. Lowercase jquery is used because AMD module names are
    // derived from file names, and jQuery is normally delivered in a lowercase
    // file name. Do this after creating the global so that if an AMD module wants
    // to call noConflict to hide this version of jQuery, it will work.
    // Note that for maximum portability, libraries that are not jQuery should
    // declare themselves as anonymous modules, and avoid setting a global if an
    // AMD loader is present. jQuery is a special case. For more information, see
    // https://github.com/jrburke/requirejs/wiki/Updating-existing-libraries#wiki-anon
        if (typeof define === "function" && define.amd) {
        define("jquery", [], function() {
            return k;
        });
    }
    var 
    // Map over jQuery in case of overwrite
    Kt = T.jQuery, 
    // Map over the $ in case of overwrite
    Zt = T.$;
    k.noConflict = function(e) {
        if (T.$ === k) {
            T.$ = Zt;
        }
        if (e && T.jQuery === k) {
            T.jQuery = Kt;
        }
        return k;
    };
    // Expose jQuery and $ identifiers, even in AMD
    // (#7102#comment:10, https://github.com/jquery/jquery/pull/557)
    // and CommonJS for browser emulators (#13566)
        if (!e) {
        T.jQuery = T.$ = k;
    }
    return k;
});

/*!
 * Bootstrap v3.3.7 (http://getbootstrap.com)
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under the MIT license
 */ if (typeof jQuery === "undefined") {
    throw new Error("Bootstrap's JavaScript requires jQuery");
}

+function(e) {
    "use strict";
    var t = e.fn.jquery.split(" ")[0].split(".");
    if (t[0] < 2 && t[1] < 9 || t[0] == 1 && t[1] == 9 && t[2] < 1 || t[0] > 3) {
        throw new Error("Bootstrap's JavaScript requires jQuery version 1.9.1 or higher, but lower than version 4");
    }
}(jQuery);

/* ========================================================================
 * Bootstrap: transition.js v3.3.7
 * http://getbootstrap.com/javascript/#transitions
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */ +function(r) {
    "use strict";
    // CSS TRANSITION SUPPORT (Shoutout: http://www.modernizr.com/)
    // ============================================================
        function e() {
        var e = document.createElement("bootstrap");
        var t = {
            WebkitTransition: "webkitTransitionEnd",
            MozTransition: "transitionend",
            OTransition: "oTransitionEnd otransitionend",
            transition: "transitionend"
        };
        for (var n in t) {
            if (e.style[n] !== undefined) {
                return {
                    end: t[n]
                };
            }
        }
        return false;
 // explicit for ie8 (  ._.)
        }
    // http://blog.alexmaccaw.com/css-transitions
        r.fn.emulateTransitionEnd = function(e) {
        var t = false;
        var n = this;
        r(this).one("bsTransitionEnd", function() {
            t = true;
        });
        var i = function() {
            if (!t) r(n).trigger(r.support.transition.end);
        };
        setTimeout(i, e);
        return this;
    };
    r(function() {
        r.support.transition = e();
        if (!r.support.transition) return;
        r.event.special.bsTransitionEnd = {
            bindType: r.support.transition.end,
            delegateType: r.support.transition.end,
            handle: function(e) {
                if (r(e.target).is(this)) return e.handleObj.handler.apply(this, arguments);
            }
        };
    });
}(jQuery);

/* ========================================================================
 * Bootstrap: alert.js v3.3.7
 * http://getbootstrap.com/javascript/#alerts
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */ +function(o) {
    "use strict";
    // ALERT CLASS DEFINITION
    // ======================
        var t = '[data-dismiss="alert"]';
    var a = function(e) {
        o(e).on("click", t, this.close);
    };
    a.VERSION = "3.3.7";
    a.TRANSITION_DURATION = 150;
    a.prototype.close = function(e) {
        var t = o(this);
        var n = t.attr("data-target");
        if (!n) {
            n = t.attr("href");
            n = n && n.replace(/.*(?=#[^\s]*$)/, "");
 // strip for ie7
                }
        var i = o(n === "#" ? [] : n);
        if (e) e.preventDefault();
        if (!i.length) {
            i = t.closest(".alert");
        }
        i.trigger(e = o.Event("close.bs.alert"));
        if (e.isDefaultPrevented()) return;
        i.removeClass("in");
        function r() {
            // detach from parent, fire event then clean up data
            i.detach().trigger("closed.bs.alert").remove();
        }
        o.support.transition && i.hasClass("fade") ? i.one("bsTransitionEnd", r).emulateTransitionEnd(a.TRANSITION_DURATION) : r();
    }
    // ALERT PLUGIN DEFINITION
    // =======================
    ;
    function e(n) {
        return this.each(function() {
            var e = o(this);
            var t = e.data("bs.alert");
            if (!t) e.data("bs.alert", t = new a(this));
            if (typeof n == "string") t[n].call(e);
        });
    }
    var n = o.fn.alert;
    o.fn.alert = e;
    o.fn.alert.Constructor = a;
    // ALERT NO CONFLICT
    // =================
        o.fn.alert.noConflict = function() {
        o.fn.alert = n;
        return this;
    }
    // ALERT DATA-API
    // ==============
    ;
    o(document).on("click.bs.alert.data-api", t, a.prototype.close);
}(jQuery);

/* ========================================================================
 * Bootstrap: button.js v3.3.7
 * http://getbootstrap.com/javascript/#buttons
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */ +function(o) {
    "use strict";
    // BUTTON PUBLIC CLASS DEFINITION
    // ==============================
        var r = function(e, t) {
        this.$element = o(e);
        this.options = o.extend({}, r.DEFAULTS, t);
        this.isLoading = false;
    };
    r.VERSION = "3.3.7";
    r.DEFAULTS = {
        loadingText: "loading..."
    };
    r.prototype.setState = function(e) {
        var t = "disabled";
        var n = this.$element;
        var i = n.is("input") ? "val" : "html";
        var r = n.data();
        e += "Text";
        if (r.resetText == null) n.data("resetText", n[i]());
        // push to event loop to allow forms to submit
                setTimeout(o.proxy(function() {
            n[i](r[e] == null ? this.options[e] : r[e]);
            if (e == "loadingText") {
                this.isLoading = true;
                n.addClass(t).attr(t, t).prop(t, true);
            } else if (this.isLoading) {
                this.isLoading = false;
                n.removeClass(t).removeAttr(t).prop(t, false);
            }
        }, this), 0);
    };
    r.prototype.toggle = function() {
        var e = true;
        var t = this.$element.closest('[data-toggle="buttons"]');
        if (t.length) {
            var n = this.$element.find("input");
            if (n.prop("type") == "radio") {
                if (n.prop("checked")) e = false;
                t.find(".active").removeClass("active");
                this.$element.addClass("active");
            } else if (n.prop("type") == "checkbox") {
                if (n.prop("checked") !== this.$element.hasClass("active")) e = false;
                this.$element.toggleClass("active");
            }
            n.prop("checked", this.$element.hasClass("active"));
            if (e) n.trigger("change");
        } else {
            this.$element.attr("aria-pressed", !this.$element.hasClass("active"));
            this.$element.toggleClass("active");
        }
    }
    // BUTTON PLUGIN DEFINITION
    // ========================
    ;
    function n(i) {
        return this.each(function() {
            var e = o(this);
            var t = e.data("bs.button");
            var n = typeof i == "object" && i;
            if (!t) e.data("bs.button", t = new r(this, n));
            if (i == "toggle") t.toggle(); else if (i) t.setState(i);
        });
    }
    var e = o.fn.button;
    o.fn.button = n;
    o.fn.button.Constructor = r;
    // BUTTON NO CONFLICT
    // ==================
        o.fn.button.noConflict = function() {
        o.fn.button = e;
        return this;
    }
    // BUTTON DATA-API
    // ===============
    ;
    o(document).on("click.bs.button.data-api", '[data-toggle^="button"]', function(e) {
        var t = o(e.target).closest(".btn");
        n.call(t, "toggle");
        if (!o(e.target).is('input[type="radio"], input[type="checkbox"]')) {
            // Prevent double click on radios, and the double selections (so cancellation) on checkboxes
            e.preventDefault();
            // The target component still receive the focus
                        if (t.is("input,button")) t.trigger("focus"); else t.find("input:visible,button:visible").first().trigger("focus");
        }
    }).on("focus.bs.button.data-api blur.bs.button.data-api", '[data-toggle^="button"]', function(e) {
        o(e.target).closest(".btn").toggleClass("focus", /^focus(in)?$/.test(e.type));
    });
}(jQuery);

/* ========================================================================
 * Bootstrap: carousel.js v3.3.7
 * http://getbootstrap.com/javascript/#carousel
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */ +function(c) {
    "use strict";
    // CAROUSEL CLASS DEFINITION
    // =========================
        var d = function(e, t) {
        this.$element = c(e);
        this.$indicators = this.$element.find(".carousel-indicators");
        this.options = t;
        this.paused = null;
        this.sliding = null;
        this.interval = null;
        this.$active = null;
        this.$items = null;
        this.options.keyboard && this.$element.on("keydown.bs.carousel", c.proxy(this.keydown, this));
        this.options.pause == "hover" && !("ontouchstart" in document.documentElement) && this.$element.on("mouseenter.bs.carousel", c.proxy(this.pause, this)).on("mouseleave.bs.carousel", c.proxy(this.cycle, this));
    };
    d.VERSION = "3.3.7";
    d.TRANSITION_DURATION = 600;
    d.DEFAULTS = {
        interval: 5e3,
        pause: "hover",
        wrap: true,
        keyboard: true
    };
    d.prototype.keydown = function(e) {
        if (/input|textarea/i.test(e.target.tagName)) return;
        switch (e.which) {
          case 37:
            this.prev();
            break;

          case 39:
            this.next();
            break;

          default:
            return;
        }
        e.preventDefault();
    };
    d.prototype.cycle = function(e) {
        e || (this.paused = false);
        this.interval && clearInterval(this.interval);
        this.options.interval && !this.paused && (this.interval = setInterval(c.proxy(this.next, this), this.options.interval));
        return this;
    };
    d.prototype.getItemIndex = function(e) {
        this.$items = e.parent().children(".item");
        return this.$items.index(e || this.$active);
    };
    d.prototype.getItemForDirection = function(e, t) {
        var n = this.getItemIndex(t);
        var i = e == "prev" && n === 0 || e == "next" && n == this.$items.length - 1;
        if (i && !this.options.wrap) return t;
        var r = e == "prev" ? -1 : 1;
        var o = (n + r) % this.$items.length;
        return this.$items.eq(o);
    };
    d.prototype.to = function(e) {
        var t = this;
        var n = this.getItemIndex(this.$active = this.$element.find(".item.active"));
        if (e > this.$items.length - 1 || e < 0) return;
        if (this.sliding) return this.$element.one("slid.bs.carousel", function() {
            t.to(e);
        });
 // yes, "slid"
                if (n == e) return this.pause().cycle();
        return this.slide(e > n ? "next" : "prev", this.$items.eq(e));
    };
    d.prototype.pause = function(e) {
        e || (this.paused = true);
        if (this.$element.find(".next, .prev").length && c.support.transition) {
            this.$element.trigger(c.support.transition.end);
            this.cycle(true);
        }
        this.interval = clearInterval(this.interval);
        return this;
    };
    d.prototype.next = function() {
        if (this.sliding) return;
        return this.slide("next");
    };
    d.prototype.prev = function() {
        if (this.sliding) return;
        return this.slide("prev");
    };
    d.prototype.slide = function(e, t) {
        var n = this.$element.find(".item.active");
        var i = t || this.getItemForDirection(e, n);
        var r = this.interval;
        var o = e == "next" ? "left" : "right";
        var a = this;
        if (i.hasClass("active")) return this.sliding = false;
        var s = i[0];
        var l = c.Event("slide.bs.carousel", {
            relatedTarget: s,
            direction: o
        });
        this.$element.trigger(l);
        if (l.isDefaultPrevented()) return;
        this.sliding = true;
        r && this.pause();
        if (this.$indicators.length) {
            this.$indicators.find(".active").removeClass("active");
            var f = c(this.$indicators.children()[this.getItemIndex(i)]);
            f && f.addClass("active");
        }
        var u = c.Event("slid.bs.carousel", {
            relatedTarget: s,
            direction: o
        });
 // yes, "slid"
                if (c.support.transition && this.$element.hasClass("slide")) {
            i.addClass(e);
            i[0].offsetWidth;
 // force reflow
                        n.addClass(o);
            i.addClass(o);
            n.one("bsTransitionEnd", function() {
                i.removeClass([ e, o ].join(" ")).addClass("active");
                n.removeClass([ "active", o ].join(" "));
                a.sliding = false;
                setTimeout(function() {
                    a.$element.trigger(u);
                }, 0);
            }).emulateTransitionEnd(d.TRANSITION_DURATION);
        } else {
            n.removeClass("active");
            i.addClass("active");
            this.sliding = false;
            this.$element.trigger(u);
        }
        r && this.cycle();
        return this;
    }
    // CAROUSEL PLUGIN DEFINITION
    // ==========================
    ;
    function a(r) {
        return this.each(function() {
            var e = c(this);
            var t = e.data("bs.carousel");
            var n = c.extend({}, d.DEFAULTS, e.data(), typeof r == "object" && r);
            var i = typeof r == "string" ? r : n.slide;
            if (!t) e.data("bs.carousel", t = new d(this, n));
            if (typeof r == "number") t.to(r); else if (i) t[i](); else if (n.interval) t.pause().cycle();
        });
    }
    var e = c.fn.carousel;
    c.fn.carousel = a;
    c.fn.carousel.Constructor = d;
    // CAROUSEL NO CONFLICT
    // ====================
        c.fn.carousel.noConflict = function() {
        c.fn.carousel = e;
        return this;
    }
    // CAROUSEL DATA-API
    // =================
    ;
    var t = function(e) {
        var t;
        var n = c(this);
        var i = c(n.attr("data-target") || (t = n.attr("href")) && t.replace(/.*(?=#[^\s]+$)/, ""));
 // strip for ie7
                if (!i.hasClass("carousel")) return;
        var r = c.extend({}, i.data(), n.data());
        var o = n.attr("data-slide-to");
        if (o) r.interval = false;
        a.call(i, r);
        if (o) {
            i.data("bs.carousel").to(o);
        }
        e.preventDefault();
    };
    c(document).on("click.bs.carousel.data-api", "[data-slide]", t).on("click.bs.carousel.data-api", "[data-slide-to]", t);
    c(window).on("load", function() {
        c('[data-ride="carousel"]').each(function() {
            var e = c(this);
            a.call(e, e.data());
        });
    });
}(jQuery);

/* ========================================================================
 * Bootstrap: collapse.js v3.3.7
 * http://getbootstrap.com/javascript/#collapse
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */
/* jshint latedef: false */ +function(a) {
    "use strict";
    // COLLAPSE PUBLIC CLASS DEFINITION
    // ================================
        var s = function(e, t) {
        this.$element = a(e);
        this.options = a.extend({}, s.DEFAULTS, t);
        this.$trigger = a('[data-toggle="collapse"][href="#' + e.id + '"],' + '[data-toggle="collapse"][data-target="#' + e.id + '"]');
        this.transitioning = null;
        if (this.options.parent) {
            this.$parent = this.getParent();
        } else {
            this.addAriaAndCollapsedClass(this.$element, this.$trigger);
        }
        if (this.options.toggle) this.toggle();
    };
    s.VERSION = "3.3.7";
    s.TRANSITION_DURATION = 350;
    s.DEFAULTS = {
        toggle: true
    };
    s.prototype.dimension = function() {
        var e = this.$element.hasClass("width");
        return e ? "width" : "height";
    };
    s.prototype.show = function() {
        if (this.transitioning || this.$element.hasClass("in")) return;
        var e;
        var t = this.$parent && this.$parent.children(".panel").children(".in, .collapsing");
        if (t && t.length) {
            e = t.data("bs.collapse");
            if (e && e.transitioning) return;
        }
        var n = a.Event("show.bs.collapse");
        this.$element.trigger(n);
        if (n.isDefaultPrevented()) return;
        if (t && t.length) {
            l.call(t, "hide");
            e || t.data("bs.collapse", null);
        }
        var i = this.dimension();
        this.$element.removeClass("collapse").addClass("collapsing")[i](0).attr("aria-expanded", true);
        this.$trigger.removeClass("collapsed").attr("aria-expanded", true);
        this.transitioning = 1;
        var r = function() {
            this.$element.removeClass("collapsing").addClass("collapse in")[i]("");
            this.transitioning = 0;
            this.$element.trigger("shown.bs.collapse");
        };
        if (!a.support.transition) return r.call(this);
        var o = a.camelCase([ "scroll", i ].join("-"));
        this.$element.one("bsTransitionEnd", a.proxy(r, this)).emulateTransitionEnd(s.TRANSITION_DURATION)[i](this.$element[0][o]);
    };
    s.prototype.hide = function() {
        if (this.transitioning || !this.$element.hasClass("in")) return;
        var e = a.Event("hide.bs.collapse");
        this.$element.trigger(e);
        if (e.isDefaultPrevented()) return;
        var t = this.dimension();
        this.$element[t](this.$element[t]())[0].offsetHeight;
        this.$element.addClass("collapsing").removeClass("collapse in").attr("aria-expanded", false);
        this.$trigger.addClass("collapsed").attr("aria-expanded", false);
        this.transitioning = 1;
        var n = function() {
            this.transitioning = 0;
            this.$element.removeClass("collapsing").addClass("collapse").trigger("hidden.bs.collapse");
        };
        if (!a.support.transition) return n.call(this);
        this.$element[t](0).one("bsTransitionEnd", a.proxy(n, this)).emulateTransitionEnd(s.TRANSITION_DURATION);
    };
    s.prototype.toggle = function() {
        this[this.$element.hasClass("in") ? "hide" : "show"]();
    };
    s.prototype.getParent = function() {
        return a(this.options.parent).find('[data-toggle="collapse"][data-parent="' + this.options.parent + '"]').each(a.proxy(function(e, t) {
            var n = a(t);
            this.addAriaAndCollapsedClass(o(n), n);
        }, this)).end();
    };
    s.prototype.addAriaAndCollapsedClass = function(e, t) {
        var n = e.hasClass("in");
        e.attr("aria-expanded", n);
        t.toggleClass("collapsed", !n).attr("aria-expanded", n);
    };
    function o(e) {
        var t;
        var n = e.attr("data-target") || (t = e.attr("href")) && t.replace(/.*(?=#[^\s]+$)/, "");
 // strip for ie7
                return a(n);
    }
    // COLLAPSE PLUGIN DEFINITION
    // ==========================
        function l(i) {
        return this.each(function() {
            var e = a(this);
            var t = e.data("bs.collapse");
            var n = a.extend({}, s.DEFAULTS, e.data(), typeof i == "object" && i);
            if (!t && n.toggle && /show|hide/.test(i)) n.toggle = false;
            if (!t) e.data("bs.collapse", t = new s(this, n));
            if (typeof i == "string") t[i]();
        });
    }
    var e = a.fn.collapse;
    a.fn.collapse = l;
    a.fn.collapse.Constructor = s;
    // COLLAPSE NO CONFLICT
    // ====================
        a.fn.collapse.noConflict = function() {
        a.fn.collapse = e;
        return this;
    }
    // COLLAPSE DATA-API
    // =================
    ;
    a(document).on("click.bs.collapse.data-api", '[data-toggle="collapse"]', function(e) {
        var t = a(this);
        if (!t.attr("data-target")) e.preventDefault();
        var n = o(t);
        var i = n.data("bs.collapse");
        var r = i ? "toggle" : t.data();
        l.call(n, r);
    });
}(jQuery);

/* ========================================================================
 * Bootstrap: dropdown.js v3.3.7
 * http://getbootstrap.com/javascript/#dropdowns
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */ +function(s) {
    "use strict";
    // DROPDOWN CLASS DEFINITION
    // =========================
        var e = ".dropdown-backdrop";
    var l = '[data-toggle="dropdown"]';
    var i = function(e) {
        s(e).on("click.bs.dropdown", this.toggle);
    };
    i.VERSION = "3.3.7";
    function f(e) {
        var t = e.attr("data-target");
        if (!t) {
            t = e.attr("href");
            t = t && /#[A-Za-z]/.test(t) && t.replace(/.*(?=#[^\s]*$)/, "");
 // strip for ie7
                }
        var n = t && s(t);
        return n && n.length ? n : e.parent();
    }
    function o(i) {
        if (i && i.which === 3) return;
        s(e).remove();
        s(l).each(function() {
            var e = s(this);
            var t = f(e);
            var n = {
                relatedTarget: this
            };
            if (!t.hasClass("open")) return;
            if (i && i.type == "click" && /input|textarea/i.test(i.target.tagName) && s.contains(t[0], i.target)) return;
            t.trigger(i = s.Event("hide.bs.dropdown", n));
            if (i.isDefaultPrevented()) return;
            e.attr("aria-expanded", "false");
            t.removeClass("open").trigger(s.Event("hidden.bs.dropdown", n));
        });
    }
    i.prototype.toggle = function(e) {
        var t = s(this);
        if (t.is(".disabled, :disabled")) return;
        var n = f(t);
        var i = n.hasClass("open");
        o();
        if (!i) {
            if ("ontouchstart" in document.documentElement && !n.closest(".navbar-nav").length) {
                // if mobile we use a backdrop because click events don't delegate
                s(document.createElement("div")).addClass("dropdown-backdrop").insertAfter(s(this)).on("click", o);
            }
            var r = {
                relatedTarget: this
            };
            n.trigger(e = s.Event("show.bs.dropdown", r));
            if (e.isDefaultPrevented()) return;
            t.trigger("focus").attr("aria-expanded", "true");
            n.toggleClass("open").trigger(s.Event("shown.bs.dropdown", r));
        }
        return false;
    };
    i.prototype.keydown = function(e) {
        if (!/(38|40|27|32)/.test(e.which) || /input|textarea/i.test(e.target.tagName)) return;
        var t = s(this);
        e.preventDefault();
        e.stopPropagation();
        if (t.is(".disabled, :disabled")) return;
        var n = f(t);
        var i = n.hasClass("open");
        if (!i && e.which != 27 || i && e.which == 27) {
            if (e.which == 27) n.find(l).trigger("focus");
            return t.trigger("click");
        }
        var r = " li:not(.disabled):visible a";
        var o = n.find(".dropdown-menu" + r);
        if (!o.length) return;
        var a = o.index(e.target);
        if (e.which == 38 && a > 0) a--;
 // up
                if (e.which == 40 && a < o.length - 1) a++;
 // down
                if (!~a) a = 0;
        o.eq(a).trigger("focus");
    }
    // DROPDOWN PLUGIN DEFINITION
    // ==========================
    ;
    function t(n) {
        return this.each(function() {
            var e = s(this);
            var t = e.data("bs.dropdown");
            if (!t) e.data("bs.dropdown", t = new i(this));
            if (typeof n == "string") t[n].call(e);
        });
    }
    var n = s.fn.dropdown;
    s.fn.dropdown = t;
    s.fn.dropdown.Constructor = i;
    // DROPDOWN NO CONFLICT
    // ====================
        s.fn.dropdown.noConflict = function() {
        s.fn.dropdown = n;
        return this;
    }
    // APPLY TO STANDARD DROPDOWN ELEMENTS
    // ===================================
    ;
    s(document).on("click.bs.dropdown.data-api", o).on("click.bs.dropdown.data-api", ".dropdown form", function(e) {
        e.stopPropagation();
    }).on("click.bs.dropdown.data-api", l, i.prototype.toggle).on("keydown.bs.dropdown.data-api", l, i.prototype.keydown).on("keydown.bs.dropdown.data-api", ".dropdown-menu", i.prototype.keydown);
}(jQuery);

/* ========================================================================
 * Bootstrap: modal.js v3.3.7
 * http://getbootstrap.com/javascript/#modals
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */ +function(o) {
    "use strict";
    // MODAL CLASS DEFINITION
    // ======================
        var a = function(e, t) {
        this.options = t;
        this.$body = o(document.body);
        this.$element = o(e);
        this.$dialog = this.$element.find(".modal-dialog");
        this.$backdrop = null;
        this.isShown = null;
        this.originalBodyPad = null;
        this.scrollbarWidth = 0;
        this.ignoreBackdropClick = false;
        if (this.options.remote) {
            this.$element.find(".modal-content").load(this.options.remote, o.proxy(function() {
                this.$element.trigger("loaded.bs.modal");
            }, this));
        }
    };
    a.VERSION = "3.3.7";
    a.TRANSITION_DURATION = 300;
    a.BACKDROP_TRANSITION_DURATION = 150;
    a.DEFAULTS = {
        backdrop: true,
        keyboard: true,
        show: true
    };
    a.prototype.toggle = function(e) {
        return this.isShown ? this.hide() : this.show(e);
    };
    a.prototype.show = function(n) {
        var i = this;
        var e = o.Event("show.bs.modal", {
            relatedTarget: n
        });
        this.$element.trigger(e);
        if (this.isShown || e.isDefaultPrevented()) return;
        this.isShown = true;
        this.checkScrollbar();
        this.setScrollbar();
        this.$body.addClass("modal-open");
        this.escape();
        this.resize();
        this.$element.on("click.dismiss.bs.modal", '[data-dismiss="modal"]', o.proxy(this.hide, this));
        this.$dialog.on("mousedown.dismiss.bs.modal", function() {
            i.$element.one("mouseup.dismiss.bs.modal", function(e) {
                if (o(e.target).is(i.$element)) i.ignoreBackdropClick = true;
            });
        });
        this.backdrop(function() {
            var e = o.support.transition && i.$element.hasClass("fade");
            if (!i.$element.parent().length) {
                i.$element.appendTo(i.$body);
 // don't move modals dom position
                        }
            i.$element.show().scrollTop(0);
            i.adjustDialog();
            if (e) {
                i.$element[0].offsetWidth;
 // force reflow
                        }
            i.$element.addClass("in");
            i.enforceFocus();
            var t = o.Event("shown.bs.modal", {
                relatedTarget: n
            });
            e ? i.$dialog.one("bsTransitionEnd", function() {
                i.$element.trigger("focus").trigger(t);
            }).emulateTransitionEnd(a.TRANSITION_DURATION) : i.$element.trigger("focus").trigger(t);
        });
    };
    a.prototype.hide = function(e) {
        if (e) e.preventDefault();
        e = o.Event("hide.bs.modal");
        this.$element.trigger(e);
        if (!this.isShown || e.isDefaultPrevented()) return;
        this.isShown = false;
        this.escape();
        this.resize();
        o(document).off("focusin.bs.modal");
        this.$element.removeClass("in").off("click.dismiss.bs.modal").off("mouseup.dismiss.bs.modal");
        this.$dialog.off("mousedown.dismiss.bs.modal");
        o.support.transition && this.$element.hasClass("fade") ? this.$element.one("bsTransitionEnd", o.proxy(this.hideModal, this)).emulateTransitionEnd(a.TRANSITION_DURATION) : this.hideModal();
    };
    a.prototype.enforceFocus = function() {
        o(document).off("focusin.bs.modal").on("focusin.bs.modal", o.proxy(function(e) {
            if (document !== e.target && this.$element[0] !== e.target && !this.$element.has(e.target).length) {
                this.$element.trigger("focus");
            }
        }, this));
    };
    a.prototype.escape = function() {
        if (this.isShown && this.options.keyboard) {
            this.$element.on("keydown.dismiss.bs.modal", o.proxy(function(e) {
                e.which == 27 && this.hide();
            }, this));
        } else if (!this.isShown) {
            this.$element.off("keydown.dismiss.bs.modal");
        }
    };
    a.prototype.resize = function() {
        if (this.isShown) {
            o(window).on("resize.bs.modal", o.proxy(this.handleUpdate, this));
        } else {
            o(window).off("resize.bs.modal");
        }
    };
    a.prototype.hideModal = function() {
        var e = this;
        this.$element.hide();
        this.backdrop(function() {
            e.$body.removeClass("modal-open");
            e.resetAdjustments();
            e.resetScrollbar();
            e.$element.trigger("hidden.bs.modal");
        });
    };
    a.prototype.removeBackdrop = function() {
        this.$backdrop && this.$backdrop.remove();
        this.$backdrop = null;
    };
    a.prototype.backdrop = function(e) {
        var t = this;
        var n = this.$element.hasClass("fade") ? "fade" : "";
        if (this.isShown && this.options.backdrop) {
            var i = o.support.transition && n;
            this.$backdrop = o(document.createElement("div")).addClass("modal-backdrop " + n).appendTo(this.$body);
            this.$element.on("click.dismiss.bs.modal", o.proxy(function(e) {
                if (this.ignoreBackdropClick) {
                    this.ignoreBackdropClick = false;
                    return;
                }
                if (e.target !== e.currentTarget) return;
                this.options.backdrop == "static" ? this.$element[0].focus() : this.hide();
            }, this));
            if (i) this.$backdrop[0].offsetWidth;
 // force reflow
                        this.$backdrop.addClass("in");
            if (!e) return;
            i ? this.$backdrop.one("bsTransitionEnd", e).emulateTransitionEnd(a.BACKDROP_TRANSITION_DURATION) : e();
        } else if (!this.isShown && this.$backdrop) {
            this.$backdrop.removeClass("in");
            var r = function() {
                t.removeBackdrop();
                e && e();
            };
            o.support.transition && this.$element.hasClass("fade") ? this.$backdrop.one("bsTransitionEnd", r).emulateTransitionEnd(a.BACKDROP_TRANSITION_DURATION) : r();
        } else if (e) {
            e();
        }
    }
    // these following methods are used to handle overflowing modals
    ;
    a.prototype.handleUpdate = function() {
        this.adjustDialog();
    };
    a.prototype.adjustDialog = function() {
        var e = this.$element[0].scrollHeight > document.documentElement.clientHeight;
        this.$element.css({
            paddingLeft: !this.bodyIsOverflowing && e ? this.scrollbarWidth : "",
            paddingRight: this.bodyIsOverflowing && !e ? this.scrollbarWidth : ""
        });
    };
    a.prototype.resetAdjustments = function() {
        this.$element.css({
            paddingLeft: "",
            paddingRight: ""
        });
    };
    a.prototype.checkScrollbar = function() {
        var e = window.innerWidth;
        if (!e) {
            // workaround for missing window.innerWidth in IE8
            var t = document.documentElement.getBoundingClientRect();
            e = t.right - Math.abs(t.left);
        }
        this.bodyIsOverflowing = document.body.clientWidth < e;
        this.scrollbarWidth = this.measureScrollbar();
    };
    a.prototype.setScrollbar = function() {
        var e = parseInt(this.$body.css("padding-right") || 0, 10);
        this.originalBodyPad = document.body.style.paddingRight || "";
        if (this.bodyIsOverflowing) this.$body.css("padding-right", e + this.scrollbarWidth);
    };
    a.prototype.resetScrollbar = function() {
        this.$body.css("padding-right", this.originalBodyPad);
    };
    a.prototype.measureScrollbar = function() {
        // thx walsh
        var e = document.createElement("div");
        e.className = "modal-scrollbar-measure";
        this.$body.append(e);
        var t = e.offsetWidth - e.clientWidth;
        this.$body[0].removeChild(e);
        return t;
    }
    // MODAL PLUGIN DEFINITION
    // =======================
    ;
    function s(i, r) {
        return this.each(function() {
            var e = o(this);
            var t = e.data("bs.modal");
            var n = o.extend({}, a.DEFAULTS, e.data(), typeof i == "object" && i);
            if (!t) e.data("bs.modal", t = new a(this, n));
            if (typeof i == "string") t[i](r); else if (n.show) t.show(r);
        });
    }
    var e = o.fn.modal;
    o.fn.modal = s;
    o.fn.modal.Constructor = a;
    // MODAL NO CONFLICT
    // =================
        o.fn.modal.noConflict = function() {
        o.fn.modal = e;
        return this;
    }
    // MODAL DATA-API
    // ==============
    ;
    o(document).on("click.bs.modal.data-api", '[data-toggle="modal"]', function(e) {
        var t = o(this);
        var n = t.attr("href");
        var i = o(t.attr("data-target") || n && n.replace(/.*(?=#[^\s]+$)/, ""));
 // strip for ie7
                var r = i.data("bs.modal") ? "toggle" : o.extend({
            remote: !/#/.test(n) && n
        }, i.data(), t.data());
        if (t.is("a")) e.preventDefault();
        i.one("show.bs.modal", function(e) {
            if (e.isDefaultPrevented()) return;
 // only register focus restorer if modal will actually get shown
                        i.one("hidden.bs.modal", function() {
                t.is(":visible") && t.trigger("focus");
            });
        });
        s.call(i, r, this);
    });
}(jQuery);

/* ========================================================================
 * Bootstrap: tooltip.js v3.3.7
 * http://getbootstrap.com/javascript/#tooltip
 * Inspired by the original jQuery.tipsy by Jason Frame
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */ +function(g) {
    "use strict";
    // TOOLTIP PUBLIC CLASS DEFINITION
    // ===============================
        var v = function(e, t) {
        this.type = null;
        this.options = null;
        this.enabled = null;
        this.timeout = null;
        this.hoverState = null;
        this.$element = null;
        this.inState = null;
        this.init("tooltip", e, t);
    };
    v.VERSION = "3.3.7";
    v.TRANSITION_DURATION = 150;
    v.DEFAULTS = {
        animation: true,
        placement: "top",
        selector: false,
        template: '<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',
        trigger: "hover focus",
        title: "",
        delay: 0,
        html: false,
        container: false,
        viewport: {
            selector: "body",
            padding: 0
        }
    };
    v.prototype.init = function(e, t, n) {
        this.enabled = true;
        this.type = e;
        this.$element = g(t);
        this.options = this.getOptions(n);
        this.$viewport = this.options.viewport && g(g.isFunction(this.options.viewport) ? this.options.viewport.call(this, this.$element) : this.options.viewport.selector || this.options.viewport);
        this.inState = {
            click: false,
            hover: false,
            focus: false
        };
        if (this.$element[0] instanceof document.constructor && !this.options.selector) {
            throw new Error("`selector` option must be specified when initializing " + this.type + " on the window.document object!");
        }
        var i = this.options.trigger.split(" ");
        for (var r = i.length; r--; ) {
            var o = i[r];
            if (o == "click") {
                this.$element.on("click." + this.type, this.options.selector, g.proxy(this.toggle, this));
            } else if (o != "manual") {
                var a = o == "hover" ? "mouseenter" : "focusin";
                var s = o == "hover" ? "mouseleave" : "focusout";
                this.$element.on(a + "." + this.type, this.options.selector, g.proxy(this.enter, this));
                this.$element.on(s + "." + this.type, this.options.selector, g.proxy(this.leave, this));
            }
        }
        this.options.selector ? this._options = g.extend({}, this.options, {
            trigger: "manual",
            selector: ""
        }) : this.fixTitle();
    };
    v.prototype.getDefaults = function() {
        return v.DEFAULTS;
    };
    v.prototype.getOptions = function(e) {
        e = g.extend({}, this.getDefaults(), this.$element.data(), e);
        if (e.delay && typeof e.delay == "number") {
            e.delay = {
                show: e.delay,
                hide: e.delay
            };
        }
        return e;
    };
    v.prototype.getDelegateOptions = function() {
        var n = {};
        var i = this.getDefaults();
        this._options && g.each(this._options, function(e, t) {
            if (i[e] != t) n[e] = t;
        });
        return n;
    };
    v.prototype.enter = function(e) {
        var t = e instanceof this.constructor ? e : g(e.currentTarget).data("bs." + this.type);
        if (!t) {
            t = new this.constructor(e.currentTarget, this.getDelegateOptions());
            g(e.currentTarget).data("bs." + this.type, t);
        }
        if (e instanceof g.Event) {
            t.inState[e.type == "focusin" ? "focus" : "hover"] = true;
        }
        if (t.tip().hasClass("in") || t.hoverState == "in") {
            t.hoverState = "in";
            return;
        }
        clearTimeout(t.timeout);
        t.hoverState = "in";
        if (!t.options.delay || !t.options.delay.show) return t.show();
        t.timeout = setTimeout(function() {
            if (t.hoverState == "in") t.show();
        }, t.options.delay.show);
    };
    v.prototype.isInStateTrue = function() {
        for (var e in this.inState) {
            if (this.inState[e]) return true;
        }
        return false;
    };
    v.prototype.leave = function(e) {
        var t = e instanceof this.constructor ? e : g(e.currentTarget).data("bs." + this.type);
        if (!t) {
            t = new this.constructor(e.currentTarget, this.getDelegateOptions());
            g(e.currentTarget).data("bs." + this.type, t);
        }
        if (e instanceof g.Event) {
            t.inState[e.type == "focusout" ? "focus" : "hover"] = false;
        }
        if (t.isInStateTrue()) return;
        clearTimeout(t.timeout);
        t.hoverState = "out";
        if (!t.options.delay || !t.options.delay.hide) return t.hide();
        t.timeout = setTimeout(function() {
            if (t.hoverState == "out") t.hide();
        }, t.options.delay.hide);
    };
    v.prototype.show = function() {
        var e = g.Event("show.bs." + this.type);
        if (this.hasContent() && this.enabled) {
            this.$element.trigger(e);
            var t = g.contains(this.$element[0].ownerDocument.documentElement, this.$element[0]);
            if (e.isDefaultPrevented() || !t) return;
            var n = this;
            var i = this.tip();
            var r = this.getUID(this.type);
            this.setContent();
            i.attr("id", r);
            this.$element.attr("aria-describedby", r);
            if (this.options.animation) i.addClass("fade");
            var o = typeof this.options.placement == "function" ? this.options.placement.call(this, i[0], this.$element[0]) : this.options.placement;
            var a = /\s?auto?\s?/i;
            var s = a.test(o);
            if (s) o = o.replace(a, "") || "top";
            i.detach().css({
                top: 0,
                left: 0,
                display: "block"
            }).addClass(o).data("bs." + this.type, this);
            this.options.container ? i.appendTo(this.options.container) : i.insertAfter(this.$element);
            this.$element.trigger("inserted.bs." + this.type);
            var l = this.getPosition();
            var f = i[0].offsetWidth;
            var u = i[0].offsetHeight;
            if (s) {
                var c = o;
                var d = this.getPosition(this.$viewport);
                o = o == "bottom" && l.bottom + u > d.bottom ? "top" : o == "top" && l.top - u < d.top ? "bottom" : o == "right" && l.right + f > d.width ? "left" : o == "left" && l.left - f < d.left ? "right" : o;
                i.removeClass(c).addClass(o);
            }
            var p = this.getCalculatedOffset(o, l, f, u);
            this.applyPlacement(p, o);
            var h = function() {
                var e = n.hoverState;
                n.$element.trigger("shown.bs." + n.type);
                n.hoverState = null;
                if (e == "out") n.leave(n);
            };
            g.support.transition && this.$tip.hasClass("fade") ? i.one("bsTransitionEnd", h).emulateTransitionEnd(v.TRANSITION_DURATION) : h();
        }
    };
    v.prototype.applyPlacement = function(e, t) {
        var n = this.tip();
        var i = n[0].offsetWidth;
        var r = n[0].offsetHeight;
        // manually read margins because getBoundingClientRect includes difference
                var o = parseInt(n.css("margin-top"), 10);
        var a = parseInt(n.css("margin-left"), 10);
        // we must check for NaN for ie 8/9
                if (isNaN(o)) o = 0;
        if (isNaN(a)) a = 0;
        e.top += o;
        e.left += a;
        // $.fn.offset doesn't round pixel values
        // so we use setOffset directly with our own function B-0
                g.offset.setOffset(n[0], g.extend({
            using: function(e) {
                n.css({
                    top: Math.round(e.top),
                    left: Math.round(e.left)
                });
            }
        }, e), 0);
        n.addClass("in");
        // check to see if placing tip in new offset caused the tip to resize itself
                var s = n[0].offsetWidth;
        var l = n[0].offsetHeight;
        if (t == "top" && l != r) {
            e.top = e.top + r - l;
        }
        var f = this.getViewportAdjustedDelta(t, e, s, l);
        if (f.left) e.left += f.left; else e.top += f.top;
        var u = /top|bottom/.test(t);
        var c = u ? f.left * 2 - i + s : f.top * 2 - r + l;
        var d = u ? "offsetWidth" : "offsetHeight";
        n.offset(e);
        this.replaceArrow(c, n[0][d], u);
    };
    v.prototype.replaceArrow = function(e, t, n) {
        this.arrow().css(n ? "left" : "top", 50 * (1 - e / t) + "%").css(n ? "top" : "left", "");
    };
    v.prototype.setContent = function() {
        var e = this.tip();
        var t = this.getTitle();
        e.find(".tooltip-inner")[this.options.html ? "html" : "text"](t);
        e.removeClass("fade in top bottom left right");
    };
    v.prototype.hide = function(e) {
        var t = this;
        var n = g(this.$tip);
        var i = g.Event("hide.bs." + this.type);
        function r() {
            if (t.hoverState != "in") n.detach();
            if (t.$element) {
                // TODO: Check whether guarding this code with this `if` is really necessary.
                t.$element.removeAttr("aria-describedby").trigger("hidden.bs." + t.type);
            }
            e && e();
        }
        this.$element.trigger(i);
        if (i.isDefaultPrevented()) return;
        n.removeClass("in");
        g.support.transition && n.hasClass("fade") ? n.one("bsTransitionEnd", r).emulateTransitionEnd(v.TRANSITION_DURATION) : r();
        this.hoverState = null;
        return this;
    };
    v.prototype.fixTitle = function() {
        var e = this.$element;
        if (e.attr("title") || typeof e.attr("data-original-title") != "string") {
            e.attr("data-original-title", e.attr("title") || "").attr("title", "");
        }
    };
    v.prototype.hasContent = function() {
        return this.getTitle();
    };
    v.prototype.getPosition = function(e) {
        e = e || this.$element;
        var t = e[0];
        var n = t.tagName == "BODY";
        var i = t.getBoundingClientRect();
        if (i.width == null) {
            // width and height are missing in IE8, so compute them manually; see https://github.com/twbs/bootstrap/issues/14093
            i = g.extend({}, i, {
                width: i.right - i.left,
                height: i.bottom - i.top
            });
        }
        var r = window.SVGElement && t instanceof window.SVGElement;
        // Avoid using $.offset() on SVGs since it gives incorrect results in jQuery 3.
        // See https://github.com/twbs/bootstrap/issues/20280
                var o = n ? {
            top: 0,
            left: 0
        } : r ? null : e.offset();
        var a = {
            scroll: n ? document.documentElement.scrollTop || document.body.scrollTop : e.scrollTop()
        };
        var s = n ? {
            width: g(window).width(),
            height: g(window).height()
        } : null;
        return g.extend({}, i, a, s, o);
    };
    v.prototype.getCalculatedOffset = function(e, t, n, i) {
        return e == "bottom" ? {
            top: t.top + t.height,
            left: t.left + t.width / 2 - n / 2
        } : e == "top" ? {
            top: t.top - i,
            left: t.left + t.width / 2 - n / 2
        } : e == "left" ? {
            top: t.top + t.height / 2 - i / 2,
            left: t.left - n
        } : 
        /* placement == 'right' */ {
            top: t.top + t.height / 2 - i / 2,
            left: t.left + t.width
        };
    };
    v.prototype.getViewportAdjustedDelta = function(e, t, n, i) {
        var r = {
            top: 0,
            left: 0
        };
        if (!this.$viewport) return r;
        var o = this.options.viewport && this.options.viewport.padding || 0;
        var a = this.getPosition(this.$viewport);
        if (/right|left/.test(e)) {
            var s = t.top - o - a.scroll;
            var l = t.top + o - a.scroll + i;
            if (s < a.top) {
                // top overflow
                r.top = a.top - s;
            } else if (l > a.top + a.height) {
                // bottom overflow
                r.top = a.top + a.height - l;
            }
        } else {
            var f = t.left - o;
            var u = t.left + o + n;
            if (f < a.left) {
                // left overflow
                r.left = a.left - f;
            } else if (u > a.right) {
                // right overflow
                r.left = a.left + a.width - u;
            }
        }
        return r;
    };
    v.prototype.getTitle = function() {
        var e;
        var t = this.$element;
        var n = this.options;
        e = t.attr("data-original-title") || (typeof n.title == "function" ? n.title.call(t[0]) : n.title);
        return e;
    };
    v.prototype.getUID = function(e) {
        do {
            e += ~~(Math.random() * 1e6);
        } while (document.getElementById(e));
        return e;
    };
    v.prototype.tip = function() {
        if (!this.$tip) {
            this.$tip = g(this.options.template);
            if (this.$tip.length != 1) {
                throw new Error(this.type + " `template` option must consist of exactly 1 top-level element!");
            }
        }
        return this.$tip;
    };
    v.prototype.arrow = function() {
        return this.$arrow = this.$arrow || this.tip().find(".tooltip-arrow");
    };
    v.prototype.enable = function() {
        this.enabled = true;
    };
    v.prototype.disable = function() {
        this.enabled = false;
    };
    v.prototype.toggleEnabled = function() {
        this.enabled = !this.enabled;
    };
    v.prototype.toggle = function(e) {
        var t = this;
        if (e) {
            t = g(e.currentTarget).data("bs." + this.type);
            if (!t) {
                t = new this.constructor(e.currentTarget, this.getDelegateOptions());
                g(e.currentTarget).data("bs." + this.type, t);
            }
        }
        if (e) {
            t.inState.click = !t.inState.click;
            if (t.isInStateTrue()) t.enter(t); else t.leave(t);
        } else {
            t.tip().hasClass("in") ? t.leave(t) : t.enter(t);
        }
    };
    v.prototype.destroy = function() {
        var e = this;
        clearTimeout(this.timeout);
        this.hide(function() {
            e.$element.off("." + e.type).removeData("bs." + e.type);
            if (e.$tip) {
                e.$tip.detach();
            }
            e.$tip = null;
            e.$arrow = null;
            e.$viewport = null;
            e.$element = null;
        });
    }
    // TOOLTIP PLUGIN DEFINITION
    // =========================
    ;
    function e(i) {
        return this.each(function() {
            var e = g(this);
            var t = e.data("bs.tooltip");
            var n = typeof i == "object" && i;
            if (!t && /destroy|hide/.test(i)) return;
            if (!t) e.data("bs.tooltip", t = new v(this, n));
            if (typeof i == "string") t[i]();
        });
    }
    var t = g.fn.tooltip;
    g.fn.tooltip = e;
    g.fn.tooltip.Constructor = v;
    // TOOLTIP NO CONFLICT
    // ===================
        g.fn.tooltip.noConflict = function() {
        g.fn.tooltip = t;
        return this;
    };
}(jQuery);

/* ========================================================================
 * Bootstrap: popover.js v3.3.7
 * http://getbootstrap.com/javascript/#popovers
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */ +function(r) {
    "use strict";
    // POPOVER PUBLIC CLASS DEFINITION
    // ===============================
        var o = function(e, t) {
        this.init("popover", e, t);
    };
    if (!r.fn.tooltip) throw new Error("Popover requires tooltip.js");
    o.VERSION = "3.3.7";
    o.DEFAULTS = r.extend({}, r.fn.tooltip.Constructor.DEFAULTS, {
        placement: "right",
        trigger: "click",
        content: "",
        template: '<div class="popover" role="tooltip"><div class="arrow"></div><h3 class="popover-title"></h3><div class="popover-content"></div></div>'
    });
    // NOTE: POPOVER EXTENDS tooltip.js
    // ================================
        o.prototype = r.extend({}, r.fn.tooltip.Constructor.prototype);
    o.prototype.constructor = o;
    o.prototype.getDefaults = function() {
        return o.DEFAULTS;
    };
    o.prototype.setContent = function() {
        var e = this.tip();
        var t = this.getTitle();
        var n = this.getContent();
        e.find(".popover-title")[this.options.html ? "html" : "text"](t);
        e.find(".popover-content").children().detach().end()[// we use append for html objects to maintain js events
        this.options.html ? typeof n == "string" ? "html" : "append" : "text"](n);
        e.removeClass("fade top bottom left right in");
        // IE8 doesn't accept hiding via the `:empty` pseudo selector, we have to do
        // this manually by checking the contents.
                if (!e.find(".popover-title").html()) e.find(".popover-title").hide();
    };
    o.prototype.hasContent = function() {
        return this.getTitle() || this.getContent();
    };
    o.prototype.getContent = function() {
        var e = this.$element;
        var t = this.options;
        return e.attr("data-content") || (typeof t.content == "function" ? t.content.call(e[0]) : t.content);
    };
    o.prototype.arrow = function() {
        return this.$arrow = this.$arrow || this.tip().find(".arrow");
    }
    // POPOVER PLUGIN DEFINITION
    // =========================
    ;
    function e(i) {
        return this.each(function() {
            var e = r(this);
            var t = e.data("bs.popover");
            var n = typeof i == "object" && i;
            if (!t && /destroy|hide/.test(i)) return;
            if (!t) e.data("bs.popover", t = new o(this, n));
            if (typeof i == "string") t[i]();
        });
    }
    var t = r.fn.popover;
    r.fn.popover = e;
    r.fn.popover.Constructor = o;
    // POPOVER NO CONFLICT
    // ===================
        r.fn.popover.noConflict = function() {
        r.fn.popover = t;
        return this;
    };
}(jQuery);

/* ========================================================================
 * Bootstrap: scrollspy.js v3.3.7
 * http://getbootstrap.com/javascript/#scrollspy
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */ +function(o) {
    "use strict";
    // SCROLLSPY CLASS DEFINITION
    // ==========================
        function r(e, t) {
        this.$body = o(document.body);
        this.$scrollElement = o(e).is(document.body) ? o(window) : o(e);
        this.options = o.extend({}, r.DEFAULTS, t);
        this.selector = (this.options.target || "") + " .nav li > a";
        this.offsets = [];
        this.targets = [];
        this.activeTarget = null;
        this.scrollHeight = 0;
        this.$scrollElement.on("scroll.bs.scrollspy", o.proxy(this.process, this));
        this.refresh();
        this.process();
    }
    r.VERSION = "3.3.7";
    r.DEFAULTS = {
        offset: 10
    };
    r.prototype.getScrollHeight = function() {
        return this.$scrollElement[0].scrollHeight || Math.max(this.$body[0].scrollHeight, document.documentElement.scrollHeight);
    };
    r.prototype.refresh = function() {
        var e = this;
        var i = "offset";
        var r = 0;
        this.offsets = [];
        this.targets = [];
        this.scrollHeight = this.getScrollHeight();
        if (!o.isWindow(this.$scrollElement[0])) {
            i = "position";
            r = this.$scrollElement.scrollTop();
        }
        this.$body.find(this.selector).map(function() {
            var e = o(this);
            var t = e.data("target") || e.attr("href");
            var n = /^#./.test(t) && o(t);
            return n && n.length && n.is(":visible") && [ [ n[i]().top + r, t ] ] || null;
        }).sort(function(e, t) {
            return e[0] - t[0];
        }).each(function() {
            e.offsets.push(this[0]);
            e.targets.push(this[1]);
        });
    };
    r.prototype.process = function() {
        var e = this.$scrollElement.scrollTop() + this.options.offset;
        var t = this.getScrollHeight();
        var n = this.options.offset + t - this.$scrollElement.height();
        var i = this.offsets;
        var r = this.targets;
        var o = this.activeTarget;
        var a;
        if (this.scrollHeight != t) {
            this.refresh();
        }
        if (e >= n) {
            return o != (a = r[r.length - 1]) && this.activate(a);
        }
        if (o && e < i[0]) {
            this.activeTarget = null;
            return this.clear();
        }
        for (a = i.length; a--; ) {
            o != r[a] && e >= i[a] && (i[a + 1] === undefined || e < i[a + 1]) && this.activate(r[a]);
        }
    };
    r.prototype.activate = function(e) {
        this.activeTarget = e;
        this.clear();
        var t = this.selector + '[data-target="' + e + '"],' + this.selector + '[href="' + e + '"]';
        var n = o(t).parents("li").addClass("active");
        if (n.parent(".dropdown-menu").length) {
            n = n.closest("li.dropdown").addClass("active");
        }
        n.trigger("activate.bs.scrollspy");
    };
    r.prototype.clear = function() {
        o(this.selector).parentsUntil(this.options.target, ".active").removeClass("active");
    }
    // SCROLLSPY PLUGIN DEFINITION
    // ===========================
    ;
    function t(i) {
        return this.each(function() {
            var e = o(this);
            var t = e.data("bs.scrollspy");
            var n = typeof i == "object" && i;
            if (!t) e.data("bs.scrollspy", t = new r(this, n));
            if (typeof i == "string") t[i]();
        });
    }
    var e = o.fn.scrollspy;
    o.fn.scrollspy = t;
    o.fn.scrollspy.Constructor = r;
    // SCROLLSPY NO CONFLICT
    // =====================
        o.fn.scrollspy.noConflict = function() {
        o.fn.scrollspy = e;
        return this;
    }
    // SCROLLSPY DATA-API
    // ==================
    ;
    o(window).on("load.bs.scrollspy.data-api", function() {
        o('[data-spy="scroll"]').each(function() {
            var e = o(this);
            t.call(e, e.data());
        });
    });
}(jQuery);

/* ========================================================================
 * Bootstrap: tab.js v3.3.7
 * http://getbootstrap.com/javascript/#tabs
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */ +function(s) {
    "use strict";
    // TAB CLASS DEFINITION
    // ====================
        var a = function(e) {
        // jscs:disable requireDollarBeforejQueryAssignment
        this.element = s(e);
        // jscs:enable requireDollarBeforejQueryAssignment
        };
    a.VERSION = "3.3.7";
    a.TRANSITION_DURATION = 150;
    a.prototype.show = function() {
        var e = this.element;
        var t = e.closest("ul:not(.dropdown-menu)");
        var n = e.data("target");
        if (!n) {
            n = e.attr("href");
            n = n && n.replace(/.*(?=#[^\s]*$)/, "");
 // strip for ie7
                }
        if (e.parent("li").hasClass("active")) return;
        var i = t.find(".active:last a");
        var r = s.Event("hide.bs.tab", {
            relatedTarget: e[0]
        });
        var o = s.Event("show.bs.tab", {
            relatedTarget: i[0]
        });
        i.trigger(r);
        e.trigger(o);
        if (o.isDefaultPrevented() || r.isDefaultPrevented()) return;
        var a = s(n);
        this.activate(e.closest("li"), t);
        this.activate(a, a.parent(), function() {
            i.trigger({
                type: "hidden.bs.tab",
                relatedTarget: e[0]
            });
            e.trigger({
                type: "shown.bs.tab",
                relatedTarget: i[0]
            });
        });
    };
    a.prototype.activate = function(e, t, n) {
        var i = t.find("> .active");
        var r = n && s.support.transition && (i.length && i.hasClass("fade") || !!t.find("> .fade").length);
        function o() {
            i.removeClass("active").find("> .dropdown-menu > .active").removeClass("active").end().find('[data-toggle="tab"]').attr("aria-expanded", false);
            e.addClass("active").find('[data-toggle="tab"]').attr("aria-expanded", true);
            if (r) {
                e[0].offsetWidth;
 // reflow for transition
                                e.addClass("in");
            } else {
                e.removeClass("fade");
            }
            if (e.parent(".dropdown-menu").length) {
                e.closest("li.dropdown").addClass("active").end().find('[data-toggle="tab"]').attr("aria-expanded", true);
            }
            n && n();
        }
        i.length && r ? i.one("bsTransitionEnd", o).emulateTransitionEnd(a.TRANSITION_DURATION) : o();
        i.removeClass("in");
    }
    // TAB PLUGIN DEFINITION
    // =====================
    ;
    function t(n) {
        return this.each(function() {
            var e = s(this);
            var t = e.data("bs.tab");
            if (!t) e.data("bs.tab", t = new a(this));
            if (typeof n == "string") t[n]();
        });
    }
    var e = s.fn.tab;
    s.fn.tab = t;
    s.fn.tab.Constructor = a;
    // TAB NO CONFLICT
    // ===============
        s.fn.tab.noConflict = function() {
        s.fn.tab = e;
        return this;
    }
    // TAB DATA-API
    // ============
    ;
    var n = function(e) {
        e.preventDefault();
        t.call(s(this), "show");
    };
    s(document).on("click.bs.tab.data-api", '[data-toggle="tab"]', n).on("click.bs.tab.data-api", '[data-toggle="pill"]', n);
}(jQuery);

/* ========================================================================
 * Bootstrap: affix.js v3.3.7
 * http://getbootstrap.com/javascript/#affix
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */ +function(l) {
    "use strict";
    // AFFIX CLASS DEFINITION
    // ======================
        var f = function(e, t) {
        this.options = l.extend({}, f.DEFAULTS, t);
        this.$target = l(this.options.target).on("scroll.bs.affix.data-api", l.proxy(this.checkPosition, this)).on("click.bs.affix.data-api", l.proxy(this.checkPositionWithEventLoop, this));
        this.$element = l(e);
        this.affixed = null;
        this.unpin = null;
        this.pinnedOffset = null;
        this.checkPosition();
    };
    f.VERSION = "3.3.7";
    f.RESET = "affix affix-top affix-bottom";
    f.DEFAULTS = {
        offset: 0,
        target: window
    };
    f.prototype.getState = function(e, t, n, i) {
        var r = this.$target.scrollTop();
        var o = this.$element.offset();
        var a = this.$target.height();
        if (n != null && this.affixed == "top") return r < n ? "top" : false;
        if (this.affixed == "bottom") {
            if (n != null) return r + this.unpin <= o.top ? false : "bottom";
            return r + a <= e - i ? false : "bottom";
        }
        var s = this.affixed == null;
        var l = s ? r : o.top;
        var f = s ? a : t;
        if (n != null && r <= n) return "top";
        if (i != null && l + f >= e - i) return "bottom";
        return false;
    };
    f.prototype.getPinnedOffset = function() {
        if (this.pinnedOffset) return this.pinnedOffset;
        this.$element.removeClass(f.RESET).addClass("affix");
        var e = this.$target.scrollTop();
        var t = this.$element.offset();
        return this.pinnedOffset = t.top - e;
    };
    f.prototype.checkPositionWithEventLoop = function() {
        setTimeout(l.proxy(this.checkPosition, this), 1);
    };
    f.prototype.checkPosition = function() {
        if (!this.$element.is(":visible")) return;
        var e = this.$element.height();
        var t = this.options.offset;
        var n = t.top;
        var i = t.bottom;
        var r = Math.max(l(document).height(), l(document.body).height());
        if (typeof t != "object") i = n = t;
        if (typeof n == "function") n = t.top(this.$element);
        if (typeof i == "function") i = t.bottom(this.$element);
        var o = this.getState(r, e, n, i);
        if (this.affixed != o) {
            if (this.unpin != null) this.$element.css("top", "");
            var a = "affix" + (o ? "-" + o : "");
            var s = l.Event(a + ".bs.affix");
            this.$element.trigger(s);
            if (s.isDefaultPrevented()) return;
            this.affixed = o;
            this.unpin = o == "bottom" ? this.getPinnedOffset() : null;
            this.$element.removeClass(f.RESET).addClass(a).trigger(a.replace("affix", "affixed") + ".bs.affix");
        }
        if (o == "bottom") {
            this.$element.offset({
                top: r - e - i
            });
        }
    }
    // AFFIX PLUGIN DEFINITION
    // =======================
    ;
    function n(i) {
        return this.each(function() {
            var e = l(this);
            var t = e.data("bs.affix");
            var n = typeof i == "object" && i;
            if (!t) e.data("bs.affix", t = new f(this, n));
            if (typeof i == "string") t[i]();
        });
    }
    var e = l.fn.affix;
    l.fn.affix = n;
    l.fn.affix.Constructor = f;
    // AFFIX NO CONFLICT
    // =================
        l.fn.affix.noConflict = function() {
        l.fn.affix = e;
        return this;
    }
    // AFFIX DATA-API
    // ==============
    ;
    l(window).on("load", function() {
        l('[data-spy="affix"]').each(function() {
            var e = l(this);
            var t = e.data();
            t.offset = t.offset || {};
            if (t.offsetBottom != null) t.offset.bottom = t.offsetBottom;
            if (t.offsetTop != null) t.offset.top = t.offsetTop;
            n.call(e, t);
        });
    });
}(jQuery);

(function(e) {
    "use strict";
    var t = {
        version: "3.57.2"
    };
    // definition of breakpoint sizes for tablet and desktop modes
        t.pfBreakpoints = {
        tablet: 768,
        desktop: 1200
    };
    e.patternfly = t;
})(typeof window !== "undefined" ? window : global);

(function(e) {
    "use strict";
    // Ensure we are assigning these to the patternfly property of the window argument, and not the implicit global patternfly
        var t = e.patternfly;
    // Util: PatternFly Palette colors
        t.pfPaletteColors = {
        black: "#030303",
        black100: "#fafafa",
        black200: "#ededed",
        black300: "#d1d1d1",
        black400: "#bbbbbb",
        black500: "#8b8d8f",
        black600: "#72767b",
        black700: "#4d5258",
        black800: "#393f44",
        black900: "#292e34",
        blue: "#0088ce",
        blue100: "#bee1f4",
        blue200: "#7dc3e8",
        blue300: "#39a5dc",
        blue400: "#0088ce",
        blue500: "#00659c",
        blue600: "#004368",
        blue700: "#002235",
        gold: "#f0ab00",
        gold100: "#fbeabc",
        gold200: "#f9d67a",
        gold300: "#f5c12e",
        gold400: "#f0ab00",
        gold500: "#b58100",
        gold600: "#795600",
        gold700: "#3d2c00",
        orange: "#ec7a08",
        orange100: "#fbdebf",
        orange200: "#f7bd7f",
        orange300: "#f39d3c",
        orange400: "#ec7a08",
        orange500: "#b35c00",
        orange600: "#773d00",
        orange700: "#3b1f00",
        lightBlue: "#00b9e4",
        lightBlue100: "#beedf9",
        lightBlue200: "#7cdbf3",
        lightBlue300: "#35caed",
        lightBlue400: "#00b9e4",
        lightBlue500: "#008bad",
        lightBlue600: "#005c73",
        lightBlue700: "#002d39",
        green: "#3f9c35",
        green100: "#cfe7cd",
        green200: "#9ecf99",
        green300: "#6ec664",
        green400: "#3f9c35",
        green500: "#2d7623",
        green600: "#1e4f18",
        green700: "#0f280d",
        lightGreen: "#92d400",
        lightGreen100: "#e4f5bc",
        lightGreen200: "#c8eb79",
        lightGreen300: "#ace12e",
        lightGreen400: "#92d400",
        lightGreen500: "#6ca100",
        lightGreen600: "#486b00",
        lightGreen700: "#253600",
        cyan: "#007a87",
        cyan100: "#bedee1",
        cyan200: "#7dbdc3",
        cyan300: "#3a9ca6",
        cyan400: "#007a87",
        cyan500: "#005c66",
        cyan600: "#003d44",
        cyan700: "#001f22",
        purple: "#703fec",
        purple100: "#c7bfff",
        purple200: "#a18fff",
        purple300: "#8461f7",
        purple400: "#703fec",
        purple500: "#582fc0",
        purple600: "#40199a",
        purple700: "#1f0066",
        red: "#cc0000",
        red100: "#cc0000",
        red200: "#a30000",
        red300: "#8b0000",
        red400: "#470000",
        red500: "#2c0000"
    };
})(typeof window !== "undefined" ? window : global);

(function(r) {
    "use strict";
    // Ensure we are assigning these to the patternfly property of the window argument, and not the implicit global patternfly
        var V = r.patternfly;
    // Util: PatternFly C3 Chart Defaults
        V.pfSetDonutChartTitle = function(e, t, n) {
        var i = r.d3.select(e).select("text.c3-chart-arcs-title");
        i.text("");
        i.insert("tspan").text(t).classed("donut-title-big-pf", true).attr("dy", 0).attr("x", 0);
        i.insert("tspan").text(n).classed("donut-title-small-pf", true).attr("dy", 20).attr("x", 0);
    };
    V.pfDonutTooltipContents = function(e, t, n, i) {
        return '<table class="c3-tooltip">' + "  <tr>" + '    <td><span style="background-color:' + i(e[0].id) + '"></span>' + "<strong>" + e[0].value + "</strong> " + e[0].name + "</td>" + "    <td>" + Math.round(e[0].ratio * 1e3) / 10 + "%</td>" + "  </tr>" + "</table>";
    };
    V.pfGetUtilizationDonutTooltipContentsFn = function(t) {
        return function(e) {
            return '<span class="donut-tooltip-pf" style="white-space: nowrap;">' + Math.round(e[0].ratio * 1e3) / 10 + "%" + " " + t + " " + e[0].name + "</span>";
        };
    };
    V.pfGetBarChartTooltipContentsFn = function(n) {
        return function(e) {
            var t = n ? n[e[0].index] : e[0].index;
            return '<table class="c3-tooltip">' + "  <tr>" + "    <td><strong>" + t + ":</td>" + "    <td>" + e[0].value + "</td>" + "  </tr>" + "</table>";
        };
    };
    V.pfSingleLineChartTooltipContentsFn = function(n) {
        return function(e) {
            var t = n ? n[e[0].index] : e[0].index;
            return '<table class="c3-tooltip">' + "  <tr>" + "    <td><strong>" + t + ":</td>" + "    <td>" + e[0].value + "</td>" + "  </tr>" + "</table>";
        };
    };
    V.pfPieTooltipContents = function(e, t, n, i) {
        return V.pfDonutTooltipContents(e, t, n, i);
    };
    V.c3ChartDefaults = function() {
        var e = function() {
            return {
                pattern: [ V.pfPaletteColors.blue, V.pfPaletteColors.blue300, V.pfPaletteColors.green, V.pfPaletteColors.orange, V.pfPaletteColors.red ]
            };
        }, t = function() {
            return {
                y: {
                    show: true
                }
            };
        }, n = function(e) {
            return {
                contents: V.pfGetBarChartTooltipContentsFn(e)
            };
        }, i = function() {
            return {
                show: false
            };
        }, r = function(e) {
            return {
                color: this.getDefaultColors(),
                grid: this.getDefaultBarGrid(),
                tooltip: this.getDefaultBarTooltip(e),
                legend: this.getDefaultBarLegend()
            };
        }, o = function() {
            return {
                y: {
                    show: true
                }
            };
        }, a = function() {
            return {
                show: true,
                position: "bottom"
            };
        }, s = function() {
            return {
                color: this.getDefaultColors(),
                grid: this.getDefaultGroupedBarGrid(),
                legend: this.getDefaultGroupedBarLegend()
            };
        }, l = function() {
            return {
                y: {
                    show: true
                }
            };
        }, f = function() {
            return {
                show: true,
                position: "bottom"
            };
        }, u = function() {
            return {
                color: this.getDefaultColors(),
                grid: this.getDefaultStackedBarGrid(),
                legend: this.getDefaultStackedBarLegend()
            };
        }, c = function(e) {
            return {
                title: e,
                label: {
                    show: false
                },
                width: 11
            };
        }, d = function() {
            return {
                height: 171
            };
        }, p = function() {
            return {
                pattern: [ V.pfPaletteColors.blue, V.pfPaletteColors.black300 ]
            };
        }, h = function() {
            return {
                pattern: [ V.pfPaletteColors.blue, V.pfPaletteColors.red100, V.pfPaletteColors.orange400, V.pfPaletteColors.green400, V.pfPaletteColors.cyan500, V.pfPaletteColors.gold200 ]
            };
        }, g = function() {
            return {
                show: false
            };
        }, v = function() {
            return {
                show: false
            };
        }, m = function(e) {
            return {
                donut: this.getDefaultDonut(e),
                size: this.getDefaultDonutSize(),
                legend: this.getDefaultDonutLegend(),
                color: this.getDefaultDonutColors(),
                tooltip: this.getDefaultDonutTooltip()
            };
        }, y = function(e) {
            return {
                donut: this.getDefaultDonut(e),
                size: this.getDefaultDonutSize(),
                legend: this.getDefaultDonutLegend(),
                color: this.getDefaultRelationshipDonutColors(),
                tooltip: this.getDefaultDonutTooltip()
            };
        }, b = function() {
            return {
                expand: true,
                label: {
                    show: false
                }
            };
        }, w = function() {
            return {
                height: 171
            };
        }, x = function() {
            return {
                pattern: [ V.pfPaletteColors.blue, V.pfPaletteColors.black300 ]
            };
        }, C = function() {
            return {
                contents: V.pfPieTooltipContents
            };
        }, T = function() {
            return {
                show: false
            };
        }, D = function() {
            return {
                pie: this.getDefaultPie(),
                size: this.getDefaultPieSize(),
                legend: this.getDefaultPieLegend(),
                color: this.getDefaultPieColors(),
                tooltip: this.getDefaultPieTooltip()
            };
        }, k = function() {
            return {
                zerobased: true
            };
        }, S = function() {
            return {
                height: 60
            };
        }, E = function() {
            return {
                x: {
                    show: false
                },
                y: {
                    show: false
                }
            };
        }, $ = function() {
            return {
                show: false
            };
        }, A = function() {
            return {
                r: 1,
                focus: {
                    expand: {
                        r: 4
                    }
                }
            };
        }, N = function() {
            return {
                // because a sparkline should only contain a single data column,
                // the tooltip will only work for a single data column
                contents: function(e) {
                    return '<span class="c3-tooltip-sparkline">' + e[0].value + " " + e[0].name + "</span>";
                }
            };
        }, j = function() {
            return {
                area: k(),
                size: S(),
                axis: E(),
                color: e(),
                legend: $(),
                point: A(),
                tooltip: N()
            };
        }, L = function() {
            return {
                x: {
                    show: true
                },
                y: {
                    show: true
                }
            };
        }, I = function() {
            return {
                x: {
                    show: false
                },
                y: {
                    show: true
                }
            };
        }, P = function() {
            return {
                show: true
            };
        }, O = function() {
            return {
                r: 3,
                focus: {
                    expand: {
                        r: 5
                    }
                }
            };
        }, R = function() {
            return {
                axis: L(),
                grid: I(),
                color: e(),
                legend: P(),
                point: O()
            };
        }, H = function() {
            return {
                contents: V.pfGetBarChartTooltipContentsFn()
            };
        }, q = function() {
            return {
                show: false
            };
        }, B = function() {
            return {
                axis: L(),
                grid: I(),
                color: e(),
                legend: q(),
                point: O(),
                tooltip: H()
            };
        }, M = function() {
            return L();
        }, _ = function() {
            return I();
        }, F = function() {
            return P();
        }, U = function() {
            return O();
        }, W = function() {
            return {
                axis: M(),
                grid: _(),
                color: e(),
                legend: F(),
                point: U()
            };
        }, z = function() {
            return {
                contents: V.pfGetBarChartTooltipContentsFn()
            };
        }, G = function() {
            return q();
        }, Q = function() {
            return {
                axis: M(),
                grid: _(),
                color: e(),
                legend: G(),
                point: U(),
                tooltip: z()
            };
        };
        return {
            getDefaultColors: e,
            getDefaultBarGrid: t,
            getDefaultBarTooltip: n,
            getDefaultBarLegend: i,
            getDefaultBarConfig: r,
            getDefaultGroupedBarGrid: o,
            getDefaultGroupedBarLegend: a,
            getDefaultGroupedBarConfig: s,
            getDefaultStackedBarGrid: l,
            getDefaultStackedBarLegend: f,
            getDefaultStackedBarConfig: u,
            getDefaultDonut: c,
            getDefaultDonutSize: d,
            getDefaultDonutColors: p,
            getDefaultDonutTooltip: g,
            getDefaultDonutLegend: v,
            getDefaultDonutConfig: m,
            getDefaultRelationshipDonutConfig: y,
            getDefaultPie: b,
            getDefaultPieSize: w,
            getDefaultPieColors: x,
            getDefaultRelationshipDonutColors: h,
            getDefaultPieTooltip: C,
            getDefaultPieLegend: T,
            getDefaultPieConfig: D,
            getDefaultSparklineArea: k,
            getDefaultSparklineSize: S,
            getDefaultSparklineAxis: E,
            getDefaultSparklineLegend: $,
            getDefaultSparklinePoint: A,
            getDefaultSparklineTooltip: N,
            getDefaultSparklineConfig: j,
            getDefaultLineAxis: L,
            getDefaultLineGrid: I,
            getDefaultLineLegend: P,
            getDefaultLinePoint: O,
            getDefaultLineConfig: R,
            getDefaultSingleLineTooltip: H,
            getDefaultSingleLineConfig: B,
            getDefaultAreaAxis: M,
            getDefaultAreaGrid: _,
            getDefaultAreaLegend: F,
            getDefaultAreaPoint: U,
            getDefaultAreaConfig: W,
            getDefaultSingleAreaTooltip: z,
            getDefaultSingleAreaConfig: Q
        };
    };
})(typeof window !== "undefined" ? window : global);

// Util: definition of breakpoint sizes for tablet and desktop modes
// Util: definition of breakpoint sizes for tablet and desktop modes
(function(e) {
    "use strict";
    if (patternfly !== undefined) {
        e.pfBreakpoints = patternfly.pfBreakpoints;
    }
})(jQuery);

// PatternFly pf-list
// PatternFly pf-list
(function(l) {
    "use strict";
    l.fn.pfList = function() {
        function e(e) {
            // Ensure the state of the expansion elements is consistent
            e.find("[data-list=expansion], .list-pf-item, .list-pf-expansion").each(function(e, t) {
                var n = l(t), i = n.find(".collapse").first(), r = i.hasClass("in");
                s(n, r);
                if (n.hasClass("list-pf-item")) {
                    a(n, r);
                }
            });
            e.find(".list-pf-container").each(function(e, t) {
                var n = l(t);
                // The toggle element is the element with the data-list=toggle attribute
                // or the entire .list-pf-container as a fallback
                                var i = n.find("[data-list=toggle]");
                i.length || (i = n);
                i.on("keydown", function(e) {
                    if (e.keyCode === 13 || e.keyCode === 32) {
                        r(this);
                        e.stopPropagation();
                        e.preventDefault();
                    }
                });
                i.on("click", function(e) {
                    r(this);
                    e.stopPropagation();
                    e.preventDefault();
                });
            });
        }
        function r(e) {
            var t, n, i, r, o;
            t = l(e);
            // Find the parent expansion of the toggle
                        n = t.parentsUntil(".list-pf", "[data-list=expansion]").first();
            n.length || (n = t.closest(".list-pf-item, .list-pf-expansion"));
            // toggle the "in" class of its  first .collapse child
                        i = n.find(".collapse").first();
            i.toggleClass("in");
            // update the state of the expansion element
                        s(n, i.hasClass("in"));
            o = n.closest(".list-pf-item");
            a(o, o.find(".collapse").first().hasClass("in"));
        }
        function a(e, t) {
            // Find the closest .list-pf-item of the expansion, and set its "active" class
            if (t) {
                e.addClass("active");
            } else {
                e.removeClass("active");
            }
        }
        function s(e, t) {
            var n = e.find(".list-pf-chevron .fa").first();
            if (t) {
                n.removeClass("fa-angle-right");
                n.addClass("fa-angle-down");
            } else {
                n.addClass("fa-angle-right");
                n.removeClass("fa-angle-down");
            }
        }
        e(this);
        return this;
    };
})(jQuery);

// Util: PatternFly Sidebar
// Set height of sidebar-pf to height of document minus height of navbar-pf if not mobile
// Util: PatternFly Sidebar
// Set height of sidebar-pf to height of document minus height of navbar-pf if not mobile
(function(i) {
    "use strict";
    i.fn.sidebar = function() {
        var e = 0, t = 0, n = 0;
        if (i(".navbar-pf .navbar-toggle").is(":hidden")) {
            e = i(document).height();
            t = i(".navbar-pf").outerHeight();
            n = e - t;
        }
        i(".sidebar-pf").parent(".row").children('[class*="col-"]').css({
            "min-height": n
        });
    };
    i(document).ready(function() {
        // Call sidebar() on ready if .sidebar-pf exists and .datatable does not exist
        if (i(".sidebar-pf").length > 0 && i(".datatable").length === 0) {
            i.fn.sidebar();
        }
    });
    i(window).on("resize", function() {
        // Call sidebar() on resize if .sidebar-pf exists
        if (i(".sidebar-pf").length > 0) {
            i.fn.sidebar();
        }
    });
})(jQuery);

// Util: PatternFly Popovers
// Add data-close="true" to insert close X icon
// Util: PatternFly Popovers
// Add data-close="true" to insert close X icon
(function(r) {
    "use strict";
    r.fn.popovers = function() {
        // Initialize
        this.popover();
        // Add close icons
                this.filter("[data-close=true]").each(function(e, t) {
            var n = r(t), i = n.attr("data-original-title") + '<button type="button" class="close" aria-hidden="true"><span class="pficon pficon-close"></span></button>';
            n.attr("data-original-title", i);
        });
        // Bind Close Icon to Toggle Display
                this.on("click", function(e) {
            var t = r(this), n = t.next(".popover").find(".popover-title");
            // Only if data-close is true add class "x" to title for right padding
                        n.find(".close").parent(".popover-title").addClass("closable");
            // Bind x icon to close popover
                        n.find(".close").on("click", function() {
                t.popover("hide");
            });
            // Prevent href="#" page scroll to top
                        e.preventDefault();
        });
        return this;
    };
})(jQuery);

// Util: DataTables Settings
// Util: DataTables Settings
(function(l) {
    "use strict";
    if (l.fn.dataTableExt) {
        /* Set the defaults for DataTables initialisation */
        l.extend(true, l.fn.dataTable.defaults, {
            bDestroy: true,
            bAutoWidth: false,
            iDisplayLength: 20,
            sDom: "<'dataTables_header' f i r >" + "<'table-responsive'  t >" + "<'dataTables_footer' p >",
            oLanguage: {
                sInfo: "Showing <b>_START_</b> to <b>_END_</b> of <b>_TOTAL_</b> Items",
                sInfoFiltered: "(of <b>_MAX_</b>)",
                sInfoEmpty: "Showing <b>0</b> Results",
                sZeroRecords: "<p>Suggestions</p>" + "<ul>" + "<li>Check the javascript regular expression syntax of the search term.</li>" + "<li>Check that the correct menu option is chosen (token ID vs. user ID).</li>" + "<li>Use wildcards (* to match 0 or more characters, + to match 1 or more characters, ? to match 0 or 1 character).</li>" + "<li>Clear the search field, then click Search to return to the 20 most recent records.</li>" + "</ul>",
                sSearch: ""
            },
            sPaginationType: "bootstrap_input",
            oSearch: {
                sSearch: "",
                bRegex: true,
                bSmart: false
            }
        });
        /* Default class modification */        l.extend(l.fn.dataTableExt.oStdClasses, {
            sWrapper: "dataTables_wrapper"
        });
        /* API method to get paging information */        l.fn.dataTableExt.oApi.fnPagingInfo = function(e) {
            return {
                iStart: e._iDisplayStart,
                iEnd: e.fnDisplayEnd(),
                iLength: e._iDisplayLength,
                iTotal: e.fnRecordsTotal(),
                iFilteredTotal: e.fnRecordsDisplay(),
                iPage: e._iDisplayLength === -1 ? 0 : Math.ceil(e._iDisplayStart / e._iDisplayLength),
                iTotalPages: e._iDisplayLength === -1 ? 0 : Math.ceil(e.fnRecordsDisplay() / e._iDisplayLength)
            };
        };
        /* Combination of Bootstrap + Input Text style pagination control */        l.extend(l.fn.dataTableExt.oPagination, {
            bootstrap_input: {
                fnInit: function(n, e, i) {
                    var t = function(e) {
                        e.preventDefault();
                        if (n.oApi._fnPageChange(n, e.data.action)) {
                            i(n);
                        }
                    }, r, o;
                    l(e).append('<ul class="pagination">' + '  <li class="first disabled"><span class="i fa fa-angle-double-left"></span></li>' + '  <li class="prev disabled"><span class="i fa fa-angle-left"></span></li>' + "</ul>" + '<div class="pagination-input">' + '  <input type="text" class="paginate_input">' + '  <span class="paginate_of">of <b>3</b></span>' + "</div>" + '<ul class="pagination">' + '  <li class="next disabled"><span class="i fa fa-angle-right"></span></li>' + '  <li class="last disabled"><span class="i fa fa-angle-double-right"></span></li>' + "</ul>");
                    r = l("li", e);
                    l(r[0]).bind("click.DT", {
                        action: "first"
                    }, t);
                    l(r[1]).bind("click.DT", {
                        action: "previous"
                    }, t);
                    l(r[2]).bind("click.DT", {
                        action: "next"
                    }, t);
                    l(r[3]).bind("click.DT", {
                        action: "last"
                    }, t);
                    o = l("input", e);
                    l(o).keyup(function(e) {
                        var t;
                        if (e.which === 38 || e.which === 39) {
                            this.value += 1;
                        } else if ((e.which === 37 || e.which === 40) && this.value > 1) {
                            this.value -= 1;
                        }
                        if (this.value === "" || !this.value.match(/[0-9]/)) {
                            /* Nothing entered or non-numeric character */
                            return;
                        }
                        t = n._iDisplayLength * (this.value - 1);
                        if (t >= n.fnRecordsDisplay()) {
                            /* Display overrun */
                            n._iDisplayStart = (Math.ceil((n.fnRecordsDisplay() - 1) / n._iDisplayLength) - 1) * n._iDisplayLength;
                            i(n);
                            return;
                        }
                        n._iDisplayStart = t;
                        i(n);
                    });
                },
                fnUpdate: function(e, t) {
                    var n = e.oInstance.fnPagingInfo(), i = e.aanFeatures.p, r = i.length, o = Math.ceil(e.fnRecordsDisplay() / e._iDisplayLength), a = Math.ceil(e._iDisplayStart / e._iDisplayLength) + 1, s;
                    for (s = 0; s < r; s += 1) {
                        l(".paginate_input", i[s]).val(a).siblings(".paginate_of").find("b").html(o);
                        // Add / remove disabled classes from the static elements
                                                if (n.iPage === 0) {
                            l("li.first", i[s]).addClass("disabled");
                            l("li.prev", i[s]).addClass("disabled");
                        } else {
                            l("li.first", i[s]).removeClass("disabled");
                            l("li.prev", i[s]).removeClass("disabled");
                        }
                        if (n.iPage === n.iTotalPages - 1 || n.iTotalPages === 0) {
                            l("li.next", i[s]).addClass("disabled");
                            l("li.last", i[s]).addClass("disabled");
                        } else {
                            l("li.next", i[s]).removeClass("disabled");
                            l("li.last", i[s]).removeClass("disabled");
                        }
                    }
                }
            }
        });
    }
})(jQuery);

// Util: PatternFly Collapsible Left Hand Navigation
// Must have navbar-toggle in navbar-pf-alt for expand/collapse
// Util: PatternFly Collapsible Left Hand Navigation
// Must have navbar-toggle in navbar-pf-alt for expand/collapse
(function(c) {
    "use strict";
    c.fn.navigation = function() {
        var n = c(".layout-pf-alt-fixed .nav-pf-vertical-alt"), i = c(".container-pf-alt-nav-pf-vertical-alt"), e = c(".navbar-toggle"), t = false, r = function() {
            var e = c(window).width();
            //Always remove the hidden & peek class
                        n.removeClass("hidden show-mobile-nav collapsed");
            //Set the body class back to the default
                        i.removeClass("collapsed-nav hidden-nav");
            // Check to see if the nav needs to collapse
                        if (e < c.pfBreakpoints.desktop || t) {
                n.addClass("collapsed");
                i.addClass("collapsed-nav");
            }
            // Check to see if we need to move down to the mobile state
                        if (e < c.pfBreakpoints.tablet) {
                //Set the nav to being hidden
                n.addClass("hidden");
                //Make sure this is expanded
                                n.removeClass("collapsed");
                //Set the body class to the correct state
                                i.removeClass("collapsed-nav");
                i.addClass("hidden-nav");
            }
        }, o = function() {
            //Make sure this is expanded
            n.addClass("collapsed");
            //Set the body class to the correct state
                        i.addClass("collapsed-nav");
            t = true;
        }, a = function() {
            // enable transitions only when toggleNavBarButton is clicked or window is resized
            c("html").addClass("transitions");
        }, s = function() {
            //Make sure this is expanded
            n.removeClass("collapsed");
            //Set the body class to the correct state
                        i.removeClass("collapsed-nav");
            t = false;
        }, l = function() {
            e.on("click", function(e) {
                var t = i.hasClass("hidden-nav");
                a();
                if (t && n.hasClass("show-mobile-nav")) {
                    //In mobile state just need to hide the nav
                    n.removeClass("show-mobile-nav");
                } else if (t) {
                    n.addClass("show-mobile-nav");
                } else if (n.hasClass("collapsed")) {
                    s();
                } else {
                    o();
                }
            });
        }, f = function() {
            c('.nav-pf-vertical-alt [data-toggle="tooltip"]').tooltip({
                container: "body",
                delay: {
                    show: "500",
                    hide: "200"
                }
            });
            c(".nav-pf-vertical-alt").on("show.bs.tooltip", function(e) {
                return c(this).hasClass("collapsed");
            });
        }, u = function() {
            //Set correct state on load
            r();
            // Bind Top level hamburger menu with menu behavior;
                        l();
            //Set tooltips
                        f();
        };
        //Listen for the window resize event and collapse/hide as needed
                c(window).on("resize", function() {
            r();
            a();
        });
        u();
    };
    c(document).ready(function() {
        if (c(".nav-pf-vertical-alt").length > 0) {
            c.fn.navigation();
        }
    });
})(jQuery);

// Count and Display Remaining Characters
// Count and Display Remaining Characters
(function(t) {
    "use strict";
    t.fn.countRemainingChars = function(e) {
        var n = t.extend({
            // These are the defaults.
            charsMaxLimit: 100,
            charsWarnRemaining: 5,
            blockInputAtMaxLimit: false
        }, e), i = this, r = t("#" + n.countFld).text(n.charsMaxLimit), o = function(e) {
            var t = n.charsMaxLimit - e;
            r.text(t);
            r.toggleClass("chars-warn-remaining-pf", t <= n.charsWarnRemaining);
            if (t < 0) {
                i.trigger("overCharsMaxLimitEvent", i.attr("id"));
            } else {
                i.trigger("underCharsMaxLimitEvent", i.attr("id"));
            }
        };
        this.on("paste", function(e) {
            setTimeout(function() {
                var e = i.val().length, t;
                if (n.blockInputAtMaxLimit && e > n.charsMaxLimit) {
                    t = i.val();
                    t = t.substring(0, n.charsMaxLimit);
                    i.val(t);
                    e = i.val().length;
                }
                o(e);
            }, 100);
        });
        this.keyup(function(e) {
            o(i.val().length);
        });
        this.keydown(function(e) {
            var t = i.val().length;
            if (n.blockInputAtMaxLimit && t >= n.charsMaxLimit) {
                // Except backspace
                if (e.keyCode !== 8) {
                    e.preventDefault();
                }
            }
        });
        return this;
    };
})(jQuery);

// Util: PatternFly Palette colors
// Util: PatternFly Palette colors
(function(e) {
    "use strict";
    if (patternfly !== undefined) {
        e.pfPaletteColors = patternfly.pfPaletteColors;
    }
})(jQuery);

// Util: PatternFly C3 Chart Defaults
// Util: PatternFly C3 Chart Defaults
(function(e) {
    "use strict";
    if (patternfly !== undefined) {
        e.fn.pfSetDonutChartTitle = patternfly.pfSetDonutChartTitle;
        e.fn.pfDonutTooltipContents = patternfly.pfDonutTooltipContents;
        e.fn.pfGetUtilizationDonutTooltipContentsFn = patternfly.pfGetUtilizationDonutTooltipContentsFn;
        e.fn.pfGetBarChartTooltipContentsFn = patternfly.pfGetBarChartTooltipContentsFn;
        e.fn.pfSingleLineChartTooltipContentsFn = patternfly.pfSingleLineChartTooltipContentsFn;
        e.fn.pfPieTooltipContents = patternfly.pfPieTooltipContents;
        e.fn.c3ChartDefaults = patternfly.c3ChartDefaults;
    }
})(jQuery);

// Util: PatternFly Collapse with fixed heights
// Update the max-height of collapse elements based on the parent container's height.
// Util: PatternFly Collapse with fixed heights
// Update the max-height of collapse elements based on the parent container's height.
(function(f) {
    "use strict";
    f.fn.initCollapseHeights = function(e) {
        var r = this, t, l = e;
        t = function() {
            var e, t, i, s, n = "hidden";
            e = r.height();
            // Close any open panel
                        t = r.find(".collapse.in");
            if (t && t.length > 0) {
                t.removeClass("in");
            }
            // Determine the necessary height for the closed content
                        i = 0;
            r.children().each(f.proxy(function(e, t) {
                var n = f(t);
                i += n.outerHeight(true);
            }, r)).end();
            // Determine the height remaining for opened collapse panels
                        s = e - i;
            // Make sure we have enough height to be able to scroll the contents if necessary
                        if (s < 25) {
                s = 25;
                // Allow the parent to scroll so the child elements are accessible
                                n = "auto";
            }
            // Reopen the initially opened panel
                        if (t && t.length > 0) {
                t.addClass("in");
            }
            setTimeout(function() {
                // Set the max-height for the collapse panels
                r.find('[data-toggle="collapse"]').each(f.proxy(function(e, t) {
                    var n, i, r, o, a = 0;
                    n = f(t);
                    // Determine the selector to find the target
                                        i = n.attr("data-target");
                    if (!i) {
                        i = n.attr("href");
                    }
                    // Determine the scroll element (either the target or the child of the target based on the given selector)
                                        r = f(i);
                    o = r;
                    if (l) {
                        o = r.find(l);
                        if (o.length === 1) {
                            a = 0;
                            r.children().each(f.proxy(function(e, t) {
                                var n = f(t);
                                if (t !== o[0]) {
                                    a += n.outerHeight(true);
                                }
                            }, r)).end();
                            s -= a;
                        } else {
                            o = r;
                        }
                    }
                    // Set the max-height and vertical scroll of the scroll element
                                        o.css({
                        "max-height": s - a + "px",
                        "overflow-y": "auto"
                    });
                }, r)).end();
                r.css({
                    "overflow-y": n
                });
            }, 100);
        };
        t();
        // Update on window resizing
                f(window).on("resize", t);
    };
    f.fn.initFixedAccordion = function() {
        var e = this, t;
        e.on("show.bs.collapse", ".collapse", function(e) {
            f(e.target.parentNode).addClass("panel-open");
        });
        e.on("hide.bs.collapse", ".collapse", function(e) {
            f(e.target.parentNode).removeClass("panel-open");
        });
        e.find(".panel").each(function(e, t) {
            f(t).removeClass("panel-open");
        });
        t = f(e.find(".collapse.in"))[0];
        if (t) {
            f(t.parentNode).addClass("panel-open");
        }
    };
})(jQuery);

// Util: PatternFly TreeGrid Tables
// Util: PatternFly TreeGrid Tables
(function(a) {
    "use strict";
    function s(e, t) {
        var n = t.attr("data-parent");
        if (typeof n === "string") {
            if (isNaN(n)) {
                n = a(n);
                if (n.length > 1) {
                    n = e.closest(n);
                }
            } else {
                n = a(e[parseInt(n, 10)]);
            }
            return n;
        }
        return undefined;
    }
    function l(e, t) {
        if (t) {
            t.find(".treegrid-node > span.expand-icon").toggleClass("fa-angle-right", t.hasClass("collapsed")).toggleClass("fa-angle-down", !t.hasClass("collapsed"));
            e.toggleClass("hidden", t.hasClass("collapsed"));
            if (t.hasClass("collapsed")) {
                e.addClass("collapsed");
            }
        }
    }
    function f(e) {
        e.find("tbody > tr").removeClass("odd");
        e.find("tbody > tr:not(.hidden):odd").addClass("odd");
    }
    a.fn.treegrid = function(i) {
        var t, r, o;
        r = this.find("tbody > tr");
        o = this;
        a.each(r, function() {
            var n, e;
            n = a(this);
            e = s(r, n);
            // Append expand icon dummies
                        n.children(".treegrid-node").prepend('<span class="icon expand-icon fa"/>');
            // Set up an event listener for the node
                        n.children(".treegrid-node").on("click", function(e) {
                var t = n.find("span.expand-icon");
                if (i && typeof i.callback === "function") {
                    i.callback(e);
                }
                if (t.hasClass("fa-angle-right")) {
                    n.removeClass("collapsed");
                }
                if (t.hasClass("fa-angle-down")) {
                    n.addClass("collapsed");
                }
                a.each(r.slice(r.index(n) + 1), function() {
                    l(a(this), s(r, a(this)));
                });
                f(o);
            });
            if (e) {
                // Calculate indentation depth
                t = e.find(".treegrid-node > span.indent").length + 1;
                for (;t > 0; t -= 1) {
                    n.children(".treegrid-node").prepend('<span class="indent"/>');
                }
                // Render expand/collapse icons
                                l(n, e);
            }
        });
        f(o);
    };
})(jQuery);

// Util: PatternFly Vertical Navigation
// Must have navbar-toggle in navbar-pf-vertical for expand/collapse
// Util: PatternFly Vertical Navigation
// Must have navbar-toggle in navbar-pf-vertical for expand/collapse
(function(P) {
    "use strict";
    P.fn.setupVerticalNavigation = function(e, n, t) {
        var r = P.extend({
            hoverDelay: 500,
            hideDelay: 700,
            rememberOpenState: true,
            storage: "localStorage"
        }, t || {}), s = P(".nav-pf-vertical"), i = P(".container-pf-nav-pf-vertical"), o = P(".navbar-toggle"), a = true, l = false, f = false, u = r.storage === "sessionStorage" ? "sessionStorage" : "localStorage", c = function() {
            return i.hasClass("hidden-nav");
        }, d = function(e) {
            setTimeout(function() {
                P(window).trigger("resize");
            }, e);
        }, p = function() {
            if (c() || !f) {
                s.addClass("secondary-visible-pf");
                i.addClass("secondary-visible-pf");
            }
            // Dispatch a resize event when showing the secondary menu in non-subdesktop state to
            // allow content to adjust to the secondary menu sizing
                        if (!f) {
                d(100);
            }
        }, h = function() {
            s.removeClass("secondary-visible-pf");
            i.removeClass("secondary-visible-pf");
            if (s.find(".secondary-nav-item-pf.is-hover").length <= 1) {
                s.removeClass("hover-secondary-nav-pf");
            }
            s.find(".mobile-nav-item-pf").each(function(e, t) {
                P(t).removeClass("mobile-nav-item-pf");
            });
            s.find(".is-hover").each(function(e, t) {
                P(t).removeClass("is-hover");
            });
        }, g = function() {
            s.removeClass("tertiary-visible-pf");
            i.removeClass("tertiary-visible-pf");
            if (s.find(".tertiary-nav-item-pf.is-hover").length <= 1) {
                s.removeClass("hover-tertiary-nav-pf");
            }
            s.find(".mobile-nav-item-pf").each(function(e, t) {
                P(t).removeClass("mobile-nav-item-pf");
            });
            s.find(".is-hover").each(function(e, t) {
                P(t).removeClass("is-hover");
            });
        }, v = function(e) {
            // remove all .active
            P(".nav-pf-vertical .list-group-item.active").removeClass("active");
            // add .active to item and its parents
                        e.addClass("active").parents(".list-group-item").addClass("active");
        }, m = function() {
            if (c()) {
                s.removeClass("show-mobile-nav");
                h();
                s.find(".mobile-nav-item-pf").each(function(e, t) {
                    P(t).removeClass("mobile-nav-item-pf");
                });
            } else {
                p();
            }
        }, y = function(e, t) {
            if (e) {
                t.addClass("collapsed");
                s.addClass("collapsed-secondary-nav-pf");
                i.addClass("collapsed-secondary-nav-pf");
            } else {
                if (t) {
                    t.removeClass("collapsed");
                } else {
                    // Remove any collapsed secondary menus
                    s.find('[data-toggle="collapse-secondary-nav"]').each(function(e, t) {
                        var n = P(t);
                        n.removeClass("collapsed");
                    });
                }
                s.removeClass("collapsed-secondary-nav-pf");
                i.removeClass("collapsed-secondary-nav-pf");
            }
        }, b = function(e, t) {
            if (e) {
                t.addClass("collapsed");
                s.addClass("collapsed-tertiary-nav-pf");
                i.addClass("collapsed-tertiary-nav-pf");
                y(false);
            } else {
                if (t) {
                    t.removeClass("collapsed");
                } else {
                    // Remove any collapsed tertiary menus
                    s.find('[data-toggle="collapse-tertiary-nav"]').each(function(e, t) {
                        var n = P(t);
                        n.removeClass("collapsed");
                    });
                }
                s.removeClass("collapsed-tertiary-nav-pf");
                i.removeClass("collapsed-tertiary-nav-pf");
            }
        }, w = function(e, t) {
            P(document).find(".list-group-item.mobile-nav-item-pf").each(function(e, t) {
                P(t).removeClass("mobile-nav-item-pf");
            });
            P(document).find(".list-group-item.mobile-secondary-item-pf").each(function(e, t) {
                P(t).removeClass("mobile-secondary-item-pf");
            });
            if (e) {
                e.addClass("mobile-nav-item-pf");
                if (t) {
                    t.addClass("mobile-secondary-item-pf");
                    s.removeClass("show-mobile-secondary");
                    s.addClass("show-mobile-tertiary");
                } else {
                    s.addClass("show-mobile-secondary");
                    s.removeClass("show-mobile-tertiary");
                }
            } else {
                s.removeClass("show-mobile-secondary");
                s.removeClass("show-mobile-tertiary");
            }
        }, x = function() {
            if (!s.hasClass("hidden")) {
                //Set the nav to being hidden
                s.addClass("hidden");
                s.removeClass("collapsed");
                //Set the body class to the correct state
                                i.removeClass("collapsed-nav");
                i.addClass("hidden-nav");
                // Reset the collapsed states
                                y(false);
                b(false);
                l = false;
            }
        }, C = function() {
            // Always remove the hidden & peek class
            s.removeClass("hidden show-mobile-nav");
            // Set the body class back to the default
                        i.removeClass("hidden-nav");
        }, T = function() {
            var e = P(window).width(), t;
            if (!a) {
                return;
            }
            // Check to see if we need to enter/exit the mobile state
                        if (e < P.pfBreakpoints.tablet && !l) {
                x();
            } else if (s.hasClass("hidden")) {
                C();
            }
            // Check to see if we need to enter/exit the sub desktop state
                        if (e < P.pfBreakpoints.desktop) {
                if (!f) {
                    // Collapse the navigation bars when entering sub desktop mode
                    s.addClass("collapsed");
                    i.addClass("collapsed-nav");
                }
                if (e >= P.pfBreakpoints.tablet) {
                    h();
                }
                f = true;
            } else {
                t = f && s.find(".secondary-nav-item-pf.active").length > 0;
                f = false;
                if (t) {
                    p();
                }
            }
            if (l) {
                s.addClass("collapsed");
                i.addClass("collapsed-nav");
            } else {
                s.removeClass("collapsed");
                i.removeClass("collapsed-nav");
            }
        }, D = function() {
            //Make sure this is expanded
            s.addClass("collapsed");
            //Set the body class to the correct state
                        i.addClass("collapsed-nav");
            if (f) {
                h();
            }
            l = true;
        }, k = function() {
            // enable transitions only when toggleNavBarButton is clicked or window is resized
            P("html").addClass("transitions");
        }, S = function() {
            //Make sure this is expanded
            s.removeClass("collapsed");
            //Set the body class to the correct state
                        i.removeClass("collapsed-nav");
            l = false;
            // Dispatch a resize event when showing the expanding then menu to
            // allow content to adjust to the menu sizing
                        if (!f) {
                d(100);
            }
        }, E = function() {
            o.on("click", function(e) {
                var t;
                k();
                if (c()) {
                    // Toggle the mobile nav
                    if (s.hasClass("show-mobile-nav")) {
                        s.removeClass("show-mobile-nav");
                    } else {
                        // Always start at the primary menu
                        w();
                        s.addClass("show-mobile-nav");
                        // If the notification drawer is shown, hide it
                                                if (!n) {
                            t = P(".drawer-pf");
                            if (t.length) {
                                P(".drawer-pf-trigger").removeClass("open");
                                t.addClass("hide");
                            }
                        }
                    }
                } else if (s.hasClass("collapsed")) {
                    if (r.rememberOpenState) {
                        window[u].setItem("patternfly-navigation-primary", "expanded");
                    }
                    S();
                } else {
                    if (r.rememberOpenState) {
                        window[u].setItem("patternfly-navigation-primary", "collapsed");
                    }
                    D();
                }
            });
        }, $ = function() {
            s.addClass("force-hide-secondary-nav-pf");
            setTimeout(function() {
                s.removeClass("force-hide-secondary-nav-pf");
            }, 500);
        }, A = function(a) {
            P(document).find(".nav-pf-vertical .list-group-item").each(function(e, t) {
                var n, o = P(t), i = o.closest('[class*="nav-pf-"]');
                if (i.hasClass("nav-pf-vertical")) {
                    // Set main nav active item on click or show secondary nav if it has a secondary nav bar and we are in the mobile state
                    n = function(e) {
                        var t = P(this), n, i, r;
                        if (!t.hasClass("secondary-nav-item-pf")) {
                            h();
                            if (c()) {
                                w();
                                s.removeClass("show-mobile-nav");
                            }
                            if (a) {
                                v(t);
                                // Don't process the click on the item
                                                                e.stopImmediatePropagation();
                            }
                        } else if (c()) {
                            w(t);
                        } else if (a) {
                            r = n = o.find(".nav-pf-secondary-nav > .list-group > .list-group-item").eq(0);
                            if (n.hasClass("tertiary-nav-item-pf")) {
                                r = n.find(".nav-pf-tertiary-nav > .list-group > .list-group-item").eq(0);
                            }
                            v(r);
                            e.stopImmediatePropagation();
                        }
                    };
                } else if (i.hasClass("nav-pf-secondary-nav")) {
                    // Set secondary nav active item on click or show tertiary nav if it has a tertiary nav bar and we are in the mobile state
                    n = function(e) {
                        var t = P(this), n, i;
                        if (!t.hasClass("tertiary-nav-item-pf")) {
                            if (c()) {
                                w();
                                s.removeClass("show-mobile-nav");
                            }
                            m();
                            if (a) {
                                v(o);
                                h();
                                e.stopImmediatePropagation();
                            }
                        } else if (c()) {
                            i = o.parents(".list-group-item");
                            w(t, i);
                            e.stopImmediatePropagation();
                        } else if (a) {
                            n = o.find(".nav-pf-tertiary-nav > .list-group > .list-group-item").eq(0);
                            v(n);
                            e.stopImmediatePropagation();
                        }
                    };
                } else if (i.hasClass("nav-pf-tertiary-nav")) {
                    // Set tertiary nav active item on click
                    n = function(e) {
                        if (c()) {
                            w();
                            s.removeClass("show-mobile-nav");
                        }
                        m();
                        if (a) {
                            v(o);
                            g();
                            h();
                            e.stopImmediatePropagation();
                        }
                    };
                }
                // register event handler
                                o.on("click.pf.secondarynav.data-api", n);
            });
            P(document).find(".secondary-nav-item-pf").each(function(e, t) {
                var i = P(t);
                // Collapse the secondary nav bar when the toggle is clicked
                                i.on("click.pf.secondarynav.data-api", '[data-toggle="collapse-secondary-nav"]', function(e) {
                    var t = P(this);
                    if (c()) {
                        w();
                        e.stopImmediatePropagation();
                    } else {
                        if (t.hasClass("collapsed")) {
                            if (r.rememberOpenState) {
                                window[u].setItem("patternfly-navigation-secondary", "expanded");
                                window[u].setItem("patternfly-navigation-tertiary", "expanded");
                            }
                            y(false, t);
                            $();
                        } else {
                            if (r.rememberOpenState) {
                                window[u].setItem("patternfly-navigation-secondary", "collapsed");
                            }
                            y(true, t);
                        }
                    }
                    s.removeClass("hover-secondary-nav-pf");
                    if (a) {
                        // Don't process the click on the parent item
                        e.stopImmediatePropagation();
                    }
                });
                i.find(".tertiary-nav-item-pf").each(function(e, t) {
                    var n = P(t);
                    // Collapse the tertiary nav bar when the toggle is clicked
                                        n.on("click.pf.tertiarynav.data-api", '[data-toggle="collapse-tertiary-nav"]', function(e) {
                        var t = P(this);
                        if (c()) {
                            w(i);
                            e.stopImmediatePropagation();
                        } else {
                            if (t.hasClass("collapsed")) {
                                if (r.rememberOpenState) {
                                    window[u].setItem("patternfly-navigation-secondary", "expanded");
                                    window[u].setItem("patternfly-navigation-tertiary", "expanded");
                                }
                                b(false, t);
                                $();
                            } else {
                                if (r.rememberOpenState) {
                                    window[u].setItem("patternfly-navigation-tertiary", "collapsed");
                                }
                                b(true, t);
                            }
                        }
                        s.removeClass("hover-secondary-nav-pf");
                        s.removeClass("hover-tertiary-nav-pf");
                        if (a) {
                            // Don't process the click on the parent item
                            e.stopImmediatePropagation();
                        }
                    });
                });
            });
            // Show secondary nav bar on hover of secondary nav items
                        P(document).on("mouseenter.pf.tertiarynav.data-api", ".secondary-nav-item-pf", function(e) {
                var t = P(this);
                if (!c()) {
                    if (t[0].navUnHoverTimeout !== undefined) {
                        clearTimeout(t[0].navUnHoverTimeout);
                        t[0].navUnHoverTimeout = undefined;
                    } else if (t[0].navHoverTimeout === undefined) {
                        t[0].navHoverTimeout = setTimeout(function() {
                            s.addClass("hover-secondary-nav-pf");
                            t.addClass("is-hover");
                            t[0].navHoverTimeout = undefined;
                        }, r.hoverDelay);
                    }
                }
            });
            P(document).on("mouseleave.pf.tertiarynav.data-api", ".secondary-nav-item-pf", function(e) {
                var t = P(this);
                if (t[0].navHoverTimeout !== undefined) {
                    clearTimeout(t[0].navHoverTimeout);
                    t[0].navHoverTimeout = undefined;
                } else if (t[0].navUnHoverTimeout === undefined && s.find(".secondary-nav-item-pf.is-hover").length > 0) {
                    t[0].navUnHoverTimeout = setTimeout(function() {
                        if (s.find(".secondary-nav-item-pf.is-hover").length <= 1) {
                            s.removeClass("hover-secondary-nav-pf");
                        }
                        t.removeClass("is-hover");
                        t[0].navUnHoverTimeout = undefined;
                    }, r.hideDelay);
                }
            });
            // Show tertiary nav bar on hover of secondary nav items
                        P(document).on("mouseover.pf.tertiarynav.data-api", ".tertiary-nav-item-pf", function(e) {
                var t = P(this);
                if (!c()) {
                    if (t[0].navUnHoverTimeout !== undefined) {
                        clearTimeout(t[0].navUnHoverTimeout);
                        t[0].navUnHoverTimeout = undefined;
                    } else if (t[0].navHoverTimeout === undefined) {
                        t[0].navHoverTimeout = setTimeout(function() {
                            s.addClass("hover-tertiary-nav-pf");
                            t.addClass("is-hover");
                            t[0].navHoverTimeout = undefined;
                        }, r.hoverDelay);
                    }
                }
            });
            P(document).on("mouseout.pf.tertiarynav.data-api", ".tertiary-nav-item-pf", function(e) {
                var t = P(this);
                if (t[0].navHoverTimeout !== undefined) {
                    clearTimeout(t[0].navHoverTimeout);
                    t[0].navHoverTimeout = undefined;
                } else if (t[0].navUnHoverTimeout === undefined) {
                    t[0].navUnHoverTimeout = setTimeout(function() {
                        if (s.find(".tertiary-nav-item-pf.is-hover").length <= 1) {
                            s.removeClass("hover-tertiary-nav-pf");
                        }
                        t.removeClass("is-hover");
                        t[0].navUnHoverTimeout = undefined;
                    }, r.hideDelay);
                }
            });
        }, N = function() {
            if (c()) {
                return;
            }
            if (window[u].getItem("patternfly-navigation-primary") === "collapsed") {
                D();
            }
            if (P(".nav-pf-vertical.nav-pf-vertical-collapsible-menus").length > 0) {
                if (window[u].getItem("patternfly-navigation-secondary") === "collapsed") {
                    y(true, P(".secondary-nav-item-pf.active [data-toggle=collapse-secondary-nav]"));
                }
                if (window[u].getItem("patternfly-navigation-tertiary") === "collapsed") {
                    b(true, P(".tertiary-nav-item-pf.active [data-toggle=collapse-tertiary-nav]"));
                }
            }
        }, j = function() {
            var e = {
                container: "body",
                placement: "bottom",
                delay: {
                    show: "500",
                    hide: "200"
                },
                template: '<div class="nav-pf-vertical-tooltip tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>'
            };
            P('.nav-pf-vertical [data-toggle="tooltip"]').tooltip(e);
            P(".nav-pf-vertical").on("show.bs.tooltip", function(e) {
                return P(this).hasClass("collapsed");
            });
        }, L = function(e) {
            // Hide the nav menus during initialization
            s.addClass("hide-nav-pf");
            i.addClass("hide-nav-pf");
            //Set correct state on load
                        T();
            // Bind Top level hamburger menu with menu behavior;
                        E();
            // Bind menu items
                        A(e);
            //Set tooltips
                        j();
            if (r.rememberOpenState) {
                N();
            }
            // Show the nav menus
                        s.removeClass("hide-nav-pf");
            i.removeClass("hide-nav-pf");
            d(250);
        }, I = {
            hideMenu: function() {
                a = false;
                x();
            },
            showMenu: function() {
                a = true;
                C();
            },
            isVisible: function() {
                return a;
            }
        };
        if (!P.fn.setupVerticalNavigation.self) {
            P.fn.setupVerticalNavigation.self = I;
            //Listen for the window resize event and collapse/hide as needed
                        P(window).on("resize", function() {
                T();
                k();
            });
            L(e);
        }
        return P.fn.setupVerticalNavigation.self;
    };
})(jQuery);
//# sourceMappingURL=jquery.min.js.map