'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _CardTitle = require('./CardTitle');

var _CardTitle2 = _interopRequireDefault(_CardTitle);

var _CardBody = require('./CardBody');

var _CardBody2 = _interopRequireDefault(_CardBody);

var _CardHeading = require('./CardHeading');

var _CardHeading2 = _interopRequireDefault(_CardHeading);

var _CardFooter = require('./CardFooter');

var _CardFooter2 = _interopRequireDefault(_CardFooter);

var _CardLink = require('./CardLink');

var _CardLink2 = _interopRequireDefault(_CardLink);

var _CardGrid = require('./CardGrid');

var _CardGrid2 = _interopRequireDefault(_CardGrid);

var _CardDropdownButton = require('./CardDropdownButton');

var _CardDropdownButton2 = _interopRequireDefault(_CardDropdownButton);

var _CardHeightMatching = require('./CardHeightMatching');

var _CardHeightMatching2 = _interopRequireDefault(_CardHeightMatching);

var _UtilizationTrendCard = require('./UtilizationTrendCard');

var _AggregateStatusCard = require('./AggregateStatusCard');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

/**
 * Card Component for PatternFly React
 */
var Card = function Card(_ref) {
  var children = _ref.children,
      className = _ref.className,
      accented = _ref.accented,
      aggregated = _ref.aggregated,
      aggregatedMini = _ref.aggregatedMini,
      matchHeight = _ref.matchHeight,
      cardRef = _ref.cardRef,
      props = _objectWithoutProperties(_ref, ['children', 'className', 'accented', 'aggregated', 'aggregatedMini', 'matchHeight', 'cardRef']);

  var classes = (0, _classnames2.default)('card-pf', { 'card-pf-accented': accented }, { 'card-pf-aggregate-status': aggregated }, {
    'card-pf-aggregate-status card-pf-aggregate-status-mini': aggregatedMini
  }, { 'card-pf-match-height': matchHeight }, className);

  return _react2.default.createElement(
    'div',
    _extends({ className: classes, ref: cardRef }, props),
    children
  );
};

Card.propTypes = {
  /** Child nodes */
  children: _propTypes2.default.node.isRequired,
  /** Additional element css classes */
  className: _propTypes2.default.string,
  /** Top Card Accent Bool */
  accented: _propTypes2.default.bool,
  /** Aggregate Card Bool */
  aggregated: _propTypes2.default.bool,
  /** Aggregate Mini Card Bool */
  aggregatedMini: _propTypes2.default.bool,
  /** Match Height Bool */
  matchHeight: _propTypes2.default.bool,
  /** Reference prop */
  cardRef: _propTypes2.default.func
};

Card.defaultProps = {
  className: '',
  accented: false,
  aggregated: false,
  aggregatedMini: false,
  matchHeight: false,
  cardRef: null
};

Card.Title = _CardTitle2.default;
Card.Body = _CardBody2.default;
Card.Heading = _CardHeading2.default;
Card.Footer = _CardFooter2.default;
Card.Link = _CardLink2.default;
Card.Grid = _CardGrid2.default;
Card.DropdownButton = _CardDropdownButton2.default;
Card.HeightMatching = _CardHeightMatching2.default;
Card.UtilizationCard = _UtilizationTrendCard.UtilizationCard;
Card.UtilizationCardDetails = _UtilizationTrendCard.UtilizationCardDetails;
Card.UtilizationCardDetailsCount = _UtilizationTrendCard.UtilizationCardDetailsCount;
Card.UtilizationCardDetailsDesc = _UtilizationTrendCard.UtilizationCardDetailsDesc;
Card.UtilizationCardDetailsLine1 = _UtilizationTrendCard.UtilizationCardDetailsLine1;
Card.UtilizationCardDetailsLine2 = _UtilizationTrendCard.UtilizationCardDetailsLine2;
Card.AggregateStatusCount = _AggregateStatusCard.AggregateStatusCount;
Card.AggregateStatusNotifications = _AggregateStatusCard.AggregateStatusNotifications;
Card.AggregateStatusNotification = _AggregateStatusCard.AggregateStatusNotification;

exports.default = Card;