'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _index = require('../../../../index');

var _LoginCardSocialLink = require('./LoginCardSocialLink');

var _LoginCardSocialLink2 = _interopRequireDefault(_LoginCardSocialLink);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var LoginCardSocialColumns = function (_React$Component) {
  _inherits(LoginCardSocialColumns, _React$Component);

  function LoginCardSocialColumns() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, LoginCardSocialColumns);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = LoginCardSocialColumns.__proto__ || Object.getPrototypeOf(LoginCardSocialColumns)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      expend: false,
      width: window.innerWidth
    }, _this.updateWindowWidth = function () {
      _this.setState({
        width: window.innerWidth
      });
    }, _this.getListItems = function () {
      _this.hiddenLinks = [];
      return _this.props.links && _this.props.links.map(function (link, index) {
        if (index >= _this.props.shownButtons) {
          _this.hiddenLinks.push(link);
          return true;
        }

        return _react2.default.createElement(_LoginCardSocialLink2.default, { link: link, key: link.key || index });
      });
    }, _this.getHiddenListItems = function () {
      return _this.hiddenLinks && _this.hiddenLinks.map(function (link, index) {
        return _react2.default.createElement(_LoginCardSocialLink2.default, { link: link, key: link.key || index + _this.props.shownButtons });
      });
    }, _this.toggleExpend = function () {
      _this.setState({ expend: !_this.state.expend });
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(LoginCardSocialColumns, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      window.addEventListener('resize', this.updateWindowWidth);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      window.removeEventListener('resize', this.updateWindowWidth);
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          links = _props.links,
          shownButtons = _props.shownButtons;

      if (!links) {
        return null;
      }
      var _state = this.state,
          expend = _state.expend,
          width = _state.width;

      var expendButton = width > 768 && links.length > shownButtons && _react2.default.createElement(
        _index.Button,
        { bsStyle: 'link', bsClass: 'btn btn-link login-pf-social-toggle', onClick: function onClick(e) {
            return _this2.toggleExpend(e);
          } },
        expend ? 'Less' : 'More',
        ' \xA0',
        _react2.default.createElement(_index.Icon, { name: 'angle-' + (expend ? 'up' : 'down') })
      );

      var doubleColumn = links.length > 4 ? 'login-pf-social-double-col' : '';
      var moreItems = expend || width < 768 ? this.getHiddenListItems() : null;
      return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
          'ul',
          { className: 'login-pf-social list-unstyled ' + doubleColumn },
          this.getListItems(),
          moreItems
        ),
        expendButton
      );
    }
  }]);

  return LoginCardSocialColumns;
}(_react2.default.Component);

LoginCardSocialColumns.propTypes = {
  links: _propTypes2.default.array,
  shownButtons: _propTypes2.default.number
};

LoginCardSocialColumns.defaultProps = {
  links: [],
  shownButtons: 8
};

exports.default = LoginCardSocialColumns;