'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var BulletChartRange = function BulletChartRange(_ref) {
  var className = _ref.className,
      value = _ref.value,
      index = _ref.index,
      vertical = _ref.vertical,
      props = _objectWithoutProperties(_ref, ['className', 'value', 'index', 'vertical']);

  var rangeClasses = (0, _classnames2.default)('bullet-chart-pf-range-bar', 'range-' + index, className);

  if (value > 0 && value <= 100) {
    return _react2.default.createElement('div', _extends({
      className: rangeClasses,
      style: {
        width: vertical ? undefined : value + '%',
        height: vertical ? value + '%' : undefined,
        zIndex: 100 - value
      }
    }, props));
  }

  return null;
};

BulletChartRange.propTypes = {
  /** Additional css classes */
  className: _propTypes2.default.string,
  /** End value for the range */
  value: _propTypes2.default.number.isRequired,
  /** Index for the range (1-3) */
  index: _propTypes2.default.number.isRequired,
  /** Vertical chart, default false */
  vertical: _propTypes2.default.bool
};

BulletChartRange.defaultProps = {
  className: '',
  vertical: false
};

exports.default = BulletChartRange;