# CiviCRM 5.65.0

Released September 6, 2023

- **[Synopsis](#synopsis)**
- **[Security advisories](#security)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |
| **Fix security vulnerabilities?**                               | **yes** |

## <a name="security"></a>Security advisories

* **[CIVI-SA-2023-07](https://civicrm.org/advisory/civi-sa-2023-07-smarty-math-rce): Smarty Math RCE**
* **[CIVI-SA-2023-08](https://civicrm.org/advisory/civi-sa-2023-08-kcfinder-xss): KCFinder XSS**
* **[CIVI-SA-2023-09](https://civicrm.org/advisory/civi-sa-2023-09-getfields-sqli): GetFields SQLI**
* **[CIVI-SA-2023-10](https://civicrm.org/advisory/civi-sa-2023-10-multiple-potential-sqli): Multiple Potential SQLI**
* **[CIVI-SA-2023-11](https://civicrm.org/advisory/civi-sa-2023-11-select2-xss): Select2 XSS**
* **[CIVI-SA-2023-12](https://civicrm.org/advisory/civi-sa-2023-12-jquery-validation-dos): jQuery Validation DoS**
* **[CIVI-SA-2023-13](https://civicrm.org/advisory/civi-sa-2023-13-survey-xss): Survey XSS**
* **[CIVI-SA-2023-14](https://civicrm.org/advisory/civi-sa-2023-14-contact-image-csrf): Contact Image CSRF**
* **[CIVI-SA-2023-15](https://civicrm.org/advisory/civi-sa-2023-15-civievent-xss): CiviEvent XSS**

## <a name="features"></a>Features

### Core CiviCRM

- **Remove top buttons on admin forms
  ([dev/user-interface#51](https://lab.civicrm.org/dev/user-interface/-/issues/51):
  [26886](https://github.com/civicrm/civicrm-core/pull/26886))**

  Improves user experience by removing the top buttons on admin forms.

- **Reduce initial height of crm-popup dialog
  ([26825](https://github.com/civicrm/civicrm-core/pull/26825))**

  Improves user experience by reducing the initial height of civi pop ups.

- **Link between Label Page Formats and Address Settings
  ([26890](https://github.com/civicrm/civicrm-core/pull/26890))**

  Adds links between the "Label Page Formats" form and the "Address Settings" form.

- **Allow matching on external_identifier for source/target contacts on Activity
  import ([25206](https://github.com/civicrm/civicrm-core/pull/25206))**

  Allows matching on `external_identifier` for source/target contacts on
  Activity import.

- **Standalone - Add support for development-friendly file-layouts
  ([26771](https://github.com/civicrm/civicrm-core/pull/26771))**

  Makes it possible to install the Standalone UF.

- **Standalone - Web-based installation for PHP built-in server  
  ([26852](https://github.com/civicrm/civicrm-core/pull/26852))**

  Extends support for PHP built-in web-server (SRV profile from #26771)
  and enables installation through the web UI.

- **Standalone: implement basic breadcrumb
  ([26782](https://github.com/civicrm/civicrm-core/pull/26782) and
  [26942](https://github.com/civicrm/civicrm-core/pull/26942))**

  Implements a rudimentary breadcrumb for CiviCRM Standalone.

- **Standalone civi-setup: grant more permissions to anon, use ts
  ([26934](https://github.com/civicrm/civicrm-core/pull/26934))**

  Sets defaults for Standalone installs, such that anonymous users have
  permissions to: view event info and register for online events. Additionally
  adds some translation compatibility.

- **standalone: Redirect to login
  ([26966](https://github.com/civicrm/civicrm-core/pull/26966))**

  For standalone implementations makes it so if you are not logged in, visiting
  a page that you don't have permission for will send you to
  /civicrm/login?anonAccessDenied which will present the login page and a
  message saying you gotta login for that. Additionally, If you access / then
  it will first check if Civi has a menu item for / (e.g. form builder /
  extension) and if not, default to /civicrm, which, if you're not logged in
  will in turn redirect you to the login page. If you are logged in and get
  permission denied, you are bounced to the civi homepage with a message.

- **add `contactId` to params array in EmailTrait
  ([26748](https://github.com/civicrm/civicrm-core/pull/26748))**

  Makes it so one can access the contactId from the `alterMailParams` hook when
  the context is singleEmail.

- **Edits the "Edit Managed Job" and "Manage Scheduled Jobs" forms: remove
  double-title, top buttons, help only on the main job page
  ([26767](https://github.com/civicrm/civicrm-core/pull/26767) and
  [26786](https://github.com/civicrm/civicrm-core/pull/26786))**

  Makes a variety of small tweaks to improves usability on the "Edit Managed
  Job" and "Manage Scheduled Jobs" forms.

- **Add escape=htmlattribute option to the ts function
  ([26792](https://github.com/civicrm/civicrm-core/pull/26792))**

  Adds a new 'escape' => 'htmlattribute' option for the ts translation function.

- **SearchKit - Add ability to run tasks via clicking links
  ([26794](https://github.com/civicrm/civicrm-core/pull/26794) and
  [27199](https://github.com/civicrm/civicrm-core/pull/27199))**

  Makes it possible to use tasks and links interchangeably in SearchKit.

- **SearchKit - Improve performance of checking link permissions
  ([26854](https://github.com/civicrm/civicrm-core/pull/26854))**

  Speeds up search display performance by checking link permissions more
  efficiently.

- **Create SearchUI extension
  ([26863](https://github.com/civicrm/civicrm-core/pull/26863) and
  [26967](https://github.com/civicrm/civicrm-core/pull/26967))**

  Creates a separate extension for Search page replacements. Like AdminUI but
  for searches.

- **SearchUI: add Find Contributions
  ([26746](https://github.com/civicrm/civicrm-core/pull/26746))**

  Replaces the Find Contributions search with a SearchKit/FormBuilder
  implementation for those using SearchUI extension.

- **Mark admin_ui extension as 'beta'
  ([26883](https://github.com/civicrm/civicrm-core/pull/26883))**

  Advertises the new AdminUI extension as beta.

- **AdminUI - Add toggle for is_active
  ([26842](https://github.com/civicrm/civicrm-core/pull/26842))**

  Adds convenient enable/disable buttons to the new SearchKit-based screens in
  the AdminUI extension.

- **AdminUI: convert 'Assign Users to Roles' ACL configuration page
  ([26925](https://github.com/civicrm/civicrm-core/pull/26925))**

  Adds the 'Assign Users to Roles' form to the Admin UI Extension.

- **AdminUI - Add Administer Scheduled Reminders page
  ([26896](https://github.com/civicrm/civicrm-core/pull/26896))**

  Adds the Administer Scheduled Reminders page to the Admin UI Extension.

- **CRM_Admin_Form - Automatically redirect to the "browse" page after
  submission ([26887](https://github.com/civicrm/civicrm-core/pull/26887) and
  [26921](https://github.com/civicrm/civicrm-core/pull/26921))**

  Makes it so one can set a browse link for admin forms in the metadata and does
  so for a bunch of forms.

- **ScheduledReminders - Add option list for limit_to column and fix type
  ([26881](https://github.com/civicrm/civicrm-core/pull/26881))**

  Cleans up metadata for the ActionSchedule.limit_to field to make it easier to
  work with in the API.

- **Autoload ActionMappings by enabling global class scanning (Variant 2)
  ([26923](https://github.com/civicrm/civicrm-core/pull/26923))**

  Auto-loading ActionMappings, and makes the auto-loading process easier with a
  new AutoSubscriber base class.

- **hook_civicrm_copy: Pass the original id when available
  ([26930](https://github.com/civicrm/civicrm-core/pull/26930))**

  Makes it so extension developers can access the id of the entity from
  `hook_civicrm_copy`.

- **5.65.alpha1 - Define pre-upgrade snapshots (Option B)
  ([26999](https://github.com/civicrm/civicrm-core/pull/26999))**

  For data-structures that are modified by the 5.65.alpha1 upgrade, create some
  snapshots (just in case we discover some schema problem later on).

- **Finish allowing use of SSL to connect to database
  (Work Towards [dev/core#1926](https://lab.civicrm.org/dev/core/-/issues/1926):
  [26910](https://github.com/civicrm/civicrm-core/pull/26910))**

  Adds docs link to civicrm.settings.php.template.

### CiviContribute

- **Financial Batches: remove the creation of activities for New/Edit
  ([dev/financial#216](https://lab.civicrm.org/dev/financial/-/issues/216):
  [26897](https://github.com/civicrm/civicrm-core/pull/26897))**

  Removes the creation of activities whenever a Financial Batch is created or
  edited.

- **Change Price paths
  ([26929](https://github.com/civicrm/civicrm-core/pull/26929),
  [26973](https://github.com/civicrm/civicrm-core/pull/26973) and
  [26990](https://github.com/civicrm/civicrm-core/pull/26990))**

  Changes paths for the Price Sets, Price Fields and Price Field Values settings
  forms allowing the original URL's to be overridden by AdminUI.

- **Change default input format for credit card expiration month to NN
  ([26768](https://github.com/civicrm/civicrm-core/pull/26768))**

  Changes the input format for credit card expiration month from the three letter
  abbreviation to the two digit month to more closely match whats on the credit card.

### CiviMail

- **Show Email bounce history on Contact summary
  ([26674](https://github.com/civicrm/civicrm-core/pull/26674))**

  Adds a link to on hold emails on the contact summary tab to a list of that
  emails bounce history.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Afform: Radios should show default value when form is loaded/reset
  ([dev/core#3777](https://lab.civicrm.org/dev/core/-/issues/3777):
  [25605](https://github.com/civicrm/civicrm-core/pull/25605))**

  Fixes setting defaults on afforms for radio and checkboxes when values are
  non-string.

- **Make frontend_title consistently required and use it in all front end
  presentations (Work Towards
  [dev/core#4213](https://lab.civicrm.org/dev/core/-/issues/4213):
  [26546](https://github.com/civicrm/civicrm-core/pull/26546) and
  [26913](https://github.com/civicrm/civicrm-core/pull/26913))**

  Makes the field frontend_title required for the Group entity and updates the
  Group Subscribe message to use frontend_title.

- **Upgrade to 5.65 shows incorrect message about Petition - Signature Added
  message template upgrade
  ([dev/core#4445](https://lab.civicrm.org/dev/core/-/issues/4445):
  [26935](https://github.com/civicrm/civicrm-core/pull/26935))**

  Only show templates upgrade message when templates have changed.

- **Status check about accessible dirs can be slow
  ([dev/core#4449](https://lab.civicrm.org/dev/core/-/issues/4449):
  [26932](https://github.com/civicrm/civicrm-core/pull/26932))**

  Avoids slow status checks.

- **search kit: activity search with activity contacts no longer working
  ([dev/core#4461](https://lab.civicrm.org/dev/core/-/issues/4461):
  [27007](https://github.com/civicrm/civicrm-core/pull/27007))**

  Fixes missing links causing SearchKit to return no results.

- **Index not created for ACL priority on upgrade to 5.64
  ([dev/core#4472](https://lab.civicrm.org/dev/core/-/issues/4472):
  [27088](https://github.com/civicrm/civicrm-core/pull/27088))**

- **View-only custom fields not getting merged
  ([dev/core#4481](https://lab.civicrm.org/dev/core/-/issues/4481):
  [26969](https://github.com/civicrm/civicrm-core/pull/26969))**

- **(regression) SearchKit doesn't handle delegated access permissions correctly
  ([dev/core#4483](https://lab.civicrm.org/dev/core/-/issues/4483):
  [27033](https://github.com/civicrm/civicrm-core/pull/27033))**

  Fixes SearchKit crash when in-place-editing a field in a joined entity
  (under certain conditions).

- **(regression) Add/Edit Scheduled Reminders page does not load if
  CiviContribute is disabled
  ([dev/core#4492](https://lab.civicrm.org/dev/core/-/issues/4492):
  [27043](https://github.com/civicrm/civicrm-core/pull/27043))**

- **Undefined $line and $value when sending offline email receipt
  ([dev/core#4494](https://lab.civicrm.org/dev/core/-/issues/4494):
  [27066](https://github.com/civicrm/civicrm-core/pull/27066))**

  Fixes e-notice by removing unused variables.

- **Search kit - if id is not present then the 'select' is misleading
  ([dev/core#4519](https://lab.civicrm.org/dev/core/-/issues/4519):
  [27123](https://github.com/civicrm/civicrm-core/pull/27123))**

  Fixes SearchKit tasks when ID column is not present.

- **SearchKit - Don't crash afforms with non-dao entities
  ([27334](https://github.com/civicrm/civicrm-core/pull/27334))**

  This fixes a regression from 5.54 that affects search displays embedded in
  afforms for entities that don't exist as data objects.

- **SearchKit - Fix assigning searchDisplay tab count
  ([27270](https://github.com/civicrm/civicrm-core/pull/27270))**

- **Regression: Unable to set price set on contribution page under membership
  page ([dev/core#4523](https://lab.civicrm.org/dev/core/-/issues/4523):
  [27120](https://github.com/civicrm/civicrm-core/pull/27120))**

  Fixes membership price sets selection regression on Contribution Pages.

- **Search forms - email validation smashes usability
  ([dev/core#4530](https://lab.civicrm.org/dev/core/-/issues/4530):
  [27130](https://github.com/civicrm/civicrm-core/pull/27130))**

  Changes email fields to text input in search mode to avoid validating that the
  input is an email as one might search on part of an email.

- **Afform - Email link doesn't render on individual emails for contacts with
  preferred locale
  ([dev/core#4531](https://lab.civicrm.org/dev/core/-/issues/4531):
  [27134](https://github.com/civicrm/civicrm-core/pull/27134))**

- **Revert "Add apiv4 Survey entity" (already exists in civi_campaign ext)
  ([27136](https://github.com/civicrm/civicrm-core/pull/27136))**

- **Cannot change membership price set on contribution pages
  ([dev/core#4486](https://lab.civicrm.org/dev/core/-/issues/4486):
  [27079](https://github.com/civicrm/civicrm-core/pull/27079) and
  [27083](https://github.com/civicrm/civicrm-core/pull/27083))**

- **Slow contact lookup query in SearchKit
  ([dev/core#4423](https://lab.civicrm.org/dev/core/-/issues/4423):
  [26840](https://github.com/civicrm/civicrm-core/pull/26840))**

- **menubar: hide toggleButton when using Standalone
  ([26793](https://github.com/civicrm/civicrm-core/pull/26793))**

- **Standalone: do not show the Hide Menu option
  ([26789](https://github.com/civicrm/civicrm-core/pull/26789))**

- **Extension Browser: there are no standalone-specific modules
  ([26787](https://github.com/civicrm/civicrm-core/pull/26787))**

  Under Administer > System Settings > Extensions, there is a mention about
  native Standalone modules, which do not exist.

- **FiveSixtyTwo - Fix upgrade for domains with default value of
  `enable_components`
  ([27075](https://github.com/civicrm/civicrm-core/pull/27075))**

- **Allow multiple registrations from search actions
  ([26303](https://github.com/civicrm/civicrm-core/pull/26303))**

- **Use `isQuickConfig()` to determine isQuickConfig (towards php8.x fix)
  ([26961](https://github.com/civicrm/civicrm-core/pull/26961))**

- **AutoDefinition - Inherit service-tags from interfaces, traits, and parent
  classes ([26963](https://github.com/civicrm/civicrm-core/pull/26963))**

- **Fix Import Template path to be dynamic, depending on the entity
  ([26927](https://github.com/civicrm/civicrm-core/pull/26927))**

- **Check if profile contact employer name matches existing contact employer
  name when saving profile
  ([24683](https://github.com/civicrm/civicrm-core/pull/24683))**

- **Status check - Use guzzle instead to avoid slowness reading zero-length file
  ([26889](https://github.com/civicrm/civicrm-core/pull/26889))**

- **SearchUI:Move 'Find Contacts' upgrader steps from AdminUI to SearchUI
  ([26919](https://github.com/civicrm/civicrm-core/pull/26919))**

- **fix lifetime membership calc in contribution pages
  ([25458](https://github.com/civicrm/civicrm-core/pull/25458))**

- **Fix relative URL generation when using alternate HTTP port
  ([26900](https://github.com/civicrm/civicrm-core/pull/26900))**

- **getEntitySpecificJoins sometimes returns NULL, triggering deprecation
  warning for trim() in php 8.1
  ([26892](https://github.com/civicrm/civicrm-core/pull/26892))**

- **DAO - Normalize null values in the writeRecord function to avoid subtle bugs
  ([26984](https://github.com/civicrm/civicrm-core/pull/26984))**

- **Remove gap before delete button on contact
  ([26904](https://github.com/civicrm/civicrm-core/pull/26904))**

- **ClassScanner - Re-skip `_Form` classes
  ([26937](https://github.com/civicrm/civicrm-core/pull/26937))**

- **Don't scan QuickForm classes
  ([26936](https://github.com/civicrm/civicrm-core/pull/26936))**

- **Change Administer > Communications > Label Formats to Label Page Formats
  ([26865](https://github.com/civicrm/civicrm-core/pull/26865))**

- **Job - uppercase api entity
  ([26880](https://github.com/civicrm/civicrm-core/pull/26880))**

  Uppercases api entity names in scheduled job table.

- **ReportTemplate data provider - skip rather than mark incomplete event/income
  ([26808](https://github.com/civicrm/civicrm-core/pull/26808))**

- **Standardize title as Administer in breadcrumbs and on main Administer page
  ([26806](https://github.com/civicrm/civicrm-core/pull/26806))**

- **Upgrade doesn't work
  ([26871](https://github.com/civicrm/civicrm-core/pull/26871))**

- **Ensure that we only check permissions if we want to in getActions follow up
  to #26823 ([26835](https://github.com/civicrm/civicrm-core/pull/26835))**

- **Fix checkbox JS regression for import data selection and email new template
  ([27132](https://github.com/civicrm/civicrm-core/pull/27132))**

- **Fix js error on CiviImport when csv has additional fields
  ([26867](https://github.com/civicrm/civicrm-core/pull/26867))**

- **Scheduled Job Admin: fix breadcrumb
  ([26783](https://github.com/civicrm/civicrm-core/pull/26783))**

- **Run regen, with data fix to allow it to run
  ([26816](https://github.com/civicrm/civicrm-core/pull/26816))**

- **hide view only custom fields on merge screen
  ([26791](https://github.com/civicrm/civicrm-core/pull/26791))**

- **Debounce SK title
  ([26770](https://github.com/civicrm/civicrm-core/pull/26770))**

- **Search kit action links cleanup
  ([26839](https://github.com/civicrm/civicrm-core/pull/26839))**

- **SearchKit - fix min-width of buttons
  ([26843](https://github.com/civicrm/civicrm-core/pull/26843))**

- **SearchKit - Remove irrelevant link from default display
  ([26798](https://github.com/civicrm/civicrm-core/pull/26798))**

- **Notice fix - ensure extends_entity_column_value isset
  ([26846](https://github.com/civicrm/civicrm-core/pull/26846))**

- **E-notice fix (smarty)
  ([26975](https://github.com/civicrm/civicrm-core/pull/26975))**

- **Undefined property fix
  ([26807](https://github.com/civicrm/civicrm-core/pull/26807))**

- **Stop setting unused property & creating notices
  ([26801](https://github.com/civicrm/civicrm-core/pull/26801))**

- **Re-remove TRUE and true IF
  ([26784](https://github.com/civicrm/civicrm-core/pull/26784))**

- **In smarty, TRUE is not true
  ([26780](https://github.com/civicrm/civicrm-core/pull/26780))**

- **Remove 'browse' link that shouldn't be there
  ([26898](https://github.com/civicrm/civicrm-core/pull/26898))**

### CiviCase

- **Clean up CaseSummary Report removing undeclared properties and minor fixes
  ([26826](https://github.com/civicrm/civicrm-core/pull/26826))**

### CiviContribute

- **Undefined index: payment_type
  ([dev/core#4435](https://lab.civicrm.org/dev/core/-/issues/4435):
  [26907](https://github.com/civicrm/civicrm-core/pull/26907))**

  Fixes e-notice with Manual processor

- **fix duplicate id for softCredit
  ([26869](https://github.com/civicrm/civicrm-core/pull/26869))**

- **Fix adding onclick for other_amount in pricesets
  ([27129](https://github.com/civicrm/civicrm-core/pull/27129))**

- **Check `isBackOffice` before checking `billing_profile_id` (e-notice fix)
  ([26960](https://github.com/civicrm/civicrm-core/pull/26960))**

- **Add/edit financial type screen broken
  ([dev/core#4473](https://lab.civicrm.org/dev/core/-/issues/4473):
  [27010](https://github.com/civicrm/civicrm-core/pull/27010))**

### CiviEvent

- **Don't allow scheduled reminders for events to also include groups
  ([dev/core#4377](https://lab.civicrm.org/dev/core/-/issues/4377):
  [26576](https://github.com/civicrm/civicrm-core/pull/26576))**

  Disables broken also include groups feature for event scheduled reminders.

- **Fix missing event pay later receipt text
  ([27335](https://github.com/civicrm/civicrm-core/pull/27335))**

  This resolves a regression in 5.63.0 where pay later text on the receipt would
  appear as "1".

- **Fix bug exposed by invalid data warning
  ([27280](https://github.com/civicrm/civicrm-core/pull/27280))**

  When a event registration is being transferred the email would be sent before
  the line item is transferred. This meant line item in the email would be
  missing in the email. This change resolves this issue.

- **Fix event fee help
  ([27057](https://github.com/civicrm/civicrm-core/pull/27057))**

- **Fix PHP8 tax_rate warning on Participant
  ([26343](https://github.com/civicrm/civicrm-core/pull/26343))**

- **Notice fixes on CiviEvent Component settings form
  ([26957](https://github.com/civicrm/civicrm-core/pull/26957))**

- **Remove meaningless header in batch update participants
  ([26766](https://github.com/civicrm/civicrm-core/pull/26766))**

- **Fix multi-value custom fields on participant import
  ([26926](https://github.com/civicrm/civicrm-core/pull/26926))**

- **Fix enotice on updating a participant on the back end to mark them paid
  ([27324](https://github.com/civicrm/civicrm-core/pull/27324))

### CiviMail

- **CiviMail - throw 400 (Bad Request) rather than 500 (Server Error) if public
  url endpoints hit with bad parameters
  ([dev/core#4298](https://lab.civicrm.org/dev/core/-/issues/4298):
  [26236](https://github.com/civicrm/civicrm-core/pull/26236))**

- **Mail accounts help bubbles not working on edit form
  ([dev/core#4480](https://lab.civicrm.org/dev/core/-/issues/4480):
  [27018](https://github.com/civicrm/civicrm-core/pull/27018))**

- **Non-administrators can't select mailing groups on 5.64
  ([dev/core#4498](https://lab.civicrm.org/dev/core/-/issues/4498):
  [27071](https://github.com/civicrm/civicrm-core/pull/27071))**

### Drupal Integration

- **Use full setting path rather than relative
  ([668](https://github.com/civicrm/civicrm-drupal/pull/668))**

### WordPress Integration

- **E2E_Core_PathUrlTest::testGetUrl_WpAdmin() fails because CiviCRM routing is
  confusing ([dev/core#4433](https://lab.civicrm.org/dev/core/-/issues/4433):
  [26772](https://github.com/civicrm/civicrm-core/pull/26772))**

  Fixes unit test failure on WordPress by specifying --entry=backend.

## <a name="misc"></a>Miscellany

- **Define soon as 'in 9 years'
  ([26958](https://github.com/civicrm/civicrm-core/pull/26958))**

- **Stop setting undeclared property in previously shared code
  ([26909](https://github.com/civicrm/civicrm-core/pull/26909))**

- **Add classes to membership results
  ([26862](https://github.com/civicrm/civicrm-core/pull/26862))**

- **[PHP Deprecation] trim(): Passing null to parameter #1 () of type string
  ([26894](https://github.com/civicrm/civicrm-core/pull/26894))**

- **[PHP8.2] Remove undefined property in favour of calc-as-needed
  ([26916](https://github.com/civicrm/civicrm-core/pull/26916))**

- **[PHP8.2] Convert remaining properties to local variables / private
  properties ([26873](https://github.com/civicrm/civicrm-core/pull/26873))**

- **[php8.2] Fix undeclared properties on case custom data form
  ([26859](https://github.com/civicrm/civicrm-core/pull/26859))**

- **[PHP8.2] move property declaration form CRM_Member_Form_Membership to parent
  ([26860](https://github.com/civicrm/civicrm-core/pull/26860))**

- **Deprecate probably never true condition
  ([26950](https://github.com/civicrm/civicrm-core/pull/26950))**

- **CRM_Utils_System::url - Remove unused param to double-escape html
  ([26888](https://github.com/civicrm/civicrm-core/pull/26888))**

- **Remove unvariable variables from previously shared function
  ([26774](https://github.com/civicrm/civicrm-core/pull/26774))**

- **Remove ts for message that should never be seen by normal people
  ([26938](https://github.com/civicrm/civicrm-core/pull/26938))**

- **Remove never set property from previously shared code
  ([26872](https://github.com/civicrm/civicrm-core/pull/26872))**

- **Remove old broken code
  ([26914](https://github.com/civicrm/civicrm-core/pull/26914))**

- **Remove never-true-if
  ([26858](https://github.com/civicrm/civicrm-core/pull/26858))**

- **Remove `_subName` property
  ([26845](https://github.com/civicrm/civicrm-core/pull/26845))**

- **Remove last reference to undefined property `_subType`
  ([26836](https://github.com/civicrm/civicrm-core/pull/26836))**

- **[PHP8.2] Remove undeclared property
  ([26947](https://github.com/civicrm/civicrm-core/pull/26947))**

- **Follow on cleanup - remove unused assign
  ([26908](https://github.com/civicrm/civicrm-core/pull/26908))**

- **Superficial cleanup in pledge form
  ([26866](https://github.com/civicrm/civicrm-core/pull/26866))**

- **Fold private `setGroupTree` function back into caller
  ([26844](https://github.com/civicrm/civicrm-core/pull/26844))**

- **Fold `preProcess` into `run`
  ([26837](https://github.com/civicrm/civicrm-core/pull/26837))**

- **[Ref] [php8] Unshare shared function
  `CRM_Custom_Form_CustomData::setGroupTree` in order to clean-up
  ([26829](https://github.com/civicrm/civicrm-core/pull/26829))**

- **[REF][PHP8.2] Ref fix deprecation in PHP8.2 about dynamic property _ssID
  ([26838](https://github.com/civicrm/civicrm-core/pull/26838))**

- **[REF] [PHP8.2] Post unshare cleanup
  ([26832](https://github.com/civicrm/civicrm-core/pull/26832))**

- **[REF] [PHP8.2]Treat subType as a internal varible, not a form property
  ([26833](https://github.com/civicrm/civicrm-core/pull/26833))**

- **[REF][PHP8.2] Fix Deprectation notice due to dynamic properties on the
  Contribute History report
  ([26830](https://github.com/civicrm/civicrm-core/pull/26830))**

- **[REF][PHP8.2] Fix deprecated dynamic properties in Logging Report Detail
  ([26828](https://github.com/civicrm/civicrm-core/pull/26828))**

- **[REF][PHP8.2] Fix Dynamic Property Deprecation notice in MultiRecordListing
  ([26827](https://github.com/civicrm/civicrm-core/pull/26827))**

- **[REF][PHP8.2] Move declaration of _actionButtonName from
  CRM_Core_Form_Search to CRM_Core_Form to fix undefined property errors in Job
  Report tests ([26815](https://github.com/civicrm/civicrm-core/pull/26815))**

- **[REF][PHP8.2] Apply PR patch to mimetyper to fix deprecated dynamic property
  ([26821](https://github.com/civicrm/civicrm-core/pull/26821))**

- **[REF][PHP8.2] Resolve PHP8.2 Dynamic property issues by declaring properties
  on the class ([364](https://github.com/civicrm/civicrm-packages/pull/364))**

- **[REF] CRM_Admin_Form - Use metadata instead of boilerplate to set page title
  ([26996](https://github.com/civicrm/civicrm-core/pull/26996))**

- **[REF] Fix poor checking of extends field as per PR #27079 but this time on
  the Amounts tab of the contribution page config
  ([27080](https://github.com/civicrm/civicrm-core/pull/27080))**

- **REF: Rename variables to make it easier to understand what the code is doing
  ([26986](https://github.com/civicrm/civicrm-core/pull/26986))**

- **[REF] CiviGrant - Switch to writeRecord/deleteRecord + BAO hooks
  ([26594](https://github.com/civicrm/civicrm-core/pull/26594))**

- **[Ref] Use `isQuickConfig` function, rather than repetitively looking it up
  ([26814](https://github.com/civicrm/civicrm-core/pull/26814))**

- **REF - Split variable assignments out of conditionals
  ([26918](https://github.com/civicrm/civicrm-core/pull/26918))**

- **[REF] Fix CRM_Utils_Array calls that return potentially incorrect value
  types ([26899](https://github.com/civicrm/civicrm-core/pull/26899))**

- **[REF] LocationType - Set defaults, modernize form and BAO
  ([26878](https://github.com/civicrm/civicrm-core/pull/26878))**

- **[REF] Ensure that url that is stored as context is generated correctly for
  backend usage in wordpress
  ([26868](https://github.com/civicrm/civicrm-core/pull/26868))**

- **ScheduledReminders - Refactor form to work at a standalone url
  ([26884](https://github.com/civicrm/civicrm-core/pull/26884))**

- **[REF] ScheduleReminders - Cleanup "sublimely stupid" form code
  ([26876](https://github.com/civicrm/civicrm-core/pull/26876))**

- **[REF] ActionMapping - Improve class structure
  ([26855](https://github.com/civicrm/civicrm-core/pull/26855))**

- **(REF) CMSUser::create - Rename misleading parameter
  ([26850](https://github.com/civicrm/civicrm-core/pull/26850))**

- **[REF] Use internal variable rather than property to pass variable
  ([26834](https://github.com/civicrm/civicrm-core/pull/26834))**

- **[REF] Stop passing `result` into `getContributionParams` to get one value
  from it, in one code path
  ([26776](https://github.com/civicrm/civicrm-core/pull/26776))**

- **[Ref] Minor cleanup on handling of financial type
  ([26775](https://github.com/civicrm/civicrm-core/pull/26775))**

- **[REF] Ensure that getActions respects any modifications by event listerners
  modifying permissions
  ([26823](https://github.com/civicrm/civicrm-core/pull/26823))**

- **[REF] Clarify loading of PriceSetID
  ([26778](https://github.com/civicrm/civicrm-core/pull/26778))**

- **[REF] Add a note in documentation of CRM_Utils_Mail::send to clarify array
  keys are case specific and replace some CRM_Utils_Array::value
  ([26803](https://github.com/civicrm/civicrm-core/pull/26803))**

- **NFC: Update translation file
  ([299](https://github.com/civicrm/civicrm-wordpress/pull/299))**

- **[NFC] setup/plugins/init/StandaloneUsers: fix missing closing quote in log
  message ([26781](https://github.com/civicrm/civicrm-core/pull/26781))**

- **(NFC) Civi\ESM - Doc cleanups
  ([26813](https://github.com/civicrm/civicrm-core/pull/26813))**

- **[NFC] Replace nonstandard copyright headers with the standard one
  ([26822](https://github.com/civicrm/civicrm-core/pull/26822))**

- **[NFC] New Event: remove empty table row
  ([26848](https://github.com/civicrm/civicrm-core/pull/26848))**

- **[NFC] Delete unused boilerplate comments
  ([26864](https://github.com/civicrm/civicrm-core/pull/26864))**

- **[NFC][PHP8.2] Fix dynamic property _loggedInUser
  ([26856](https://github.com/civicrm/civicrm-core/pull/26856))**

- **[PHP8.x] Stop setting undeclared, unused property in test
  ([26819](https://github.com/civicrm/civicrm-core/pull/26819))**

- **Fix mis-cased apiVersion causing php8.x fails in SavedSearchTest
  ([26820](https://github.com/civicrm/civicrm-core/pull/26820))**

- **[php8.x] Fix test to use full form flow
  ([26962](https://github.com/civicrm/civicrm-core/pull/26962))**

- **Update tests to ignore packaged saved searches
  ([26924](https://github.com/civicrm/civicrm-core/pull/26924))**

- **Reduce test fails on edge for Contact_Detail report
  ([26818](https://github.com/civicrm/civicrm-core/pull/26818))**

- **Minor cleanup in test class
  ([26912](https://github.com/civicrm/civicrm-core/pull/26912))**

- **Cleanup test class, including fix undeclared property
  ([26874](https://github.com/civicrm/civicrm-core/pull/26874))**

- **Fix undeclared property in SyntaxConformanceTests
  ([26817](https://github.com/civicrm/civicrm-core/pull/26817))**

- **[tests][php8.2] Use function rather than sometimes declared property for
  loggedInUserID ([26857](https://github.com/civicrm/civicrm-core/pull/26857))**

- **ManagedEntityTest - Simplify reconciliation
  ([26971](https://github.com/civicrm/civicrm-core/pull/26971))**

- **Limit Managed Entity test reconciliation to the entities in the test
  ([26970](https://github.com/civicrm/civicrm-core/pull/26970))**

- **Update ContributionMainTest to use full form flow
  ([26949](https://github.com/civicrm/civicrm-core/pull/26949))**

- **Move turning logging off to the tearDown
  ([26809](https://github.com/civicrm/civicrm-core/pull/26809))**

- **Minor improvement in test set up function
  ([26917](https://github.com/civicrm/civicrm-core/pull/26917))**

- **Fix saved search test when there is an existing managed saved search
  ([26954](https://github.com/civicrm/civicrm-core/pull/26954))**

- **God has answered
  ([26877](https://github.com/civicrm/civicrm-core/pull/26877))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt;  Artful Robot - Rich Lott; Benjamin W; Christian
Wach; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; Coop
SymbioTIC - Mathieu Lutfy; Dave D; JMA Consulting - Seamus Lee; Megaphone
Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire; PERORA
SRL - Samuele Masetto; Progressive Technology Project - Jamie McClelland;
Squiffle Consulting - Aidan Saunders; Third Sector Design - Kurund Jalmi;
Wikimedia Foundation - Eileen McNaughton; Wildsight - Lars Sander-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; Australian Greens - John Twyman; Bob Silvern;
BrightMinded Ltd - Bradley Taylor; Circle Interactive - Pradeep Nayak;
Humanists UK - Andrew West; JMA Consulting - Joe Murray, Monish Deb; Korlon -
Stuart Gaston; Megaphone Technology Consulting - Brienne Kordis; Ranjit Pahan;
Richard Baugh; Richard van Oosterhout; Semper IT - Karin Gerritsen; RIPS
Technologies - Dennis Brinkrolf; Tadpole Collective - Kevin Cristiano; Third
Sector Design - William Mortada; Uepal - Jean-Marie Heitz; xavi-xaloc

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
