# CiviCRM 5.62.0

Released June 7, 2023

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Importer - Add system-setting for batch size
  ([26125](https://github.com/civicrm/civicrm-core/pull/26125))**

  Adds a setting for import batch size.

- **Add target contact custom data to activity report
  ([26137](https://github.com/civicrm/civicrm-core/pull/26137))**

  Adds custom fields for the target contact to the activity report.

- **API4: add SQL Function DAYOFWEEK
  ([26063](https://github.com/civicrm/civicrm-core/pull/26063))**

  Adds day of week functions as SQL transformation. Let's you do things like
  'find events on Wednesdays'.

- **APIv4 - Fix customValue fieldSpec to include input types & labels
  ([26009](https://github.com/civicrm/civicrm-core/pull/26009))**

  Adds necessary metadata to allow multirecord-custom-field entities to filter
  by contact in Afform.

- **API4: Add DAYSTOANNIV function
  ([26062](https://github.com/civicrm/civicrm-core/pull/26062))**

  Adds a DAYSTOANNIV function to generalize the 'days to next birthday'
  calculated field to be applicable to any date field.

- **APIv4 Explorer - Translate localizable strings in php output
  ([26058](https://github.com/civicrm/civicrm-core/pull/26058))**

  Displays localizable strings wrapped in E::ts() when using PHP output in the
  APIv4 explorer.

- **Add sql QUARTER function
  ([26061](https://github.com/civicrm/civicrm-core/pull/26061))**

  Adds QUARTER sql function for use in Api4 / Search Kit.

- **Support APCu with apcu_* functions
  ([dev/core#4243](https://lab.civicrm.org/dev/core/-/issues/4243):
  [26073](https://github.com/civicrm/civicrm-core/pull/26073))**

  Adds support for APCu functions.

- **Afform - Allow selecting search operator for filter fields
  ([26066](https://github.com/civicrm/civicrm-core/pull/26066))**

  Makes it so users can select search operators for Afform filter fields.

- **SearchKit - Display option values for field transformations
  ([26065](https://github.com/civicrm/civicrm-core/pull/26065))**

  Takes advantage of function option lists in SearchKit output, e.g. this
  will show Janurary instead of 1 for the Month-Only transformation.

- **RecentItems - Improve automatic url construction
  ([24662](https://github.com/civicrm/civicrm-core/pull/24662))**

  Improves the automatic construction of URLs to include tokens other than [id],
  which allows switching the CiviGrant extension to use the api. It also paves
  the way for the ECK extension to integrate with RecentItems.

- **Scheduled Jobs - add dedicated url's for add, edit/delete
  ([26056](https://github.com/civicrm/civicrm-core/pull/26056))**

  In preparation for a 'Manage Scheduled Jobs' screen in the Admin UI extension,
  this updates the URL's for adding, editing and deleting Jobs so it does not
  conflict with the URL for managing scheduled jobs.

- **CustomField - Support filters in EntityReference fields
  ([25960](https://github.com/civicrm/civicrm-core/pull/25960))**

  Adds basic support for filters on the new custom field type EntityReference.

- **Make enable_components a non-domain setting
  ([26043](https://github.com/civicrm/civicrm-core/pull/26043))**

  Makes `enable_components` a global setting rather than domain-specific.

- **Add user-friendly label to contact.image_URL field
  ([26097](https://github.com/civicrm/civicrm-core/pull/26097))**

  Adds a friendlier user-facing label to the Contact.image_URL field.

- **Finish making legacycustomsearches optional
  ([dev/core#4112](https://lab.civicrm.org/dev/core/-/issues/4112):
  [25504](https://github.com/civicrm/civicrm-core/pull/25504))**

  Separate code to handle exporting legacy custom searches into the extension.

- **Update success.tpl CSS (pre/post upgrade messages)
  ([25961](https://github.com/civicrm/civicrm-core/pull/25961))**

  Makes pre and post upgrade messages prettier.

### CiviContribute

- **Add regions to the Contribute Dashboard Page
  ([26100](https://github.com/civicrm/civicrm-core/pull/26100))**

  Adds regions to the Contribute Dashboard page to make it easier for developers
  to customize it.

### CiviMail

- **Mailing - Rename trackable URL entities for consistency and add APIv4
  ([26016](https://github.com/civicrm/civicrm-core/pull/26016))**

  Adds missing APIs for tracking click-throughs in sent mailings.

### Drupal Integration

- **Event ID contextual filter
  ([664](https://github.com/civicrm/civicrm-drupal/pull/664))**

  Makes it so one can use the Event ID as a contextual filter for blocks
  displayed on event info pages.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Search string on a custom contact field is escaped too many times
  ([dev/core#1340](https://lab.civicrm.org/dev/core/-/issues/1340):
  [26018](https://github.com/civicrm/civicrm-core/pull/26018))**

- **Custom radio fields do not allow both a clear button and a maximum options
  per line ([dev/core#1821](https://lab.civicrm.org/dev/core/-/issues/1821):
  [26110](https://github.com/civicrm/civicrm-core/pull/26110))**

- **Preserve pristine ids' for further manipulation via hooks for reports
  ([dev/core#2855](https://lab.civicrm.org/dev/core/-/issues/2855):
  [26144](https://github.com/civicrm/civicrm-core/pull/26144))**

- **Fix lack of price set options for edit registration from search results
  ([24671](https://github.com/civicrm/civicrm-core/pull/24671))**

- **Clicking View and Edit Price Fields for a Price Set no longer tells you
  which pages/events it's being used in
  ([dev/core#4248](https://lab.civicrm.org/dev/core/-/issues/4248):
  [26090](https://github.com/civicrm/civicrm-core/pull/26090))**

- **Search results include participants with price set options they have been
  removed from ([dev/core#3885](https://lab.civicrm.org/dev/core/-/issues/3885):
  [24650](https://github.com/civicrm/civicrm-core/pull/24650))**

  Only find fee levels with qty > 0 for participant and advanced search.

- **AFFORM: numerical fields are not checked when the form is submitted
  ([dev/core#4115](https://lab.civicrm.org/dev/core/-/issues/4115):
  [26124](https://github.com/civicrm/civicrm-core/pull/26124))**

- **Make civicrm_mapping.name required and fix index to be unique
  ([26055](https://github.com/civicrm/civicrm-core/pull/26055))**

- **Mapping.mapping_id does not resolve in api v4 explorer
  ([dev/core#4226](https://lab.civicrm.org/dev/core/-/issues/4226):
  [26046](https://github.com/civicrm/civicrm-core/pull/26046))**

  Adds labelField metadata for mapping entity.

- **Contact import (new) deletes contact fields
  ([dev/core#4227](https://lab.civicrm.org/dev/core/-/issues/4227):
  [26172](https://github.com/civicrm/civicrm-core/pull/26172))**

  Fixes import to not blank birth_date etc on update.

- **Formbuilder: Labels of filters double-escape html
  ([dev/core#4242](https://lab.civicrm.org/dev/core/-/issues/4242):
  [26069](https://github.com/civicrm/civicrm-core/pull/26069))**

  Fix double-escape of Formbuilder form labels.

- **Dblog warning: pass an array for included groups Caller:
  CRM_ACL_API::groupPermission Array ( [civi.tag] => deprecated )
  ([dev/core#4249](https://lab.civicrm.org/dev/core/-/issues/4249):
  [26086](https://github.com/civicrm/civicrm-core/pull/26086))**

- **Auto detect line endings Deprecated
  ([dev/core#4262](https://lab.civicrm.org/dev/core/-/issues/4262):
  [26139](https://github.com/civicrm/civicrm-core/pull/26139) and
  [26136](https://github.com/civicrm/civicrm-core/pull/26136))**

  Drop auto_detect_line_endings from civicrm.settings.php.template and add
  upgrade message.

- **Revert "Remove old deprecated class aliases"
  ([dev/core#4302](https://lab.civicrm.org/dev/core/-/issues/4302):
  [26271](https://github.com/civicrm/civicrm-core/pull/26271))**

- **Custom field post help results in "Unable to load help file."
  ([dev/core#4303](https://lab.civicrm.org/dev/core/-/issues/4303):
  [26298](https://github.com/civicrm/civicrm-core/pull/26298))**

- **Membership HTML output on contribution pages causing layout errors due to
  unclosed div - 5.61 regression
  ([dev/core#4310](https://lab.civicrm.org/dev/core/-/issues/4310):
  [26320](https://github.com/civicrm/civicrm-core/pull/26320))**

- **APIv4 - Remove incorrect EntityBridge from UFMatch entity
  ([26109](https://github.com/civicrm/civicrm-core/pull/26109))**

- **APIv4 - Enforce custom group permissions when loading metadata
  ([25920](https://github.com/civicrm/civicrm-core/pull/25920))**

- **APIv4 Explorer - Don't translate empty strings
  ([26332](https://github.com/civicrm/civicrm-core/pull/26332))**

- **[SearchKit] Do not crash on entities without fields
  ([26045](https://github.com/civicrm/civicrm-core/pull/26045))**

- **SearchKit - Support the `Group.parents` field
  ([25994](https://github.com/civicrm/civicrm-core/pull/25994))**

  Enables Group.parents field to function correctly in SearchKit.

- **Fix broken wysiwyg fields in Afforms due to timing issue
  ([26030](https://github.com/civicrm/civicrm-core/pull/26030))**

- **Afform - Consistently save 'contact_summary' = null
  ([26076](https://github.com/civicrm/civicrm-core/pull/26076))**

- **Afform: Add required flag to select2
  ([25535](https://github.com/civicrm/civicrm-core/pull/25535))**

- **Afform - support field defaults from the url even when in a popup
  ([26028](https://github.com/civicrm/civicrm-core/pull/26028))**

- **Fix show_public regression
  ([26308](https://github.com/civicrm/civicrm-core/pull/26308))**

- **Import help text gone missing
  ([26252](https://github.com/civicrm/civicrm-core/pull/26252))**

- **setup - Fix uninstall on MySQL 8.0
  ([26239](https://github.com/civicrm/civicrm-core/pull/26239))**

  Fixes a bug with uninstalling or reinstalling via cv (cv core:uninstall or cv
  core:install -f) on MySQL 8.0.

- **Fix notice on Constituent Summary report (strict smarty)
  ([26130](https://github.com/civicrm/civicrm-core/pull/26130))**

- **Further notice fixes on Constituent report
  ([26131](https://github.com/civicrm/civicrm-core/pull/26131))**

- **Use settings::get instead of $config object to retrieve enabled components
  ([26121](https://github.com/civicrm/civicrm-core/pull/26121))**

- **Don't add newlines into HTML emails when viewing activities
  ([24900](https://github.com/civicrm/civicrm-core/pull/24900))**

- **FiveSixtyTwo - Improve detection of identical configurations
  ([26150](https://github.com/civicrm/civicrm-core/pull/26150))**

- **Use label from schema instead of title for selects on QuickForms
  ([26105](https://github.com/civicrm/civicrm-core/pull/26105))**

- **Expire notifications for adding and removing groups, tags and relationships
  ([26138](https://github.com/civicrm/civicrm-core/pull/26138))**

- **PriceSet - Fix metadata for extends column, for SearchKit compatibility
  ([24765](https://github.com/civicrm/civicrm-core/pull/24765))**

  Fixes not-so-accurate metadata on the extends column in the PriceSet entity.

- **Include subtypes if passed to avoid 61 join limit for Mysql on Custom group
  ([26096](https://github.com/civicrm/civicrm-core/pull/26096))**

- **Enhance metadata for CustomField/Group
  ([26095](https://github.com/civicrm/civicrm-core/pull/26095))**

- **Don't show email receipt option for on hold emails when adding contribution
  and selecting contact
  ([25403](https://github.com/civicrm/civicrm-core/pull/25403))**

- **Add option group file_type
  ([25904](https://github.com/civicrm/civicrm-core/pull/25904))**

- **Surveys: Fix I18n translation support and WYSIWYG support
  ([26135](https://github.com/civicrm/civicrm-core/pull/26135))**

- **empty pseudoconstant string on create causes an error
  ([26098](https://github.com/civicrm/civicrm-core/pull/26098))**

- **Use `mb_strtolower` rathter than `strtolower` to compare translated strings
  ([26017](https://github.com/civicrm/civicrm-core/pull/26017))**

- **Fix missing change from #25918
  ([26094](https://github.com/civicrm/civicrm-core/pull/26094))**

- **Enotice fix on frontend_title
  ([26267](https://github.com/civicrm/civicrm-core/pull/26267))**

- **Minor fixes around linting
  ([26033](https://github.com/civicrm/civicrm-core/pull/26033))**

- **Fix e-notice & php8.2 issue on user dashboard
  ([25545](https://github.com/civicrm/civicrm-core/pull/25545))**

- **htxt undetected opening tag
  ([26079](https://github.com/civicrm/civicrm-core/pull/26079))**

- **Referencing not needed
  ([26101](https://github.com/civicrm/civicrm-core/pull/26101))**

### CiviCase

- **CiviCRM Activity Revisions - still some code that uses this in core
  ([dev/core#4220](https://lab.civicrm.org/dev/core/-/issues/4220):
  [26039](https://github.com/civicrm/civicrm-core/pull/26039),
  [26037](https://github.com/civicrm/civicrm-core/pull/26037),
  [26091](https://github.com/civicrm/civicrm-core/pull/26091) and
  [26092](https://github.com/civicrm/civicrm-core/pull/26092))**

- **Migrate case activity revisions to trigger-based logging
  (Work Towards
  [dev/core/#1532](https://lab.civicrm.org/dev/core/-/issues/1532):
  [26149](https://github.com/civicrm/civicrm-core/pull/26149))**

  Adds warning if Activity Revisions are present.

- **Upgrade - don't set nonexistant 'civicaseActivityRevisions' setting
  ([26048](https://github.com/civicrm/civicrm-core/pull/26048))**

### CiviContribute

- **Contribution reports, specify type for is pledge payment
  ([26132](https://github.com/civicrm/civicrm-core/pull/26132))**

- **Update BillingBlock.tpl - Error with CiviDiscount + Patch Issue #24781
  ([26064](https://github.com/civicrm/civicrm-core/pull/26064))**

### CiviEvent

- **fix import of participant role ID
  ([25945](https://github.com/civicrm/civicrm-core/pull/25945))**

### CiviGrant

- **CiviGrant - Fix upgrade to work on multiple domains
  ([26118](https://github.com/civicrm/civicrm-core/pull/26118))**

### CiviMail

- **CRM_Mailing_Selector_Browse: fix typo in local variable name
  ([26106](https://github.com/civicrm/civicrm-core/pull/26106))**

- **tell search engines not to index click-through URLs
  ([26050](https://github.com/civicrm/civicrm-core/pull/26050))**

### CiviMember

- **Membership for regression in 5.61
  ([dev/core#4282](https://lab.civicrm.org/dev/core/-/issues/4282):
  [26268](https://github.com/civicrm/civicrm-core/pull/26268))**

  Fixes isShowMembershipBlock Regression in 5.61.

- **Regression: Fatal error when importing membership
  ([26199](https://github.com/civicrm/civicrm-core/pull/26199))**

- **Fix regression whereby membership does not submit
  ([26170](https://github.com/civicrm/civicrm-core/pull/26170) and
  [26193](https://github.com/civicrm/civicrm-core/pull/26193))**

- **Offline membership receipt - custom message text is wrong
  ([26128](https://github.com/civicrm/civicrm-core/pull/26128))**

- **Update membership offline receipt to run off WorkflowTemplate & tokens
  ([25930](https://github.com/civicrm/civicrm-core/pull/25930))**

### Drupal Integration

- **Make the `args` route parameter a string, avoiding a TypeError with Drupal
  9.5.9 ([82](https://github.com/civicrm/civicrm-drupal-8/pull/82))**

- **Fix warnings on non-civi pages from recently fixed args param
  ([85](https://github.com/civicrm/civicrm-drupal-8/pull/85))**

- **Upgrade message for drupal9 sites to advise to clear drupal cache
  ([26159](https://github.com/civicrm/civicrm-core/pull/26159))**

- **Fix unreplaced template vars in civicrm.settings.php when using drush
  installer ([650](https://github.com/civicrm/civicrm-drupal/pull/650))**

## <a name="misc"></a>Miscellany

- **Re-order Contact fields in table,DAO
  ([26014](https://github.com/civicrm/civicrm-core/pull/26014))**

- **Bump minimum upgradable version to 4.7.32
  ([26049](https://github.com/civicrm/civicrm-core/pull/26049))**

- **Clarify return on `BAO_Activity::create`
  ([26022](https://github.com/civicrm/civicrm-core/pull/26022))**

- **Update a few references to `list()`
  ([26023](https://github.com/civicrm/civicrm-core/pull/26023))**

- **Replace deprecated functions in financialtrxn BAO
  ([26057](https://github.com/civicrm/civicrm-core/pull/26057))**

- **This doesn't belong here
  ([26038](https://github.com/civicrm/civicrm-core/pull/26038))**

- **I am Hu
  ([26032](https://github.com/civicrm/civicrm-core/pull/26032))**

- **Deprecate unused 'validContact' function
  ([26075](https://github.com/civicrm/civicrm-core/pull/26075))**

- **Code cleanup ([26102](https://github.com/civicrm/civicrm-core/pull/26102))**

- **Contributors: semseysandor - change of organization
  ([26107](https://github.com/civicrm/civicrm-core/pull/26107))**

- **Remove notices on group_by i reports (eg pledge report)
  ([26134](https://github.com/civicrm/civicrm-core/pull/26134))**

- **Remove unused broken $config->geocodeMethod
  ([26122](https://github.com/civicrm/civicrm-core/pull/26122))**

- **Remove "and Time" from registration date label on view Participant
  ([26104](https://github.com/civicrm/civicrm-core/pull/26104))**

- **Removes failing patch
  ([26080](https://github.com/civicrm/civicrm-core/pull/26080))**

- **Remove unnecessary count() from smarty conditionals
  ([26070](https://github.com/civicrm/civicrm-core/pull/26070))**

- **Remove some ;
  ([26053](https://github.com/civicrm/civicrm-core/pull/26053))**

- **Remove a couple of unused variables
  ([26052](https://github.com/civicrm/civicrm-core/pull/26052))**

- **Remove almost all remaining handling for preferred_mail_format
  ([26040](https://github.com/civicrm/civicrm-core/pull/26040))**

- **Remove traces of preferred mail format from communication preferences
  ([26020](https://github.com/civicrm/civicrm-core/pull/26020))**

- **Remove old deprecated class aliases
  ([26025](https://github.com/civicrm/civicrm-core/pull/26025))**

- **Remove references to preferred_mail_format from examples
  ([26019](https://github.com/civicrm/civicrm-core/pull/26019))**

- **Remove some uses of legacy array format (`array()`)
  ([26024](https://github.com/civicrm/civicrm-core/pull/26024))**

- **Remove a long-deprecated bit of code
  ([26021](https://github.com/civicrm/civicrm-core/pull/26021))**

- **REF - Noisily deprecate BAO::retrieve functions
  ([25984](https://github.com/civicrm/civicrm-core/pull/25984))**

- **[REF] Bump socket.io-parser to 4.2.3
  ([26321](https://github.com/civicrm/civicrm-core/pull/26321))**

- **[REF] Update league/csv package to 9.7.4 to remove need for patching
  ([26126](https://github.com/civicrm/civicrm-core/pull/26126))**

- **[REF] Fix an additional htxt id issue similar to #26079
  ([26084](https://github.com/civicrm/civicrm-core/pull/26084))**

- **[REF] Clarify not-so-great code in the Group BAO
  ([26074](https://github.com/civicrm/civicrm-core/pull/26074))**

- **[REF][PHP8.2] Add cookieExpire property to CRM_Campaign_BAO_Petition
  ([26034](https://github.com/civicrm/civicrm-core/pull/26034))**

- **[REF] CoreComponent - Standardize on isEnabled function and remove unused
  code ([26031](https://github.com/civicrm/civicrm-core/pull/26031))**

- **REF - Update ContactType BAO to use writeRecord, deprecated add function
  ([26006](https://github.com/civicrm/civicrm-core/pull/26006))**

- **REF - Deprecate RelationshipType add function in favor of writeRecord
  ([26007](https://github.com/civicrm/civicrm-core/pull/26007))**

- **[NFC] Add comment about secondary todo when deprecated function is removed
  ([26077](https://github.com/civicrm/civicrm-core/pull/26077))**

- **[NFC] Hook - Clarify param docs for hook_civicrm_aclGroup
  ([26054](https://github.com/civicrm/civicrm-core/pull/26054))**

- **(NFC) PHPdoc fixes and improvements
  ([26035](https://github.com/civicrm/civicrm-core/pull/26035))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Agileware - Francis Whittle; BrightMinded Ltd -
Bradley Taylor; Circle Interactive - Pradeep Nayak; CiviCRM - Coleman Watts,
Tim Otten; CiviDesk - Yashodha Chaku; Coop SymbioTIC - Mathieu Lutfy, Samuel
Vanhove; Dave D; Freeform Solutions - Herb van den Dool; Fuzion - Luke Stewart;
Greyson Stalcup; Humanists UK - Andrew West; Jens Schuppe; JMA Consulting -
Seamus Lee; Lighthouse Consulting and Design - Brian Shaughnessy; Megaphone
Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire; Reflexive
Communications - Sandor Semsey; Registered Nurses' Association of Ontario - Ian
Wilson; Squiffle Consulting - Aidan Saunders; Wikimedia Foundation - Damilare
Adedoyin, Eileen McNaughton; Wildsight - Lars Sanders-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; ALL IN APPLI admin; Andreas Howiller; Christian
Wach; Circle Interactive - Dave Jenkins; Joinery - Allen Shaw; Klangsoft - David
Reedy Jr; Makoa - Usha F. Matisson; Nicol Wistreich; peth-systopia; Richard
Baugh; Semper IT - Karin Gerritsen; Skvare - Mark Hanna; Slanted Hall digital
type foundry - Jeff Kellem; Systopia - Dominic Tubach, Tycho Schottelius

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
