<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2018
 *
 * Generated from xml/schema/CRM/Price/PriceField.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:6ee89c3106c27af4ca96897826a2ef8c)
 */

/**
 * Database access object for the PriceField entity.
 */
class CRM_Price_DAO_PriceField extends CRM_Core_DAO {

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_price_field';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  static $_log = TRUE;

  /**
   * Price Field
   *
   * @var int unsigned
   */
  public $id;

  /**
   * FK to civicrm_price_set
   *
   * @var int unsigned
   */
  public $price_set_id;

  /**
   * Variable name/programmatic handle for this field.
   *
   * @var string
   */
  public $name;

  /**
   * Text for form field label (also friendly name for administering this field).
   *
   * @var string
   */
  public $label;

  /**
   * @var string
   */
  public $html_type;

  /**
   * Enter a quantity for this field?
   *
   * @var boolean
   */
  public $is_enter_qty;

  /**
   * Description and/or help text to display before this field.
   *
   * @var text
   */
  public $help_pre;

  /**
   * Description and/or help text to display after this field.
   *
   * @var text
   */
  public $help_post;

  /**
   * Order in which the fields should appear
   *
   * @var int
   */
  public $weight;

  /**
   * Should the price be displayed next to the label for each option?
   *
   * @var boolean
   */
  public $is_display_amounts;

  /**
   * number of options per line for checkbox and radio
   *
   * @var int unsigned
   */
  public $options_per_line;

  /**
   * Is this price field active
   *
   * @var boolean
   */
  public $is_active;

  /**
   * Is this price field required (value must be > 1)
   *
   * @var boolean
   */
  public $is_required;

  /**
   * If non-zero, do not show this field before the date specified
   *
   * @var datetime
   */
  public $active_on;

  /**
   * If non-zero, do not show this field after the date specified
   *
   * @var datetime
   */
  public $expire_on;

  /**
   * Optional scripting attributes for field
   *
   * @var string
   */
  public $javascript;

  /**
   * Implicit FK to civicrm_option_group with name = 'visibility'
   *
   * @var int unsigned
   */
  public $visibility_id;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_price_field';
    parent::__construct();
  }

  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  public static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'price_set_id', 'civicrm_price_set', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Price Field ID'),
          'description' => 'Price Field',
          'required' => TRUE,
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
        ],
        'price_set_id' => [
          'name' => 'price_set_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Price Set'),
          'description' => 'FK to civicrm_price_set',
          'required' => TRUE,
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'FKClassName' => 'CRM_Price_DAO_PriceSet',
        ],
        'name' => [
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Name'),
          'description' => 'Variable name/programmatic handle for this field.',
          'required' => TRUE,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'label' => [
          'name' => 'label',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Label'),
          'description' => 'Text for form field label (also friendly name for administering this field).',
          'required' => TRUE,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'html_type' => [
          'name' => 'html_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Html Type'),
          'required' => TRUE,
          'maxlength' => 12,
          'size' => CRM_Utils_Type::TWELVE,
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Price_BAO_PriceField::htmlTypes',
          ]
        ],
        'is_enter_qty' => [
          'name' => 'is_enter_qty',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Price Field Quantity Required?'),
          'description' => 'Enter a quantity for this field?',
          'default' => '0',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'help_pre' => [
          'name' => 'help_pre',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Price Field Pre Text'),
          'description' => 'Description and/or help text to display before this field.',
          'rows' => 4,
          'cols' => 80,
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
        ],
        'help_post' => [
          'name' => 'help_post',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Price Field Post Text'),
          'description' => 'Description and/or help text to display after this field.',
          'rows' => 4,
          'cols' => 80,
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
        ],
        'weight' => [
          'name' => 'weight',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Order'),
          'description' => 'Order in which the fields should appear',
          'default' => '1',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
        ],
        'is_display_amounts' => [
          'name' => 'is_display_amounts',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Price Field Show Amounts?'),
          'description' => 'Should the price be displayed next to the label for each option?',
          'default' => '1',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'options_per_line' => [
          'name' => 'options_per_line',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Price Field Options per Row'),
          'description' => 'number of options per line for checkbox and radio',
          'default' => '1',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'is_active' => [
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Price Field Is Active?'),
          'description' => 'Is this price field active',
          'default' => '1',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'is_required' => [
          'name' => 'is_required',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Price Field is Required?'),
          'description' => 'Is this price field required (value must be > 1)',
          'default' => '1',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'active_on' => [
          'name' => 'active_on',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Price Field Start Date'),
          'description' => 'If non-zero, do not show this field before the date specified',
          'default' => 'NULL',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'expire_on' => [
          'name' => 'expire_on',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Price Field End Date'),
          'description' => 'If non-zero, do not show this field after the date specified',
          'default' => 'NULL',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
          ],
        ],
        'javascript' => [
          'name' => 'javascript',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Price Field Javascript'),
          'description' => 'Optional scripting attributes for field',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'visibility_id' => [
          'name' => 'visibility_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Price Field Visibility'),
          'description' => 'Implicit FK to civicrm_option_group with name = \'visibility\'',
          'default' => '1',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'visibility',
            'optionEditPath' => 'civicrm/admin/options/visibility',
          ]
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return CRM_Core_DAO::getLocaleTableName(self::$_tableName);
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'price_field', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'price_field', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'index_name' => [
        'name' => 'index_name',
        'field' => [
          0 => 'name',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_price_field::0::name',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
