<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2018
 *
 * Generated from xml/schema/CRM/Batch/Batch.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:a9d49cd47b4a388ca88aa2af363f952d)
 */

/**
 * Database access object for the Batch entity.
 */
class CRM_Batch_DAO_Batch extends CRM_Core_DAO {

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_batch';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  static $_log = FALSE;

  /**
   * Unique Address ID
   *
   * @var int unsigned
   */
  public $id;

  /**
   * Variable name/programmatic handle for this batch.
   *
   * @var string
   */
  public $name;

  /**
   * Friendly Name.
   *
   * @var string
   */
  public $title;

  /**
   * Description of this batch set.
   *
   * @var text
   */
  public $description;

  /**
   * FK to Contact ID
   *
   * @var int unsigned
   */
  public $created_id;

  /**
   * When was this item created
   *
   * @var datetime
   */
  public $created_date;

  /**
   * FK to Contact ID
   *
   * @var int unsigned
   */
  public $modified_id;

  /**
   * When was this item created
   *
   * @var datetime
   */
  public $modified_date;

  /**
   * FK to Saved Search ID
   *
   * @var int unsigned
   */
  public $saved_search_id;

  /**
   * fk to Batch Status options in civicrm_option_values
   *
   * @var int unsigned
   */
  public $status_id;

  /**
   * fk to Batch Type options in civicrm_option_values
   *
   * @var int unsigned
   */
  public $type_id;

  /**
   * fk to Batch mode options in civicrm_option_values
   *
   * @var int unsigned
   */
  public $mode_id;

  /**
   * Total amount for this batch.
   *
   * @var float
   */
  public $total;

  /**
   * Number of items in a batch.
   *
   * @var int unsigned
   */
  public $item_count;

  /**
   * fk to Payment Instrument options in civicrm_option_values
   *
   * @var int unsigned
   */
  public $payment_instrument_id;

  /**
   * @var datetime
   */
  public $exported_date;

  /**
   * cache entered data
   *
   * @var longtext
   */
  public $data;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_batch';
    parent::__construct();
  }

  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  public static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'created_id', 'civicrm_contact', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'modified_id', 'civicrm_contact', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'saved_search_id', 'civicrm_saved_search', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Batch ID'),
          'description' => 'Unique Address ID',
          'required' => TRUE,
          'table_name' => 'civicrm_batch',
          'entity' => 'Batch',
          'bao' => 'CRM_Batch_BAO_Batch',
          'localizable' => 0,
        ],
        'name' => [
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Batch Name'),
          'description' => 'Variable name/programmatic handle for this batch.',
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'table_name' => 'civicrm_batch',
          'entity' => 'Batch',
          'bao' => 'CRM_Batch_BAO_Batch',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'title' => [
          'name' => 'title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Batch Title'),
          'description' => 'Friendly Name.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_batch',
          'entity' => 'Batch',
          'bao' => 'CRM_Batch_BAO_Batch',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'description' => [
          'name' => 'description',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Batch Description'),
          'description' => 'Description of this batch set.',
          'rows' => 4,
          'cols' => 80,
          'table_name' => 'civicrm_batch',
          'entity' => 'Batch',
          'bao' => 'CRM_Batch_BAO_Batch',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
        ],
        'created_id' => [
          'name' => 'created_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Batch Created By'),
          'description' => 'FK to Contact ID',
          'table_name' => 'civicrm_batch',
          'entity' => 'Batch',
          'bao' => 'CRM_Batch_BAO_Batch',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
        ],
        'created_date' => [
          'name' => 'created_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Batch Created Date'),
          'description' => 'When was this item created',
          'table_name' => 'civicrm_batch',
          'entity' => 'Batch',
          'bao' => 'CRM_Batch_BAO_Batch',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
          ],
        ],
        'modified_id' => [
          'name' => 'modified_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Batch Modified By'),
          'description' => 'FK to Contact ID',
          'table_name' => 'civicrm_batch',
          'entity' => 'Batch',
          'bao' => 'CRM_Batch_BAO_Batch',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
        ],
        'modified_date' => [
          'name' => 'modified_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Batch Modified Date'),
          'description' => 'When was this item created',
          'table_name' => 'civicrm_batch',
          'entity' => 'Batch',
          'bao' => 'CRM_Batch_BAO_Batch',
          'localizable' => 0,
        ],
        'saved_search_id' => [
          'name' => 'saved_search_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Batch Smart Group'),
          'description' => 'FK to Saved Search ID',
          'table_name' => 'civicrm_batch',
          'entity' => 'Batch',
          'bao' => 'CRM_Batch_BAO_Batch',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_SavedSearch',
          'html' => [
            'type' => 'EntityRef',
          ],
        ],
        'status_id' => [
          'name' => 'status_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Batch Status'),
          'description' => 'fk to Batch Status options in civicrm_option_values',
          'required' => TRUE,
          'table_name' => 'civicrm_batch',
          'entity' => 'Batch',
          'bao' => 'CRM_Batch_BAO_Batch',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'batch_status',
            'optionEditPath' => 'civicrm/admin/options/batch_status',
          ]
        ],
        'type_id' => [
          'name' => 'type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Batch Type'),
          'description' => 'fk to Batch Type options in civicrm_option_values',
          'table_name' => 'civicrm_batch',
          'entity' => 'Batch',
          'bao' => 'CRM_Batch_BAO_Batch',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'batch_type',
            'optionEditPath' => 'civicrm/admin/options/batch_type',
          ]
        ],
        'mode_id' => [
          'name' => 'mode_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Batch Mode'),
          'description' => 'fk to Batch mode options in civicrm_option_values',
          'table_name' => 'civicrm_batch',
          'entity' => 'Batch',
          'bao' => 'CRM_Batch_BAO_Batch',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'batch_mode',
            'optionEditPath' => 'civicrm/admin/options/batch_mode',
          ]
        ],
        'total' => [
          'name' => 'total',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Batch Total'),
          'description' => 'Total amount for this batch.',
          'precision' => [
            20,
            2
          ],
          'table_name' => 'civicrm_batch',
          'entity' => 'Batch',
          'bao' => 'CRM_Batch_BAO_Batch',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'item_count' => [
          'name' => 'item_count',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Batch Number of Items'),
          'description' => 'Number of items in a batch.',
          'table_name' => 'civicrm_batch',
          'entity' => 'Batch',
          'bao' => 'CRM_Batch_BAO_Batch',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'payment_instrument_id' => [
          'name' => 'payment_instrument_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Batch Payment Method'),
          'description' => 'fk to Payment Instrument options in civicrm_option_values',
          'table_name' => 'civicrm_batch',
          'entity' => 'Batch',
          'bao' => 'CRM_Batch_BAO_Batch',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'payment_instrument',
            'optionEditPath' => 'civicrm/admin/options/payment_instrument',
          ]
        ],
        'exported_date' => [
          'name' => 'exported_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Batch Exported Date'),
          'table_name' => 'civicrm_batch',
          'entity' => 'Batch',
          'bao' => 'CRM_Batch_BAO_Batch',
          'localizable' => 0,
        ],
        'data' => [
          'name' => 'data',
          'type' => CRM_Utils_Type::T_LONGTEXT,
          'title' => ts('Batch Data'),
          'description' => 'cache entered data',
          'table_name' => 'civicrm_batch',
          'entity' => 'Batch',
          'bao' => 'CRM_Batch_BAO_Batch',
          'localizable' => 0,
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return CRM_Core_DAO::getLocaleTableName(self::$_tableName);
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'batch', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'batch', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'UI_name' => [
        'name' => 'UI_name',
        'field' => [
          0 => 'name',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_batch::1::name',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
