<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2018
 *
 * Generated from xml/schema/CRM/Mailing/MailingJob.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:51449e1b36d9d248712f346f20c9e446)
 */

/**
 * Database access object for the MailingJob entity.
 */
class CRM_Mailing_DAO_MailingJob extends CRM_Core_DAO {

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_mailing_job';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  static $_log = FALSE;

  /**
   * @var int unsigned
   */
  public $id;

  /**
   * The ID of the mailing this Job will send.
   *
   * @var int unsigned
   */
  public $mailing_id;

  /**
   * date on which this job was scheduled.
   *
   * @var timestamp
   */
  public $scheduled_date;

  /**
   * date on which this job was started.
   *
   * @var timestamp
   */
  public $start_date;

  /**
   * date on which this job ended.
   *
   * @var timestamp
   */
  public $end_date;

  /**
   * The state of this job
   *
   * @var string
   */
  public $status;

  /**
   * Is this job for a test mail?
   *
   * @var boolean
   */
  public $is_test;

  /**
   * Type of mailling job: null | child
   *
   * @var string
   */
  public $job_type;

  /**
   * Parent job id
   *
   * @var int unsigned
   */
  public $parent_id;

  /**
   * Offset of the child job
   *
   * @var int
   */
  public $job_offset;

  /**
   * Queue size limit for each child job
   *
   * @var int
   */
  public $job_limit;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_mailing_job';
    parent::__construct();
  }

  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  public static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'mailing_id', 'civicrm_mailing', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'parent_id', 'civicrm_mailing_job', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Mailing Job ID'),
          'required' => TRUE,
          'table_name' => 'civicrm_mailing_job',
          'entity' => 'MailingJob',
          'bao' => 'CRM_Mailing_BAO_MailingJob',
          'localizable' => 0,
        ],
        'mailing_id' => [
          'name' => 'mailing_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Mailing'),
          'description' => 'The ID of the mailing this Job will send.',
          'required' => TRUE,
          'table_name' => 'civicrm_mailing_job',
          'entity' => 'MailingJob',
          'bao' => 'CRM_Mailing_BAO_MailingJob',
          'localizable' => 0,
          'FKClassName' => 'CRM_Mailing_DAO_Mailing',
        ],
        'scheduled_date' => [
          'name' => 'scheduled_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Mailing Scheduled Date'),
          'description' => 'date on which this job was scheduled.',
          'required' => FALSE,
          'default' => 'NULL',
          'table_name' => 'civicrm_mailing_job',
          'entity' => 'MailingJob',
          'bao' => 'CRM_Mailing_BAO_MailingJob',
          'localizable' => 0,
        ],
        'start_date' => [
          'name' => 'start_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Mailing Job Start Date'),
          'description' => 'date on which this job was started.',
          'required' => FALSE,
          'default' => 'NULL',
          'table_name' => 'civicrm_mailing_job',
          'entity' => 'MailingJob',
          'bao' => 'CRM_Mailing_BAO_MailingJob',
          'localizable' => 0,
        ],
        'end_date' => [
          'name' => 'end_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Mailing Job End Date'),
          'description' => 'date on which this job ended.',
          'required' => FALSE,
          'default' => 'NULL',
          'table_name' => 'civicrm_mailing_job',
          'entity' => 'MailingJob',
          'bao' => 'CRM_Mailing_BAO_MailingJob',
          'localizable' => 0,
        ],
        'status' => [
          'name' => 'status',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Mailing Job Status'),
          'description' => 'The state of this job',
          'maxlength' => 12,
          'size' => CRM_Utils_Type::TWELVE,
          'table_name' => 'civicrm_mailing_job',
          'entity' => 'MailingJob',
          'bao' => 'CRM_Mailing_BAO_MailingJob',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_SelectValues::getMailingJobStatus',
          ]
        ],
        'is_test' => [
          'name' => 'is_test',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Mailing Job Is Test?'),
          'description' => 'Is this job for a test mail?',
          'table_name' => 'civicrm_mailing_job',
          'entity' => 'MailingJob',
          'bao' => 'CRM_Mailing_BAO_MailingJob',
          'localizable' => 0,
        ],
        'job_type' => [
          'name' => 'job_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Mailing Job Type'),
          'description' => 'Type of mailling job: null | child ',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_mailing_job',
          'entity' => 'MailingJob',
          'bao' => 'CRM_Mailing_BAO_MailingJob',
          'localizable' => 0,
        ],
        'parent_id' => [
          'name' => 'parent_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Mailing Job Parent'),
          'description' => 'Parent job id',
          'default' => 'NULL',
          'table_name' => 'civicrm_mailing_job',
          'entity' => 'MailingJob',
          'bao' => 'CRM_Mailing_BAO_MailingJob',
          'localizable' => 0,
          'FKClassName' => 'CRM_Mailing_DAO_MailingJob',
        ],
        'job_offset' => [
          'name' => 'job_offset',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Mailing Job Offset'),
          'description' => 'Offset of the child job',
          'table_name' => 'civicrm_mailing_job',
          'entity' => 'MailingJob',
          'bao' => 'CRM_Mailing_BAO_MailingJob',
          'localizable' => 0,
        ],
        'job_limit' => [
          'name' => 'job_limit',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Mailing Job Limit'),
          'description' => 'Queue size limit for each child job',
          'table_name' => 'civicrm_mailing_job',
          'entity' => 'MailingJob',
          'bao' => 'CRM_Mailing_BAO_MailingJob',
          'localizable' => 0,
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return self::$_tableName;
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'mailing_job', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'mailing_job', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
