<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Core/Country.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:d40139ce11551ce445103a7fe9d3d46e)
 */

/**
 * Database access object for the Country entity.
 */
class CRM_Core_DAO_Country extends CRM_Core_DAO {

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_country';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = FALSE;

  /**
   * Country Id
   *
   * @var int
   */
  public $id;

  /**
   * Country Name
   *
   * @var string
   */
  public $name;

  /**
   * ISO Code
   *
   * @var string
   */
  public $iso_code;

  /**
   * National prefix to be used when dialing TO this country.
   *
   * @var string
   */
  public $country_code;

  /**
   * Foreign key to civicrm_address_format.id.
   *
   * @var int
   */
  public $address_format_id;

  /**
   * International direct dialing prefix from within the country TO another country
   *
   * @var string
   */
  public $idd_prefix;

  /**
   * Access prefix to call within a country to a different area
   *
   * @var string
   */
  public $ndd_prefix;

  /**
   * Foreign key to civicrm_worldregion.id.
   *
   * @var int
   */
  public $region_id;

  /**
   * Should state/province be displayed as abbreviation for contacts from this country?
   *
   * @var bool
   */
  public $is_province_abbreviated;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_country';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   */
  public static function getEntityTitle() {
    return ts('Countries');
  }

  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  public static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'address_format_id', 'civicrm_address_format', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'region_id', 'civicrm_worldregion', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Country ID'),
          'description' => ts('Country Id'),
          'required' => TRUE,
          'where' => 'civicrm_country.id',
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
          'add' => '1.1',
        ],
        'name' => [
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Country'),
          'description' => ts('Country Name'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'import' => TRUE,
          'where' => 'civicrm_country.name',
          'headerPattern' => '/country/i',
          'dataPattern' => '/^[A-Z][a-z]+\.?(\s+[A-Z][a-z]+){0,3}$/',
          'export' => TRUE,
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
          'add' => '1.1',
        ],
        'iso_code' => [
          'name' => 'iso_code',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Country ISO Code'),
          'description' => ts('ISO Code'),
          'maxlength' => 2,
          'size' => CRM_Utils_Type::TWO,
          'where' => 'civicrm_country.iso_code',
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
          'add' => '1.1',
        ],
        'country_code' => [
          'name' => 'country_code',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Country Phone Prefix'),
          'description' => ts('National prefix to be used when dialing TO this country.'),
          'maxlength' => 4,
          'size' => CRM_Utils_Type::FOUR,
          'where' => 'civicrm_country.country_code',
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
          'add' => '1.1',
        ],
        'address_format_id' => [
          'name' => 'address_format_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Address Format'),
          'description' => ts('Foreign key to civicrm_address_format.id.'),
          'where' => 'civicrm_country.address_format_id',
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_AddressFormat',
          'add' => '3.2',
        ],
        'idd_prefix' => [
          'name' => 'idd_prefix',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Outgoing Phone Prefix'),
          'description' => ts('International direct dialing prefix from within the country TO another country'),
          'maxlength' => 4,
          'size' => CRM_Utils_Type::FOUR,
          'where' => 'civicrm_country.idd_prefix',
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
          'add' => '1.1',
        ],
        'ndd_prefix' => [
          'name' => 'ndd_prefix',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Area Code'),
          'description' => ts('Access prefix to call within a country to a different area'),
          'maxlength' => 4,
          'size' => CRM_Utils_Type::FOUR,
          'where' => 'civicrm_country.ndd_prefix',
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
          'add' => '1.1',
        ],
        'region_id' => [
          'name' => 'region_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('World Region ID'),
          'description' => ts('Foreign key to civicrm_worldregion.id.'),
          'required' => TRUE,
          'where' => 'civicrm_country.region_id',
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
          'localize_context' => 'country',
          'FKClassName' => 'CRM_Core_DAO_Worldregion',
          'pseudoconstant' => [
            'table' => 'civicrm_worldregion',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          ],
          'add' => '1.8',
        ],
        'is_province_abbreviated' => [
          'name' => 'is_province_abbreviated',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Abbreviate Province?'),
          'description' => ts('Should state/province be displayed as abbreviation for contacts from this country?'),
          'where' => 'civicrm_country.is_province_abbreviated',
          'default' => '0',
          'table_name' => 'civicrm_country',
          'entity' => 'Country',
          'bao' => 'CRM_Core_BAO_Country',
          'localizable' => 0,
          'add' => '3.1',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return self::$_tableName;
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'country', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'country', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'UI_name_iso_code' => [
        'name' => 'UI_name_iso_code',
        'field' => [
          0 => 'name',
          1 => 'iso_code',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_country::1::name::iso_code',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
