<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2016                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2016
 *
 * Generated from xml/schema/CRM/Event/Event.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
class CRM_Event_DAO_Event extends CRM_Core_DAO
{
  /**
   * static instance to hold the table name
   *
   * @var string
   */
  static $_tableName = 'civicrm_event';
  /**
   * static instance to hold the field values
   *
   * @var array
   */
  static $_fields = null;
  /**
   * static instance to hold the keys used in $_fields for each field.
   *
   * @var array
   */
  static $_fieldKeys = null;
  /**
   * static instance to hold the FK relationships
   *
   * @var string
   */
  static $_links = null;
  /**
   * static instance to hold the values that can
   * be imported
   *
   * @var array
   */
  static $_import = null;
  /**
   * static instance to hold the values that can
   * be exported
   *
   * @var array
   */
  static $_export = null;
  /**
   * static value to see if we should log any modifications to
   * this table in the civicrm_log table
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * Event
   *
   * @var int unsigned
   */
  public $id;
  /**
   * Event Title (e.g. Fall Fundraiser Dinner)
   *
   * @var string
   */
  public $title;
  /**
   * Brief summary of event. Text and html allowed. Displayed on Event Registration form and can be used on other CMS pages which need an event summary.
   *
   * @var text
   */
  public $summary;
  /**
   * Full description of event. Text and html allowed. Displayed on built-in Event Information screens.
   *
   * @var text
   */
  public $description;
  /**
   * Event Type ID.Implicit FK to civicrm_option_value where option_group = event_type.
   *
   * @var int unsigned
   */
  public $event_type_id;
  /**
   * Should we expose the participant list? Implicit FK to civicrm_option_value where option_group = participant_listing.
   *
   * @var int unsigned
   */
  public $participant_listing_id;
  /**
   * Public events will be included in the iCal feeds. Access to private event information may be limited using ACLs.
   *
   * @var boolean
   */
  public $is_public;
  /**
   * Date and time that event starts.
   *
   * @var datetime
   */
  public $start_date;
  /**
   * Date and time that event ends. May be NULL if no defined end date/time
   *
   * @var datetime
   */
  public $end_date;
  /**
   * If true, include registration link on Event Info page.
   *
   * @var boolean
   */
  public $is_online_registration;
  /**
   * Text for link to Event Registration form which is displayed on Event Information screen when is_online_registration is true.
   *
   * @var string
   */
  public $registration_link_text;
  /**
   * Date and time that online registration starts.
   *
   * @var datetime
   */
  public $registration_start_date;
  /**
   * Date and time that online registration ends.
   *
   * @var datetime
   */
  public $registration_end_date;
  /**
   * Maximum number of registered participants to allow. After max is reached, a custom Event Full message is displayed. If NULL, allow unlimited number of participants.
   *
   * @var int unsigned
   */
  public $max_participants;
  /**
   * Message to display on Event Information page and INSTEAD OF Event Registration form if maximum participants are signed up. Can include email address/info about getting on a waiting list, etc. Text and html allowed.
   *
   * @var text
   */
  public $event_full_text;
  /**
   * If true, one or more fee amounts must be set and a Payment Processor must be configured for Online Event Registration.
   *
   * @var boolean
   */
  public $is_monetary;
  /**
   * Financial type assigned to paid event registrations for this event. Required if is_monetary is true.
   *
   * @var int unsigned
   */
  public $financial_type_id;
  /**
   * Payment Processors configured for this Event (if is_monetary is true)
   *
   * @var string
   */
  public $payment_processor;
  /**
   * Include a map block on the Event Information page when geocode info is available and a mapping provider has been specified?
   *
   * @var boolean
   */
  public $is_map;
  /**
   * Is this Event enabled or disabled/cancelled?
   *
   * @var boolean
   */
  public $is_active;
  /**
   *
   * @var string
   */
  public $fee_label;
  /**
   * If true, show event location.
   *
   * @var boolean
   */
  public $is_show_location;
  /**
   * FK to Location Block ID
   *
   * @var int unsigned
   */
  public $loc_block_id;
  /**
   * Participant role ID. Implicit FK to civicrm_option_value where option_group = participant_role.
   *
   * @var int unsigned
   */
  public $default_role_id;
  /**
   * Introductory message for Event Registration page. Text and html allowed. Displayed at the top of Event Registration form.
   *
   * @var text
   */
  public $intro_text;
  /**
   * Footer message for Event Registration page. Text and html allowed. Displayed at the bottom of Event Registration form.
   *
   * @var text
   */
  public $footer_text;
  /**
   * Title for Confirmation page.
   *
   * @var string
   */
  public $confirm_title;
  /**
   * Introductory message for Event Registration page. Text and html allowed. Displayed at the top of Event Registration form.
   *
   * @var text
   */
  public $confirm_text;
  /**
   * Footer message for Event Registration page. Text and html allowed. Displayed at the bottom of Event Registration form.
   *
   * @var text
   */
  public $confirm_footer_text;
  /**
   * If true, confirmation is automatically emailed to contact on successful registration.
   *
   * @var boolean
   */
  public $is_email_confirm;
  /**
   * text to include above standard event info on confirmation email. emails are text-only, so do not allow html for now
   *
   * @var text
   */
  public $confirm_email_text;
  /**
   * FROM email name used for confirmation emails.
   *
   * @var string
   */
  public $confirm_from_name;
  /**
   * FROM email address used for confirmation emails.
   *
   * @var string
   */
  public $confirm_from_email;
  /**
   * comma-separated list of email addresses to cc each time a confirmation is sent
   *
   * @var string
   */
  public $cc_confirm;
  /**
   * comma-separated list of email addresses to bcc each time a confirmation is sent
   *
   * @var string
   */
  public $bcc_confirm;
  /**
   * FK to civicrm_option_value.
   *
   * @var int unsigned
   */
  public $default_fee_id;
  /**
   * FK to civicrm_option_value.
   *
   * @var int unsigned
   */
  public $default_discount_fee_id;
  /**
   * Title for ThankYou page.
   *
   * @var string
   */
  public $thankyou_title;
  /**
   * ThankYou Text.
   *
   * @var text
   */
  public $thankyou_text;
  /**
   * Footer message.
   *
   * @var text
   */
  public $thankyou_footer_text;
  /**
   * if true - allows the user to send payment directly to the org later
   *
   * @var boolean
   */
  public $is_pay_later;
  /**
   * The text displayed to the user in the main form
   *
   * @var text
   */
  public $pay_later_text;
  /**
   * The receipt sent to the user instead of the normal receipt text
   *
   * @var text
   */
  public $pay_later_receipt;
  /**
   * is partial payment enabled for this event
   *
   * @var boolean
   */
  public $is_partial_payment;
  /**
   * Initial amount label for partial payment
   *
   * @var string
   */
  public $initial_amount_label;
  /**
   * Initial amount help text for partial payment
   *
   * @var text
   */
  public $initial_amount_help_text;
  /**
   * Minimum initial amount for partial payment
   *
   * @var float
   */
  public $min_initial_amount;
  /**
   * if true - allows the user to register multiple participants for event
   *
   * @var boolean
   */
  public $is_multiple_registrations;
  /**
   * Maximum number of additional participants that can be registered on a single booking
   *
   * @var int unsigned
   */
  public $max_additional_participants;
  /**
   * if true - allows the user to register multiple registrations from same email address.
   *
   * @var boolean
   */
  public $allow_same_participant_emails;
  /**
   * Whether the event has waitlist support.
   *
   * @var boolean
   */
  public $has_waitlist;
  /**
   * Whether participants require approval before they can finish registering.
   *
   * @var boolean
   */
  public $requires_approval;
  /**
   * Expire pending but unconfirmed registrations after this many hours.
   *
   * @var int unsigned
   */
  public $expiration_time;
  /**
   * Allow self service cancellation or transfer for event?
   *
   * @var boolean
   */
  public $allow_selfcancelxfer;
  /**
   * Number of hours prior to event start date to allow self-service cancellation or transfer.
   *
   * @var int unsigned
   */
  public $selfcancelxfer_time;
  /**
   * Text to display when the event is full, but participants can signup for a waitlist.
   *
   * @var text
   */
  public $waitlist_text;
  /**
   * Text to display when the approval is required to complete registration for an event.
   *
   * @var text
   */
  public $approval_req_text;
  /**
   * whether the event has template
   *
   * @var boolean
   */
  public $is_template;
  /**
   * Event Template Title
   *
   * @var string
   */
  public $template_title;
  /**
   * FK to civicrm_contact, who created this event
   *
   * @var int unsigned
   */
  public $created_id;
  /**
   * Date and time that event was created.
   *
   * @var datetime
   */
  public $created_date;
  /**
   * 3 character string, value from config setting or input via user.
   *
   * @var string
   */
  public $currency;
  /**
   * The campaign for which this event has been created.
   *
   * @var int unsigned
   */
  public $campaign_id;
  /**
   * Can people share the event through social media?
   *
   * @var boolean
   */
  public $is_share;
  /**
   * If false, the event booking confirmation screen gets skipped
   *
   * @var boolean
   */
  public $is_confirm_enabled;
  /**
   * Implicit FK to civicrm_event: parent event
   *
   * @var int unsigned
   */
  public $parent_event_id;
  /**
   * Subevent slot label. Implicit FK to civicrm_option_value where option_group = conference_slot.
   *
   * @var int unsigned
   */
  public $slot_label_id;
  /**
   * Rule to use when matching registrations for this event
   *
   * @var int unsigned
   */
  public $dedupe_rule_group_id;
  /**
   * if true than billing block is required this event
   *
   * @var boolean
   */
  public $is_billing_required;
  /**
   * class constructor
   *
   * @return civicrm_event
   */
  function __construct()
  {
    $this->__table = 'civicrm_event';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns()
  {
    if (!self::$_links) {
      self::$_links = static ::createReferenceColumns(__CLASS__);
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'loc_block_id', 'civicrm_loc_block', 'id');
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'created_id', 'civicrm_contact', 'id');
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'campaign_id', 'civicrm_campaign', 'id');
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'dedupe_rule_group_id', 'civicrm_dedupe_rule_group', 'id');
    }
    return self::$_links;
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields()
  {
    if (!(self::$_fields)) {
      self::$_fields = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Event ID') ,
          'description' => 'Event',
          'required' => true,
        ) ,
        'event_title' => array(
          'name' => 'title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Event Title') ,
          'description' => 'Event Title (e.g. Fall Fundraiser Dinner)',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'import' => true,
          'where' => 'civicrm_event.title',
          'headerPattern' => '/(event.)?title$/i',
          'dataPattern' => '',
          'export' => true,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'summary' => array(
          'name' => 'summary',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Event Summary') ,
          'description' => 'Brief summary of event. Text and html allowed. Displayed on Event Registration form and can be used on other CMS pages which need an event summary.',
          'rows' => 4,
          'cols' => 60,
          'html' => array(
            'type' => 'TextArea',
          ) ,
        ) ,
        'event_description' => array(
          'name' => 'description',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Event Description') ,
          'description' => 'Full description of event. Text and html allowed. Displayed on built-in Event Information screens.',
          'rows' => 8,
          'cols' => 60,
          'html' => array(
            'type' => 'TextArea',
          ) ,
        ) ,
        'event_type_id' => array(
          'name' => 'event_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Event Type') ,
          'description' => 'Event Type ID.Implicit FK to civicrm_option_value where option_group = event_type.',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'optionGroupName' => 'event_type',
            'optionEditPath' => 'civicrm/admin/options/event_type',
          )
        ) ,
        'participant_listing_id' => array(
          'name' => 'participant_listing_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Participant Listing') ,
          'description' => 'Should we expose the participant list? Implicit FK to civicrm_option_value where option_group = participant_listing.',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'optionGroupName' => 'participant_listing',
            'optionEditPath' => 'civicrm/admin/options/participant_listing',
          )
        ) ,
        'is_public' => array(
          'name' => 'is_public',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is Event Public') ,
          'description' => 'Public events will be included in the iCal feeds. Access to private event information may be limited using ACLs.',
          'default' => '1',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'event_start_date' => array(
          'name' => 'start_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Event Start Date') ,
          'description' => 'Date and time that event starts.',
          'import' => true,
          'where' => 'civicrm_event.start_date',
          'headerPattern' => '/^start|(s(tart\s)?date)$/i',
          'dataPattern' => '',
          'export' => true,
          'html' => array(
            'type' => 'Select Date',
          ) ,
        ) ,
        'event_end_date' => array(
          'name' => 'end_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Event End Date') ,
          'description' => 'Date and time that event ends. May be NULL if no defined end date/time',
          'import' => true,
          'where' => 'civicrm_event.end_date',
          'headerPattern' => '/^end|(e(nd\s)?date)$/i',
          'dataPattern' => '',
          'export' => true,
          'html' => array(
            'type' => 'Select Date',
          ) ,
        ) ,
        'is_online_registration' => array(
          'name' => 'is_online_registration',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is Online Registration') ,
          'description' => 'If true, include registration link on Event Info page.',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'registration_link_text' => array(
          'name' => 'registration_link_text',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Event Registration Link Text') ,
          'description' => 'Text for link to Event Registration form which is displayed on Event Information screen when is_online_registration is true.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'registration_start_date' => array(
          'name' => 'registration_start_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Registration Start Date') ,
          'description' => 'Date and time that online registration starts.',
          'html' => array(
            'type' => 'Select Date',
          ) ,
        ) ,
        'registration_end_date' => array(
          'name' => 'registration_end_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Registration End Date') ,
          'description' => 'Date and time that online registration ends.',
          'html' => array(
            'type' => 'Select Date',
          ) ,
        ) ,
        'max_participants' => array(
          'name' => 'max_participants',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Max Participants') ,
          'description' => 'Maximum number of registered participants to allow. After max is reached, a custom Event Full message is displayed. If NULL, allow unlimited number of participants.',
          'default' => 'NULL',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'event_full_text' => array(
          'name' => 'event_full_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Event Information') ,
          'description' => 'Message to display on Event Information page and INSTEAD OF Event Registration form if maximum participants are signed up. Can include email address/info about getting on a waiting list, etc. Text and html allowed.',
          'rows' => 4,
          'cols' => 60,
          'html' => array(
            'type' => 'TextArea',
          ) ,
        ) ,
        'is_monetary' => array(
          'name' => 'is_monetary',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is this a PAID event?') ,
          'description' => 'If true, one or more fee amounts must be set and a Payment Processor must be configured for Online Event Registration.',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'financial_type_id' => array(
          'name' => 'financial_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Financial Type') ,
          'description' => 'Financial type assigned to paid event registrations for this event. Required if is_monetary is true.',
          'default' => 'NULL',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_financial_type',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          )
        ) ,
        'payment_processor' => array(
          'name' => 'payment_processor',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Payment Processor') ,
          'description' => 'Payment Processors configured for this Event (if is_monetary is true)',
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_payment_processor',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          )
        ) ,
        'is_map' => array(
          'name' => 'is_map',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Map Enabled') ,
          'description' => 'Include a map block on the Event Information page when geocode info is available and a mapping provider has been specified?',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'is_active' => array(
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is Active') ,
          'description' => 'Is this Event enabled or disabled/cancelled?',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'fee_label' => array(
          'name' => 'fee_label',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Fee Label') ,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'import' => true,
          'where' => 'civicrm_event.fee_label',
          'headerPattern' => '/^fee|(f(ee\s)?label)$/i',
          'dataPattern' => '',
          'export' => true,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'is_show_location' => array(
          'name' => 'is_show_location',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('show location') ,
          'description' => 'If true, show event location.',
          'default' => '1',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'loc_block_id' => array(
          'name' => 'loc_block_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Location Block ID') ,
          'description' => 'FK to Location Block ID',
          'FKClassName' => 'CRM_Core_DAO_LocBlock',
        ) ,
        'default_role_id' => array(
          'name' => 'default_role_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Default Role ID') ,
          'description' => 'Participant role ID. Implicit FK to civicrm_option_value where option_group = participant_role.',
          'import' => true,
          'where' => 'civicrm_event.default_role_id',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'default' => '1',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'optionGroupName' => 'participant_role',
            'optionEditPath' => 'civicrm/admin/options/participant_role',
          )
        ) ,
        'intro_text' => array(
          'name' => 'intro_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Introductory Message') ,
          'description' => 'Introductory message for Event Registration page. Text and html allowed. Displayed at the top of Event Registration form.',
          'rows' => 6,
          'cols' => 50,
          'html' => array(
            'type' => 'TextArea',
          ) ,
        ) ,
        'footer_text' => array(
          'name' => 'footer_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Footer Message') ,
          'description' => 'Footer message for Event Registration page. Text and html allowed. Displayed at the bottom of Event Registration form.',
          'rows' => 6,
          'cols' => 50,
          'html' => array(
            'type' => 'TextArea',
          ) ,
        ) ,
        'confirm_title' => array(
          'name' => 'confirm_title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Confirmation Title') ,
          'description' => 'Title for Confirmation page.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'default' => 'NULL',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'confirm_text' => array(
          'name' => 'confirm_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Confirm Text') ,
          'description' => 'Introductory message for Event Registration page. Text and html allowed. Displayed at the top of Event Registration form.',
          'rows' => 6,
          'cols' => 50,
          'html' => array(
            'type' => 'TextArea',
          ) ,
        ) ,
        'confirm_footer_text' => array(
          'name' => 'confirm_footer_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Footer Text') ,
          'description' => 'Footer message for Event Registration page. Text and html allowed. Displayed at the bottom of Event Registration form.',
          'rows' => 6,
          'cols' => 50,
          'html' => array(
            'type' => 'TextArea',
          ) ,
        ) ,
        'is_email_confirm' => array(
          'name' => 'is_email_confirm',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is confirm email') ,
          'description' => 'If true, confirmation is automatically emailed to contact on successful registration.',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'confirm_email_text' => array(
          'name' => 'confirm_email_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Confirmation Email Text') ,
          'description' => 'text to include above standard event info on confirmation email. emails are text-only, so do not allow html for now',
          'rows' => 4,
          'cols' => 50,
          'html' => array(
            'type' => 'TextArea',
          ) ,
        ) ,
        'confirm_from_name' => array(
          'name' => 'confirm_from_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Confirm From Name') ,
          'description' => 'FROM email name used for confirmation emails.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'confirm_from_email' => array(
          'name' => 'confirm_from_email',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Confirm From Email') ,
          'description' => 'FROM email address used for confirmation emails.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'cc_confirm' => array(
          'name' => 'cc_confirm',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Cc Confirm') ,
          'description' => 'comma-separated list of email addresses to cc each time a confirmation is sent',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'bcc_confirm' => array(
          'name' => 'bcc_confirm',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Bcc Confirm') ,
          'description' => 'comma-separated list of email addresses to bcc each time a confirmation is sent',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'default_fee_id' => array(
          'name' => 'default_fee_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Default Fee ID') ,
          'description' => 'FK to civicrm_option_value.',
        ) ,
        'default_discount_fee_id' => array(
          'name' => 'default_discount_fee_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Default Discount Fee ID') ,
          'description' => 'FK to civicrm_option_value.',
        ) ,
        'thankyou_title' => array(
          'name' => 'thankyou_title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('ThankYou Title') ,
          'description' => 'Title for ThankYou page.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'default' => 'NULL',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'thankyou_text' => array(
          'name' => 'thankyou_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('ThankYou Text') ,
          'description' => 'ThankYou Text.',
          'rows' => 6,
          'cols' => 50,
          'html' => array(
            'type' => 'TextArea',
          ) ,
        ) ,
        'thankyou_footer_text' => array(
          'name' => 'thankyou_footer_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Footer Text') ,
          'description' => 'Footer message.',
          'rows' => 6,
          'cols' => 50,
          'html' => array(
            'type' => 'TextArea',
          ) ,
        ) ,
        'is_pay_later' => array(
          'name' => 'is_pay_later',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Pay Later Allowed') ,
          'description' => 'if true - allows the user to send payment directly to the org later',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'pay_later_text' => array(
          'name' => 'pay_later_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Pay Later Text') ,
          'description' => 'The text displayed to the user in the main form',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'pay_later_receipt' => array(
          'name' => 'pay_later_receipt',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Pay Later Receipt Text') ,
          'description' => 'The receipt sent to the user instead of the normal receipt text',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'is_partial_payment' => array(
          'name' => 'is_partial_payment',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Partial Payments Enabled') ,
          'description' => 'is partial payment enabled for this event',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'initial_amount_label' => array(
          'name' => 'initial_amount_label',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Initial Amount Label') ,
          'description' => 'Initial amount label for partial payment',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'initial_amount_help_text' => array(
          'name' => 'initial_amount_help_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Initial Amount Help Text') ,
          'description' => 'Initial amount help text for partial payment',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'min_initial_amount' => array(
          'name' => 'min_initial_amount',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Minimum Initial Amount') ,
          'description' => 'Minimum initial amount for partial payment',
          'precision' => array(
            20,
            2
          ) ,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'is_multiple_registrations' => array(
          'name' => 'is_multiple_registrations',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Allow Multiple Registrations') ,
          'description' => 'if true - allows the user to register multiple participants for event',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'max_additional_participants' => array(
          'name' => 'max_additional_participants',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Maximum number of additional participants per registration') ,
          'description' => 'Maximum number of additional participants that can be registered on a single booking',
        ) ,
        'allow_same_participant_emails' => array(
          'name' => 'allow_same_participant_emails',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Does Event allow multiple registrations from same email address?') ,
          'description' => 'if true - allows the user to register multiple registrations from same email address.',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'has_waitlist' => array(
          'name' => 'has_waitlist',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Waitlist Enabled') ,
          'description' => 'Whether the event has waitlist support.',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'requires_approval' => array(
          'name' => 'requires_approval',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Requires Approval') ,
          'description' => 'Whether participants require approval before they can finish registering.',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'expiration_time' => array(
          'name' => 'expiration_time',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Expiration Time') ,
          'description' => 'Expire pending but unconfirmed registrations after this many hours.',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'allow_selfcancelxfer' => array(
          'name' => 'allow_selfcancelxfer',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Allow Self-service Cancellation or Transfer') ,
          'description' => 'Allow self service cancellation or transfer for event?',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'selfcancelxfer_time' => array(
          'name' => 'selfcancelxfer_time',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Self-service Cancellation or Transfer Time') ,
          'description' => 'Number of hours prior to event start date to allow self-service cancellation or transfer.',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'waitlist_text' => array(
          'name' => 'waitlist_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Waitlist Text') ,
          'description' => 'Text to display when the event is full, but participants can signup for a waitlist.',
          'rows' => 4,
          'cols' => 60,
          'html' => array(
            'type' => 'TextArea',
          ) ,
        ) ,
        'approval_req_text' => array(
          'name' => 'approval_req_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Approval Req Text') ,
          'description' => 'Text to display when the approval is required to complete registration for an event.',
          'rows' => 4,
          'cols' => 60,
          'html' => array(
            'type' => 'TextArea',
          ) ,
        ) ,
        'is_template' => array(
          'name' => 'is_template',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is an Event Template') ,
          'description' => 'whether the event has template',
          'required' => true,
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'template_title' => array(
          'name' => 'template_title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Event Template Title') ,
          'description' => 'Event Template Title',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'import' => true,
          'where' => 'civicrm_event.template_title',
          'headerPattern' => '/(template.)?title$/i',
          'dataPattern' => '',
          'export' => true,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'created_id' => array(
          'name' => 'created_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Created By Contact ID') ,
          'description' => 'FK to civicrm_contact, who created this event',
          'FKClassName' => 'CRM_Contact_DAO_Contact',
        ) ,
        'created_date' => array(
          'name' => 'created_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Event Created Date') ,
          'description' => 'Date and time that event was created.',
        ) ,
        'currency' => array(
          'name' => 'currency',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Currency') ,
          'description' => '3 character string, value from config setting or input via user.',
          'maxlength' => 3,
          'size' => CRM_Utils_Type::FOUR,
          'import' => true,
          'where' => 'civicrm_event.currency',
          'headerPattern' => '/cur(rency)?/i',
          'dataPattern' => '/^[A-Z]{3}$/i',
          'export' => true,
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_currency',
            'keyColumn' => 'name',
            'labelColumn' => 'full_name',
            'nameColumn' => 'numeric_code',
          )
        ) ,
        'campaign_id' => array(
          'name' => 'campaign_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Campaign') ,
          'description' => 'The campaign for which this event has been created.',
          'FKClassName' => 'CRM_Campaign_DAO_Campaign',
          'html' => array(
            'type' => 'EntityRef',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_campaign',
            'keyColumn' => 'id',
            'labelColumn' => 'title',
          )
        ) ,
        'is_share' => array(
          'name' => 'is_share',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is shared through social media') ,
          'description' => 'Can people share the event through social media?',
          'default' => '1',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'is_confirm_enabled' => array(
          'name' => 'is_confirm_enabled',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is the booking confirmation screen enabled?') ,
          'description' => 'If false, the event booking confirmation screen gets skipped',
          'default' => '1',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'parent_event_id' => array(
          'name' => 'parent_event_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Parent Event ID') ,
          'description' => 'Implicit FK to civicrm_event: parent event',
          'default' => 'NULL',
          'html' => array(
            'type' => 'EntityRef',
          ) ,
        ) ,
        'slot_label_id' => array(
          'name' => 'slot_label_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Subevent Slot Label ID') ,
          'description' => 'Subevent slot label. Implicit FK to civicrm_option_value where option_group = conference_slot.',
          'default' => 'NULL',
          'html' => array(
            'type' => 'Select',
          ) ,
        ) ,
        'dedupe_rule_group_id' => array(
          'name' => 'dedupe_rule_group_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Dedupe Rule') ,
          'description' => 'Rule to use when matching registrations for this event',
          'default' => 'NULL',
          'FKClassName' => 'CRM_Dedupe_DAO_RuleGroup',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_dedupe_rule_group',
            'keyColumn' => 'id',
            'labelColumn' => 'title',
            'nameColumn' => 'name',
          )
        ) ,
        'is_billing_required' => array(
          'name' => 'is_billing_required',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is billing block required') ,
          'description' => 'if true than billing block is required this event',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
      );
    }
    return self::$_fields;
  }
  /**
   * Returns an array containing, for each field, the arary key used for that
   * field in self::$_fields.
   *
   * @return array
   */
  static function &fieldKeys()
  {
    if (!(self::$_fieldKeys)) {
      self::$_fieldKeys = array(
        'id' => 'id',
        'title' => 'event_title',
        'summary' => 'summary',
        'description' => 'event_description',
        'event_type_id' => 'event_type_id',
        'participant_listing_id' => 'participant_listing_id',
        'is_public' => 'is_public',
        'start_date' => 'event_start_date',
        'end_date' => 'event_end_date',
        'is_online_registration' => 'is_online_registration',
        'registration_link_text' => 'registration_link_text',
        'registration_start_date' => 'registration_start_date',
        'registration_end_date' => 'registration_end_date',
        'max_participants' => 'max_participants',
        'event_full_text' => 'event_full_text',
        'is_monetary' => 'is_monetary',
        'financial_type_id' => 'financial_type_id',
        'payment_processor' => 'payment_processor',
        'is_map' => 'is_map',
        'is_active' => 'is_active',
        'fee_label' => 'fee_label',
        'is_show_location' => 'is_show_location',
        'loc_block_id' => 'loc_block_id',
        'default_role_id' => 'default_role_id',
        'intro_text' => 'intro_text',
        'footer_text' => 'footer_text',
        'confirm_title' => 'confirm_title',
        'confirm_text' => 'confirm_text',
        'confirm_footer_text' => 'confirm_footer_text',
        'is_email_confirm' => 'is_email_confirm',
        'confirm_email_text' => 'confirm_email_text',
        'confirm_from_name' => 'confirm_from_name',
        'confirm_from_email' => 'confirm_from_email',
        'cc_confirm' => 'cc_confirm',
        'bcc_confirm' => 'bcc_confirm',
        'default_fee_id' => 'default_fee_id',
        'default_discount_fee_id' => 'default_discount_fee_id',
        'thankyou_title' => 'thankyou_title',
        'thankyou_text' => 'thankyou_text',
        'thankyou_footer_text' => 'thankyou_footer_text',
        'is_pay_later' => 'is_pay_later',
        'pay_later_text' => 'pay_later_text',
        'pay_later_receipt' => 'pay_later_receipt',
        'is_partial_payment' => 'is_partial_payment',
        'initial_amount_label' => 'initial_amount_label',
        'initial_amount_help_text' => 'initial_amount_help_text',
        'min_initial_amount' => 'min_initial_amount',
        'is_multiple_registrations' => 'is_multiple_registrations',
        'max_additional_participants' => 'max_additional_participants',
        'allow_same_participant_emails' => 'allow_same_participant_emails',
        'has_waitlist' => 'has_waitlist',
        'requires_approval' => 'requires_approval',
        'expiration_time' => 'expiration_time',
        'allow_selfcancelxfer' => 'allow_selfcancelxfer',
        'selfcancelxfer_time' => 'selfcancelxfer_time',
        'waitlist_text' => 'waitlist_text',
        'approval_req_text' => 'approval_req_text',
        'is_template' => 'is_template',
        'template_title' => 'template_title',
        'created_id' => 'created_id',
        'created_date' => 'created_date',
        'currency' => 'currency',
        'campaign_id' => 'campaign_id',
        'is_share' => 'is_share',
        'is_confirm_enabled' => 'is_confirm_enabled',
        'parent_event_id' => 'parent_event_id',
        'slot_label_id' => 'slot_label_id',
        'dedupe_rule_group_id' => 'dedupe_rule_group_id',
        'is_billing_required' => 'is_billing_required',
      );
    }
    return self::$_fieldKeys;
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName()
  {
    return CRM_Core_DAO::getLocaleTableName(self::$_tableName);
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog()
  {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false)
  {
    if (!(self::$_import)) {
      self::$_import = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('import', $field)) {
          if ($prefix) {
            self::$_import['event'] = & $fields[$name];
          } else {
            self::$_import[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_import;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false)
  {
    if (!(self::$_export)) {
      self::$_export = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('export', $field)) {
          if ($prefix) {
            self::$_export['event'] = & $fields[$name];
          } else {
            self::$_export[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_export;
  }
}
