<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2016                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2016
 *
 * Generated from xml/schema/CRM/Contribute/Widget.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
class CRM_Contribute_DAO_Widget extends CRM_Core_DAO
{
  /**
   * static instance to hold the table name
   *
   * @var string
   */
  static $_tableName = 'civicrm_contribution_widget';
  /**
   * static instance to hold the field values
   *
   * @var array
   */
  static $_fields = null;
  /**
   * static instance to hold the keys used in $_fields for each field.
   *
   * @var array
   */
  static $_fieldKeys = null;
  /**
   * static instance to hold the FK relationships
   *
   * @var string
   */
  static $_links = null;
  /**
   * static instance to hold the values that can
   * be imported
   *
   * @var array
   */
  static $_import = null;
  /**
   * static instance to hold the values that can
   * be exported
   *
   * @var array
   */
  static $_export = null;
  /**
   * static value to see if we should log any modifications to
   * this table in the civicrm_log table
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * Contribution Id
   *
   * @var int unsigned
   */
  public $id;
  /**
   * The Contribution Page which triggered this contribution
   *
   * @var int unsigned
   */
  public $contribution_page_id;
  /**
   * Is this property active?
   *
   * @var boolean
   */
  public $is_active;
  /**
   * Widget title.
   *
   * @var string
   */
  public $title;
  /**
   * URL to Widget logo
   *
   * @var string
   */
  public $url_logo;
  /**
   * Button title.
   *
   * @var string
   */
  public $button_title;
  /**
   * About description.
   *
   * @var text
   */
  public $about;
  /**
   * URL to Homepage.
   *
   * @var string
   */
  public $url_homepage;
  /**
   *
   * @var string
   */
  public $color_title;
  /**
   *
   * @var string
   */
  public $color_button;
  /**
   *
   * @var string
   */
  public $color_bar;
  /**
   *
   * @var string
   */
  public $color_main_text;
  /**
   *
   * @var string
   */
  public $color_main;
  /**
   *
   * @var string
   */
  public $color_main_bg;
  /**
   *
   * @var string
   */
  public $color_bg;
  /**
   *
   * @var string
   */
  public $color_about_link;
  /**
   *
   * @var string
   */
  public $color_homepage_link;
  /**
   * class constructor
   *
   * @return civicrm_contribution_widget
   */
  function __construct()
  {
    $this->__table = 'civicrm_contribution_widget';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns()
  {
    if (!self::$_links) {
      self::$_links = static ::createReferenceColumns(__CLASS__);
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'contribution_page_id', 'civicrm_contribution_page', 'id');
    }
    return self::$_links;
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields()
  {
    if (!(self::$_fields)) {
      self::$_fields = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Widget ID') ,
          'description' => 'Contribution Id',
          'required' => true,
        ) ,
        'contribution_page_id' => array(
          'name' => 'contribution_page_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contribution Page') ,
          'description' => 'The Contribution Page which triggered this contribution',
          'FKClassName' => 'CRM_Contribute_DAO_ContributionPage',
        ) ,
        'is_active' => array(
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Enabled?') ,
          'description' => 'Is this property active?',
        ) ,
        'title' => array(
          'name' => 'title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Widget Title') ,
          'description' => 'Widget title.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'url_logo' => array(
          'name' => 'url_logo',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Widget Image Url') ,
          'description' => 'URL to Widget logo',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'button_title' => array(
          'name' => 'button_title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Button Title') ,
          'description' => 'Button title.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'about' => array(
          'name' => 'about',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Description') ,
          'description' => 'About description.',
        ) ,
        'url_homepage' => array(
          'name' => 'url_homepage',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Homepage Url') ,
          'description' => 'URL to Homepage.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'color_title' => array(
          'name' => 'color_title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Title Color') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
        ) ,
        'color_button' => array(
          'name' => 'color_button',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Button Colour') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
        ) ,
        'color_bar' => array(
          'name' => 'color_bar',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Bar Color') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
        ) ,
        'color_main_text' => array(
          'name' => 'color_main_text',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Main Text Color') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
        ) ,
        'color_main' => array(
          'name' => 'color_main',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Main Colour') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
        ) ,
        'color_main_bg' => array(
          'name' => 'color_main_bg',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Backgroup Color') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
        ) ,
        'color_bg' => array(
          'name' => 'color_bg',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Other Backgroun Colour') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
        ) ,
        'color_about_link' => array(
          'name' => 'color_about_link',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('About Link Colour') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
        ) ,
        'color_homepage_link' => array(
          'name' => 'color_homepage_link',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Homepage Link Colour') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
        ) ,
      );
    }
    return self::$_fields;
  }
  /**
   * Returns an array containing, for each field, the arary key used for that
   * field in self::$_fields.
   *
   * @return array
   */
  static function &fieldKeys()
  {
    if (!(self::$_fieldKeys)) {
      self::$_fieldKeys = array(
        'id' => 'id',
        'contribution_page_id' => 'contribution_page_id',
        'is_active' => 'is_active',
        'title' => 'title',
        'url_logo' => 'url_logo',
        'button_title' => 'button_title',
        'about' => 'about',
        'url_homepage' => 'url_homepage',
        'color_title' => 'color_title',
        'color_button' => 'color_button',
        'color_bar' => 'color_bar',
        'color_main_text' => 'color_main_text',
        'color_main' => 'color_main',
        'color_main_bg' => 'color_main_bg',
        'color_bg' => 'color_bg',
        'color_about_link' => 'color_about_link',
        'color_homepage_link' => 'color_homepage_link',
      );
    }
    return self::$_fieldKeys;
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName()
  {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog()
  {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false)
  {
    if (!(self::$_import)) {
      self::$_import = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('import', $field)) {
          if ($prefix) {
            self::$_import['contribution_widget'] = & $fields[$name];
          } else {
            self::$_import[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_import;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false)
  {
    if (!(self::$_export)) {
      self::$_export = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('export', $field)) {
          if ($prefix) {
            self::$_export['contribution_widget'] = & $fields[$name];
          } else {
            self::$_export[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_export;
  }
}
