// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chromeos/services/ime/public/cpp/rulebased/def/lo.h"

namespace lo {

const char* kId = "lo";
bool kIs102 = false;
const char* kNormal[] = {
    u8"*",       // BackQuote
    u8"\u0ea2",  // Digit1
    u8"\u0e9f",  // Digit2
    u8"\u0ec2",  // Digit3
    u8"\u0e96",  // Digit4
    u8"\u0eb8",  // Digit5
    u8"\u0eb9",  // Digit6
    u8"\u0e84",  // Digit7
    u8"\u0e95",  // Digit8
    u8"\u0e88",  // Digit9
    u8"\u0e82",  // Digit0
    u8"\u0e8a",  // Minus
    u8"\u0ecd",  // Equal
    u8"\u0ebb",  // KeyQ
    u8"\u0ec4",  // KeyW
    u8"\u0eb3",  // KeyE
    u8"\u0e9e",  // KeyR
    u8"\u0eb0",  // KeyT
    u8"\u0eb4",  // KeyY
    u8"\u0eb5",  // KeyU
    u8"\u0eae",  // KeyI
    u8"\u0e99",  // KeyO
    u8"\u0e8d",  // KeyP
    u8"\u0e9a",  // BracketLeft
    u8"\u0ea5",  // BracketRight
    u8"\u201c",  // Backslash
    u8"\u0eb1",  // KeyA
    u8"\u0eab",  // KeyS
    u8"\u0e81",  // KeyD
    u8"\u0e94",  // KeyF
    u8"\u0ec0",  // KeyG
    u8"\u0ec9",  // KeyH
    u8"\u0ec8",  // KeyJ
    u8"\u0eb2",  // KeyK
    u8"\u0eaa",  // KeyL
    u8"\u0ea7",  // Semicolon
    u8"\u0e87",  // Quote
    u8"\u0e9c",  // KeyZ
    u8"\u0e9b",  // KeyX
    u8"\u0ec1",  // KeyC
    u8"\u0ead",  // KeyV
    u8"\u0eb6",  // KeyB
    u8"\u0eb7",  // KeyN
    u8"\u0e97",  // KeyM
    u8"\u0ea1",  // Comma
    u8"\u0ec3",  // Period
    u8"\u0e9d",  // Slash
    u8"\u0020",  // Space
};
const char* kShift[] = {
    u8"/",             // BackQuote
    u8"1",             // Digit1
    u8"2",             // Digit2
    u8"3",             // Digit3
    u8"4",             // Digit4
    u8"\u0ecc",        // Digit5
    u8"\u0ebc",        // Digit6
    u8"5",             // Digit7
    u8"6",             // Digit8
    u8"7",             // Digit9
    u8"8",             // Digit0
    u8"9",             // Minus
    u8"\u0ecd\u0ec8",  // Equal
    u8"\u0ebb\u0ec9",  // KeyQ
    u8"0",             // KeyW
    u8"\u0eb3\u0ec9",  // KeyE
    u8"_",             // KeyR
    u8"+",             // KeyT
    u8"\u0eb4\u0ec9",  // KeyY
    u8"\u0eb5\u0ec9",  // KeyU
    u8"\u0ea3",        // KeyI
    u8"\u0edc",        // KeyO
    u8"\u0ebd",        // KeyP
    u8"-",             // BracketLeft
    u8"\u0eab\u0ebc",  // BracketRight
    u8"\u201d",        // Backslash
    u8"\u0eb1\u0ec9",  // KeyA
    u8";",             // KeyS
    u8".",             // KeyD
    u8",",             // KeyF
    u8":",             // KeyG
    u8"\u0eca",        // KeyH
    u8"\u0ecb",        // KeyJ
    u8"!",             // KeyK
    u8"?",             // KeyL
    u8"%",             // Semicolon
    u8"=",             // Quote
    u8"\u20ad",        // KeyZ
    u8"(",             // KeyX
    u8"\u0eaf",        // KeyC
    u8"x",             // KeyV
    u8"\u0eb6\u0ec9",  // KeyB
    u8"\u0eb7\u0ec9",  // KeyN
    u8"\u0ec6",        // KeyM
    u8"\u0edd",        // Comma
    u8"$",             // Period
    u8")",             // Slash
    u8"\u0020",        // Space
};
const char* kAltGr[] = {
    u8"",        // BackQuote
    u8"\u0ed1",  // Digit1
    u8"\u0ed2",  // Digit2
    u8"\u0ed3",  // Digit3
    u8"\u0ed4",  // Digit4
    u8"\u0ed5",  // Digit5
    u8"\u0ed6",  // Digit6
    u8"\u0ed7",  // Digit7
    u8"\u0ed8",  // Digit8
    u8"\u0ed9",  // Digit9
    u8"\u0ed0",  // Digit0
    u8"",        // Minus
    u8"",        // Equal
    u8"",        // KeyQ
    u8"",        // KeyW
    u8"",        // KeyE
    u8"",        // KeyR
    u8"",        // KeyT
    u8"",        // KeyY
    u8"",        // KeyU
    u8"",        // KeyI
    u8"",        // KeyO
    u8"",        // KeyP
    u8"",        // BracketLeft
    u8"",        // BracketRight
    u8"",        // Backslash
    u8"",        // KeyA
    u8"",        // KeyS
    u8"",        // KeyD
    u8"",        // KeyF
    u8"",        // KeyG
    u8"",        // KeyH
    u8"",        // KeyJ
    u8"",        // KeyK
    u8"",        // KeyL
    u8"",        // Semicolon
    u8"",        // Quote
    u8"",        // KeyZ
    u8"",        // KeyX
    u8"",        // KeyC
    u8"",        // KeyV
    u8"",        // KeyB
    u8"",        // KeyN
    u8"",        // KeyM
    u8"",        // Comma
    u8"",        // Period
    u8"",        // Slash
    u8"\u0020",  // Space
};
const char* kCapslock[] = {
    u8"*",       // BackQuote
    u8"\u0ea2",  // Digit1
    u8"\u0e9f",  // Digit2
    u8"\u0ec2",  // Digit3
    u8"\u0e96",  // Digit4
    u8"\u0eb8",  // Digit5
    u8"\u0eb9",  // Digit6
    u8"\u0e84",  // Digit7
    u8"\u0e95",  // Digit8
    u8"\u0e88",  // Digit9
    u8"\u0e82",  // Digit0
    u8"\u0e8a",  // Minus
    u8"\u0ecd",  // Equal
    u8"\u0ebb",  // KeyQ
    u8"\u0ec4",  // KeyW
    u8"\u0eb3",  // KeyE
    u8"\u0e9e",  // KeyR
    u8"\u0eb0",  // KeyT
    u8"\u0eb4",  // KeyY
    u8"\u0eb5",  // KeyU
    u8"\u0eae",  // KeyI
    u8"\u0e99",  // KeyO
    u8"\u0e8d",  // KeyP
    u8"\u0e9a",  // BracketLeft
    u8"\u0ea5",  // BracketRight
    u8"\u201c",  // Backslash
    u8"\u0eb1",  // KeyA
    u8"\u0eab",  // KeyS
    u8"\u0e81",  // KeyD
    u8"\u0e94",  // KeyF
    u8"\u0ec0",  // KeyG
    u8"\u0ec9",  // KeyH
    u8"\u0ec8",  // KeyJ
    u8"\u0eb2",  // KeyK
    u8"\u0eaa",  // KeyL
    u8"\u0ea7",  // Semicolon
    u8"\u0e87",  // Quote
    u8"\u0e9c",  // KeyZ
    u8"\u0e9b",  // KeyX
    u8"\u0ec1",  // KeyC
    u8"\u0ead",  // KeyV
    u8"\u0eb6",  // KeyB
    u8"\u0eb7",  // KeyN
    u8"\u0e97",  // KeyM
    u8"\u0ea1",  // Comma
    u8"\u0ec3",  // Period
    u8"\u0e9d",  // Slash
    u8"\u0020",  // Space
};
const char* kAltgrCapslock[] = {
    u8"",        // BackQuote
    u8"\u0ed1",  // Digit1
    u8"\u0ed2",  // Digit2
    u8"\u0ed3",  // Digit3
    u8"\u0ed4",  // Digit4
    u8"\u0ed5",  // Digit5
    u8"\u0ed6",  // Digit6
    u8"\u0ed7",  // Digit7
    u8"\u0ed8",  // Digit8
    u8"\u0ed9",  // Digit9
    u8"\u0ed0",  // Digit0
    u8"",        // Minus
    u8"",        // Equal
    u8"",        // KeyQ
    u8"",        // KeyW
    u8"",        // KeyE
    u8"",        // KeyR
    u8"",        // KeyT
    u8"",        // KeyY
    u8"",        // KeyU
    u8"",        // KeyI
    u8"",        // KeyO
    u8"",        // KeyP
    u8"",        // BracketLeft
    u8"",        // BracketRight
    u8"",        // Backslash
    u8"",        // KeyA
    u8"",        // KeyS
    u8"",        // KeyD
    u8"",        // KeyF
    u8"",        // KeyG
    u8"",        // KeyH
    u8"",        // KeyJ
    u8"",        // KeyK
    u8"",        // KeyL
    u8"",        // Semicolon
    u8"",        // Quote
    u8"",        // KeyZ
    u8"",        // KeyX
    u8"",        // KeyC
    u8"",        // KeyV
    u8"",        // KeyB
    u8"",        // KeyN
    u8"",        // KeyM
    u8"",        // Comma
    u8"",        // Period
    u8"",        // Slash
    u8"\u0020",  // Space
};
const char* kShiftCapslock[] = {
    u8"/",             // BackQuote
    u8"1",             // Digit1
    u8"2",             // Digit2
    u8"3",             // Digit3
    u8"4",             // Digit4
    u8"\u0ecc",        // Digit5
    u8"\u0ebc",        // Digit6
    u8"5",             // Digit7
    u8"6",             // Digit8
    u8"7",             // Digit9
    u8"8",             // Digit0
    u8"9",             // Minus
    u8"\u0ecd\u0ec8",  // Equal
    u8"\u0ebb\u0ec9",  // KeyQ
    u8"0",             // KeyW
    u8"\u0eb3\u0ec9",  // KeyE
    u8"_",             // KeyR
    u8"+",             // KeyT
    u8"\u0eb4\u0ec9",  // KeyY
    u8"\u0eb5\u0ec9",  // KeyU
    u8"\u0ea3",        // KeyI
    u8"\u0edc",        // KeyO
    u8"\u0ebd",        // KeyP
    u8"-",             // BracketLeft
    u8"\u0eab\u0ebc",  // BracketRight
    u8"\u201d",        // Backslash
    u8"\u0eb1\u0ec9",  // KeyA
    u8";",             // KeyS
    u8".",             // KeyD
    u8",",             // KeyF
    u8":",             // KeyG
    u8"\u0eca",        // KeyH
    u8"\u0ecb",        // KeyJ
    u8"!",             // KeyK
    u8"?",             // KeyL
    u8"%",             // Semicolon
    u8"=",             // Quote
    u8"\u20ad",        // KeyZ
    u8"(",             // KeyX
    u8"\u0eaf",        // KeyC
    u8"x",             // KeyV
    u8"\u0eb6\u0ec9",  // KeyB
    u8"\u0eb7\u0ec9",  // KeyN
    u8"\u0ec6",        // KeyM
    u8"\u0edd",        // Comma
    u8"$",             // Period
    u8")",             // Slash
    u8"\u0020",        // Space
};
const char** kKeyMap[8] = {kNormal,        kShift,        kAltGr,
                           kShift,         kCapslock,     kShiftCapslock,
                           kAltgrCapslock, kShiftCapslock};

}  // namespace lo
