// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_CONSTANTS_NOTIFIER_CATALOGS_H_
#define ASH_CONSTANTS_NOTIFIER_CATALOGS_H_

namespace ash {

// This file contains catalogs with entries for every notifier in CrOS,
// including notifications, toasts, and nudges. By having your notifier here
// you'll automatically get metrics for it ---> go/notifier-framework-metrics.

// A living catalog that registers notifications.
// Current values should not be renumbered or removed. Please keep in sync with
// "NotificationCatalogName" in tools/metrics/histograms/enums.xml.
// To deprecate comment out the entry.
enum class NotificationCatalogName {
  kNone = 0,
  kTestCatalogName = 1,
  kManagementTransition = 2,
  // [Deprecated] kAuthpolicyCredentialsError = 3,
  // [Deprecated] kUnauthorizedBattery = 4,
  // [Deprecated] kNonWilcoCharger = 5,
  // [Deprecated] kIncompatibleDock = 6,
  // [Deprecated] kDockError = 7,
  // [Deprecated] KDockDisplayError = 8,
  // [Deprecated] kDockThunderboltError = 9,
  // [Deprecated] kWilcoLowPowerCharger = 10,
  kDeprecatedAccelerator = 11,
  // [Deprecated] kShortcutsChanged = 12,
  kDockedMagnifierEnabled = 13,
  kHighContrastEnabled = 14,
  kFullScreenMagnifierEnabled = 15,
  kAccessibilityFeatureDisabled = 16,
  kDisplayError = 17,
  kDisplayChange = 18,
  kDualRole = 19,
  kEOL = 20,
  kPendingEOL = 21,
  kHats = 22,
  kKerberosTicketExpiry = 23,
  kMobileData = 24,
  kMultiDevice = 25,
  kNetworkOutOfCredits = 26,
  kNetworkConnectionError = 27,
  kNetworkVPNConnectionLost = 28,
  kNetworkCellularActivated = 29,
  kNetworkActivationError = 30,
  kPasswordExpiry = 31,
  kDeviceAccountSigninError = 32,
  kSecondaryAccountSigninError = 33,
  kSyncError = 34,
  kTetherPotentialHotspot = 35,
  kTetherSetupRequired = 36,
  kTetherConnectionError = 37,
  kScreenTimeLimitUpdated = 38,
  kBedtimeUpdated = 39,
  kTimeLimitOverride = 40,
  kScreenTimeLimit = 41,
  kBedtimeLimit = 42,
  kTPMFirmwareUpdate = 43,
  kU2F = 44,
  kReleaseNotes = 45,
  kSMS = 46,
  kAssistantNotification = 47,
  kFastPair = 48,
  // [Deprecated] kPowerNotifier = 49,
  kBatteryNotifier = 50,
  kMicrophoneMute = 51,
  kCast = 52,
  kSessionLengthTimeout = 53,
  kLocaleUpdate = 54,
  kTracing = 55,
  kPcieBillboardDevice = 56,
  kPcieLimitedPerformance = 57,
  kPcieGuestMode = 58,
  kPciePeripheralBlocked = 59,
  kDetachableBaseRequiresUpdate = 60,
  kDetachableBasePairingNotification = 61,
  kFirmwareUpdate = 62,
  kPeripheralBattery = 63,
  kBluetoothPairingRequest = 64,
  // [Deprecated] kBluetoothPairedDevice = 65,
  kCellularSetup = 66,
  // [Deprecated] kScreenSecurity = 67,
  kWifiToggle = 68,
  kUSBPeripheralInvalidDpCable = 69,
  kUSBPeripheralInvalidUSB4ValidTBTCable = 70,
  kUSBPeripheralInvalidUSB4Cable = 71,
  kUSBPeripheralInvalidTBTCable = 72,
  kUSBPeripheralSpeedLimitingCable = 73,
  kGestureEducation = 74,
  kUpdate = 75,
  kArcSnapshotReboot = 76,
  kPhoneHubTetherFailed = 77,
  kCapsLock = 78,
  kNightLight = 79,
  kPluginVMUninstaller = 80,
  // [Deprecated] kTPMAutoUpdate = 81,
  kIt2MeConfirmation = 82,
  kHPSNotify = 83,
  kNearbyShare = 84,
  kUpdateRequired = 85,
  kFileSystemProvider = 86,
  kEasyUnlockChromebookAdded = 87,
  kEasyUnlockPairingChange = 88,
  kEasyUnlockPairingChangeApplied = 89,
  kEasyUnlockSmartLockSignInRemoved = 90,
  kSystemProxy = 91,
  kDlpPolicy = 92,
  kPacketCapture = 93,
  kEcheAppRetryConnection = 94,
  kEcheAppInactivity = 95,
  kEcheAppFromWebWithoutButton = 96,
  kEcheAppScreenLock = 97,
  // [Deprecated] kAccessibility = 98,
  kProjector = 99,
  kWebsiteApproval = 100,
  kArcMigrationGuide = 101,
  kBorealisContext = 102,
  kArcProvision = 103,
  kUsbPrinter = 104,
  kCupsPrintJob = 105,
  kArcBootError = 106,
  kDeviceCommandReset = 107,
  kCrostiniLowDisk = 108,
  kScreenCapture = 109,
  kLowDisk = 110,
  kEventRewriterDeprecation = 111,
  kVMCameraMic = 112,
  kSecurityToken = 113,
  kCrostiniExportImport = 114,
  // [Deprecated] kLacrosCannotLaunch = 115,
  kRequestFileSystem = 116,
  kNetworkPortalDetector = 117,
  kCrostiniPackage = 118,
  kCrostiniUpgradeAvailable = 119,
  // [Deprecated] kFullRestore = 120,
  kAdbSideloadingDisallowed = 121,
  kAdbSideloadingPowerwashPlanned = 122,
  kAdbSideloadingPowerwashOnReboot = 123,
  kAppTime = 124,
  kCrosUSBDetector = 125,
  kPowerwashRequest = 126,
  kPowerwashRequestError = 127,
  kCameraPrivacySwitch = 128,
  kAutoLaunch = 129,
  kPasswordChange = 130,
  kAnnouncementNotification = 131,
  kWebUsb = 132,
  kBackgroundCrash = 133,
  kDownloadNotification = 134,
  kAdaptiveCharging = 135,
  kManagedSimLock = 136,
  kSpokenFeedbackEnabled = 137,
  kBrailleDisplayConnected = 138,
  kSpokenFeedbackBrailleEnabled = 139,
  kSwitchAccessEnabled = 140,
  kSpeechRecognitionFilesDownloaded = 141,
  kSpeechRecognitionFilesFailed = 142,
  kLowPowerCharger = 143,
  kLowPowerAdapter = 144,
  kTPMAutoUpdatePlanned = 145,
  kTPMAutoUpdateOnReboot = 146,
  kPrivacyIndicators = 147,
  kTailoredSecurityDisabled = 148,
  kTailoredSecurityEnabled = 149,
  kTailoredSecurityPromotion = 150,
  kArcLowDiskSpacePreStop = 151,
  kArcLowDiskSpacePostStop = 152,
  kMultiCapture = 153,
  kPrivacyHubCamera = 154,
  // [Deprecated] kPrivacyHubHWCameraSwitchOffSWCameraSwitchOn = 155,
  kEcheAppNetworkSetting = 156,
  kPrivacyHubMicAndCamera = 157,
  kArcVmDataMigration = 158,
  kWebHid = 159,
  kDoNotDisturb = 160,
  kDictationAllDlcsDownloaded = 161,
  kDictationNoDlcsDownloaded = 162,
  kDicationOnlyPumpkinDownloaded = 163,
  kDictationOnlySodaDownloaded = 164,
  kIPHGoogleOneOffer = 165,
  kLockScreen = 166,
  kWebAppSettings = 167,
  kEOLIncentive = 168,
  kHotspot = 169,
  kGeolocationSwitch = 170,
  kMultiCaptureOnLogin = 171,
  kFloatingWorkspace = 172,
  kScalableIphNotification = 173,
  // [Deprecated] kUpdateNotification = 174,
  kSubAppsUninstall = 175,
  kNetworkCarrierUnlock = 176,
  kCoralFeature = 177,
  kInputDeviceSettings = 178,
  kDocumentScanning = 179,
  kGrowthFramework = 180,
  kAudioSelection = 181,
  kExtendedUpdatesAvailable = 182,
  kOnDeviceAppControls = 183,
  kFaceGazeAssetsDownloaded = 184,
  kFaceGazeAssetsFailed = 185,
  kDeviceRestrictionScheduleUpcomingLogout = 186,
  kDeviceRestrictionSchedulePostLogout = 187,
  kTouchpadDisabled = 188,
  kOnTaskEnterLockedMode = 189,
  kOnTaskSessionEnd = 190,
  kOnTaskAddContentToBundle = 191,
  kOnTaskRemoveContentFromBundle = 192,
  kScannerAction = 193,
  kChromeAppDeprecation = 194,
  kDownloadImageFromLobster = 195,
  kBocaSpotlightStarted = 196,
  kFaceGazeActive = 197,
  kMaxValue = kFaceGazeActive
};

// A living catalog that registers system nudges.
// Current values should not be renumbered or removed. Please keep in sync with
// "NudgeCatalogName" in tools/metrics/histograms/metadata/ash/enums.xml.
// To deprecate comment out the entry.
// Use `AnchoredNudgeManager::Get()->MaybeRecordNudgeAction()` with the proper
// catalog name when the nudge's suggested action is performed by the user, if
// applicable, to record a `TimeToAction` metric.
enum class NudgeCatalogName {
  kTestCatalogName = 0,
  kDictation = 1,
  // [Deprecated] kMultipaste = 2,
  // [Deprecated] kDarkLightMode = 3,
  kAutozoom = 4,
  // [Deprecated] kAdaptiveCharging = 5,
  kPhoneHub = 6,
  kClipboardHistoryZeroState = 7,
  kClipboardHistoryOnboarding = 8,
  kDisableDiacritics = 9,
  kClipboardHistoryDuplicateCopy = 10,
  kVideoConferenceTraySpeakOnMuteDetected = 11,
  kVideoConferenceTrayMicrophoneUseWhileHWDisabled = 12,
  kVideoConferenceTrayMicrophoneUseWhileSWDisabled = 13,
  kVideoConferenceTrayCameraUseWhileHWDisabled = 14,
  kVideoConferenceTrayCameraUseWhileSWDisabled = 15,
  kVideoConferenceTraySpeakOnMuteOptIn = 16,
  // [Deprecated] kVideoConferenceTraySpeakOnMuteOptInConfirmation = 17,
  kScalableIphBubble = 18,
  kVideoConferenceTrayCameraMicrophoneUseWhileDisabled = 19,
  kMultitaskMenuClamshell = 20,
  kMultitaskMenuTablet = 21,
  kCaptureModeEducationShortcutNudge = 22,
  kCaptureModeEducationShortcutTutorial = 23,
  kCaptureModeEducationQuickSettingsNudge = 24,
  kGameDashboardControlsNudge = 25,
  // [Deprecated] kWebsiteTelemetryReportingNudge = 26,
  // [Deprecated] kStandaloneWindowMigrationUx = 27,
  kFocusModeEndingMomentNudge = 28,
  kInformedRestoreEducationNudge = 29,
  kGrowthCampaignNudge = 30,
  kSearchTopRowKeyPressed = 31,
  kSixPackRemappingPressed = 32,
  kCapsLockShortcutPressed = 33,
  kMahi = 34,
  kBirchPrivacy = 35,
  kVideoConferenceTraySidetoneNotSupported = 36,
  kVideoConferenceTraySidetoneEnabled = 37,
  kGraduationAppEnabled = 38,
  kSunfishLauncherNudge = 39,
  kMaxValue = kSunfishLauncherNudge
};

// A living catalog that registers toasts.
// Current values should not be renumbered or removed. Please keep in sync with
// "ToastCatalogName" in tools/metrics/histograms/metadata/ash/enums.xml
// To deprecate comment out the entry.
enum class ToastCatalogName {
  kVirtualDesksLimitMax = 0,
  kVirtualDesksLimitMin = 1,
  kAssistantError = 2,
  kDebugCommand = 3,
  kAssistantUnboundService = 4,
  kStylusPrompt = 5,
  kAppResizable = 6,
  kKioskAppError = 7,
  kBluetoothDevicePaired = 8,
  kBluetoothDeviceDisconnected = 9,
  kBluetoothDeviceConnected = 10,
  kBluetoothAdapterDiscoverable = 11,
  kEncourageUnlock = 12,
  kNetworkAutoConnect = 13,
  kAssistantLoading = 14,
  kTestCatalogName = 15,
  kMaximumDeskLaunchTemplate = 16,
  // [Deprecated] kEnterOverviewGesture = 17,
  // [Deprecated] kExitOverviewGesture = 18,
  // [Deprecated] kNextDeskGesture = 19,
  // [Deprecated] kPreviousDeskGesture = 20,
  kMoveVisibleOnAllDesksWindow = 21,
  kAppCannotSnap = 22,
  kCrostiniUnsupportedVirtualKeyboard = 23,
  kCrostiniUnsupportedIME = 24,
  kCopyToClipboardShareAction = 25,
  kClipboardBlockedAction = 26,
  kClipboardWarnOnPaste = 27,
  kAppNotAvailable = 28,
  kCameraPrivacySwitchOff = 29,
  kCameraPrivacySwitchOn = 30,
  kExtensionInstallSuccess = 31,
  kAccountRemoved = 32,
  kDeskTemplateTooLarge = 33,
  kUndoCloseAll = 34,
  kEcheAppToast = 35,
  // [Deprecated] kDeprecateAssistantStylus = 36,
  // [Deprecated] kEcheTrayCopyPasteNotImplemented = 37,
  kEcheTrayTabletModeNotSupported = 38,
  kNotificationCenterTrayNoNotifications = 39,
  // [Deprecated] kCopyToClipboardAction = 40,
  // [Deprecated] kVideoConferenceTraySpeakOnMuteDetected = 41,
  kCopyGifToClipboardAction = 42,
  // [Deprecated] kVideoConferenceTrayUseWhileDisabled = 43,
  kBatterySaverDisabled = 44,
  kDictationNoFocusedTextField = 45,
  kBatterySaverEnabled = 46,
  kDictationMicMuted = 47,
  kVideoConferenceTraySpeakOnMuteOptInConfirmation = 48,
  kAppNotClosable = 49,
  kGameDashboardEnterTablet = 50,
  kInformedRestoreOnboarding = 51,
  kTouchpadDisabled = 52,
  // [Deprecated] kOnTaskEnterLockedMode = 53,
  // [Deprecated] kOnTaskSessionEnd = 54,
  kOnTaskUrlBlocked = 55,
  kCopyImageToClipboardAction = 56,
  kCaptureModeTextCopied = 57,
  kCoralSavedGroupLimitMax = 58,
  kScannerActionSuccess = 59,
  kScannerActionFailure = 60,
  kCameraNowAllowed = 61,
  kCameraNowDisallowed = 62,
  kCameraForceDisabled = 63,
  kMaxValue = kCameraForceDisabled
};

}  // namespace ash

#endif  // ASH_CONSTANTS_NOTIFIER_CATALOGS_H_
