// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_CONSTANTS_ASH_FEATURES_H_
#define ASH_CONSTANTS_ASH_FEATURES_H_

#include "base/component_export.h"
#include "base/feature_list.h"
#include "base/metrics/field_trial_params.h"
#include "base/time/time.h"

namespace ash::features {

// All features in alphabetical order. The features should be documented
// alongside the definition of their values in the .cc file. If a feature is
// being rolled out via Finch, add a comment in the .cc file.

COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAdaptiveCharging);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOnDeviceAppControls);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAllowAmbientEQ);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAllowApnModificationPolicy);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAllowCrossDeviceFeatureSuite);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAllowScrollSettings);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAltClickAndSixPackCustomization);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAlwaysReinstallSystemWebApps);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAmbientEQDefaultOff);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAmbientModeDevUseProdFeature);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAnnotatorMode);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kApnRevamp);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kArcAdbSideloadingFeature);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kArcManagedAdbSideloadingSupport);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAshSessionRestoreDeferOccludedActiveTabLoad);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAssistMultiWord);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAudioSelectionImprovement);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCrasSplitAlsaUsbInternal);
COMPONENT_EXPORT(ASH_CONSTANTS)
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAudioUrl);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAutoNightLight);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAutoScreenBrightness);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAutocorrectFederatedPhh);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAutocorrectParamsTuning);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAutocorrectByDefault);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAutozoomNudgeSessionReset);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBabelOrca);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBatterySaver);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kBirchVideoConferenceSuggestions);
enum BatterySaverNotificationBehavior { kBSMAutoEnable, kBSMOptIn };
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<BatterySaverNotificationBehavior>
    kBatterySaverNotificationBehavior;
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<double> kBatterySaverActivationChargePercent;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBatterySaverAlwaysOn);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kBluetoothFixA2dpPacketSize);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBluetoothQualityReport);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBluetoothWbsDogfood);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBoca);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBocaUber);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBocaConsumer);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBocaExtensionConsumer);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBocaCustomPolling);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta>
    kBocaIndefinitePeriodicJobIntervalInSeconds;
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta>
    kBocaInSessionPeriodicJobIntervalInSeconds;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBocaOnTaskMuteArcAudio);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBocaOnTaskPod);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kBocaOnTaskUnmuteBrowserTabsOnUnlock);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kBocaLockedModeCustomCountdownDuration);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta>
    kBocaLockedModeCountdownDurationInSeconds;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBocaStudentHeartbeat);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kBocaStudentHeartbeatCustomInterval);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta>
    kBocaStudentHeartbeatPeriodicJobIntervalInSeconds;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBocaSpotlight);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<std::string> kBocaSpotlightUrlTemplate;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBocaNetworkRestriction);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kBocaSequentialSessionLoad);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kBocaClientTypeForSpeechRecognition);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kBocaAdjustCaptionBubbleOnExpand);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCameraSuperResSupported);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrosSwitcher);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBorealisBigGl);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBorealisDGPU);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kBorealisEnableUnsupportedHardware);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBorealisForceBetaClient);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBorealisForceDoubleScale);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBorealisLinuxMode);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBorealisPermitted);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBorealisProvision);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBorealisScaleClientByDPI);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBorealisZinkGlDriver);
enum BorealisZinkGlDriverParam { kZinkEnableRecommended, kZinkEnableAll };
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<BorealisZinkGlDriverParam>
    kBorealisZinkGlDriverParam;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCampbellGlyph);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCaptureModeEducation);
enum class CaptureModeEducationParam {
  kShortcutNudge,
  kShortcutTutorial,
  kQuickSettingsNudge
};
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<CaptureModeEducationParam>
    kCaptureModeEducationParam;
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCaptureModeEducationBypassLimits);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCaptureModeOnDeviceOcr);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCellularBypassESimInstallationConnectivityCheck);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCellularUseSecondEuicc);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kChangePasswordFactorSetup);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCheckPasswordsAgainstCryptohomeHelper);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kClipboardHistoryLongpress);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kClipboardHistoryUrlTitles);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kConch);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kConchExpandTranscriptionLanguage);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kConchGenAi);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kConchLargeModel);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kConchSystemAudioFromMic);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kContinuousOverviewScrollAnimation);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCopyClientKeysCertsToChaps);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCoralFeature);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCoralFeatureAllowed);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCoralFeatureMultiLanguage);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrosPrivacyHub);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrosSeparateGeoApiKey);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrosSafetyService);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCryptauthAttestationSyncing);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDesksTemplates);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kChromeboxUsbPassthroughLimit);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrostiniContainerless);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrostiniDiskResizing);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrostiniGpuSupport);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrostiniResetLxdDb);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrostiniMultiContainer);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrostiniQtImeSupport);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCrostiniVirtualKeyboardSupport);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCryptAuthV2DeviceActivityStatus);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCryptAuthV2DeviceActivityStatusUseConnectivity);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCryptohomeRecoveryByDefaultForConsumers);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCryptohomeRecoveryByDefaultForEnterprise);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDeferConciergeStartup);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDemoModeAppResetWindowContainer);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDemoModeSignIn);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDemoModeWallpaperUpdate);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDemoModeSignInFileCleanup);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDeskTemplateSync);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDeviceActiveClient28DayActiveCheckMembership);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDeviceActiveClientChurnCohortCheckMembership);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDeviceActiveClientChurnObservationCheckMembership);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDeviceActiveClientChurnObservationNewDeviceMetadata);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kInputDeviceSettingsSplit);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kInputMethodDeadKeyFixForNoInputField);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kInputMethodDeadKeyFix);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kInputMethodKoreanRightAltKeyDownFix);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kPeripheralCustomization);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDiacriticsOnPhysicalKeyboardLongpressDefaultOn);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDiacriticsUseReplaceSurroundingText);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDisableBruschettaInstallChecks);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDisableGoogleOneOfferFilesBanner);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDisableIdleSocketsCloseOnMemoryPressure);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDisableDnsProxy);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDisconnectWiFiOnEthernetConnected);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDisplayAlignAssist);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDisplayPerformanceMode);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDoNotDisturbShortcut);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDriveFs);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDriveFsMirroring);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementDriveFsBulkPinning);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDriveFsShowCSEFiles);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEapGtcWifiAuthentication);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEcheSWA);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEcheSWADebugMode);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEcheSWAMeasureLatency);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEcheSWASendStartSignaling);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEcheSWADisableStunServer);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEcheSWACheckAndroidNetworkInfo);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEcheSWAProcessAndroidAccessibilityTree);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableBackgroundBlur);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableBrightnessControlInSettings);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableDozeModePowerScheduler);
COMPONENT_EXPORT(ASH_CONSTANTS)
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableExternalKeyboardsInDiagnostics);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableFilesAppCopyImage);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableHostnameSetting);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableFastInkForSoftwareCursor);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableKeyboardBacklightControlInSettings);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableKeyboardRewriterFix);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableOAuthIpp);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableAllSystemWebApps);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableNssDbClientCertsRollback);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableRFC8925);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableRootNsDnsProxy);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableToggleCameraShortcut);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableTouchscreenMappingExperience);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableTouchpadsInDiagnosticsApp);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableTouchscreensInDiagnosticsApp);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableWifiQos);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableWifiQosEnterprise);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnterOverviewFromWallpaper);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEolIncentive);
enum class EolIncentiveParam { kNoOffer, kOffer, kOfferWithWarning };
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<EolIncentiveParam> kEolIncentiveParam;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEolIncentiveSettings);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kESimEmptyActivationCodeSupported);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kExoHapticFeedbackSupport);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kExoLinuxDmabufV4);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kExoLinuxDmabufModifiers);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kExoOrdinalMotion);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kExperimentalRgbKeyboardPatterns);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kExtendedUpdatesOptInFeature);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFamilyLinkOnSchoolDevice);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFastPair);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFastPairAdvertisingFormat2025);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFastPairBleRotation);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFastPairDebugMetadata);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFastPairHandshakeLongTermRefactor);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFastPairKeyboards);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFastPairSavedDevicesNicknames);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFastPairPwaCompanion);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<std::string> kFastPairPwaCompanionInstallUri;
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<std::string> kFastPairPwaCompanionAppId;
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<std::string> kFastPairPwaCompanionPlayStoreUri;
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<std::string> kFastPairPwaCompanionDeviceIds;
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<double>
    kFastPairDeviceLostNotificationTimeoutMinutes;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnterpriseReportingUI);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEphemeralNetworkPolicies);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEphemeralNetworkPoliciesEnabledPolicy);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFastPairSavedDevices);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFastPairSavedDevicesStrictOptIn);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagement16Desks);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementBorealis);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementConchGenAi);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFeatureManagementShowoff);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementTimeOfDayScreenSaver);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementTimeOfDayWallpaper);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFederatedService);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFederatedStringsService);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFederatedStringsServiceScheduleTasks);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFederatedLauncherQueryAnalyticsVersion2Task);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFilesConflictDialog);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFilesLocalImageSearch);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFilesMaterializedViews);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFilesSinglePartitionFormat);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFilesTrashAutoCleanup);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFilesTrashDrive);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFirmwareUpdateUIV2);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFirstPartyVietnameseInput);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFlexAutoEnrollment);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFloatingSso);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFloatingWorkspace);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta>
    kFloatingWorkspaceMaxTimeAvailableForRestoreAfterLogin;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFloatingWorkspaceV2);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta>
    kFloatingWorkspaceV2MaxTimeAvailableForRestoreAfterLogin;
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta>
    kFloatingWorkspaceV2PeriodicJobIntervalInSeconds;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEcheLauncher);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEcheLauncherListView);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEcheLauncherIconsInMoreAppsButton);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEcheNetworkConnectionState);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEcheShorterScanningDutyCycle);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta>
    kEcheBackgroundConnectionAttemptThrottleTimeout;
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta>
    kEcheConnectionStatusResetTimeout;
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta> kEcheScanningCycleOnTime;
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta> kEcheScanningCycleOffTime;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFingerprintAuthFactor);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kForceEnableServerSideSpeechRecognition);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kForceOnDeviceAppControlsForAllRegions);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kForestFeature);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFullscreenAfterUnlockAllowed);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFullscreenAlertBubble);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFuseBoxDebug);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGlanceablesTimeManagementClassroomStudentView);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGlanceablesTimeManagementTasksView);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGlanceablesTimeManagementTasksViewAssignedTasks);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGaiaRecordAccountCreation);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGameDashboardGamepadSupport);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kGameDashboardGamePWAs);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kGameDashboardGamesInTest);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kGameDashboardUtilities);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAppLaunchShortcut);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementGameDashboardRecordGame);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBlockFwupdClient);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kGamepadVibration);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGesturePropertiesDBusService);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGoogleOneOfferFilesBanner);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kGraduation);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGraduationUseEmbeddedTransferEndpoint);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementGrowthFramework);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFlexFirmwareUpdate);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kIgnoreDeviceFlexArcEnabledPolicy);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthFramework);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsNudgeParentToAppWindow);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsCrOSEvents);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsDemoModeSignIn);
// Predefined Growth Framework experiments.
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment1);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment2);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment3);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment4);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment5);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment6);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment7);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment8);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment9);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment10);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment11);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment12);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment13);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment14);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment15);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment16);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment17);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment18);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment19);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperiment20);
// Growth Framework one-off experiment tags.
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperimentFileAppGamgee);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperimentG1Nudge);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsExperimentTagTargeting);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsInConsumerSession);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsInDemoMode);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsShowNudgeInsideWindowBounds);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsTriggerAtLoadComplete);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsTriggerByAppOpen);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsTriggerByBrowser);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsTriggerByEvent);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsTriggerByRecordEvent);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGrowthCampaignsObserveTriggeringWidgetChange);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kGrowthInternals);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHomeButtonWithText);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProductivityLauncherImageSearch);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kLauncherItemColorSync);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kHealthdInternalsTabs);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kHelpAppAppDetailPage);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kHelpAppAppsList);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kHelpAppAutoTriggerInstallDialog);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kHelpAppHomePageAppArticles);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHelpAppLauncherSearch);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kHelpAppOnboardingRevamp);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kHelpAppOpensInsteadOfReleaseNotesNotification);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHelpAppWelcomeTips);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHibernate);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHiddenNetworkWarning);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kHideShelfControlsInTabletMode);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHindiInscriptLayout);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHoldingSpaceSuggestions);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHomeButtonQuickAppAccess);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kImeDownloaderExperiment);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kImeDownloaderUpdate);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImeFstDecoderParamsUpdate);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kImeOptionsInSettings);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kImeRuleConfig);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImeServiceProto);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kImeManifestV3);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kImeSystemEmojiPicker);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImeSystemEmojiPickerGIFSupport);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImeSystemEmojiPickerJellySupport);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImeSystemEmojiPickerMojoSearch);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImeSystemEmojiPickerVariantGrouping);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kImeStylusHandwriting);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImeUsEnglishExperimentalModel);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kImeUsEnglishModelUpdate);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImeKoreanModeSwitchDebug);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImeSwitchCheckConnectionStatus);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImeKoreanOnlyModeSwitchOnRightAlt);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImprovedLoginErrorHandling);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImprovedManagementDisclosure);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kInstantHotspotOnNearby);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kInstantHotspotRebrand);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kInstantTethering);
// TODO(b/288273641): Clean up the server speech recognition related flags.
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kInternalServerSideSpeechRecognition);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kInternalServerSideSpeechRecognitionControl);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kInternalServerSideSpeechRecognitionByFinch);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kInternalServerSideSpeechRecognitionUSMModelFinch);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kIppClientInfo);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kIppFirstSetupForUsbPrinters);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kIsolatedWebAppKiosk);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kJapaneseFunctionRow);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kJapaneseOSSettings);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kKerberosRememberPasswordByDefault);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kKioskEnableImeButton);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLanguagePacksFonts);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<bool>
    kLanguagePacksFontsLoadAfterDownloadDuringLogin;
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLanguagePacksInOobe);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLanguagePacksInSettings);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLauncherContinueSectionWithRecents);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLauncherContinueSectionWithRecentsRollout);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLauncherNudgeShortInterval);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLauncherNudgeSessionReset);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kLauncherSearchControl);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementLocalImageSearch);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLinkCrossDeviceDogfoodFeedback);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLinkCrossDeviceInternals);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLobster);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLobsterDogfood);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLobsterDraggingSupport);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLobsterFileNamingImprovement);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLobsterQuickInsertZeroState);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLobsterDisabledByInvalidIME);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLobsterFeedback);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLobsterForManagedUsers);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLobsterI18n);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLobsterUseRewrittenQuery);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLobsterAlwaysShowDisclaimerForTesting);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLobsterRightClickMenu);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementLobster);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLockScreenHideSensitiveNotificationsSupport);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kLockScreenNotifications);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kMacAddressRandomization);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kMediaAppPdfMahi);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kMediaAppImageMantis);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kMediaAppImageMantisErase);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kMediaAppImageMantisExpandBackground);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kMediaAppImageMantisMakeASticker);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kMediaAppImageMantisModel);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kMediaAppImageMantisReimagine);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kMediaAppImageMantisRemoveBackground);
enum class MantisModel { V1, V2 };
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<MantisModel> kMediaAppImageMantisModelParams;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kMinimumChromeVersion);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kModifierSplit);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kMouseImposterCheck);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kMultiCalendarSupport);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta>
    kMultiDeviceSetupNotificationTimeLimit;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kMultiZoneRgbKeyboard);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kNearbyPresence);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kNotificationLimit);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kNotifierCollision);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kNullTopRowFix);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementShouldExcludeFromSysUiHoldback);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSysUiShouldHoldbackDriveIntegration);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSysUiShouldHoldbackTaskManagement);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kNightLight);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kNotificationCenterController);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kNotificationExpansionAnimation);
COMPONENT_EXPORT(ASH_CONSTANTS)
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kNotificationScrollBar);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kNotificationsInContextMenu);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOfflineItemsInNotifications);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOnDeviceGrammarCheck);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOnDeviceSpeechRecognition);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOneDriveUploadImmediateReauth);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOngoingProcesses);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSearchCustomizableShortcutsInLauncher);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOobeAddUserDuringEnrollment);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeChoobe);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeCrosEvents);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeDrivePinning);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeGaiaInfoScreen);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeJelly);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeJellyModal);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeLazyLoading);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobePerksDiscovery);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOobePersonalizedOnboarding);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobePreConsentMetrics);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeSoftwareUpdate);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementOobeAiIntro);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementOobeGeminiIntro);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementOobeSimon);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeSkipAssistant);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOobeQuickStartOnLoginScreen);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeTouchpadScroll);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeDisplaySize);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeInputMethods);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOobeSplitModifierKeyboardInfo);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaArc);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaElaborate);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaEmojify);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaFormalize);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaProofread);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaRephrase);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaShorten);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOrcaInternationalizeElaborate);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOrcaInternationalizeEmojify);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOrcaInternationalizeFormalize);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOrcaInternationalizeProofread);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOrcaInternationalizeRephrase);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOrcaInternationalizeShorten);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaAfrikaans);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaDanish);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaDutch);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaFinnish);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaFrench);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaGerman);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaItalian);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaJapanese);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaNorwegian);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaPolish);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaPortugese);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaSpanish);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaSwedish);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaForManagedUsers);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaOnWorkspace);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaServiceConnection);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaServiceProto);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOrcaSupportDemoMode);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOrcaForceFetchContextOnGetEditorPanelContext);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOrcaDraggingSupport);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOrcaOnlyInEnglishLocales);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOrcaResizingSupport);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOrcaUseAccountCapabilities);
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOsFeedbackDialogEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOsFeedbackDialog);
COMPONENT_EXPORT(ASH_CONSTANTS)
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOsSyncConsentRevamp);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kParentAccessJelly);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kPcieBillboardNotification);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPerDeskShelf);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPeripheralNotification);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnablePeripheralsLogging);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPhoneHub);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPhoneHubCameraRoll);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta>
    kPhoneHubCameraRollThrottleInterval;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPhoneHubCallNotification);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kPhoneHubMonochromeNotificationIcons);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kPhoneHubOnboardingNotifierRevamp);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<bool> kPhoneHubOnboardingNotifierUseNudge;
enum class PhoneHubNotifierTextGroup {
  // The int values should not be changed as they are referenced on the server.
  kNotifierTextGroupA = 1,
  kNotifierTextGroupB = 2
};
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<PhoneHubNotifierTextGroup>
    kPhoneHubNotifierTextGroup;
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta> kPhoneHubNudgeDelay;
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<int> kPhoneHubNudgeTotalAppearancesAllowed;
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kPhoneHubPingOnBubbleOpen);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta> kPhoneHubPingTimeout;
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kPhoneHubShortQuickActionPodsTitles);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPickerGifs);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPreferConstantFrameRate);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPrintPreviewCrosApp);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kProjectorManagedUser);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kProjectorAppDebug);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kProjectorCustomThumbnail);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProjectorManagedUserIgnorePolicy);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProjectorShowShortPseudoTranscript);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProjectorUpdateIndexableText);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProjectorBleedingEdgeExperience);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProjectorServerSideRecognitionFallbackImpl);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kProjectorMuting);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kProjectorRedirectToPwa);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProjectorUseUSMForS3);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kProjectorDynamicColors);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kProjectorGm3);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProjectorUseDVSPlaybackEndpoint);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPromiseIcons);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPromiseIconsWebApps);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kQuickDim);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSmbServiceIsCreatedOnUserSessionStartUpTaskCompleted);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSmbproviderdOnDemand);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kQuickAppAccessTestUI);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kQuickUnlockFingerprint);
// TODO(crbug.com/1104164) - Remove this once most users have their preferences
// backfilled.
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kQuickUnlockPinAutosubmitBackfill);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kReleaseNotesNotificationAllChannels);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kReleaseNotesNotificationAlwaysEligible);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kRenderArcNotificationsByChrome);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kRemoveStalePolicyPinnedAppsFromShelf);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kResetAudioSelectionImprovementPref);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kResetShortcutCustomizations);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSameAppWindowCycle);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSanitize);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSanitizeV1);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kScalableIph);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kScalableIphDebug);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kScalableIphTrackingOnly);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kScalableIphClientConfig);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kScalableShelfPods);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kScannerDogfood);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kScannerFeedbackToast);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kScannerUpdate);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFeatureManagementScanner);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSchedulerConfiguration);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSeamlessRefreshRateSwitching);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSeaPen);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFeatureManagementSeaPen);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSeaPenDemoMode);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSeaPenQueryRewrite);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSeaPenTextInput);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSeaPenTextInputTranslation);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSeaPenUseExptTemplate);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSeparateNetworkIcons);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSeparateWebAppShortcutBadgeIcon);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSessionManagerLongKillTimeout);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSessionManagerLivenessCheck);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSettingsAppNotificationSettings);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSettingsAppThemeChangeAnimation);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kShelfAutoHideSeparation);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kShelfLauncherNudge);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kShimlessRMAOsUpdate);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kShimlessRMA3pDiagnostics);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kShimlessRMA3pDiagnosticsDevMode);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kShimlessRMA3pDiagnosticsAllowPermissionPolicy);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kShimlessRMAHardwareValidationSkip);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kShimlessRMADynamicDeviceInfoInputs);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kShortcutStateMachines);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kShowBluetoothDebugLogToggle);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kShowLiveCaptionInVideoConferenceTray);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kShowSharingUserInLauncherContinueSection);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kShowSpatialAudioToggle);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSingleCaCertVerificationPhase0);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSingleCaCertVerificationPhase1);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSingleCaCertVerificationPhase2);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementFeatureAwareDeviceDemoMode);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDemoModeAppLandscapeLocked);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSideAlignedToasts);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSmartDimExperimentalComponent);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSmartLockSignInRemoved);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSnoopingProtection);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSplitKeyboardRefactor);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSunfishFeature);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSunfishLensWeb);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSunfishLensWebCopyText);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSuspendStateMachine);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSystemJapanesePhysicalTyping);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSystemShortcutBehavior);
enum class SystemShortcutBehaviorParam {
  kNormalShortcutBehavior,
  kIgnoreCommonVdiShortcutList,
  kIgnoreCommonVdiShortcutListFullscreenOnly,
  kAllowSearchBasedPassthrough,
  kAllowSearchBasedPassthroughFullscreenOnly,
};
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<SystemShortcutBehaviorParam>
    kSystemShortcutBehaviorParam;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSystemNudgeMigration);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSystemTrayShadow);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSystemProxyForSystemServices);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kTelemetryExtension);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kTetheringExperimentalFunctionality);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kTerminalDev);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kTilingWindowResize);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kTouchVirtualKeyboardPolicyListenPrefsAtLogin);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kTrafficCountersEnabled);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kTrafficCountersForWiFiTesting);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kTrilinearFiltering);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kUnmanagedDeviceDeviceTrustConnectorEnabled);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kUseAndroidStagingSmds);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kUseAnnotatedAccountId);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kUseAuthPanelInSession);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kUseKcerClientCertStore);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kUseLegacyDHCPCD);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAllowPasswordlessSetup);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAllowPasswordlessRecovery);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLocalAuthenticationWithPin);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWebAuthNAuthDialogMerge);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kActiveSessionAuth);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kUseLoginShelfWidget);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kUseMessagesStagingUrl);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kUseMlServiceForNonLongformHandwritingOnAllBoards);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kUseSearchClickForRightClick);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kUseStorkSmdsServerAddress);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kUseWallpaperStagingUrl);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kUserActivityPrediction);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kUseTokenHandleStore);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLiveCaptionUserMicrophone);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVcBackgroundReplace);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVcResizeThumbnail);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVcDlcUi);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVcStopAllScreenShare);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVcPortraitRelight);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kVcRelightingInferenceBackend);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVcControlsUiFakeEffects);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kVcSegmentationInferenceBackend);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kVcRetouchInferenceBackend);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVcSegmentationModel);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVcStudioLook);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVcTrayMicIndicator);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVcTrayTitleHeader);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVcLightIntensity);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVcWebApi);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementVideoConference);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kVirtualKeyboardBorderedKey);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kVirtualKeyboardGlobalEmojiPreferences);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWakeOnWifiAllowed);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWallpaperFastRefresh);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kWallpaperGooglePhotosSharedAlbums);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWelcomeExperience);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kWelcomeExperienceTestUnsupportedDevices);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kWelcomeTour);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kWelcomeTourChromeVoxSupported);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kWelcomeTourCounterfactualArm);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kWelcomeTourForceUserEligibility);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kWelcomeTourHoldbackArm);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kWelcomeTourV3);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kWifiConnectMacAddressRandomization);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWifiConcurrency);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWifiSyncAllowDeletes);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWifiSyncAndroid);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWifiSyncApplyDeletes);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWindowSplitting);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWmMode);

// TODO(http://b/367799751): Remove when the issue gets fixed.
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kIgnoreM129Holdback);

// Keep alphabetized.

COMPONENT_EXPORT(ASH_CONSTANTS) bool AreCaptureModeDemoToolsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool AreDesksTemplatesEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool AreHelpAppWelcomeTipsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool ArePromiseIconsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool ArePromiseIconsForWebAppsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool AreSideAlignedToastsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool ForceOnDeviceAppControlsForAllRegions();
COMPONENT_EXPORT(ASH_CONSTANTS) bool AreImprovedScreenCaptureSettingsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool Is16DesksEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAdaptiveChargingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOnDeviceAppControlsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAdjustSplitViewForVKEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAllowAmbientEQEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAllowScrollSettingsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsEapDefaultCasWithoutSubjectVerificationAllowed();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAltClickAndSixPackCustomizationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAmbientEQDefaultOff();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAmbientModeDevUseProdEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAnnotatorModeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsApnRevampAndPoliciesEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAllowApnModificationPolicyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsApnRevampAndAllowApnModificationPolicyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsApnRevampEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsArcInputOverlayAlphaV2Enabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAutoNightLightEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAudioSelectionImprovementEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBackgroundBlurEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBabelOrcaAvailable();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBatterySaverAvailable();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBatterySaverAlwaysOn();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBirchVideoConferenceSuggestionsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBluetoothQualityReportEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBocaEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBocaUberEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBocaConsumerEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBocaExtensionConsumerEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBocaCustomPollingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBocaOnTaskMuteArcAudioEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBocaOnTaskPodEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsBocaOnTaskUnmuteBrowserTabsOnUnlockEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsBocaLockedModeCustomCountdownDurationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsBocaStudentHeartbeatEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsBocaStudentHeartbeatCustomIntervalEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBocaSpotlightEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBocaNetworkRestrictionEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsBocaClientTypeForSpeechRecognitionEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsBocaAdjustCaptionBubbleOnExpandEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsBocaSequentialSessionLoadEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBrightnessControlInSettingsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCaptureModeEducationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsCaptureModeEducationBypassLimitsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCaptureModeOnDeviceOcrEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsCheckPasswordsAgainstCryptohomeHelperEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsClipboardHistoryLongpressEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsClipboardHistoryUrlTitlesEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsContinuousOverviewScrollAnimationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCoralFeatureEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCopyClientKeysCertsToChapsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCrosPrivacyHubLocationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCrosSeparateGeoApiKeyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCrosSafetyServiceEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCrossDeviceFeatureSuiteAllowed();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCrosSwitcherEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsCryptauthAttestationSyncingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDeepLinkingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDemoModeAppLandscapeLockedEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDemoModeAppResetWindowContainerEnable();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDemoModeSignInEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDemoModeWallpaperUpdateEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDemoModeSignInFileCleanupEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDeskTemplateSyncEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDisplayPerformanceModeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsInputDeviceSettingsSplitEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPeripheralCustomizationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPeripheralsLoggingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDisplayAlignmentAssistanceEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDoNotDisturbShortcutEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDozeModePowerSchedulerEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDriveFsMirroringEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) int GetDriveFsBulkPinningQueueSize();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEapGtcWifiAuthenticationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEcheSWAEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEcheSWADebugModeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEcheSWAMeasureLatencyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEOLIncentiveEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsExperimentalRgbKeyboardPatternsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsExtendedUpdatesOptInFeatureEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsExternalKeyboardInDiagnosticsAppEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFamilyLinkOnSchoolDeviceEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastInkForSoftwareCursorEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairAdvertisingFormat2025Enabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairBleRotationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairDebugMetadataEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairHandshakeRefactorEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsFastPairHandshakeLongTermRefactorEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairKeyboardsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairSavedDevicesNicknamesEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairPwaCompanionEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairSoftwareScanningEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairSavedDevicesEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairSavedDevicesStrictOptInEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFederatedStringsServiceEnabled();

// TODO revisit structure of feature flags w.r.t. gating task scheduling.
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsFederatedStringsServiceScheduleTasksEnabled();

COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFileManagerFuseBoxDebugEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFilesConflictDialogEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFilesLocalImageSearchEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFingerprintAuthFactorEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFirmwareUpdateUIV2Enabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFlexAutoEnrollmentEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFloatingSsoAllowed();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFloatingWorkspaceEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFloatingWorkspaceV2Enabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool ShouldForceEnableServerSideSpeechRecognition();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsForestFeatureEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEcheLauncherEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEcheLauncherListViewEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsEcheLauncherIconsInMoreAppsButtonEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEcheNetworkConnectionStateEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsEcheShorterScanningDutyCycleEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool AreEphemeralNetworkPoliciesEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool CanEphemeralNetworkPoliciesBeEnabledByPolicy();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFlexFirmwareUpdateEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool ShouldIgnoreDeviceFlexArcEnabledPolicy();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFullscreenAfterUnlockAllowed();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFullscreenAlertBubbleEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBlockFwupdClientEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsGaiaRecordAccountCreationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsGameDashboardEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsGameDashboardGamepadSupportEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsGameDashboardGamePWAsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsGameDashboardGamesInTestEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool AreGameDashboardUtilitiesEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAppLaunchShortcutEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsGraduationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsGraduationUseEmbeddedTransferEndpointEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsFeatureManagementGrowthFrameworkEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsGrowthFrameworkEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsGrowthCampaignsNudgeParentToAppWindow();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsGrowthCampaignsCrOSEventsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsGrowthCampaignsDemoModeSignInEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsGrowthCampaignsExperimentTagTargetingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsGrowthCampaignsInConsumerSessionEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsGrowthCampaignsInDemoModeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsGrowthCampaignsShowNudgeInsideWindowBoundsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsGrowthCampaignsTriggerAtLoadComplete();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsGrowthCampaignsTriggerByAppOpenEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsGrowthCampaignsTriggerByBrowserEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsGrowthCampaignsTriggerByEventEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsGrowthCampaignsObserveTriggeringWidgetChangeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsGrowthCampaignsTriggerByRecordEventEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsGrowthInternalsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsGlanceablesTimeManagementClassroomStudentViewEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsGlanceablesTimeManagementTasksViewEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsGlanceablesTimeManagementTasksViewAssignedTasksEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool AreAnyGlanceablesTimeManagementViewsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool AreHealthdInternalsTabsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsHibernateEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsHideShelfControlsInTabletModeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsHoldingSpaceSuggestionsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsHomeButtonQuickAppAccessEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsHomeButtonWithTextEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsHostnameSettingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsInstantHotspotRebrandEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsInputNoiseCancellationUiEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsESimEmptyActivationCodeSupportEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsInternalServerSideSpeechRecognitionEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsInternalServerSideSpeechRecognitionEnabledByFinch();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsInternalServerSideSpeechRecognitionControlEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsIppClientInfoEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsIsolatedWebAppKioskEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsKerberosRememberPasswordByDefaultEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsKeyboardBacklightControlInSettingsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsKeyboardRewriterFixEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLanguagePacksInOobeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsLauncherContinueSectionWithRecentsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLauncherNudgeShortIntervalEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLauncherNudgeSessionResetEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLauncherSearchControlEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLinkCrossDeviceDogfoodFeedbackEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLinkCrossDeviceInternalsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLobsterEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLobsterEnabledForManagedUsers();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLobsterDisabledByInvalidIME();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLobsterI18nEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLobsterUseRewrittenQuery();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLobsterAlwaysShowDisclaimerForTesting();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsLockScreenHideSensitiveNotificationsSupported();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLockScreenNotificationsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsMacAddressRandomizationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool ShouldMigrateOwnerKeyToPrivateSlot();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsMinimumChromeVersionEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsMultiCalendarSupportEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsMultiZoneRgbKeyboardEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsNearbyPresenceEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsNotificationLimitEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsNotifierCollisionEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEnrollmentNudgingForTestingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsNotificationCenterControllerEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsNotificationExpansionAnimationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsNotificationExperimentalShortTimeoutsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsNotificationScrollBarEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsNotificationsInContextMenuEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsNssDbClientCertsRollbackEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOAuthIppEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOfflineItemsInNotificationsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool AreOngoingProcessesEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeAddUserDuringEnrollmentEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeChoobeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeCrosEventsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeLazyLoadingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobePerksDiscoveryEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeGaiaInfoScreenEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeJellyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeJellyModalEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBootAnimationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeAiIntroEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeSkipAssistantEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobePersonalizedOnboardingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobePreConsentMetricsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeSoftwareUpdateEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeQuickStartOnLoginScreenEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeRemoveShutdownButtonEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeTouchpadScrollEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeDisplaySizeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeSplitModifierKeyboardInfoEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeInputMethodsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOsSyncConsentRevampEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsParentAccessJellyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPcieBillboardNotificationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPciguardUiEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPerDeskShelfEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPeripheralNotificationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPhoneHubCameraRollEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsPhoneHubMonochromeNotificationIconsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsPhoneHubOnboardingNotifierRevampEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsPhoneHubPingOnBubbleOpenEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsPhoneHubShortQuickActionPodsTitlesEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPhoneHubEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPhoneHubCallNotificationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsModifierSplitEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsMouseImposterCheckEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSplitKeyboardRefactorEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPickerUpdateEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPinAutosubmitBackfillFeatureEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPrinterPreviewCrosAppEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProductivityLauncherImageSearchEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorManagedUserEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorAppDebugMode();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorCustomThumbnailEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsProjectorManagedUserIgnorePolicyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsProjectorShowShortPseudoTranscript();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorUpdateIndexableTextEnabled();
// TODO(b/288273641): Clean up the server speech recognition related flags.
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsProjectorServerSideRecognitionFallbackImplEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorMutingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorRedirectToPwaEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorUseUSMForS3Enabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorDynamicColorsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorGm3Enabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorUseDVSPlaybackEndpointEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsQuickDimEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsRenderArcNotificationsByChromeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsRemoveStalePolicyPinnedAppsFromShelfEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSameAppWindowCycleEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsResetAudioSelectionImprovementPrefEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsResetShortcutCustomizationsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsSamlNotificationOnPasswordChangeSuccessEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsScalableIphEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsScalableIphDebugEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsScalableIphTrackingOnlyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsScalableIphClientConfigEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsScalableShelfPodsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsScannerEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsScannerFeedbackToastEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSeaPenDemoModeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSeaPenQueryRewriteEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSeaPenEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSeaPenTextInputEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSeaPenTextInputTranslationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSeaPenUseExptTemplateEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSeparateNetworkIconsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSeparateWebAppShortcutBadgeIconEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsSettingsAppNotificationSettingsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsSettingsAppThemeChangeAnimationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsShelfLauncherNudgeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsShimlessRMAComplianceCheckEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSimLockPolicyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsShimlessRMAOsUpdateEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsShimlessRMA3pDiagnosticsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsShimlessRMA3pDiagnosticsDevModeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsShimlessRMA3pDiagnosticsAllowPermissionPolicyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsShimlessRMAHardwareValidationSkipEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsShimlessRMADynamicDeviceInfoInputsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsShowSharingUserInLauncherContinueSectionEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSnoopingProtectionEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsStoreOwnerKeyInPrivateSlotEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSunfishFeatureEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSunfishLensWebEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSunfishLensWebCopyTextEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSuspendStateMachineEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSystemNudgeMigrationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSystemTrayShadowEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsSysUiShouldHoldbackDriveIntegrationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsTetheringExperimentalFunctionalityEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsTilingWindowResizeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsTimeOfDayScreenSaverEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsTimeOfDayWallpaperEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsToggleCameraShortcutEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsTouchscreenMappingExperienceEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsTouchpadInDiagnosticsAppEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsTouchscreenInDiagnosticsAppEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsTrafficCountersEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsTrafficCountersForWiFiTestingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsTrilinearFilteringEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsUnmanagedDeviceDeviceTrustConnectorFeatureEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsUseAuthPanelInSessionEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAuthPanelUsingAuthHub();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAllowPasswordlessSetupEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAllowPasswordlessRecoveryEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLocalAuthenticationWithPinEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWebAuthNAuthDialogMergeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsUserEducationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLiveCaptionUserMicrophoneEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsVideoConferenceEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsStopAllScreenShareEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsVcBackgroundReplaceEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsVcResizeThumbnailEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsVcDlcUiEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsVcPortraitRelightEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsVcControlsUiFakeEffectsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsVcStudioLookEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsVcTrayMicIndicatorEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsVcTrayTitleHeaderEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsVcWebApiEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWallpaperFastRefreshEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsWallpaperGooglePhotosSharedAlbumsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWelcomeExperienceEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsWelcomeExperienceTestUnsupportedDevicesEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWelcomeTourChromeVoxSupported();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWelcomeTourCounterfactuallyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWelcomeTourEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWelcomeTourForceUserEligibilityEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWelcomeTourHoldbackEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWelcomeTourV3Enabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWifiConcurrencyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWifiSyncAndroidEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWindowSplittingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWmModeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool ShouldUseKcerClientCertStore();
COMPONENT_EXPORT(ASH_CONSTANTS) bool ShouldEnterOverviewFromWallpaper();
COMPONENT_EXPORT(ASH_CONSTANTS) bool ShouldOnlyShowNewShortcutApp();
COMPONENT_EXPORT(ASH_CONSTANTS) bool ShouldUseAndroidStagingSmds();
COMPONENT_EXPORT(ASH_CONSTANTS) bool ShouldUseStorkSmds();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsSearchCustomizableShortcutsInLauncherEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsFeatureAwareDeviceDemoModeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsUseTokenHandleStoreEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool UseMixedFileLauncherContinueSection();

// Keep alphabetized.

}  // namespace ash::features

#endif  // ASH_CONSTANTS_ASH_FEATURES_H_
