WebAPKs
--
A WebAPK is an APK which is installed by "Add to Home screen" in the Chrome app menu
provided that the website meets the
[requirements](https://web.dev/install-criteria/).

Sample site which meets WebAPK requirements
--
[https://pwa-directory.appspot.com/](https://pwa-directory.appspot.com/)

Code layout
--
- shell_apk/ - Code for APK which is generated by the Chrome server. Not compiled
into Chrome.  
- libs/client/ - Library which is compiled into Chrome. Useful if another browser
implemented WebAPKs.  
- libs/common/ - Library with code which is used by both WebAPK shell and Chrome. WebAPK shell
and Chrome might use different versions of the library.
- libs/runtime_library/ - Library which is stored in the Chrome APK's assets and which is extracted
from the Chrome APK by the WebAPK at runtime. This approach ensures
that the majority of the WebAPK logic is shared and can be updated as often as
CHrome, without the need for updating each individual WebAPK.

Installing WebAPK from Chrome Developer Build
--
To enable a developer build of Chrome to install WebAPKs run the following
commands:

`adb root`  
`adb shell am broadcast -a com.google.gservices.intent.action.GSERVICES_OVERRIDE -e finsky.webapk.do_webapk_install_package_check false`  
`adb shell am broadcast -a com.google.gservices.intent.action.GSERVICES_OVERRIDE -e finsky.webapk.do_webapk_install_signing_check false`

Building WebAPK shell locally
--
It is possible to build a test WebAPK and bypass the generation on the WebAPK
server.

On Android, build  
//chrome/android/webapk/shell_apk:webapk  
On ChromeOS, build  
//chrome/android/webapk/shell_apk:webapk_chromeos  

Both can be customized via [shell_apk/manifest/bound_manifest_config.json](https://source.chromium.org/chromium/chromium/src/+/main:chrome/android/webapk/shell_apk/manifest/bound_manifest_config.json)

To make a locally built WebAPK launch Chrome in 'WebAPK mode':
1) Set the --skip-webapk-verification Chrome command line flag
2) Ensure that the 'scope_url_\*' parameters in bound_manifest_config.json
   match a directory which contains the 'start_url' parameter. In 99% of
   test cases the other parameters can use arbitrary URL origins.

   Example:
   ```
   "intent_filters": {
     "scope_url_scheme": "https",
     "scope_url_host": "foo.com",
     "scope_url_path_type": "android:pathPrefix",
     "scope_url_path": "/bar/"
   },
   "start_url": "https://foo.com/bar/baz/start.html",
   ```
