// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * All string resources in resources.h.
 */
export enum I18nString {
  ADD_NEW_PAGE_BUTTON = 'add_new_page_button',
  ARIA_ASPECT_RATIO_16_TO_9 = 'aria_aspect_ratio_16_to_9',
  ARIA_ASPECT_RATIO_4_TO_3 = 'aria_aspect_ratio_4_to_3',
  ARIA_CAMERA_MODE_GROUP = 'aria_camera_mode_group',
  ARIA_GRID_3X3 = 'aria_grid_3x3',
  ARIA_GRID_4X4 = 'aria_grid_4x4',
  ARIA_GRID_OFF = 'aria_grid_off',
  ARIA_MIRROR_OFF = 'aria_mirror_off',
  ARIA_MIRROR_ON = 'aria_mirror_on',
  ARIA_MUTE_OFF = 'aria_mute_off',
  ARIA_MUTE_ON = 'aria_mute_on',
  ARIA_RECORD_TYPE_GROUP = 'aria_record_type_group',
  ARIA_SCAN_TYPE_GROUP = 'aria_scan_type_group',
  ARIA_TIMER_10S = 'aria_timer_10s',
  ARIA_TIMER_3S = 'aria_timer_3s',
  ARIA_TIMER_OFF = 'aria_timer_off',
  BACK_BUTTON = 'back_button',
  BARCODE_COPY_LINK_BUTTON = 'barcode_copy_link_button',
  BARCODE_COPY_TEXT_BUTTON = 'barcode_copy_text_button',
  BARCODE_LINK_DETECTED = 'barcode_link_detected',
  BARCODE_TEXT_DETECTED = 'barcode_text_detected',
  CANCEL_REVIEW_BUTTON = 'cancel_review_button',
  CONFIRM_REVIEW_BUTTON = 'confirm_review_button',
  DELETE_PAGE_BUTTON = 'delete_page_button',
  DELETE_PAGE_MESSAGE = 'delete_page_message',
  DIALOG_CANCEL_BUTTON = 'dialog_cancel_button',
  DIALOG_OK_BUTTON = 'dialog_ok_button',
  DOCUMENT_CORNER_MOVE_DESC = 'document_corner_move_desc',
  ERROR_MSG_CAMERA_PAUSED = 'error_msg_camera_paused',
  ERROR_MSG_EMPTY_RECORDING = 'error_msg_empty_recording',
  ERROR_MSG_FILE_SYSTEM_FAILED = 'error_msg_file_system_failed',
  ERROR_MSG_NO_CAMERA = 'error_msg_no_camera',
  ERROR_MSG_RECORD_START_FAILED = 'error_msg_record_start_failed',
  ERROR_MSG_SAVE_FILE_FAILED = 'error_msg_save_file_failed',
  ERROR_MSG_TAKE_PHOTO_FAILED = 'error_msg_take_photo_failed',
  ERROR_MSG_TAKE_PORTRAIT_BOKEH_PHOTO_FAILED =
      'error_msg_take_portrait_bokeh_photo_failed',
  ERROR_MSG_VIDEO_TOO_SHORT = 'error_msg_video_too_short',
  EXPERT_CUSTOM_VIDEO_PARAMETERS = 'expert_custom_video_parameters',
  EXPERT_ENABLE_EXPERT_MODE = 'expert_enable_expert_mode',
  EXPERT_ENABLE_FPS_PICKER_FOR_BUILTIN = 'expert_enable_fps_picker_for_builtin',
  EXPERT_ENABLE_FULL_SIZED_VIDEO_SNAPSHOT =
      'expert_enable_full_sized_video_snapshot',
  EXPERT_ENABLE_PTZ_FOR_BUILTIN = 'expert_enable_ptz_for_builtin',
  EXPERT_MODE_BUTTON = 'expert_mode_button',
  EXPERT_MULTISTREAM_RECORDING = 'expert_multistream_recording',
  EXPERT_PREVIEW_METADATA = 'expert_preview_metadata',
  EXPERT_PRINT_PERFORMANCE_LOGS = 'expert_print_performance_logs',
  EXPERT_SAVE_METADATA = 'expert_save_metadata',
  EXPERT_SHOW_ALL_RESOLUTIONS = 'expert_show_all_resolutions',
  FEEDBACK_BUTTON = 'feedback_button',
  FEEDBACK_DESCRIPTION_PLACEHOLDER = 'feedback_description_placeholder',
  FIX_PAGE_BUTTON = 'fix_page_button',
  GALLERY_BUTTON = 'gallery_button',
  HELP_BUTTON = 'help_button',
  LABEL_30FPS = 'label_30fps',
  LABEL_60FPS = 'label_60fps',
  LABEL_BACK_CAMERA = 'label_back_camera',
  LABEL_CROP_DONE = 'label_crop_done',
  LABEL_CURRENT_AND_MAXIMAL_RECORD_TIME =
      'label_current_and_maximal_record_time',
  LABEL_DOCUMENT_BOTTOM_LEFT_CORNER = 'label_document_bottom_left_corner',
  LABEL_DOCUMENT_BOTTOM_RIGHT_CORNER = 'label_document_bottom_right_corner',
  LABEL_DOCUMENT_TOP_LEFT_CORNER = 'label_document_top_left_corner',
  LABEL_DOCUMENT_TOP_RIGHT_CORNER = 'label_document_top_right_corner',
  LABEL_EXTERNAL_CAMERA = 'label_external_camera',
  LABEL_FRONT_CAMERA = 'label_front_camera',
  LABEL_FULL_RESOLUTION = 'label_full_resolution',
  LABEL_GRID_3X3 = 'label_grid_3x3',
  LABEL_GRID_4X4 = 'label_grid_4x4',
  LABEL_GRID_GOLDEN = 'label_grid_golden',
  LABEL_MEDIUM_RESOLUTION = 'label_medium_resolution',
  LABEL_NO_RESOLUTION_OPTION = 'label_no_resolution_option',
  LABEL_OFF = 'label_off',
  LABEL_ON = 'label_on',
  LABEL_OTHER_ASPECT_RATIO = 'label_other_aspect_ratio',
  LABEL_RECORD_GIF_VIDEO_OPTION = 'label_record_gif_video_option',
  LABEL_RECORD_NORMAL_VIDEO_OPTION = 'label_record_normal_video_option',
  LABEL_RECORD_TIME_LAPSE_VIDEO_OPTION = 'label_record_time_lapse_video_option',
  LABEL_RESOLUTION_MP = 'label_resolution_mp',
  LABEL_RETAKE = 'label_retake',
  LABEL_SAVE = 'label_save',
  LABEL_SAVE_PDF_DOCUMENT = 'label_save_pdf_document',
  LABEL_SAVE_PHOTO_DOCUMENT = 'label_save_photo_document',
  LABEL_SCAN_DOCUMENT_OPTION = 'label_scan_document_option',
  LABEL_SCAN_QRCODE_OPTION = 'label_scan_qrcode_option',
  LABEL_SHARE = 'label_share',
  LABEL_SWITCH_RECORD_VIDEO_BUTTON = 'label_switch_record_video_button',
  LABEL_SWITCH_SCAN_MODE_BUTTON = 'label_switch_scan_mode_button',
  LABEL_SWITCH_TAKE_PHOTO_BUTTON = 'label_switch_take_photo_button',
  LABEL_SWITCH_TAKE_PORTRAIT_BOKEH_PHOTO_BUTTON =
      'label_switch_take_portrait_bokeh_photo_button',
  LABEL_SWITCH_TAKE_SQUARE_PHOTO_BUTTON =
      'label_switch_take_square_photo_button',
  LABEL_TIMER_10S = 'label_timer_10s',
  LABEL_TIMER_3S = 'label_timer_3s',
  LABEL_VIDEO_RESOLUTION_360P = 'label_video_resolution_360p',
  LABEL_VIDEO_RESOLUTION_4K = 'label_video_resolution_4k',
  LABEL_VIDEO_RESOLUTION_FULL_HD = 'label_video_resolution_full_hd',
  LABEL_VIDEO_RESOLUTION_HD = 'label_video_resolution_hd',
  LABEL_VIDEO_RESOLUTION_QUAD_HD = 'label_video_resolution_quad_hd',
  LOW_STORAGE_DIALOG_AUTO_STOP_DESC = 'low_storage_dialog_auto_stop_desc',
  LOW_STORAGE_DIALOG_AUTO_STOP_TITLE = 'low_storage_dialog_auto_stop_title',
  LOW_STORAGE_DIALOG_CANNOT_START_DESC = 'low_storage_dialog_cannot_start_desc',
  LOW_STORAGE_DIALOG_CANNOT_START_TITLE =
      'low_storage_dialog_cannot_start_title',
  LOW_STORAGE_DIALOG_STORAGE_BUTTON = 'low_storage_dialog_storage_button',
  LOW_STORAGE_NUDGE_WARNING_MSG = 'low_storage_nudge_warning_msg',
  MOVING_IN_BOTTOM_DIRECTION = 'moving_in_bottom_direction',
  MOVING_IN_BOTTOM_LEFT_DIRECTION = 'moving_in_bottom_left_direction',
  MOVING_IN_BOTTOM_RIGHT_DIRECTION = 'moving_in_bottom_right_direction',
  MOVING_IN_LEFT_DIRECTION = 'moving_in_left_direction',
  MOVING_IN_RIGHT_DIRECTION = 'moving_in_right_direction',
  MOVING_IN_TOP_DIRECTION = 'moving_in_top_direction',
  MOVING_IN_TOP_LEFT_DIRECTION = 'moving_in_top_left_direction',
  MOVING_IN_TOP_RIGHT_DIRECTION = 'moving_in_top_right_direction',
  MSG_DOCUMENT_DETECTED = 'msg_document_detected',
  MSG_PROCESSING_IMAGE = 'msg_processing_image',
  // I18nString.NAME: Bypass the presubmit check for unused strings. Used here:
  // https://source.chromium.org/chromium/chromium/src/+/main:chrome/browser/ash/web_applications/camera_app/camera_system_web_app_info.cc
  // NAME = 'name',
  NEXT_PAGE_COUNT = 'next_page_count',
  NO_DOCUMENT_GUIDE_MSG = 'no_document_guide_msg',
  OPEN_GRID_PANEL_BUTTON = 'open_grid_panel_button',
  OPEN_MIRROR_PANEL_BUTTON = 'open_mirror_panel_button',
  OPEN_PTZ_PANEL_BUTTON = 'open_ptz_panel_button',
  OPEN_TIMER_PANEL_BUTTON = 'open_timer_panel_button',
  PAN_LEFT_BUTTON = 'pan_left_button',
  PAN_RIGHT_BUTTON = 'pan_right_button',
  PHOTO_ASPECT_RATIO_BUTTON = 'photo_aspect_ratio_button',
  PHOTO_RESOLUTION_BUTTON = 'photo_resolution_button',
  PHOTO_SETTINGS = 'photo_settings',
  PTZ_RESET_ALL_BUTTON = 'ptz_reset_all_button',
  RECORD_GIF_VIDEO_OPTION = 'record_gif_video_option',
  RECORD_NORMAL_VIDEO_OPTION = 'record_normal_video_option',
  RECORD_TIME_LAPSE_VIDEO_OPTION = 'record_time_lapse_video_option',
  RECORD_VIDEO_PAUSE_BUTTON = 'record_video_pause_button',
  RECORD_VIDEO_PAUSED_MSG = 'record_video_paused_msg',
  RECORD_VIDEO_RESUME_BUTTON = 'record_video_resume_button',
  RECORD_VIDEO_START_BUTTON = 'record_video_start_button',
  RECORD_VIDEO_STOP_BUTTON = 'record_video_stop_button',
  ROTATE_CLOCKWISE_BUTTON = 'rotate_clockwise_button',
  ROTATE_COUNTERCLOCKWISE_BUTTON = 'rotate_counterclockwise_button',
  SCAN_BUTTON = 'scan_button',
  SCAN_DOCUMENT_OPTION = 'scan_document_option',
  SCAN_QRCODE_OPTION = 'scan_qrcode_option',
  SCANNED_PAGE_LIST = 'scanned_page_list',
  SELECT_PAGE_BUTTON = 'select_page_button',
  SETTINGS_BUTTON = 'settings_button',
  SNACKBAR_LINK_COPIED = 'snackbar_link_copied',
  SNACKBAR_TEXT_COPIED = 'snackbar_text_copied',
  STATUS_MSG_CAMERA_PLUGGED = 'status_msg_camera_plugged',
  STATUS_MSG_CAMERA_SWITCHED = 'status_msg_camera_switched',
  STATUS_MSG_CAMERA_UNPLUGGED = 'status_msg_camera_unplugged',
  STATUS_MSG_RECORDING_STOPPED = 'status_msg_recording_stopped',
  SWITCH_CAMERA_BUTTON = 'switch_camera_button',
  SWITCH_RECORD_VIDEO_BUTTON = 'switch_record_video_button',
  SWITCH_SCAN_MODE_BUTTON = 'switch_scan_mode_button',
  SWITCH_TAKE_PHOTO_BUTTON = 'switch_take_photo_button',
  SWITCH_TAKE_PORTRAIT_BOKEH_PHOTO_BUTTON =
      'switch_take_portrait_bokeh_photo_button',
  TAKE_PHOTO_BUTTON = 'take_photo_button',
  TAKE_PHOTO_CANCEL_BUTTON = 'take_photo_cancel_button',
  TAKE_VIDEO_SNAPSHOT_BUTTON = 'take_video_snapshot_button',
  TILT_DOWN_BUTTON = 'tilt_down_button',
  TILT_UP_BUTTON = 'tilt_up_button',
  TOGGLE_MIC_BUTTON = 'toggle_mic_button',
  VIDEO_RESOLUTION_BUTTON = 'video_resolution_button',
  VIDEO_SETTINGS = 'video_settings',
  ZOOM_IN_BUTTON = 'zoom_in_button',
  ZOOM_OUT_BUTTON = 'zoom_out_button',
}
