// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include <jni.h>

#include "base/feature_list.h"
#include "chrome/android/chrome_jni_headers/PrivacyPreferencesManagerImpl_jni.h"
#include "chrome/browser/browser_process.h"
#include "chrome/browser/prefetch/prefetch_prefs.h"
#include "chrome/browser/profiles/profile_manager.h"
#include "chrome/common/pref_names.h"
#include "components/metrics/metrics_pref_names.h"
#include "components/policy/core/common/features.h"
#include "components/prefs/pref_service.h"

static jboolean JNI_PrivacyPreferencesManagerImpl_IsMetricsReportingEnabled(
    JNIEnv* env) {
  PrefService* local_state = g_browser_process->local_state();
  return local_state->GetBoolean(metrics::prefs::kMetricsReportingEnabled);
}

static void JNI_PrivacyPreferencesManagerImpl_SetMetricsReportingEnabled(
    JNIEnv* env,
    jboolean enabled) {
  PrefService* local_state = g_browser_process->local_state();
  local_state->SetBoolean(metrics::prefs::kMetricsReportingEnabled, enabled);
}

static jboolean
JNI_PrivacyPreferencesManagerImpl_IsMetricsReportingDisabledByPolicy(
    JNIEnv* env) {
  // Metrics reporting can only be disabled by policy if the policy is active.
  if (!base::FeatureList::IsEnabled(
          policy::features::kActivateMetricsReportingEnabledPolicyAndroid)) {
    return false;
  }

  const PrefService* local_state = g_browser_process->local_state();
  return local_state->IsManagedPreference(
             metrics::prefs::kMetricsReportingEnabled) &&
         !local_state->GetBoolean(metrics::prefs::kMetricsReportingEnabled);
}
