// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {Flag} from '../flag.js';
import {I18nString} from '../i18n_string.js';

/**
 * Returns the device board name.
 */
export function getBoard(): string {
  return window.loadTimeData.getString('board_name');
}

/**
 * Returns the device type.
 */
export function getDeviceType(): string {
  return window.loadTimeData.getString('device_type');
}

/**
 * Returns the I18N message generated by given |name| and |substitutions|.
 */
export function getI18nMessage(
    name: I18nString, ...substitutions: Array<number|string>): string {
  return window.loadTimeData.getStringF(name, ...substitutions);
}

/**
 * @return Returns 'ltr'/'rtl' for left-to-right/right-to-left system UI
 *     language.
 */
export function getTextDirection(): string {
  return window.loadTimeData.getString('textdirection');
}

/**
 * Returns the boolean value of the chrome flag.
 */
export function getChromeFlag(flag: Flag): boolean {
  return window.loadTimeData.getBoolean(flag);
}
