// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ash/services/ime/public/cpp/rulebased/def/th_tis.h"

namespace th_tis {

const char* kId = "th_tis";
bool kIs102 = false;
const char* kNormal[] = {
    "_",       // BackQuote
    "\u0e45",  // Digit1
    "/",       // Digit2
    "-",       // Digit3
    "\u0e20",  // Digit4
    "\u0e16",  // Digit5
    "\u0e38",  // Digit6
    "\u0e36",  // Digit7
    "\u0e04",  // Digit8
    "\u0e15",  // Digit9
    "\u0e08",  // Digit0
    "\u0e02",  // Minus
    "\u0e0a",  // Equal
    "\u0e46",  // KeyQ
    "\u0e44",  // KeyW
    "\u0e33",  // KeyE
    "\u0e1e",  // KeyR
    "\u0e30",  // KeyT
    "\u0e31",  // KeyY
    "\u0e35",  // KeyU
    "\u0e23",  // KeyI
    "\u0e19",  // KeyO
    "\u0e22",  // KeyP
    "\u0e1a",  // BracketLeft
    "\u0e25",  // BracketRight
    "\u0e03",  // Backslash
    "\u0e1f",  // KeyA
    "\u0e2b",  // KeyS
    "\u0e01",  // KeyD
    "\u0e14",  // KeyF
    "\u0e40",  // KeyG
    "\u0e49",  // KeyH
    "\u0e48",  // KeyJ
    "\u0e32",  // KeyK
    "\u0e2a",  // KeyL
    "\u0e27",  // Semicolon
    "\u0e07",  // Quote
    "\u0e1c",  // KeyZ
    "\u0e1b",  // KeyX
    "\u0e41",  // KeyC
    "\u0e2d",  // KeyV
    "\u0e34",  // KeyB
    "\u0e37",  // KeyN
    "\u0e17",  // KeyM
    "\u0e21",  // Comma
    "\u0e43",  // Period
    "\u0e1d",  // Slash
    "\u0020",  // Space
};
const char* kShift[] = {
    "%",       // BackQuote
    "+",       // Digit1
    "\u0e51",  // Digit2
    "\u0e52",  // Digit3
    "\u0e53",  // Digit4
    "\u0e54",  // Digit5
    "\u0e39",  // Digit6
    "\u0e3f",  // Digit7
    "\u0e55",  // Digit8
    "\u0e56",  // Digit9
    "\u0e57",  // Digit0
    "\u0e58",  // Minus
    "\u0e59",  // Equal
    "\u0e50",  // KeyQ
    "\"",      // KeyW
    "\u0e0e",  // KeyE
    "\u0e11",  // KeyR
    "\u0e18",  // KeyT
    "\u0e4d",  // KeyY
    "\u0e4a",  // KeyU
    "\u0e13",  // KeyI
    "\u0e2f",  // KeyO
    "\u0e0d",  // KeyP
    "\u0e10",  // BracketLeft
    ",",       // BracketRight
    "\u0e05",  // Backslash
    "\u0e24",  // KeyA
    "\u0e06",  // KeyS
    "\u0e0f",  // KeyD
    "\u0e42",  // KeyF
    "\u0e0c",  // KeyG
    "\u0e47",  // KeyH
    "\u0e4b",  // KeyJ
    "\u0e29",  // KeyK
    "\u0e28",  // KeyL
    "\u0e0b",  // Semicolon
    ".",       // Quote
    "(",       // KeyZ
    ")",       // KeyX
    "\u0e09",  // KeyC
    "\u0e2e",  // KeyV
    "\u0e3a",  // KeyB
    "\u0e4c",  // KeyN
    "?",       // KeyM
    "\u0e12",  // Comma
    "\u0e2c",  // Period
    "\u0e26",  // Slash
    "\u0020",  // Space
};
const char* kAltGr[] = {
    "_",       // BackQuote
    "\u0e45",  // Digit1
    "/",       // Digit2
    "-",       // Digit3
    "\u0e20",  // Digit4
    "\u0e16",  // Digit5
    "\u0e38",  // Digit6
    "\u0e36",  // Digit7
    "\u0e04",  // Digit8
    "\u0e15",  // Digit9
    "\u0e08",  // Digit0
    "\u0e02",  // Minus
    "\u0e0a",  // Equal
    "\u0e46",  // KeyQ
    "\u0e44",  // KeyW
    "\u0e33",  // KeyE
    "\u0e1e",  // KeyR
    "\u0e30",  // KeyT
    "\u0e31",  // KeyY
    "\u0e35",  // KeyU
    "\u0e23",  // KeyI
    "\u0e19",  // KeyO
    "\u0e22",  // KeyP
    "\u0e1a",  // BracketLeft
    "\u0e25",  // BracketRight
    "\u0e03",  // Backslash
    "\u0e1f",  // KeyA
    "\u0e2b",  // KeyS
    "\u0e01",  // KeyD
    "\u0e14",  // KeyF
    "\u0e40",  // KeyG
    "\u0e49",  // KeyH
    "\u0e48",  // KeyJ
    "\u0e32",  // KeyK
    "\u0e2a",  // KeyL
    "\u0e27",  // Semicolon
    "\u0e07",  // Quote
    "\u0e1c",  // KeyZ
    "\u0e1b",  // KeyX
    "\u0e41",  // KeyC
    "\u0e2d",  // KeyV
    "\u0e34",  // KeyB
    "\u0e37",  // KeyN
    "\u0e17",  // KeyM
    "\u0e21",  // Comma
    "\u0e43",  // Period
    "\u0e1d",  // Slash
    "\u0020",  // Space
};
const char* kCapslock[] = {
    "%",       // BackQuote
    "+",       // Digit1
    "\u0e51",  // Digit2
    "\u0e52",  // Digit3
    "\u0e53",  // Digit4
    "\u0e54",  // Digit5
    "\u0e39",  // Digit6
    "\u0e3f",  // Digit7
    "\u0e55",  // Digit8
    "\u0e56",  // Digit9
    "\u0e57",  // Digit0
    "\u0e58",  // Minus
    "\u0e59",  // Equal
    "\u0e50",  // KeyQ
    "\"",      // KeyW
    "\u0e0e",  // KeyE
    "\u0e11",  // KeyR
    "\u0e18",  // KeyT
    "\u0e4d",  // KeyY
    "\u0e4a",  // KeyU
    "\u0e13",  // KeyI
    "\u0e2f",  // KeyO
    "\u0e0d",  // KeyP
    "\u0e10",  // BracketLeft
    ",",       // BracketRight
    "\u0e05",  // Backslash
    "\u0e24",  // KeyA
    "\u0e06",  // KeyS
    "\u0e0f",  // KeyD
    "\u0e42",  // KeyF
    "\u0e0c",  // KeyG
    "\u0e47",  // KeyH
    "\u0e4b",  // KeyJ
    "\u0e29",  // KeyK
    "\u0e28",  // KeyL
    "\u0e0b",  // Semicolon
    ".",       // Quote
    "(",       // KeyZ
    ")",       // KeyX
    "\u0e09",  // KeyC
    "\u0e2e",  // KeyV
    "\u0e3a",  // KeyB
    "\u0e4c",  // KeyN
    "?",       // KeyM
    "\u0e12",  // Comma
    "\u0e2c",  // Period
    "\u0e26",  // Slash
    "\u0020",  // Space
};
const char* kShiftAltGr[] = {
    "%",       // BackQuote
    "+",       // Digit1
    "\u0e51",  // Digit2
    "\u0e52",  // Digit3
    "\u0e53",  // Digit4
    "\u0e54",  // Digit5
    "\u0e39",  // Digit6
    "\u0e3f",  // Digit7
    "\u0e55",  // Digit8
    "\u0e56",  // Digit9
    "\u0e57",  // Digit0
    "\u0e58",  // Minus
    "\u0e59",  // Equal
    "\u0e50",  // KeyQ
    "\"",      // KeyW
    "\u0e0e",  // KeyE
    "\u0e11",  // KeyR
    "\u0e18",  // KeyT
    "\u0e4d",  // KeyY
    "\u0e4a",  // KeyU
    "\u0e13",  // KeyI
    "\u0e2f",  // KeyO
    "\u0e0d",  // KeyP
    "\u0e10",  // BracketLeft
    ",",       // BracketRight
    "\u0e05",  // Backslash
    "\u0e24",  // KeyA
    "\u0e06",  // KeyS
    "\u0e0f",  // KeyD
    "\u0e42",  // KeyF
    "\u0e0c",  // KeyG
    "\u0e47",  // KeyH
    "\u0e4b",  // KeyJ
    "\u0e29",  // KeyK
    "\u0e28",  // KeyL
    "\u0e0b",  // Semicolon
    ".",       // Quote
    "(",       // KeyZ
    ")",       // KeyX
    "\u0e09",  // KeyC
    "\u0e2e",  // KeyV
    "\u0e3a",  // KeyB
    "\u0e4c",  // KeyN
    "?",       // KeyM
    "\u0e12",  // Comma
    "\u0e2c",  // Period
    "\u0e26",  // Slash
    "\u0020",  // Space
};
const char* kAltgrCapslock[] = {
    "%",       // BackQuote
    "+",       // Digit1
    "\u0e51",  // Digit2
    "\u0e52",  // Digit3
    "\u0e53",  // Digit4
    "\u0e54",  // Digit5
    "\u0e39",  // Digit6
    "\u0e3f",  // Digit7
    "\u0e55",  // Digit8
    "\u0e56",  // Digit9
    "\u0e57",  // Digit0
    "\u0e58",  // Minus
    "\u0e59",  // Equal
    "\u0e50",  // KeyQ
    "\"",      // KeyW
    "\u0e0e",  // KeyE
    "\u0e11",  // KeyR
    "\u0e18",  // KeyT
    "\u0e4d",  // KeyY
    "\u0e4a",  // KeyU
    "\u0e13",  // KeyI
    "\u0e2f",  // KeyO
    "\u0e0d",  // KeyP
    "\u0e10",  // BracketLeft
    ",",       // BracketRight
    "\u0e05",  // Backslash
    "\u0e24",  // KeyA
    "\u0e06",  // KeyS
    "\u0e0f",  // KeyD
    "\u0e42",  // KeyF
    "\u0e0c",  // KeyG
    "\u0e47",  // KeyH
    "\u0e4b",  // KeyJ
    "\u0e29",  // KeyK
    "\u0e28",  // KeyL
    "\u0e0b",  // Semicolon
    ".",       // Quote
    "(",       // KeyZ
    ")",       // KeyX
    "\u0e09",  // KeyC
    "\u0e2e",  // KeyV
    "\u0e3a",  // KeyB
    "\u0e4c",  // KeyN
    "?",       // KeyM
    "\u0e12",  // Comma
    "\u0e2c",  // Period
    "\u0e26",  // Slash
    "\u0020",  // Space
};
const char* kShiftCapslock[] = {
    "_",       // BackQuote
    "\u0e45",  // Digit1
    "/",       // Digit2
    "-",       // Digit3
    "\u0e20",  // Digit4
    "\u0e16",  // Digit5
    "\u0e38",  // Digit6
    "\u0e36",  // Digit7
    "\u0e04",  // Digit8
    "\u0e15",  // Digit9
    "\u0e08",  // Digit0
    "\u0e02",  // Minus
    "\u0e0a",  // Equal
    "\u0e46",  // KeyQ
    "\u0e44",  // KeyW
    "\u0e33",  // KeyE
    "\u0e1e",  // KeyR
    "\u0e30",  // KeyT
    "\u0e31",  // KeyY
    "\u0e35",  // KeyU
    "\u0e23",  // KeyI
    "\u0e19",  // KeyO
    "\u0e22",  // KeyP
    "\u0e1a",  // BracketLeft
    "\u0e25",  // BracketRight
    "\u0e03",  // Backslash
    "\u0e1f",  // KeyA
    "\u0e2b",  // KeyS
    "\u0e01",  // KeyD
    "\u0e14",  // KeyF
    "\u0e40",  // KeyG
    "\u0e49",  // KeyH
    "\u0e48",  // KeyJ
    "\u0e32",  // KeyK
    "\u0e2a",  // KeyL
    "\u0e27",  // Semicolon
    "\u0e07",  // Quote
    "\u0e1c",  // KeyZ
    "\u0e1b",  // KeyX
    "\u0e41",  // KeyC
    "\u0e2d",  // KeyV
    "\u0e34",  // KeyB
    "\u0e37",  // KeyN
    "\u0e17",  // KeyM
    "\u0e21",  // Comma
    "\u0e43",  // Period
    "\u0e1d",  // Slash
    "\u0020",  // Space
};
const char* kShiftAltGrCapslock[] = {
    "_",       // BackQuote
    "\u0e45",  // Digit1
    "/",       // Digit2
    "-",       // Digit3
    "\u0e20",  // Digit4
    "\u0e16",  // Digit5
    "\u0e38",  // Digit6
    "\u0e36",  // Digit7
    "\u0e04",  // Digit8
    "\u0e15",  // Digit9
    "\u0e08",  // Digit0
    "\u0e02",  // Minus
    "\u0e0a",  // Equal
    "\u0e46",  // KeyQ
    "\u0e44",  // KeyW
    "\u0e33",  // KeyE
    "\u0e1e",  // KeyR
    "\u0e30",  // KeyT
    "\u0e31",  // KeyY
    "\u0e35",  // KeyU
    "\u0e23",  // KeyI
    "\u0e19",  // KeyO
    "\u0e22",  // KeyP
    "\u0e1a",  // BracketLeft
    "\u0e25",  // BracketRight
    "\u0e03",  // Backslash
    "\u0e1f",  // KeyA
    "\u0e2b",  // KeyS
    "\u0e01",  // KeyD
    "\u0e14",  // KeyF
    "\u0e40",  // KeyG
    "\u0e49",  // KeyH
    "\u0e48",  // KeyJ
    "\u0e32",  // KeyK
    "\u0e2a",  // KeyL
    "\u0e27",  // Semicolon
    "\u0e07",  // Quote
    "\u0e1c",  // KeyZ
    "\u0e1b",  // KeyX
    "\u0e41",  // KeyC
    "\u0e2d",  // KeyV
    "\u0e34",  // KeyB
    "\u0e37",  // KeyN
    "\u0e17",  // KeyM
    "\u0e21",  // Comma
    "\u0e43",  // Period
    "\u0e1d",  // Slash
    "\u0020",  // Space
};
const char** kKeyMap[8] = {
    kNormal,   kShift,         kAltGr,         kShiftAltGr,
    kCapslock, kShiftCapslock, kAltgrCapslock, kShiftAltGrCapslock};

}  // namespace th_tis
