// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ash/services/ime/public/cpp/rulebased/def/th_pattajoti.h"

namespace th_pattajoti {

const char* kId = "th_pattajoti";
bool kIs102 = false;
const char* kNormal[] = {
    "_",       // BackQuote
    "=",       // Digit1
    "\u0e52",  // Digit2
    "\u0e53",  // Digit3
    "\u0e54",  // Digit4
    "\u0e55",  // Digit5
    "\u0e39",  // Digit6
    "\u0e57",  // Digit7
    "\u0e58",  // Digit8
    "\u0e59",  // Digit9
    "\u0e50",  // Digit0
    "\u0e51",  // Minus
    "\u0e56",  // Equal
    "\u0e47",  // KeyQ
    "\u0e15",  // KeyW
    "\u0e22",  // KeyE
    "\u0e2d",  // KeyR
    "\u0e23",  // KeyT
    "\u0e48",  // KeyY
    "\u0e14",  // KeyU
    "\u0e21",  // KeyI
    "\u0e27",  // KeyO
    "\u0e41",  // KeyP
    "\u0e43",  // BracketLeft
    "\u0e0c",  // BracketRight
    "\u0e3a",  // Backslash
    "\u0e49",  // KeyA
    "\u0e17",  // KeyS
    "\u0e07",  // KeyD
    "\u0e01",  // KeyF
    "\u0e31",  // KeyG
    "\u0e35",  // KeyH
    "\u0e32",  // KeyJ
    "\u0e19",  // KeyK
    "\u0e40",  // KeyL
    "\u0e44",  // Semicolon
    "\u0e02",  // Quote
    "\u0e1a",  // KeyZ
    "\u0e1b",  // KeyX
    "\u0e25",  // KeyC
    "\u0e2b",  // KeyV
    "\u0e34",  // KeyB
    "\u0e04",  // KeyN
    "\u0e2a",  // KeyM
    "\u0e30",  // Comma
    "\u0e08",  // Period
    "\u0e1e",  // Slash
    "\u0020",  // Space
};
const char* kShift[] = {
    "\u0e3f",        // BackQuote
    "+",             // Digit1
    "\"",            // Digit2
    "/",             // Digit3
    ",",             // Digit4
    "?",             // Digit5
    "\u0e38",        // Digit6
    "\u0e45",        // Digit7
    ".",             // Digit8
    "(",             // Digit9
    ")",             // Digit0
    "-",             // Minus
    "%",             // Equal
    "\u0e4a",        // KeyQ
    "\u0e24",        // KeyW
    "\u0e46",        // KeyE
    "\u0e0d",        // KeyR
    "\u0e29",        // KeyT
    "\u0e36",        // KeyY
    "\u0e1d",        // KeyU
    "\u0e0b",        // KeyI
    "\u0e16",        // KeyO
    "\u0e12",        // KeyP
    "\u0e2f",        // BracketLeft
    "\u0e26",        // BracketRight
    "\u0e4d",        // Backslash
    "\u0e4b",        // KeyA
    "\u0e18",        // KeyS
    "\u0e33",        // KeyD
    "\u0e13",        // KeyF
    "\u0e4c",        // KeyG
    "\u0e37",        // KeyH
    "\u0e1c",        // KeyJ
    "\u0e0a",        // KeyK
    "\u0e42",        // KeyL
    "\u0e06",        // Semicolon
    "\u0e11",        // Quote
    "\u0e0e",        // KeyZ
    "\u0e0f",        // KeyX
    "\u0e10",        // KeyC
    "\u0e20",        // KeyV
    "\u0e31\u0e49",  // KeyB
    "\u0e28",        // KeyN
    "\u0e2e",        // KeyM
    "\u0e1f",        // Comma
    "\u0e09",        // Period
    "\u0e2c",        // Slash
    "\u0020",        // Space
};
const char* kAltGr[] = {
    "_",       // BackQuote
    "=",       // Digit1
    "\u0e52",  // Digit2
    "\u0e53",  // Digit3
    "\u0e54",  // Digit4
    "\u0e55",  // Digit5
    "\u0e39",  // Digit6
    "\u0e57",  // Digit7
    "\u0e58",  // Digit8
    "\u0e59",  // Digit9
    "\u0e50",  // Digit0
    "\u0e51",  // Minus
    "\u0e56",  // Equal
    "\u0e47",  // KeyQ
    "\u0e15",  // KeyW
    "\u0e22",  // KeyE
    "\u0e2d",  // KeyR
    "\u0e23",  // KeyT
    "\u0e48",  // KeyY
    "\u0e14",  // KeyU
    "\u0e21",  // KeyI
    "\u0e27",  // KeyO
    "\u0e41",  // KeyP
    "\u0e43",  // BracketLeft
    "\u0e0c",  // BracketRight
    "\u0e3a",  // Backslash
    "\u0e49",  // KeyA
    "\u0e17",  // KeyS
    "\u0e07",  // KeyD
    "\u0e01",  // KeyF
    "\u0e31",  // KeyG
    "\u0e35",  // KeyH
    "\u0e32",  // KeyJ
    "\u0e19",  // KeyK
    "\u0e40",  // KeyL
    "\u0e44",  // Semicolon
    "\u0e02",  // Quote
    "\u0e1a",  // KeyZ
    "\u0e1b",  // KeyX
    "\u0e25",  // KeyC
    "\u0e2b",  // KeyV
    "\u0e34",  // KeyB
    "\u0e04",  // KeyN
    "\u0e2a",  // KeyM
    "\u0e30",  // Comma
    "\u0e08",  // Period
    "\u0e1e",  // Slash
    "\u0020",  // Space
};
const char* kCapslock[] = {
    "\u0e3f",        // BackQuote
    "+",             // Digit1
    "\"",            // Digit2
    "/",             // Digit3
    ",",             // Digit4
    "?",             // Digit5
    "\u0e38",        // Digit6
    "\u0e45",        // Digit7
    ".",             // Digit8
    "(",             // Digit9
    ")",             // Digit0
    "-",             // Minus
    "%",             // Equal
    "\u0e4a",        // KeyQ
    "\u0e24",        // KeyW
    "\u0e46",        // KeyE
    "\u0e0d",        // KeyR
    "\u0e29",        // KeyT
    "\u0e36",        // KeyY
    "\u0e1d",        // KeyU
    "\u0e0b",        // KeyI
    "\u0e16",        // KeyO
    "\u0e12",        // KeyP
    "\u0e2f",        // BracketLeft
    "\u0e26",        // BracketRight
    "\u0e4d",        // Backslash
    "\u0e4b",        // KeyA
    "\u0e18",        // KeyS
    "\u0e33",        // KeyD
    "\u0e13",        // KeyF
    "\u0e4c",        // KeyG
    "\u0e37",        // KeyH
    "\u0e1c",        // KeyJ
    "\u0e0a",        // KeyK
    "\u0e42",        // KeyL
    "\u0e06",        // Semicolon
    "\u0e11",        // Quote
    "\u0e0e",        // KeyZ
    "\u0e0f",        // KeyX
    "\u0e10",        // KeyC
    "\u0e20",        // KeyV
    "\u0e31\u0e49",  // KeyB
    "\u0e28",        // KeyN
    "\u0e2e",        // KeyM
    "\u0e1f",        // Comma
    "\u0e09",        // Period
    "\u0e2c",        // Slash
    "\u0020",        // Space
};
const char* kShiftAltGr[] = {
    "\u0e3f",        // BackQuote
    "+",             // Digit1
    "\"",            // Digit2
    "/",             // Digit3
    ",",             // Digit4
    "?",             // Digit5
    "\u0e38",        // Digit6
    "\u0e45",        // Digit7
    ".",             // Digit8
    "(",             // Digit9
    ")",             // Digit0
    "-",             // Minus
    "%",             // Equal
    "\u0e4a",        // KeyQ
    "\u0e24",        // KeyW
    "\u0e46",        // KeyE
    "\u0e0d",        // KeyR
    "\u0e29",        // KeyT
    "\u0e36",        // KeyY
    "\u0e1d",        // KeyU
    "\u0e0b",        // KeyI
    "\u0e16",        // KeyO
    "\u0e12",        // KeyP
    "\u0e2f",        // BracketLeft
    "\u0e26",        // BracketRight
    "\u0e4d",        // Backslash
    "\u0e4b",        // KeyA
    "\u0e18",        // KeyS
    "\u0e33",        // KeyD
    "\u0e13",        // KeyF
    "\u0e4c",        // KeyG
    "\u0e37",        // KeyH
    "\u0e1c",        // KeyJ
    "\u0e0a",        // KeyK
    "\u0e42",        // KeyL
    "\u0e06",        // Semicolon
    "\u0e11",        // Quote
    "\u0e0e",        // KeyZ
    "\u0e0f",        // KeyX
    "\u0e10",        // KeyC
    "\u0e20",        // KeyV
    "\u0e31\u0e49",  // KeyB
    "\u0e28",        // KeyN
    "\u0e2e",        // KeyM
    "\u0e1f",        // Comma
    "\u0e09",        // Period
    "\u0e2c",        // Slash
    "\u0020",        // Space
};
const char* kAltgrCapslock[] = {
    "\u0e3f",        // BackQuote
    "+",             // Digit1
    "\"",            // Digit2
    "/",             // Digit3
    ",",             // Digit4
    "?",             // Digit5
    "\u0e38",        // Digit6
    "\u0e45",        // Digit7
    ".",             // Digit8
    "(",             // Digit9
    ")",             // Digit0
    "-",             // Minus
    "%",             // Equal
    "\u0e4a",        // KeyQ
    "\u0e24",        // KeyW
    "\u0e46",        // KeyE
    "\u0e0d",        // KeyR
    "\u0e29",        // KeyT
    "\u0e36",        // KeyY
    "\u0e1d",        // KeyU
    "\u0e0b",        // KeyI
    "\u0e16",        // KeyO
    "\u0e12",        // KeyP
    "\u0e2f",        // BracketLeft
    "\u0e26",        // BracketRight
    "\u0e4d",        // Backslash
    "\u0e4b",        // KeyA
    "\u0e18",        // KeyS
    "\u0e33",        // KeyD
    "\u0e13",        // KeyF
    "\u0e4c",        // KeyG
    "\u0e37",        // KeyH
    "\u0e1c",        // KeyJ
    "\u0e0a",        // KeyK
    "\u0e42",        // KeyL
    "\u0e06",        // Semicolon
    "\u0e11",        // Quote
    "\u0e0e",        // KeyZ
    "\u0e0f",        // KeyX
    "\u0e10",        // KeyC
    "\u0e20",        // KeyV
    "\u0e31\u0e49",  // KeyB
    "\u0e28",        // KeyN
    "\u0e2e",        // KeyM
    "\u0e1f",        // Comma
    "\u0e09",        // Period
    "\u0e2c",        // Slash
    "\u0020",        // Space
};
const char* kShiftCapslock[] = {
    "_",       // BackQuote
    "=",       // Digit1
    "\u0e52",  // Digit2
    "\u0e53",  // Digit3
    "\u0e54",  // Digit4
    "\u0e55",  // Digit5
    "\u0e39",  // Digit6
    "\u0e57",  // Digit7
    "\u0e58",  // Digit8
    "\u0e59",  // Digit9
    "\u0e50",  // Digit0
    "\u0e51",  // Minus
    "\u0e56",  // Equal
    "\u0e47",  // KeyQ
    "\u0e15",  // KeyW
    "\u0e22",  // KeyE
    "\u0e2d",  // KeyR
    "\u0e23",  // KeyT
    "\u0e48",  // KeyY
    "\u0e14",  // KeyU
    "\u0e21",  // KeyI
    "\u0e27",  // KeyO
    "\u0e41",  // KeyP
    "\u0e43",  // BracketLeft
    "\u0e0c",  // BracketRight
    "\u0e3a",  // Backslash
    "\u0e49",  // KeyA
    "\u0e17",  // KeyS
    "\u0e07",  // KeyD
    "\u0e01",  // KeyF
    "\u0e31",  // KeyG
    "\u0e35",  // KeyH
    "\u0e32",  // KeyJ
    "\u0e19",  // KeyK
    "\u0e40",  // KeyL
    "\u0e44",  // Semicolon
    "\u0e02",  // Quote
    "\u0e1a",  // KeyZ
    "\u0e1b",  // KeyX
    "\u0e25",  // KeyC
    "\u0e2b",  // KeyV
    "\u0e34",  // KeyB
    "\u0e04",  // KeyN
    "\u0e2a",  // KeyM
    "\u0e30",  // Comma
    "\u0e08",  // Period
    "\u0e1e",  // Slash
    "\u0020",  // Space
};
const char* kShiftAltGrCapslock[] = {
    "_",       // BackQuote
    "=",       // Digit1
    "\u0e52",  // Digit2
    "\u0e53",  // Digit3
    "\u0e54",  // Digit4
    "\u0e55",  // Digit5
    "\u0e39",  // Digit6
    "\u0e57",  // Digit7
    "\u0e58",  // Digit8
    "\u0e59",  // Digit9
    "\u0e50",  // Digit0
    "\u0e51",  // Minus
    "\u0e56",  // Equal
    "\u0e47",  // KeyQ
    "\u0e15",  // KeyW
    "\u0e22",  // KeyE
    "\u0e2d",  // KeyR
    "\u0e23",  // KeyT
    "\u0e48",  // KeyY
    "\u0e14",  // KeyU
    "\u0e21",  // KeyI
    "\u0e27",  // KeyO
    "\u0e41",  // KeyP
    "\u0e43",  // BracketLeft
    "\u0e0c",  // BracketRight
    "\u0e3a",  // Backslash
    "\u0e49",  // KeyA
    "\u0e17",  // KeyS
    "\u0e07",  // KeyD
    "\u0e01",  // KeyF
    "\u0e31",  // KeyG
    "\u0e35",  // KeyH
    "\u0e32",  // KeyJ
    "\u0e19",  // KeyK
    "\u0e40",  // KeyL
    "\u0e44",  // Semicolon
    "\u0e02",  // Quote
    "\u0e1a",  // KeyZ
    "\u0e1b",  // KeyX
    "\u0e25",  // KeyC
    "\u0e2b",  // KeyV
    "\u0e34",  // KeyB
    "\u0e04",  // KeyN
    "\u0e2a",  // KeyM
    "\u0e30",  // Comma
    "\u0e08",  // Period
    "\u0e1e",  // Slash
    "\u0020",  // Space
};
const char** kKeyMap[8] = {
    kNormal,   kShift,         kAltGr,         kShiftAltGr,
    kCapslock, kShiftCapslock, kAltgrCapslock, kShiftAltGrCapslock};

}  // namespace th_pattajoti
