// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ash/services/ime/public/cpp/rulebased/def/ta_inscript.h"

namespace ta_inscript {

const char* kId = "ta_inscript";
bool kIs102 = false;
const char* kNormal[] = {
    "\u0bca",  // BackQuote
    "1",       // Digit1
    "2",       // Digit2
    "3",       // Digit3
    "4",       // Digit4
    "5",       // Digit5
    "6",       // Digit6
    "7",       // Digit7
    "8",       // Digit8
    "9",       // Digit9
    "0",       // Digit0
    "-",       // Minus
    "\u0bf2",  // Equal
    "\u0bcc",  // KeyQ
    "\u0bc8",  // KeyW
    "\u0bbe",  // KeyE
    "\u0bc0",  // KeyR
    "\u0bc2",  // KeyT
    "\u0baa",  // KeyY
    "\u0bb9",  // KeyU
    "\u0b95",  // KeyI
    "\u0ba4",  // KeyO
    "\u0b9c",  // KeyP
    "\u0b9f",  // BracketLeft
    "\u0b9e",  // BracketRight
    "\u0b9f",  // Backslash
    "\u0bcb",  // KeyA
    "\u0bc7",  // KeyS
    "\u0bcd",  // KeyD
    "\u0bbf",  // KeyF
    "\u0bc1",  // KeyG
    "\u0baa",  // KeyH
    "\u0bb0",  // KeyJ
    "\u0b95",  // KeyK
    "\u0ba4",  // KeyL
    "\u0b9a",  // Semicolon
    "\u0b9f",  // Quote
    "\u0bc6",  // KeyZ
    "\u0b82",  // KeyX
    "\u0bae",  // KeyC
    "\u0ba8",  // KeyV
    "\u0bb5",  // KeyB
    "\u0bb2",  // KeyN
    "\u0bb8",  // KeyM
    ",",       // Comma
    ".",       // Period
    "\u0baf",  // Slash
    "\u0020",  // Space
};
const char* kShift[] = {
    "\u0b92",                    // BackQuote
    "\u0b95",                    // Digit1
    "\u0be8",                    // Digit2
    "\u0bcd\u0bb0",              // Digit3
    "\u20b9",                    // Digit4
    "\u0b9c\u0bcd\u0b9e",        // Digit5
    "\u0ba4\u0bcd\u0bb0",        // Digit6
    "\u0b95\u0bcd\u0bb7",        // Digit7
    "\u0bb6\u0bcd\u0bb0",        // Digit8
    "(",                         // Digit9
    ")",                         // Digit0
    "\u0b83",                    // Minus
    "",                          // Equal
    "\u0b94",                    // KeyQ
    "\u0b90",                    // KeyW
    "\u0b86",                    // KeyE
    "\u0b88",                    // KeyR
    "\u0b8a",                    // KeyT
    "",                          // KeyY
    "\u0b99",                    // KeyU
    "",                          // KeyI
    "",                          // KeyO
    "\u0b9a",                    // KeyP
    "",                          // BracketLeft
    "",                          // BracketRight
    "",                          // Backslash
    "\u0b93",                    // KeyA
    "\u0b8f",                    // KeyS
    "\u0b85",                    // KeyD
    "\u0b87",                    // KeyF
    "\u0b89",                    // KeyG
    "",                          // KeyH
    "\u0bb1",                    // KeyJ
    "",                          // KeyK
    "",                          // KeyL
    "",                          // Semicolon
    "",                          // Quote
    "\u0b8e",                    // KeyZ
    "",                          // KeyX
    "\u0ba3",                    // KeyC
    "\u0ba9",                    // KeyV
    "\u0bb4",                    // KeyB
    "\u0bb3",                    // KeyN
    "\u0bb6",                    // KeyM
    "\u0bb7",                    // Comma
    "\u0bb8\u0bcd\u0bb0\u0bc0",  // Period
    "?",                         // Slash
    "\u0020",                    // Space
};
const char* kAltGr[] = {
    "",        // BackQuote
    "\u0be7",  // Digit1
    "\u0be8",  // Digit2
    "\u0be9",  // Digit3
    "\u0bea",  // Digit4
    "\u0beb",  // Digit5
    "\u0bec",  // Digit6
    "\u0bed",  // Digit7
    "\u0bee",  // Digit8
    "\u0bef",  // Digit9
    "\u0be6",  // Digit0
    "",        // Minus
    "\u0bf2",  // Equal
    "",        // KeyQ
    "",        // KeyW
    "",        // KeyE
    "",        // KeyR
    "",        // KeyT
    "",        // KeyY
    "",        // KeyU
    "",        // KeyI
    "",        // KeyO
    "",        // KeyP
    "",        // BracketLeft
    "",        // BracketRight
    "",        // Backslash
    "",        // KeyA
    "",        // KeyS
    "",        // KeyD
    "",        // KeyF
    "",        // KeyG
    "",        // KeyH
    "",        // KeyJ
    "",        // KeyK
    "",        // KeyL
    "",        // Semicolon
    "",        // Quote
    "",        // KeyZ
    "",        // KeyX
    "",        // KeyC
    "",        // KeyV
    "",        // KeyB
    "",        // KeyN
    "",        // KeyM
    "",        // Comma
    "",        // Period
    "",        // Slash
    "\u0020",  // Space
};
const char* kCapslock[] = {
    "\u0bca",  // BackQuote
    "1",       // Digit1
    "2",       // Digit2
    "3",       // Digit3
    "4",       // Digit4
    "5",       // Digit5
    "6",       // Digit6
    "7",       // Digit7
    "8",       // Digit8
    "9",       // Digit9
    "0",       // Digit0
    "-",       // Minus
    "\u0bf2",  // Equal
    "\u0bcc",  // KeyQ
    "\u0bc8",  // KeyW
    "\u0bbe",  // KeyE
    "\u0bc0",  // KeyR
    "\u0bc2",  // KeyT
    "\u0baa",  // KeyY
    "\u0bb9",  // KeyU
    "\u0b95",  // KeyI
    "\u0ba4",  // KeyO
    "\u0b9c",  // KeyP
    "\u0b9f",  // BracketLeft
    "\u0b9e",  // BracketRight
    "\u0b9f",  // Backslash
    "\u0bcb",  // KeyA
    "\u0bc7",  // KeyS
    "\u0bcd",  // KeyD
    "\u0bbf",  // KeyF
    "\u0bc1",  // KeyG
    "\u0baa",  // KeyH
    "\u0bb0",  // KeyJ
    "\u0b95",  // KeyK
    "\u0ba4",  // KeyL
    "\u0b9a",  // Semicolon
    "\u0b9f",  // Quote
    "\u0bc6",  // KeyZ
    "\u0b82",  // KeyX
    "\u0bae",  // KeyC
    "\u0ba8",  // KeyV
    "\u0bb5",  // KeyB
    "\u0bb2",  // KeyN
    "\u0bb8",  // KeyM
    ",",       // Comma
    ".",       // Period
    "\u0baf",  // Slash
    "\u0020",  // Space
};
const char* kShiftCapslock[] = {
    "\u0b92",                    // BackQuote
    "\u0b95",                    // Digit1
    "\u0be8",                    // Digit2
    "\u0bcd\u0bb0",              // Digit3
    "\u20b9",                    // Digit4
    "\u0b9c\u0bcd\u0b9e",        // Digit5
    "\u0ba4\u0bcd\u0bb0",        // Digit6
    "\u0b95\u0bcd\u0bb7",        // Digit7
    "\u0bb6\u0bcd\u0bb0",        // Digit8
    "(",                         // Digit9
    ")",                         // Digit0
    "\u0b83",                    // Minus
    "",                          // Equal
    "\u0b94",                    // KeyQ
    "\u0b90",                    // KeyW
    "\u0b86",                    // KeyE
    "\u0b88",                    // KeyR
    "\u0b8a",                    // KeyT
    "",                          // KeyY
    "\u0b99",                    // KeyU
    "",                          // KeyI
    "",                          // KeyO
    "\u0b9a",                    // KeyP
    "",                          // BracketLeft
    "",                          // BracketRight
    "",                          // Backslash
    "\u0b93",                    // KeyA
    "\u0b8f",                    // KeyS
    "\u0b85",                    // KeyD
    "\u0b87",                    // KeyF
    "\u0b89",                    // KeyG
    "",                          // KeyH
    "\u0bb1",                    // KeyJ
    "",                          // KeyK
    "",                          // KeyL
    "",                          // Semicolon
    "",                          // Quote
    "\u0b8e",                    // KeyZ
    "",                          // KeyX
    "\u0ba3",                    // KeyC
    "\u0ba9",                    // KeyV
    "\u0bb4",                    // KeyB
    "\u0bb3",                    // KeyN
    "\u0bb6",                    // KeyM
    "\u0bb7",                    // Comma
    "\u0bb8\u0bcd\u0bb0\u0bc0",  // Period
    "?",                         // Slash
    "\u0020",                    // Space
};
const char** kKeyMap[8] = {kNormal,   kShift,         kAltGr, kAltGr,
                           kCapslock, kShiftCapslock, kAltGr, kShiftCapslock};

}  // namespace ta_inscript
