// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ash/services/ime/public/cpp/rulebased/def/ru_phone_aatseel.h"

namespace ru_phone_aatseel {

const char* kId = "ru_phone_aatseel";
bool kIs102 = false;
const char* kNormal[] = {
    "\u0451",  // BackQuote
    "1",       // Digit1
    "2",       // Digit2
    "3",       // Digit3
    "4",       // Digit4
    "5",       // Digit5
    "6",       // Digit6
    "7",       // Digit7
    "8",       // Digit8
    "9",       // Digit9
    "0",       // Digit0
    "-",       // Minus
    "\u044a",  // Equal
    "\u044f",  // KeyQ
    "\u0448",  // KeyW
    "\u0435",  // KeyE
    "\u0440",  // KeyR
    "\u0442",  // KeyT
    "\u044b",  // KeyY
    "\u0443",  // KeyU
    "\u0438",  // KeyI
    "\u043e",  // KeyO
    "\u043f",  // KeyP
    "\u044e",  // BracketLeft
    "\u0449",  // BracketRight
    "\u044d",  // Backslash
    "\u0430",  // KeyA
    "\u0441",  // KeyS
    "\u0434",  // KeyD
    "\u0444",  // KeyF
    "\u0433",  // KeyG
    "\u0447",  // KeyH
    "\u0439",  // KeyJ
    "\u043a",  // KeyK
    "\u043b",  // KeyL
    "\u044c",  // Semicolon
    "\u0436",  // Quote
    "\u0437",  // KeyZ
    "\u0445",  // KeyX
    "\u0446",  // KeyC
    "\u0432",  // KeyV
    "\u0431",  // KeyB
    "\u043d",  // KeyN
    "\u043c",  // KeyM
    ",",       // Comma
    ".",       // Period
    "/",       // Slash
    "\u0020",  // Space
};
const char* kShift[] = {
    "\u0401",  // BackQuote
    "!",       // Digit1
    "@",       // Digit2
    "#",       // Digit3
    "\"",      // Digit4
    ":",       // Digit5
    "^",       // Digit6
    "&",       // Digit7
    "*",       // Digit8
    "(",       // Digit9
    ")",       // Digit0
    "_",       // Minus
    "\u042a",  // Equal
    "\u042f",  // KeyQ
    "\u0428",  // KeyW
    "\u0415",  // KeyE
    "\u0420",  // KeyR
    "\u0422",  // KeyT
    "\u042b",  // KeyY
    "\u0423",  // KeyU
    "\u0418",  // KeyI
    "\u041e",  // KeyO
    "\u041f",  // KeyP
    "\u042e",  // BracketLeft
    "\u0429",  // BracketRight
    "\u042d",  // Backslash
    "\u0410",  // KeyA
    "\u0421",  // KeyS
    "\u0414",  // KeyD
    "\u0424",  // KeyF
    "\u0413",  // KeyG
    "\u0427",  // KeyH
    "\u0419",  // KeyJ
    "\u041a",  // KeyK
    "\u041b",  // KeyL
    "\u042c",  // Semicolon
    "\u0416",  // Quote
    "\u0417",  // KeyZ
    "\u0425",  // KeyX
    "\u0426",  // KeyC
    "\u0412",  // KeyV
    "\u0411",  // KeyB
    "\u041d",  // KeyN
    "\u041c",  // KeyM
    "<",       // Comma
    ">",       // Period
    "?",       // Slash
    "\u0020",  // Space
};
const char* kAltGr[] = {
    "`",       // BackQuote
    "1",       // Digit1
    "2",       // Digit2
    "3",       // Digit3
    "4",       // Digit4
    "5",       // Digit5
    "6",       // Digit6
    "7",       // Digit7
    "8",       // Digit8
    "9",       // Digit9
    "0",       // Digit0
    "-",       // Minus
    "=",       // Equal
    "q",       // KeyQ
    "w",       // KeyW
    "e",       // KeyE
    "r",       // KeyR
    "t",       // KeyT
    "y",       // KeyY
    "u",       // KeyU
    "i",       // KeyI
    "o",       // KeyO
    "p",       // KeyP
    "[",       // BracketLeft
    "]",       // BracketRight
    "\\",      // Backslash
    "a",       // KeyA
    "s",       // KeyS
    "d",       // KeyD
    "f",       // KeyF
    "g",       // KeyG
    "h",       // KeyH
    "j",       // KeyJ
    "k",       // KeyK
    "l",       // KeyL
    ";",       // Semicolon
    "'",       // Quote
    "z",       // KeyZ
    "x",       // KeyX
    "c",       // KeyC
    "v",       // KeyV
    "b",       // KeyB
    "n",       // KeyN
    "m",       // KeyM
    ",",       // Comma
    ".",       // Period
    "/",       // Slash
    "\u0020",  // Space
};
const char* kCapslock[] = {
    "\u0401",  // BackQuote
    "1",       // Digit1
    "2",       // Digit2
    "3",       // Digit3
    "4",       // Digit4
    "5",       // Digit5
    "6",       // Digit6
    "7",       // Digit7
    "8",       // Digit8
    "9",       // Digit9
    "0",       // Digit0
    "-",       // Minus
    "\u042a",  // Equal
    "\u042f",  // KeyQ
    "\u0428",  // KeyW
    "\u0415",  // KeyE
    "\u0420",  // KeyR
    "\u0422",  // KeyT
    "\u042b",  // KeyY
    "\u0423",  // KeyU
    "\u0418",  // KeyI
    "\u041e",  // KeyO
    "\u041f",  // KeyP
    "\u042e",  // BracketLeft
    "\u0429",  // BracketRight
    "\u042d",  // Backslash
    "\u0410",  // KeyA
    "\u0421",  // KeyS
    "\u0414",  // KeyD
    "\u0424",  // KeyF
    "\u0413",  // KeyG
    "\u0427",  // KeyH
    "\u0419",  // KeyJ
    "\u041a",  // KeyK
    "\u041b",  // KeyL
    "\u042c",  // Semicolon
    "\u0416",  // Quote
    "\u0417",  // KeyZ
    "\u0425",  // KeyX
    "\u0426",  // KeyC
    "\u0412",  // KeyV
    "\u0411",  // KeyB
    "\u041d",  // KeyN
    "\u041c",  // KeyM
    ",",       // Comma
    ".",       // Period
    "/",       // Slash
    "\u0020",  // Space
};
const char* kShiftAltGr[] = {
    "~",       // BackQuote
    "!",       // Digit1
    "@",       // Digit2
    "#",       // Digit3
    "$",       // Digit4
    "%",       // Digit5
    "^",       // Digit6
    "&",       // Digit7
    "*",       // Digit8
    "(",       // Digit9
    ")",       // Digit0
    "_",       // Minus
    "+",       // Equal
    "Q",       // KeyQ
    "W",       // KeyW
    "E",       // KeyE
    "R",       // KeyR
    "T",       // KeyT
    "Y",       // KeyY
    "U",       // KeyU
    "I",       // KeyI
    "O",       // KeyO
    "P",       // KeyP
    "{",       // BracketLeft
    "}",       // BracketRight
    "|",       // Backslash
    "A",       // KeyA
    "S",       // KeyS
    "D",       // KeyD
    "F",       // KeyF
    "G",       // KeyG
    "H",       // KeyH
    "J",       // KeyJ
    "K",       // KeyK
    "L",       // KeyL
    ":",       // Semicolon
    "\"",      // Quote
    "Z",       // KeyZ
    "X",       // KeyX
    "C",       // KeyC
    "V",       // KeyV
    "B",       // KeyB
    "N",       // KeyN
    "M",       // KeyM
    "<",       // Comma
    ">",       // Period
    "?",       // Slash
    "\u0020",  // Space
};
const char* kAltgrCapslock[] = {
    "`",       // BackQuote
    "1",       // Digit1
    "2",       // Digit2
    "3",       // Digit3
    "4",       // Digit4
    "5",       // Digit5
    "6",       // Digit6
    "7",       // Digit7
    "8",       // Digit8
    "9",       // Digit9
    "0",       // Digit0
    "-",       // Minus
    "=",       // Equal
    "Q",       // KeyQ
    "W",       // KeyW
    "E",       // KeyE
    "R",       // KeyR
    "T",       // KeyT
    "Y",       // KeyY
    "U",       // KeyU
    "I",       // KeyI
    "O",       // KeyO
    "P",       // KeyP
    "[",       // BracketLeft
    "]",       // BracketRight
    "\\",      // Backslash
    "A",       // KeyA
    "S",       // KeyS
    "D",       // KeyD
    "F",       // KeyF
    "G",       // KeyG
    "H",       // KeyH
    "J",       // KeyJ
    "K",       // KeyK
    "L",       // KeyL
    ";",       // Semicolon
    "'",       // Quote
    "Z",       // KeyZ
    "X",       // KeyX
    "C",       // KeyC
    "V",       // KeyV
    "B",       // KeyB
    "N",       // KeyN
    "M",       // KeyM
    ",",       // Comma
    ".",       // Period
    "/",       // Slash
    "\u0020",  // Space
};
const char* kShiftCapslock[] = {
    "\u0451",  // BackQuote
    "!",       // Digit1
    "@",       // Digit2
    "#",       // Digit3
    "\"",      // Digit4
    ":",       // Digit5
    "^",       // Digit6
    "&",       // Digit7
    "*",       // Digit8
    "(",       // Digit9
    ")",       // Digit0
    "_",       // Minus
    "\u044a",  // Equal
    "\u044f",  // KeyQ
    "\u0448",  // KeyW
    "\u0435",  // KeyE
    "\u0440",  // KeyR
    "\u0442",  // KeyT
    "\u044b",  // KeyY
    "\u0443",  // KeyU
    "\u0438",  // KeyI
    "\u043e",  // KeyO
    "\u043f",  // KeyP
    "\u044e",  // BracketLeft
    "\u0449",  // BracketRight
    "\u044d",  // Backslash
    "\u0430",  // KeyA
    "\u0441",  // KeyS
    "\u0434",  // KeyD
    "\u0444",  // KeyF
    "\u0433",  // KeyG
    "\u0447",  // KeyH
    "\u0439",  // KeyJ
    "\u043a",  // KeyK
    "\u043b",  // KeyL
    "\u044c",  // Semicolon
    "\u0436",  // Quote
    "\u0437",  // KeyZ
    "\u0445",  // KeyX
    "\u0446",  // KeyC
    "\u0432",  // KeyV
    "\u0431",  // KeyB
    "\u043d",  // KeyN
    "\u043c",  // KeyM
    "<",       // Comma
    ">",       // Period
    "?",       // Slash
    "\u0020",  // Space
};
const char* kShiftAltGrCapslock[] = {
    "~",       // BackQuote
    "!",       // Digit1
    "@",       // Digit2
    "#",       // Digit3
    "$",       // Digit4
    "%",       // Digit5
    "^",       // Digit6
    "&",       // Digit7
    "*",       // Digit8
    "(",       // Digit9
    ")",       // Digit0
    "_",       // Minus
    "+",       // Equal
    "q",       // KeyQ
    "w",       // KeyW
    "e",       // KeyE
    "r",       // KeyR
    "t",       // KeyT
    "y",       // KeyY
    "u",       // KeyU
    "i",       // KeyI
    "o",       // KeyO
    "p",       // KeyP
    "{",       // BracketLeft
    "}",       // BracketRight
    "|",       // Backslash
    "a",       // KeyA
    "s",       // KeyS
    "d",       // KeyD
    "f",       // KeyF
    "g",       // KeyG
    "h",       // KeyH
    "j",       // KeyJ
    "k",       // KeyK
    "l",       // KeyL
    ":",       // Semicolon
    "\"",      // Quote
    "z",       // KeyZ
    "x",       // KeyX
    "c",       // KeyC
    "v",       // KeyV
    "b",       // KeyB
    "n",       // KeyN
    "m",       // KeyM
    "<",       // Comma
    ">",       // Period
    "?",       // Slash
    "\u0020",  // Space
};
const char** kKeyMap[8] = {
    kNormal,   kShift,         kAltGr,         kShiftAltGr,
    kCapslock, kShiftCapslock, kAltgrCapslock, kShiftAltGrCapslock};

}  // namespace ru_phone_aatseel
