// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ash/services/ime/public/cpp/rulebased/def/ml_phone.h"

#include <iterator>

namespace ml_phone {

const char* kId = "ml_phone";
bool kIs102 = false;
const char* kTransforms[] = {
    "\\\\([a-zA-Z0-9@$])",
    "\\1",
    "([a-zA-Z])\u001d([a-zA-Z0-9`~!@#$%^&*()_=+:;\"',<.>?/|\\-])",
    "\\1\\2",
    "\\\\(ch)",
    "\\1",
    "([a-zA-Z])\u001d(ch)",
    "\\1\\2",
    "(M|\u001d?_M|\u0d02\u001d?m)",
    "\u0d2e\u0d4d\u0d2e\u0d4d",
    "([\u0d03-\u0d0a\u0d0c-\u0d4c\u0d4e-\u0d79])\u001d?R",
    "\\1\u0d7c",
    "([\u0d02-\u0d4c\u0d4e-\u0d79])\u001d?~",
    "\\1\u0d4d",
    "([\u0d02-\u0d4c\u0d4e-\u0d7f])\u0d7b\u001d?j",
    "\\1\u0d1e\u0d4d\u0d1e\u0d4d",
    "([\u0d15-\u0d3a])\u001d?a",
    "\\1\u0d3e",
    "([\u0d15-\u0d3a])\u001d?i",
    "\\1\u0d48",
    "([\u0d15-\u0d3a])\u001d?u",
    "\\1\u0d57",
    "([\u0d66-\u0d6f])\u001d?0",
    "\\1\u0d66",
    "([\u0d66-\u0d6f])\u001d?1",
    "\\1\u0d67",
    "([\u0d66-\u0d6f])\u001d?2",
    "\\1\u0d68",
    "([\u0d66-\u0d6f])\u001d?3",
    "\\1\u0d69",
    "([\u0d66-\u0d6f])\u001d?4",
    "\\1\u0d6a",
    "([\u0d66-\u0d6f])\u001d?5",
    "\\1\u0d6b",
    "([\u0d66-\u0d6f])\u001d?6",
    "\\1\u0d6c",
    "([\u0d66-\u0d6f])\u001d?7",
    "\\1\u0d6d",
    "([\u0d66-\u0d6f])\u001d?8",
    "\\1\u0d6e",
    "([\u0d66-\u0d6f])\u001d?9",
    "\\1\u0d6f",
    "([wv]|\u001d?_[wv])",
    "\u0d35\u0d4d",
    "(\u001d?R|\u0d0b\u001d?)A",
    "\u0d31\u0d3e",
    "(\u001d?R|\u0d0b\u001d?)E",
    "\u0d31\u0d47",
    "(\u001d?R|\u0d0b\u001d?)I",
    "\u0d31\u0d40",
    "(\u001d?R|\u0d0b\u001d?)U",
    "\u0d31\u0d42",
    "(\u001d?R|\u0d0b\u001d?)a",
    "\u0d31",
    "(\u001d?R|\u0d0b\u001d?)e",
    "\u0d31\u0d46",
    "(\u001d?R|\u0d0b\u001d?)i",
    "\u0d31\u0d3f",
    "(\u001d?R|\u0d0b\u001d?)u",
    "\u0d31\u0d41",
    "(\u001d?_)?B",
    "\u0d2c\u0d4d\u0d2c\u0d4d",
    "(\u001d?_)?D",
    "\u0d21\u0d4d",
    "(\u001d?_)?G",
    "\u0d17\u0d4d\u0d17\u0d4d",
    "(\u001d?_)?J",
    "\u0d1c\u0d4d\u0d1c\u0d4d",
    "(\u001d?_)?K",
    "\u0d15\u0d4d\u0d15\u0d4d",
    "(\u001d?_)?P",
    "\u0d2a\u0d4d\u0d2a\u0d4d",
    "(\u001d?_)?Y",
    "\u0d2f\u0d4d\u0d2f\u0d4d",
    "(\u001d?_)?Z",
    "\u0d34\u0d4d",
    "(\u001d?_)?T",
    "\u0d1f\u0d4d",
    "(\u001d?_)?[Sz]",
    "\u0d36\u0d4d",
    "(\u001d?_)?[VW]",
    "\u0d35\u0d4d\u0d35\u0d4d",
    "(\u001d?_)?[Cc]",
    "\u0d1a\u0d4d",
    "(\u001d?_)?[Xx]",
    "\u0d15\u0d4d\u0d38\u0d4d",
    "(\u001d?_)?b",
    "\u0d2c\u0d4d",
    "(\u001d?_)?d",
    "\u0d26\u0d4d",
    "(\u001d?_)?g",
    "\u0d17\u0d4d",
    "(\u001d?_)?h",
    "\u0d39\u0d4d",
    "(\u001d?_)?j",
    "\u0d1c\u0d4d",
    "(\u001d?_)?p",
    "\u0d2a\u0d4d",
    "(\u001d?_)?s",
    "\u0d38\u0d4d",
    "(\u001d?_)?y",
    "\u0d2f\u0d4d",
    "(\u0d05\u001d?a|_?A)",
    "\u0d06",
    "(\u0d07\u001d?i|\u0d0e\u001d?a|_?I|[\u0d0e\u0d07]\u001d?e)",
    "\u0d08",
    "(\u0d09\u001d?u|\u0d12\u001d?o|_?U)",
    "\u0d0a",
    "(\u0d0b\u001d?|\u001d?R)O",
    "\u0d31\u0d4b",
    "(\u0d0b\u001d?|\u001d?R)o",
    "\u0d31\u0d4a",
    "(\u0d0b\u001d?|\u001d?R)~",
    "\u0d31\u0d4d",
    "(\u0d15\u0d4d\u001d?h|\u001d?_[qQ]|[qQ])",
    "\u0d16\u0d4d",
    "(\u0d15\u0d4d|\u0d7f)\u001d?\\^",
    "\u0d15\u0d4d\u200d",
    "(\u0d1f\u0d4d\u001d?t|\u0d31\u0d4d\u0d31\u0d4d\u001d?[tT])",
    "\u0d1f\u0d4d\u0d1f\u0d4d",
    "(\u0d28\u0d4d\u001d?T|\u0d7a\u001d?[Tt])",
    "\u0d23\u0d4d\u0d1f\u0d4d",
    "(\u0d23\u0d4d\u001d?t|\u0d7b\u001d?T)",
    "\u0d23\u0d4d\u0d1f\u0d4d",
    "(\u0d23\u0d4d|\u0d7a)\u001d?\\^",
    "\u0d23\u0d4d\u200d",
    "(\u0d28\u0d4d\u001d?ch?|\u0d7b\u001d?ch?)",
    "\u0d1e\u0d4d\u0d1a\u0d4d",
    "(\u0d28\u0d4d|\u0d7b)\u001d?k",
    "\u0d19\u0d4d\u0d15\u0d4d",
    "(\u0d2a\u0d4d\u001d?h|\u001d?_[Ff]|[Ff])",
    "\u0d2b\u0d4d",
    "(\u0d30\u0d4d|\u0d7c)\u001d?\\^",
    "\u0d30\u0d4d\u200d",
    "(\u0d30\u0d4d|\u0d7c)\u001d?r",
    "\u0d31\u0d4d",
    "(\u0d4b\u0d3e*)\u001d?O",
    "\\1\u0d3e",
    "(\u0d4d\u001d?I|\u0d46\u001d?[ea]|\u0d3f\u001d?[ie])",
    "\u0d40",
    "(\u0d4d\u001d?U|\u0d41\u001d?u|\u0d4a\u001d?o)",
    "\u0d42",
    "(\u0d4d\u0d05|\u0d46)\u001d?i",
    "\u0d48",
    "(\u0d4d\u0d05|\u0d4a)\u001d?u",
    "\u0d57",
    "(\u0d7b|\u0d28\u0d4d)\u001d?\\^",
    "\u0d28\u0d4d\u200d",
    "(\u0d7b|\u0d28\u0d4d)\u001d?t",
    "\u0d28\u0d4d\u0d31\u0d4d",
    "(\u0d7d\u001d?L|\u0d7e\u001d?[lL])",
    "\u0d33\u0d4d\u0d33\u0d4d",
    "(\u0d7d|\u0d32\u0d4d)\u001d?\\^",
    "\u0d32\u0d4d\u200d",
    "(\u0d7e|\u0d33\u0d4d)\u001d?\\^",
    "\u0d33\u0d4d\u200d",
    "(k|\u001d?_[kc])",
    "\u0d15\u0d4d",
    "(\u0d7c\u001d?~|\u001d?_r)",
    "\u0d30\u0d4d",
    "(\u0d7e\u001d?~|\u001d?_L)",
    "\u0d33\u0d4d",
    "(\u0d7d\u001d?~|\u001d?_l)",
    "\u0d32\u0d4d",
    "(\u0d7a\u001d?~|\u001d?_N)",
    "\u0d23\u0d4d",
    "(\u0d7b\u001d?~|\u001d?_n)",
    "\u0d28\u0d4d",
    "(\u0d02\u001d?~|\u001d?_m)",
    "\u0d2e\u0d4d",
    "0#",
    "\u0d66",
    "1#",
    "\u0d67",
    "1/2#",
    "\u0d74",
    "1/4#",
    "\u0d73",
    "10#",
    "\u0d70",
    "100#",
    "\u0d71",
    "1000#",
    "\u0d72",
    "2#",
    "\u0d68",
    "3#",
    "\u0d69",
    "3/4#",
    "\u0d75",
    "4#",
    "\u0d6a",
    "5#",
    "\u0d6b",
    "6#",
    "\u0d6c",
    "7#",
    "\u0d6d",
    "8#",
    "\u0d6e",
    "9#",
    "\u0d6f",
    "@",
    "\u0d4d",
    "@a",
    "\u0d4d\u0d05",
    "@aL",
    "\u0d7e",
    "@aN",
    "\u0d7a",
    "@aa",
    "\u0d3e",
    "@ai",
    "\u0d48",
    "@al",
    "\u0d7d",
    "@am",
    "\u0d02",
    "@an",
    "\u0d7b",
    "@ar",
    "\u0d7c",
    "@au",
    "\u0d57",
    "C",
    "\u0d1a\u0d4d\u0d1a\u0d4d",
    "H",
    "\u0d03",
    "[\u0d05\u0d0e]\u001d?i",
    "\u0d10",
    "[\u0d05\u0d12]\u001d?u",
    "\u0d14",
    "\\$",
    "\u20b9",
    "\u001d?_X",
    "\u0d15\u0d4d\u0d37\u0d4d",
    "\u0d02\u001d?A",
    "\u0d2e\u0d3e",
    "\u0d02\u001d?E",
    "\u0d2e\u0d47",
    "\u0d02\u001d?I",
    "\u0d2e\u0d40",
    "\u0d02\u001d?O",
    "\u0d2e\u0d4b",
    "\u0d02\u001d?U",
    "\u0d2e\u0d42",
    "\u0d02\u001d?[Ll]",
    "\u0d2e\u0d4d\u0d32\u0d4d",
    "\u0d02\u001d?a",
    "\u0d2e",
    "\u0d02\u001d?e",
    "\u0d2e\u0d46",
    "\u0d02\u001d?i",
    "\u0d2e\u0d3f",
    "\u0d02\u001d?n",
    "\u0d2e\u0d4d\u0d28\u0d4d",
    "\u0d02\u001d?o",
    "\u0d2e\u0d4a",
    "\u0d02\u001d?p",
    "\u0d2e\u0d4d\u0d2a\u0d4d",
    "\u0d02\u001d?r",
    "\u0d2e\u0d4d\u0d30\u0d4d",
    "\u0d02\u001d?R",
    "\u0d2e\u0d43",
    "\u0d02\u001d?u",
    "\u0d2e\u0d41",
    "\u0d02\u001d?y",
    "\u0d2e\u0d4d\u0d2f\u0d4d",
    "\u0d05\u001d?#",
    "\u0d3d",
    "\u0d06\u001d?[Aa]",
    "\u0d06\u0d3e",
    "\u0d08\u001d?#",
    "\u0d5f",
    "\u0d08\u001d?[eiI]",
    "\u0d08\u0d57",
    "\u0d0a\u001d?[uoU]",
    "\u0d0a\u0d57",
    "\u0d0b\u0d0b\u001d?#",
    "\u0d60",
    "\u0d0c\u001d?L",
    "\u0d61",
    "\u0d13\u001d?O",
    "\u0d13\u0d3e",
    "\u0d14\u001d?u",
    "\u0d14\u0d57",
    "\u0d15\u0d4d\u001d?#",
    "\u0d7f",
    "\u0d17\u0d4d\u001d?h",
    "\u0d18\u0d4d",
    "\u0d1a\u0d4d\u001d?h",
    "\u0d1b\u0d4d",
    "\u0d1c\u0d4d\u001d?h",
    "\u0d1d\u0d4d",
    "\u0d1e\u0d4d\u0d1e\u0d4d\u001d?ch",
    "\u0d1e\u0d4d\u0d1a\u0d4d",
    "\u0d1e\u0d4d\u0d1e\u0d4d\u001d?j",
    "\u0d1e\u0d4d\u0d1c\u0d4d",
    "\u0d1e\u0d4d\u0d1e\u0d4d\u0d28\u0d4d\u001d?j",
    "\u0d1e\u0d4d\u0d1e\u0d4d",
    "\u0d1e\u0d4d\u0d1e\u0d4d\u0d7b\u001d?j",
    "\u0d1e\u0d4d\u0d1e\u0d4d",
    "\u0d1e\u0d4d\u0d28\u0d4d\u001d?j",
    "\u0d1e\u0d4d\u0d1e\u0d4d",
    "\u0d1f\u0d4d\u001d?h",
    "\u0d20\u0d4d",
    "\u0d1f\u0d4d\u0d1f\u0d4d\u001d?h",
    "\u0d24\u0d4d\u0d24\u0d4d",
    "\u0d21\u0d4d\u001d?h",
    "\u0d22\u0d4d",
    "\u0d23\u0d4d\u0d1f\u0d4d\u001d?T",
    "\u0d7a\u0d1f\u0d4d\u0d1f\u0d4d",
    "\u0d23\u0d4d\u0d21\u0d4d\u001d?D",
    "\u0d7a\u0d21\u0d4d\u0d21\u0d4d",
    "\u0d23\u0d4d\u0d26\u0d4d\u001d?d",
    "\u0d7a\u0d26\u0d4d\u0d26\u0d4d",
    "\u0d23\u0d4d\u0d28\u0d4d\u001d?n",
    "\u0d7a\u0d28\u0d4d\u0d28\u0d4d",
    "\u0d23\u0d4d\u0d2a\u0d4d\u001d?p",
    "\u0d7a\u0d2a\u0d4d\u0d2a\u0d4d",
    "\u0d23\u0d4d\u0d2e\u0d4d\u001d?m",
    "\u0d7a\u0d2e\u0d4d\u0d2e\u0d4d",
    "\u0d23\u0d4d\u0d2f\u0d4d\u001d?y",
    "\u0d7a\u0d2f\u0d4d\u0d2f\u0d4d",
    "\u0d23\u0d4d\u0d32\u0d4d\u001d?l",
    "\u0d7a\u0d32\u0d4d\u0d32\u0d4d",
    "\u0d23\u0d4d\u0d33\u0d4d\u001d?L",
    "\u0d7a\u0d33\u0d4d\u0d33\u0d4d",
    "\u0d23\u0d4d\u0d35\u0d4d\u001d?v",
    "\u0d7a\u0d35\u0d4d\u0d35\u0d4d",
    "\u0d24\u0d4d\u001d?h",
    "\u0d25\u0d4d",
    "\u0d24\u0d4d\u0d24\u0d4d\u001d?h",
    "\u0d24\u0d4d\u0d25\u0d4d",
    "\u0d26\u0d4d\u001d?h",
    "\u0d27\u0d4d",
    "\u0d28\u0d41\u001d?#",
    "\u0d79",
    "\u0d28\u0d4d\u001d?#",
    "\u0d29\u0d4d",
    "\u0d28\u001d?#",
    "\u0d29",
    "\u0d28\u0d4d\u001d?g",
    "\u0d19\u0d4d",
    "\u0d7b\u001d?j",
    "\u0d1e\u0d4d",
    "\u0d28\u0d4d\u0d1f\u0d4d\u001d?T",
    "\u0d7b\u0d1f\u0d4d\u0d1f\u0d4d",
    "\u0d28\u0d4d\u0d21\u0d4d\u001d?D",
    "\u0d7b\u0d21\u0d4d\u0d21\u0d4d",
    "\u0d28\u0d4d\u0d26\u0d4d\u001d?d",
    "\u0d7b\u0d26\u0d4d\u0d26\u0d4d",
    "\u0d28\u0d4d\u0d28\u0d4d\u001d?n",
    "\u0d7b\u0d28\u0d4d\u0d28\u0d4d",
    "\u0d28\u0d4d\u0d2a\u0d4d\u001d?p",
    "\u0d7b\u0d2a\u0d4d\u0d2a\u0d4d",
    "\u0d28\u0d4d\u0d2e\u0d4d\u001d?m",
    "\u0d7b\u0d2e\u0d4d\u0d2e\u0d4d",
    "\u0d28\u0d4d\u0d2f\u0d4d\u001d?y",
    "\u0d7b\u0d2f\u0d4d\u0d2f\u0d4d",
    "\u0d28\u0d4d\u0d30\u0d4d\u001d?r",
    "\u0d7b\u0d31\u0d4d",
    "\u0d28\u0d4d\u0d31\u0d4d\u001d?h",
    "\u0d28\u0d4d\u0d24\u0d4d",
    "\u0d28\u0d4d\u0d32\u0d4d\u001d?l",
    "\u0d7b\u0d32\u0d4d\u0d32\u0d4d",
    "\u0d28\u0d4d\u0d33\u0d4d\u001d?L",
    "\u0d7b\u0d33\u0d4d\u0d33\u0d4d",
    "\u0d28\u0d4d\u0d35\u0d4d\u001d?v",
    "\u0d7b\u0d35\u0d4d\u0d35\u0d4d",
    "\u0d2c\u0d4d\u001d?h",
    "\u0d2d\u0d4d",
    "\u0d2e\u0d4d\u0d1f\u0d4d\u001d?T",
    "\u0d02\u0d1f\u0d4d\u0d1f\u0d4d",
    "\u0d2e\u0d4d\u0d21\u0d4d\u001d?D",
    "\u0d02\u0d21\u0d4d\u0d21\u0d4d",
    "\u0d2e\u0d4d\u0d26\u0d4d\u001d?d",
    "\u0d02\u0d26\u0d4d\u0d26\u0d4d",
    "\u0d2e\u0d4d\u0d28\u0d4d\u001d?n",
    "\u0d02\u0d28\u0d4d\u0d28\u0d4d",
    "\u0d2e\u0d4d\u0d2a\u0d4d\u001d?p",
    "\u0d02\u0d2a\u0d4d\u0d2a\u0d4d",
    "\u0d2e\u0d4d\u0d2e\u0d4d\u001d?m",
    "\u0d02\u0d2e\u0d4d\u0d2e\u0d4d",
    "\u0d2e\u0d4d\u0d2f\u0d4d\u001d?y",
    "\u0d02\u0d2f\u0d4d\u0d2f\u0d4d",
    "\u0d2e\u0d4d\u0d32\u0d4d\u001d?l",
    "\u0d02\u0d32\u0d4d\u0d32\u0d4d",
    "\u0d2e\u0d4d\u0d33\u0d4d\u001d?L",
    "\u0d02\u0d33\u0d4d\u0d33\u0d4d",
    "\u0d2e\u0d4d\u0d35\u0d4d\u001d?v",
    "\u0d02\u0d35\u0d4d\u0d35\u0d4d",
    "\u0d30\u0d4d\u0d1f\u0d4d\u001d?T",
    "\u0d7c\u0d1f\u0d4d\u0d1f\u0d4d",
    "\u0d30\u0d4d\u0d21\u0d4d\u001d?D",
    "\u0d7c\u0d21\u0d4d\u0d21\u0d4d",
    "\u0d30\u0d4d\u0d26\u0d4d\u001d?d",
    "\u0d7c\u0d26\u0d4d\u0d26\u0d4d",
    "\u0d30\u0d4d\u0d28\u0d4d\u001d?n",
    "\u0d7c\u0d28\u0d4d\u0d28\u0d4d",
    "\u0d30\u0d4d\u0d2a\u0d4d\u001d?p",
    "\u0d7c\u0d2a\u0d4d\u0d2a\u0d4d",
    "\u0d30\u0d4d\u0d2e\u0d4d\u001d?m",
    "\u0d7c\u0d2e\u0d4d\u0d2e\u0d4d",
    "\u0d30\u0d4d\u0d2f\u0d4d\u001d?y",
    "\u0d7c\u0d2f\u0d4d\u0d2f\u0d4d",
    "\u0d30\u0d4d\u0d32\u0d4d\u001d?l",
    "\u0d7c\u0d32\u0d4d\u0d32\u0d4d",
    "\u0d30\u0d4d\u0d33\u0d4d\u001d?L",
    "\u0d7c\u0d33\u0d4d\u0d33\u0d4d",
    "\u0d30\u0d4d\u0d35\u0d4d\u001d?v",
    "\u0d7c\u0d35\u0d4d\u0d35\u0d4d",
    "\u0d31\u0d4d\u0d31\u0d4d\u001d?#",
    "\u0d3a\u0d4d",
    "\u0d31\u0d4d\u0d31\u001d?#",
    "\u0d3a",
    "\u0d31\u0d4d\u0d31\u0d4d\u001d?h",
    "\u0d24\u0d4d",
    "\u0d32\u0d4d\u0d1f\u0d4d\u001d?T",
    "\u0d7d\u0d1f\u0d4d\u0d1f\u0d4d",
    "\u0d32\u0d4d\u0d21\u0d4d\u001d?D",
    "\u0d7d\u0d21\u0d4d\u0d21\u0d4d",
    "\u0d32\u0d4d\u0d26\u0d4d\u001d?d",
    "\u0d7d\u0d26\u0d4d\u0d26\u0d4d",
    "\u0d32\u0d4d\u0d28\u0d4d\u001d?n",
    "\u0d7d\u0d28\u0d4d\u0d28\u0d4d",
    "\u0d32\u0d4d\u0d2a\u0d4d\u001d?p",
    "\u0d7d\u0d2a\u0d4d\u0d2a\u0d4d",
    "\u0d32\u0d4d\u0d2e\u0d4d\u001d?m",
    "\u0d7d\u0d2e\u0d4d\u0d2e\u0d4d",
    "\u0d32\u0d4d\u0d2f\u0d4d\u001d?y",
    "\u0d7d\u0d2f\u0d4d\u0d2f\u0d4d",
    "\u0d32\u0d4d\u0d32\u0d4d\u001d?l",
    "\u0d7d\u0d32\u0d4d\u0d32\u0d4d",
    "\u0d32\u0d4d\u0d33\u0d4d\u001d?L",
    "\u0d7d\u0d33\u0d4d\u0d33\u0d4d",
    "\u0d32\u0d4d\u0d35\u0d4d\u001d?v",
    "\u0d7d\u0d35\u0d4d\u0d35\u0d4d",
    "\u0d33\u0d4d\u001d?#",
    "\u0d0c",
    "\u0d33\u0d4d\u001d?L",
    "\u0d33\u0d4d\u0d33\u0d4d",
    "\u0d33\u0d4d\u0d1f\u0d4d\u001d?T",
    "\u0d7e\u0d1f\u0d4d\u0d1f\u0d4d",
    "\u0d33\u0d4d\u0d21\u0d4d\u001d?D",
    "\u0d7e\u0d21\u0d4d\u0d21\u0d4d",
    "\u0d33\u0d4d\u0d26\u0d4d\u001d?d",
    "\u0d7e\u0d26\u0d4d\u0d26\u0d4d",
    "\u0d33\u0d4d\u0d28\u0d4d\u001d?n",
    "\u0d7e\u0d28\u0d4d\u0d28\u0d4d",
    "\u0d33\u0d4d\u0d2a\u0d4d\u001d?p",
    "\u0d7e\u0d2a\u0d4d\u0d2a\u0d4d",
    "\u0d33\u0d4d\u0d2e\u0d4d\u001d?m",
    "\u0d7e\u0d2e\u0d4d\u0d2e\u0d4d",
    "\u0d33\u0d4d\u0d2f\u0d4d\u001d?y",
    "\u0d7e\u0d2f\u0d4d\u0d2f\u0d4d",
    "\u0d33\u0d4d\u0d32\u0d4d\u001d?l",
    "\u0d7e\u0d32\u0d4d\u0d32\u0d4d",
    "\u0d33\u0d4d\u0d33\u0d4d\u001d?L",
    "\u0d7e\u0d33\u0d4d\u0d33\u0d4d",
    "\u0d33\u0d4d\u0d33\u0d4d\u001d?#",
    "\u0d61",
    "\u0d33\u0d4d\u0d35\u0d4d\u001d?v",
    "\u0d7e\u0d35\u0d4d\u0d35\u0d4d",
    "\u0d36\u0d4d\u001d?h",
    "\u0d34\u0d4d",
    "\u0d38\u0d02\u001d?r",
    "\u0d38\u0d02\u0d7c",
    "\u0d38\u0d02\u001d?y",
    "\u0d38\u0d02\u0d2f\u0d4d",
    "\u0d38\u0d4d\u001d?h",
    "\u0d37\u0d4d",
    "\u0d3e\u001d?[Aa]",
    "\u0d3e\u0d3e",
    "\u0d40\u001d?[eiI]",
    "\u0d40\u0d40",
    "\u0d42\u001d?[uoU]",
    "\u0d42\u0d42",
    "\u0d43\u001d?R",
    "\u0d43\u0d7c",
    "\u0d43\u0d7c\u001d?#",
    "\u0d44",
    "\u0d4c\u001d?u",
    "\u0d4c\u0d57",
    "\u0d4d(\u001d?A|\u0d05\u001d?a)",
    "\u0d3e",
    "\u0d4d[\u0d33\u0d32]\u0d4d\u001d?#",
    "\u0d62",
    "\u0d4d[\u0d33\u0d32]\u0d4d[\u0d33\u0d32]\u0d4d\u001d?#",
    "\u0d63",
    "\u0d4d\u001d?E",
    "\u0d47",
    "\u0d4d\u001d?L",
    "\u0d4d\u0d32\u0d4d",
    "\u0d4d\u001d?O",
    "\u0d4b",
    "\u0d4d\u001d?R",
    "\u0d43",
    "\u0d4d\u001d?RA",
    "\u0d4d\u0d30\u0d3e",
    "\u0d4d\u001d?RE",
    "\u0d4d\u0d30\u0d47",
    "\u0d4d\u001d?RI",
    "\u0d4d\u0d30\u0d40",
    "\u0d4d\u001d?RO",
    "\u0d4d\u0d30\u0d4b",
    "\u0d4d\u001d?RU",
    "\u0d4d\u0d30\u0d42",
    "\u0d4d\u001d?Ra",
    "\u0d4d\u0d30",
    "\u0d4d\u001d?Re",
    "\u0d4d\u0d30\u0d46",
    "\u0d4d\u001d?Ri",
    "\u0d4d\u0d30\u0d3f",
    "\u0d4d\u001d?Ro",
    "\u0d4d\u0d30\u0d4a",
    "\u0d4d\u001d?Ru",
    "\u0d4d\u0d30\u0d41",
    "\u0d4d\u001d?R~",
    "\u0d4d\u0d30\u0d4d",
    "\u0d4d\u001d?_B",
    "\u0d4d\u200c\u0d2c\u0d4d\u0d2c\u0d4d",
    "\u0d4d\u001d?_C",
    "\u0d4d\u200c\u0d1a\u0d4d",
    "\u0d4d\u001d?_G",
    "\u0d4d\u200c\u0d17\u0d4d\u0d17\u0d4d",
    "\u0d4d\u001d?_J",
    "\u0d4d\u200c\u0d1c\u0d4d\u0d1c\u0d4d",
    "\u0d4d\u001d?_K",
    "\u0d4d\u200c\u0d15\u0d4d\u0d15\u0d4d",
    "\u0d4d\u001d?_N",
    "\u0d4d\u200c\u0d23\u0d4d",
    "\u0d4d\u001d?_Z",
    "\u0d4d\u200c\u0d36\u0d4d\u0d36\u0d4d",
    "\u0d4d\u001d?_b",
    "\u0d4d\u200c\u0d2c\u0d4d",
    "\u0d4d\u001d?_g",
    "\u0d4d\u200c\u0d17\u0d4d",
    "\u0d4d\u001d?_j",
    "\u0d4d\u200c\u0d1c\u0d4d",
    "\u0d4d\u001d?_n",
    "\u0d4d\u200c\u0d28\u0d4d",
    "\u0d4d\u001d?_r",
    "\u0d4d\u200c\u0d30\u0d4d",
    "\u0d4d\u001d?_s",
    "\u0d4d\u200c\u0d38\u0d4d",
    "\u0d4d\u001d?_T",
    "\u0d4d\u200c\u0d1f\u0d4d",
    "\u0d4d\u001d?_t",
    "\u0d4d\u200c\u0d31\u0d4d\u0d31\u0d4d",
    "\u0d4d\u001d?_D",
    "\u0d4d\u200c\u0d21\u0d4d",
    "\u0d4d\u001d?_L",
    "\u0d4d\u200c\u0d33\u0d4d",
    "\u0d4d\u001d?_M",
    "\u0d4d\u200c\u0d2e\u0d4d\u0d2e\u0d4d",
    "\u0d4d\u001d?_P",
    "\u0d4d\u200c\u0d2a\u0d4d\u0d2a\u0d4d",
    "\u0d4d\u001d?_X",
    "\u0d4d\u200c\u0d15\u0d4d\u0d37\u0d4d",
    "\u0d4d\u001d?_Y",
    "\u0d4d\u200c\u0d2f\u0d4d\u0d2f\u0d4d",
    "\u0d4d\u001d?_d",
    "\u0d4d\u200c\u0d26\u0d4d",
    "\u0d4d\u001d?_h",
    "\u0d4d\u200c\u0d39\u0d4d",
    "\u0d4d\u001d?_l",
    "\u0d4d\u200c\u0d32\u0d4d",
    "\u0d4d\u001d?_m",
    "\u0d4d\u200c\u0d2e\u0d4d",
    "\u0d4d\u001d?_p",
    "\u0d4d\u200c\u0d2a\u0d4d",
    "\u0d4d\u001d?_x",
    "\u0d4d\u200c\u0d15\u0d4d\u0d38\u0d4d",
    "\u0d4d\u001d?_y",
    "\u0d4d\u200c\u0d2f\u0d4d",
    "\u0d4d\u001d?_[kc]",
    "\u0d4d\u200c\u0d15\u0d4d",
    "\u0d4d\u001d?_[qQ]",
    "\u0d4d\u200c\u0d16\u0d4d",
    "\u0d4d\u001d?_[fF]",
    "\u0d4d\u200c\u0d2b\u0d4d",
    "\u0d4d\u001d?_[VW]",
    "\u0d4d\u200c\u0d35\u0d4d\u0d35\u0d4d",
    "\u0d4d\u001d?_[vw]",
    "\u0d4d\u200c\u0d35\u0d4d",
    "\u0d4d\u001d?_[zS]",
    "\u0d4d\u200c\u0d36\u0d4d",
    "\u0d33\u0d4d\u001d?_",
    "\u0d7e",
    "\u0d23\u0d4d\u001d?_",
    "\u0d7a",
    "\u0d32\u0d4d\u001d?_",
    "\u0d7d",
    "\u0d2e\u0d4d\u001d?_",
    "\u0d02",
    "\u0d28\u0d4d\u001d?_",
    "\u0d7b",
    "\u0d30\u0d4d\u001d?_",
    "\u0d7c",
    "\u0d4d\u001d?a",
    "",
    "\u0d4d\u001d?e",
    "\u0d46",
    "\u0d4d\u001d?i",
    "\u0d3f",
    "\u0d4d\u001d?o",
    "\u0d4a",
    "\u0d4d\u001d?u",
    "\u0d41",
    "\u0d4d\u001d?~",
    "\u0d4d",
    "\u0d4d\u001d?~A",
    "\u0d4d\u0d06",
    "\u0d4d\u001d?~E",
    "\u0d4d\u0d0f",
    "\u0d4d\u001d?~I",
    "\u0d4d\u0d08",
    "\u0d4d\u001d?~O",
    "\u0d4d\u0d13",
    "\u0d4d\u001d?~R",
    "\u0d4d\u0d0b",
    "\u0d4d\u001d?~U",
    "\u0d4d\u0d0a",
    "\u0d4d\u001d?~a",
    "\u0d4d\u0d05",
    "\u0d4d\u001d?~e",
    "\u0d4d\u0d0e",
    "\u0d4d\u001d?~i",
    "\u0d4d\u0d07",
    "\u0d4d\u001d?~o",
    "\u0d4d\u0d12",
    "\u0d4d\u001d?~u",
    "\u0d4d\u0d09",
    "\u0d57\u001d?#",
    "\u0d4c",
    "\u0d57\u001d?[uieIuUou]",
    "\u0d57\u0d57",
    "\u0d7a\u001d?A",
    "\u0d23\u0d3e",
    "\u0d7a\u001d?D",
    "\u0d23\u0d4d\u0d21\u0d4d",
    "\u0d7a\u001d?E",
    "\u0d23\u0d47",
    "\u0d7a\u001d?I",
    "\u0d23\u0d40",
    "\u0d7a\u001d?N",
    "\u0d23\u0d4d\u0d23\u0d4d",
    "\u0d7a\u001d?O",
    "\u0d23\u0d4b",
    "\u0d7a\u001d?U",
    "\u0d23\u0d42",
    "\u0d7a\u001d?a",
    "\u0d23",
    "\u0d7a\u001d?e",
    "\u0d23\u0d46",
    "\u0d7a\u001d?i",
    "\u0d23\u0d3f",
    "\u0d7a\u001d?m",
    "\u0d23\u0d4d\u0d2e\u0d4d",
    "\u0d7a\u001d?o",
    "\u0d23\u0d4a",
    "\u0d7a\u001d?R",
    "\u0d23\u0d43",
    "\u0d7a\u001d?u",
    "\u0d23\u0d41",
    "\u0d7a\u001d?v",
    "\u0d23\u0d4d\u0d35\u0d4d",
    "\u0d7a\u001d?y",
    "\u0d23\u0d4d\u0d2f\u0d4d",
    "\u0d7b\u001d?A",
    "\u0d28\u0d3e",
    "\u0d7b\u001d?E",
    "\u0d28\u0d47",
    "\u0d7b\u001d?I",
    "\u0d28\u0d40",
    "\u0d7b\u001d?O",
    "\u0d28\u0d4b",
    "\u0d7b\u001d?U",
    "\u0d28\u0d42",
    "\u0d7b\u001d?a",
    "\u0d28",
    "\u0d7b\u001d?d",
    "\u0d28\u0d4d\u0d26\u0d4d",
    "\u0d7b\u001d?e",
    "\u0d28\u0d46",
    "\u0d7b\u001d?g",
    "\u0d19\u0d4d",
    "\u0d7b\u001d?i",
    "\u0d28\u0d3f",
    "\u0d7b\u001d?m",
    "\u0d28\u0d4d\u0d2e\u0d4d",
    "\u0d7b\u001d?n",
    "\u0d28\u0d4d\u0d28\u0d4d",
    "\u0d7b\u001d?o",
    "\u0d28\u0d4a",
    "\u0d7b\u001d?r",
    "\u0d28\u0d4d\u0d30\u0d4d",
    "\u0d7b\u001d?R",
    "\u0d28\u0d43",
    "\u0d7b\u001d?u",
    "\u0d28\u0d41",
    "\u0d7b\u001d?v",
    "\u0d28\u0d4d\u0d35\u0d4d",
    "\u0d7b\u001d?y",
    "\u0d28\u0d4d\u0d2f\u0d4d",
    "\u0d7c\u001d?#",
    "\u0d4e",
    "\u0d7c\u001d?A",
    "\u0d30\u0d3e",
    "\u0d7c\u001d?E",
    "\u0d30\u0d47",
    "\u0d7c\u001d?I",
    "\u0d30\u0d40",
    "\u0d7c\u001d?O",
    "\u0d30\u0d4b",
    "\u0d7c\u001d?U",
    "\u0d30\u0d42",
    "\u0d7c\u001d?a",
    "\u0d30",
    "\u0d7c\u001d?e",
    "\u0d30\u0d46",
    "\u0d7c\u001d?i",
    "\u0d30\u0d3f",
    "\u0d7c\u001d?o",
    "\u0d30\u0d4a",
    "\u0d7c\u001d?R",
    "\u0d30\u0d43",
    "\u0d7c\u001d?u",
    "\u0d30\u0d41",
    "\u0d7c\u001d?y",
    "\u0d30\u0d4d\u0d2f\u0d4d",
    "\u0d7d\u001d?A",
    "\u0d32\u0d3e",
    "\u0d7d\u001d?E",
    "\u0d32\u0d47",
    "\u0d7d\u001d?I",
    "\u0d32\u0d40",
    "\u0d7d\u001d?O",
    "\u0d32\u0d4b",
    "\u0d7d\u001d?U",
    "\u0d32\u0d42",
    "\u0d7d\u001d?[lL]",
    "\u0d32\u0d4d\u0d32\u0d4d",
    "\u0d7d\u001d?a",
    "\u0d32",
    "\u0d7d\u001d?e",
    "\u0d32\u0d46",
    "\u0d7d\u001d?i",
    "\u0d32\u0d3f",
    "\u0d7d\u001d?m",
    "\u0d32\u0d4d\u0d2e\u0d4d",
    "\u0d7d\u001d?o",
    "\u0d32\u0d4a",
    "\u0d7d\u001d?p",
    "\u0d32\u0d4d\u0d2a\u0d4d",
    "\u0d7d\u001d?R",
    "\u0d32\u0d43",
    "\u0d7d\u001d?u",
    "\u0d32\u0d41",
    "\u0d7d\u001d?v",
    "\u0d32\u0d4d\u0d35\u0d4d",
    "\u0d7d\u001d?y",
    "\u0d32\u0d4d\u0d2f\u0d4d",
    "\u0d7e\u001d?A",
    "\u0d33\u0d3e",
    "\u0d7e\u001d?E",
    "\u0d33\u0d47",
    "\u0d7e\u001d?I",
    "\u0d33\u0d40",
    "\u0d7e\u001d?O",
    "\u0d33\u0d4b",
    "\u0d7e\u001d?U",
    "\u0d33\u0d42",
    "\u0d7e\u001d?a",
    "\u0d33",
    "\u0d7e\u001d?e",
    "\u0d33\u0d46",
    "\u0d7e\u001d?i",
    "\u0d33\u0d3f",
    "\u0d7e\u001d?o",
    "\u0d33\u0d4a",
    "\u0d7e\u001d?R",
    "\u0d33\u0d43",
    "\u0d7e\u001d?u",
    "\u0d33\u0d41",
    "\u0d7e\u001d?y",
    "\u0d33\u0d4d\u0d2f\u0d4d",
    "_?E",
    "\u0d0f",
    "_?O",
    "\u0d13",
    "_?R",
    "\u0d0b",
    "_?a",
    "\u0d05",
    "_?e",
    "\u0d0e",
    "_?i",
    "\u0d07",
    "_?o",
    "\u0d12",
    "_?u",
    "\u0d09",
    "cch",
    "\u0d1a\u0d4d\u0d1a\u0d4d",
    "cchh",
    "\u0d1a\u0d4d\u0d1b\u0d4d",
    "ch",
    "\u0d1a\u0d4d",
    "t",
    "\u0d31\u0d4d\u0d31\u0d4d",
    "L",
    "\u0d7e",
    "N",
    "\u0d7a",
    "l",
    "\u0d7d",
    "m",
    "\u0d02",
    "n",
    "\u0d7b",
    "r",
    "\u0d7c"};
const unsigned int kTransformsLen = std::size(kTransforms);
const char* kHistoryPrune = "a|@|@a|c|R|_|~";

}  // namespace ml_phone
