// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ash/services/ime/public/cpp/rulebased/def/lo.h"

namespace lo {

const char* kId = "lo";
bool kIs102 = false;
const char* kNormal[] = {
    "*",       // BackQuote
    "\u0ea2",  // Digit1
    "\u0e9f",  // Digit2
    "\u0ec2",  // Digit3
    "\u0e96",  // Digit4
    "\u0eb8",  // Digit5
    "\u0eb9",  // Digit6
    "\u0e84",  // Digit7
    "\u0e95",  // Digit8
    "\u0e88",  // Digit9
    "\u0e82",  // Digit0
    "\u0e8a",  // Minus
    "\u0ecd",  // Equal
    "\u0ebb",  // KeyQ
    "\u0ec4",  // KeyW
    "\u0eb3",  // KeyE
    "\u0e9e",  // KeyR
    "\u0eb0",  // KeyT
    "\u0eb4",  // KeyY
    "\u0eb5",  // KeyU
    "\u0eae",  // KeyI
    "\u0e99",  // KeyO
    "\u0e8d",  // KeyP
    "\u0e9a",  // BracketLeft
    "\u0ea5",  // BracketRight
    "\u201c",  // Backslash
    "\u0eb1",  // KeyA
    "\u0eab",  // KeyS
    "\u0e81",  // KeyD
    "\u0e94",  // KeyF
    "\u0ec0",  // KeyG
    "\u0ec9",  // KeyH
    "\u0ec8",  // KeyJ
    "\u0eb2",  // KeyK
    "\u0eaa",  // KeyL
    "\u0ea7",  // Semicolon
    "\u0e87",  // Quote
    "\u0e9c",  // KeyZ
    "\u0e9b",  // KeyX
    "\u0ec1",  // KeyC
    "\u0ead",  // KeyV
    "\u0eb6",  // KeyB
    "\u0eb7",  // KeyN
    "\u0e97",  // KeyM
    "\u0ea1",  // Comma
    "\u0ec3",  // Period
    "\u0e9d",  // Slash
    "\u0020",  // Space
};
const char* kShift[] = {
    "/",             // BackQuote
    "1",             // Digit1
    "2",             // Digit2
    "3",             // Digit3
    "4",             // Digit4
    "\u0ecc",        // Digit5
    "\u0ebc",        // Digit6
    "5",             // Digit7
    "6",             // Digit8
    "7",             // Digit9
    "8",             // Digit0
    "9",             // Minus
    "\u0ecd\u0ec8",  // Equal
    "\u0ebb\u0ec9",  // KeyQ
    "0",             // KeyW
    "\u0eb3\u0ec9",  // KeyE
    "_",             // KeyR
    "+",             // KeyT
    "\u0eb4\u0ec9",  // KeyY
    "\u0eb5\u0ec9",  // KeyU
    "\u0ea3",        // KeyI
    "\u0edc",        // KeyO
    "\u0ebd",        // KeyP
    "-",             // BracketLeft
    "\u0eab\u0ebc",  // BracketRight
    "\u201d",        // Backslash
    "\u0eb1\u0ec9",  // KeyA
    ";",             // KeyS
    ".",             // KeyD
    ",",             // KeyF
    ":",             // KeyG
    "\u0eca",        // KeyH
    "\u0ecb",        // KeyJ
    "!",             // KeyK
    "?",             // KeyL
    "%",             // Semicolon
    "=",             // Quote
    "\u20ad",        // KeyZ
    "(",             // KeyX
    "\u0eaf",        // KeyC
    "x",             // KeyV
    "\u0eb6\u0ec9",  // KeyB
    "\u0eb7\u0ec9",  // KeyN
    "\u0ec6",        // KeyM
    "\u0edd",        // Comma
    "$",             // Period
    ")",             // Slash
    "\u0020",        // Space
};
const char* kAltGr[] = {
    "",        // BackQuote
    "\u0ed1",  // Digit1
    "\u0ed2",  // Digit2
    "\u0ed3",  // Digit3
    "\u0ed4",  // Digit4
    "\u0ed5",  // Digit5
    "\u0ed6",  // Digit6
    "\u0ed7",  // Digit7
    "\u0ed8",  // Digit8
    "\u0ed9",  // Digit9
    "\u0ed0",  // Digit0
    "",        // Minus
    "",        // Equal
    "",        // KeyQ
    "",        // KeyW
    "",        // KeyE
    "",        // KeyR
    "",        // KeyT
    "",        // KeyY
    "",        // KeyU
    "",        // KeyI
    "",        // KeyO
    "",        // KeyP
    "",        // BracketLeft
    "",        // BracketRight
    "",        // Backslash
    "",        // KeyA
    "",        // KeyS
    "",        // KeyD
    "",        // KeyF
    "",        // KeyG
    "",        // KeyH
    "",        // KeyJ
    "",        // KeyK
    "",        // KeyL
    "",        // Semicolon
    "",        // Quote
    "",        // KeyZ
    "",        // KeyX
    "",        // KeyC
    "",        // KeyV
    "",        // KeyB
    "",        // KeyN
    "",        // KeyM
    "",        // Comma
    "",        // Period
    "",        // Slash
    "\u0020",  // Space
};
const char* kCapslock[] = {
    "*",       // BackQuote
    "\u0ea2",  // Digit1
    "\u0e9f",  // Digit2
    "\u0ec2",  // Digit3
    "\u0e96",  // Digit4
    "\u0eb8",  // Digit5
    "\u0eb9",  // Digit6
    "\u0e84",  // Digit7
    "\u0e95",  // Digit8
    "\u0e88",  // Digit9
    "\u0e82",  // Digit0
    "\u0e8a",  // Minus
    "\u0ecd",  // Equal
    "\u0ebb",  // KeyQ
    "\u0ec4",  // KeyW
    "\u0eb3",  // KeyE
    "\u0e9e",  // KeyR
    "\u0eb0",  // KeyT
    "\u0eb4",  // KeyY
    "\u0eb5",  // KeyU
    "\u0eae",  // KeyI
    "\u0e99",  // KeyO
    "\u0e8d",  // KeyP
    "\u0e9a",  // BracketLeft
    "\u0ea5",  // BracketRight
    "\u201c",  // Backslash
    "\u0eb1",  // KeyA
    "\u0eab",  // KeyS
    "\u0e81",  // KeyD
    "\u0e94",  // KeyF
    "\u0ec0",  // KeyG
    "\u0ec9",  // KeyH
    "\u0ec8",  // KeyJ
    "\u0eb2",  // KeyK
    "\u0eaa",  // KeyL
    "\u0ea7",  // Semicolon
    "\u0e87",  // Quote
    "\u0e9c",  // KeyZ
    "\u0e9b",  // KeyX
    "\u0ec1",  // KeyC
    "\u0ead",  // KeyV
    "\u0eb6",  // KeyB
    "\u0eb7",  // KeyN
    "\u0e97",  // KeyM
    "\u0ea1",  // Comma
    "\u0ec3",  // Period
    "\u0e9d",  // Slash
    "\u0020",  // Space
};
const char* kAltgrCapslock[] = {
    "",        // BackQuote
    "\u0ed1",  // Digit1
    "\u0ed2",  // Digit2
    "\u0ed3",  // Digit3
    "\u0ed4",  // Digit4
    "\u0ed5",  // Digit5
    "\u0ed6",  // Digit6
    "\u0ed7",  // Digit7
    "\u0ed8",  // Digit8
    "\u0ed9",  // Digit9
    "\u0ed0",  // Digit0
    "",        // Minus
    "",        // Equal
    "",        // KeyQ
    "",        // KeyW
    "",        // KeyE
    "",        // KeyR
    "",        // KeyT
    "",        // KeyY
    "",        // KeyU
    "",        // KeyI
    "",        // KeyO
    "",        // KeyP
    "",        // BracketLeft
    "",        // BracketRight
    "",        // Backslash
    "",        // KeyA
    "",        // KeyS
    "",        // KeyD
    "",        // KeyF
    "",        // KeyG
    "",        // KeyH
    "",        // KeyJ
    "",        // KeyK
    "",        // KeyL
    "",        // Semicolon
    "",        // Quote
    "",        // KeyZ
    "",        // KeyX
    "",        // KeyC
    "",        // KeyV
    "",        // KeyB
    "",        // KeyN
    "",        // KeyM
    "",        // Comma
    "",        // Period
    "",        // Slash
    "\u0020",  // Space
};
const char* kShiftCapslock[] = {
    "/",             // BackQuote
    "1",             // Digit1
    "2",             // Digit2
    "3",             // Digit3
    "4",             // Digit4
    "\u0ecc",        // Digit5
    "\u0ebc",        // Digit6
    "5",             // Digit7
    "6",             // Digit8
    "7",             // Digit9
    "8",             // Digit0
    "9",             // Minus
    "\u0ecd\u0ec8",  // Equal
    "\u0ebb\u0ec9",  // KeyQ
    "0",             // KeyW
    "\u0eb3\u0ec9",  // KeyE
    "_",             // KeyR
    "+",             // KeyT
    "\u0eb4\u0ec9",  // KeyY
    "\u0eb5\u0ec9",  // KeyU
    "\u0ea3",        // KeyI
    "\u0edc",        // KeyO
    "\u0ebd",        // KeyP
    "-",             // BracketLeft
    "\u0eab\u0ebc",  // BracketRight
    "\u201d",        // Backslash
    "\u0eb1\u0ec9",  // KeyA
    ";",             // KeyS
    ".",             // KeyD
    ",",             // KeyF
    ":",             // KeyG
    "\u0eca",        // KeyH
    "\u0ecb",        // KeyJ
    "!",             // KeyK
    "?",             // KeyL
    "%",             // Semicolon
    "=",             // Quote
    "\u20ad",        // KeyZ
    "(",             // KeyX
    "\u0eaf",        // KeyC
    "x",             // KeyV
    "\u0eb6\u0ec9",  // KeyB
    "\u0eb7\u0ec9",  // KeyN
    "\u0ec6",        // KeyM
    "\u0edd",        // Comma
    "$",             // Period
    ")",             // Slash
    "\u0020",        // Space
};
const char** kKeyMap[8] = {kNormal,        kShift,        kAltGr,
                           kAltGr,         kCapslock,     kShiftCapslock,
                           kAltgrCapslock, kAltgrCapslock};

}  // namespace lo
