// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ash/services/ime/public/cpp/rulebased/def/km.h"

namespace km {

const char* kId = "km";
bool kIs102 = false;
const char* kNormal[] = {
    "\u00ab",        // BackQuote
    "\u17e1",        // Digit1
    "\u17e2",        // Digit2
    "\u17e3",        // Digit3
    "\u17e4",        // Digit4
    "\u17e5",        // Digit5
    "\u17e6",        // Digit6
    "\u17e7",        // Digit7
    "\u17e8",        // Digit8
    "\u17e9",        // Digit9
    "\u17e0",        // Digit0
    "\u17a5",        // Minus
    "\u17b2",        // Equal
    "\u1786",        // KeyQ
    "\u17b9",        // KeyW
    "\u17c1",        // KeyE
    "\u179a",        // KeyR
    "\u178f",        // KeyT
    "\u1799",        // KeyY
    "\u17bb",        // KeyU
    "\u17b7",        // KeyI
    "\u17c4",        // KeyO
    "\u1795",        // KeyP
    "\u17c0",        // BracketLeft
    "\u17aa",        // BracketRight
    "\u17ae",        // Backslash
    "\u17b6",        // KeyA
    "\u179f",        // KeyS
    "\u178a",        // KeyD
    "\u1790",        // KeyF
    "\u1784",        // KeyG
    "\u17a0",        // KeyH
    "\u17d2",        // KeyJ
    "\u1780",        // KeyK
    "\u179b",        // KeyL
    "\u17be",        // Semicolon
    "\u17cb",        // Quote
    "\u178b",        // KeyZ
    "\u1781",        // KeyX
    "\u1785",        // KeyC
    "\u179c",        // KeyV
    "\u1794",        // KeyB
    "\u1793",        // KeyN
    "\u1798",        // KeyM
    "\u17bb\u17c6",  // Comma
    "\u17d4",        // Period
    "\u17ca",        // Slash
    "\u200b",        // Space
};
const char* kShift[] = {
    "\u00bb",        // BackQuote
    "!",             // Digit1
    "\u17d7",        // Digit2
    "\"",            // Digit3
    "\u17db",        // Digit4
    "%",             // Digit5
    "\u17cd",        // Digit6
    "\u17d0",        // Digit7
    "\u17cf",        // Digit8
    "(",             // Digit9
    ")",             // Digit0
    "\u17cc",        // Minus
    "=",             // Equal
    "\u1788",        // KeyQ
    "\u17ba",        // KeyW
    "\u17c2",        // KeyE
    "\u17ac",        // KeyR
    "\u1791",        // KeyT
    "\u17bd",        // KeyY
    "\u17bc",        // KeyU
    "\u17b8",        // KeyI
    "\u17c5",        // KeyO
    "\u1797",        // KeyP
    "\u17bf",        // BracketLeft
    "\u17a7",        // BracketRight
    "\u17ad",        // Backslash
    "\u17b6\u17c6",  // KeyA
    "\u17c3",        // KeyS
    "\u178c",        // KeyD
    "\u1792",        // KeyF
    "\u17a2",        // KeyG
    "\u17c7",        // KeyH
    "\u1789",        // KeyJ
    "\u1782",        // KeyK
    "\u17a1",        // KeyL
    "\u17c4\u17c7",  // Semicolon
    "\u17c9",        // Quote
    "\u178d",        // KeyZ
    "\u1783",        // KeyX
    "\u1787",        // KeyC
    "\u17c1\u17c7",  // KeyV
    "\u1796",        // KeyB
    "\u178e",        // KeyN
    "\u17c6",        // KeyM
    "\u17bb\u17c7",  // Comma
    "\u17d5",        // Period
    "?",             // Slash
    "\u0020",        // Space
};
const char* kAltGr[] = {
    "\u200d",  // BackQuote
    "\u200c",  // Digit1
    "@",       // Digit2
    "\u17d1",  // Digit3
    "$",       // Digit4
    "\u20ac",  // Digit5
    "\u17d9",  // Digit6
    "\u17da",  // Digit7
    "*",       // Digit8
    "{",       // Digit9
    "}",       // Digit0
    "\u00d7",  // Minus
    "\u17ce",  // Equal
    "\u17dc",  // KeyQ
    "\u17dd",  // KeyW
    "\u17af",  // KeyE
    "\u17ab",  // KeyR
    "\u17a8",  // KeyT
    "",        // KeyY
    "",        // KeyU
    "\u17a6",  // KeyI
    "\u17b1",  // KeyO
    "\u17b0",  // KeyP
    "\u17a9",  // BracketLeft
    "\u17b3",  // BracketRight
    "\\",      // Backslash
    "+",       // KeyA
    "-",       // KeyS
    "",        // KeyD
    "",        // KeyF
    "",        // KeyG
    "",        // KeyH
    "",        // KeyJ
    "\u179d",  // KeyK
    "",        // KeyL
    "\u17d6",  // Semicolon
    "\u17c8",  // Quote
    "",        // KeyZ
    "",        // KeyX
    "",        // KeyC
    "",        // KeyV
    "\u179e",  // KeyB
    "",        // KeyN
    "",        // KeyM
    ",",       // Comma
    ".",       // Period
    "/",       // Slash
    "\u0020",  // Space
};
const char* kCapslock[] = {
    "\u00bb",        // BackQuote
    "!",             // Digit1
    "\u17d7",        // Digit2
    "\"",            // Digit3
    "\u17db",        // Digit4
    "%",             // Digit5
    "\u17cd",        // Digit6
    "\u17d0",        // Digit7
    "\u17cf",        // Digit8
    "(",             // Digit9
    ")",             // Digit0
    "\u17cc",        // Minus
    "=",             // Equal
    "\u1788",        // KeyQ
    "\u17ba",        // KeyW
    "\u17c2",        // KeyE
    "\u17ac",        // KeyR
    "\u1791",        // KeyT
    "\u17bd",        // KeyY
    "\u17bc",        // KeyU
    "\u17b8",        // KeyI
    "\u17c5",        // KeyO
    "\u1797",        // KeyP
    "\u17bf",        // BracketLeft
    "\u17a7",        // BracketRight
    "\u17ad",        // Backslash
    "\u17b6\u17c6",  // KeyA
    "\u17c3",        // KeyS
    "\u178c",        // KeyD
    "\u1792",        // KeyF
    "\u17a2",        // KeyG
    "\u17c7",        // KeyH
    "\u1789",        // KeyJ
    "\u1782",        // KeyK
    "\u17a1",        // KeyL
    "\u17c4\u17c7",  // Semicolon
    "\u17c9",        // Quote
    "\u178d",        // KeyZ
    "\u1783",        // KeyX
    "\u1787",        // KeyC
    "\u17c1\u17c7",  // KeyV
    "\u1796",        // KeyB
    "\u178e",        // KeyN
    "\u17c6",        // KeyM
    "\u17bb\u17c7",  // Comma
    "\u17d5",        // Period
    "?",             // Slash
    "\u0020",        // Space
};
const char* kShiftAltGr[] = {
    "",        // BackQuote
    "\u17f1",  // Digit1
    "\u17f2",  // Digit2
    "\u17f3",  // Digit3
    "\u17f4",  // Digit4
    "\u17f5",  // Digit5
    "\u17f6",  // Digit6
    "\u17f7",  // Digit7
    "\u17f8",  // Digit8
    "\u17f9",  // Digit9
    "\u17f0",  // Digit0
    "",        // Minus
    "",        // Equal
    "\u19e0",  // KeyQ
    "\u19e1",  // KeyW
    "\u19e2",  // KeyE
    "\u19e3",  // KeyR
    "\u19e4",  // KeyT
    "\u19e5",  // KeyY
    "\u19e6",  // KeyU
    "\u19e7",  // KeyI
    "\u19e8",  // KeyO
    "\u19e9",  // KeyP
    "\u19ea",  // BracketLeft
    "\u19eb",  // BracketRight
    "",        // Backslash
    "\u19ec",  // KeyA
    "\u19ed",  // KeyS
    "\u19ee",  // KeyD
    "\u19ef",  // KeyF
    "\u19f0",  // KeyG
    "\u19f1",  // KeyH
    "\u19f2",  // KeyJ
    "\u19f3",  // KeyK
    "\u19f4",  // KeyL
    "\u19f5",  // Semicolon
    "\u19f6",  // Quote
    "\u19f7",  // KeyZ
    "\u19f8",  // KeyX
    "\u19f9",  // KeyC
    "\u19fa",  // KeyV
    "\u19fb",  // KeyB
    "\u19fc",  // KeyN
    "\u19fd",  // KeyM
    "\u19fe",  // Comma
    "\u19ff",  // Period
    "",        // Slash
    "\u0020",  // Space
};
const char* kAltgrCapslock[] = {
    "",        // BackQuote
    "\u17f1",  // Digit1
    "\u17f2",  // Digit2
    "\u17f3",  // Digit3
    "\u17f4",  // Digit4
    "\u17f5",  // Digit5
    "\u17f6",  // Digit6
    "\u17f7",  // Digit7
    "\u17f8",  // Digit8
    "\u17f9",  // Digit9
    "\u17f0",  // Digit0
    "",        // Minus
    "",        // Equal
    "\u19e0",  // KeyQ
    "\u19e1",  // KeyW
    "\u19e2",  // KeyE
    "\u19e3",  // KeyR
    "\u19e4",  // KeyT
    "\u19e5",  // KeyY
    "\u19e6",  // KeyU
    "\u19e7",  // KeyI
    "\u19e8",  // KeyO
    "\u19e9",  // KeyP
    "\u19ea",  // BracketLeft
    "\u19eb",  // BracketRight
    "",        // Backslash
    "\u19ec",  // KeyA
    "\u19ed",  // KeyS
    "\u19ee",  // KeyD
    "\u19ef",  // KeyF
    "\u19f0",  // KeyG
    "\u19f1",  // KeyH
    "\u19f2",  // KeyJ
    "\u19f3",  // KeyK
    "\u19f4",  // KeyL
    "\u19f5",  // Semicolon
    "\u19f6",  // Quote
    "\u19f7",  // KeyZ
    "\u19f8",  // KeyX
    "\u19f9",  // KeyC
    "\u19fa",  // KeyV
    "\u19fb",  // KeyB
    "\u19fc",  // KeyN
    "\u19fd",  // KeyM
    "\u19fe",  // Comma
    "\u19ff",  // Period
    "",        // Slash
    "\u0020",  // Space
};
const char* kShiftCapslock[] = {
    "\u00ab",        // BackQuote
    "\u17e1",        // Digit1
    "\u17e2",        // Digit2
    "\u17e3",        // Digit3
    "\u17e4",        // Digit4
    "\u17e5",        // Digit5
    "\u17e6",        // Digit6
    "\u17e7",        // Digit7
    "\u17e8",        // Digit8
    "\u17e9",        // Digit9
    "\u17e0",        // Digit0
    "\u17a5",        // Minus
    "\u17b2",        // Equal
    "\u1786",        // KeyQ
    "\u17b9",        // KeyW
    "\u17c1",        // KeyE
    "\u179a",        // KeyR
    "\u178f",        // KeyT
    "\u1799",        // KeyY
    "\u17bb",        // KeyU
    "\u17b7",        // KeyI
    "\u17c4",        // KeyO
    "\u1795",        // KeyP
    "\u17c0",        // BracketLeft
    "\u17aa",        // BracketRight
    "\u17ae",        // Backslash
    "\u17b6",        // KeyA
    "\u179f",        // KeyS
    "\u178a",        // KeyD
    "\u1790",        // KeyF
    "\u1784",        // KeyG
    "\u17a0",        // KeyH
    "\u17d2",        // KeyJ
    "\u1780",        // KeyK
    "\u179b",        // KeyL
    "\u17be",        // Semicolon
    "\u17cb",        // Quote
    "\u178b",        // KeyZ
    "\u1781",        // KeyX
    "\u1785",        // KeyC
    "\u179c",        // KeyV
    "\u1794",        // KeyB
    "\u1793",        // KeyN
    "\u1798",        // KeyM
    "\u17bb\u17c6",  // Comma
    "\u17d4",        // Period
    "\u17ca",        // Slash
    "\u200b",        // Space
};
const char* kShiftAltGrCapslock[] = {
    "\u200d",  // BackQuote
    "\u200c",  // Digit1
    "@",       // Digit2
    "\u17d1",  // Digit3
    "$",       // Digit4
    "\u20ac",  // Digit5
    "\u17d9",  // Digit6
    "\u17da",  // Digit7
    "*",       // Digit8
    "{",       // Digit9
    "}",       // Digit0
    "\u00d7",  // Minus
    "\u17ce",  // Equal
    "\u17dc",  // KeyQ
    "\u17dd",  // KeyW
    "\u17af",  // KeyE
    "\u17ab",  // KeyR
    "\u17a8",  // KeyT
    "",        // KeyY
    "",        // KeyU
    "\u17a6",  // KeyI
    "\u17b1",  // KeyO
    "\u17b0",  // KeyP
    "\u17a9",  // BracketLeft
    "\u17b3",  // BracketRight
    "\\",      // Backslash
    "+",       // KeyA
    "-",       // KeyS
    "",        // KeyD
    "",        // KeyF
    "",        // KeyG
    "",        // KeyH
    "",        // KeyJ
    "\u179d",  // KeyK
    "",        // KeyL
    "\u17d6",  // Semicolon
    "\u17c8",  // Quote
    "",        // KeyZ
    "",        // KeyX
    "",        // KeyC
    "",        // KeyV
    "\u179e",  // KeyB
    "",        // KeyN
    "",        // KeyM
    ",",       // Comma
    ".",       // Period
    "/",       // Slash
    "\u0020",  // Space
};
const char** kKeyMap[8] = {
    kNormal,   kShift,         kAltGr,         kShiftAltGr,
    kCapslock, kShiftCapslock, kAltgrCapslock, kShiftAltGrCapslock};

}  // namespace km
