// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ash/services/ime/public/cpp/rulebased/def/fa.h"

namespace fa {

const char* kId = "fa";
bool kIs102 = false;
const char* kNormal[] = {
    "\u200d",  // BackQuote
    "\u06f1",  // Digit1
    "\u06f2",  // Digit2
    "\u06f3",  // Digit3
    "\u06f4",  // Digit4
    "\u06f5",  // Digit5
    "\u06f6",  // Digit6
    "\u06f7",  // Digit7
    "\u06f8",  // Digit8
    "\u06f9",  // Digit9
    "\u06f0",  // Digit0
    "-",       // Minus
    "=",       // Equal
    "\u0636",  // KeyQ
    "\u0635",  // KeyW
    "\u062b",  // KeyE
    "\u0642",  // KeyR
    "\u0641",  // KeyT
    "\u063a",  // KeyY
    "\u0639",  // KeyU
    "\u0647",  // KeyI
    "\u062e",  // KeyO
    "\u062d",  // KeyP
    "\u062c",  // BracketLeft
    "\u0686",  // BracketRight
    "\\",      // Backslash
    "\u0634",  // KeyA
    "\u0633",  // KeyS
    "\u06cc",  // KeyD
    "\u0628",  // KeyF
    "\u0644",  // KeyG
    "\u0627",  // KeyH
    "\u062a",  // KeyJ
    "\u0646",  // KeyK
    "\u0645",  // KeyL
    "\u06a9",  // Semicolon
    "\u06af",  // Quote
    "\u0638",  // KeyZ
    "\u0637",  // KeyX
    "\u0632",  // KeyC
    "\u0631",  // KeyV
    "\u0630",  // KeyB
    "\u062f",  // KeyN
    "\u067e",  // KeyM
    "\u0648",  // Comma
    ".",       // Period
    "/",       // Slash
    "\u0020",  // Space
};
const char* kShift[] = {
    "",                          // BackQuote
    "!",                         // Digit1
    "\u066c",                    // Digit2
    "\u066b",                    // Digit3
    "\u0631\u06cc\u0627\u0644",  // Digit4
    "\u066a",                    // Digit5
    "\u00d7",                    // Digit6
    "\u060c",                    // Digit7
    "*",                         // Digit8
    ")",                         // Digit9
    "(",                         // Digit0
    "\u0640",                    // Minus
    "+",                         // Equal
    "\u0652",                    // KeyQ
    "\u064c",                    // KeyW
    "\u064d",                    // KeyE
    "\u064b",                    // KeyR
    "\u064f",                    // KeyT
    "\u0650",                    // KeyY
    "\u064e",                    // KeyU
    "\u0651",                    // KeyI
    "]",                         // KeyO
    "[",                         // KeyP
    "}",                         // BracketLeft
    "{",                         // BracketRight
    "|",                         // Backslash
    "\u0624",                    // KeyA
    "\u0626",                    // KeyS
    "\u064a",                    // KeyD
    "\u0625",                    // KeyF
    "\u0623",                    // KeyG
    "\u0622",                    // KeyH
    "\u0629",                    // KeyJ
    "\u00bb",                    // KeyK
    "\u00ab",                    // KeyL
    ":",                         // Semicolon
    "\u061b",                    // Quote
    "\u0643",                    // KeyZ
    "",                          // KeyX
    "\u0698",                    // KeyC
    "",                          // KeyV
    "\u200c",                    // KeyB
    "",                          // KeyN
    "\u0621",                    // KeyM
    "<",                         // Comma
    ">",                         // Period
    "\u061f",                    // Slash
    "\u200c",                    // Space
};
const char* kAltGr[] = {
    "~",       // BackQuote
    "`",       // Digit1
    "@",       // Digit2
    "#",       // Digit3
    "$",       // Digit4
    "%",       // Digit5
    "^",       // Digit6
    "&",       // Digit7
    "\u2022",  // Digit8
    "\u200e",  // Digit9
    "\u200f",  // Digit0
    "_",       // Minus
    "\u2212",  // Equal
    "\u00b0",  // KeyQ
    "",        // KeyW
    "\u20ac",  // KeyE
    "",        // KeyR
    "",        // KeyT
    "",        // KeyY
    "",        // KeyU
    "\u202d",  // KeyI
    "\u202e",  // KeyO
    "\u202c",  // KeyP
    "\u202a",  // BracketLeft
    "\u202b",  // BracketRight
    "\u2010",  // Backslash
    "",        // KeyA
    "",        // KeyS
    "\u0649",  // KeyD
    "",        // KeyF
    "",        // KeyG
    "\u0671",  // KeyH
    "",        // KeyJ
    "\ufd3e",  // KeyK
    "\ufd3f",  // KeyL
    ";",       // Semicolon
    "\"",      // Quote
    "\u00a0",  // KeyZ
    "",        // KeyX
    "",        // KeyC
    "\u0656",  // KeyV
    "\u200d",  // KeyB
    "\u0655",  // KeyN
    "\u2026",  // KeyM
    ",",       // Comma
    "'",       // Period
    "?",       // Slash
    "\u0020",  // Space
};
const char* kCapslock[] = {
    "\u200d",  // BackQuote
    "\u06f1",  // Digit1
    "\u06f2",  // Digit2
    "\u06f3",  // Digit3
    "\u06f4",  // Digit4
    "\u06f5",  // Digit5
    "\u06f6",  // Digit6
    "\u06f7",  // Digit7
    "\u06f8",  // Digit8
    "\u06f9",  // Digit9
    "\u06f0",  // Digit0
    "-",       // Minus
    "=",       // Equal
    "\u0636",  // KeyQ
    "\u0635",  // KeyW
    "\u062b",  // KeyE
    "\u0642",  // KeyR
    "\u0641",  // KeyT
    "\u063a",  // KeyY
    "\u0639",  // KeyU
    "\u0647",  // KeyI
    "\u062e",  // KeyO
    "\u062d",  // KeyP
    "\u062c",  // BracketLeft
    "\u0686",  // BracketRight
    "\\",      // Backslash
    "\u0634",  // KeyA
    "\u0633",  // KeyS
    "\u06cc",  // KeyD
    "\u0628",  // KeyF
    "\u0644",  // KeyG
    "\u0627",  // KeyH
    "\u062a",  // KeyJ
    "\u0646",  // KeyK
    "\u0645",  // KeyL
    "\u06a9",  // Semicolon
    "\u06af",  // Quote
    "\u0638",  // KeyZ
    "\u0637",  // KeyX
    "\u0632",  // KeyC
    "\u0631",  // KeyV
    "\u0630",  // KeyB
    "\u062f",  // KeyN
    "\u067e",  // KeyM
    "\u0648",  // Comma
    ".",       // Period
    "/",       // Slash
    "\u0020",  // Space
};
const char* kShiftCapslock[] = {
    "",                          // BackQuote
    "!",                         // Digit1
    "\u066c",                    // Digit2
    "\u066b",                    // Digit3
    "\u0631\u06cc\u0627\u0644",  // Digit4
    "\u066a",                    // Digit5
    "\u00d7",                    // Digit6
    "\u060c",                    // Digit7
    "*",                         // Digit8
    ")",                         // Digit9
    "(",                         // Digit0
    "\u0640",                    // Minus
    "+",                         // Equal
    "\u0652",                    // KeyQ
    "\u064c",                    // KeyW
    "\u064d",                    // KeyE
    "\u064b",                    // KeyR
    "\u064f",                    // KeyT
    "\u0650",                    // KeyY
    "\u064e",                    // KeyU
    "\u0651",                    // KeyI
    "]",                         // KeyO
    "[",                         // KeyP
    "}",                         // BracketLeft
    "{",                         // BracketRight
    "|",                         // Backslash
    "\u0624",                    // KeyA
    "\u0626",                    // KeyS
    "\u064a",                    // KeyD
    "\u0625",                    // KeyF
    "\u0623",                    // KeyG
    "\u0622",                    // KeyH
    "\u0629",                    // KeyJ
    "\u00bb",                    // KeyK
    "\u00ab",                    // KeyL
    ":",                         // Semicolon
    "\u061b",                    // Quote
    "\u0643",                    // KeyZ
    "",                          // KeyX
    "\u0698",                    // KeyC
    "",                          // KeyV
    "\u200c",                    // KeyB
    "",                          // KeyN
    "\u0621",                    // KeyM
    "<",                         // Comma
    ">",                         // Period
    "\u061f",                    // Slash
    "\u200c",                    // Space
};
const char** kKeyMap[8] = {kNormal,   kShift,         kAltGr, kAltGr,
                           kCapslock, kShiftCapslock, kAltGr, kShiftCapslock};

}  // namespace fa
