// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ash/services/ime/public/cpp/rulebased/def/ar.h"

namespace ar {

const char* kId = "ar";
bool kIs102 = false;
const char* kNormal[] = {
    "\u0630",        // BackQuote
    "\u0661",        // Digit1
    "\u0662",        // Digit2
    "\u0663",        // Digit3
    "\u0664",        // Digit4
    "\u0665",        // Digit5
    "\u0666",        // Digit6
    "\u0667",        // Digit7
    "\u0668",        // Digit8
    "\u0669",        // Digit9
    "\u0660",        // Digit0
    "-",             // Minus
    "=",             // Equal
    "\u0636",        // KeyQ
    "\u0635",        // KeyW
    "\u062b",        // KeyE
    "\u0642",        // KeyR
    "\u0641",        // KeyT
    "\u063a",        // KeyY
    "\u0639",        // KeyU
    "\u0647",        // KeyI
    "\u062e",        // KeyO
    "\u062d",        // KeyP
    "\u062c",        // BracketLeft
    "\u062f",        // BracketRight
    "\\",            // Backslash
    "\u0634",        // KeyA
    "\u0633",        // KeyS
    "\u064a",        // KeyD
    "\u0628",        // KeyF
    "\u0644",        // KeyG
    "\u0627",        // KeyH
    "\u062a",        // KeyJ
    "\u0646",        // KeyK
    "\u0645",        // KeyL
    "\u0643",        // Semicolon
    "\u0637",        // Quote
    "\u0626",        // KeyZ
    "\u0621",        // KeyX
    "\u0624",        // KeyC
    "\u0631",        // KeyV
    "\u0644\u0627",  // KeyB
    "\u0649",        // KeyN
    "\u0629",        // KeyM
    "\u0648",        // Comma
    "\u0632",        // Period
    "\u0638",        // Slash
    "\u0020",        // Space
};
const char* kShift[] = {
    "\u0651",        // BackQuote
    "!",             // Digit1
    "\"",            // Digit2
    "#",             // Digit3
    "$",             // Digit4
    "%",             // Digit5
    "^",             // Digit6
    "&",             // Digit7
    "*",             // Digit8
    ")",             // Digit9
    "(",             // Digit0
    "_",             // Minus
    "+",             // Equal
    "\u064e",        // KeyQ
    "\u064b",        // KeyW
    "\u064f",        // KeyE
    "\u064c",        // KeyR
    "\u0644\u0625",  // KeyT
    "\u0625",        // KeyY
    "\u2018",        // KeyU
    "\u00f7",        // KeyI
    "\u00d7",        // KeyO
    "\u061b",        // KeyP
    "<",             // BracketLeft
    ">",             // BracketRight
    "|",             // Backslash
    "\u0650",        // KeyA
    "\u064d",        // KeyS
    "]",             // KeyD
    "[",             // KeyF
    "\u0644\u0623",  // KeyG
    "\u0623",        // KeyH
    "\u0640",        // KeyJ
    "\u060c",        // KeyK
    "/",             // KeyL
    ":",             // Semicolon
    "@",             // Quote
    "~",             // KeyZ
    "\u0652",        // KeyX
    "}",             // KeyC
    "{",             // KeyV
    "\u0644\u0622",  // KeyB
    "\u0622",        // KeyN
    "\u2019",        // KeyM
    ",",             // Comma
    ".",             // Period
    "\u061f",        // Slash
    "\u0020",        // Space
};
const char* kAltGr[] = {
    "\u0630",        // BackQuote
    "\u0661",        // Digit1
    "\u0662",        // Digit2
    "\u0663",        // Digit3
    "\u0664",        // Digit4
    "\u0665",        // Digit5
    "\u0666",        // Digit6
    "\u0667",        // Digit7
    "\u0668",        // Digit8
    "\u0669",        // Digit9
    "\u0660",        // Digit0
    "-",             // Minus
    "=",             // Equal
    "\u0636",        // KeyQ
    "\u0635",        // KeyW
    "\u062b",        // KeyE
    "\u0642",        // KeyR
    "\u0641",        // KeyT
    "\u063a",        // KeyY
    "\u0639",        // KeyU
    "\u0647",        // KeyI
    "\u062e",        // KeyO
    "\u062d",        // KeyP
    "\u062c",        // BracketLeft
    "\u062f",        // BracketRight
    "\\",            // Backslash
    "\u0634",        // KeyA
    "\u0633",        // KeyS
    "\u064a",        // KeyD
    "\u0628",        // KeyF
    "\u0644",        // KeyG
    "\u0627",        // KeyH
    "\u062a",        // KeyJ
    "\u0646",        // KeyK
    "\u0645",        // KeyL
    "\u0643",        // Semicolon
    "\u0637",        // Quote
    "\u0626",        // KeyZ
    "\u0621",        // KeyX
    "\u0624",        // KeyC
    "\u0631",        // KeyV
    "\u0644\u0627",  // KeyB
    "\u0649",        // KeyN
    "\u0629",        // KeyM
    "\u0648",        // Comma
    "\u0632",        // Period
    "\u0638",        // Slash
    "\u0020",        // Space
};
const char* kCapslock[] = {
    "\u0630",        // BackQuote
    "\u0661",        // Digit1
    "\u0662",        // Digit2
    "\u0663",        // Digit3
    "\u0664",        // Digit4
    "\u0665",        // Digit5
    "\u0666",        // Digit6
    "\u0667",        // Digit7
    "\u0668",        // Digit8
    "\u0669",        // Digit9
    "\u0660",        // Digit0
    "-",             // Minus
    "=",             // Equal
    "\u0636",        // KeyQ
    "\u0635",        // KeyW
    "\u062b",        // KeyE
    "\u0642",        // KeyR
    "\u0641",        // KeyT
    "\u063a",        // KeyY
    "\u0639",        // KeyU
    "\u0647",        // KeyI
    "\u062e",        // KeyO
    "\u062d",        // KeyP
    "\u062c",        // BracketLeft
    "\u062f",        // BracketRight
    "\\",            // Backslash
    "\u0634",        // KeyA
    "\u0633",        // KeyS
    "\u064a",        // KeyD
    "\u0628",        // KeyF
    "\u0644",        // KeyG
    "\u0627",        // KeyH
    "\u062a",        // KeyJ
    "\u0646",        // KeyK
    "\u0645",        // KeyL
    "\u0643",        // Semicolon
    "\u0637",        // Quote
    "\u0626",        // KeyZ
    "\u0621",        // KeyX
    "\u0624",        // KeyC
    "\u0631",        // KeyV
    "\u0644\u0627",  // KeyB
    "\u0649",        // KeyN
    "\u0629",        // KeyM
    "\u0648",        // Comma
    "\u0632",        // Period
    "\u0638",        // Slash
    "\u0020",        // Space
};
const char* kShiftAltGr[] = {
    "\u0651",        // BackQuote
    "!",             // Digit1
    "\"",            // Digit2
    "#",             // Digit3
    "$",             // Digit4
    "%",             // Digit5
    "^",             // Digit6
    "&",             // Digit7
    "*",             // Digit8
    ")",             // Digit9
    "(",             // Digit0
    "_",             // Minus
    "+",             // Equal
    "\u064e",        // KeyQ
    "\u064b",        // KeyW
    "\u064f",        // KeyE
    "\u064c",        // KeyR
    "\u0644\u0625",  // KeyT
    "\u0625",        // KeyY
    "\u2018",        // KeyU
    "\u00f7",        // KeyI
    "\u00d7",        // KeyO
    "\u061b",        // KeyP
    "<",             // BracketLeft
    ">",             // BracketRight
    "|",             // Backslash
    "\u0650",        // KeyA
    "\u064d",        // KeyS
    "]",             // KeyD
    "[",             // KeyF
    "\u0644\u0623",  // KeyG
    "\u0623",        // KeyH
    "\u0640",        // KeyJ
    "\u060c",        // KeyK
    "/",             // KeyL
    ":",             // Semicolon
    "@",             // Quote
    "~",             // KeyZ
    "\u0652",        // KeyX
    "}",             // KeyC
    "{",             // KeyV
    "\u0644\u0622",  // KeyB
    "\u0622",        // KeyN
    "\u2019",        // KeyM
    ",",             // Comma
    ".",             // Period
    "\u061f",        // Slash
    "\u0020",        // Space
};
const char* kAltgrCapslock[] = {
    "\u0630",        // BackQuote
    "\u0661",        // Digit1
    "\u0662",        // Digit2
    "\u0663",        // Digit3
    "\u0664",        // Digit4
    "\u0665",        // Digit5
    "\u0666",        // Digit6
    "\u0667",        // Digit7
    "\u0668",        // Digit8
    "\u0669",        // Digit9
    "\u0660",        // Digit0
    "-",             // Minus
    "=",             // Equal
    "\u0636",        // KeyQ
    "\u0635",        // KeyW
    "\u062b",        // KeyE
    "\u0642",        // KeyR
    "\u0641",        // KeyT
    "\u063a",        // KeyY
    "\u0639",        // KeyU
    "\u0647",        // KeyI
    "\u062e",        // KeyO
    "\u062d",        // KeyP
    "\u062c",        // BracketLeft
    "\u062f",        // BracketRight
    "\\",            // Backslash
    "\u0634",        // KeyA
    "\u0633",        // KeyS
    "\u064a",        // KeyD
    "\u0628",        // KeyF
    "\u0644",        // KeyG
    "\u0627",        // KeyH
    "\u062a",        // KeyJ
    "\u0646",        // KeyK
    "\u0645",        // KeyL
    "\u0643",        // Semicolon
    "\u0637",        // Quote
    "\u0626",        // KeyZ
    "\u0621",        // KeyX
    "\u0624",        // KeyC
    "\u0631",        // KeyV
    "\u0644\u0627",  // KeyB
    "\u0649",        // KeyN
    "\u0629",        // KeyM
    "\u0648",        // Comma
    "\u0632",        // Period
    "\u0638",        // Slash
    "\u0020",        // Space
};
const char* kShiftCapslock[] = {
    "\u0651",        // BackQuote
    "!",             // Digit1
    "\"",            // Digit2
    "#",             // Digit3
    "$",             // Digit4
    "%",             // Digit5
    "^",             // Digit6
    "&",             // Digit7
    "*",             // Digit8
    ")",             // Digit9
    "(",             // Digit0
    "_",             // Minus
    "+",             // Equal
    "\u064e",        // KeyQ
    "\u064b",        // KeyW
    "\u064f",        // KeyE
    "\u064c",        // KeyR
    "\u0644\u0625",  // KeyT
    "\u0625",        // KeyY
    "\u2018",        // KeyU
    "\u00f7",        // KeyI
    "\u00d7",        // KeyO
    "\u061b",        // KeyP
    "<",             // BracketLeft
    ">",             // BracketRight
    "|",             // Backslash
    "\u0650",        // KeyA
    "\u064d",        // KeyS
    "]",             // KeyD
    "[",             // KeyF
    "\u0644\u0623",  // KeyG
    "\u0623",        // KeyH
    "\u0640",        // KeyJ
    "\u060c",        // KeyK
    "/",             // KeyL
    ":",             // Semicolon
    "@",             // Quote
    "~",             // KeyZ
    "\u0652",        // KeyX
    "}",             // KeyC
    "{",             // KeyV
    "\u0644\u0622",  // KeyB
    "\u0622",        // KeyN
    "\u2019",        // KeyM
    ",",             // Comma
    ".",             // Period
    "\u061f",        // Slash
    "\u0020",        // Space
};
const char* kShiftAltGrCapslock[] = {
    "\u0651",        // BackQuote
    "!",             // Digit1
    "\"",            // Digit2
    "#",             // Digit3
    "$",             // Digit4
    "%",             // Digit5
    "^",             // Digit6
    "&",             // Digit7
    "*",             // Digit8
    ")",             // Digit9
    "(",             // Digit0
    "_",             // Minus
    "+",             // Equal
    "\u064e",        // KeyQ
    "\u064b",        // KeyW
    "\u064f",        // KeyE
    "\u064c",        // KeyR
    "\u0644\u0625",  // KeyT
    "\u0625",        // KeyY
    "\u2018",        // KeyU
    "\u00f7",        // KeyI
    "\u00d7",        // KeyO
    "\u061b",        // KeyP
    "<",             // BracketLeft
    ">",             // BracketRight
    "|",             // Backslash
    "\u0650",        // KeyA
    "\u064d",        // KeyS
    "]",             // KeyD
    "[",             // KeyF
    "\u0644\u0623",  // KeyG
    "\u0623",        // KeyH
    "\u0640",        // KeyJ
    "\u060c",        // KeyK
    "/",             // KeyL
    ":",             // Semicolon
    "@",             // Quote
    "~",             // KeyZ
    "\u0652",        // KeyX
    "}",             // KeyC
    "{",             // KeyV
    "\u0644\u0622",  // KeyB
    "\u0622",        // KeyN
    "\u2019",        // KeyM
    ",",             // Comma
    ".",             // Period
    "\u061f",        // Slash
    "\u0020",        // Space
};
const char** kKeyMap[8] = {
    kNormal,   kShift,         kAltGr,         kShiftAltGr,
    kCapslock, kShiftCapslock, kAltgrCapslock, kShiftAltGrCapslock};

}  // namespace ar
