// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_CONSTANTS_NOTIFIER_CATALOGS_H_
#define ASH_CONSTANTS_NOTIFIER_CATALOGS_H_

namespace ash {

// A living catalog that registers notifications.
// Current values should not be renumbered or removed. Please keep in sync with
// "NotificationCatalogName" in tools/metrics/histograms/enums.xml.
// To deprecate comment out the entry.
enum class NotificationCatalogName {
  kNone = 0,
  kTestCatalogName = 1,
  kManagementTransition = 2,
  kAuthpolicyCredentialsError = 3,
  kUnauthorizedBattery = 4,
  kNonWilcoCharger = 5,
  kIncompatibleDock = 6,
  kDockError = 7,
  KDockDisplayError = 8,
  kDockThunderboltError = 9,
  kWilcoLowPowerCharger = 10,
  kDeprecatedAccelerator = 11,
  // [Deprecated] kShortcutsChanged = 12,
  kDockedMagnifierEnabled = 13,
  kHighContrastEnabled = 14,
  kFullScreenMagnifierEnabled = 15,
  kAccessibilityFeatureDisabled = 16,
  kDisplayError = 17,
  kDisplayChange = 18,
  kDualRole = 19,
  kEOL = 20,
  kPendingEOL = 21,
  kHats = 22,
  kKerberosTicketExpiry = 23,
  kMobileData = 24,
  kMultiDevice = 25,
  kNetworkOutOfCredits = 26,
  kNetworkConnectionError = 27,
  kNetworkVPNConnectionLost = 28,
  kNetworkCellularActivated = 29,
  kNetworkActivationError = 30,
  kPasswordExpiry = 31,
  kDeviceAccountSigninError = 32,
  kSecondaryAccountSigninError = 33,
  kSyncError = 34,
  kTetherPotentialHotspot = 35,
  kTetherSetupRequired = 36,
  kTetherConnectionError = 37,
  kScreenTimeLimitUpdated = 38,
  kBedtimeUpdated = 39,
  kTimeLimitOverride = 40,
  kScreenTimeLimit = 41,
  kBedtimeLimit = 42,
  kTPMFirmwareUpdate = 43,
  kU2F = 44,
  kReleaseNotes = 45,
  kSMS = 46,
  kAssistantNotification = 47,
  kFastPair = 48,
  // [Deprecated] kPowerNotifier = 49,
  kBatteryNotifier = 50,
  kMicrophoneMute = 51,
  kCast = 52,
  kSessionLengthTimeout = 53,
  kLocaleUpdate = 54,
  kTracing = 55,
  kPcieBillboardDevice = 56,
  kPcieLimitedPerformance = 57,
  kPcieGuestMode = 58,
  kPciePeripheralBlocked = 59,
  kDetachableBaseRequiresUpdate = 60,
  kDetachableBasePairingNotification = 61,
  kFirmwareUpdate = 62,
  kPeripheralBattery = 63,
  kBluetoothPairingRequest = 64,
  // [Deprecated] kBluetoothPairedDevice = 65,
  kCellularSetup = 66,
  kScreenSecurity = 67,
  kWifiToggle = 68,
  kUSBPeripheralInvalidDpCable = 69,
  kUSBPeripheralInvalidUSB4ValidTBTCable = 70,
  kUSBPeripheralInvalidUSB4Cable = 71,
  kUSBPeripheralInvalidTBTCable = 72,
  kUSBPeripheralSpeedLimitingCable = 73,
  kGestureEducation = 74,
  kUpdate = 75,
  kArcSnapshotReboot = 76,
  kPhoneHubTetherFailed = 77,
  kCapsLock = 78,
  kNightLight = 79,
  kPluginVMUninstaller = 80,
  // [Deprecated] kTPMAutoUpdate = 81,
  kIt2MeConfirmation = 82,
  kHPSNotify = 83,
  kNearbyShare = 84,
  kUpdateRequired = 85,
  kFileSystemProvider = 86,
  kEasyUnlockChromebookAdded = 87,
  kEasyUnlockPairingChange = 88,
  kEasyUnlockPairingChangeApplied = 89,
  kEasyUnlockSmartLockSignInRemoved = 90,
  kSystemProxy = 91,
  kDlpPolicy = 92,
  kPacketCapture = 93,
  kEcheAppRetryConnection = 94,
  kEcheAppInactivity = 95,
  kEcheAppFromWebWithoutButton = 96,
  kEcheAppScreenLock = 97,
  // [Deprecated] kAccessibility = 98,
  kProjector = 99,
  kWebsiteApproval = 100,
  kArcMigrationGuide = 101,
  kBorealisContext = 102,
  kArcProvision = 103,
  kUsbPrinter = 104,
  kCupsPrintJob = 105,
  kArcBootError = 106,
  kDeviceCommandReset = 107,
  kCrostiniLowDisk = 108,
  kScreenCapture = 109,
  kLowDisk = 110,
  kEventRewriterDeprecation = 111,
  kVMCameraMic = 112,
  kSecurityToken = 113,
  kCrostiniExportImport = 114,
  kLacrosCannotLaunch = 115,
  kRequestFileSystem = 116,
  kNetworkPortalDetector = 117,
  kCrostiniPackage = 118,
  kCrostiniUpgradeAvailable = 119,
  kFullRestore = 120,
  kAdbSideloadingDisallowed = 121,
  kAdbSideloadingPowerwashPlanned = 122,
  kAdbSideloadingPowerwashOnReboot = 123,
  kAppTime = 124,
  kCrosUSBDetector = 125,
  kPowerwashRequest = 126,
  kPowerwashRequestError = 127,
  kCameraPrivacySwitch = 128,
  kAutoLaunch = 129,
  kPasswordChange = 130,
  kAnnouncementNotification = 131,
  kWebUsb = 132,
  kBackgroundCrash = 133,
  kDownloadNotification = 134,
  kAdaptiveCharging = 135,
  kManagedSimLock = 136,
  kSpokenFeedbackEnabled = 137,
  kBrailleDisplayConnected = 138,
  kSpokenFeedbackBrailleEnabled = 139,
  kSwitchAccessEnabled = 140,
  kSpeechRecognitionFilesDownloaded = 141,
  kSpeechRecognitionFilesFailed = 142,
  kLowPowerCharger = 143,
  kLowPowerAdapter = 144,
  kTPMAutoUpdatePlanned = 145,
  kTPMAutoUpdateOnReboot = 146,
  kPrivacyIndicators = 147,
  kTailoredSecurityDisabled = 148,
  kTailoredSecurityEnabled = 149,
  kTailoredSecurityPromotion = 150,
  kArcLowDiskSpacePreStop = 151,
  kArcLowDiskSpacePostStop = 152,
  kMultiCapture = 153,
  kPrivacyHubCamera = 154,
  kPrivacyHubHWCameraSwitchOffSWCameraSwitchOn = 155,
  kEcheAppNetworkSetting = 156,
  kMaxValue = kEcheAppNetworkSetting
};

// A living catalog that registers system nudges.
// Current values should not be renumbered or removed. Please keep in sync with
// "NudgeCatalogName" in tools/metrics/histograms/enums.xml.
// To deprecate comment out the entry.
enum class NudgeCatalogName {
  kTestCatalogName = 0,
  kDictation = 1,
  kMultipaste = 2,
  kDarkLightMode = 3,
  kAutozoom = 4,
  kAdaptiveCharging = 5,
  kMaxValue = kAdaptiveCharging,
};

// A living catalog that registers toasts.
// Current values should not be renumbered or removed. Please keep in sync with
// "ToastCatalogName" in tools/metrics/histograms/enums.xml.
// To deprecate comment out the entry.
enum class ToastCatalogName {
  kVirtualDesksLimitMax = 0,
  kVirtualDesksLimitMin = 1,
  kAssistantError = 2,
  kDebugCommand = 3,
  kAssistantUnboundService = 4,
  kStylusPrompt = 5,
  kAppResizable = 6,
  kKioskAppError = 7,
  kBluetoothDevicePaired = 8,
  kBluetoothDeviceDisconnected = 9,
  kBluetoothDeviceConnected = 10,
  kBluetoothAdapterDiscoverable = 11,
  kEncourageUnlock = 12,
  kNetworkAutoConnect = 13,
  kAssistantLoading = 14,
  kToastManagerUnittest = 15,
  kMaximumDeskLaunchTemplate = 16,
  kEnterOverviewGesture = 17,
  kExitOverviewGesture = 18,
  kNextDeskGesture = 19,
  kPreviousDeskGesture = 20,
  kMoveVisibleOnAllDesksWindow = 21,
  kAppCannotSnap = 22,
  kCrostiniUnsupportedVirtualKeyboard = 23,
  kCrostiniUnsupportedIME = 24,
  kCopyToClipboardShareAction = 25,
  kClipboardBlockedAction = 26,
  kClipboardWarnOnPaste = 27,
  kAppNotAvailable = 28,
  kCameraPrivacySwitchOff = 29,
  kCameraPrivacySwitchOn = 30,
  kExtensionInstallSuccess = 31,
  kAccountRemoved = 32,
  kDeskTemplateTooLarge = 33,
  kUndoCloseAll = 34,
  kEcheAppToast = 35,
  kDeprecateAssistantStylus = 36,
  kEcheTrayCopyPasteNotImplemented = 37,
  kEcheTrayTabletModeNotSupported = 38,
  kMaxValue = kEcheTrayTabletModeNotSupported,
};

}  // namespace ash

#endif  // ASH_CONSTANTS_NOTIFIER_CATALOGS_H_
