// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ash/accelerators/accelerator_layout_table.h"

#include "ash/public/cpp/accelerators.h"
#include "ash/public/mojom/accelerator_info.mojom.h"
#include "base/containers/fixed_flat_map.h"

namespace ash {

// TODO(jimmyxgong): Reconcile this map with default accelerator keys, either
// create a separate map or modify this map to include default accelerators.
const auto kAcceleratorLayouts =
    base::MakeFixedFlatMap<AcceleratorAction, AcceleratorLayoutDetails>({
        {BRIGHTNESS_DOWN,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {BRIGHTNESS_UP,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {CYCLE_BACKWARD_MRU,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {CYCLE_FORWARD_MRU,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DESKS_ACTIVATE_DESK_LEFT,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DESKS_ACTIVATE_DESK_RIGHT,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DESKS_MOVE_ACTIVE_ITEM_LEFT,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DESKS_MOVE_ACTIVE_ITEM_RIGHT,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DESKS_NEW_DESK,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DESKS_REMOVE_CURRENT_DESK,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DESKS_ACTIVATE_0,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DESKS_ACTIVATE_1,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DESKS_ACTIVATE_2,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DESKS_ACTIVATE_3,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DESKS_ACTIVATE_4,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DESKS_ACTIVATE_5,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DESKS_ACTIVATE_6,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DESKS_ACTIVATE_7,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DESKS_TOGGLE_ASSIGN_TO_ALL_DESKS,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DISABLE_CAPS_LOCK,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {EXIT,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {FOCUS_CAMERA_PREVIEW,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {FOCUS_NEXT_PANE,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {FOCUS_PREVIOUS_PANE,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {FOCUS_SHELF,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {FOCUS_PIP,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {KEYBOARD_BACKLIGHT_TOGGLE,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {KEYBOARD_BRIGHTNESS_DOWN,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {KEYBOARD_BRIGHTNESS_UP,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {LAUNCH_APP_0,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {LAUNCH_APP_1,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {LAUNCH_APP_2,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {LAUNCH_APP_3,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {LAUNCH_APP_4,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {LAUNCH_APP_5,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {LAUNCH_APP_6,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {LAUNCH_APP_7,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {LAUNCH_LAST_APP,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {LOCK_PRESSED,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {LOCK_RELEASED,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {LOCK_SCREEN,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {MAGNIFIER_ZOOM_IN,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {MAGNIFIER_ZOOM_OUT,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {MEDIA_FAST_FORWARD,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {MEDIA_NEXT_TRACK,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {MEDIA_PAUSE,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {MEDIA_PLAY,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {MEDIA_PLAY_PAUSE,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {MEDIA_PREV_TRACK,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {MEDIA_REWIND,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {MEDIA_STOP,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {MICROPHONE_MUTE_TOGGLE,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {MOVE_ACTIVE_WINDOW_BETWEEN_DISPLAYS,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {NEW_INCOGNITO_WINDOW,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {NEW_TAB,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {NEW_WINDOW,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {OPEN_CALCULATOR,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {OPEN_CROSH,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {OPEN_DIAGNOSTICS,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {OPEN_FEEDBACK_PAGE,
         {mojom::AcceleratorCategory::kSystem,
          mojom::AcceleratorSubcategory::kSystemApps,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {OPEN_FILE_MANAGER,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {OPEN_GET_HELP,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {POWER_PRESSED,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {POWER_RELEASED,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {PRINT_UI_HIERARCHIES,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {PRIVACY_SCREEN_TOGGLE,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {RESTORE_TAB,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {ROTATE_SCREEN,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {ROTATE_WINDOW,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {SCALE_UI_DOWN,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {SCALE_UI_RESET,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {SCALE_UI_UP,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {SHOW_EMOJI_PICKER,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_IME_MENU_BUBBLE,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {SHOW_SHORTCUT_VIEWER,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {SHOW_STYLUS_TOOLS,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {SHOW_TASK_MANAGER,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {START_AMBIENT_MODE,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {START_ASSISTANT,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {SUSPEND,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {SWAP_PRIMARY_DISPLAY,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {SWITCH_IME,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {SWITCH_TO_LAST_USED_IME,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {SWITCH_TO_NEXT_IME,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {SWITCH_TO_NEXT_USER,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {SWITCH_TO_PREVIOUS_USER,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TAKE_PARTIAL_SCREENSHOT,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TAKE_SCREENSHOT,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TAKE_WINDOW_SCREENSHOT,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_APP_LIST,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_CALENDAR,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_CAPS_LOCK,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_CLIPBOARD_HISTORY,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_DICTATION,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_DOCKED_MAGNIFIER,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_FLOATING,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_FULLSCREEN,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_FULLSCREEN_MAGNIFIER,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_HIGH_CONTRAST,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_MAXIMIZED,
         {mojom::AcceleratorCategory::kWindowsAndDesk,
          mojom::AcceleratorSubcategory::kSystemControls,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_MESSAGE_CENTER_BUBBLE,
         {mojom::AcceleratorCategory::kTabsAndPages,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_MIRROR_MODE,
         {mojom::AcceleratorCategory::kTabsAndPages,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_OVERVIEW,
         {mojom::AcceleratorCategory::kTabsAndPages,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_PROJECTOR_MARKER,
         {mojom::AcceleratorCategory::kTabsAndPages,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_RESIZE_LOCK_MENU,
         {mojom::AcceleratorCategory::kTabsAndPages,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_SPOKEN_FEEDBACK,
         {mojom::AcceleratorCategory::kTabsAndPages,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_SYSTEM_TRAY_BUBBLE,
         {mojom::AcceleratorCategory::kTabsAndPages,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOGGLE_WIFI,
         {mojom::AcceleratorCategory::kTabsAndPages,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOUCH_HUD_CLEAR,
         {mojom::AcceleratorCategory::kTabsAndPages,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {TOUCH_HUD_MODE_CHANGE,
         {mojom::AcceleratorCategory::kTabsAndPages,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {UNPIN,
         {mojom::AcceleratorCategory::kTextAndInput,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {VOLUME_DOWN,
         {mojom::AcceleratorCategory::kTextAndInput,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {VOLUME_MUTE,
         {mojom::AcceleratorCategory::kTextAndInput,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {VOLUME_UP,
         {mojom::AcceleratorCategory::kTextAndInput,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {WINDOW_CYCLE_SNAP_LEFT,
         {mojom::AcceleratorCategory::kTextAndInput,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {WINDOW_CYCLE_SNAP_RIGHT,
         {mojom::AcceleratorCategory::kTextAndInput,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {WINDOW_MINIMIZE,
         {mojom::AcceleratorCategory::kTextAndInput,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {MINIMIZE_TOP_WINDOW_ON_BACK,
         {mojom::AcceleratorCategory::kTextAndInput,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_DUMP_CALENDAR_MODEL,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_KEYBOARD_BACKLIGHT_TOGGLE,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_MICROPHONE_MUTE_TOGGLE,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_PRINT_LAYER_HIERARCHY,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_PRINT_VIEW_HIERARCHY,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_PRINT_WINDOW_HIERARCHY,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_SHOW_TOAST,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_SYSTEM_UI_STYLE_VIEWER,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_TUCK_FLOATED_WINDOW_LEFT,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_TUCK_FLOATED_WINDOW_RIGHT,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_TOGGLE_DARK_MODE,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_TOGGLE_DYNAMIC_COLOR,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_TOGGLE_GLANCEABLES,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_TOGGLE_SHOW_DEBUG_BORDERS,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_TOGGLE_SHOW_FPS_COUNTER,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_TOGGLE_SHOW_PAINT_RECTS,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_TOGGLE_TOUCH_PAD,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_TOGGLE_TOUCH_SCREEN,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_TOGGLE_TABLET_MODE,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_TOGGLE_WALLPAPER_MODE,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_TRIGGER_CRASH,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEBUG_TOGGLE_HUD_DISPLAY,
         {mojom::AcceleratorCategory::kDebug,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEV_ADD_REMOVE_DISPLAY,
         {mojom::AcceleratorCategory::kDeveloper,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEV_TOGGLE_APP_LIST,
         {mojom::AcceleratorCategory::kDeveloper,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
        {DEV_TOGGLE_UNIFIED_DESKTOP,
         {mojom::AcceleratorCategory::kDeveloper,
          mojom::AcceleratorSubcategory::kGeneral,
          /**locked=*/true, mojom::AcceleratorLayoutStyle::kDefault}},
    });

}  // namespace ash
