// Copyright (c) 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/chrome_cleaner/constants/chrome_cleaner_switches.h"

namespace chrome_cleaner {

// Command line switches

// Set the timeout for the cleaning phase, in minutes. 0 disables the timeout
// entirely.
const char kCleaningTimeoutMinutesSwitch[] = "cleaning-timeout";

// Identifier used to group all reports generated during the same run of the
// cleaner, including runs before and after a reboot. The id is generated by
// the first cleaner process for a run, and propagated to spawned or scheduled
// cleaner processes. A new id will be generated in the first process for a
// subsequent cleanup, so cleanups from the same user cannot be tracked over
// time.
const char kCleanupIdSwitch[] = "cleanup-id";

// Runs as the Crashpad handler.
const char kCrashHandlerSwitch[] = "crash-handler";

// Crash flag to force a crash right away. Mainly intended for ensuring crashes
// are properly recorded by crashpad.
const char kCrashSwitch[] = "crash";

// Dump the raw logs to a file with the same base name as the executable. The
// dumped file is a raw protobuf and has a "pb" extension.
// WARNING: this switch is used internally. Be careful when making changes.
const char kDumpRawLogsSwitch[] = "dump-raw-logs";

// Identify that the process is already supposed to be elevated, so that we
// don't try again.
const char kElevatedSwitch[] = "elevated";

// Force a logs upload failure to help test the logs upload retry.
const char kForceLogsUploadFailureSwitch[] = "force-logs-upload-failure";

// Force the recovery component, when running an unofficial build. This only
// applies to the cleaner, not the reporter.
const char kForceRecoveryComponentSwitch[] = "force-recovery-component";

// Force self-deletion even on non-official builds.
const char kForceSelfDeleteSwitch[] = "force-self-delete";

// Log all removable UwS that were not detected, but the scanner found some
// UwS-related footprints.
// WARNING: this switch is used internally. Be careful when making changes.
const char kForceUwsDetectionSwitch[] = "force-uws-detection";

// The handle of an event to signal when the initialization of the main process
// is complete (including loading all DLL's). This is used by the integration
// test to check that forbidden modules aren't loaded outside the sandbox. If
// this is set, the main process will signal the event and then wait for the
// integration test to signal it as well before continuing. Ignored in official
// builds.
const char kInitDoneNotifierSwitch[] = "init-done-notifier";

// Set the timeout for integration tests in minutes. 0 disables the timeout
// entirely.
const char kIntegrationTestTimeoutMinutesSwitch[] =
    "integration-test-timeout-minutes";

// Attempt to load empty-dll.dll whenever this flag is set. For testing DLL
// loading.
const char kLoadEmptyDLLSwitch[] = "load-empty-dll";

// Specifies a file to log all the interface calls of EngineRequestsImpl and
// CleanerEngineRequestsImpl.
const char kLogInterfaceCallsToSwitch[] = "log-interface-calls-to";

// Specify the time to wait between logs upload retries, in minutes.
const char kLogUploadRetryIntervalSwitch[] = "logs-upload-retry-interval";

// Prevent the crash client from uploading crash reports.
const char kNoCrashUploadSwitch[] = "no-crash-upload";

// Prevent downloading and running the recovery component.
const char kNoRecoveryComponentSwitch[] = "no-recovery-component";

// Prevent the logging service from uploading logs and reports.
// WARNING: this switch is used internally, be careful when making changes.
const char kNoReportUploadSwitch[] = "no-report-upload";

// Prevent the executable from deleting itself after running.
const char kNoSelfDeleteSwitch[] = "no-self-delete";

// Indicates this run is post-reboot.
const char kPostRebootSwitch[] = "post-reboot";

// A freeform text string that records what triggered a post-reboot run.
const char kPostRebootTriggerSwitch[] = "post-reboot-trigger";

// Indicates that this is a post-reboot run that should fetch its switches from
// an external registry key.
// Important note: When this switch is present in the command line, all other
// switches are ignored except for kCleanupIdSwitch, which is used to read
// post-reboot switches from the correct registry location.
const char kPostRebootSwitchesInOtherRegistryKeySwitch[] =
    "post-reboot-override-cmd";

// Allow the engine to remove UwS that isn't marked cleanable. For testing
// only.
const char kRemoveScanOnlyUwS[] = "remove-scan-only-uws";

// Enable reporting of force-installed Chrome extensions.
const char kReportExtensionsSwitch[] = "report-extensions";

// Mojo pipe token generated in the broker process and passed to the sandbox
// process to bind with the EngineCommands IPC interface.
const char kSandboxMojoPipeTokenSwitch[] = "sandbox-mojo-pipe-token";

// Used to identify the id of the sandbox process that is intended
// to be spawned.
const char kSandboxedProcessIdSwitch[] = "sandboxed-process-id";

// Used to limit trace locations that will be scanned. Trace locations should be
// specified as integers, separated by commas. For example:
//   --scan-locations=1,2,3,5
const char kScanLocationsSwitch[] = "scan-locations";

// Set the timeout for the scanning phase, in minutes. 0 disables the timeout
// entirely.
const char kScanningTimeoutMinutesSwitch[] = "scanning-timeout";

// Set a test logging URL, where logs will be uploaded.
const char kTestLoggingURLSwitch[] = "test-logging-url";

// Flag set during testing and stored as a crash key, to differentiate from
// crashes received from actual users.
// WARNING: this switch is used internally, be careful when making changes.
const char kTestingSwitch[] = "testing";

// Specifies the full path to a protocol buffer log file to be uploaded.
const char kUploadLogFileSwitch[] = "upload-log-file";

// If present, the test harness will use the crash reporter.
const char kUseCrashHandlerInTestsSwitch[] = "use-crash-handler-in-tests";

// Specifies the IPC pipe name of the crash handler to use (instead of starting
// a new crash handler process).
const char kUseCrashHandlerWithIdSwitch[] = "use-crash-handler-with-id";

// Override the registry with the specified temporary registry. Used for tests.
const char kUseTempRegistryPathSwitch[] = "use-temp-registry-path";

// Set the timeout for how long to wait for user response from Chrome, in
// minutes. 0 disables the timeout entirely.
const char kUserResponseTimeoutMinutesSwitch[] = "user-response-timeout";

// Identify that the elevated cleaner process is allowed to collect logs. This
// shouldn't be set if |kExecutionModeSwitch| is not ExecutionMode::kCleaner.
const char kWithCleanupModeLogsSwitch[] = "with-cleanup-mode-logs";

#if !defined(CHROME_CLEANER_OFFICIAL_BUILD)
// Don't allow EnableSecureDllLoading to run when this is set. This is only to
// be used in tests.
const char kAllowUnsecureDLLsSwitch[] = "allow-unsecure-dlls";
#endif  // CHROME_CLEANER_OFFICIAL_BUILD

}  // namespace chrome_cleaner
