// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_CHROMEOS_ARC_OPTIN_ARC_OPTIN_PREFERENCE_HANDLER_OBSERVER_H_
#define CHROME_BROWSER_CHROMEOS_ARC_OPTIN_ARC_OPTIN_PREFERENCE_HANDLER_OBSERVER_H_

namespace arc {

// Notifies about changes in Arc related preferences and metrics mode.
class ArcOptInPreferenceHandlerObserver {
 public:
  // Notifies metrics mode has been changed.
  virtual void OnMetricsModeChanged(bool enabled, bool managed) = 0;
  // Notifies use backup and restore preference has been changed.
  virtual void OnBackupAndRestoreModeChanged(bool enabled, bool managed) = 0;
  // Notifies location service consent preference has been changed.
  virtual void OnLocationServicesModeChanged(bool enabled, bool managed) = 0;

  virtual ~ArcOptInPreferenceHandlerObserver() = default;
};

}  // namespace arc

#endif  // CHROME_BROWSER_CHROMEOS_ARC_OPTIN_ARC_OPTIN_PREFERENCE_HANDLER_OBSERVER_H_
