// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

var usb = chrome.usb;

function resetDevice() {
  usb.findDevices({vendorId: 0, productId: 0}, function(devices) {
    usb.resetDevice(devices[0], function(result) {
      chrome.test.assertEq(result, true);
      // Ensure the device is still open.
      var transfer = {
        direction: "out",
        endpoint: 2,
        data: new ArrayBuffer(1)
      };
      usb.interruptTransfer(devices[0], transfer, function(result) {
        // This is designed to fail.
        usb.resetDevice(devices[0], function(result) {
          chrome.test.assertEq(result, false);
          usb.interruptTransfer(devices[0], transfer, function(result) {
            chrome.test.assertEq(result, undefined);
            chrome.test.assertEq(
                chrome.runtime.lastError && chrome.runtime.lastError.message,
                'No such device.'
            );
            chrome.test.succeed();
          });
        });
      });
    });
  });
}

chrome.test.runTests([resetDevice]);
