# Copyright 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'targets': [
    {
      'target_name': 'browser_ui',
      'type': 'static_library',
      'variables': { 'enable_wexit_time_destructors': 1, },
      # Since browser and browser_ui actually depend on each other,
      # we must omit the dependency from browser_ui to browser.
      # However, this means browser_ui and browser should more or less
      # have the same dependencies. Once browser_ui is untangled from
      # browser, then we can clean up these dependencies.
      'dependencies': [
        # NOTE: New dependencies should generally be added in the OS!="ios"
        # dependencies block below, rather than here.
        'cert_logger_proto',
        'chrome_browser_ui_views.gyp:browser_ui_views',
        'chrome_resources.gyp:chrome_extra_resources',
        'chrome_resources.gyp:chrome_resources',
        'chrome_resources.gyp:chrome_strings',
        'chrome_resources.gyp:platform_locale_settings',
        'chrome_resources.gyp:theme_resources',
        'common',
        'common_net',
        'in_memory_url_index_cache_proto',
        'safe_browsing_proto',
        'safe_browsing_report_proto',
        'feedback_proto',
        '../components/components.gyp:auto_login_parser',
        '../content/content.gyp:content_browser',
        '../content/content.gyp:content_common',
        '../crypto/crypto.gyp:crypto',
        '../skia/skia.gyp:skia',
        '../sync/sync.gyp:sync',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation_proto_cpp',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../third_party/libusb/libusb.gyp:libusb',
        '../third_party/libxml/libxml.gyp:libxml',
        '../third_party/zlib/zlib.gyp:zlib',
        '../ui/base/strings/ui_strings.gyp:ui_strings',
        '../ui/message_center/message_center.gyp:message_center',
        '../ui/native_theme/native_theme.gyp:native_theme',
        '../ui/snapshot/snapshot.gyp:snapshot',
        '../ui/ui.gyp:ui',
        '../ui/ui.gyp:ui_resources',
        '../webkit/common/user_agent/webkit_user_agent.gyp:user_agent',
      ],
      'include_dirs': [
        '..',
        '<(INTERMEDIATE_DIR)',
        # Needed by pepper_flash_component_installer.cc.
        '<(SHARED_INTERMEDIATE_DIR)',
      ],
      'export_dependent_settings': [
        '../sync/sync.gyp:sync',
      ],
      'sources': [
        # All .cc, .h, .m, and .mm files under browser/ui except for:
        # * tests and mocks.
        'browser/ui/accelerator_utils.h',
        'browser/ui/active_tab_tracker.cc',
        'browser/ui/active_tab_tracker.h',
        'browser/ui/alternate_error_tab_observer.cc',
        'browser/ui/alternate_error_tab_observer.h',
        'browser/ui/android/android_about_app_info.cc',
        'browser/ui/android/android_about_app_info.h',
        'browser/ui/android/autofill/autofill_dialog_controller_android.cc',
        'browser/ui/android/autofill/autofill_dialog_controller_android.h',
        'browser/ui/android/autofill/autofill_dialog_result.cc',
        'browser/ui/android/autofill/autofill_dialog_result.h',
        'browser/ui/android/autofill/autofill_popup_view_android.cc',
        'browser/ui/android/autofill/autofill_popup_view_android.h',
        'browser/ui/android/infobar/auto_login_infobar_delegate_android.cc',
        'browser/ui/android/infobar/confirm_infobar.cc',
        'browser/ui/android/infobar/confirm_infobar.h',
        'browser/ui/android/infobar/infobar_android.cc',
        'browser/ui/android/infobar/infobar_android.h',
        'browser/ui/android/infobar/infobar_container_android.cc',
        'browser/ui/android/infobar/infobar_container_android.h',
        'browser/ui/android/certificate_viewer_android.cc',
        'browser/ui/android/chrome_http_auth_handler.cc',
        'browser/ui/android/chrome_http_auth_handler.h',
        'browser/ui/android/color_chooser_dialog_android.cc',
        'browser/ui/android/extensions/extension_install_dialog_android.cc',
        'browser/ui/android/extensions/extension_install_ui_android.cc',
        'browser/ui/android/extensions/extension_install_ui_android.h',
        'browser/ui/android/extensions/extension_view_android.cc',
        'browser/ui/android/extensions/extension_view_android.h',
        'browser/ui/android/external_protocol_dialog_android.cc',
        'browser/ui/android/javascript_app_modal_dialog_android.cc',
        'browser/ui/android/login_prompt_android.cc',
        'browser/ui/android/navigation_popup.cc',
        'browser/ui/android/navigation_popup.h',
        'browser/ui/android/simple_message_box_android.cc',
        'browser/ui/android/ssl_client_certificate_request.cc',
        'browser/ui/android/ssl_client_certificate_request.h',
        'browser/ui/android/status_tray_android.cc',
        'browser/ui/android/tab_contents/chrome_web_contents_view_delegate_android.cc',
        'browser/ui/android/tab_contents/chrome_web_contents_view_delegate_android.h',
        'browser/ui/android/tab_model/tab_model.cc',
        'browser/ui/android/tab_model/tab_model.h',
        'browser/ui/android/tab_model/tab_model_list.cc',
        'browser/ui/android/tab_model/tab_model_list.h',
        'browser/ui/android/tab_restore_service_delegate_android.cc',
        'browser/ui/android/validation_message_bubble_android.h',
        'browser/ui/android/validation_message_bubble_android.cc',
        'browser/ui/android/website_settings_popup_android.cc',
        'browser/ui/android/website_settings_popup_android.h',
        'browser/ui/android/window_android_helper.cc',
        'browser/ui/android/window_android_helper.h',
        'browser/ui/app_list/fast_show_pickler.cc',
        'browser/ui/app_list/fast_show_pickler.h',
        'browser/ui/app_list/app_context_menu.cc',
        'browser/ui/app_list/app_context_menu.h',
        'browser/ui/app_list/app_context_menu_delegate.h',
        'browser/ui/app_list/app_list_controller_delegate.cc',
        'browser/ui/app_list/app_list_controller_delegate.h',
        'browser/ui/app_list/app_list_service.cc',
        'browser/ui/app_list/app_list_service.h',
        'browser/ui/app_list/app_list_service_ash.h',
        'browser/ui/app_list/app_list_service_disabled.cc',
        'browser/ui/app_list/app_list_service_impl.cc',
        'browser/ui/app_list/app_list_service_impl.h',
        'browser/ui/app_list/app_list_service_mac.h',
        'browser/ui/app_list/app_list_service_mac.mm',
        'browser/ui/app_list/app_list_service_win.cc',
        'browser/ui/app_list/app_list_service_win.h',
        'browser/ui/app_list/app_list_view_delegate.cc',
        'browser/ui/app_list/app_list_view_delegate.h',
        'browser/ui/app_list/apps_model_builder.cc',
        'browser/ui/app_list/apps_model_builder.h',
        'browser/ui/app_list/chrome_app_list_item.h',
        'browser/ui/app_list/chrome_signin_delegate.cc',
        'browser/ui/app_list/chrome_signin_delegate.h',
        'browser/ui/app_list/extension_app_item.cc',
        'browser/ui/app_list/extension_app_item.h',
        'browser/ui/app_list/search/app_result.cc',
        'browser/ui/app_list/search/app_result.h',
        'browser/ui/app_list/search/app_search_provider.cc',
        'browser/ui/app_list/search/app_search_provider.h',
        'browser/ui/app_list/search/chrome_search_result.h',
        'browser/ui/app_list/search/common/json_response_fetcher.cc',
        'browser/ui/app_list/search/common/json_response_fetcher.h',
        'browser/ui/app_list/search/common/url_icon_source.cc',
        'browser/ui/app_list/search/common/url_icon_source.h',
        'browser/ui/app_list/search/common/webservice_search_provider.cc',
        'browser/ui/app_list/search/common/webservice_search_provider.h',
        'browser/ui/app_list/search/history.cc',
        'browser/ui/app_list/search/history.h',
        'browser/ui/app_list/search/history_data.cc',
        'browser/ui/app_list/search/history_data.h',
        'browser/ui/app_list/search/history_data_store.cc',
        'browser/ui/app_list/search/history_data_store.h',
        'browser/ui/app_list/search/history_factory.cc',
        'browser/ui/app_list/search/history_factory.h',
        'browser/ui/app_list/search/history_types.h',
        'browser/ui/app_list/search/mixer.cc',
        'browser/ui/app_list/search/mixer.h',
        'browser/ui/app_list/search/omnibox_provider.cc',
        'browser/ui/app_list/search/omnibox_provider.h',
        'browser/ui/app_list/search/people/people_provider.cc',
        'browser/ui/app_list/search/people/people_provider.h',
        'browser/ui/app_list/search/people/people_result.cc',
        'browser/ui/app_list/search/people/people_result.h',
        'browser/ui/app_list/search/search_controller.cc',
        'browser/ui/app_list/search/search_controller.h',
        'browser/ui/app_list/search/search_provider.cc',
        'browser/ui/app_list/search/search_provider.h',
        'browser/ui/app_list/search/search_webstore_result.cc',
        'browser/ui/app_list/search/search_webstore_result.h',
        'browser/ui/app_list/search/term_break_iterator.cc',
        'browser/ui/app_list/search/term_break_iterator.h',
        'browser/ui/app_list/search/tokenized_string.cc',
        'browser/ui/app_list/search/tokenized_string.h',
        'browser/ui/app_list/search/tokenized_string_char_iterator.cc',
        'browser/ui/app_list/search/tokenized_string_char_iterator.h',
        'browser/ui/app_list/search/tokenized_string_match.cc',
        'browser/ui/app_list/search/tokenized_string_match.h',
        'browser/ui/app_list/search/webstore/webstore_cache.cc',
        'browser/ui/app_list/search/webstore/webstore_cache.h',
        'browser/ui/app_list/search/webstore/webstore_installer.cc',
        'browser/ui/app_list/search/webstore/webstore_installer.h',
        'browser/ui/app_list/search/webstore/webstore_provider.cc',
        'browser/ui/app_list/search/webstore/webstore_provider.h',
        'browser/ui/app_list/search/webstore/webstore_result.cc',
        'browser/ui/app_list/search/webstore/webstore_result.h',
        'browser/ui/app_modal_dialogs/app_modal_dialog.cc',
        'browser/ui/app_modal_dialogs/app_modal_dialog.h',
        'browser/ui/app_modal_dialogs/app_modal_dialog_queue.cc',
        'browser/ui/app_modal_dialogs/app_modal_dialog_queue.h',
        'browser/ui/app_modal_dialogs/javascript_app_modal_dialog.cc',
        'browser/ui/app_modal_dialogs/javascript_app_modal_dialog.h',
        'browser/ui/app_modal_dialogs/javascript_dialog_manager.cc',
        'browser/ui/app_modal_dialogs/javascript_dialog_manager.h',
        'browser/ui/app_modal_dialogs/native_app_modal_dialog.h',
        'browser/ui/apps/app_metro_infobar_delegate_win.cc',
        'browser/ui/apps/app_metro_infobar_delegate_win.h',
        'browser/ui/apps/apps_metro_handler_win.cc',
        'browser/ui/apps/apps_metro_handler_win.h',
        'browser/ui/apps/chrome_shell_window_delegate.cc',
        'browser/ui/apps/chrome_shell_window_delegate.h',
        'browser/ui/apps/directory_access_confirmation_dialog.cc',
        'browser/ui/apps/directory_access_confirmation_dialog.h',
        'browser/ui/ash/ash_keyboard_controller_proxy.cc',
        'browser/ui/ash/ash_keyboard_controller_proxy.h',
        'browser/ui/ash/app_list/app_list_controller_ash.h',
        'browser/ui/ash/app_list/app_list_controller_ash.cc',
        'browser/ui/ash/app_list/app_list_service_ash.cc',
        'browser/ui/ash/app_list/app_sync_ui_state_watcher.cc',
        'browser/ui/ash/app_list/app_sync_ui_state_watcher.h',
        'browser/ui/ash/app_sync_ui_state.cc',
        'browser/ui/ash/app_sync_ui_state.h',
        'browser/ui/ash/app_sync_ui_state_observer.h',
        'browser/ui/ash/app_sync_ui_state_factory.cc',
        'browser/ui/ash/app_sync_ui_state_factory.h',
        'browser/ui/ash/ash_init.cc',
        'browser/ui/ash/ash_init.h',
        'browser/ui/ash/ash_util.cc',
        'browser/ui/ash/ash_util.h',
        'browser/ui/ash/caps_lock_delegate_chromeos.cc',
        'browser/ui/ash/caps_lock_delegate_chromeos.h',
        'browser/ui/ash/caps_lock_delegate_views.cc',
        'browser/ui/ash/caps_lock_delegate_views.h',
        'browser/ui/ash/brightness_controller_chromeos.cc',
        'browser/ui/ash/brightness_controller_chromeos.h',
        'browser/ui/ash/chrome_launcher_prefs.cc',
        'browser/ui/ash/chrome_launcher_prefs.h',
        'browser/ui/ash/chrome_shell_delegate.cc',
        'browser/ui/ash/chrome_shell_delegate.h',
        'browser/ui/ash/chrome_shell_delegate_chromeos.cc',
        'browser/ui/ash/chrome_shell_delegate_views.cc',
        'browser/ui/ash/event_rewriter.cc',
        'browser/ui/ash/event_rewriter.h',
        'browser/ui/ash/ime_controller_chromeos.cc',
        'browser/ui/ash/ime_controller_chromeos.h',
        'browser/ui/ash/launcher/app_shortcut_launcher_item_controller.cc',
        'browser/ui/ash/launcher/app_shortcut_launcher_item_controller.h',
        'browser/ui/ash/launcher/browser_shortcut_launcher_item_controller.cc',
        'browser/ui/ash/launcher/browser_shortcut_launcher_item_controller.h',
        'browser/ui/ash/launcher/browser_status_monitor.cc',
        'browser/ui/ash/launcher/browser_status_monitor.h',
        'browser/ui/ash/launcher/chrome_launcher_app_menu_item.cc',
        'browser/ui/ash/launcher/chrome_launcher_app_menu_item.h',
        'browser/ui/ash/launcher/chrome_launcher_app_menu_item_browser.cc',
        'browser/ui/ash/launcher/chrome_launcher_app_menu_item_browser.h',
        'browser/ui/ash/launcher/chrome_launcher_app_menu_item_tab.cc',
        'browser/ui/ash/launcher/chrome_launcher_app_menu_item_tab.h',
        'browser/ui/ash/launcher/chrome_launcher_app_menu_item_v2app.cc',
        'browser/ui/ash/launcher/chrome_launcher_app_menu_item_v2app.h',
        'browser/ui/ash/launcher/chrome_launcher_controller.cc',
        'browser/ui/ash/launcher/chrome_launcher_controller.h',
        'browser/ui/ash/launcher/launcher_app_tab_helper.cc',
        'browser/ui/ash/launcher/launcher_app_tab_helper.h',
        'browser/ui/ash/launcher/launcher_context_menu.cc',
        'browser/ui/ash/launcher/launcher_context_menu.h',
        'browser/ui/ash/launcher/launcher_favicon_loader.cc',
        'browser/ui/ash/launcher/launcher_favicon_loader.h',
        'browser/ui/ash/launcher/launcher_item_controller.cc',
        'browser/ui/ash/launcher/launcher_item_controller.h',
        'browser/ui/ash/launcher/launcher_application_menu_item_model.cc',
        'browser/ui/ash/launcher/launcher_application_menu_item_model.h',
        'browser/ui/ash/launcher/shell_window_launcher_item_controller.cc',
        'browser/ui/ash/launcher/shell_window_launcher_item_controller.h',
        'browser/ui/ash/launcher/shell_window_launcher_controller.cc',
        'browser/ui/ash/launcher/shell_window_launcher_controller.h',
        'browser/ui/ash/screenshot_taker.cc',
        'browser/ui/ash/screenshot_taker.h',
        'browser/ui/ash/session_state_delegate_chromeos.cc',
        'browser/ui/ash/session_state_delegate_chromeos.h',
        'browser/ui/ash/session_state_delegate_views.cc',
        'browser/ui/ash/session_state_delegate_views.h',
        'browser/ui/ash/tabs/dock_info_ash.cc',
        'browser/ui/ash/tabs/dock_info_ash.h',
        'browser/ui/ash/tabs/dock_info_chromeos.cc',
        'browser/ui/ash/user_action_handler.cc',
        'browser/ui/ash/user_action_handler.h',
        'browser/ui/ash/user_wallpaper_delegate_win.cc',
        'browser/ui/ash/user_wallpaper_delegate_win.h',
        'browser/ui/ash/volume_controller_chromeos.cc',
        'browser/ui/ash/volume_controller_chromeos.h',
        'browser/ui/ash/window_positioner.cc',
        'browser/ui/ash/window_positioner.h',
        'browser/ui/aura/active_desktop_monitor.cc',
        'browser/ui/aura/active_desktop_monitor.h',
        'browser/ui/aura/chrome_browser_main_extra_parts_aura.cc',
        'browser/ui/aura/chrome_browser_main_extra_parts_aura.h',
        'browser/ui/aura/tab_contents/web_drag_bookmark_handler_aura.cc',
        'browser/ui/aura/tab_contents/web_drag_bookmark_handler_aura.h',
        'browser/ui/aura/tabs/dock_info_aurax11.cc',
        'browser/ui/autofill/account_chooser_model.cc',
        'browser/ui/autofill/account_chooser_model.h',
        'browser/ui/autofill/autofill_dialog_common.cc',
        'browser/ui/autofill/autofill_dialog_common.h',
        'browser/ui/autofill/autofill_dialog_controller.cc',
        'browser/ui/autofill/autofill_dialog_controller.h',
        'browser/ui/autofill/autofill_dialog_controller_impl.cc',
        'browser/ui/autofill/autofill_dialog_controller_impl.h',
        'browser/ui/autofill/autofill_dialog_models.cc',
        'browser/ui/autofill/autofill_dialog_models.h',
        'browser/ui/autofill/autofill_dialog_sign_in_delegate.cc',
        'browser/ui/autofill/autofill_dialog_sign_in_delegate.h',
        'browser/ui/autofill/autofill_dialog_types.cc',
        'browser/ui/autofill/autofill_dialog_types.h',
        'browser/ui/autofill/autofill_dialog_view.cc',
        'browser/ui/autofill/autofill_dialog_view.h',
        'browser/ui/autofill/autofill_dialog_view_delegate.h',
        'browser/ui/autofill/autofill_popup_controller.h',
        'browser/ui/autofill/autofill_popup_controller_impl.cc',
        'browser/ui/autofill/autofill_popup_controller_impl.h',
        'browser/ui/autofill/autofill_popup_view.h',
        'browser/ui/autofill/country_combobox_model.cc',
        'browser/ui/autofill/country_combobox_model.h',
        'browser/ui/autofill/data_model_wrapper.cc',
        'browser/ui/autofill/data_model_wrapper.h',
        'browser/ui/autofill/generated_credit_card_bubble_view.cc',
        'browser/ui/autofill/generated_credit_card_bubble_view.h',
        'browser/ui/autofill/generated_credit_card_bubble_controller.cc',
        'browser/ui/autofill/generated_credit_card_bubble_controller.h',
        'browser/ui/autofill/loading_animation.cc',
        'browser/ui/autofill/loading_animation.h',
        'browser/ui/autofill/new_credit_card_bubble_view.cc',
        'browser/ui/autofill/new_credit_card_bubble_view.h',
        'browser/ui/autofill/new_credit_card_bubble_controller.cc',
        'browser/ui/autofill/new_credit_card_bubble_controller.h',
        'browser/ui/autofill/tab_autofill_manager_delegate.cc',
        'browser/ui/autofill/tab_autofill_manager_delegate.h',
        'browser/ui/auto_login_infobar_delegate.cc',
        'browser/ui/auto_login_infobar_delegate.h',
        'browser/ui/auto_login_infobar_delegate_android.h',
        'browser/ui/auto_login_prompter.cc',
        'browser/ui/auto_login_prompter.h',
        'browser/ui/blocked_content/blocked_window_params.cc',
        'browser/ui/blocked_content/blocked_window_params.h',
        'browser/ui/blocked_content/popup_blocker_tab_helper.cc',
        'browser/ui/blocked_content/popup_blocker_tab_helper.h',
        'browser/ui/bookmarks/bookmark_bar.h',
        'browser/ui/bookmarks/bookmark_bar_constants.h',
        'browser/ui/bookmarks/bookmark_bar_instructions_delegate.h',
        'browser/ui/bookmarks/bookmark_bubble_delegate.h',
        'browser/ui/bookmarks/bookmark_bubble_sign_in_delegate.cc',
        'browser/ui/bookmarks/bookmark_bubble_sign_in_delegate.h',
        'browser/ui/bookmarks/bookmark_context_menu_controller.cc',
        'browser/ui/bookmarks/bookmark_context_menu_controller.h',
        'browser/ui/bookmarks/bookmark_drag_drop.cc',
        'browser/ui/bookmarks/bookmark_drag_drop.h',
        'browser/ui/bookmarks/bookmark_editor.cc',
        'browser/ui/bookmarks/bookmark_editor.h',
        'browser/ui/bookmarks/bookmark_prompt_controller.cc',
        'browser/ui/bookmarks/bookmark_prompt_controller.h',
        'browser/ui/bookmarks/bookmark_tab_helper.cc',
        'browser/ui/bookmarks/bookmark_tab_helper.h',
        'browser/ui/bookmarks/bookmark_tab_helper_delegate.cc',
        'browser/ui/bookmarks/bookmark_tab_helper_delegate.h',
        'browser/ui/bookmarks/bookmark_utils.cc',
        'browser/ui/bookmarks/bookmark_utils.h',
        'browser/ui/bookmarks/recently_used_folders_combo_model.cc',
        'browser/ui/bookmarks/recently_used_folders_combo_model.h',
        'browser/ui/browser.cc',
        'browser/ui/browser.h',
        'browser/ui/browser_commands.cc',
        'browser/ui/browser_commands.h',
        'browser/ui/browser_commands_mac.cc',
        'browser/ui/browser_commands_mac.h',
        'browser/ui/browser_command_controller.cc',
        'browser/ui/browser_command_controller.h',
        'browser/ui/browser_content_setting_bubble_model_delegate.cc',
        'browser/ui/browser_content_setting_bubble_model_delegate.h',
        'browser/ui/browser_dialogs.h',
        'browser/ui/browser_finder.cc',
        'browser/ui/browser_finder.h',
        'browser/ui/browser_instant_controller.cc',
        'browser/ui/browser_instant_controller.h',
        'browser/ui/browser_iterator.cc',
        'browser/ui/browser_iterator.h',
        'browser/ui/browser_list.cc',
        'browser/ui/browser_list.h',
        'browser/ui/browser_mac.cc',
        'browser/ui/browser_mac.h',
        'browser/ui/browser_navigator.cc',
        'browser/ui/browser_navigator.h',
        'browser/ui/browser_otr_state_android.cc',
        'browser/ui/browser_otr_state.cc',
        'browser/ui/browser_otr_state.h',
        'browser/ui/browser_ui_prefs.cc',
        'browser/ui/browser_ui_prefs.h',
        'browser/ui/browser_tab_contents.h',
        'browser/ui/browser_tab_contents.cc',
        'browser/ui/browser_tab_restore_service_delegate.cc',
        'browser/ui/browser_tab_restore_service_delegate.h',
        'browser/ui/browser_tab_strip_model_delegate.cc',
        'browser/ui/browser_tab_strip_model_delegate.h',
        'browser/ui/browser_tabrestore.cc',
        'browser/ui/browser_tabrestore.h',
        'browser/ui/browser_tabstrip.cc',
        'browser/ui/browser_tabstrip.h',
        'browser/ui/browser_toolbar_model_delegate.cc',
        'browser/ui/browser_toolbar_model_delegate.h',
        'browser/ui/browser_view_prefs.cc',
        'browser/ui/browser_view_prefs.h',
        'browser/ui/browser_win.cc',
        'browser/ui/browser_window.h',
        'browser/ui/browser_window_state.cc',
        'browser/ui/browser_window_state.h',
        'browser/ui/certificate_dialogs.cc',
        'browser/ui/certificate_dialogs.h',
        'browser/ui/chrome_pages.cc',
        'browser/ui/chrome_pages.h',
        'browser/ui/chrome_select_file_policy.cc',
        'browser/ui/chrome_select_file_policy.h',
        'browser/ui/chrome_style.cc',
        'browser/ui/chrome_style.h',
        'browser/ui/chrome_web_modal_dialog_manager_delegate.cc',
        'browser/ui/chrome_web_modal_dialog_manager_delegate.h',
        'browser/ui/cocoa/accelerator_utils_cocoa.mm',
        'browser/ui/cocoa/about_ipc_controller.h',
        'browser/ui/cocoa/about_ipc_controller.mm',
        'browser/ui/cocoa/about_ipc_dialog.h',
        'browser/ui/cocoa/about_ipc_dialog.mm',
        'browser/ui/cocoa/accelerators_cocoa.h',
        'browser/ui/cocoa/accelerators_cocoa.mm',
        'browser/ui/cocoa/animatable_image.h',
        'browser/ui/cocoa/animatable_image.mm',
        'browser/ui/cocoa/animatable_view.h',
        'browser/ui/cocoa/animatable_view.mm',
        'browser/ui/cocoa/applescript/apple_event_util.h',
        'browser/ui/cocoa/applescript/apple_event_util.mm',
        'browser/ui/cocoa/applescript/bookmark_folder_applescript.h',
        'browser/ui/cocoa/applescript/bookmark_folder_applescript.mm',
        'browser/ui/cocoa/applescript/bookmark_item_applescript.h',
        'browser/ui/cocoa/applescript/bookmark_item_applescript.mm',
        'browser/ui/cocoa/applescript/bookmark_node_applescript.h',
        'browser/ui/cocoa/applescript/bookmark_node_applescript.mm',
        'browser/ui/cocoa/applescript/browsercrapplication+applescript.h',
        'browser/ui/cocoa/applescript/browsercrapplication+applescript.mm',
        'browser/ui/cocoa/applescript/constants_applescript.h',
        'browser/ui/cocoa/applescript/constants_applescript.mm',
        'browser/ui/cocoa/applescript/element_applescript.h',
        'browser/ui/cocoa/applescript/element_applescript.mm',
        'browser/ui/cocoa/applescript/error_applescript.h',
        'browser/ui/cocoa/applescript/error_applescript.mm',
        'browser/ui/cocoa/applescript/tab_applescript.h',
        'browser/ui/cocoa/applescript/tab_applescript.mm',
        'browser/ui/cocoa/applescript/window_applescript.h',
        'browser/ui/cocoa/applescript/window_applescript.mm',
        'browser/ui/cocoa/apps/app_shim_menu_controller_mac.h',
        'browser/ui/cocoa/apps/app_shim_menu_controller_mac.mm',
        'browser/ui/cocoa/apps/chrome_shell_window_delegate_cocoa.mm',
        'browser/ui/cocoa/apps/native_app_window_cocoa.h',
        'browser/ui/cocoa/apps/native_app_window_cocoa.mm',
        'browser/ui/cocoa/autofill/autofill_account_chooser.h',
        'browser/ui/cocoa/autofill/autofill_account_chooser.mm',
        'browser/ui/cocoa/autofill/autofill_details_container.h',
        'browser/ui/cocoa/autofill/autofill_details_container.mm',
        'browser/ui/cocoa/autofill/autofill_dialog_cocoa.h',
        'browser/ui/cocoa/autofill/autofill_dialog_cocoa.mm',
        'browser/ui/cocoa/autofill/autofill_dialog_constants.h',
        'browser/ui/cocoa/autofill/autofill_layout.h',
        'browser/ui/cocoa/autofill/autofill_notification_container.h',
        'browser/ui/cocoa/autofill/autofill_notification_container.mm',
        'browser/ui/cocoa/autofill/autofill_notification_controller.h',
        'browser/ui/cocoa/autofill/autofill_notification_controller.mm',
        'browser/ui/cocoa/autofill/autofill_main_container.h',
        'browser/ui/cocoa/autofill/autofill_main_container.mm',
        'browser/ui/cocoa/autofill/autofill_overlay_controller.h',
        'browser/ui/cocoa/autofill/autofill_overlay_controller.mm',
        'browser/ui/cocoa/autofill/autofill_popup_view_bridge.h',
        'browser/ui/cocoa/autofill/autofill_popup_view_bridge.mm',
        'browser/ui/cocoa/autofill/autofill_popup_view_cocoa.h',
        'browser/ui/cocoa/autofill/autofill_popup_view_cocoa.mm',
        'browser/ui/cocoa/autofill/autofill_section_container.h',
        'browser/ui/cocoa/autofill/autofill_section_container.mm',
        'browser/ui/cocoa/autofill/autofill_section_view.h',
        'browser/ui/cocoa/autofill/autofill_section_view.mm',
        'browser/ui/cocoa/autofill/autofill_sign_in_container.h',
        'browser/ui/cocoa/autofill/autofill_sign_in_container.mm',
        'browser/ui/cocoa/autofill/autofill_suggestion_container.h',
        'browser/ui/cocoa/autofill/autofill_suggestion_container.mm',
        'browser/ui/cocoa/autofill/autofill_textfield.h',
        'browser/ui/cocoa/autofill/autofill_textfield.mm',
        'browser/ui/cocoa/autofill/down_arrow_popup_menu_cell.h',
        'browser/ui/cocoa/autofill/down_arrow_popup_menu_cell.mm',
        'browser/ui/cocoa/autofill/layout_view.h',
        'browser/ui/cocoa/autofill/layout_view.mm',
        'browser/ui/cocoa/autofill/autofill_pop_up_button.h',
        'browser/ui/cocoa/autofill/autofill_pop_up_button.mm',
        'browser/ui/cocoa/autofill/simple_grid_layout.h',
        'browser/ui/cocoa/autofill/simple_grid_layout.mm',
        'browser/ui/cocoa/background_gradient_view.h',
        'browser/ui/cocoa/background_gradient_view.mm',
        'browser/ui/cocoa/base_bubble_controller.h',
        'browser/ui/cocoa/base_bubble_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_all_tabs_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_all_tabs_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_bridge.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_bridge.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_constants.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_button_cell.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_button_cell.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_hover_state.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_hover_state.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_view.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_view.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_window.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_window.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_state.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_toolbar_view.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_toolbar_view.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_view.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_view.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bubble_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_bubble_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_button.h',
        'browser/ui/cocoa/bookmarks/bookmark_button.mm',
        'browser/ui/cocoa/bookmarks/bookmark_button_cell.h',
        'browser/ui/cocoa/bookmarks/bookmark_button_cell.mm',
        'browser/ui/cocoa/bookmarks/bookmark_context_menu_cocoa_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_context_menu_cocoa_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_drag_drop_cocoa.h',
        'browser/ui/cocoa/bookmarks/bookmark_drag_drop_cocoa.mm',
        'browser/ui/cocoa/bookmarks/bookmark_editor_base_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_editor_base_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_editor_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_editor_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_folder_target.h',
        'browser/ui/cocoa/bookmarks/bookmark_folder_target.mm',
        'browser/ui/cocoa/bookmarks/bookmark_menu_bridge.h',
        'browser/ui/cocoa/bookmarks/bookmark_menu_bridge.mm',
        'browser/ui/cocoa/bookmarks/bookmark_menu_cocoa_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_menu_cocoa_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_model_observer_for_cocoa.h',
        'browser/ui/cocoa/bookmarks/bookmark_model_observer_for_cocoa.mm',
        'browser/ui/cocoa/bookmarks/bookmark_name_folder_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_name_folder_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_sync_promo_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_sync_promo_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_tree_browser_cell.h',
        'browser/ui/cocoa/bookmarks/bookmark_tree_browser_cell.mm',
        'browser/ui/cocoa/browser/avatar_button_controller.h',
        'browser/ui/cocoa/browser/avatar_button_controller.mm',
        'browser/ui/cocoa/browser/avatar_label_button.h',
        'browser/ui/cocoa/browser/avatar_label_button.mm',
        'browser/ui/cocoa/browser/avatar_menu_bubble_controller.h',
        'browser/ui/cocoa/browser/avatar_menu_bubble_controller.mm',
        'browser/ui/cocoa/browser/edit_search_engine_cocoa_controller.h',
        'browser/ui/cocoa/browser/edit_search_engine_cocoa_controller.mm',
        'browser/ui/cocoa/browser/password_generation_bubble_controller.h',
        'browser/ui/cocoa/browser/password_generation_bubble_controller.mm',
        'browser/ui/cocoa/browser/zoom_bubble_controller.h',
        'browser/ui/cocoa/browser/zoom_bubble_controller.mm',
        'browser/ui/cocoa/browser_command_executor.h',
        'browser/ui/cocoa/browser_window_cocoa.h',
        'browser/ui/cocoa/browser_window_cocoa.mm',
        'browser/ui/cocoa/browser_window_controller.h',
        'browser/ui/cocoa/browser_window_controller.mm',
        'browser/ui/cocoa/browser_window_controller_private.h',
        'browser/ui/cocoa/browser_window_controller_private.mm',
        'browser/ui/cocoa/browser_window_factory.mm',
        'browser/ui/cocoa/browser_window_utils.h',
        'browser/ui/cocoa/browser_window_utils.mm',
        'browser/ui/cocoa/bubble_view.h',
        'browser/ui/cocoa/bubble_view.mm',
        'browser/ui/cocoa/certificate_viewer_mac.mm',
        'browser/ui/cocoa/chrome_browser_window.h',
        'browser/ui/cocoa/chrome_browser_window.mm',
        'browser/ui/cocoa/chrome_event_processing_window.h',
        'browser/ui/cocoa/chrome_event_processing_window.mm',
        'browser/ui/cocoa/clickhold_button_cell.h',
        'browser/ui/cocoa/clickhold_button_cell.mm',
        'browser/ui/cocoa/color_chooser_mac.mm',
        'browser/ui/cocoa/command_observer_bridge.h',
        'browser/ui/cocoa/command_observer_bridge.mm',
        'browser/ui/cocoa/confirm_bubble_cocoa.h',
        'browser/ui/cocoa/confirm_bubble_cocoa.mm',
        'browser/ui/cocoa/confirm_bubble_controller.h',
        'browser/ui/cocoa/confirm_bubble_controller.mm',
        'browser/ui/cocoa/confirm_quit.h',
        'browser/ui/cocoa/confirm_quit_panel_controller.h',
        'browser/ui/cocoa/confirm_quit_panel_controller.mm',
        'browser/ui/cocoa/constrained_web_dialog_delegate_mac.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_alert.h',
        'browser/ui/cocoa/constrained_window/constrained_window_alert.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_animation.h',
        'browser/ui/cocoa/constrained_window/constrained_window_animation.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_button.h',
        'browser/ui/cocoa/constrained_window/constrained_window_button.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_control_utils.h',
        'browser/ui/cocoa/constrained_window/constrained_window_control_utils.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_custom_sheet.h',
        'browser/ui/cocoa/constrained_window/constrained_window_custom_sheet.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_custom_window.h',
        'browser/ui/cocoa/constrained_window/constrained_window_custom_window.h',
        'browser/ui/cocoa/constrained_window/constrained_window_custom_window.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_mac.h',
        'browser/ui/cocoa/constrained_window/constrained_window_mac.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_sheet.h',
        'browser/ui/cocoa/constrained_window/constrained_window_sheet_controller.h',
        'browser/ui/cocoa/constrained_window/constrained_window_sheet_controller.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_sheet_info.h',
        'browser/ui/cocoa/constrained_window/constrained_window_sheet_info.mm',
        'browser/ui/cocoa/content_settings/collected_cookies_mac.h',
        'browser/ui/cocoa/content_settings/collected_cookies_mac.mm',
        'browser/ui/cocoa/content_settings/content_setting_bubble_cocoa.h',
        'browser/ui/cocoa/content_settings/content_setting_bubble_cocoa.mm',
        'browser/ui/cocoa/content_settings/cookie_details.h',
        'browser/ui/cocoa/content_settings/cookie_details.mm',
        'browser/ui/cocoa/content_settings/cookie_details_view_controller.h',
        'browser/ui/cocoa/content_settings/cookie_details_view_controller.mm',
        'browser/ui/cocoa/content_settings/cookie_tree_node.h',
        'browser/ui/cocoa/content_settings/cookie_tree_node.mm',
        'browser/ui/cocoa/custom_frame_view.h',
        'browser/ui/cocoa/custom_frame_view.mm',
        'browser/ui/cocoa/dev_tools_controller.h',
        'browser/ui/cocoa/dev_tools_controller.mm',
        'browser/ui/cocoa/dock_icon.h',
        'browser/ui/cocoa/dock_icon.mm',
        'browser/ui/cocoa/download/background_theme.h',
        'browser/ui/cocoa/download/background_theme.mm',
        'browser/ui/cocoa/download/download_item_button.h',
        'browser/ui/cocoa/download/download_item_button.mm',
        'browser/ui/cocoa/download/download_item_cell.h',
        'browser/ui/cocoa/download/download_item_cell.mm',
        'browser/ui/cocoa/download/download_item_controller.h',
        'browser/ui/cocoa/download/download_item_controller.mm',
        'browser/ui/cocoa/download/download_item_drag_mac.mm',
        'browser/ui/cocoa/download/download_item_mac.h',
        'browser/ui/cocoa/download/download_item_mac.mm',
        'browser/ui/cocoa/download/download_shelf_context_menu_controller.h',
        'browser/ui/cocoa/download/download_shelf_context_menu_controller.mm',
        'browser/ui/cocoa/download/download_shelf_controller.h',
        'browser/ui/cocoa/download/download_shelf_controller.mm',
        'browser/ui/cocoa/download/download_shelf_mac.h',
        'browser/ui/cocoa/download/download_shelf_mac.mm',
        'browser/ui/cocoa/download/download_shelf_view.h',
        'browser/ui/cocoa/download/download_shelf_view.mm',
        'browser/ui/cocoa/download/download_show_all_button.h',
        'browser/ui/cocoa/download/download_show_all_button.mm',
        'browser/ui/cocoa/download/download_show_all_cell.h',
        'browser/ui/cocoa/download/download_show_all_cell.mm',
        'browser/ui/cocoa/download/download_started_animation_mac.mm',
        'browser/ui/cocoa/download/download_util_mac.h',
        'browser/ui/cocoa/download/download_util_mac.mm',
        'browser/ui/cocoa/draggable_button.h',
        'browser/ui/cocoa/draggable_button.mm',
        'browser/ui/cocoa/draggable_button_mixin.h',
        'browser/ui/cocoa/draggable_button_mixin.mm',
        'browser/ui/cocoa/drag_util.h',
        'browser/ui/cocoa/drag_util.mm',
        'browser/ui/cocoa/encoding_menu_controller_delegate_mac.h',
        'browser/ui/cocoa/encoding_menu_controller_delegate_mac.mm',
        'browser/ui/cocoa/extensions/browser_action_button.h',
        'browser/ui/cocoa/extensions/browser_action_button.mm',
        'browser/ui/cocoa/extensions/browser_action_test_util_mac.mm',
        'browser/ui/cocoa/extensions/browser_actions_container_view.h',
        'browser/ui/cocoa/extensions/browser_actions_container_view.mm',
        'browser/ui/cocoa/extensions/browser_actions_controller.h',
        'browser/ui/cocoa/extensions/browser_actions_controller.mm',
        'browser/ui/cocoa/extensions/browser_actions_controller_prefs.h',
        'browser/ui/cocoa/extensions/browser_actions_controller_prefs.cc',
        'browser/ui/cocoa/extensions/extension_action_context_menu_controller.h',
        'browser/ui/cocoa/extensions/extension_action_context_menu_controller.mm',
        'browser/ui/cocoa/extensions/extension_install_dialog_controller.h',
        'browser/ui/cocoa/extensions/extension_install_dialog_controller.mm',
        'browser/ui/cocoa/extensions/extension_install_view_controller.h',
        'browser/ui/cocoa/extensions/extension_install_view_controller.mm',
        'browser/ui/cocoa/extensions/extension_installed_bubble_bridge.mm',
        'browser/ui/cocoa/extensions/extension_installed_bubble_controller.h',
        'browser/ui/cocoa/extensions/extension_installed_bubble_controller.mm',
        'browser/ui/cocoa/extensions/extension_keybinding_registry_cocoa.h',
        'browser/ui/cocoa/extensions/extension_keybinding_registry_cocoa.mm',
        'browser/ui/cocoa/extensions/extension_popup_controller.h',
        'browser/ui/cocoa/extensions/extension_popup_controller.mm',
        'browser/ui/cocoa/extensions/extension_uninstall_dialog_cocoa.mm',
        'browser/ui/cocoa/extensions/extension_view_mac.h',
        'browser/ui/cocoa/extensions/extension_view_mac.mm',
        'browser/ui/cocoa/extensions/media_galleries_dialog_cocoa.h',
        'browser/ui/cocoa/extensions/media_galleries_dialog_cocoa.mm',
        'browser/ui/cocoa/external_protocol_dialog.h',
        'browser/ui/cocoa/external_protocol_dialog.mm',
        'browser/ui/cocoa/fast_resize_view.h',
        'browser/ui/cocoa/fast_resize_view.mm',
        'browser/ui/cocoa/find_bar/find_bar_bridge.h',
        'browser/ui/cocoa/find_bar/find_bar_bridge.mm',
        'browser/ui/cocoa/find_bar/find_bar_cocoa_controller.h',
        'browser/ui/cocoa/find_bar/find_bar_cocoa_controller.mm',
        'browser/ui/cocoa/find_bar/find_bar_text_field.h',
        'browser/ui/cocoa/find_bar/find_bar_text_field.mm',
        'browser/ui/cocoa/find_bar/find_bar_text_field_cell.h',
        'browser/ui/cocoa/find_bar/find_bar_text_field_cell.mm',
        'browser/ui/cocoa/find_bar/find_bar_view.h',
        'browser/ui/cocoa/find_bar/find_bar_view.mm',
        'browser/ui/cocoa/first_run_bubble_controller.h',
        'browser/ui/cocoa/first_run_bubble_controller.mm',
        'browser/ui/cocoa/first_run_dialog.h',
        'browser/ui/cocoa/first_run_dialog.mm',
        'browser/ui/cocoa/floating_bar_backing_view.h',
        'browser/ui/cocoa/floating_bar_backing_view.mm',
        'browser/ui/cocoa/framed_browser_window.h',
        'browser/ui/cocoa/framed_browser_window.mm',
        'browser/ui/cocoa/fullscreen_exit_bubble_controller.h',
        'browser/ui/cocoa/fullscreen_exit_bubble_controller.mm',
        'browser/ui/cocoa/fullscreen_exit_bubble_view.h',
        'browser/ui/cocoa/fullscreen_exit_bubble_view.mm',
        'browser/ui/cocoa/fullscreen_mode_controller.h',
        'browser/ui/cocoa/fullscreen_mode_controller.mm',
        'browser/ui/cocoa/fullscreen_window.h',
        'browser/ui/cocoa/fullscreen_window.mm',
        'browser/ui/cocoa/global_error_bubble_controller.h',
        'browser/ui/cocoa/global_error_bubble_controller.mm',
        'browser/ui/cocoa/gradient_button_cell.h',
        'browser/ui/cocoa/gradient_button_cell.mm',
        'browser/ui/cocoa/history_menu_bridge.h',
        'browser/ui/cocoa/history_menu_bridge.mm',
        'browser/ui/cocoa/history_menu_cocoa_controller.h',
        'browser/ui/cocoa/history_menu_cocoa_controller.mm',
        'browser/ui/cocoa/history_overlay_controller.h',
        'browser/ui/cocoa/history_overlay_controller.mm',
        'browser/ui/cocoa/hover_close_button.h',
        'browser/ui/cocoa/hover_close_button.mm',
        'browser/ui/cocoa/hung_renderer_controller.h',
        'browser/ui/cocoa/hung_renderer_controller.mm',
        'browser/ui/cocoa/hyperlink_text_view.h',
        'browser/ui/cocoa/hyperlink_text_view.mm',
        'browser/ui/cocoa/image_button_cell.h',
        'browser/ui/cocoa/image_button_cell.mm',
        'browser/ui/cocoa/importer/import_lock_dialog_cocoa.mm',
        'browser/ui/cocoa/info_bubble_view.h',
        'browser/ui/cocoa/info_bubble_view.mm',
        'browser/ui/cocoa/info_bubble_window.h',
        'browser/ui/cocoa/info_bubble_window.mm',
        'browser/ui/cocoa/infobars/after_translate_infobar_controller.h',
        'browser/ui/cocoa/infobars/after_translate_infobar_controller.mm',
        'browser/ui/cocoa/infobars/alternate_nav_infobar_controller.h',
        'browser/ui/cocoa/infobars/alternate_nav_infobar_controller.mm',
        'browser/ui/cocoa/infobars/before_translate_infobar_controller.h',
        'browser/ui/cocoa/infobars/before_translate_infobar_controller.mm',
        'browser/ui/cocoa/infobars/confirm_infobar_controller.h',
        'browser/ui/cocoa/infobars/confirm_infobar_controller.mm',
        'browser/ui/cocoa/infobars/extension_infobar_controller.h',
        'browser/ui/cocoa/infobars/extension_infobar_controller.mm',
        'browser/ui/cocoa/infobars/infobar_cocoa.h',
        'browser/ui/cocoa/infobars/infobar_cocoa.mm',
        'browser/ui/cocoa/infobars/infobar_container_cocoa.h',
        'browser/ui/cocoa/infobars/infobar_container_cocoa.mm',
        'browser/ui/cocoa/infobars/infobar_container_controller.h',
        'browser/ui/cocoa/infobars/infobar_container_controller.mm',
        'browser/ui/cocoa/infobars/infobar_controller.h',
        'browser/ui/cocoa/infobars/infobar_controller.mm',
        'browser/ui/cocoa/infobars/infobar_gradient_view.h',
        'browser/ui/cocoa/infobars/infobar_gradient_view.mm',
        'browser/ui/cocoa/infobars/infobar_utilities.h',
        'browser/ui/cocoa/infobars/infobar_utilities.mm',
        'browser/ui/cocoa/infobars/translate_infobar_base.h',
        'browser/ui/cocoa/infobars/translate_infobar_base.mm',
        'browser/ui/cocoa/infobars/translate_message_infobar_controller.h',
        'browser/ui/cocoa/infobars/translate_message_infobar_controller.mm',
        'browser/ui/cocoa/javascript_app_modal_dialog_cocoa.h',
        'browser/ui/cocoa/javascript_app_modal_dialog_cocoa.mm',
        'browser/ui/cocoa/key_equivalent_constants.h',
        'browser/ui/cocoa/key_equivalent_constants.mm',
        'browser/ui/cocoa/keystone_infobar_delegate.h',
        'browser/ui/cocoa/keystone_infobar_delegate.mm',
        'browser/ui/cocoa/l10n_util.h',
        'browser/ui/cocoa/l10n_util.mm',
        'browser/ui/cocoa/last_active_browser_cocoa.cc',
        'browser/ui/cocoa/last_active_browser_cocoa.h',
        'browser/ui/cocoa/location_bar/autocomplete_text_field.h',
        'browser/ui/cocoa/location_bar/autocomplete_text_field.mm',
        'browser/ui/cocoa/location_bar/autocomplete_text_field_cell.h',
        'browser/ui/cocoa/location_bar/autocomplete_text_field_cell.mm',
        'browser/ui/cocoa/location_bar/autocomplete_text_field_editor.h',
        'browser/ui/cocoa/location_bar/autocomplete_text_field_editor.mm',
        'browser/ui/cocoa/location_bar/bubble_decoration.h',
        'browser/ui/cocoa/location_bar/bubble_decoration.mm',
        'browser/ui/cocoa/location_bar/button_decoration.h',
        'browser/ui/cocoa/location_bar/button_decoration.mm',
        'browser/ui/cocoa/location_bar/content_setting_decoration.h',
        'browser/ui/cocoa/location_bar/content_setting_decoration.mm',
        'browser/ui/cocoa/location_bar/ev_bubble_decoration.h',
        'browser/ui/cocoa/location_bar/ev_bubble_decoration.mm',
        'browser/ui/cocoa/location_bar/image_decoration.h',
        'browser/ui/cocoa/location_bar/image_decoration.mm',
        'browser/ui/cocoa/location_bar/keyword_hint_decoration.h',
        'browser/ui/cocoa/location_bar/keyword_hint_decoration.mm',
        'browser/ui/cocoa/location_bar/location_bar_decoration.h',
        'browser/ui/cocoa/location_bar/location_bar_decoration.mm',
        'browser/ui/cocoa/location_bar/location_bar_view_mac.h',
        'browser/ui/cocoa/location_bar/location_bar_view_mac.mm',
        'browser/ui/cocoa/location_bar/location_icon_decoration.h',
        'browser/ui/cocoa/location_bar/location_icon_decoration.mm',
        'browser/ui/cocoa/location_bar/mic_search_decoration.h',
        'browser/ui/cocoa/location_bar/mic_search_decoration.mm',
        'browser/ui/cocoa/location_bar/page_action_decoration.h',
        'browser/ui/cocoa/location_bar/page_action_decoration.mm',
        'browser/ui/cocoa/location_bar/selected_keyword_decoration.h',
        'browser/ui/cocoa/location_bar/selected_keyword_decoration.mm',
        'browser/ui/cocoa/location_bar/star_decoration.h',
        'browser/ui/cocoa/location_bar/star_decoration.mm',
        'browser/ui/cocoa/location_bar/zoom_decoration.h',
        'browser/ui/cocoa/location_bar/zoom_decoration.mm',
        'browser/ui/cocoa/login_prompt_cocoa.h',
        'browser/ui/cocoa/login_prompt_cocoa.mm',
        'browser/ui/cocoa/main_menu_item.h',
        'browser/ui/cocoa/media_picker/desktop_media_picker_bridge.h',
        'browser/ui/cocoa/media_picker/desktop_media_picker_bridge.mm',
        'browser/ui/cocoa/media_picker/desktop_media_picker_cocoa.h',
        'browser/ui/cocoa/media_picker/desktop_media_picker_cocoa.mm',
        'browser/ui/cocoa/media_picker/desktop_media_picker_controller.h',
        'browser/ui/cocoa/media_picker/desktop_media_picker_controller.mm',
        'browser/ui/cocoa/media_picker/desktop_media_picker_item.h',
        'browser/ui/cocoa/media_picker/desktop_media_picker_item.mm',
        'browser/ui/cocoa/menu_button.h',
        'browser/ui/cocoa/menu_button.mm',
        'browser/ui/cocoa/multi_key_equivalent_button.h',
        'browser/ui/cocoa/multi_key_equivalent_button.mm',
        'browser/ui/cocoa/new_tab_button.h',
        'browser/ui/cocoa/new_tab_button.mm',
        'browser/ui/cocoa/notifications/balloon_collection_cocoa.mm',
        'browser/ui/cocoa/notifications/balloon_controller.h',
        'browser/ui/cocoa/notifications/balloon_controller.mm',
        'browser/ui/cocoa/notifications/balloon_view.h',
        'browser/ui/cocoa/notifications/balloon_view.mm',
        'browser/ui/cocoa/notifications/balloon_view_bridge.h',
        'browser/ui/cocoa/notifications/balloon_view_bridge.mm',
        'browser/ui/cocoa/notifications/balloon_view_host_mac.h',
        'browser/ui/cocoa/notifications/balloon_view_host_mac.mm',
        'browser/ui/cocoa/notifications/message_center_tray_bridge.h',
        'browser/ui/cocoa/notifications/message_center_tray_bridge.mm',
        'browser/ui/cocoa/nsmenuitem_additions.h',
        'browser/ui/cocoa/nsmenuitem_additions.mm',
        'browser/ui/cocoa/nsview_additions.h',
        'browser/ui/cocoa/nsview_additions.mm',
        'browser/ui/cocoa/omnibox/omnibox_popup_cell.h',
        'browser/ui/cocoa/omnibox/omnibox_popup_cell.mm',
        'browser/ui/cocoa/omnibox/omnibox_popup_matrix.h',
        'browser/ui/cocoa/omnibox/omnibox_popup_matrix.mm',
        'browser/ui/cocoa/omnibox/omnibox_popup_separator_view.h',
        'browser/ui/cocoa/omnibox/omnibox_popup_separator_view.mm',
        'browser/ui/cocoa/omnibox/omnibox_popup_view_mac.h',
        'browser/ui/cocoa/omnibox/omnibox_popup_view_mac.mm',
        'browser/ui/cocoa/omnibox/omnibox_view_mac.h',
        'browser/ui/cocoa/omnibox/omnibox_view_mac.mm',
        'browser/ui/cocoa/one_click_signin_bubble_controller.h',
        'browser/ui/cocoa/one_click_signin_bubble_controller.mm',
        'browser/ui/cocoa/one_click_signin_dialog_controller.h',
        'browser/ui/cocoa/one_click_signin_dialog_controller.mm',
        'browser/ui/cocoa/one_click_signin_view_controller.h',
        'browser/ui/cocoa/one_click_signin_view_controller.mm',
        'browser/ui/cocoa/panels/display_settings_provider_cocoa.mm',
        'browser/ui/cocoa/panels/mouse_drag_controller.h',
        'browser/ui/cocoa/panels/mouse_drag_controller.mm',
        'browser/ui/cocoa/panels/panel_cocoa.h',
        'browser/ui/cocoa/panels/panel_cocoa.mm',
        'browser/ui/cocoa/panels/panel_stack_window_cocoa.h',
        'browser/ui/cocoa/panels/panel_stack_window_cocoa.mm',
        'browser/ui/cocoa/panels/panel_titlebar_view_cocoa.h',
        'browser/ui/cocoa/panels/panel_titlebar_view_cocoa.mm',
        'browser/ui/cocoa/panels/panel_utils_cocoa.h',
        'browser/ui/cocoa/panels/panel_utils_cocoa.mm',
        'browser/ui/cocoa/panels/panel_window_controller_cocoa.h',
        'browser/ui/cocoa/panels/panel_window_controller_cocoa.mm',
        'browser/ui/cocoa/pdf_password_dialog.mm',
        'browser/ui/cocoa/presentation_mode_controller.h',
        'browser/ui/cocoa/presentation_mode_controller.mm',
        'browser/ui/cocoa/profile_menu_controller.h',
        'browser/ui/cocoa/profile_menu_controller.mm',
        'browser/ui/cocoa/rect_path_utils.h',
        'browser/ui/cocoa/rect_path_utils.mm',
        'browser/ui/cocoa/restart_browser.h',
        'browser/ui/cocoa/restart_browser.mm',
        'browser/ui/cocoa/screen_capture_notification_ui_cocoa.h',
        'browser/ui/cocoa/screen_capture_notification_ui_cocoa.mm',
        'browser/ui/cocoa/simple_message_box_mac.mm',
        'browser/ui/cocoa/speech_recognition_bubble_cocoa.mm',
        'browser/ui/cocoa/speech_recognition_window_controller.h',
        'browser/ui/cocoa/speech_recognition_window_controller.mm',
        'browser/ui/cocoa/ssl_client_certificate_selector_cocoa.h',
        'browser/ui/cocoa/ssl_client_certificate_selector_cocoa.mm',
        'browser/ui/cocoa/status_bubble_mac.h',
        'browser/ui/cocoa/status_bubble_mac.mm',
        'browser/ui/cocoa/status_icons/status_icon_mac.h',
        'browser/ui/cocoa/status_icons/status_icon_mac.mm',
        'browser/ui/cocoa/status_icons/status_tray_mac.h',
        'browser/ui/cocoa/status_icons/status_tray_mac.mm',
        'browser/ui/cocoa/styled_text_field.h',
        'browser/ui/cocoa/styled_text_field.mm',
        'browser/ui/cocoa/styled_text_field_cell.h',
        'browser/ui/cocoa/styled_text_field_cell.mm',
        'browser/ui/cocoa/profile_signin_confirmation_dialog_cocoa.h',
        'browser/ui/cocoa/profile_signin_confirmation_dialog_cocoa.mm',
        'browser/ui/cocoa/profile_signin_confirmation_view_controller.h',
        'browser/ui/cocoa/profile_signin_confirmation_view_controller.mm',
        'browser/ui/cocoa/tab_contents/chrome_web_contents_view_delegate_mac.h',
        'browser/ui/cocoa/tab_contents/chrome_web_contents_view_delegate_mac.mm',
        'browser/ui/cocoa/tab_contents/favicon_util_mac.h',
        'browser/ui/cocoa/tab_contents/favicon_util_mac.mm',
        'browser/ui/cocoa/tab_contents/overlayable_contents_controller.h',
        'browser/ui/cocoa/tab_contents/overlayable_contents_controller.mm',
        'browser/ui/cocoa/tab_contents/render_view_context_menu_mac.h',
        'browser/ui/cocoa/tab_contents/render_view_context_menu_mac.mm',
        'browser/ui/cocoa/tab_contents/sad_tab_controller.h',
        'browser/ui/cocoa/tab_contents/sad_tab_controller.mm',
        'browser/ui/cocoa/tab_contents/sad_tab_view.h',
        'browser/ui/cocoa/tab_contents/sad_tab_view.mm',
        'browser/ui/cocoa/tab_contents/tab_contents_controller.h',
        'browser/ui/cocoa/tab_contents/tab_contents_controller.mm',
        'browser/ui/cocoa/tab_contents/web_drag_bookmark_handler_mac.h',
        'browser/ui/cocoa/tab_contents/web_drag_bookmark_handler_mac.mm',
        'browser/ui/cocoa/tab_modal_confirm_dialog_mac.h',
        'browser/ui/cocoa/tab_modal_confirm_dialog_mac.mm',
        'browser/ui/cocoa/table_row_nsimage_cache.h',
        'browser/ui/cocoa/table_row_nsimage_cache.mm',
        'browser/ui/cocoa/tabpose_window.h',
        'browser/ui/cocoa/tabpose_window.mm',
        'browser/ui/cocoa/tabs/dock_info_mac.cc',
        'browser/ui/cocoa/tabs/tab_controller.h',
        'browser/ui/cocoa/tabs/tab_controller.mm',
        'browser/ui/cocoa/tabs/tab_projecting_image_view.h',
        'browser/ui/cocoa/tabs/tab_projecting_image_view.mm',
        'browser/ui/cocoa/tabs/tab_strip_controller.h',
        'browser/ui/cocoa/tabs/tab_strip_controller.mm',
        'browser/ui/cocoa/tabs/tab_strip_drag_controller.h',
        'browser/ui/cocoa/tabs/tab_strip_drag_controller.mm',
        'browser/ui/cocoa/tabs/tab_strip_model_observer_bridge.h',
        'browser/ui/cocoa/tabs/tab_strip_model_observer_bridge.mm',
        'browser/ui/cocoa/tabs/tab_strip_view.h',
        'browser/ui/cocoa/tabs/tab_strip_view.mm',
        'browser/ui/cocoa/tabs/tab_view.h',
        'browser/ui/cocoa/tabs/tab_view.mm',
        'browser/ui/cocoa/tabs/tab_window_controller.h',
        'browser/ui/cocoa/tabs/tab_window_controller.mm',
        'browser/ui/cocoa/tabs/throbber_view.h',
        'browser/ui/cocoa/tabs/throbber_view.mm',
        'browser/ui/cocoa/tabs/throbbing_image_view.h',
        'browser/ui/cocoa/tabs/throbbing_image_view.mm',
        'browser/ui/cocoa/task_manager_mac.h',
        'browser/ui/cocoa/task_manager_mac.mm',
        'browser/ui/cocoa/themed_window.h',
        'browser/ui/cocoa/themed_window.mm',
        'browser/ui/cocoa/toolbar/back_forward_menu_controller.h',
        'browser/ui/cocoa/toolbar/back_forward_menu_controller.mm',
        'browser/ui/cocoa/toolbar/reload_button.h',
        'browser/ui/cocoa/toolbar/reload_button.mm',
        'browser/ui/cocoa/toolbar/toolbar_button.h',
        'browser/ui/cocoa/toolbar/toolbar_button.mm',
        'browser/ui/cocoa/toolbar/toolbar_controller.h',
        'browser/ui/cocoa/toolbar/toolbar_controller.mm',
        'browser/ui/cocoa/toolbar/toolbar_view.h',
        'browser/ui/cocoa/toolbar/toolbar_view.mm',
        'browser/ui/cocoa/toolbar/wrench_toolbar_button_cell.h',
        'browser/ui/cocoa/toolbar/wrench_toolbar_button_cell.mm',
        'browser/ui/cocoa/ui_localizer.h',
        'browser/ui/cocoa/ui_localizer.mm',
        'browser/ui/cocoa/url_drop_target.h',
        'browser/ui/cocoa/url_drop_target.mm',
        'browser/ui/cocoa/validation_message_bubble_cocoa.mm',
        'browser/ui/cocoa/validation_message_bubble_controller.h',
        'browser/ui/cocoa/vertical_gradient_view.h',
        'browser/ui/cocoa/vertical_gradient_view.mm',
        'browser/ui/cocoa/view_id_util.h',
        'browser/ui/cocoa/view_id_util.mm',
        'browser/ui/cocoa/view_resizer.h',
        'browser/ui/cocoa/web_contents_modal_dialog_manager_cocoa.mm',
        'browser/ui/cocoa/web_dialog_window_controller.h',
        'browser/ui/cocoa/web_dialog_window_controller.mm',
        'browser/ui/cocoa/website_settings_bubble_controller.h',
        'browser/ui/cocoa/website_settings_bubble_controller.mm',
        'browser/ui/cocoa/window_restore_utils.h',
        'browser/ui/cocoa/window_restore_utils.mm',
        'browser/ui/cocoa/window_size_autosaver.h',
        'browser/ui/cocoa/window_size_autosaver.mm',
        'browser/ui/cocoa/wrench_menu/menu_tracked_button.h',
        'browser/ui/cocoa/wrench_menu/menu_tracked_button.mm',
        'browser/ui/cocoa/wrench_menu/menu_tracked_root_view.h',
        'browser/ui/cocoa/wrench_menu/menu_tracked_root_view.mm',
        'browser/ui/cocoa/wrench_menu/recent_tabs_menu_model_delegate.h',
        'browser/ui/cocoa/wrench_menu/recent_tabs_menu_model_delegate.mm',
        'browser/ui/cocoa/wrench_menu/wrench_menu_button_cell.h',
        'browser/ui/cocoa/wrench_menu/wrench_menu_button_cell.mm',
        'browser/ui/cocoa/wrench_menu/wrench_menu_controller.h',
        'browser/ui/cocoa/wrench_menu/wrench_menu_controller.mm',
        'browser/ui/collected_cookies_infobar_delegate.cc',
        'browser/ui/collected_cookies_infobar_delegate.h',
        'browser/ui/confirm_bubble.h',
        'browser/ui/confirm_bubble_model.cc',
        'browser/ui/confirm_bubble_model.h',
        'browser/ui/content_settings/content_setting_bubble_model.cc',
        'browser/ui/content_settings/content_setting_bubble_model.h',
        'browser/ui/content_settings/content_setting_bubble_model_delegate.h',
        'browser/ui/content_settings/content_setting_image_model.cc',
        'browser/ui/content_settings/content_setting_image_model.h',
        'browser/ui/content_settings/content_setting_media_menu_model.cc',
        'browser/ui/content_settings/content_setting_media_menu_model.h',
        'browser/ui/content_settings/media_setting_changed_infobar_delegate.cc',
        'browser/ui/content_settings/media_setting_changed_infobar_delegate.h',
        'browser/ui/crypto_module_password_dialog.cc',
        'browser/ui/crypto_module_password_dialog.h',
        'browser/ui/crypto_module_password_dialog_nss.cc',
        'browser/ui/crypto_module_password_dialog_openssl.cc',
        'browser/ui/extensions/application_launch.cc',
        'browser/ui/extensions/application_launch.h',
        'browser/ui/extensions/extension_installed_bubble.cc',
        'browser/ui/extensions/extension_installed_bubble.h',
        'browser/ui/extensions/extension_install_ui_default.cc',
        'browser/ui/extensions/extension_install_ui_default.h',
        'browser/ui/extensions/extension_enable_flow.cc',
        'browser/ui/extensions/extension_enable_flow.h',
        'browser/ui/extensions/extension_enable_flow_delegate.h',
        'browser/ui/external_protocol_dialog_delegate.cc',
        'browser/ui/external_protocol_dialog_delegate.h',
        'browser/ui/fast_unload_controller.cc',
        'browser/ui/fast_unload_controller.h',
        'browser/ui/find_bar/find_bar.h',
        'browser/ui/find_bar/find_bar_controller.cc',
        'browser/ui/find_bar/find_bar_controller.h',
        'browser/ui/find_bar/find_bar_state.h',
        'browser/ui/find_bar/find_bar_state_factory.cc',
        'browser/ui/find_bar/find_bar_state_factory.h',
        'browser/ui/find_bar/find_notification_details.h',
        'browser/ui/find_bar/find_tab_helper.cc',
        'browser/ui/find_bar/find_tab_helper.h',
        'browser/ui/fullscreen/fullscreen_controller.cc',
        'browser/ui/fullscreen/fullscreen_controller.h',
        'browser/ui/fullscreen/fullscreen_exit_bubble.cc',
        'browser/ui/fullscreen/fullscreen_exit_bubble.h',
        'browser/ui/fullscreen/fullscreen_exit_bubble_type.cc',
        'browser/ui/fullscreen/fullscreen_exit_bubble_type.h',
        'browser/ui/gesture_prefs_observer_factory_aura.cc',
        'browser/ui/gesture_prefs_observer_factory_aura.h',
        'browser/ui/global_error/global_error.cc',
        'browser/ui/global_error/global_error.h',
        'browser/ui/global_error/global_error_bubble_view_base.h',
        'browser/ui/global_error/global_error_service.cc',
        'browser/ui/global_error/global_error_service.h',
        'browser/ui/global_error/global_error_service_factory.cc',
        'browser/ui/global_error/global_error_service_factory.h',
        'browser/ui/gtk/accelerator_utils_gtk.cc',
        'browser/ui/gtk/accelerators_gtk.cc',
        'browser/ui/gtk/accelerators_gtk.h',
        'browser/ui/gtk/apps/chrome_shell_window_delegate_gtk.cc',
        'browser/ui/gtk/apps/native_app_window_gtk.cc',
        'browser/ui/gtk/apps/native_app_window_gtk.h',
        'browser/ui/gtk/autofill/autofill_popup_view_gtk.cc',
        'browser/ui/gtk/autofill/autofill_popup_view_gtk.h',
        'browser/ui/gtk/avatar_menu_bubble_gtk.cc',
        'browser/ui/gtk/avatar_menu_bubble_gtk.h',
        'browser/ui/gtk/avatar_menu_button_gtk.cc',
        'browser/ui/gtk/avatar_menu_button_gtk.h',
        'browser/ui/gtk/avatar_menu_item_gtk.cc',
        'browser/ui/gtk/avatar_menu_item_gtk.h',
        'browser/ui/gtk/back_forward_button_gtk.cc',
        'browser/ui/gtk/back_forward_button_gtk.h',
        'browser/ui/gtk/bookmarks/bookmark_bar_gtk.cc',
        'browser/ui/gtk/bookmarks/bookmark_bar_gtk.h',
        'browser/ui/gtk/bookmarks/bookmark_bar_instructions_gtk.cc',
        'browser/ui/gtk/bookmarks/bookmark_bar_instructions_gtk.h',
        'browser/ui/gtk/bookmarks/bookmark_bubble_gtk.cc',
        'browser/ui/gtk/bookmarks/bookmark_bubble_gtk.h',
        'browser/ui/gtk/bookmarks/bookmark_drag_drop_gtk.cc',
        'browser/ui/gtk/bookmarks/bookmark_editor_gtk.cc',
        'browser/ui/gtk/bookmarks/bookmark_editor_gtk.h',
        'browser/ui/gtk/bookmarks/bookmark_menu_controller_gtk.cc',
        'browser/ui/gtk/bookmarks/bookmark_menu_controller_gtk.h',
        'browser/ui/gtk/bookmarks/bookmark_sub_menu_model_gtk.cc',
        'browser/ui/gtk/bookmarks/bookmark_sub_menu_model_gtk.h',
        'browser/ui/gtk/bookmarks/bookmark_tree_model.cc',
        'browser/ui/gtk/bookmarks/bookmark_tree_model.h',
        'browser/ui/gtk/bookmarks/bookmark_utils_gtk.cc',
        'browser/ui/gtk/bookmarks/bookmark_utils_gtk.h',
        'browser/ui/gtk/browser_actions_toolbar_gtk.cc',
        'browser/ui/gtk/browser_actions_toolbar_gtk.h',
        'browser/ui/gtk/browser_titlebar.cc',
        'browser/ui/gtk/browser_titlebar.h',
        'browser/ui/gtk/browser_toolbar_gtk.cc',
        'browser/ui/gtk/browser_toolbar_gtk.h',
        'browser/ui/gtk/browser_window_gtk.cc',
        'browser/ui/gtk/browser_window_gtk.h',
        'browser/ui/gtk/bubble/bubble_accelerators_gtk.cc',
        'browser/ui/gtk/bubble/bubble_accelerators_gtk.h',
        'browser/ui/gtk/bubble/bubble_gtk.cc',
        'browser/ui/gtk/bubble/bubble_gtk.h',
        'browser/ui/gtk/certificate_viewer_gtk.cc',
        'browser/ui/gtk/chrome_browser_main_extra_parts_gtk.cc',
        'browser/ui/gtk/chrome_browser_main_extra_parts_gtk.h',
        'browser/ui/gtk/chrome_gtk_frame.cc',
        'browser/ui/gtk/chrome_gtk_frame.h',
        'browser/ui/gtk/collected_cookies_gtk.cc',
        'browser/ui/gtk/collected_cookies_gtk.h',
        'browser/ui/gtk/confirm_bubble_gtk.cc',
        'browser/ui/gtk/confirm_bubble_gtk.h',
        'browser/ui/gtk/color_chooser_gtk.cc',
        'browser/ui/gtk/constrained_web_dialog_delegate_gtk.cc',
        'browser/ui/gtk/constrained_window_gtk.cc',
        'browser/ui/gtk/constrained_window_gtk.h',
        'browser/ui/gtk/content_setting_bubble_gtk.cc',
        'browser/ui/gtk/content_setting_bubble_gtk.h',
        'browser/ui/gtk/create_application_shortcuts_dialog_gtk.cc',
        'browser/ui/gtk/create_application_shortcuts_dialog_gtk.h',
        'browser/ui/gtk/crypto_module_password_dialog_gtk.cc',
        'browser/ui/gtk/custom_button.cc',
        'browser/ui/gtk/custom_button.h',
        'browser/ui/gtk/custom_drag.cc',
        'browser/ui/gtk/custom_drag.h',
        'browser/ui/gtk/download/download_in_progress_dialog_gtk.cc',
        'browser/ui/gtk/download/download_in_progress_dialog_gtk.h',
        'browser/ui/gtk/download/download_item_drag.cc',
        'browser/ui/gtk/download/download_item_drag.h',
        'browser/ui/gtk/download/download_item_gtk.cc',
        'browser/ui/gtk/download/download_item_gtk.h',
        'browser/ui/gtk/download/download_shelf_context_menu_gtk.cc',
        'browser/ui/gtk/download/download_shelf_context_menu_gtk.h',
        'browser/ui/gtk/download/download_shelf_gtk.cc',
        'browser/ui/gtk/download/download_shelf_gtk.h',
        'browser/ui/gtk/download/download_started_animation_gtk.cc',
        'browser/ui/gtk/edit_search_engine_dialog.cc',
        'browser/ui/gtk/edit_search_engine_dialog.h',
        'browser/ui/gtk/event_utils.cc',
        'browser/ui/gtk/event_utils.h',
        'browser/ui/gtk/extensions/browser_action_test_util_gtk.cc',
        'browser/ui/gtk/extensions/bundle_installed_bubble_gtk.cc',
        'browser/ui/gtk/extensions/bundle_installed_bubble_gtk.h',
        'browser/ui/gtk/extensions/extension_install_dialog_gtk.cc',
        'browser/ui/gtk/extensions/extension_installed_bubble_gtk.cc',
        'browser/ui/gtk/extensions/extension_installed_bubble_gtk.h',
        'browser/ui/gtk/extensions/extension_keybinding_registry_gtk.cc',
        'browser/ui/gtk/extensions/extension_keybinding_registry_gtk.h',
        'browser/ui/gtk/extensions/extension_popup_gtk.cc',
        'browser/ui/gtk/extensions/extension_popup_gtk.h',
        'browser/ui/gtk/extensions/extension_uninstall_dialog_gtk.cc',
        'browser/ui/gtk/extensions/extension_view_gtk.cc',
        'browser/ui/gtk/extensions/extension_view_gtk.h',
        'browser/ui/gtk/extensions/media_galleries_dialog_gtk.cc',
        'browser/ui/gtk/extensions/media_galleries_dialog_gtk.h',
        'browser/ui/gtk/find_bar_gtk.cc',
        'browser/ui/gtk/find_bar_gtk.h',
        'browser/ui/gtk/first_run_bubble.cc',
        'browser/ui/gtk/first_run_bubble.h',
        'browser/ui/gtk/first_run_dialog.cc',
        'browser/ui/gtk/first_run_dialog.h',
        'browser/ui/gtk/fullscreen_exit_bubble_gtk.cc',
        'browser/ui/gtk/fullscreen_exit_bubble_gtk.h',
        'browser/ui/gtk/gconf_titlebar_listener.cc',
        'browser/ui/gtk/gconf_titlebar_listener.h',
        'browser/ui/gtk/global_error_bubble.cc',
        'browser/ui/gtk/global_error_bubble.h',
        'browser/ui/gtk/global_history_menu.cc',
        'browser/ui/gtk/global_history_menu.h',
        'browser/ui/gtk/global_menu_bar.cc',
        'browser/ui/gtk/global_menu_bar.h',
        'browser/ui/gtk/gtk_chrome_button.cc',
        'browser/ui/gtk/gtk_chrome_button.h',
        'browser/ui/gtk/gtk_chrome_cookie_view.cc',
        'browser/ui/gtk/gtk_chrome_cookie_view.h',
        'browser/ui/gtk/gtk_chrome_link_button.cc',
        'browser/ui/gtk/gtk_chrome_link_button.h',
        'browser/ui/gtk/gtk_chrome_shrinkable_hbox.cc',
        'browser/ui/gtk/gtk_chrome_shrinkable_hbox.h',
        'browser/ui/gtk/gtk_custom_menu.cc',
        'browser/ui/gtk/gtk_custom_menu.h',
        'browser/ui/gtk/gtk_custom_menu_item.cc',
        'browser/ui/gtk/gtk_custom_menu_item.h',
        'browser/ui/gtk/gtk_input_event_box.cc',
        'browser/ui/gtk/gtk_input_event_box.h',
        'browser/ui/gtk/gtk_theme_service.cc',
        'browser/ui/gtk/gtk_theme_service.h',
        'browser/ui/gtk/gtk_tree.cc',
        'browser/ui/gtk/gtk_tree.h',
        'browser/ui/gtk/gtk_util.cc',
        'browser/ui/gtk/gtk_util.h',
        'browser/ui/gtk/gtk_window_util.cc',
        'browser/ui/gtk/gtk_window_util.h',
        'browser/ui/gtk/hover_controller_gtk.cc',
        'browser/ui/gtk/hover_controller_gtk.h',
        'browser/ui/gtk/hung_renderer_dialog_gtk.cc',
        'browser/ui/gtk/importer/import_lock_dialog_gtk.cc',
        'browser/ui/gtk/importer/import_lock_dialog_gtk.h',
        'browser/ui/gtk/infobars/after_translate_infobar_gtk.cc',
        'browser/ui/gtk/infobars/after_translate_infobar_gtk.h',
        'browser/ui/gtk/infobars/alternate_nav_infobar_gtk.cc',
        'browser/ui/gtk/infobars/alternate_nav_infobar_gtk.h',
        'browser/ui/gtk/infobars/before_translate_infobar_gtk.cc',
        'browser/ui/gtk/infobars/before_translate_infobar_gtk.h',
        'browser/ui/gtk/infobars/confirm_infobar_gtk.cc',
        'browser/ui/gtk/infobars/confirm_infobar_gtk.h',
        'browser/ui/gtk/infobars/extension_infobar_gtk.cc',
        'browser/ui/gtk/infobars/extension_infobar_gtk.h',
        'browser/ui/gtk/infobars/infobar_container_gtk.cc',
        'browser/ui/gtk/infobars/infobar_container_gtk.h',
        'browser/ui/gtk/infobars/infobar_gtk.cc',
        'browser/ui/gtk/infobars/infobar_gtk.h',
        'browser/ui/gtk/infobars/translate_infobar_base_gtk.cc',
        'browser/ui/gtk/infobars/translate_infobar_base_gtk.h',
        'browser/ui/gtk/infobars/translate_message_infobar_gtk.cc',
        'browser/ui/gtk/infobars/translate_message_infobar_gtk.h',
        'browser/ui/gtk/javascript_app_modal_dialog_gtk.cc',
        'browser/ui/gtk/javascript_app_modal_dialog_gtk.h',
        'browser/ui/gtk/location_bar_view_gtk.cc',
        'browser/ui/gtk/location_bar_view_gtk.h',
        'browser/ui/gtk/login_prompt_gtk.cc',
        'browser/ui/gtk/menu_bar_helper.cc',
        'browser/ui/gtk/menu_bar_helper.h',
        'browser/ui/gtk/menu_gtk.cc',
        'browser/ui/gtk/menu_gtk.h',
        'browser/ui/gtk/nine_box.cc',
        'browser/ui/gtk/nine_box.h',
        'browser/ui/gtk/notifications/balloon_collection_gtk.cc',
        'browser/ui/gtk/notifications/balloon_view_gtk.cc',
        'browser/ui/gtk/notifications/balloon_view_gtk.h',
        'browser/ui/gtk/notifications/balloon_view_host_gtk.cc',
        'browser/ui/gtk/notifications/balloon_view_host_gtk.h',
        'browser/ui/gtk/omnibox/omnibox_popup_view_gtk.cc',
        'browser/ui/gtk/omnibox/omnibox_popup_view_gtk.h',
        'browser/ui/gtk/omnibox/omnibox_view_gtk.cc',
        'browser/ui/gtk/omnibox/omnibox_view_gtk.h',
        'browser/ui/gtk/one_click_signin_bubble_gtk.cc',
        'browser/ui/gtk/one_click_signin_bubble_gtk.h',
        'browser/ui/gtk/overflow_button.cc',
        'browser/ui/gtk/overflow_button.h',
        'browser/ui/gtk/panels/display_settings_provider_gtk.cc',
        'browser/ui/gtk/panels/panel_drag_gtk.cc',
        'browser/ui/gtk/panels/panel_drag_gtk.h',
        'browser/ui/gtk/panels/panel_gtk.cc',
        'browser/ui/gtk/panels/panel_gtk.h',
        'browser/ui/gtk/panels/panel_stack_window_gtk.cc',
        'browser/ui/gtk/panels/panel_stack_window_gtk.h',
        'browser/ui/gtk/panels/panel_titlebar_gtk.cc',
        'browser/ui/gtk/panels/panel_titlebar_gtk.h',
        'browser/ui/gtk/password_generation_bubble_gtk.cc',
        'browser/ui/gtk/password_generation_bubble_gtk.h',
        'browser/ui/gtk/process_singleton_dialog.cc',
        'browser/ui/gtk/process_singleton_dialog.h',
        'browser/ui/gtk/protocol_dialog_gtk.cc',
        'browser/ui/gtk/protocol_dialog_gtk.h',
        'browser/ui/gtk/reload_button_gtk.cc',
        'browser/ui/gtk/reload_button_gtk.h',
        'browser/ui/gtk/rounded_window.cc',
        'browser/ui/gtk/rounded_window.h',
        'browser/ui/gtk/sad_tab_gtk.cc',
        'browser/ui/gtk/sad_tab_gtk.h',
        'browser/ui/gtk/screen_capture_notification_ui_gtk.cc',
        'browser/ui/gtk/script_bubble_gtk.cc',
        'browser/ui/gtk/script_bubble_gtk.h',
        'browser/ui/gtk/simple_message_box_gtk.cc',
        'browser/ui/gtk/slide_animator_gtk.cc',
        'browser/ui/gtk/slide_animator_gtk.h',
        'browser/ui/gtk/speech_recognition_bubble_gtk.cc',
        'browser/ui/gtk/ssl_client_certificate_selector.cc',
        'browser/ui/gtk/status_bubble_gtk.cc',
        'browser/ui/gtk/status_bubble_gtk.h',
        'browser/ui/gtk/status_icons/status_icon_gtk.cc',
        'browser/ui/gtk/status_icons/status_icon_gtk.h',
        'browser/ui/gtk/status_icons/status_tray_gtk.cc',
        'browser/ui/gtk/status_icons/status_tray_gtk.h',
        'browser/ui/gtk/tab_contents/chrome_web_contents_view_delegate_gtk.cc',
        'browser/ui/gtk/tab_contents/chrome_web_contents_view_delegate_gtk.h',
        'browser/ui/gtk/tab_contents/render_view_context_menu_gtk.cc',
        'browser/ui/gtk/tab_contents/render_view_context_menu_gtk.h',
        'browser/ui/gtk/tab_contents/web_drag_bookmark_handler_gtk.cc',
        'browser/ui/gtk/tab_contents/web_drag_bookmark_handler_gtk.h',
        'browser/ui/gtk/tab_contents_container_gtk.cc',
        'browser/ui/gtk/tab_contents_container_gtk.h',
        'browser/ui/gtk/tab_modal_confirm_dialog_gtk.cc',
        'browser/ui/gtk/tab_modal_confirm_dialog_gtk.h',
        'browser/ui/gtk/tabs/dock_info_gtk.cc',
        'browser/ui/gtk/tabs/drag_data.cc',
        'browser/ui/gtk/tabs/drag_data.h',
        'browser/ui/gtk/tabs/dragged_tab_controller_gtk.cc',
        'browser/ui/gtk/tabs/dragged_tab_controller_gtk.h',
        'browser/ui/gtk/tabs/dragged_view_gtk.cc',
        'browser/ui/gtk/tabs/dragged_view_gtk.h',
        'browser/ui/gtk/tabs/tab_gtk.cc',
        'browser/ui/gtk/tabs/tab_gtk.h',
        'browser/ui/gtk/tabs/tab_renderer_gtk.cc',
        'browser/ui/gtk/tabs/tab_renderer_gtk.h',
        'browser/ui/gtk/tabs/tab_strip_gtk.cc',
        'browser/ui/gtk/tabs/tab_strip_gtk.h',
        'browser/ui/gtk/tabs/tab_strip_menu_controller.cc',
        'browser/ui/gtk/tabs/tab_strip_menu_controller.h',
        'browser/ui/gtk/task_manager_gtk.cc',
        'browser/ui/gtk/task_manager_gtk.h',
        'browser/ui/gtk/throbber_gtk.cc',
        'browser/ui/gtk/throbber_gtk.h',
        'browser/ui/gtk/titlebar_throb_animation.cc',
        'browser/ui/gtk/titlebar_throb_animation.h',
        'browser/ui/gtk/unity_service.cc',
        'browser/ui/gtk/unity_service.h',
        'browser/ui/gtk/update_recommended_dialog.cc',
        'browser/ui/gtk/update_recommended_dialog.h',
        'browser/ui/gtk/validation_message_bubble_gtk.cc',
        'browser/ui/gtk/view_id_util.cc',
        'browser/ui/gtk/view_id_util.h',
        'browser/ui/gtk/web_contents_modal_dialog_manager_gtk.cc',
        'browser/ui/gtk/web_dialog_gtk.cc',
        'browser/ui/gtk/web_dialog_gtk.h',
        'browser/ui/gtk/website_settings/permission_selector.cc',
        'browser/ui/gtk/website_settings/permission_selector.h',
        'browser/ui/gtk/website_settings/permission_selector_observer.h',
        'browser/ui/gtk/website_settings/website_settings_popup_gtk.cc',
        'browser/ui/gtk/website_settings/website_settings_popup_gtk.h',
        'browser/ui/gtk/zoom_bubble_gtk.cc',
        'browser/ui/gtk/zoom_bubble_gtk.h',
        'browser/ui/host_desktop.cc',
        'browser/ui/host_desktop.h',
        'browser/ui/hung_plugin_tab_helper.cc',
        'browser/ui/hung_plugin_tab_helper.h',
        'browser/ui/immersive_fullscreen_configuration.cc',
        'browser/ui/immersive_fullscreen_configuration.h',
        'browser/ui/login/login_model.h',
        'browser/ui/login/login_prompt.cc',
        'browser/ui/login/login_prompt.h',
        'browser/ui/media_utils.cc',
        'browser/ui/media_utils.h',
        'browser/ui/metro_pin_tab_helper_win.cc',
        'browser/ui/metro_pin_tab_helper_win.h',
        'browser/ui/native_focus_tracker.h',
        'browser/ui/network_profile_bubble.cc',
        'browser/ui/network_profile_bubble.h',
        'browser/ui/ntp_background_util.cc',
        'browser/ui/ntp_background_util.h',
        'browser/ui/omnibox/alternate_nav_infobar_delegate.cc',
        'browser/ui/omnibox/alternate_nav_infobar_delegate.h',
        'browser/ui/omnibox/alternate_nav_url_fetcher.cc',
        'browser/ui/omnibox/alternate_nav_url_fetcher.h',
        'browser/ui/omnibox/location_bar.h',
        'browser/ui/omnibox/location_bar_util.cc',
        'browser/ui/omnibox/location_bar_util.h',
        'browser/ui/omnibox/omnibox_controller.h',
        'browser/ui/omnibox/omnibox_controller.cc',
        'browser/ui/omnibox/omnibox_current_page_delegate.h',
        'browser/ui/omnibox/omnibox_current_page_delegate_impl.cc',
        'browser/ui/omnibox/omnibox_current_page_delegate_impl.h',
        'browser/ui/omnibox/omnibox_edit_controller.h',
        'browser/ui/omnibox/omnibox_edit_model.cc',
        'browser/ui/omnibox/omnibox_edit_model.h',
        'browser/ui/omnibox/omnibox_popup_model.cc',
        'browser/ui/omnibox/omnibox_popup_model.h',
        'browser/ui/omnibox/omnibox_popup_model_observer.h',
        'browser/ui/omnibox/omnibox_popup_view.h',
        'browser/ui/omnibox/omnibox_view.cc',
        'browser/ui/omnibox/omnibox_view.h',
        'browser/ui/options/options_util.cc',
        'browser/ui/options/options_util.h',
        'browser/ui/panels/detached_panel_collection.cc',
        'browser/ui/panels/detached_panel_collection.h',
        'browser/ui/panels/detached_panel_drag_handler.cc',
        'browser/ui/panels/detached_panel_drag_handler.h',
        'browser/ui/panels/display_settings_provider_win.cc',
        'browser/ui/panels/display_settings_provider_win.h',
        'browser/ui/panels/display_settings_provider.cc',
        'browser/ui/panels/display_settings_provider.h',
        'browser/ui/panels/docked_panel_collection.cc',
        'browser/ui/panels/docked_panel_collection.h',
        'browser/ui/panels/docked_panel_drag_handler.cc',
        'browser/ui/panels/docked_panel_drag_handler.h',
        'browser/ui/panels/native_panel.h',
        'browser/ui/panels/native_panel_stack_window.h',
        'browser/ui/panels/panel.cc',
        'browser/ui/panels/panel.h',
        'browser/ui/panels/panel_bounds_animation.cc',
        'browser/ui/panels/panel_bounds_animation.h',
        'browser/ui/panels/panel_collection.cc',
        'browser/ui/panels/panel_collection.h',
        'browser/ui/panels/panel_constants.h',
        'browser/ui/panels/panel_drag_controller.cc',
        'browser/ui/panels/panel_drag_controller.h',
        'browser/ui/panels/panel_host.cc',
        'browser/ui/panels/panel_host.h',
        'browser/ui/panels/panel_resize_controller.cc',
        'browser/ui/panels/panel_resize_controller.h',
        'browser/ui/panels/panel_manager.cc',
        'browser/ui/panels/panel_manager.h',
        'browser/ui/panels/panel_mouse_watcher.cc',
        'browser/ui/panels/panel_mouse_watcher.h',
        'browser/ui/panels/panel_mouse_watcher_observer.h',
        'browser/ui/panels/panel_mouse_watcher_timer.cc',
        'browser/ui/panels/stacked_panel_collection.cc',
        'browser/ui/panels/stacked_panel_collection.h',
        'browser/ui/panels/stacked_panel_drag_handler.cc',
        'browser/ui/panels/stacked_panel_drag_handler.h',
        'browser/ui/pdf/open_pdf_in_reader_prompt_delegate.h',
        'browser/ui/pdf/pdf_tab_helper.cc',
        'browser/ui/pdf/pdf_tab_helper.h',
        'browser/ui/pdf/pdf_unsupported_feature.cc',
        'browser/ui/pdf/pdf_unsupported_feature.h',
        'browser/ui/prefs/prefs_tab_helper.cc',
        'browser/ui/prefs/prefs_tab_helper.h',
        'browser/ui/profile_error_dialog.cc',
        'browser/ui/profile_error_dialog.h',
        'browser/ui/protocol_dialog_delegate.h',
        'browser/ui/sad_tab.cc',
        'browser/ui/sad_tab.h',
        'browser/ui/sad_tab_helper.cc',
        'browser/ui/sad_tab_helper.h',
        'browser/ui/sad_tab_types.h',
        'browser/ui/screen_capture_notification_ui.h',
        'browser/ui/screen_capture_notification_ui_stub.cc',
        'browser/ui/search/instant_controller.cc',
        'browser/ui/search/instant_controller.h',
        'browser/ui/search/instant_ipc_sender.cc',
        'browser/ui/search/instant_ipc_sender.h',
        'browser/ui/search/instant_loader.cc',
        'browser/ui/search/instant_loader.h',
        'browser/ui/search/instant_ntp.cc',
        'browser/ui/search/instant_ntp.h',
        'browser/ui/search/instant_ntp_prerenderer.cc',
        'browser/ui/search/instant_ntp_prerenderer.h',
        'browser/ui/search/instant_page.cc',
        'browser/ui/search/instant_page.h',
        'browser/ui/search/instant_tab.cc',
        'browser/ui/search/instant_tab.h',
        'browser/ui/search/instant_unload_handler.cc',
        'browser/ui/search/instant_unload_handler.h',
        'browser/ui/search/search_delegate.cc',
        'browser/ui/search/search_delegate.h',
        'browser/ui/search/search_ipc_router.cc',
        'browser/ui/search/search_ipc_router.h',
        'browser/ui/search/search_ipc_router_policy_impl.cc',
        'browser/ui/search/search_ipc_router_policy_impl.h',
        'browser/ui/search/search_model.cc',
        'browser/ui/search/search_model.h',
        'browser/ui/search/search_model_observer.h',
        'browser/ui/search/search_tab_helper.cc',
        'browser/ui/search/search_tab_helper.h',
        'browser/ui/search/search_ui.cc',
        'browser/ui/search/search_ui.h',
        'browser/ui/search_engines/edit_search_engine_controller.cc',
        'browser/ui/search_engines/edit_search_engine_controller.h',
        'browser/ui/search_engines/keyword_editor_controller.cc',
        'browser/ui/search_engines/keyword_editor_controller.h',
        'browser/ui/search_engines/search_engine_tab_helper.cc',
        'browser/ui/search_engines/search_engine_tab_helper.h',
        'browser/ui/search_engines/search_engine_tab_helper_delegate.cc',
        'browser/ui/search_engines/search_engine_tab_helper_delegate.h',
        'browser/ui/search_engines/template_url_fetcher_ui_callbacks.cc',
        'browser/ui/search_engines/template_url_fetcher_ui_callbacks.h',
        'browser/ui/search_engines/template_url_table_model.cc',
        'browser/ui/search_engines/template_url_table_model.h',
        'browser/ui/send_feedback_experiment.cc',
        'browser/ui/send_feedback_experiment.h',
        'browser/ui/simple_message_box.h',
        'browser/ui/singleton_tabs.cc',
        'browser/ui/singleton_tabs.h',
        'browser/ui/startup/autolaunch_prompt.cc',
        'browser/ui/startup/autolaunch_prompt_win.cc',
        'browser/ui/startup/autolaunch_prompt.h',
        'browser/ui/startup/bad_flags_prompt.cc',
        'browser/ui/startup/bad_flags_prompt.h',
        'browser/ui/startup/default_browser_prompt.cc',
        'browser/ui/startup/default_browser_prompt.h',
        'browser/ui/startup/default_browser_prompt_win.cc',
        'browser/ui/startup/google_api_keys_infobar_delegate.cc',
        'browser/ui/startup/google_api_keys_infobar_delegate.h',
        'browser/ui/startup/obsolete_os_infobar_delegate.cc',
        'browser/ui/startup/obsolete_os_infobar_delegate.h',
        'browser/ui/startup/session_crashed_infobar_delegate.cc',
        'browser/ui/startup/session_crashed_infobar_delegate.h',
        'browser/ui/startup/startup_browser_creator.cc',
        'browser/ui/startup/startup_browser_creator.h',
        'browser/ui/startup/startup_browser_creator_impl.cc',
        'browser/ui/startup/startup_browser_creator_impl.h',
        'browser/ui/startup/startup_browser_creator_win.cc',
        'browser/ui/startup/startup_browser_creator_win.h',
        'browser/ui/startup/startup_tab.cc',
        'browser/ui/startup/startup_tab.h',
        'browser/ui/startup/startup_types.h',
        'browser/ui/status_bubble.h',
        'browser/ui/sync/browser_synced_window_delegate.h',
        'browser/ui/sync/browser_synced_window_delegate.cc',
        'browser/ui/sync/inline_login_dialog.cc',
        'browser/ui/sync/inline_login_dialog.h',
        'browser/ui/sync/one_click_signin_bubble_delegate.h',
        'browser/ui/sync/one_click_signin_bubble_links_delegate.cc',
        'browser/ui/sync/one_click_signin_bubble_links_delegate.h',
        'browser/ui/sync/one_click_signin_helper.cc',
        'browser/ui/sync/one_click_signin_helper.h',
        'browser/ui/sync/one_click_signin_histogram.h',
        'browser/ui/sync/one_click_signin_sync_starter.cc',
        'browser/ui/sync/one_click_signin_sync_starter.h',
        'browser/ui/sync/profile_signin_confirmation_helper.cc',
        'browser/ui/sync/profile_signin_confirmation_helper.h',
        'browser/ui/sync/signin_histogram.h',
        'browser/ui/sync/sync_promo_ui.cc',
        'browser/ui/sync/sync_promo_ui.h',
        'browser/ui/sync/tab_contents_synced_tab_delegate.cc',
        'browser/ui/sync/tab_contents_synced_tab_delegate.h',
        'browser/ui/tab_contents/chrome_web_contents_view_delegate.h',
        'browser/ui/tab_contents/core_tab_helper.cc',
        'browser/ui/tab_contents/core_tab_helper.h',
        'browser/ui/tab_contents/core_tab_helper_delegate.cc',
        'browser/ui/tab_contents/core_tab_helper_delegate.h',
        'browser/ui/tab_contents/tab_contents_iterator.cc',
        'browser/ui/tab_contents/tab_contents_iterator.h',
        'browser/ui/tab_modal_confirm_dialog.h',
        'browser/ui/tab_modal_confirm_dialog_delegate.cc',
        'browser/ui/tab_modal_confirm_dialog_delegate.h',
        'browser/ui/tabs/dock_info.cc',
        'browser/ui/tabs/dock_info.h',
        'browser/ui/tabs/hover_tab_selector.cc',
        'browser/ui/tabs/hover_tab_selector.h',
        'browser/ui/tabs/pinned_tab_codec.cc',
        'browser/ui/tabs/pinned_tab_codec.h',
        'browser/ui/tabs/pinned_tab_service.cc',
        'browser/ui/tabs/pinned_tab_service.h',
        'browser/ui/tabs/pinned_tab_service_factory.cc',
        'browser/ui/tabs/pinned_tab_service_factory.h',
        'browser/ui/tabs/tab_menu_model.cc',
        'browser/ui/tabs/tab_menu_model.h',
        'browser/ui/tabs/tab_resources.cc',
        'browser/ui/tabs/tab_resources.h',
        'browser/ui/tabs/tab_strip_layout_type.h',
        'browser/ui/tabs/tab_strip_layout_type_prefs.cc',
        'browser/ui/tabs/tab_strip_layout_type_prefs.h',
        'browser/ui/tabs/tab_strip_model.cc',
        'browser/ui/tabs/tab_strip_model.h',
        'browser/ui/tabs/tab_strip_model_delegate.h',
        'browser/ui/tabs/tab_strip_model_observer.cc',
        'browser/ui/tabs/tab_strip_model_observer.h',
        'browser/ui/tabs/tab_strip_model_order_controller.cc',
        'browser/ui/tabs/tab_strip_model_order_controller.h',
        'browser/ui/tabs/tab_strip_model_utils.cc',
        'browser/ui/tabs/tab_strip_model_utils.h',
        'browser/ui/tabs/tab_utils.cc',
        'browser/ui/tabs/tab_utils.h',
        'browser/ui/toolbar/back_forward_menu_model.cc',
        'browser/ui/toolbar/back_forward_menu_model.h',
        'browser/ui/toolbar/bookmark_sub_menu_model.cc',
        'browser/ui/toolbar/bookmark_sub_menu_model.h',
        'browser/ui/toolbar/encoding_menu_controller.cc',
        'browser/ui/toolbar/encoding_menu_controller.h',
        'browser/ui/toolbar/recent_tabs_sub_menu_model.cc',
        'browser/ui/toolbar/recent_tabs_sub_menu_model.h',
        'browser/ui/toolbar/toolbar_model.h',
        'browser/ui/toolbar/toolbar_model_impl.cc',
        'browser/ui/toolbar/toolbar_model_impl.h',
        'browser/ui/toolbar/toolbar_model_delegate.h',
        'browser/ui/toolbar/toolbar_model_security_level_list.h',
        'browser/ui/toolbar/wrench_icon_painter.cc',
        'browser/ui/toolbar/wrench_icon_painter.h',
        'browser/ui/toolbar/wrench_menu_model.cc',
        'browser/ui/toolbar/wrench_menu_model.h',
        'browser/ui/top_level_widget.h',
        'browser/ui/uma_browsing_activity_observer.cc',
        'browser/ui/uma_browsing_activity_observer.h',
        'browser/ui/uninstall_browser_prompt.h',
        'browser/ui/unload_controller.cc',
        'browser/ui/unload_controller.h',
        'browser/ui/user_data_dir_dialog.h',
        'browser/ui/validation_message_bubble.h',
        'browser/ui/view_ids.h',
        'browser/ui/views/accelerator_utils_aura.cc',
        'browser/ui/views/accelerator_utils_views.cc',
        'browser/ui/views/about_ipc_dialog.cc',
        'browser/ui/views/about_ipc_dialog.h',
        'browser/ui/views/accessibility/accessibility_event_router_views.cc',
        'browser/ui/views/accessibility/accessibility_event_router_views.h',
        'browser/ui/views/accessibility/invert_bubble_view.cc',
        'browser/ui/views/accessibility/invert_bubble_view.h',
        'browser/ui/views/app_menu_button_win.cc',
        'browser/ui/views/app_menu_button_win.h',
        'browser/ui/views/app_list/app_list_controller_win.cc',
        'browser/ui/views/apps/chrome_shell_window_delegate_views.cc',
        'browser/ui/views/apps/native_app_window_views.cc',
        'browser/ui/views/apps/native_app_window_views.h',
        'browser/ui/views/ash/chrome_browser_main_extra_parts_ash.cc',
        'browser/ui/views/ash/chrome_browser_main_extra_parts_ash.h',
        'browser/ui/views/ash/tab_scrubber.h',
        'browser/ui/views/ash/tab_scrubber.cc',
        'browser/ui/views/autofill/autofill_dialog_views.cc',
        'browser/ui/views/autofill/autofill_dialog_views.h',
        'browser/ui/views/autofill/autofill_popup_view_views.cc',
        'browser/ui/views/autofill/autofill_popup_view_views.h',
        'browser/ui/views/autofill/generated_credit_card_bubble_views.cc',
        'browser/ui/views/autofill/generated_credit_card_bubble_views.h',
        'browser/ui/views/autofill/new_credit_card_bubble_views.cc',
        'browser/ui/views/autofill/new_credit_card_bubble_views.h',
        'browser/ui/views/autofill/decorated_textfield.cc',
        'browser/ui/views/autofill/decorated_textfield.h',
        'browser/ui/views/avatar_menu_bubble_view.cc',
        'browser/ui/views/avatar_menu_bubble_view.h',
        'browser/ui/views/avatar_menu_button.cc',
        'browser/ui/views/avatar_menu_button.h',
        'browser/ui/views/avatar_label.cc',
        'browser/ui/views/avatar_label.cc',
        'browser/ui/views/bookmarks/bookmark_bar_instructions_view.cc',
        'browser/ui/views/bookmarks/bookmark_bar_instructions_view.h',
        'browser/ui/views/bookmarks/bookmark_bar_view.cc',
        'browser/ui/views/bookmarks/bookmark_bar_view.h',
        'browser/ui/views/bookmarks/bookmark_bubble_view.cc',
        'browser/ui/views/bookmarks/bookmark_bubble_view.h',
        'browser/ui/views/bookmarks/bookmark_bubble_view_observer.h',
        'browser/ui/views/bookmarks/bookmark_context_menu.cc',
        'browser/ui/views/bookmarks/bookmark_context_menu.h',
        'browser/ui/views/bookmarks/bookmark_context_menu_controller_win.cc',
        'browser/ui/views/bookmarks/bookmark_drag_drop_views.cc',
        'browser/ui/views/bookmarks/bookmark_drag_drop_views.h',
        'browser/ui/views/bookmarks/bookmark_editor_view.cc',
        'browser/ui/views/bookmarks/bookmark_editor_view.h',
        'browser/ui/views/bookmarks/bookmark_menu_controller_observer.h',
        'browser/ui/views/bookmarks/bookmark_menu_controller_views.cc',
        'browser/ui/views/bookmarks/bookmark_menu_controller_views.h',
        'browser/ui/views/bookmarks/bookmark_menu_delegate.cc',
        'browser/ui/views/bookmarks/bookmark_menu_delegate.h',
        'browser/ui/views/bookmarks/bookmark_prompt_view.cc',
        'browser/ui/views/bookmarks/bookmark_prompt_view.h',
        'browser/ui/views/bookmarks/bookmark_sync_promo_view.cc',
        'browser/ui/views/bookmarks/bookmark_sync_promo_view.h',
        'browser/ui/views/browser_action_test_util_views.cc',
        'browser/ui/views/browser_action_view.cc',
        'browser/ui/views/browser_action_view.h',
        'browser/ui/views/browser_actions_container.cc',
        'browser/ui/views/browser_actions_container.h',
        'browser/ui/views/certificate_viewer_win.cc',
        'browser/ui/views/chrome_browser_main_extra_parts_views.cc',
        'browser/ui/views/chrome_browser_main_extra_parts_views.h',
        'browser/ui/views/chrome_views_delegate.cc',
        'browser/ui/views/chrome_views_delegate.h',
        'browser/ui/views/chrome_web_dialog_view.cc',
        'browser/ui/views/collected_cookies_views.cc',
        'browser/ui/views/collected_cookies_views.h',
        'browser/ui/views/color_chooser_aura.cc',
        'browser/ui/views/color_chooser_dialog.cc',
        'browser/ui/views/color_chooser_dialog.h',
        'browser/ui/views/color_chooser_win.cc',
        'browser/ui/views/confirm_bubble_views.cc',
        'browser/ui/views/confirm_bubble_views.h',
        'browser/ui/views/conflicting_module_view_win.cc',
        'browser/ui/views/conflicting_module_view_win.h',
        'browser/ui/views/constrained_web_dialog_delegate_views.cc',
        'browser/ui/views/constrained_window_views.cc',
        'browser/ui/views/constrained_window_views.h',
        'browser/ui/views/content_setting_bubble_contents.cc',
        'browser/ui/views/content_setting_bubble_contents.h',
        'browser/ui/views/cookie_info_view.cc',
        'browser/ui/views/cookie_info_view.h',
        'browser/ui/views/create_application_shortcut_view.cc',
        'browser/ui/views/create_application_shortcut_view.h',
        'browser/ui/views/crypto_module_password_dialog_view.cc',
        'browser/ui/views/crypto_module_password_dialog_view.h',
        'browser/ui/views/critical_notification_bubble_view.cc',
        'browser/ui/views/critical_notification_bubble_view.h',
        'browser/ui/views/desktop_media_picker_views.cc',
        'browser/ui/views/detachable_toolbar_view.cc',
        'browser/ui/views/detachable_toolbar_view.h',
        'browser/ui/views/download/download_in_progress_dialog_view.cc',
        'browser/ui/views/download/download_in_progress_dialog_view.h',
        'browser/ui/views/download/download_item_view.cc',
        'browser/ui/views/download/download_item_view.h',
        'browser/ui/views/download/download_shelf_context_menu_view.cc',
        'browser/ui/views/download/download_shelf_context_menu_view.h',
        'browser/ui/views/download/download_shelf_view.cc',
        'browser/ui/views/download/download_shelf_view.h',
        'browser/ui/views/download/download_started_animation_views.cc',
        'browser/ui/views/dropdown_bar_host.cc',
        'browser/ui/views/dropdown_bar_host.h',
        'browser/ui/views/dropdown_bar_host_aura.cc',
        'browser/ui/views/dropdown_bar_host_delegate.h',
        'browser/ui/views/dropdown_bar_host_win.cc',
        'browser/ui/views/dropdown_bar_view.cc',
        'browser/ui/views/dropdown_bar_view.h',
        'browser/ui/views/edit_search_engine_dialog.cc',
        'browser/ui/views/edit_search_engine_dialog.h',
        'browser/ui/views/extensions/browser_action_drag_data.cc',
        'browser/ui/views/extensions/browser_action_drag_data.h',
        'browser/ui/views/extensions/browser_action_overflow_menu_controller.cc',
        'browser/ui/views/extensions/browser_action_overflow_menu_controller.h',
        'browser/ui/views/extensions/bundle_installed_bubble.cc',
        'browser/ui/views/extensions/extension_dialog.cc',
        'browser/ui/views/extensions/extension_dialog.h',
        'browser/ui/views/extensions/extension_dialog_observer.cc',
        'browser/ui/views/extensions/extension_dialog_observer.h',
        'browser/ui/views/extensions/extension_install_dialog_view.cc',
        'browser/ui/views/extensions/extension_installed_bubble_view.cc',
        'browser/ui/views/extensions/extension_installed_bubble_view.h',
        'browser/ui/views/extensions/extension_keybinding_registry_views.cc',
        'browser/ui/views/extensions/extension_keybinding_registry_views.h',
        'browser/ui/views/extensions/extension_popup.cc',
        'browser/ui/views/extensions/extension_popup.h',
        'browser/ui/views/extensions/extension_uninstall_dialog_view.cc',
        'browser/ui/views/extensions/extension_view_views.cc',
        'browser/ui/views/extensions/extension_view_views.h',
        'browser/ui/views/extensions/media_galleries_dialog_views.cc',
        'browser/ui/views/extensions/media_galleries_dialog_views.h',
        'browser/ui/views/extensions/shell_window_frame_view.cc',
        'browser/ui/views/extensions/shell_window_frame_view.h',
        'browser/ui/views/external_protocol_dialog.cc',
        'browser/ui/views/external_protocol_dialog.h',
        'browser/ui/views/external_tab_container_win.cc',
        'browser/ui/views/external_tab_container_win.h',
        'browser/ui/views/find_bar_host.cc',
        'browser/ui/views/find_bar_host.h',
        'browser/ui/views/find_bar_host_aura.cc',
        'browser/ui/views/find_bar_host_win.cc',
        'browser/ui/views/find_bar_view.cc',
        'browser/ui/views/find_bar_view.h',
        'browser/ui/views/first_run_bubble.cc',
        'browser/ui/views/first_run_bubble.h',
        'browser/ui/views/frame/app_non_client_frame_view_ash.cc',
        'browser/ui/views/frame/app_non_client_frame_view_ash.h',
        'browser/ui/views/frame/app_panel_browser_frame_view.cc',
        'browser/ui/views/frame/app_panel_browser_frame_view.h',
        'browser/ui/views/frame/browser_frame.cc',
        'browser/ui/views/frame/browser_frame.h',
        'browser/ui/views/frame/browser_frame_aura.cc',
        'browser/ui/views/frame/browser_frame_aura.h',
        'browser/ui/views/frame/browser_frame_common_win.cc',
        'browser/ui/views/frame/browser_frame_common_win.h',
        'browser/ui/views/frame/browser_frame_win.cc',
        'browser/ui/views/frame/browser_frame_win.h',
        'browser/ui/views/frame/browser_non_client_frame_view.cc',
        'browser/ui/views/frame/browser_non_client_frame_view.h',
        'browser/ui/views/frame/browser_non_client_frame_view_ash.h',
        'browser/ui/views/frame/browser_non_client_frame_view_ash.cc',
        'browser/ui/views/frame/browser_non_client_frame_view_factory_aura.cc',
        'browser/ui/views/frame/browser_non_client_frame_view_factory_win.cc',
        'browser/ui/views/frame/browser_non_client_frame_view_factory_x11.cc',
        'browser/ui/views/frame/browser_root_view.cc',
        'browser/ui/views/frame/browser_root_view.h',
        'browser/ui/views/frame/browser_view.cc',
        'browser/ui/views/frame/browser_view.h',
        'browser/ui/views/frame/browser_view_layout.cc',
        'browser/ui/views/frame/browser_view_layout.h',
        'browser/ui/views/frame/browser_view_layout_delegate.h',
        'browser/ui/views/frame/contents_container.cc',
        'browser/ui/views/frame/contents_container.h',
        'browser/ui/views/frame/desktop_browser_frame_aura.cc',
        'browser/ui/views/frame/desktop_browser_frame_aura.h',
        'browser/ui/views/frame/desktop_user_action_handler_aura.cc',
        'browser/ui/views/frame/desktop_user_action_handler_aura.h',
        'browser/ui/views/frame/browser_desktop_root_window_host.h',
        'browser/ui/views/frame/browser_desktop_root_window_host_win.cc',
        'browser/ui/views/frame/browser_desktop_root_window_host_win.h',
        'browser/ui/views/frame/browser_desktop_root_window_host_x11.cc',
        'browser/ui/views/frame/browser_desktop_root_window_host_x11.h',
        'browser/ui/views/frame/glass_browser_frame_view.cc',
        'browser/ui/views/frame/glass_browser_frame_view.h',
        'browser/ui/views/frame/global_menu_bar_x11.cc',
        'browser/ui/views/frame/global_menu_bar_x11.h',
        'browser/ui/views/frame/global_menu_bar_registrar_x11.cc',
        'browser/ui/views/frame/global_menu_bar_registrar_x11.h',
        'browser/ui/views/frame/immersive_mode_controller.cc',
        'browser/ui/views/frame/immersive_mode_controller.h',
        'browser/ui/views/frame/immersive_mode_controller_ash.cc',
        'browser/ui/views/frame/immersive_mode_controller_ash.h',
        'browser/ui/views/frame/immersive_mode_controller_factory.cc',
        'browser/ui/views/frame/immersive_mode_controller_stub.cc',
        'browser/ui/views/frame/immersive_mode_controller_stub.h',
        'browser/ui/views/frame/minimize_button_metrics_win.cc',
        'browser/ui/views/frame/minimize_button_metrics_win.h',
        'browser/ui/views/frame/native_browser_frame.h',
        'browser/ui/views/frame/native_browser_frame_factory.cc',
        'browser/ui/views/frame/native_browser_frame_factory.h',
        'browser/ui/views/frame/native_browser_frame_factory_aura.cc',
        'browser/ui/views/frame/native_browser_frame_factory_win.cc',
        'browser/ui/views/frame/native_browser_frame_factory.cc',
        'browser/ui/views/frame/native_browser_frame_factory.h',
        'browser/ui/views/frame/opaque_browser_frame_view.cc',
        'browser/ui/views/frame/opaque_browser_frame_view.h',
        'browser/ui/views/frame/opaque_browser_frame_view_layout.cc',
        'browser/ui/views/frame/opaque_browser_frame_view_layout.h',
        'browser/ui/views/frame/opaque_browser_frame_view_layout_delegate.h',
        'browser/ui/views/frame/opaque_browser_frame_view_platform_specific.h',
        'browser/ui/views/frame/opaque_browser_frame_view_platform_specific.cc',
        'browser/ui/views/frame/opaque_browser_frame_view_linux.h',
        'browser/ui/views/frame/opaque_browser_frame_view_linux.cc',
        'browser/ui/views/frame/popup_non_client_frame_view.cc',
        'browser/ui/views/frame/popup_non_client_frame_view.h',
        'browser/ui/views/frame/scroll_end_effect_controller.h',
        'browser/ui/views/frame/scroll_end_effect_controller_ash.cc',
        'browser/ui/views/frame/scroll_end_effect_controller_ash.h',
        'browser/ui/views/frame/system_menu_insertion_delegate_win.cc',
        'browser/ui/views/frame/system_menu_insertion_delegate_win.h',
        'browser/ui/views/frame/system_menu_model_builder.cc',
        'browser/ui/views/frame/system_menu_model_builder.h',
        'browser/ui/views/frame/system_menu_model_delegate.cc',
        'browser/ui/views/frame/system_menu_model_delegate.h',
        'browser/ui/views/frame/taskbar_decorator.cc',
        'browser/ui/views/frame/taskbar_decorator.h',
        'browser/ui/views/frame/taskbar_decorator_win.cc',
        'browser/ui/views/frame/top_container_view.cc',
        'browser/ui/views/frame/top_container_view.h',
        'browser/ui/views/fullscreen_exit_bubble_views.cc',
        'browser/ui/views/fullscreen_exit_bubble_views.h',
        'browser/ui/views/global_error_bubble_view.cc',
        'browser/ui/views/global_error_bubble_view.h',
        'browser/ui/views/home_button.cc',
        'browser/ui/views/home_button.h',
        'browser/ui/views/hung_renderer_view.cc',
        'browser/ui/views/hung_renderer_view.h',
        'browser/ui/views/hung_renderer_view_win.cc',
        'browser/ui/views/hung_renderer_view_win.h',
        'browser/ui/views/importer/import_lock_dialog_view.cc',
        'browser/ui/views/importer/import_lock_dialog_view.h',
        'browser/ui/views/infobars/alternate_nav_infobar_view.cc',
        'browser/ui/views/infobars/alternate_nav_infobar_view.h',
        'browser/ui/views/infobars/after_translate_infobar.cc',
        'browser/ui/views/infobars/after_translate_infobar.h',
        'browser/ui/views/infobars/before_translate_infobar.cc',
        'browser/ui/views/infobars/before_translate_infobar.h',
        'browser/ui/views/infobars/confirm_infobar.cc',
        'browser/ui/views/infobars/confirm_infobar.h',
        'browser/ui/views/infobars/extension_infobar.cc',
        'browser/ui/views/infobars/extension_infobar.h',
        'browser/ui/views/infobars/infobar_background.cc',
        'browser/ui/views/infobars/infobar_background.h',
        'browser/ui/views/infobars/infobar_button_border.cc',
        'browser/ui/views/infobars/infobar_button_border.h',
        'browser/ui/views/infobars/infobar_container_view.cc',
        'browser/ui/views/infobars/infobar_container_view.h',
        'browser/ui/views/infobars/infobar_label_button_border.cc',
        'browser/ui/views/infobars/infobar_label_button_border.h',
        'browser/ui/views/infobars/infobar_view.cc',
        'browser/ui/views/infobars/infobar_view.h',
        'browser/ui/views/infobars/translate_infobar_base.cc',
        'browser/ui/views/infobars/translate_infobar_base.h',
        'browser/ui/views/infobars/translate_language_menu_model.cc',
        'browser/ui/views/infobars/translate_language_menu_model.h',
        'browser/ui/views/infobars/translate_message_infobar.cc',
        'browser/ui/views/infobars/translate_message_infobar.h',
        'browser/ui/views/javascript_app_modal_dialog_views.cc',
        'browser/ui/views/javascript_app_modal_dialog_views.h',
        'browser/ui/views/load_complete_listener.cc',
        'browser/ui/views/load_complete_listener.h',
        'browser/ui/views/location_bar/generated_credit_card_view.cc',
        'browser/ui/views/location_bar/generated_credit_card_view.h',
        'browser/ui/views/location_bar/content_setting_image_view.cc',
        'browser/ui/views/location_bar/content_setting_image_view.h',
        'browser/ui/views/location_bar/ev_bubble_view.cc',
        'browser/ui/views/location_bar/ev_bubble_view.h',
        'browser/ui/views/location_bar/icon_label_bubble_view.cc',
        'browser/ui/views/location_bar/icon_label_bubble_view.h',
        'browser/ui/views/location_bar/keyword_hint_view.cc',
        'browser/ui/views/location_bar/keyword_hint_view.h',
        'browser/ui/views/location_bar/location_bar_decoration_view.cc',
        'browser/ui/views/location_bar/location_bar_decoration_view.h',
        'browser/ui/views/location_bar/location_bar_layout.cc',
        'browser/ui/views/location_bar/location_bar_layout.h',
        'browser/ui/views/location_bar/location_bar_view.cc',
        'browser/ui/views/location_bar/location_bar_view.h',
        'browser/ui/views/location_bar/location_icon_view.cc',
        'browser/ui/views/location_bar/location_icon_view.h',
        'browser/ui/views/location_bar/open_pdf_in_reader_view.cc',
        'browser/ui/views/location_bar/open_pdf_in_reader_view.h',
        'browser/ui/views/location_bar/page_action_image_view.cc',
        'browser/ui/views/location_bar/page_action_image_view.h',
        'browser/ui/views/location_bar/page_action_with_badge_view.cc',
        'browser/ui/views/location_bar/page_action_with_badge_view.h',
        'browser/ui/views/location_bar/page_info_helper.cc',
        'browser/ui/views/location_bar/page_info_helper.h',
        'browser/ui/views/location_bar/script_bubble_icon_view.cc',
        'browser/ui/views/location_bar/script_bubble_icon_view.h',
        'browser/ui/views/location_bar/selected_keyword_view.cc',
        'browser/ui/views/location_bar/selected_keyword_view.h',
        'browser/ui/views/location_bar/star_view.cc',
        'browser/ui/views/location_bar/star_view.h',
        'browser/ui/views/location_bar/zoom_bubble_view.cc',
        'browser/ui/views/location_bar/zoom_bubble_view.h',
        'browser/ui/views/location_bar/zoom_view.cc',
        'browser/ui/views/location_bar/zoom_view.h',
        'browser/ui/views/login_prompt_views.cc',
        'browser/ui/views/login_view.cc',
        'browser/ui/views/login_view.h',
        'browser/ui/views/message_center/message_center_frame_view.cc',
        'browser/ui/views/message_center/message_center_frame_view.h',
        'browser/ui/views/message_center/message_center_widget_delegate.h',
        'browser/ui/views/message_center/message_center_widget_delegate.cc',
        'browser/ui/views/message_center/web_notification_tray.h',
        'browser/ui/views/message_center/web_notification_tray.cc',
        'browser/ui/views/message_center/web_notification_tray_win.cc',
        'browser/ui/views/native_focus_tracker_views.cc',
        'browser/ui/views/native_focus_tracker_views.h',
        'browser/ui/views/native_focus_tracker_views_aura.cc',
        'browser/ui/views/native_focus_tracker_views_win.cc',
        'browser/ui/views/notifications/balloon_collection_views.cc',
        'browser/ui/views/notifications/balloon_view_host.cc',
        'browser/ui/views/notifications/balloon_view_host.h',
        'browser/ui/views/notifications/balloon_view_views.cc',
        'browser/ui/views/notifications/balloon_view_views.h',
        'browser/ui/views/omnibox/omnibox_popup_contents_view.cc',
        'browser/ui/views/omnibox/omnibox_popup_contents_view.h',
        'browser/ui/views/omnibox/omnibox_result_view.cc',
        'browser/ui/views/omnibox/omnibox_result_view.h',
        'browser/ui/views/omnibox/omnibox_result_view_model.h',
        'browser/ui/views/omnibox/omnibox_views.cc',
        'browser/ui/views/omnibox/omnibox_views.h',
        'browser/ui/views/omnibox/omnibox_view_views.cc',
        'browser/ui/views/omnibox/omnibox_view_views.h',
        'browser/ui/views/omnibox/omnibox_view_win.cc',
        'browser/ui/views/omnibox/omnibox_view_win.h',
        'browser/ui/views/omnibox/touch_omnibox_popup_contents_view.cc',
        'browser/ui/views/omnibox/touch_omnibox_popup_contents_view.h',
        'browser/ui/views/open_pdf_in_reader_bubble_view.cc',
        'browser/ui/views/open_pdf_in_reader_bubble_view.h',
        'browser/ui/views/panels/panel_frame_view.cc',
        'browser/ui/views/panels/panel_frame_view.h',
        'browser/ui/views/panels/panel_stack_view.cc',
        'browser/ui/views/panels/panel_stack_view.h',
        'browser/ui/views/panels/panel_view.cc',
        'browser/ui/views/panels/panel_view.h',
        'browser/ui/views/panels/taskbar_window_thumbnailer_win.cc',
        'browser/ui/views/panels/taskbar_window_thumbnailer_win.h',
        'browser/ui/views/password_generation_bubble_view.cc',
        'browser/ui/views/password_generation_bubble_view.h',
        'browser/ui/views/pdf_password_dialog.cc',
        'browser/ui/views/profile_chooser_view.cc',
        'browser/ui/views/profile_chooser_view.h',
        'browser/ui/views/user_manager_view.cc',
        'browser/ui/views/user_manager_view.h',
        'browser/ui/views/reload_button.cc',
        'browser/ui/views/reload_button.h',
        'browser/ui/views/sad_tab_view.cc',
        'browser/ui/views/sad_tab_view.h',
        'browser/ui/views/screen_capture_notification_ui_views.cc',
        'browser/ui/views/script_bubble_view.cc',
        'browser/ui/views/script_bubble_view.h',
        'browser/ui/views/select_file_dialog_extension.cc',
        'browser/ui/views/select_file_dialog_extension.h',
        'browser/ui/views/select_file_dialog_extension_factory.cc',
        'browser/ui/views/select_file_dialog_extension_factory.h',
        'browser/ui/views/simple_message_box_views.cc',
        'browser/ui/views/simple_message_box_win.cc',
        'browser/ui/views/simple_message_box_win.h',
        'browser/ui/views/speech_recognition_bubble_views.cc',
        'browser/ui/views/ssl_client_certificate_selector.cc',
        'browser/ui/views/ssl_client_certificate_selector.h',
        'browser/ui/views/status_bubble_views.cc',
        'browser/ui/views/status_bubble_views.h',
        'browser/ui/views/status_icons/status_icon_linux_wrapper.cc',
        'browser/ui/views/status_icons/status_icon_linux_wrapper.h',
        'browser/ui/views/status_icons/status_icon_win.cc',
        'browser/ui/views/status_icons/status_icon_win.h',
        'browser/ui/views/status_icons/status_tray_linux.cc',
        'browser/ui/views/status_icons/status_tray_linux.h',
        'browser/ui/views/status_icons/status_tray_win.cc',
        'browser/ui/views/status_icons/status_tray_win.h',
        'browser/ui/views/stubs_aura.cc',
        'browser/ui/views/sync/one_click_signin_bubble_view.cc',
        'browser/ui/views/sync/one_click_signin_bubble_view.h',
        'browser/ui/views/sync/profile_signin_confirmation_dialog_views.cc',
        'browser/ui/views/sync/profile_signin_confirmation_dialog_views.h',
        'browser/ui/views/tab_contents/chrome_web_contents_view_delegate_views.cc',
        'browser/ui/views/tab_contents/chrome_web_contents_view_delegate_views.h',
        'browser/ui/views/tab_contents/render_view_context_menu_views.cc',
        'browser/ui/views/tab_contents/render_view_context_menu_views.h',
        'browser/ui/views/tab_contents/render_view_context_menu_win.cc',
        'browser/ui/views/tab_contents/render_view_context_menu_win.h',
        'browser/ui/views/tab_contents/web_drag_bookmark_handler_win.cc',
        'browser/ui/views/tab_contents/web_drag_bookmark_handler_win.h',
        'browser/ui/views/tab_icon_view.cc',
        'browser/ui/views/tab_icon_view.h',
        'browser/ui/views/tab_modal_confirm_dialog_views.cc',
        'browser/ui/views/tab_modal_confirm_dialog_views.h',
        'browser/ui/views/tabs/browser_tab_strip_controller.cc',
        'browser/ui/views/tabs/browser_tab_strip_controller.h',
        'browser/ui/views/tabs/dock_info_views.cc',
        'browser/ui/views/tabs/dock_info_win.cc',
        'browser/ui/views/tabs/dragged_tab_view.cc',
        'browser/ui/views/tabs/dragged_tab_view.h',
        'browser/ui/views/tabs/native_view_photobooth.h',
        'browser/ui/views/tabs/native_view_photobooth_win.cc',
        'browser/ui/views/tabs/native_view_photobooth_win.h',
        'browser/ui/views/tabs/stacked_tab_strip_layout.cc',
        'browser/ui/views/tabs/stacked_tab_strip_layout.h',
        'browser/ui/views/tabs/tab.cc',
        'browser/ui/views/tabs/tab.h',
        'browser/ui/views/tabs/tab_controller.h',
        'browser/ui/views/tabs/tab_drag_controller.cc',
        'browser/ui/views/tabs/tab_drag_controller.h',
        'browser/ui/views/tabs/tab_strip.cc',
        'browser/ui/views/tabs/tab_strip.h',
        'browser/ui/views/tabs/tab_strip_controller.h',
        'browser/ui/views/task_manager_view.cc',
        'browser/ui/views/theme_image_mapper.cc',
        'browser/ui/views/theme_image_mapper.h',
        'browser/ui/views/theme_image_mapper_aura_win.cc',
        'browser/ui/views/toolbar_view.cc',
        'browser/ui/views/toolbar_view.h',
        'browser/ui/views/top_level_widget_views.cc',
        'browser/ui/views/touch_uma/touch_uma.h',
        'browser/ui/views/uninstall_view.cc',
        'browser/ui/views/uninstall_view.h',
        'browser/ui/views/update_recommended_message_box.cc',
        'browser/ui/views/update_recommended_message_box.h',
        'browser/ui/views/outdated_upgrade_bubble_view.h',
        'browser/ui/views/outdated_upgrade_bubble_view.cc',
        'browser/ui/views/user_data_dir_dialog_view.cc',
        'browser/ui/views/user_data_dir_dialog_view.h',
        'browser/ui/views/validation_message_bubble_delegate.h',
        'browser/ui/views/validation_message_bubble_delegate.cc',
        'browser/ui/views/validation_message_bubble_view.cc',
        'browser/ui/views/web_contents_modal_dialog_manager_views.cc',
        'browser/ui/views/website_settings/permission_selector_view.cc',
        'browser/ui/views/website_settings/permission_selector_view.h',
        'browser/ui/views/website_settings/permission_selector_view_observer.h',
        'browser/ui/views/website_settings/website_settings_popup_view.cc',
        'browser/ui/views/website_settings/website_settings_popup_view.h',
        'browser/ui/views/wrench_menu.cc',
        'browser/ui/views/wrench_menu.h',
        'browser/ui/views/wrench_menu_observer.h',
        'browser/ui/views/wrench_toolbar_button.cc',
        'browser/ui/views/wrench_toolbar_button.h',
        'browser/ui/web_applications/web_app_ui.cc',
        'browser/ui/web_applications/web_app_ui.h',
        'browser/ui/website_settings/permission_menu_model.cc',
        'browser/ui/website_settings/permission_menu_model.h',
        'browser/ui/website_settings/website_settings.cc',
        'browser/ui/website_settings/website_settings.h',
        'browser/ui/website_settings/website_settings_infobar_delegate.cc',
        'browser/ui/website_settings/website_settings_infobar_delegate.h',
        'browser/ui/website_settings/website_settings_ui.cc',
        'browser/ui/website_settings/website_settings_ui.h',
        'browser/ui/website_settings/website_settings_utils.cc',
        'browser/ui/website_settings/website_settings_utils.h',
        'browser/ui/webui/about_ui.cc',
        'browser/ui/webui/about_ui.h',
        'browser/ui/webui/app_launcher_page_ui.cc',
        'browser/ui/webui/app_launcher_page_ui.h',
        'browser/ui/webui/bookmarks_ui.cc',
        'browser/ui/webui/bookmarks_ui.h',
        'browser/ui/webui/certificate_viewer_webui.cc',
        'browser/ui/webui/certificate_viewer_webui.h',
        'browser/ui/webui/certificate_viewer_ui.cc',
        'browser/ui/webui/certificate_viewer_ui.h',
        'browser/ui/webui/chrome_web_contents_handler.cc',
        'browser/ui/webui/chrome_web_contents_handler.h',
        'browser/ui/webui/chrome_web_ui_controller_factory.cc',
        'browser/ui/webui/chrome_web_ui_controller_factory.h',
        'browser/ui/webui/chromeos/bluetooth_pairing_ui.cc',
        'browser/ui/webui/chromeos/bluetooth_pairing_ui.h',
        'browser/ui/webui/chromeos/choose_mobile_network_ui.cc',
        'browser/ui/webui/chromeos/choose_mobile_network_ui.h',
        'browser/ui/webui/chromeos/cryptohome_ui.cc',
        'browser/ui/webui/chromeos/cryptohome_ui.h',
        'browser/ui/webui/chromeos/cryptohome_web_ui_handler.cc',
        'browser/ui/webui/chromeos/cryptohome_web_ui_handler.h',
        'browser/ui/webui/chromeos/diagnostics/diagnostics_ui.cc',
        'browser/ui/webui/chromeos/diagnostics/diagnostics_ui.h',
        'browser/ui/webui/chromeos/drive_internals_ui.cc',
        'browser/ui/webui/chromeos/drive_internals_ui.h',
        'browser/ui/webui/chromeos/first_run/first_run_actor.cc',
        'browser/ui/webui/chromeos/first_run/first_run_actor.h',
        'browser/ui/webui/chromeos/first_run/first_run_handler.cc',
        'browser/ui/webui/chromeos/first_run/first_run_handler.h',
        'browser/ui/webui/chromeos/first_run/first_run_ui.cc',
        'browser/ui/webui/chromeos/first_run/first_run_ui.h',
        'browser/ui/webui/chromeos/imageburner/imageburner_ui.cc',
        'browser/ui/webui/chromeos/imageburner/imageburner_ui.h',
        'browser/ui/webui/chromeos/keyboard_overlay_ui.cc',
        'browser/ui/webui/chromeos/keyboard_overlay_ui.h',
        'browser/ui/webui/chromeos/login/app_launch_splash_screen_handler.cc',
        'browser/ui/webui/chromeos/login/app_launch_splash_screen_handler.h',
        'browser/ui/webui/chromeos/login/base_screen_handler.cc',
        'browser/ui/webui/chromeos/login/base_screen_handler.h',
        'browser/ui/webui/chromeos/login/base_screen_handler_utils.h',
        'browser/ui/webui/chromeos/login/core_oobe_handler.cc',
        'browser/ui/webui/chromeos/login/core_oobe_handler.h',
        'browser/ui/webui/chromeos/login/enrollment_screen_handler.cc',
        'browser/ui/webui/chromeos/login/enrollment_screen_handler.h',
        'browser/ui/webui/chromeos/login/error_screen_handler.cc',
        'browser/ui/webui/chromeos/login/error_screen_handler.h',
        'browser/ui/webui/chromeos/login/eula_screen_handler.cc',
        'browser/ui/webui/chromeos/login/eula_screen_handler.h',
        'browser/ui/webui/chromeos/login/kiosk_app_menu_handler.cc',
        'browser/ui/webui/chromeos/login/kiosk_app_menu_handler.h',
        'browser/ui/webui/chromeos/login/kiosk_autolaunch_screen_handler.cc',
        'browser/ui/webui/chromeos/login/kiosk_autolaunch_screen_handler.h',
        'browser/ui/webui/chromeos/login/kiosk_enable_screen_handler.cc',
        'browser/ui/webui/chromeos/login/kiosk_enable_screen_handler.h',
        'browser/ui/webui/chromeos/login/locally_managed_user_creation_screen_handler.cc',
        'browser/ui/webui/chromeos/login/locally_managed_user_creation_screen_handler.h',
        'browser/ui/webui/chromeos/login/network_dropdown.cc',
        'browser/ui/webui/chromeos/login/network_dropdown.h',
        'browser/ui/webui/chromeos/login/network_dropdown_handler.cc',
        'browser/ui/webui/chromeos/login/network_dropdown_handler.h',
        'browser/ui/webui/chromeos/login/network_screen_handler.cc',
        'browser/ui/webui/chromeos/login/network_screen_handler.h',
        'browser/ui/webui/chromeos/login/network_state_informer.cc',
        'browser/ui/webui/chromeos/login/network_state_informer.h',
        'browser/ui/webui/chromeos/login/oobe_ui.cc',
        'browser/ui/webui/chromeos/login/oobe_ui.h',
        'browser/ui/webui/chromeos/login/reset_screen_handler.cc',
        'browser/ui/webui/chromeos/login/reset_screen_handler.h',
        'browser/ui/webui/chromeos/login/screen_manager_handler.cc',
        'browser/ui/webui/chromeos/login/screen_manager_handler.h',
        'browser/ui/webui/chromeos/login/signin_screen_handler.cc',
        'browser/ui/webui/chromeos/login/signin_screen_handler.h',
        'browser/ui/webui/chromeos/login/terms_of_service_screen_handler.cc',
        'browser/ui/webui/chromeos/login/terms_of_service_screen_handler.h',
        'browser/ui/webui/chromeos/login/update_screen_handler.cc',
        'browser/ui/webui/chromeos/login/update_screen_handler.h',
        'browser/ui/webui/chromeos/login/user_image_screen_handler.cc',
        'browser/ui/webui/chromeos/login/user_image_screen_handler.h',
        'browser/ui/webui/chromeos/login/wrong_hwid_screen_handler.cc',
        'browser/ui/webui/chromeos/login/wrong_hwid_screen_handler.h',
        'browser/ui/webui/chromeos/mobile_setup_dialog.cc',
        'browser/ui/webui/chromeos/mobile_setup_dialog.h',
        'browser/ui/webui/chromeos/mobile_setup_ui.cc',
        'browser/ui/webui/chromeos/mobile_setup_ui.h',
        'browser/ui/webui/chromeos/network_ui.cc',
        'browser/ui/webui/chromeos/network_ui.h',
        'browser/ui/webui/chromeos/proxy_settings_ui.cc',
        'browser/ui/webui/chromeos/proxy_settings_ui.h',
        'browser/ui/webui/chromeos/sim_unlock_ui.cc',
        'browser/ui/webui/chromeos/sim_unlock_ui.h',
        'browser/ui/webui/chromeos/slow_ui.cc',
        'browser/ui/webui/chromeos/slow_ui.h',
        'browser/ui/webui/chromeos/system_info_ui.cc',
        'browser/ui/webui/chromeos/system_info_ui.h',
        'browser/ui/webui/chromeos/ui_account_tweaks.cc',
        'browser/ui/webui/chromeos/ui_account_tweaks.h',
        'browser/ui/webui/components_ui.cc',
        'browser/ui/webui/components_ui.h',
        'browser/ui/webui/constrained_web_dialog_ui.cc',
        'browser/ui/webui/constrained_web_dialog_ui.h',
        'browser/ui/webui/constrained_web_dialog_delegate_base.cc',
        'browser/ui/webui/constrained_web_dialog_delegate_base.h',
        'browser/ui/webui/cookies_tree_model_util.cc',
        'browser/ui/webui/cookies_tree_model_util.h',
        'browser/ui/webui/crashes_ui.cc',
        'browser/ui/webui/crashes_ui.h',
        'browser/ui/webui/devtools_ui.cc',
        'browser/ui/webui/devtools_ui.h',
        'browser/ui/webui/downloads_dom_handler.cc',
        'browser/ui/webui/downloads_dom_handler.h',
        'browser/ui/webui/downloads_ui.cc',
        'browser/ui/webui/downloads_ui.h',
        'browser/ui/webui/extensions/chromeos/kiosk_apps_handler.cc',
        'browser/ui/webui/extensions/chromeos/kiosk_apps_handler.h',
        'browser/ui/webui/extensions/command_handler.cc',
        'browser/ui/webui/extensions/command_handler.h',
        'browser/ui/webui/extensions/extension_basic_info.cc',
        'browser/ui/webui/extensions/extension_basic_info.h',
        'browser/ui/webui/extensions/extension_error_handler.cc',
        'browser/ui/webui/extensions/extension_error_handler.h',
        'browser/ui/webui/extensions/extension_icon_source.cc',
        'browser/ui/webui/extensions/extension_icon_source.h',
        'browser/ui/webui/extensions/extension_info_ui.cc',
        'browser/ui/webui/extensions/extension_info_ui.h',
        'browser/ui/webui/extensions/extension_settings_handler.cc',
        'browser/ui/webui/extensions/extension_settings_handler.h',
        'browser/ui/webui/extensions/extensions_ui.cc',
        'browser/ui/webui/extensions/extensions_ui.h',
        'browser/ui/webui/extensions/install_extension_handler.cc',
        'browser/ui/webui/extensions/install_extension_handler.h',
        'browser/ui/webui/extensions/pack_extension_handler.cc',
        'browser/ui/webui/extensions/pack_extension_handler.h',
        'browser/ui/webui/favicon_source.cc',
        'browser/ui/webui/favicon_source.h',
        'browser/ui/webui/fileicon_source.cc',
        'browser/ui/webui/fileicon_source.h',
        'browser/ui/webui/flags_ui.cc',
        'browser/ui/webui/flags_ui.h',
        'browser/ui/webui/flash_ui.cc',
        'browser/ui/webui/flash_ui.h',
        'browser/ui/webui/gesture_config_ui.cc',
        'browser/ui/webui/gesture_config_ui.h',
        'browser/ui/webui/chromeos/salsa_ui.cc',
        'browser/ui/webui/chromeos/salsa_ui.h',
        'browser/ui/webui/help/help_handler.cc',
        'browser/ui/webui/help/help_handler.h',
        'browser/ui/webui/help/help_ui.cc',
        'browser/ui/webui/help/help_ui.h',
        'browser/ui/webui/help/help_utils_chromeos.cc',
        'browser/ui/webui/help/help_utils_chromeos.h',
        'browser/ui/webui/help/version_updater.h',
        'browser/ui/webui/help/version_updater_basic.cc',
        'browser/ui/webui/help/version_updater_basic.h',
        'browser/ui/webui/help/version_updater_chromeos.cc',
        'browser/ui/webui/help/version_updater_chromeos.h',
        'browser/ui/webui/help/version_updater_mac.h',
        'browser/ui/webui/help/version_updater_mac.mm',
        'browser/ui/webui/help/version_updater_win.cc',
        'browser/ui/webui/history_ui.cc',
        'browser/ui/webui/history_ui.h',
        'browser/ui/webui/identity_internals_ui.cc',
        'browser/ui/webui/identity_internals_ui.h',
        'browser/ui/webui/inline_login_ui.cc',
        'browser/ui/webui/inline_login_ui.h',
        'browser/ui/webui/inspect_ui.cc',
        'browser/ui/webui/inspect_ui.h',
        'browser/ui/webui/instant_ui.cc',
        'browser/ui/webui/instant_ui.h',
        'browser/ui/webui/media/webrtc_logs_ui.cc',
        'browser/ui/webui/media/webrtc_logs_ui.h',
        'browser/ui/webui/memory_internals/memory_internals_handler.cc',
        'browser/ui/webui/memory_internals/memory_internals_handler.h',
        'browser/ui/webui/memory_internals/memory_internals_proxy.cc',
        'browser/ui/webui/memory_internals/memory_internals_proxy.h',
        'browser/ui/webui/memory_internals/memory_internals_ui.cc',
        'browser/ui/webui/memory_internals/memory_internals_ui.h',
        'browser/ui/webui/metrics_handler.cc',
        'browser/ui/webui/metrics_handler.h',
        'browser/ui/webui/nacl_ui.cc',
        'browser/ui/webui/nacl_ui.h',
        'browser/ui/webui/net_export_ui.cc',
        'browser/ui/webui/net_export_ui.h',
        'browser/ui/webui/net_internals/net_internals_ui.cc',
        'browser/ui/webui/net_internals/net_internals_ui.h',
        'browser/ui/webui/ntp/app_launcher_handler.cc',
        'browser/ui/webui/ntp/app_launcher_handler.h',
        'browser/ui/webui/ntp/core_app_launcher_handler.cc',
        'browser/ui/webui/ntp/core_app_launcher_handler.h',
        'browser/ui/webui/ntp/app_resource_cache_factory.cc',
        'browser/ui/webui/ntp/app_resource_cache_factory.h',
        'browser/ui/webui/ntp/favicon_webui_handler.cc',
        'browser/ui/webui/ntp/favicon_webui_handler.h',
        'browser/ui/webui/ntp/foreign_session_handler.cc',
        'browser/ui/webui/ntp/foreign_session_handler.h',
        'browser/ui/webui/ntp/most_visited_handler.cc',
        'browser/ui/webui/ntp/most_visited_handler.h',
        'browser/ui/webui/ntp/new_tab_page_handler.cc',
        'browser/ui/webui/ntp/new_tab_page_handler.h',
        'browser/ui/webui/ntp/new_tab_page_sync_handler.cc',
        'browser/ui/webui/ntp/new_tab_page_sync_handler.h',
        'browser/ui/webui/ntp/new_tab_ui.cc',
        'browser/ui/webui/ntp/new_tab_ui.h',
        'browser/ui/webui/ntp/ntp_login_handler.cc',
        'browser/ui/webui/ntp/ntp_login_handler.h',
        'browser/ui/webui/ntp/ntp_resource_cache.cc',
        'browser/ui/webui/ntp/ntp_resource_cache.h',
        'browser/ui/webui/ntp/ntp_resource_cache_factory.cc',
        'browser/ui/webui/ntp/ntp_resource_cache_factory.h',
        'browser/ui/webui/ntp/ntp_stats.h',
        'browser/ui/webui/ntp/ntp_user_data_logger.cc',
        'browser/ui/webui/ntp/ntp_user_data_logger.h',
        'browser/ui/webui/ntp/recently_closed_tabs_handler.cc',
        'browser/ui/webui/ntp/recently_closed_tabs_handler.h',
        'browser/ui/webui/ntp/suggestions_combiner.cc',
        'browser/ui/webui/ntp/suggestions_combiner.h',
        'browser/ui/webui/ntp/suggestions_page_handler.cc',
        'browser/ui/webui/ntp/suggestions_page_handler.h',
        'browser/ui/webui/ntp/suggestions_source.h',
        'browser/ui/webui/ntp/suggestions_source_discovery.cc',
        'browser/ui/webui/ntp/suggestions_source_discovery.h',
        'browser/ui/webui/ntp/suggestions_source_top_sites.cc',
        'browser/ui/webui/ntp/suggestions_source_top_sites.h',
        'browser/ui/webui/ntp/thumbnail_source.cc',
        'browser/ui/webui/ntp/thumbnail_source.h',
        'browser/ui/webui/omnibox/omnibox_ui.cc',
        'browser/ui/webui/omnibox/omnibox_ui.h',
        'browser/ui/webui/omnibox/omnibox_ui_handler.cc',
        'browser/ui/webui/omnibox/omnibox_ui_handler.h',
        'browser/ui/webui/options/advanced_options_utils.h',
        'browser/ui/webui/options/advanced_options_utils_mac.mm',
        'browser/ui/webui/options/advanced_options_utils_win.cc',
        'browser/ui/webui/options/advanced_options_utils_x11.cc',
        'browser/ui/webui/options/autofill_options_handler.cc',
        'browser/ui/webui/options/autofill_options_handler.h',
        'browser/ui/webui/options/browser_options_handler.cc',
        'browser/ui/webui/options/browser_options_handler.h',
        'browser/ui/webui/options/certificate_manager_handler.cc',
        'browser/ui/webui/options/certificate_manager_handler.h',
        'browser/ui/webui/options/chromeos/accounts_options_handler.cc',
        'browser/ui/webui/options/chromeos/accounts_options_handler.h',
        'browser/ui/webui/options/chromeos/bluetooth_options_handler.cc',
        'browser/ui/webui/options/chromeos/bluetooth_options_handler.h',
        'browser/ui/webui/options/chromeos/change_picture_options_handler.cc',
        'browser/ui/webui/options/chromeos/change_picture_options_handler.h',
        'browser/ui/webui/options/chromeos/core_chromeos_options_handler.cc',
        'browser/ui/webui/options/chromeos/core_chromeos_options_handler.h',
        'browser/ui/webui/options/chromeos/cros_language_options_handler.cc',
        'browser/ui/webui/options/chromeos/cros_language_options_handler.h',
        'browser/ui/webui/options/chromeos/display_options_handler.cc',
        'browser/ui/webui/options/chromeos/display_options_handler.h',
        'browser/ui/webui/options/chromeos/display_overscan_handler.cc',
        'browser/ui/webui/options/chromeos/display_overscan_handler.h',
        'browser/ui/webui/options/chromeos/internet_options_handler.cc',
        'browser/ui/webui/options/chromeos/internet_options_handler.h',
        'browser/ui/webui/options/chromeos/keyboard_handler.cc',
        'browser/ui/webui/options/chromeos/keyboard_handler.h',
        'browser/ui/webui/options/chromeos/pointer_handler.cc',
        'browser/ui/webui/options/chromeos/pointer_handler.h',
        'browser/ui/webui/options/chromeos/proxy_handler.cc',
        'browser/ui/webui/options/chromeos/proxy_handler.h',
        'browser/ui/webui/options/chromeos/stats_options_handler.cc',
        'browser/ui/webui/options/chromeos/stats_options_handler.h',
        'browser/ui/webui/options/chromeos/timezone_options_util.cc',
        'browser/ui/webui/options/chromeos/timezone_options_util.h',
        'browser/ui/webui/options/chromeos/user_image_source.cc',
        'browser/ui/webui/options/chromeos/user_image_source.h',
        'browser/ui/webui/options/clear_browser_data_handler.cc',
        'browser/ui/webui/options/clear_browser_data_handler.h',
        'browser/ui/webui/options/content_settings_handler.cc',
        'browser/ui/webui/options/content_settings_handler.h',
        'browser/ui/webui/options/cookies_view_handler.cc',
        'browser/ui/webui/options/cookies_view_handler.h',
        'browser/ui/webui/options/core_options_handler.cc',
        'browser/ui/webui/options/core_options_handler.h',
        'browser/ui/webui/options/create_profile_handler.cc',
        'browser/ui/webui/options/create_profile_handler.h',
        'browser/ui/webui/options/font_settings_handler.cc',
        'browser/ui/webui/options/font_settings_handler.h',
        'browser/ui/webui/options/font_settings_utils.h',
        'browser/ui/webui/options/font_settings_utils_linux.cc',
        'browser/ui/webui/options/font_settings_utils_mac.mm',
        'browser/ui/webui/options/font_settings_utils_win.cc',
        'browser/ui/webui/options/geolocation_options_handler.cc',
        'browser/ui/webui/options/geolocation_options_handler.h',
        'browser/ui/webui/options/handler_options_handler.cc',
        'browser/ui/webui/options/handler_options_handler.h',
        'browser/ui/webui/options/home_page_overlay_handler.cc',
        'browser/ui/webui/options/home_page_overlay_handler.h',
        'browser/ui/webui/options/import_data_handler.cc',
        'browser/ui/webui/options/import_data_handler.h',
        'browser/ui/webui/options/language_dictionary_overlay_handler.cc',
        'browser/ui/webui/options/language_dictionary_overlay_handler.h',
        'browser/ui/webui/options/language_options_handler.cc',
        'browser/ui/webui/options/language_options_handler.h',
        'browser/ui/webui/options/language_options_handler_common.cc',
        'browser/ui/webui/options/language_options_handler_common.h',
        'browser/ui/webui/options/managed_user_create_confirm_handler.cc',
        'browser/ui/webui/options/managed_user_create_confirm_handler.h',
        'browser/ui/webui/options/managed_user_import_handler.cc',
        'browser/ui/webui/options/managed_user_import_handler.h',
        'browser/ui/webui/options/managed_user_learn_more_handler.cc',
        'browser/ui/webui/options/managed_user_learn_more_handler.h',
        'browser/ui/webui/options/manage_profile_handler.cc',
        'browser/ui/webui/options/manage_profile_handler.h',
        'browser/ui/webui/options/media_devices_selection_handler.cc',
        'browser/ui/webui/options/media_devices_selection_handler.h',
        'browser/ui/webui/options/media_galleries_handler.cc',
        'browser/ui/webui/options/media_galleries_handler.h',
        'browser/ui/webui/options/options_handlers_helper.cc',
        'browser/ui/webui/options/options_handlers_helper.h',
        'browser/ui/webui/options/options_ui.cc',
        'browser/ui/webui/options/options_ui.h',
        'browser/ui/webui/options/password_manager_handler.cc',
        'browser/ui/webui/options/password_manager_handler.h',
        'browser/ui/webui/options/pepper_flash_content_settings_utils.cc',
        'browser/ui/webui/options/pepper_flash_content_settings_utils.h',
        'browser/ui/webui/options/reset_profile_settings_handler.cc',
        'browser/ui/webui/options/reset_profile_settings_handler.h',
        'browser/ui/webui/options/search_engine_manager_handler.cc',
        'browser/ui/webui/options/search_engine_manager_handler.h',
        'browser/ui/webui/options/startup_pages_handler.cc',
        'browser/ui/webui/options/startup_pages_handler.h',
        'browser/ui/webui/performance_monitor/performance_monitor_l10n.cc',
        'browser/ui/webui/performance_monitor/performance_monitor_l10n.h',
        'browser/ui/webui/performance_monitor/performance_monitor_ui_constants.cc',
        'browser/ui/webui/performance_monitor/performance_monitor_ui_constants.h',
        'browser/ui/webui/performance_monitor/performance_monitor_ui_util.cc',
        'browser/ui/webui/performance_monitor/performance_monitor_ui_util.h',
        'browser/ui/webui/performance_monitor/performance_monitor_ui.cc',
        'browser/ui/webui/performance_monitor/performance_monitor_ui.h',
        'browser/ui/webui/performance_monitor/performance_monitor_handler.cc',
        'browser/ui/webui/performance_monitor/performance_monitor_handler.h',
        'browser/ui/webui/plugins_ui.cc',
        'browser/ui/webui/plugins_ui.h',
        'browser/ui/webui/policy_ui.cc',
        'browser/ui/webui/policy_ui.h',
        'browser/ui/webui/predictors/predictors_handler.cc',
        'browser/ui/webui/predictors/predictors_handler.h',
        'browser/ui/webui/predictors/predictors_ui.cc',
        'browser/ui/webui/predictors/predictors_ui.h',
        'browser/ui/webui/print_preview/print_preview_handler.cc',
        'browser/ui/webui/print_preview/print_preview_handler.h',
        'browser/ui/webui/print_preview/print_preview_ui.cc',
        'browser/ui/webui/print_preview/print_preview_ui.h',
        'browser/ui/webui/print_preview/sticky_settings.cc',
        'browser/ui/webui/print_preview/sticky_settings.h',
        'browser/ui/webui/profiler_ui.cc',
        'browser/ui/webui/profiler_ui.h',
        'browser/ui/webui/quota_internals/quota_internals_handler.cc',
        'browser/ui/webui/quota_internals/quota_internals_handler.h',
        'browser/ui/webui/quota_internals/quota_internals_proxy.cc',
        'browser/ui/webui/quota_internals/quota_internals_proxy.h',
        'browser/ui/webui/quota_internals/quota_internals_types.cc',
        'browser/ui/webui/quota_internals/quota_internals_types.h',
        'browser/ui/webui/quota_internals/quota_internals_ui.cc',
        'browser/ui/webui/quota_internals/quota_internals_ui.h',
        'browser/ui/webui/set_as_default_browser_ui.cc',
        'browser/ui/webui/set_as_default_browser_ui.h',
        'browser/ui/webui/signin/login_ui_service.cc',
        'browser/ui/webui/signin/login_ui_service.h',
        'browser/ui/webui/signin/login_ui_service_factory.cc',
        'browser/ui/webui/signin/login_ui_service_factory.h',
        'browser/ui/webui/signin/profile_signin_confirmation_dialog.h',
        'browser/ui/webui/signin/profile_signin_confirmation_dialog.cc',
        'browser/ui/webui/signin/profile_signin_confirmation_ui.h',
        'browser/ui/webui/signin/profile_signin_confirmation_ui.cc',
        'browser/ui/webui/signin/user_manager_screen_handler.h',
        'browser/ui/webui/signin/user_manager_screen_handler.cc',
        'browser/ui/webui/signin/user_manager_ui.h',
        'browser/ui/webui/signin/user_manager_ui.cc',
        'browser/ui/webui/signin_internals_ui.cc',
        'browser/ui/webui/signin_internals_ui.h',
        'browser/ui/webui/suggestions_internals/suggestions_internals_ui.cc',
        'browser/ui/webui/suggestions_internals/suggestions_internals_ui.h',
        'browser/ui/webui/suggestions_internals/suggestions_internals_ui_handler.cc',
        'browser/ui/webui/suggestions_internals/suggestions_internals_ui_handler.h',
        'browser/ui/webui/sync_file_system_internals/extension_statuses_handler.cc',
        'browser/ui/webui/sync_file_system_internals/extension_statuses_handler.h',
        'browser/ui/webui/sync_file_system_internals/file_metadata_handler.cc',
        'browser/ui/webui/sync_file_system_internals/file_metadata_handler.h',
        'browser/ui/webui/sync_file_system_internals/sync_file_system_internals_handler.cc',
        'browser/ui/webui/sync_file_system_internals/sync_file_system_internals_handler.h',
        'browser/ui/webui/sync_file_system_internals/sync_file_system_internals_ui.cc',
        'browser/ui/webui/sync_file_system_internals/sync_file_system_internals_ui.h',
        'browser/ui/webui/sync_internals_ui.cc',
        'browser/ui/webui/sync_internals_ui.h',
        'browser/ui/webui/sync_setup_handler.cc',
        'browser/ui/webui/sync_setup_handler.h',
        'browser/ui/webui/task_manager/task_manager_dialog.cc',
        'browser/ui/webui/task_manager/task_manager_dialog.h',
        'browser/ui/webui/task_manager/task_manager_handler.cc',
        'browser/ui/webui/task_manager/task_manager_handler.h',
        'browser/ui/webui/task_manager/task_manager_ui.cc',
        'browser/ui/webui/task_manager/task_manager_ui.h',
        'browser/ui/webui/theme_handler.cc',
        'browser/ui/webui/theme_handler.h',
        'browser/ui/webui/theme_source.cc',
        'browser/ui/webui/theme_source.h',
        'browser/ui/webui/translate_internals/translate_internals_handler.cc',
        'browser/ui/webui/translate_internals/translate_internals_handler.h',
        'browser/ui/webui/translate_internals/translate_internals_ui.cc',
        'browser/ui/webui/translate_internals/translate_internals_ui.h',
        'browser/ui/webui/uber/uber_ui.cc',
        'browser/ui/webui/uber/uber_ui.h',
        'browser/ui/webui/user_actions/user_actions_ui.cc',
        'browser/ui/webui/user_actions/user_actions_ui.h',
        'browser/ui/webui/user_actions/user_actions_ui_handler.cc',
        'browser/ui/webui/user_actions/user_actions_ui_handler.h',
        'browser/ui/webui/version_handler.cc',
        'browser/ui/webui/version_handler.h',
        'browser/ui/webui/version_handler_chromeos.cc',
        'browser/ui/webui/version_handler_chromeos.h',
        'browser/ui/webui/version_ui.cc',
        'browser/ui/webui/version_ui.h',
        'browser/ui/webui/welcome_handler_android.cc',
        'browser/ui/webui/welcome_handler_android.h',
        'browser/ui/webui/welcome_ui_android.cc',
        'browser/ui/webui/welcome_ui_android.h',
        'browser/ui/window_sizer/window_sizer.cc',
        'browser/ui/window_sizer/window_sizer.h',
        'browser/ui/window_sizer/window_sizer_ash.cc',
        'browser/ui/window_sizer/window_sizer_aura.cc',
        'browser/ui/window_sizer/window_sizer_gtk.cc',
        'browser/ui/window_sizer/window_sizer_mac.mm',
        'browser/ui/window_sizer/window_sizer_win.cc',
        'browser/ui/window_snapshot/window_snapshot.cc',
        'browser/ui/window_snapshot/window_snapshot.h',
        'browser/ui/zoom/zoom_controller.cc',
        'browser/ui/zoom/zoom_controller.h',
        'browser/ui/zoom/zoom_observer.h',
      ],
      'conditions': [
        ['OS != "ios"', {
          'dependencies': [
            'browser_extensions',
            'browser/performance_monitor/performance_monitor.gyp:performance_monitor',
            'common/extensions/api/api.gyp:api',
            'debugger',
            'installer_util',
            '../components/components.gyp:autofill_content_risk_proto',
            '../components/component_strings.gyp:component_strings',
            '../components/components.gyp:dom_distiller_core',
            '../components/components.gyp:dom_distiller_webui',
            '../device/bluetooth/bluetooth.gyp:device_bluetooth',
            '../media/media.gyp:media',
            '../net/net.gyp:net_with_v8',
            '../printing/printing.gyp:printing',
            '../third_party/adobe/flash/flash_player.gyp:flapper_version_h',
            '../third_party/expat/expat.gyp:expat',
            '../third_party/hunspell/hunspell.gyp:hunspell',
            '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
            '../third_party/libjingle/libjingle.gyp:libjingle',
            '../third_party/npapi/npapi.gyp:npapi',
            '../third_party/re2/re2.gyp:re2',
            '../ui/compositor/compositor.gyp:compositor',
            '../ui/surface/surface.gyp:surface',
            '../ui/web_dialogs/web_dialogs.gyp:web_dialogs',
            '../v8/tools/gyp/v8.gyp:v8',
            '../webkit/common/webkit_common.gyp:webkit_common',
            '../webkit/storage_browser.gyp:webkit_storage_browser',
            '../webkit/storage_common.gyp:webkit_storage_common',
            '../webkit/webkit_resources.gyp:webkit_resources',
          ],
          'defines': [
            '<@(nacl_defines)',
          ],
          'direct_dependent_settings': {
            'defines': [
              '<@(nacl_defines)',
            ],
          },
        }, {  # OS == "ios"
          'dependencies': [
            '../net/net.gyp:net',
          ],
          'sources/': [
            # iOS uses only small portions of browser/ui/.
            ['exclude', '\\.(cc|mm)$'],
            ['include', '_ios\\.(cc|mm)$'],
            ['include', '(^|/)ios/'],
            # TODO(ios): Add files here as they are updated to compile on iOS.
            ['include', '^browser/ui/profile_error_dialog\\.cc$'],
          ],
        }],
        ['OS!="ios" and chrome_multiple_dll!=1', {
          'dependencies': [
            '../webkit/support/webkit_support.gyp:glue',
          ],
        }],
        ['OS == "android"', {
          'dependencies': [
            '../third_party/openssl/openssl.gyp:openssl',
          ],
        }],
        ['enable_one_click_signin==0', {
          'sources!': [
            'browser/ui/cocoa/one_click_signin_bubble_controller.h',
            'browser/ui/cocoa/one_click_signin_bubble_controller.mm',
            'browser/ui/gtk/one_click_signin_bubble_gtk.cc',
            'browser/ui/gtk/one_click_signin_bubble_gtk.h',
            'browser/ui/sync/one_click_signin_bubble_delegate.h',
            'browser/ui/sync/one_click_signin_bubble_links_delegate.cc',
            'browser/ui/sync/one_click_signin_bubble_links_delegate.h',
            'browser/ui/sync/one_click_signin_helper.cc',
            'browser/ui/sync/one_click_signin_helper.h',
            'browser/ui/sync/one_click_signin_histogram.h',
            'browser/ui/sync/one_click_signin_sync_starter.cc',
            'browser/ui/sync/one_click_signin_sync_starter.h',
            'browser/ui/views/sync/one_click_signin_bubble_view.cc',
            'browser/ui/views/sync/one_click_signin_bubble_view.h',
          ]
        }],
        ['enable_task_manager==0', {
          'sources/': [
            ['exclude', '^browser/ui/webui/task_manager/'],
            ['exclude', '^browser/ui/views/task_manager_view.cc'],
            ['exclude', '^browser/ui/cocoa/task_manager_mac.h'],
            ['exclude', '^browser/ui/cocoa/task_manager_mac.mm'],
            ['exclude', '^browser/ui/gtk/task_manager_gtk.cc'],
            ['exclude', '^browser/ui/gtk/task_manager_gtk.h'],
          ],
        }],
        ['disable_nacl==0', {
          'sources': [
            'browser/ui/webui/nacl_ui.cc',
            'browser/ui/webui/nacl_ui.h',
          ],
          'dependencies': [
            '../native_client/src/trusted/service_runtime/service_runtime.gyp:sel',
          ],
        }],
        ['debug_devtools==1', {
          'defines': [
            'DEBUG_DEVTOOLS=1',
          ],
        }],
        ['configuration_policy==1', {
          'dependencies': [
            'app/policy/cloud_policy_codegen.gyp:policy',
          ],
        }, {  # configuration_policy==0
          'sources/': [
            ['exclude', 'browser/ui/webui/policy_ui.cc'],
            ['exclude', 'browser/ui/webui/policy_ui.h'],
          ],
        }],
        ['enable_plugins==1', {
          'dependencies': [
            '../ppapi/ppapi_internal.gyp:ppapi_ipc',
          ],
        }, {  # enable_plugins == 0
          'sources!': [
            'browser/ui/hung_plugin_tab_helper.cc',
            'browser/ui/hung_plugin_tab_helper.h',
          ],
        }],
        ['safe_browsing==1', {
          'defines': [
            'FULL_SAFE_BROWSING',
          ],
        }, {  # safe_browsing==0 || safe_browsing==2
          'dependencies!': [
            'safe_browsing_proto',
            'safe_browsing_report_proto',
            '../third_party/libusb/libusb.gyp:libusb',
          ],
        }],
        ['toolkit_views == 0', {
          'sources!': [
            'browser/ui/tabs/tab_strip_layout_type.h',
            'browser/ui/tabs/tab_strip_layout_type_prefs.cc',
            'browser/ui/tabs/tab_strip_layout_type_prefs.h',
          ],
        }],
        ['OS=="linux"', {
          'dependencies': [
            '../build/linux/system.gyp:udev',
          ],
          'sources/': [
            ['exclude', '^browser/ui/webui/certificate_viewer_webui.cc'],
            ['exclude', '^browser/ui/webui/certificate_viewer_webui.h'],
          ],
        }],
        ['chromeos==0', {
          'sources/': [
            ['exclude', '^browser/ui/webui/chromeos'],
            ['exclude', '^browser/ui/webui/options/chromeos'],
          ],
        }, {  # chromeos==1
          'dependencies': [
            'browser_chromeos',
          ],
          'sources!': [
            'browser/first_run/upgrade_util.cc',
            'browser/first_run/upgrade_util.h',
            'browser/first_run/upgrade_util_linux.cc',
            'browser/icon_loader_linux.cc',
            'browser/icon_manager_linux.cc',
            'browser/idle_linux.cc',
            'browser/password_manager/native_backend_gnome_x.cc',
            'browser/password_manager/native_backend_gnome_x.h',
            'browser/password_manager/native_backend_kwallet_x.cc',
            'browser/password_manager/native_backend_kwallet_x.h',
            'browser/platform_util_linux.cc',
            'browser/speech/extension_api/tts_extension_api_linux.cc',
            'browser/storage_monitor/mtab_watcher_linux.cc',
            'browser/storage_monitor/mtab_watcher_linux.h',
            'browser/storage_monitor/storage_monitor_linux.cc',
            'browser/storage_monitor/storage_monitor_linux.h',
            'browser/ui/ash/caps_lock_delegate_views.cc',
            'browser/ui/ash/chrome_shell_delegate_views.cc',
            'browser/ui/ash/session_state_delegate_views.cc',
            'browser/ui/screen_capture_notification_ui_stub.cc',
            'browser/ui/startup/default_browser_prompt.cc',
            'browser/ui/startup/default_browser_prompt.h',
            'browser/ui/views/frame/browser_desktop_root_window_host_x11.cc',
            'browser/ui/views/frame/browser_desktop_root_window_host_x11.h',
            'browser/ui/views/frame/desktop_browser_frame_aura.cc',
            'browser/ui/views/frame/desktop_browser_frame_aura.h',
            'browser/ui/views/frame/desktop_user_action_handler_aura.cc',
            'browser/ui/views/frame/desktop_user_action_handler_aura.h',
            'browser/ui/views/frame/global_menu_bar_x11.cc',
            'browser/ui/views/frame/global_menu_bar_x11.h',
            'browser/ui/views/frame/global_menu_bar_registrar_x11.cc',
            'browser/ui/views/frame/global_menu_bar_registrar_x11.h',
            'browser/ui/views/frame/opaque_browser_frame_view_linux.h',
            'browser/ui/views/frame/opaque_browser_frame_view_linux.cc',
            'browser/ui/views/screen_capture_notification_ui_views.cc',
            'browser/ui/webui/help/version_updater_basic.cc',
            'browser/ui/webui/help/version_updater_basic.h',
            'browser/ui/webui/signin/user_manager_screen_handler.h',
            'browser/ui/webui/signin/user_manager_screen_handler.cc',
            'browser/ui/webui/signin/user_manager_ui.h',
            'browser/ui/webui/signin/user_manager_ui.cc',
            'browser/upgrade_detector_impl.cc',
            'browser/upgrade_detector_impl.h',
          ],
        }],
        ['use_cups==1', {
          'dependencies': [
            '../printing/printing.gyp:cups',
          ],
        }],
        ['use_gconf==0', {
          'sources!': [
            'browser/ui/gtk/gconf_titlebar_listener.cc',
            'browser/ui/gtk/gconf_titlebar_listener.h',
          ],
        }],
        ['use_ash==1', {
          'sources': [
            'browser/ui/views/touch_uma/touch_uma_ash.cc',
          ],
          'dependencies': [
            '../ash/ash.gyp:ash',
            '../ash/ash_strings.gyp:ash_strings',
          ],
        }, { # use_ash==0
          'sources': [
            'browser/ui/views/touch_uma/touch_uma.cc',
          ],
        }],
        ['toolkit_views==0 or chromeos==1', {
          'sources!': [
            'browser/ui/views/message_center/message_center_frame_view.cc',
            'browser/ui/views/message_center/message_center_frame_view.h',
            'browser/ui/views/message_center/message_center_widget_delegate.h',
            'browser/ui/views/message_center/message_center_widget_delegate.cc',
            'browser/ui/views/message_center/web_notification_tray.h',
            'browser/ui/views/message_center/web_notification_tray.cc',
          ],
        }],
        ['use_aura==1 and use_ash==0 and use_ozone==0 and OS=="linux"', {
          'dependencies': [
            # gtk2 is the only component that can interact with gtk2 in our new
            # world.
            'browser/ui/libgtk2ui/libgtk2ui.gyp:gtk2ui',
            '../build/linux/system.gyp:gio',
          ],
        }],
        ['use_aura==0 or chromeos==1 or OS!="linux"', {
          'sources!': [
            'browser/ui/views/status_icons/status_icon_linux_wrapper.cc',
            'browser/ui/views/status_icons/status_icon_linux_wrapper.h',
          ],
        }],
        ['use_aura==1', {
          'sources/': [
            ['exclude', '^browser/ui/external_protocol_dialog_delegate.cc'],
            ['exclude', '^browser/ui/panels/display_settings_provider_win.cc'],
            ['exclude', '^browser/ui/panels/taskbar_window_thumbnailer_win.cc'],
            ['exclude', '^browser/ui/panels/taskbar_window_thumbnailer_win.h'],
            ['exclude', '^browser/ui/screen_capture_notification_ui_stub.cc'],
            ['exclude', '^browser/ui/views/about_ipc_dialog.cc'],
            ['exclude', '^browser/ui/views/app_menu_button_win.cc'],
            ['exclude', '^browser/ui/views/dropdown_bar_host_win.cc'],
            ['exclude', '^browser/ui/views/external_protocol_dialog.cc'],
            ['exclude', '^browser/ui/views/find_bar_host_win.cc'],
            ['exclude', '^browser/ui/views/frame/browser_frame_win.cc'],
            ['exclude', '^browser/ui/views/frame/browser_frame_win.h'],
            ['exclude', '^browser/ui/views/frame/browser_non_client_frame_view_factory_win.cc'],
            ['exclude', '^browser/ui/views/frame/native_browser_frame_factory_win.cc'],
            ['exclude', '^browser/ui/views/importer/import_progress_dialog_view.cc'],
            ['exclude', '^browser/ui/views/omnibox/omnibox_view_win.cc'],
            ['exclude', '^browser/ui/views/omnibox/omnibox_view_win.h'],
            ['exclude', '^browser/ui/views/color_chooser_dialog.cc'],
            ['exclude', '^browser/ui/views/color_chooser_dialog.h'],
            ['exclude', '^browser/ui/views/color_chooser_win.cc'],
            ['exclude', '^browser/ui/views/tabs/native_view_photobooth.h'],
            ['exclude', '^browser/ui/views/tabs/native_view_photobooth_win.cc'],
            ['exclude', '^browser/ui/views/tabs/native_view_photobooth_win.h'],
            ['exclude', '^browser/ui/views/user_data_dir_dialog_view.cc'],
            ['exclude', '^browser/ui/views/tab_contents/web_drag_bookmark_handler_win.cc'],
            ['exclude', '^browser/ui/views/tab_contents/web_drag_bookmark_handler_win.h'],
            ['exclude', '^browser/ui/webui/task_manager/'],
            ['exclude', '^browser/ui/window_sizer/window_sizer_win.cc'],
            # TODO: (stevenjb/beng): Find a home for these.
            ['include', '^browser/ui/views/simple_message_box_views.cc'],
            ['include', '^browser/ui/webui/certificate_viewer_webui.cc'],
            ['include', '^browser/ui/webui/certificate_viewer_webui.h'],
            ['include', '^browser/ui/webui/certificate_viewer_ui.cc'],
            ['include', '^browser/ui/webui/certificate_viewer_ui.h'],
          ],
          'dependencies': [
            # aura uses some of ash resources.
            '../ash/ash.gyp:ash_resources',
            '../ui/aura/aura.gyp:aura',
            '../ui/keyboard/keyboard.gyp:keyboard',
            '../ui/keyboard/keyboard.gyp:keyboard_resources',
          ],
          'conditions': [
            ['OS=="win"', {
              'sources/': [
                ['exclude', '^browser/ui/views/hwnd_util_win.cc'],
                ['exclude', '^browser/ui/views/native_focus_tracker_views_win.cc'],
                ['exclude', '^browser/ui/views/theme_image_mapper.cc'],
                ['exclude', '^browser/ui/webui/certificate_viewer_webui.cc'],
                ['exclude', '^browser/ui/webui/certificate_viewer_webui.h'],
                ['exclude', '^browser/ui/webui/certificate_viewer_ui.cc'],
                ['exclude', '^browser/ui/webui/certificate_viewer_ui.h'],
                ['include', 'browser/ui/browser_win.cc'],
              ],
            }, {
              'sources/': [
                ['exclude', '^browser/ui/views/hwnd_util.h'],
                ['exclude', '^browser/ui/views/frame/glass_browser_frame_view.cc'],
                ['exclude', '^browser/ui/views/frame/glass_browser_frame_view.h'],
              ],
            }],
          ],
        }, { # else: use_aura==0
          'sources/': [
            ['exclude', '^browser/ui/views/frame/browser_desktop_root_window_host.h'],
            ['exclude', '^browser/ui/views/frame/browser_desktop_root_window_host_win.cc'],
            ['exclude', '^browser/ui/views/frame/browser_desktop_root_window_host_win.h'],
            ['exclude', '^browser/ui/views/frame/browser_desktop_root_window_host_x11.cc'],
            ['exclude', '^browser/ui/views/frame/browser_desktop_root_window_host_x11.h'],
            ['exclude', '^browser/ui/views/theme_image_mapper_aura_win.cc'],
            ['exclude', '^browser/ui/webui/gesture_config_ui.cc'],
            ['exclude', '^browser/ui/webui/gesture_config_ui.h'],
            ['exclude', '^browser/ui/webui/salsa_ui.cc'],
            ['exclude', '^browser/ui/webui/salsa_ui.h'],
            ['exclude', '^browser/ui/webui/task_manager/'],
          ],
        }],
        ['ui_compositor_image_transport==1', {
          'dependencies': [
            '../ui/gl/gl.gyp:gl',
          ],
        }],
        ['os_posix == 1 and OS != "mac" and OS != "ios" and OS != "android"', {
          'link_settings': {
            'libraries': [
              '-lXss',
            ],
          },
        }],
        ['use_nss!=1', {
          'sources!': [
            'browser/ui/webui/options/certificate_manager_handler.cc',
            'browser/ui/webui/options/certificate_manager_handler.h',
          ],
        }],
        ['use_nss==0 and use_openssl==0', {
          'sources!': [
            'browser/ui/webui/certificate_viewer_webui.cc',
            'browser/ui/webui/certificate_viewer_webui.h',
            'browser/ui/webui/certificate_viewer_ui.cc',
            'browser/ui/webui/certificate_viewer_ui.h',
          ],
        }],
        ['toolkit_uses_gtk == 1', {
          'dependencies': [
            '../build/linux/system.gyp:dbus',
            '../build/linux/system.gyp:gconf',
            '../build/linux/system.gyp:gtk',
            '../build/linux/system.gyp:gtkprint',
            '../build/linux/system.gyp:ssl',
            '../build/linux/system.gyp:x11',
            '../dbus/dbus.gyp:dbus',
            '../third_party/undoview/undoview.gyp:undoview',
          ],
          'sources!': [
            'browser/ui/screen_capture_notification_ui_stub.cc',
          ],
        }],
        ['enable_themes==0', {
          'sources!': [
            'browser/ui/webui/theme_source.cc',
          ],
        }],
        ['enable_printing!=1', {
          'sources/': [
            ['exclude', '^browser/ui/webui/print_preview/'],
          ],
        }],
        ['OS=="android"', {
          'dependencies': [
            '../components/components.gyp:web_contents_delegate_android',
            'chrome_browser_jni_headers',
          ],
          'sources': [
            'browser/ui/webui/ntp/android/bookmarks_handler.cc',
            'browser/ui/webui/ntp/android/bookmarks_handler.h',
            'browser/ui/webui/ntp/android/context_menu_handler.cc',
            'browser/ui/webui/ntp/android/context_menu_handler.h',
            'browser/ui/webui/ntp/android/managed_bookmarks_shim.cc',
            'browser/ui/webui/ntp/android/managed_bookmarks_shim.h',
            'browser/ui/webui/ntp/android/navigation_handler.cc',
            'browser/ui/webui/ntp/android/navigation_handler.h',
            'browser/ui/webui/ntp/android/new_tab_page_ready_handler.cc',
            'browser/ui/webui/ntp/android/new_tab_page_ready_handler.h',
            'browser/ui/webui/ntp/android/partner_bookmarks_shim.cc',
            'browser/ui/webui/ntp/android/partner_bookmarks_shim.h',
            'browser/ui/webui/ntp/android/promo_handler.cc',
            'browser/ui/webui/ntp/android/promo_handler.h',
            'browser/ui/webui/ntp/android/ntp_resource_cache_android.cc',
          ],
          'sources!': [
            # Android uses native UI for sync setup.
            'browser/ui/webui/ntp/new_tab_page_sync_handler.cc',
            'browser/ui/webui/ntp/new_tab_page_sync_handler.h',
            'browser/ui/webui/ntp/ntp_login_handler.cc',
            'browser/ui/webui/ntp/ntp_login_handler.h',
            'browser/ui/webui/sync_setup_handler.cc',
            'browser/ui/webui/sync_setup_handler.h',

            # There's no Browser/BrowserList on Android.
            'browser/ui/active_tab_tracker.cc',
            'browser/ui/active_tab_tracker.h',
            'browser/ui/bookmarks/bookmark_bubble_sign_in_delegate.cc',
            'browser/ui/bookmarks/bookmark_bubble_sign_in_delegate.h',
            'browser/ui/bookmarks/bookmark_context_menu_controller.cc',
            'browser/ui/bookmarks/bookmark_prompt_controller.cc',
            'browser/ui/browser.cc',
            'browser/ui/browser_command_controller.cc',
            'browser/ui/browser_finder.cc',
            'browser/ui/browser_iterator.cc',
            'browser/ui/browser_list.cc',
            'browser/ui/browser_otr_state.cc',
            'browser/ui/browser_tab_contents.cc',
            'browser/ui/browser_tab_restore_service_delegate.cc',
            'browser/ui/browser_tabstrip.cc',
            'browser/ui/browser_tabstrip.h',
            'browser/ui/chrome_pages.cc',
            'browser/ui/chrome_pages.h',
            'browser/ui/extensions/extension_install_ui_default.cc',
            'browser/ui/extensions/extension_install_ui_default.h',
            'browser/ui/ntp_background_util.cc',
            'browser/ui/ntp_background_util.h',
            'browser/ui/sad_tab_helper.cc',
            'browser/ui/singleton_tabs.cc',
            'browser/ui/singleton_tabs.h',
            'browser/ui/sync/browser_synced_window_delegate.cc',
            'browser/ui/tab_contents/tab_contents_iterator.cc',
            'browser/ui/uma_browsing_activity_observer.cc',
            'browser/ui/uma_browsing_activity_observer.h',
            'browser/ui/webui/bookmarks_ui.cc',
            'browser/ui/webui/bookmarks_ui.h',
            'browser/ui/webui/certificate_viewer_webui.cc',
            'browser/ui/webui/extensions/command_handler.cc',
            'browser/ui/webui/extensions/extension_settings_handler.cc',
            'browser/ui/webui/extensions/extension_settings_handler.h',
            'browser/ui/webui/extensions/extensions_ui.cc',
            'browser/ui/webui/extensions/install_extension_handler.cc',
            'browser/ui/webui/identity_internals_ui.cc',
            'browser/ui/webui/identity_internals_ui.h',
            'browser/ui/webui/inspect_ui.cc',
            'browser/ui/webui/inspect_ui.h',
            'browser/ui/webui/ntp/app_launcher_handler.cc',
            'browser/ui/webui/ntp/app_launcher_handler.h',
            'browser/ui/webui/ntp/new_tab_page_handler.cc',
            'browser/ui/webui/ntp/new_tab_page_handler.h',
            'browser/ui/webui/ntp/ntp_resource_cache.cc',
            'browser/ui/webui/ntp/suggestions_combiner.cc',
            'browser/ui/webui/ntp/suggestions_combiner.h',
            'browser/ui/webui/ntp/suggestions_page_handler.cc',
            'browser/ui/webui/ntp/suggestions_page_handler.h',
            'browser/ui/webui/ntp/suggestions_source.h',
            'browser/ui/webui/ntp/suggestions_source_discovery.cc',
            'browser/ui/webui/ntp/suggestions_source_discovery.h',
            'browser/ui/webui/ntp/suggestions_source_top_sites.cc',
            'browser/ui/webui/ntp/suggestions_source_top_sites.h',
            'browser/ui/webui/plugins_ui.cc',
            'browser/ui/webui/plugins_ui.h',
            'browser/ui/webui/suggestions_internals/suggestions_internals_ui.cc',
            'browser/ui/webui/suggestions_internals/suggestions_internals_ui.h',
            'browser/ui/webui/suggestions_internals/suggestions_internals_ui_handler.cc',
            'browser/ui/webui/suggestions_internals/suggestions_internals_ui_handler.h',
            'browser/ui/window_sizer/window_sizer.cc',
            'browser/ui/window_sizer/window_sizer.h',

            # Also not used on android
            'browser/ui/apps/chrome_shell_window_delegate.cc',
            'browser/ui/autofill/account_chooser_model.cc',
            'browser/ui/autofill/autocheckout_bubble.cc',
            'browser/ui/autofill/autofill_dialog_sign_in_delegate.cc',
            'browser/ui/autofill/country_combobox_model.cc',
            'browser/ui/bookmarks/bookmark_drag_drop.cc',
            'browser/ui/bookmarks/bookmark_tab_helper_delegate.cc',
            'browser/ui/browser_content_setting_bubble_model_delegate.cc',
            'browser/ui/browser_tabrestore.cc',
            'browser/ui/browser_tab_strip_model_delegate.cc',
            'browser/ui/browser_toolbar_model_delegate.cc',
            'browser/ui/browser_view_prefs.cc',
            'browser/ui/chrome_style.cc',
            'browser/ui/chrome_web_modal_dialog_manager_delegate.cc',
            'browser/ui/collected_cookies_infobar_delegate.cc',
            'browser/ui/confirm_bubble_model.cc',
            'browser/ui/crypto_module_password_dialog_openssl.cc',
            'browser/ui/extensions/application_launch.cc',
            'browser/ui/fast_unload_controller.cc',
            'browser/ui/find_bar/find_bar_controller.cc',
            'browser/ui/fullscreen/fullscreen_controller.cc',
            'browser/ui/fullscreen/fullscreen_exit_bubble_type.cc',
            'browser/ui/immersive_fullscreen_configuration.cc',
            'browser/ui/options/options_util.cc',
            'browser/ui/sad_tab.cc',
            'browser/ui/search_engines/search_engine_tab_helper_delegate.cc',
            'browser/ui/search_engines/template_url_fetcher_ui_callbacks.cc',
            'browser/ui/search/search_delegate.cc',
            'browser/ui/search/search_ui.cc',
            'browser/ui/send_feedback_experiment.cc',
            'browser/ui/tab_modal_confirm_dialog_delegate.cc',
            'browser/ui/unload_controller.cc',
            'browser/ui/website_settings/permission_menu_model.cc',
            'browser/ui/website_settings/website_settings_utils.cc',
            'browser/ui/webui/certificate_viewer_ui.cc',
            'browser/ui/webui/chrome_web_contents_handler.cc',
            'browser/ui/webui/ntp/app_resource_cache_factory.cc',
            'browser/ui/webui/ntp/core_app_launcher_handler.cc',
            'browser/ui/webui/performance_monitor/performance_monitor_handler.cc',
            'browser/ui/webui/performance_monitor/performance_monitor_l10n.cc',
            'browser/ui/webui/performance_monitor/performance_monitor_ui.cc',
            'browser/ui/webui/performance_monitor/performance_monitor_ui_constants.cc',
            'browser/ui/webui/theme_handler.cc',
          ],
          'sources/': [
            ['exclude', '^browser/ui/autofill/.*credit_card_bubble.*'],
            ['exclude', '^browser/ui/content_settings/'],
            ['exclude', '^browser/ui/omnibox/'],
            ['exclude', '^browser/ui/panels/'],
            ['exclude', '^browser/ui/pdf/'],
            ['exclude', '^browser/ui/startup/'],
            ['exclude', '^browser/ui/tabs/'],
            ['include', '^browser/ui/tabs/tab_utils\\.(cc|h)$'],
            ['exclude', '^browser/ui/toolbar/'],
            ['include', '^browser/ui/toolbar/toolbar_model\\.(cc|h)$'],
            ['include', '^browser/ui/toolbar/toolbar_model_delegate\\.(cc|h)$'],
            ['include', '^browser/ui/toolbar/toolbar_model_impl\\.(cc|h)$'],
            ['include', '^browser/ui/toolbar/toolbar_model_security_level_list\\.h$'],
            ['exclude', '^browser/ui/webui/downloads_'],
            ['exclude', '^browser/ui/webui/feedback_'],
            ['exclude', '^browser/ui/webui/help/'],
            ['exclude', '^browser/ui/webui/inspect_'],
            ['exclude', '^browser/ui/webui/options'],
            ['exclude', '^browser/ui/webui/options'],
            ['exclude', '^browser/ui/webui/signin/'],
            ['exclude', '^browser/ui/webui/suggestions_internals'],
            ['exclude', '^browser/ui/webui/sync_file_system_internals'],
            ['exclude', '^browser/ui/webui/sync_promo'],
            ['exclude', '^browser/ui/webui/uber'],
          ],
        }],
        ['OS=="mac"', {
          'sources!': [
            'browser/ui/certificate_dialogs.cc',
            'browser/ui/certificate_dialogs.h',
            'browser/ui/crypto_module_password_dialog.cc',
            'browser/ui/crypto_module_password_dialog_nss.cc',
            'browser/ui/screen_capture_notification_ui_stub.cc',
            'browser/ui/tabs/dock_info.cc',
            'browser/ui/tabs/tab_resources.cc',
            'browser/ui/views/extensions/extension_view_views.cc',
            'browser/ui/views/extensions/extension_view_views.h',
            'browser/ui/webui/help/version_updater_basic.cc',
            'browser/ui/webui/help/version_updater_basic.h',
          ],
          'dependencies': [
            '../ui/ui.gyp:ui_cocoa_third_party_toolkits',
          ],
          'include_dirs': [
            '../third_party/GTM',
          ],
          'link_settings': {
            'libraries': [
              '$(SDKROOT)/System/Library/Frameworks/Quartz.framework',
            ],
          },
          'actions': [
            {
              # This action is used to extract the localization data from xib
              # files and generate table for the ui localizer from it.
              'variables': {
                'xib_localizer_tool_path':
                    'tools/build/mac/generate_localizer',
              },
              'includes': [
                'chrome_nibs.gypi',
              ],
              'action_name': 'Process xibs for localization',
              'inputs': [
                '<(xib_localizer_tool_path)',
                '<@(mac_translated_xibs)',
              ],
              'outputs': [
                '<(INTERMEDIATE_DIR)/ui_localizer_table.h',
              ],
              'action': ['<(xib_localizer_tool_path)',
                          '<@(_outputs)',
                          '<@(mac_translated_xibs)'],
            },
          ],
        }],
        ['OS=="win"', {
          'include_dirs': [
            '<(DEPTH)/third_party/wtl/include',
          ],
          'dependencies': [
            'installer_util_strings',
            'launcher_support',
            'metro_utils',
            '../google_update/google_update.gyp:google_update',
            '../third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
            '../third_party/isimpledom/isimpledom.gyp:isimpledom',
            '../ui/app_list/app_list.gyp:app_list',
            '../ui/views/controls/webview/webview.gyp:webview',
            '../ui/views/views.gyp:views',
            '../win8/win8.gyp:win8_util',
          ],
          'export_dependent_settings': [
            '../ui/views/controls/webview/webview.gyp:webview',
            '../ui/views/views.gyp:views',
          ],
          'sources': [
            'browser/ui/views/network_profile_bubble_view.cc',
            'browser/ui/views/network_profile_bubble_view.h',
            'browser/ui/webui/conflicts_ui.cc',
            'browser/ui/webui/conflicts_ui.h',
          ],
          'sources!': [
            'browser/ui/certificate_dialogs.cc',
            'browser/ui/certificate_dialogs.h',
            'browser/ui/crypto_module_password_dialog.cc',
            'browser/ui/crypto_module_password_dialog_nss.cc',
            'browser/ui/screen_capture_notification_ui_stub.cc',
            'browser/ui/startup/autolaunch_prompt.cc',
            'browser/ui/views/frame/taskbar_decorator.cc',
            'browser/ui/views/simple_message_box_views.cc',
            'browser/ui/webui/help/version_updater_basic.cc',
            'browser/ui/webui/help/version_updater_basic.h',
          ],
          'conditions': [
            ['win_use_allocator_shim==1', {
              'dependencies': [
                '<(allocator_target)',
              ],
            }],
          ],
        }, {  # 'OS!="win"
          'sources/': [
            # Exclude files that should be excluded for all non-Windows platforms.
            ['exclude', '^browser/ui/network_profile_bubble.cc'],
            ['exclude', '^browser/ui/network_profile_bubble.h'],
            ['exclude', '^browser/ui/views/frame/system_menu_model.cc'],
            ['exclude', '^browser/ui/views/frame/system_menu_model.h'],
            ['exclude', '^browser/ui/webui/set_as_default_browser_ui.cc'],
            ['exclude', '^browser/ui/webui/set_as_default_browser_ui.h'],
          ],
          'conditions': [
            ['use_aura==1',{
              'dependencies': [
                '../build/linux/system.gyp:dbus',
                '../build/linux/system.gyp:fontconfig',
                '../build/linux/system.gyp:x11',
                '../dbus/dbus.gyp:dbus',
                '../ui/views/controls/webview/webview.gyp:webview',
                '../ui/views/views.gyp:views',
              ],
              'include_dirs': [
                '<(INTERMEDIATE_DIR)',
                '<(INTERMEDIATE_DIR)/chrome',
              ],
              'sources/': [
                ['exclude', '^browser/ui/views/frame/app_panel_browser_frame_view.cc'],
                ['exclude', '^browser/ui/views/frame/app_panel_browser_frame_view.h'],
                ['exclude', '^browser/ui/views/uninstall_view.cc'],
                ['exclude', '^browser/ui/views/uninstall_view.h'],
                ['include', '^browser/ui/tabs/dock_info.cc'],
                ['include', '^browser/ui/tabs/dock_info.h'],
                ['include', '^browser/ui/views/speech_recognition_bubble_views.cc'],
                ['include', '^browser/ui/window_sizer/window_sizer.cc'],
                ['include', '^browser/ui/window_sizer/window_sizer.h'],
              ],
            }, { # else: use_aura==0
              'sources/': [
                # Exclude all of views.
                ['exclude', '^browser/ui/views/'],
              ]
            }],
            # GTK build only
            ['toolkit_uses_gtk==1', {
              'sources/': [
                ['exclude', '^browser/ui/toolbar/bookmark_sub_menu_model.cc'],
                ['exclude', '^browser/ui/views/notifications/balloon_collection_views.cc'],
              ],
            }],
          ],
        }],
        [ 'use_openssl==1', {
          'sources!': [
            'browser/ui/crypto_module_password_dialog_nss.cc',
          ]}, {
           'sources!': [
             'browser/ui/crypto_module_password_dialog_openssl.cc',
          ]},
        ],
        # File manager extension replaces the native OS file open/save dialog.
        ['file_manager_extension==1', {
          'sources/': [
            ['include', '^browser/ui/views/select_file_dialog_extension.cc'],
            ['include', '^browser/ui/views/select_file_dialog_extension.h'],
            ['include', '^browser/ui/views/select_file_dialog_extension_factory.cc'],
            ['include', '^browser/ui/views/select_file_dialog_extension_factory.h'],
          ]}, {
          'sources/': [
            ['exclude', '^browser/ui/views/select_file_dialog_extension.cc'],
            ['exclude', '^browser/ui/views/select_file_dialog_extension.h'],
            ['exclude', '^browser/ui/views/select_file_dialog_extension_factory.cc'],
            ['exclude', '^browser/ui/views/select_file_dialog_extension_factory.h'],
          ]}
        ],
        ['enable_app_list==1', {
          'dependencies': [
            '../ui/app_list/app_list.gyp:app_list',
          ],
          'sources!': [
            'browser/ui/app_list/app_list_service_disabled.cc',
          ],
        }, { # else: enable_app_list==0
          'sources/': [
            ['exclude', '^browser/ui/views/app_list/'],
            ['exclude', '^browser/ui/app_list/'],
            ['include', '^browser/ui/app_list/app_list_service.h'],
            ['include', '^browser/ui/app_list/app_list_service_disabled.cc'],
          ],
        }],
        ['enable_autofill_dialog!=1 or OS=="android"', {
          'sources!': [
            'browser/ui/autofill/autofill_dialog_controller_impl.cc',
            'browser/ui/autofill/autofill_dialog_controller_impl.h',
            'browser/ui/autofill/autofill_dialog_view.h',
            'browser/ui/autofill/autofill_dialog_view.cc',
            'browser/ui/autofill/autofill_dialog_view_delegate.h',
          ],
        }],
        ['enable_google_now==0', {
          'sources!': [
            'browser/ui/webui/options/geolocation_options_handler.cc',
            'browser/ui/webui/options/geolocation_options_handler.h',
          ],
        }],
        ['enable_webrtc==0', {
          'sources!': [
            'browser/ui/webui/media/webrtc_logs_ui.cc',
            'browser/ui/webui/media/webrtc_logs_ui.h',
          ],
        }],
        ['enable_mdns==1', {
          'sources': [
            'browser/ui/webui/local_discovery/local_discovery_ui.cc',
            'browser/ui/webui/local_discovery/local_discovery_ui.h',
            'browser/ui/webui/local_discovery/local_discovery_ui_handler.cc',
            'browser/ui/webui/local_discovery/local_discovery_ui_handler.h',
          ],
        }],
      ],
    },
  ],
}
