// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_EXTENSIONS_API_IMAGE_WRITER_PRIVATE_WRITE_FROM_FILE_OPERATION_H_
#define CHROME_BROWSER_EXTENSIONS_API_IMAGE_WRITER_PRIVATE_WRITE_FROM_FILE_OPERATION_H_

#include "chrome/browser/extensions/api/image_writer_private/operation.h"

namespace extensions {
namespace image_writer {

// Encapsulates a write of an image from a local file.
class WriteFromFileOperation : public Operation {
 public:
  WriteFromFileOperation(base::WeakPtr<OperationManager> manager,
                         const ExtensionId& extension_id,
                         const base::FilePath& path,
                         const std::string& storage_unit_id);
  virtual void Start() OVERRIDE;

 private:
  virtual ~WriteFromFileOperation();
  const base::FilePath path_;
};

}  // namespace image_writer
}  // namespace extensions

#endif  // CHROME_BROWSER_EXTENSIONS_API_IMAGE_WRITER_PRIVATE_WRITE_FROM_FILE_OPERATION_H_
