Nintendo Switch build instructions
==================================
this project requires the devkitpro toolchain.
you can use your personal computer to install devkitpro
but the easiest way is to use the following container.

Build container image
---------------------
```
bash scripts/switch/build-docker-image.sh
```

Run container
-------------
from the project's [root folder](../)
```
docker run -it --rm \
	-v "$(pwd):/build" \
	-p 28771:28771 \
	chiaki-switch
```

Build Project
-------------
```
bash scripts/switch/run-docker-build-chiaki.sh
```

tools
-----
Push to homebrew Netloader
```
# where X.X.X.X is the IP of your switch
scripts/switch/push-docker-build-chiaki.sh 192.168.0.200
```

Troubleshoot
```
# replace 0xCCB5C with the backtrace adress (PC - Backtrace Start Address)
aarch64-none-elf-addr2line \
	-e ./build_switch/switch/chiaki \
	-f -p -C -a 0xCCB5C
```

Chiaki config file
------------------
The **chiaki.conf** is generated by the application.
this file contains sensitive data. (do not share this file)
```ini
# required: PS*-*** (PS4/PS5 local name)
# name from Settings > System > system information
[PS*-***]
# required: lan PlayStation IP address
# IP from Settings > System > system information
host_ip = *.*.*.*
# required: sony oline id (login)
psn_online_id = ps_online_id
# required (PS4>7.0 Only): https://git.sr.ht/~thestr4ng3r/chiaki/tree/master/item/README.md#obtaining-your-psn-accountid
psn_account_id = ps_base64_account_id
# optional(default 60): remote play fps (must be 30 or 60)
video_fps = 60
# optional(default 720p): remote play resolution (must be 720p, 540p or 360p)
video_resolution = 720p
```
