# NAME

certspotter-script - Certificate Transparency Log Monitor (hook script)

# SYNOPSIS

**certspotter-script**

# DESCRIPTION

**certspotter-script** is *any* program that is called from **certspotter**'s
*-script* argument. **certspotter** executes this script when a file from the
CT log matches against the watchlist.

# ENVIRONMENT

The script will have the following in its environment:

## Entry information

`CERT_FILENAME`

:    The path of the saved certificate on the local filesystem, if one exists.

`CERT_TYPE`

:    The certificate's type ("cert" or "precert").

`FINGERPRINT`

:    The certificate's fingerprint.

`LOG_URI`

:    The URI of the log the certificate was found on.

`ENTRY_INDEX`

:    The entry's index in the log.

`CERT_PARSEABLE`

:    Whether the certificate could be parsed.

## Identifiers

`DNS_NAMES`

:    A comma-separated list of the certificate's dnsNames.

`IP_ADDRESSES`

:    A comma-separated list of the certificate's IP addresses.

## Certificate information

`PUBKEY_HASH`

:    The certificate public key's hash.

`SERIAL`

:    The certificate's serial.

`NOT_BEFORE`, `NOT_AFTER`

:    The certificate's validity information, as a string.

`NOT_BEFORE_UNIXTIME`, `NOT_AFTER_UNIXTIME`

:    The certificate's validity information, as UNIX time.

`SUBJECT_DN`

:    The certificate's subject distinguished name (DN).

`ISSUER_DN`

:    the certificate issuer distinguished name (DN).

## Errors

`PARSE_ERROR`

:   Set to the error that occurred when attempting to extract information about
    the certificate. In this case, `CERT_PARSEABLE` will also be set to "no"
    and information such as `PUBKEY_HASH`, `SERIAL`, as well as validity and
    subject, will not be present.

`SERIAL_PARSE_ERROR`

:   Set to the error that occurred when attempting to extract the certificate's
    serial. Emitted instead of `SERIAL`.

`IDENTIFIERS_PARSE_ERROR`

:   Set to the error that occurred when attempting to extract the certificate's
    identifiers. Emitted instead of `DNS_NAMES`, `IP_ADDRESSES`.

`VALIDITY_PARSE_ERROR`

:   Set to the error that occurred when attempting to extract the certificate's
    validity information. Emitted instead of `NOT_BEFORE`, `NOT_AFTER`.

`SUBJECT_PARSE_ERROR`

:   Set to the error that occurred when attempting to extract the certificate's
    subject information. Emitted instead of `SUBJECT_DN`.

`ISSUER_PARSE_ERROR`

:   Set to the error that occurred when attempting to extract the certificate's
    issuer information. Emitted instead of `ISSUER_DN`.

# SEE ALSO

certspotter(8)

# COPYRIGHT

Copyright (c) 2016-2022 Opsmate, Inc.

# BUGS

Report bugs to <https://github.com/SSLmate/certspotter>.
