#include "parameterConversion.h"

#include <inttypes.h>
#include <stdlib.h>
#include <cstddef>
#include <ctype.h>

#include "exception.h"
#include "compare.h"


const char *
parameter2word(const char *string)
{
  size_t len = strlen(string);

  for (size_t i = 0; i < len; ++i)
    {
      int c = string[i];
      if (iscntrl(c) || isblank(c)) cdoAbort("Word parameter >%s< contains invalid character at position %zu!", string, i + 1);
    }

  if (len == 0) cdoAbort("Word parameter >%s< is empty!", string);

  return string;
}

bool
parameter2bool(const char *str)
{
  size_t len = strlen(str);

  if (len == 1)
    {
      if (*str == 't' || *str == 'T' || *str == '1') return true;
      if (*str == 'f' || *str == 'F' || *str == '0') return false;
    }
  else if (len == 4 && (cstrIsEqual(str, "true") || cstrIsEqual(str, "TRUE") || cstrIsEqual(str, "True")))
    return true;
  else if (len == 5 && (cstrIsEqual(str, "false") || cstrIsEqual(str, "FALSE") || cstrIsEqual(str, "False")))
    return false;

  cdoAbort("Boolean parameter >%s< contains invalid characters!", str);

  return false;
}

double
parameter2double(const char *string)
{
  char *endptr = NULL;
  double fval = strtod(string, &endptr);
  if (*endptr != 0)
    cdoAbort("Float parameter >%s< contains invalid character at position %d!", string, (int) (endptr - string + 1));

  return fval;
}

int
parameter2int(const char *string)
{
  char *endptr = NULL;
  int ival = (int) strtol(string, &endptr, 10);
  if (*endptr != 0)
    cdoAbort("Integer parameter >%s< contains invalid character at position %d!", string, (int) (endptr - string + 1));

  return ival;
}

long
parameter2long(const char *string)
{
  char *endptr = NULL;
  long ival = strtol(string, &endptr, 10);
  if (*endptr != 0)
    cdoAbort("Integer parameter >%s< contains invalid character at position %d!", string, (int) (endptr - string + 1));

  return ival;
}

size_t
parameter2sizet(const char *string)
{
  char *endptr = NULL;
  size_t ival = (size_t) strtoimax(string, &endptr, 10);
  if (*endptr != 0)
    cdoAbort("Integer parameter >%s< contains invalid character at position %d!", string, (int) (endptr - string + 1));

  return ival;
}

int
parameter2intlist(const char *string)
{
  char *endptr = NULL;
  int ival = (int) strtol(string, &endptr, 10);
  if (*endptr != 0 && *endptr != '/' && (endptr - string) == 0)
    cdoAbort("Integer parameter >%s< contains invalid character at position %d!", string, (int) (endptr - string + 1));

  return ival;
}


