/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2018 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/

#ifndef CDO_INT_H
#define CDO_INT_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "field.h"
#include "functs.h"
#include "dmemory.h"
#include "util.h"
#include "cdo_vlist.h"
#include "process_int.h"
#include "exception.h"
#include "cdoOptions.h"

#ifdef _OPENMP
#define OPENMP3 200805
#define OPENMP4 201307
#define OPENMP45 201511

#if _OPENMP >= OPENMP3
#define HAVE_OPENMP3 1
#endif

#if _OPENMP >= OPENMP4
#define HAVE_OPENMP4 1
#endif

#if _OPENMP >= OPENMP45
#define HAVE_OPENMP45 1
#endif
#endif


#define cmpstr(s1, s2) (strncmp(s1, s2, strlen(s2)))
#define cmpstrlen(s1, s2, len) (strncmp(s1, s2, len = strlen(s2)))

/* sxxxYYYYMMDDhhmm0 */
#define DATE_LEN 31 /* YYYYMMDDhhmmss allocate DTLEN+1 !!!! */
#define SET_DATE(dtstr, date, time) (sprintf(dtstr, "%*lld%*d", DATE_LEN - 6, date, 6, time))
#define DATE_IS_NEQ(dtstr1, dtstr2, len) (memcmp(dtstr1, dtstr2, len) != 0)

enum T_WEIGHT_MODE
{
  WEIGHT_OFF,
  WEIGHT_ON
};
enum T_EIGEN_MODE
{
  JACOBI,
  DANIELSON_LANCZOS
};

#ifndef M_LN10
#define M_LN10 2.30258509299404568401799145468436421 /* log_e 10 */
#endif

#ifndef M_PI
#define M_PI 3.14159265358979323846264338327950288 /* pi */
#endif

#define VECTOR_2D(T, P2D, N, M)       \
  std::vector<std::vector<T>> P2D(N); \
  if ((N))                            \
    for (size_t i = 0; i < (size_t)(N); ++i) P2D[i].resize(M);

#define IX2D(y, x, nx) ((y) * (nx) + (x))


void print_pthread_info(void);

int readline(FILE *fp, char *line, int len);

int zaxis2ltype(int zaxisID);

double radius_str_to_deg(const char *string);

const char *tunit2str(int tunits);
const char *calendar2str(int calendar);

void cdo_set_grids(const char *gridarg);
void defineInstitution(const char *instarg);
int defineTable(const char *tablearg);

void nospec(int vlistID);

void openLock(void);
void openUnlock(void);

int cdf_openread(const char *filename);


off_t fileSize(const char * filename);

void cdo_read_field(const char *name, char *pline, int size, double *field, int *lineno, FILE *fp, const char *dname);

double cdoZaxisInqLevel(int zaxisID, int levelID);
int cdoZaxisInqLevels(int zaxisID, double *levels);

char *cdoVlistInqVarName(int vlistID, int varID, char *name);

#ifdef __cplusplus
extern "C" {
#endif

void cdiDefTableID(int tableID);

void gridGenXvals(int xsize, double xfirst, double xlast, double xinc, double *xvals);
void gridGenYvals(int gridtype, int ysize, double yfirst, double ylast, double yinc, double *yvals);

void gaussaw(double * pa, double * pw, size_t nlat);


void cdoCompareGrids(int gridID1, int gridID2);

#if defined(__cplusplus)
}
#endif

#endif /* CDO_INT_H */
