#include <vector>
#include <cstring>
#include <ctype.h>
#include "cdo_int.h"
#include "param_conversion.h"
#include "listarray.h"

template <typename T>
ListArray<T>::ListArray()
  {
    nalloc = 0;
    allinc = 1024;
  }

template <typename T>
T * ListArray<T>:: data()
  {
    return array.data();
  }

template <typename T>
  void ListArray<T>::setValue(int num, T value)
  {
    ensureArraySize(num);
    array[num] = value;
  }

template <typename T>
T ListArray<T>::getValue(int num)
  {
    return array[num];
  }

template <typename T>
  int
 ListArray<T>::argvToInt(int argc, char **argv)
  {
    int nint = 0;

    for (int iarg = 0; iarg < argc; iarg++)
      {
        int first, last, inc;
        split_intstring(argv[iarg], &first, &last, &inc);

        if (inc >= 0)
          {
            for (int ival = first; ival <= last; ival += inc) setValue(nint++, ival);
          }
        else
          {
            for (int ival = first; ival >= last; ival += inc) setValue(nint++, ival);
          }
      }

    return nint;
  }

template <typename T>
  int ListArray<T>::argvToFlt(int argc, char **argv)
  {
    int nint = 0;

    for (int iarg = 0; iarg < argc; iarg++)
      {
        int len = (int) strlen(argv[iarg]);
        int i;
        for (i = 0; i < len; i++)
          if (argv[iarg][i] != '/' && argv[iarg][i] != '-' && !isdigit(argv[iarg][i])) break;

        if (i != len)
          {
            /*
              if      ( strcmp(argv[iarg],  "inf") == 0 )
              tmp_val =  DBL_MAX;
              else if ( strcmp(argv[iarg], "-inf") == 0 )
              tmp_val = -DBL_MAX;
              else
            */
            double tmp_val = parameter2double(argv[iarg]);
            setValue(nint++, tmp_val);
          }
        else
          {
            int first, last, inc;
            split_intstring(argv[iarg], &first, &last, &inc);

            if (inc >= 0)
              {
                for (int ival = first; ival <= last; ival += inc) setValue(nint++, (double) ival);
              }
            else
              {
                for (int ival = first; ival >= last; ival += inc) setValue(nint++, (double) ival);
              }
          }
      }

    return nint;
  }

template <typename T>
  void ListArray<T>::ensureArraySize(int num) {
    while (nalloc <= num)
      {
        nalloc += allinc;
        array.resize(nalloc);
      }
  }

template class ListArray<int>;
template class ListArray<double>;
template class ListArray<float>;
